// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__){
return (function (state_35923){
var state_val_35924 = (state_35923[(1)]);
if((state_val_35924 === (7))){
var inst_35880 = (state_35923[(7)]);
var inst_35880__$1 = (state_35923[(2)]);
var inst_35882 = (inst_35880__$1 == null);
var inst_35883 = cljs.core.not(inst_35882);
var state_35923__$1 = (function (){var statearr_35925 = state_35923;
(statearr_35925[(7)] = inst_35880__$1);

return statearr_35925;
})();
if(inst_35883){
var statearr_35926_35963 = state_35923__$1;
(statearr_35926_35963[(1)] = (8));

} else {
var statearr_35927_35964 = state_35923__$1;
(statearr_35927_35964[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (20))){
var inst_35902 = (state_35923[(8)]);
var inst_35910 = (state_35923[(2)]);
var state_35923__$1 = (function (){var statearr_35928 = state_35923;
(statearr_35928[(9)] = inst_35910);

return statearr_35928;
})();
if(cljs.core.truth_(inst_35902)){
var statearr_35929_35965 = state_35923__$1;
(statearr_35929_35965[(1)] = (21));

} else {
var statearr_35930_35966 = state_35923__$1;
(statearr_35930_35966[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (1))){
var state_35923__$1 = state_35923;
var statearr_35931_35967 = state_35923__$1;
(statearr_35931_35967[(2)] = null);

(statearr_35931_35967[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (4))){
var state_35923__$1 = state_35923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35923__$1,(7),agg_data_channel);
} else {
if((state_val_35924 === (15))){
var inst_35880 = (state_35923[(7)]);
var state_35923__$1 = state_35923;
var statearr_35932_35968 = state_35923__$1;
(statearr_35932_35968[(2)] = inst_35880);

(statearr_35932_35968[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (21))){
var inst_35912 = cljs.core.async.close_BANG_(agg_data_channel);
var state_35923__$1 = state_35923;
var statearr_35933_35969 = state_35923__$1;
(statearr_35933_35969[(2)] = inst_35912);

(statearr_35933_35969[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (13))){
var inst_35892 = (state_35923[(2)]);
var state_35923__$1 = state_35923;
var statearr_35934_35970 = state_35923__$1;
(statearr_35934_35970[(2)] = inst_35892);

(statearr_35934_35970[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (22))){
var state_35923__$1 = state_35923;
var statearr_35935_35971 = state_35923__$1;
(statearr_35935_35971[(2)] = null);

(statearr_35935_35971[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (6))){
var inst_35919 = (state_35923[(2)]);
var state_35923__$1 = state_35923;
var statearr_35936_35972 = state_35923__$1;
(statearr_35936_35972[(2)] = inst_35919);

(statearr_35936_35972[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (17))){
var inst_35901 = (state_35923[(10)]);
var inst_35902 = (state_35923[(8)]);
var inst_35904 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_35901,inst_35902) : callback.call(null,inst_35901,inst_35902));
var state_35923__$1 = state_35923;
var statearr_35937_35973 = state_35923__$1;
(statearr_35937_35973[(2)] = inst_35904);

(statearr_35937_35973[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (3))){
var inst_35921 = (state_35923[(2)]);
var state_35923__$1 = state_35923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35923__$1,inst_35921);
} else {
if((state_val_35924 === (12))){
var state_35923__$1 = state_35923;
var statearr_35938_35974 = state_35923__$1;
(statearr_35938_35974[(2)] = false);

(statearr_35938_35974[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (2))){
var state_35923__$1 = state_35923;
var statearr_35939_35975 = state_35923__$1;
(statearr_35939_35975[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (23))){
var inst_35915 = (state_35923[(2)]);
var state_35923__$1 = (function (){var statearr_35941 = state_35923;
(statearr_35941[(11)] = inst_35915);

return statearr_35941;
})();
var statearr_35942_35976 = state_35923__$1;
(statearr_35942_35976[(2)] = null);

(statearr_35942_35976[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (19))){
var inst_35907 = (state_35923[(2)]);
var inst_35908 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_35923__$1 = (function (){var statearr_35943 = state_35923;
(statearr_35943[(12)] = inst_35907);

return statearr_35943;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35923__$1,(20),inst_35908);
} else {
if((state_val_35924 === (11))){
var state_35923__$1 = state_35923;
var statearr_35944_35977 = state_35923__$1;
(statearr_35944_35977[(2)] = true);

(statearr_35944_35977[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (9))){
var state_35923__$1 = state_35923;
var statearr_35945_35978 = state_35923__$1;
(statearr_35945_35978[(2)] = false);

(statearr_35945_35978[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (5))){
var state_35923__$1 = state_35923;
var statearr_35946_35979 = state_35923__$1;
(statearr_35946_35979[(2)] = null);

(statearr_35946_35979[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (14))){
var inst_35880 = (state_35923[(7)]);
var inst_35897 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35880);
var state_35923__$1 = state_35923;
var statearr_35947_35980 = state_35923__$1;
(statearr_35947_35980[(2)] = inst_35897);

(statearr_35947_35980[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (16))){
var inst_35901 = (state_35923[(10)]);
var inst_35900 = (state_35923[(2)]);
var inst_35901__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35900,cljs.core.cst$kw$data);
var inst_35902 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35900,cljs.core.cst$kw$completed_QMARK_);
var state_35923__$1 = (function (){var statearr_35948 = state_35923;
(statearr_35948[(10)] = inst_35901__$1);

(statearr_35948[(8)] = inst_35902);

return statearr_35948;
})();
if(cljs.core.truth_(inst_35901__$1)){
var statearr_35949_35981 = state_35923__$1;
(statearr_35949_35981[(1)] = (17));

} else {
var statearr_35950_35982 = state_35923__$1;
(statearr_35950_35982[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (10))){
var inst_35895 = (state_35923[(2)]);
var state_35923__$1 = state_35923;
if(cljs.core.truth_(inst_35895)){
var statearr_35951_35983 = state_35923__$1;
(statearr_35951_35983[(1)] = (14));

} else {
var statearr_35952_35984 = state_35923__$1;
(statearr_35952_35984[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (18))){
var state_35923__$1 = state_35923;
var statearr_35953_35985 = state_35923__$1;
(statearr_35953_35985[(2)] = null);

(statearr_35953_35985[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35924 === (8))){
var inst_35880 = (state_35923[(7)]);
var inst_35885 = inst_35880.cljs$lang$protocol_mask$partition0$;
var inst_35886 = (inst_35885 & (64));
var inst_35887 = inst_35880.cljs$core$ISeq$;
var inst_35888 = (inst_35886) || (inst_35887);
var state_35923__$1 = state_35923;
if(cljs.core.truth_(inst_35888)){
var statearr_35954_35986 = state_35923__$1;
(statearr_35954_35986[(1)] = (11));

} else {
var statearr_35955_35987 = state_35923__$1;
(statearr_35955_35987[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__))
;
return ((function (switch__12027__auto__,c__12139__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____0 = (function (){
var statearr_35959 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35959[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__);

(statearr_35959[(1)] = (1));

return statearr_35959;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____1 = (function (state_35923){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_35923);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e35960){if((e35960 instanceof Object)){
var ex__12031__auto__ = e35960;
var statearr_35961_35988 = state_35923;
(statearr_35961_35988[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35923);

return cljs.core.cst$kw$recur;
} else {
throw e35960;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__35989 = state_35923;
state_35923 = G__35989;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__ = function(state_35923){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____1.call(this,state_35923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__))
})();
var state__12141__auto__ = (function (){var statearr_35962 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_35962[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_35962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__))
);

return c__12139__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__35992_35994 = agg;
var G__35993_35995 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__35992_35994,G__35993_35995) : cljs.core.reset_BANG_.call(null,G__35992_35994,G__35993_35995));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___36003 = arguments.length;
var i__7485__auto___36004 = (0);
while(true){
if((i__7485__auto___36004 < len__7484__auto___36003)){
args__7491__auto__.push((arguments[i__7485__auto___36004]));

var G__36005 = (i__7485__auto___36004 + (1));
i__7485__auto___36004 = G__36005;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__35999){
var map__36000 = p__35999;
var map__36000__$1 = ((((!((map__36000 == null)))?((((map__36000.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36000.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36000):map__36000);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36000__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__36002 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36002) : cljs.core.atom.call(null,G__36002));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__36000,map__36000__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__36000,map__36000__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__36000,map__36000__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__36000,map__36000__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq35996){
var G__35997 = cljs.core.first(seq35996);
var seq35996__$1 = cljs.core.next(seq35996);
var G__35998 = cljs.core.first(seq35996__$1);
var seq35996__$2 = cljs.core.next(seq35996__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35997,G__35998,seq35996__$2);
});

