// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.urls');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._id,new cljs.core.Keyword(null,"label","label",1718410804),"id",new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._id,new cljs.core.Keyword(null,"type","type",1174270348),"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.call(null,extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18564 = arguments.length;
var i__7485__auto___18565 = (0);
while(true){
if((i__7485__auto___18565 < len__7484__auto___18564)){
args__7491__auto__.push((arguments[i__7485__auto___18565]));

var G__18566 = (i__7485__auto___18565 + (1));
i__7485__auto___18565 = G__18566;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__18561){
var map__18562 = p__18561;
var map__18562__$1 = ((((!((map__18562 == null)))?((((map__18562.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18562.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18562):map__18562);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__18562__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,hatti.views.table.get_extra_fields.call(null,is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),cljs.core.not.call(null,is_filtered_dataview_QMARK_)))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq18559){
var G__18560 = cljs.core.first.call(null,seq18559);
var seq18559__$1 = cljs.core.next.call(null,seq18559);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__18560,seq18559__$1);
});

/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__18567_SHARP_){
if(typeof p1__18567_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__18567_SHARP_);
} else {
return p1__18567_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__18573){
var vec__18574 = p__18573;
var fname = cljs.core.nth.call(null,vec__18574,(0),null);
var answer = cljs.core.nth.call(null,vec__18574,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__18568_SHARP_){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),[cljs.core.str(p1__18568_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,clj_value,language,true);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__18577 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__18577__$1 = ((((!((map__18577 == null)))?((((map__18577.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18577.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18577):map__18577);
var owner__$1 = cljs.core.get.call(null,map__18577__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__18577__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__18577__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = chimera.urls.last_url_param.call(null,owner__$1);
var project_id = chimera.urls.last_url_param.call(null,project);
var edit_link = chimera.urls.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info.right","span.tip-info.right",-1208244295),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-clone","i.fa.fa-clone",1946695810),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info.right","span.tip-info.right",-1208244295),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil-square-o","i.fa.fa-pencil-square-o",1550650091)], null)], null)], null)], null):null));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(70),"",hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args18580 = [];
var len__7484__auto___18610 = arguments.length;
var i__7485__auto___18611 = (0);
while(true){
if((i__7485__auto___18611 < len__7484__auto___18610)){
args18580.push((arguments[i__7485__auto___18611]));

var G__18612 = (i__7485__auto___18611 + (1));
i__7485__auto___18611 = G__18612;
continue;
} else {
}
break;
}

var G__18586 = args18580.length;
switch (G__18586) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7503__auto__ = (new cljs.core.IndexedSeq(args18580.slice((3)),(0),null));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7503__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__18587){
var map__18588 = p__18587;
var map__18588__$1 = ((((!((map__18588 == null)))?((((map__18588.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18588.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18588):map__18588);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__18588__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var owner = cljs.core.get.call(null,map__18588__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var has_hxl_QMARK_ = cljs.core.any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,((function (map__18588,map__18588__$1,is_filtered_dataview_QMARK_,owner){
return (function (p1__18579_SHARP_){
return (new cljs.core.Keyword(null,"hxl","hxl",-849576989).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"instance","instance",-2121349050).cljs$core$IFn$_invoke$arity$1(p1__18579_SHARP_)) == null);
});})(map__18588,map__18588__$1,is_filtered_dataview_QMARK_,owner))
,form));
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__18588,map__18588__$1,is_filtered_dataview_QMARK_,owner){
return (function hatti$views$table$iter__18590(s__18591){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__18588,map__18588__$1,is_filtered_dataview_QMARK_,owner){
return (function (){
var s__18591__$1 = s__18591;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__18591__$1);
if(temp__4657__auto__){
var s__18591__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__18591__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__18591__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__18593 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__18592 = (0);
while(true){
if((i__18592 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__18592);
cljs.core.chunk_append.call(null,b__18593,(function (){var map__18602 = field;
var map__18602__$1 = ((((!((map__18602 == null)))?((((map__18602.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18602.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18602):map__18602);
var map__18603 = cljs.core.get.call(null,map__18602__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__18603__$1 = ((((!((map__18603 == null)))?((((map__18603.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18603.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18603):map__18603);
var hxl = cljs.core.get.call(null,map__18603__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__18602__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__18602__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__18602__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,((has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})());

var G__18614 = (i__18592 + (1));
i__18592 = G__18614;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18593),hatti$views$table$iter__18590.call(null,cljs.core.chunk_rest.call(null,s__18591__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18593),null);
}
} else {
var field = cljs.core.first.call(null,s__18591__$2);
return cljs.core.cons.call(null,(function (){var map__18606 = field;
var map__18606__$1 = ((((!((map__18606 == null)))?((((map__18606.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18606.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18606):map__18606);
var map__18607 = cljs.core.get.call(null,map__18606__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__18607__$1 = ((((!((map__18607 == null)))?((((map__18607.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18607.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18607):map__18607);
var hxl = cljs.core.get.call(null,map__18607__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__18606__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__18606__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__18606__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,((has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__18590.call(null,cljs.core.rest.call(null,s__18591__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__18588,map__18588__$1,is_filtered_dataview_QMARK_,owner))
,null,null));
});})(has_hxl_QMARK_,map__18588,map__18588__$1,is_filtered_dataview_QMARK_,owner))
;
return iter__7189__auto__.call(null,hatti.views.table.all_fields.call(null,form,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_));
})();
return cljs.core.clj__GT_js.call(null,cljs.core.conj.call(null,columns,hatti.views.table.actions_column.call(null,owner,has_hxl_QMARK_)));
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq18581){
var G__18582 = cljs.core.first.call(null,seq18581);
var seq18581__$1 = cljs.core.next.call(null,seq18581);
var G__18583 = cljs.core.first.call(null,seq18581__$1);
var seq18581__$2 = cljs.core.next.call(null,seq18581__$1);
var G__18584 = cljs.core.first.call(null,seq18581__$2);
var seq18581__$3 = cljs.core.next.call(null,seq18581__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__18582,G__18583,G__18584,seq18581__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
/**
 * Fixes the first column on slick table on horizontal scroll
 */
hatti.views.table.freeze_action_column_BANG_ = (function hatti$views$table$freeze_action_column_BANG_(){
var actions = document.getElementsByClassName("record-actions");
var sg_viewport = cljs.core.first.call(null,document.getElementsByClassName("slick-viewport"));
var seq__18620 = cljs.core.seq.call(null,actions);
var chunk__18621 = null;
var count__18622 = (0);
var i__18623 = (0);
while(true){
if((i__18623 < count__18622)){
var action = cljs.core._nth.call(null,chunk__18621,i__18623);
var leftOffset_18624 = parseInt(action.offsetLeft);
sg_viewport.addEventListener("scroll",((function (seq__18620,chunk__18621,count__18622,i__18623,leftOffset_18624,action,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__18620,chunk__18621,count__18622,i__18623,sl,leftOffset_18624,action,actions,sg_viewport){
return (function (p1__18615_SHARP_){
return action.style.borderRight = p1__18615_SHARP_;
});})(seq__18620,chunk__18621,count__18622,i__18623,sl,leftOffset_18624,action,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_.call(null,"1px dotted #ededed");
} else {
set_border_BANG_.call(null,"1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_18624)),cljs.core.str("px")].join('');
});})(seq__18620,chunk__18621,count__18622,i__18623,leftOffset_18624,action,actions,sg_viewport))
);

var G__18625 = seq__18620;
var G__18626 = chunk__18621;
var G__18627 = count__18622;
var G__18628 = (i__18623 + (1));
seq__18620 = G__18625;
chunk__18621 = G__18626;
count__18622 = G__18627;
i__18623 = G__18628;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__18620);
if(temp__4657__auto__){
var seq__18620__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__18620__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__18620__$1);
var G__18629 = cljs.core.chunk_rest.call(null,seq__18620__$1);
var G__18630 = c__7220__auto__;
var G__18631 = cljs.core.count.call(null,c__7220__auto__);
var G__18632 = (0);
seq__18620 = G__18629;
chunk__18621 = G__18630;
count__18622 = G__18631;
i__18623 = G__18632;
continue;
} else {
var action = cljs.core.first.call(null,seq__18620__$1);
var leftOffset_18633 = parseInt(action.offsetLeft);
sg_viewport.addEventListener("scroll",((function (seq__18620,chunk__18621,count__18622,i__18623,leftOffset_18633,action,seq__18620__$1,temp__4657__auto__,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__18620,chunk__18621,count__18622,i__18623,sl,leftOffset_18633,action,seq__18620__$1,temp__4657__auto__,actions,sg_viewport){
return (function (p1__18615_SHARP_){
return action.style.borderRight = p1__18615_SHARP_;
});})(seq__18620,chunk__18621,count__18622,i__18623,sl,leftOffset_18633,action,seq__18620__$1,temp__4657__auto__,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_.call(null,"1px dotted #ededed");
} else {
set_border_BANG_.call(null,"1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_18633)),cljs.core.str("px")].join('');
});})(seq__18620,chunk__18621,count__18622,i__18623,leftOffset_18633,action,seq__18620__$1,temp__4657__auto__,actions,sg_viewport))
);

var G__18634 = cljs.core.next.call(null,seq__18620__$1);
var G__18635 = null;
var G__18636 = (0);
var G__18637 = (0);
seq__18620 = G__18634;
chunk__18621 = G__18635;
count__18622 = G__18636;
i__18623 = G__18637;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__18654(s__18655){
return (new cljs.core.LazySeq(null,(function (){
var s__18655__$1 = s__18655;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__18655__$1);
if(temp__4657__auto__){
var s__18655__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__18655__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__18655__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__18657 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__18656 = (0);
while(true){
if((i__18656 < size__7188__auto__)){
var vec__18664 = cljs.core._nth.call(null,c__7187__auto__,i__18656);
var handler_key = cljs.core.nth.call(null,vec__18664,(0),null);
var handler_function = cljs.core.nth.call(null,vec__18664,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__18657,event.subscribe(handler_function));

var G__18670 = (i__18656 + (1));
i__18656 = G__18670;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18657),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__18654.call(null,cljs.core.chunk_rest.call(null,s__18655__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18657),null);
}
} else {
var vec__18667 = cljs.core.first.call(null,s__18655__$2);
var handler_key = cljs.core.nth.call(null,vec__18667,(0),null);
var handler_function = cljs.core.nth.call(null,vec__18667,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__18654.call(null,cljs.core.rest.call(null,s__18655__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__18687(s__18688){
return (new cljs.core.LazySeq(null,(function (){
var s__18688__$1 = s__18688;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__18688__$1);
if(temp__4657__auto__){
var s__18688__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__18688__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__18688__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__18690 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__18689 = (0);
while(true){
if((i__18689 < size__7188__auto__)){
var vec__18697 = cljs.core._nth.call(null,c__7187__auto__,i__18689);
var handler_key = cljs.core.nth.call(null,vec__18697,(0),null);
var handler_function = cljs.core.nth.call(null,vec__18697,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__18690,event.subscribe(handler_function));

var G__18703 = (i__18689 + (1));
i__18689 = G__18703;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18690),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__18687.call(null,cljs.core.chunk_rest.call(null,s__18688__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18690),null);
}
} else {
var vec__18700 = cljs.core.first.call(null,s__18688__$2);
var handler_key = cljs.core.nth.call(null,vec__18700,(0),null);
var handler_function = cljs.core.nth.call(null,vec__18700,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__18687.call(null,cljs.core.rest.call(null,s__18688__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__18704){
var map__18713 = p__18704;
var map__18713__$1 = ((((!((map__18713 == null)))?((((map__18713.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18713.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18713):map__18713);
var grid_event_handlers = cljs.core.get.call(null,map__18713__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__18713__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,true,current_language,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__18715 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__18715__$1 = ((((!((map__18715 == null)))?((((map__18715.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18715.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18715):map__18715);
var map__18716 = cljs.core.get.call(null,map__18715__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__18716__$1 = ((((!((map__18716 == null)))?((((map__18716.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18716.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18716):map__18716);
var map__18717 = cljs.core.get.call(null,map__18716__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__18717__$1 = ((((!((map__18717 == null)))?((((map__18717.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18717.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18717):map__18717);
var num_displayed_records = cljs.core.get.call(null,map__18717__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__18717__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__18715,map__18715__$1,map__18716,map__18716__$1,map__18717,map__18717__$1,num_displayed_records,total_page_count,map__18713,map__18713__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__18715,map__18715__$1,map__18716,map__18716__$1,map__18717,map__18717__$1,num_displayed_records,total_page_count,map__18713,map__18713__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__18715,map__18715__$1,map__18716,map__18716__$1,map__18717,map__18717__$1,num_displayed_records,total_page_count,map__18713,map__18713__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__18715,map__18715__$1,map__18716,map__18716__$1,map__18717,map__18717__$1,num_displayed_records,total_page_count,map__18713,map__18713__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__18715,map__18715__$1,map__18716,map__18716__$1,map__18717,map__18717__$1,num_displayed_records,total_page_count,map__18713,map__18713__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__18715,map__18715__$1,map__18716,map__18716__$1,map__18717,map__18717__$1,num_displayed_records,total_page_count,map__18713,map__18713__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__18715,map__18715__$1,map__18716,map__18716__$1,map__18717,map__18717__$1,num_displayed_records,total_page_count,map__18713,map__18713__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
});})(columns,SlickGrid,DataView,dataview,grid,map__18715,map__18715__$1,map__18716,map__18716__$1,map__18717,map__18717__$1,num_displayed_records,total_page_count,map__18713,map__18713__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__12139__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto__,event_chan){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__,event_chan){
return (function (state_18982){
var state_val_18983 = (state_18982[(1)]);
if((state_val_18983 === (7))){
var inst_18891 = (state_18982[(7)]);
var inst_18891__$1 = (state_18982[(2)]);
var inst_18893 = (inst_18891__$1 == null);
var inst_18894 = cljs.core.not.call(null,inst_18893);
var state_18982__$1 = (function (){var statearr_18984 = state_18982;
(statearr_18984[(7)] = inst_18891__$1);

return statearr_18984;
})();
if(inst_18894){
var statearr_18985_19052 = state_18982__$1;
(statearr_18985_19052[(1)] = (8));

} else {
var statearr_18986_19053 = state_18982__$1;
(statearr_18986_19053[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (20))){
var inst_18913 = (state_18982[(8)]);
var inst_18921 = (state_18982[(9)]);
var inst_18930 = inst_18921.call(null,inst_18913);
var state_18982__$1 = state_18982;
var statearr_18987_19054 = state_18982__$1;
(statearr_18987_19054[(2)] = inst_18930);

(statearr_18987_19054[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (27))){
var state_18982__$1 = state_18982;
var statearr_18988_19055 = state_18982__$1;
(statearr_18988_19055[(2)] = null);

(statearr_18988_19055[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (1))){
var state_18982__$1 = state_18982;
var statearr_18989_19056 = state_18982__$1;
(statearr_18989_19056[(2)] = null);

(statearr_18989_19056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (24))){
var state_18982__$1 = state_18982;
var statearr_18990_19057 = state_18982__$1;
(statearr_18990_19057[(2)] = null);

(statearr_18990_19057[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (4))){
var state_18982__$1 = state_18982;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18982__$1,(7),event_chan);
} else {
if((state_val_18983 === (15))){
var inst_18891 = (state_18982[(7)]);
var state_18982__$1 = state_18982;
var statearr_18991_19058 = state_18982__$1;
(statearr_18991_19058[(2)] = inst_18891);

(statearr_18991_19058[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (21))){
var state_18982__$1 = state_18982;
var statearr_18992_19059 = state_18982__$1;
(statearr_18992_19059[(2)] = null);

(statearr_18992_19059[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (31))){
var inst_18917 = (state_18982[(10)]);
var inst_18955 = (state_18982[(2)]);
var inst_18956 = cljs.core._EQ_.call(null,inst_18917,new cljs.core.Keyword(null,"table","table",-564943036));
var state_18982__$1 = (function (){var statearr_18993 = state_18982;
(statearr_18993[(11)] = inst_18955);

return statearr_18993;
})();
if(inst_18956){
var statearr_18994_19060 = state_18982__$1;
(statearr_18994_19060[(1)] = (32));

} else {
var statearr_18995_19061 = state_18982__$1;
(statearr_18995_19061[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (32))){
var inst_18915 = (state_18982[(12)]);
var inst_18914 = (state_18982[(13)]);
var inst_18922 = (state_18982[(14)]);
var inst_18917 = (state_18982[(10)]);
var inst_18913 = (state_18982[(8)]);
var inst_18912 = (state_18982[(15)]);
var inst_18921 = (state_18982[(9)]);
var inst_18916 = (state_18982[(16)]);
var inst_18891 = (state_18982[(7)]);
var inst_18911 = (state_18982[(17)]);
var inst_18969 = cljs.core.async.chan.call(null,(1));
var inst_18970 = (function (){var new_columns = inst_18916;
var submission_clicked = inst_18913;
var submission_unclicked = inst_18914;
var get_submission_data = inst_18922;
var map__18889 = inst_18911;
var re_render = inst_18917;
var update_data_BANG_ = inst_18921;
var c__12139__auto____$1 = inst_18969;
var submission_to_rank = inst_18912;
var e = inst_18891;
var filter_by = inst_18915;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,map__18889,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,e,filter_by,inst_18915,inst_18914,inst_18922,inst_18917,inst_18913,inst_18912,inst_18921,inst_18916,inst_18891,inst_18911,inst_18969,state_val_18983,c__12139__auto__,event_chan){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,map__18889,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,e,filter_by,inst_18915,inst_18914,inst_18922,inst_18917,inst_18913,inst_18912,inst_18921,inst_18916,inst_18891,inst_18911,inst_18969,state_val_18983,c__12139__auto__,event_chan){
return (function (state_18967){
var state_val_18968 = (state_18967[(1)]);
if((state_val_18968 === (1))){
var inst_18958 = cljs.core.async.timeout.call(null,(20));
var state_18967__$1 = state_18967;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18967__$1,(2),inst_18958);
} else {
if((state_val_18968 === (2))){
var inst_18960 = (state_18967[(2)]);
var inst_18961 = grid.resizeCanvas();
var inst_18962 = grid.invalidateAllRows();
var inst_18963 = hatti.views.table.resizeColumns.call(null,grid);
var inst_18964 = grid.render();
var inst_18965 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_18967__$1 = (function (){var statearr_18996 = state_18967;
(statearr_18996[(7)] = inst_18964);

(statearr_18996[(8)] = inst_18960);

(statearr_18996[(9)] = inst_18963);

(statearr_18996[(10)] = inst_18961);

(statearr_18996[(11)] = inst_18962);

return statearr_18996;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18967__$1,inst_18965);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,map__18889,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,e,filter_by,inst_18915,inst_18914,inst_18922,inst_18917,inst_18913,inst_18912,inst_18921,inst_18916,inst_18891,inst_18911,inst_18969,state_val_18983,c__12139__auto__,event_chan))
;
return ((function (switch__12027__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,map__18889,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,e,filter_by,inst_18915,inst_18914,inst_18922,inst_18917,inst_18913,inst_18912,inst_18921,inst_18916,inst_18891,inst_18911,inst_18969,state_val_18983,c__12139__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____0 = (function (){
var statearr_19000 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19000[(0)] = hatti$views$table$handle_table_events_$_state_machine__12028__auto__);

(statearr_19000[(1)] = (1));

return statearr_19000;
});
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____1 = (function (state_18967){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_18967);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e19001){if((e19001 instanceof Object)){
var ex__12031__auto__ = e19001;
var statearr_19002_19062 = state_18967;
(statearr_19002_19062[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18967);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19001;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19063 = state_18967;
state_18967 = G__19063;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = function(state_18967){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____1.call(this,state_18967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,map__18889,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,e,filter_by,inst_18915,inst_18914,inst_18922,inst_18917,inst_18913,inst_18912,inst_18921,inst_18916,inst_18891,inst_18911,inst_18969,state_val_18983,c__12139__auto__,event_chan))
})();
var state__12141__auto__ = (function (){var statearr_19003 = f__12140__auto__.call(null);
(statearr_19003[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto____$1);

return statearr_19003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,map__18889,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,e,filter_by,inst_18915,inst_18914,inst_18922,inst_18917,inst_18913,inst_18912,inst_18921,inst_18916,inst_18891,inst_18911,inst_18969,state_val_18983,c__12139__auto__,event_chan))
})();
var inst_18971 = cljs.core.async.impl.dispatch.run.call(null,inst_18970);
var state_18982__$1 = (function (){var statearr_19004 = state_18982;
(statearr_19004[(18)] = inst_18971);

return statearr_19004;
})();
var statearr_19005_19064 = state_18982__$1;
(statearr_19005_19064[(2)] = inst_18969);

(statearr_19005_19064[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (33))){
var state_18982__$1 = state_18982;
var statearr_19006_19065 = state_18982__$1;
(statearr_19006_19065[(2)] = null);

(statearr_19006_19065[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (13))){
var inst_18903 = (state_18982[(2)]);
var state_18982__$1 = state_18982;
var statearr_19007_19066 = state_18982__$1;
(statearr_19007_19066[(2)] = inst_18903);

(statearr_19007_19066[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (22))){
var inst_18914 = (state_18982[(13)]);
var inst_18933 = (state_18982[(2)]);
var state_18982__$1 = (function (){var statearr_19008 = state_18982;
(statearr_19008[(19)] = inst_18933);

return statearr_19008;
})();
if(cljs.core.truth_(inst_18914)){
var statearr_19009_19067 = state_18982__$1;
(statearr_19009_19067[(1)] = (23));

} else {
var statearr_19010_19068 = state_18982__$1;
(statearr_19010_19068[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (29))){
var inst_18915 = (state_18982[(12)]);
var inst_18947 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_18948 = [inst_18915];
var inst_18949 = cljs.core.PersistentHashMap.fromArrays(inst_18947,inst_18948);
var inst_18950 = cljs.core.clj__GT_js.call(null,inst_18949);
var inst_18951 = dataview.setFilterArgs(inst_18950);
var inst_18952 = dataview.refresh();
var state_18982__$1 = (function (){var statearr_19011 = state_18982;
(statearr_19011[(20)] = inst_18951);

return statearr_19011;
})();
var statearr_19012_19069 = state_18982__$1;
(statearr_19012_19069[(2)] = inst_18952);

(statearr_19012_19069[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (6))){
var inst_18978 = (state_18982[(2)]);
var state_18982__$1 = state_18982;
var statearr_19013_19070 = state_18982__$1;
(statearr_19013_19070[(2)] = inst_18978);

(statearr_19013_19070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (28))){
var inst_18915 = (state_18982[(12)]);
var inst_18945 = (state_18982[(2)]);
var state_18982__$1 = (function (){var statearr_19014 = state_18982;
(statearr_19014[(21)] = inst_18945);

return statearr_19014;
})();
if(cljs.core.truth_(inst_18915)){
var statearr_19015_19071 = state_18982__$1;
(statearr_19015_19071[(1)] = (29));

} else {
var statearr_19016_19072 = state_18982__$1;
(statearr_19016_19072[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (25))){
var inst_18916 = (state_18982[(16)]);
var inst_18938 = (state_18982[(2)]);
var state_18982__$1 = (function (){var statearr_19017 = state_18982;
(statearr_19017[(22)] = inst_18938);

return statearr_19017;
})();
if(cljs.core.truth_(inst_18916)){
var statearr_19018_19073 = state_18982__$1;
(statearr_19018_19073[(1)] = (26));

} else {
var statearr_19019_19074 = state_18982__$1;
(statearr_19019_19074[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (34))){
var inst_18974 = (state_18982[(2)]);
var state_18982__$1 = (function (){var statearr_19020 = state_18982;
(statearr_19020[(23)] = inst_18974);

return statearr_19020;
})();
var statearr_19021_19075 = state_18982__$1;
(statearr_19021_19075[(2)] = null);

(statearr_19021_19075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (17))){
var inst_18922 = (state_18982[(14)]);
var inst_18912 = (state_18982[(15)]);
var inst_18921 = (state_18982[(9)]);
var inst_18924 = inst_18922.call(null,hatti.constants._rank,inst_18912);
var inst_18925 = inst_18921.call(null,inst_18924);
var state_18982__$1 = state_18982;
var statearr_19022_19076 = state_18982__$1;
(statearr_19022_19076[(2)] = inst_18925);

(statearr_19022_19076[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (3))){
var inst_18980 = (state_18982[(2)]);
var state_18982__$1 = state_18982;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18982__$1,inst_18980);
} else {
if((state_val_18983 === (12))){
var state_18982__$1 = state_18982;
var statearr_19023_19077 = state_18982__$1;
(statearr_19023_19077[(2)] = false);

(statearr_19023_19077[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (2))){
var state_18982__$1 = state_18982;
var statearr_19024_19078 = state_18982__$1;
(statearr_19024_19078[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (23))){
var inst_18921 = (state_18982[(9)]);
var inst_18935 = inst_18921.call(null,null);
var state_18982__$1 = state_18982;
var statearr_19026_19079 = state_18982__$1;
(statearr_19026_19079[(2)] = inst_18935);

(statearr_19026_19079[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (19))){
var inst_18913 = (state_18982[(8)]);
var inst_18928 = (state_18982[(2)]);
var state_18982__$1 = (function (){var statearr_19027 = state_18982;
(statearr_19027[(24)] = inst_18928);

return statearr_19027;
})();
if(cljs.core.truth_(inst_18913)){
var statearr_19028_19080 = state_18982__$1;
(statearr_19028_19080[(1)] = (20));

} else {
var statearr_19029_19081 = state_18982__$1;
(statearr_19029_19081[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (11))){
var state_18982__$1 = state_18982;
var statearr_19030_19082 = state_18982__$1;
(statearr_19030_19082[(2)] = true);

(statearr_19030_19082[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (9))){
var state_18982__$1 = state_18982;
var statearr_19031_19083 = state_18982__$1;
(statearr_19031_19083[(2)] = false);

(statearr_19031_19083[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (5))){
var state_18982__$1 = state_18982;
var statearr_19032_19084 = state_18982__$1;
(statearr_19032_19084[(2)] = null);

(statearr_19032_19084[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (14))){
var inst_18891 = (state_18982[(7)]);
var inst_18908 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18891);
var state_18982__$1 = state_18982;
var statearr_19033_19085 = state_18982__$1;
(statearr_19033_19085[(2)] = inst_18908);

(statearr_19033_19085[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (26))){
var inst_18916 = (state_18982[(16)]);
var inst_18940 = grid.setColumns(inst_18916);
var inst_18941 = hatti.views.table.resizeColumns.call(null,grid);
var inst_18942 = grid.render();
var state_18982__$1 = (function (){var statearr_19034 = state_18982;
(statearr_19034[(25)] = inst_18940);

(statearr_19034[(26)] = inst_18941);

return statearr_19034;
})();
var statearr_19035_19086 = state_18982__$1;
(statearr_19035_19086[(2)] = inst_18942);

(statearr_19035_19086[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (16))){
var inst_18915 = (state_18982[(12)]);
var inst_18914 = (state_18982[(13)]);
var inst_18917 = (state_18982[(10)]);
var inst_18913 = (state_18982[(8)]);
var inst_18912 = (state_18982[(15)]);
var inst_18921 = (state_18982[(9)]);
var inst_18916 = (state_18982[(16)]);
var inst_18891 = (state_18982[(7)]);
var inst_18911 = (state_18982[(17)]);
var inst_18911__$1 = (state_18982[(2)]);
var inst_18912__$1 = cljs.core.get.call(null,inst_18911__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_18913__$1 = cljs.core.get.call(null,inst_18911__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_18914__$1 = cljs.core.get.call(null,inst_18911__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_18915__$1 = cljs.core.get.call(null,inst_18911__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_18916__$1 = cljs.core.get.call(null,inst_18911__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_18917__$1 = cljs.core.get.call(null,inst_18911__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_18918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18919 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_18920 = (new cljs.core.PersistentVector(null,3,(5),inst_18918,inst_18919,null));
var inst_18921__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_18920);
var inst_18922 = (function (){var e = inst_18891;
var map__18889 = inst_18911__$1;
var submission_to_rank = inst_18912__$1;
var submission_clicked = inst_18913__$1;
var submission_unclicked = inst_18914__$1;
var filter_by = inst_18915__$1;
var new_columns = inst_18916__$1;
var re_render = inst_18917__$1;
var update_data_BANG_ = inst_18921__$1;
return ((function (e,map__18889,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_18915,inst_18914,inst_18917,inst_18913,inst_18912,inst_18921,inst_18916,inst_18891,inst_18911,inst_18911__$1,inst_18912__$1,inst_18913__$1,inst_18914__$1,inst_18915__$1,inst_18916__$1,inst_18917__$1,inst_18918,inst_18919,inst_18920,inst_18921__$1,state_val_18983,c__12139__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (e,map__18889,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_18915,inst_18914,inst_18917,inst_18913,inst_18912,inst_18921,inst_18916,inst_18891,inst_18911,inst_18911__$1,inst_18912__$1,inst_18913__$1,inst_18914__$1,inst_18915__$1,inst_18916__$1,inst_18917__$1,inst_18918,inst_18919,inst_18920,inst_18921__$1,state_val_18983,c__12139__auto__,event_chan){
return (function (p1__18721_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__18721_SHARP_,field));
});})(e,map__18889,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_18915,inst_18914,inst_18917,inst_18913,inst_18912,inst_18921,inst_18916,inst_18891,inst_18911,inst_18911__$1,inst_18912__$1,inst_18913__$1,inst_18914__$1,inst_18915__$1,inst_18916__$1,inst_18917__$1,inst_18918,inst_18919,inst_18920,inst_18921__$1,state_val_18983,c__12139__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(e,map__18889,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_18915,inst_18914,inst_18917,inst_18913,inst_18912,inst_18921,inst_18916,inst_18891,inst_18911,inst_18911__$1,inst_18912__$1,inst_18913__$1,inst_18914__$1,inst_18915__$1,inst_18916__$1,inst_18917__$1,inst_18918,inst_18919,inst_18920,inst_18921__$1,state_val_18983,c__12139__auto__,event_chan))
})();
var state_18982__$1 = (function (){var statearr_19036 = state_18982;
(statearr_19036[(12)] = inst_18915__$1);

(statearr_19036[(13)] = inst_18914__$1);

(statearr_19036[(14)] = inst_18922);

(statearr_19036[(10)] = inst_18917__$1);

(statearr_19036[(8)] = inst_18913__$1);

(statearr_19036[(15)] = inst_18912__$1);

(statearr_19036[(9)] = inst_18921__$1);

(statearr_19036[(16)] = inst_18916__$1);

(statearr_19036[(17)] = inst_18911__$1);

return statearr_19036;
})();
if(cljs.core.truth_(inst_18912__$1)){
var statearr_19037_19087 = state_18982__$1;
(statearr_19037_19087[(1)] = (17));

} else {
var statearr_19038_19088 = state_18982__$1;
(statearr_19038_19088[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (30))){
var state_18982__$1 = state_18982;
var statearr_19039_19089 = state_18982__$1;
(statearr_19039_19089[(2)] = null);

(statearr_19039_19089[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (10))){
var inst_18906 = (state_18982[(2)]);
var state_18982__$1 = state_18982;
if(cljs.core.truth_(inst_18906)){
var statearr_19040_19090 = state_18982__$1;
(statearr_19040_19090[(1)] = (14));

} else {
var statearr_19041_19091 = state_18982__$1;
(statearr_19041_19091[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (18))){
var state_18982__$1 = state_18982;
var statearr_19042_19092 = state_18982__$1;
(statearr_19042_19092[(2)] = null);

(statearr_19042_19092[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18983 === (8))){
var inst_18891 = (state_18982[(7)]);
var inst_18896 = inst_18891.cljs$lang$protocol_mask$partition0$;
var inst_18897 = (inst_18896 & (64));
var inst_18898 = inst_18891.cljs$core$ISeq$;
var inst_18899 = (inst_18897) || (inst_18898);
var state_18982__$1 = state_18982;
if(cljs.core.truth_(inst_18899)){
var statearr_19043_19093 = state_18982__$1;
(statearr_19043_19093[(1)] = (11));

} else {
var statearr_19044_19094 = state_18982__$1;
(statearr_19044_19094[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__,event_chan))
;
return ((function (switch__12027__auto__,c__12139__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____0 = (function (){
var statearr_19048 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19048[(0)] = hatti$views$table$handle_table_events_$_state_machine__12028__auto__);

(statearr_19048[(1)] = (1));

return statearr_19048;
});
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____1 = (function (state_18982){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_18982);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e19049){if((e19049 instanceof Object)){
var ex__12031__auto__ = e19049;
var statearr_19050_19095 = state_18982;
(statearr_19050_19095[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18982);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19049;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19096 = state_18982;
state_18982 = G__19096;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = function(state_18982){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____1.call(this,state_18982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__,event_chan))
})();
var state__12141__auto__ = (function (){var statearr_19051 = f__12140__auto__.call(null);
(statearr_19051[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_19051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto__,event_chan))
);

return c__12139__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),k);

return colset_BANG_.call(null,k);
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__19113(s__19114){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__19114__$1 = s__19114;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19114__$1);
if(temp__4657__auto__){
var s__19114__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19114__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19114__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19116 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19115 = (0);
while(true){
if((i__19115 < size__7188__auto__)){
var vec__19123 = cljs.core._nth.call(null,c__7187__auto__,i__19115);
var k = cljs.core.nth.call(null,vec__19123,(0),null);
var v = cljs.core.nth.call(null,vec__19123,(1),null);
cljs.core.chunk_append.call(null,b__19116,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__19115,vec__19123,k,v,c__7187__auto__,size__7188__auto__,b__19116,s__19114__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__19115,vec__19123,k,v,c__7187__auto__,size__7188__auto__,b__19116,s__19114__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__19129 = (i__19115 + (1));
i__19115 = G__19129;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19116),hatti$views$table$render_options_$_iter__19113.call(null,cljs.core.chunk_rest.call(null,s__19114__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19116),null);
}
} else {
var vec__19126 = cljs.core.first.call(null,s__19114__$2);
var k = cljs.core.nth.call(null,vec__19126,(0),null);
var v = cljs.core.nth.call(null,vec__19126,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__19126,k,v,s__19114__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__19126,k,v,s__19114__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__19113.call(null,cljs.core.rest.call(null,s__19114__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table19131 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table19131 = (function (_,owner,meta19132){
this._ = _;
this.owner = owner;
this.meta19132 = meta19132;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table19131.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19133,meta19132__$1){
var self__ = this;
var _19133__$1 = this;
return (new hatti.views.table.t_hatti$views$table19131(self__._,self__.owner,meta19132__$1));
});

hatti.views.table.t_hatti$views$table19131.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19133){
var self__ = this;
var _19133__$1 = this;
return self__.meta19132;
});

hatti.views.table.t_hatti$views$table19131.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table19131.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table19131.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table19131.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__19134){
var self__ = this;
var map__19135 = p__19134;
var map__19135__$1 = ((((!((map__19135 == null)))?((((map__19135.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19135.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19135):map__19135);
var name_or_label = cljs.core.get.call(null,map__19135__$1,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208));
var language = cljs.core.get.call(null,map__19135__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__19137 = om.core.get_shared.call(null,self__.owner);
var map__19137__$1 = ((((!((map__19137 == null)))?((((map__19137.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19137.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19137):map__19137);
var flat_form = cljs.core.get.call(null,map__19137__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__19137,map__19137__$1,flat_form,new_language,___$2,map__19135,map__19135__$1,name_or_label,language){
return (function (p1__19130_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__19130_SHARP_),new_language)], null));
});})(options,map__19137,map__19137__$1,flat_form,new_language,___$2,map__19135,map__19135__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,name_or_label);
} else {
}

return React.DOM.div(({"className": "label-changer"}),React.DOM.span(({"className": "label-changer-label"}),"Show:"),React.DOM.div(({"id": "header-display-dropdown", "className": "drop-hover"}),(function (){var attrs19141 = options.call(null,name_or_label);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs19141))?sablono.interpreter.attributes.call(null,attrs19141):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs19141))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i(({"className": "fa fa-angle-down"}))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs19141),React.DOM.i(({"className": "fa fa-angle-down"}))], null))));
})(),React.DOM.ul(({"className": "submenu no-dot"}),sablono.interpreter.interpret.call(null,hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_)))));
});

hatti.views.table.t_hatti$views$table19131.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta19132","meta19132",-1233628609,null)], null);
});

hatti.views.table.t_hatti$views$table19131.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table19131.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table19131";

hatti.views.table.t_hatti$views$table19131.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table19131");
});

hatti.views.table.__GT_t_hatti$views$table19131 = (function hatti$views$table$__GT_t_hatti$views$table19131(___$1,owner__$1,meta19132){
return (new hatti.views.table.t_hatti$views$table19131(___$1,owner__$1,meta19132));
});

}

return (new hatti.views.table.t_hatti$views$table19131(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12139__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto__,query){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__,query){
return (function (state_19188){
var state_val_19189 = (state_19188[(1)]);
if((state_val_19189 === (1))){
var inst_19174 = cljs.core.async.timeout.call(null,(150));
var state_19188__$1 = state_19188;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19188__$1,(2),inst_19174);
} else {
if((state_val_19189 === (2))){
var inst_19176 = (state_19188[(2)]);
var inst_19177 = input.value;
var inst_19178 = cljs.core._EQ_.call(null,query,inst_19177);
var state_19188__$1 = (function (){var statearr_19190 = state_19188;
(statearr_19190[(7)] = inst_19176);

return statearr_19190;
})();
if(inst_19178){
var statearr_19191_19202 = state_19188__$1;
(statearr_19191_19202[(1)] = (3));

} else {
var statearr_19192_19203 = state_19188__$1;
(statearr_19192_19203[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19189 === (3))){
var inst_19180 = [query_event_key];
var inst_19181 = [query];
var inst_19182 = cljs.core.PersistentHashMap.fromArrays(inst_19180,inst_19181);
var inst_19183 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_19182);
var state_19188__$1 = state_19188;
var statearr_19193_19204 = state_19188__$1;
(statearr_19193_19204[(2)] = inst_19183);

(statearr_19193_19204[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19189 === (4))){
var state_19188__$1 = state_19188;
var statearr_19194_19205 = state_19188__$1;
(statearr_19194_19205[(2)] = null);

(statearr_19194_19205[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19189 === (5))){
var inst_19186 = (state_19188[(2)]);
var state_19188__$1 = state_19188;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19188__$1,inst_19186);
} else {
return null;
}
}
}
}
}
});})(c__12139__auto__,query))
;
return ((function (switch__12027__auto__,c__12139__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12028__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12028__auto____0 = (function (){
var statearr_19198 = [null,null,null,null,null,null,null,null];
(statearr_19198[(0)] = hatti$views$table$delayed_search_$_state_machine__12028__auto__);

(statearr_19198[(1)] = (1));

return statearr_19198;
});
var hatti$views$table$delayed_search_$_state_machine__12028__auto____1 = (function (state_19188){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_19188);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e19199){if((e19199 instanceof Object)){
var ex__12031__auto__ = e19199;
var statearr_19200_19206 = state_19188;
(statearr_19200_19206[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19188);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19199;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19207 = state_19188;
state_19188 = G__19207;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12028__auto__ = function(state_19188){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12028__auto____1.call(this,state_19188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12028__auto____0;
hatti$views$table$delayed_search_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12028__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__,query))
})();
var state__12141__auto__ = (function (){var statearr_19201 = f__12140__auto__.call(null);
(statearr_19201[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_19201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto__,query))
);

return c__12139__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table19209 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table19209 = (function (_,owner,meta19210){
this._ = _;
this.owner = owner;
this.meta19210 = meta19210;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table19209.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19211,meta19210__$1){
var self__ = this;
var _19211__$1 = this;
return (new hatti.views.table.t_hatti$views$table19209(self__._,self__.owner,meta19210__$1));
});

hatti.views.table.t_hatti$views$table19209.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19211){
var self__ = this;
var _19211__$1 = this;
return self__.meta19210;
});

hatti.views.table.t_hatti$views$table19209.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table19209.prototype.om$core$IRender$render$arity$1 = (function (this__17298__auto__){
var self__ = this;
var this__17298__auto____$1 = this;
return React.DOM.div(({"className": "table-search"}),React.DOM.i(({"className": "fa fa-search"})),sablono.interpreter.input.call(null,({"type": "text", "placeholder": "Search", "onChange": ((function (this__17298__auto____$1){
return (function (p1__19208_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__19208_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__17298__auto____$1))
})));
});

hatti.views.table.t_hatti$views$table19209.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta19210","meta19210",-1016633408,null)], null);
});

hatti.views.table.t_hatti$views$table19209.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table19209.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table19209";

hatti.views.table.t_hatti$views$table19209.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table19209");
});

hatti.views.table.__GT_t_hatti$views$table19209 = (function hatti$views$table$__GT_t_hatti$views$table19209(___$1,owner__$1,meta19210){
return (new hatti.views.table.t_hatti$views$table19209(___$1,owner__$1,meta19210));
});

}

return (new hatti.views.table.t_hatti$views$table19209(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table19214 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table19214 = (function (app_state,owner,meta19215){
this.app_state = app_state;
this.owner = owner;
this.meta19215 = meta19215;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table19214.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19216,meta19215__$1){
var self__ = this;
var _19216__$1 = this;
return (new hatti.views.table.t_hatti$views$table19214(self__.app_state,self__.owner,meta19215__$1));
});

hatti.views.table.t_hatti$views$table19214.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19216){
var self__ = this;
var _19216__$1 = this;
return self__.meta19215;
});

hatti.views.table.t_hatti$views$table19214.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table19214.prototype.om$core$IRender$render$arity$1 = (function (this__17298__auto__){
var self__ = this;
var this__17298__auto____$1 = this;
return React.DOM.div(({"className": "topbar"}),React.DOM.div(({"id": hatti.views.table.pager_id})),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.app_state)),React.DOM.div(({"style": ({"clear": "both"})})));
});

hatti.views.table.t_hatti$views$table19214.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta19215","meta19215",1553953732,null)], null);
});

hatti.views.table.t_hatti$views$table19214.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table19214.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table19214";

hatti.views.table.t_hatti$views$table19214.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table19214");
});

hatti.views.table.__GT_t_hatti$views$table19214 = (function hatti$views$table$__GT_t_hatti$views$table19214(app_state__$1,owner__$1,meta19215){
return (new hatti.views.table.t_hatti$views$table19214(app_state__$1,owner__$1,meta19215));
});

}

return (new hatti.views.table.t_hatti$views$table19214(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq.call(null,data)){
var map__19224 = om.core.get_shared.call(null,owner);
var map__19224__$1 = ((((!((map__19224 == null)))?((((map__19224.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19224.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19224):map__19224);
var flat_form = cljs.core.get.call(null,map__19224__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__19224__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__19225 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__19225,(0),null);
var dataview = cljs.core.nth.call(null,vec__19225,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__19230,owner,p__19231){
var map__19232 = p__19230;
var map__19232__$1 = ((((!((map__19232 == null)))?((((map__19232.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19232.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19232):map__19232);
var app_state = map__19232__$1;
var map__19233 = cljs.core.get.call(null,map__19232__$1,new cljs.core.Keyword(null,"views","views",1450155487));
var map__19233__$1 = ((((!((map__19233 == null)))?((((map__19233.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19233.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19233):map__19233);
var active = cljs.core.get.call(null,map__19233__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var map__19234 = p__19231;
var map__19234__$1 = ((((!((map__19234 == null)))?((((map__19234.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19234.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19234):map__19234);
var opts = map__19234__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__19234__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

var active_QMARK_ = chimera.seq.in_QMARK_.call(null,active,new cljs.core.Keyword(null,"table","table",-564943036));
if(typeof hatti.views.table.t_hatti$views$table19238 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table19238 = (function (owner,p__19231,active_QMARK_,p__19230,slick_grid_event_handlers,map__19232,map__19234,app_state,map__19233,active,opts,meta19239){
this.owner = owner;
this.p__19231 = p__19231;
this.active_QMARK_ = active_QMARK_;
this.p__19230 = p__19230;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.map__19232 = map__19232;
this.map__19234 = map__19234;
this.app_state = app_state;
this.map__19233 = map__19233;
this.active = active;
this.opts = opts;
this.meta19239 = meta19239;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table19238.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers){
return (function (_19240,meta19239__$1){
var self__ = this;
var _19240__$1 = this;
return (new hatti.views.table.t_hatti$views$table19238(self__.owner,self__.p__19231,self__.active_QMARK_,self__.p__19230,self__.slick_grid_event_handlers,self__.map__19232,self__.map__19234,self__.app_state,self__.map__19233,self__.active,self__.opts,meta19239__$1));
});})(active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table19238.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers){
return (function (_19240){
var self__ = this;
var _19240__$1 = this;
return self__.meta19239;
});})(active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table19238.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table19238.prototype.om$core$IRender$render$arity$1 = ((function (active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null)));
var map__19241 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__19241__$1 = ((((!((map__19241 == null)))?((((map__19241.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19241.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19241):map__19241);
var dataset_info = map__19241__$1;
var num_of_submissions = cljs.core.get.call(null,map__19241__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var with_info = ((function (no_data_QMARK_,map__19241,map__19241__$1,dataset_info,num_of_submissions,___$1,active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers){
return (function (p1__19229_SHARP_){
return cljs.core.merge.call(null,p1__19229_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),dataset_info], null));
});})(no_data_QMARK_,map__19241,map__19241__$1,dataset_info,num_of_submissions,___$1,active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
var attrs19243 = om.core.build.call(null,hatti.views.submission_view,with_info.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855)], null))),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null));
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs19243))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs19243)):({"className": "table-view"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs19243))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div(({"id": hatti.views.table.table_id, "className": "slickgrid"}),(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span(({"className": "empty-state"}),"No data"):React.DOM.span(null,React.DOM.i(({"className": "fa fa-spinner fa-pulse"})),"Loading...")))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs19243),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div(({"id": hatti.views.table.table_id, "className": "slickgrid"}),(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span(({"className": "empty-state"}),"No data"):React.DOM.span(null,React.DOM.i(({"className": "fa fa-spinner fa-pulse"})),"Loading...")))], null))));
} else {
return null;
}
});})(active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table19238.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table19238.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
var data = cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__19252 = temp__4657__auto__;
var grid = cljs.core.nth.call(null,vec__19252,(0),null);
var dataview = cljs.core.nth.call(null,vec__19252,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table19238.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table19238.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__19255 = om.core.get_state.call(null,self__.owner);
var map__19255__$1 = ((((!((map__19255 == null)))?((((map__19255.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19255.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19255):map__19255);
var grid = cljs.core.get.call(null,map__19255__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__19255__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__19257 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__19257,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__19257,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table19238.getBasis = ((function (active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__19231","p__19231",1289380677,null),new cljs.core.Symbol(null,"active?","active?",2100031303,null),new cljs.core.Symbol(null,"p__19230","p__19230",1003868328,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"map__19232","map__19232",436287247,null),new cljs.core.Symbol(null,"map__19234","map__19234",846168015,null),new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"map__19233","map__19233",-352504358,null),new cljs.core.Symbol(null,"active","active",-758473701,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"meta19239","meta19239",581127856,null)], null);
});})(active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table19238.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table19238.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table19238";

hatti.views.table.t_hatti$views$table19238.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table19238");
});})(active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table19238 = ((function (active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table19238(owner__$1,p__19231__$1,active_QMARK___$1,p__19230__$1,slick_grid_event_handlers__$1,map__19232__$2,map__19234__$2,app_state__$1,map__19233__$2,active__$1,opts__$1,meta19239){
return (new hatti.views.table.t_hatti$views$table19238(owner__$1,p__19231__$1,active_QMARK___$1,p__19230__$1,slick_grid_event_handlers__$1,map__19232__$2,map__19234__$2,app_state__$1,map__19233__$2,active__$1,opts__$1,meta19239));
});})(active_QMARK_,map__19232,map__19232__$1,app_state,map__19233,map__19233__$1,active,map__19234,map__19234__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table19238(owner,p__19231,active_QMARK_,p__19230,slick_grid_event_handlers,map__19232__$1,map__19234__$1,app_state,map__19233__$1,active,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
