// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__7072__auto__ = (((x == null))?null:x);
var m__7073__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7073__auto__.call(null,x));
} else {
var m__7073__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7073__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return (c2.dom.select.cljs$core$IFn$_invoke$arity$1 ? c2.dom.select.cljs$core$IFn$_invoke$arity$1(selector) : c2.dom.select.call(null,selector));
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render(v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args35131 = [];
var len__7484__auto___35134 = arguments.length;
var i__7485__auto___35135 = (0);
while(true){
if((i__7485__auto___35135 < len__7484__auto___35134)){
args35131.push((arguments[i__7485__auto___35135]));

var G__35136 = (i__7485__auto___35135 + (1));
i__7485__auto___35135 = G__35136;
continue;
} else {
}
break;
}

var G__35133 = args35131.length;
switch (G__35133) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35131.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;

/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args35138 = [];
var len__7484__auto___35141 = arguments.length;
var i__7485__auto___35142 = (0);
while(true){
if((i__7485__auto___35142 < len__7484__auto___35141)){
args35138.push((arguments[i__7485__auto___35142]));

var G__35143 = (i__7485__auto___35142 + (1));
i__7485__auto___35142 = G__35143;
continue;
} else {
}
break;
}

var G__35140 = args35138.length;
switch (G__35140) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35138.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;

/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom(node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom(node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__35147_35149 = c2.dom.__GT_dom(container);
var G__35148_35150 = el__$1;
goog.dom.appendChild(G__35147_35149,G__35148_35150);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__35154_35157 = c2.dom.__GT_dom(container);
var G__35155_35158 = el__$1;
var G__35156_35159 = (0);
goog.dom.insertChildAt(G__35154_35157,G__35155_35158,G__35156_35159);

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
var G__35161 = c2.dom.__GT_dom(el);
return goog.dom.removeNode(G__35161);
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom(new$);
var G__35164_35166 = new$__$1;
var G__35165_35167 = c2.dom.__GT_dom(old);
goog.dom.replaceNode(G__35164_35166,G__35165_35167);

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args35168 = [];
var len__7484__auto___35186 = arguments.length;
var i__7485__auto___35187 = (0);
while(true){
if((i__7485__auto___35187 < len__7484__auto___35186)){
args35168.push((arguments[i__7485__auto___35187]));

var G__35188 = (i__7485__auto___35187 + (1));
i__7485__auto___35187 = G__35188;
continue;
} else {
}
break;
}

var G__35170 = args35168.length;
switch (G__35170) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35168.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
var G__35171 = el__$1;
var G__35172 = cljs.core.name(x);
return goog.style.getComputedStyle(G__35171,G__35172);
} else {
if(cljs.core.map_QMARK_(x)){
var seq__35173_35190 = cljs.core.seq(x);
var chunk__35174_35191 = null;
var count__35175_35192 = (0);
var i__35176_35193 = (0);
while(true){
if((i__35176_35193 < count__35175_35192)){
var vec__35177_35194 = chunk__35174_35191.cljs$core$IIndexed$_nth$arity$2(null,i__35176_35193);
var k_35195 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35177_35194,(0),null);
var v_35196 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35177_35194,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_35195,v_35196);

var G__35197 = seq__35173_35190;
var G__35198 = chunk__35174_35191;
var G__35199 = count__35175_35192;
var G__35200 = (i__35176_35193 + (1));
seq__35173_35190 = G__35197;
chunk__35174_35191 = G__35198;
count__35175_35192 = G__35199;
i__35176_35193 = G__35200;
continue;
} else {
var temp__4657__auto___35201 = cljs.core.seq(seq__35173_35190);
if(temp__4657__auto___35201){
var seq__35173_35202__$1 = temp__4657__auto___35201;
if(cljs.core.chunked_seq_QMARK_(seq__35173_35202__$1)){
var c__7220__auto___35203 = cljs.core.chunk_first(seq__35173_35202__$1);
var G__35204 = cljs.core.chunk_rest(seq__35173_35202__$1);
var G__35205 = c__7220__auto___35203;
var G__35206 = cljs.core.count(c__7220__auto___35203);
var G__35207 = (0);
seq__35173_35190 = G__35204;
chunk__35174_35191 = G__35205;
count__35175_35192 = G__35206;
i__35176_35193 = G__35207;
continue;
} else {
var vec__35180_35208 = cljs.core.first(seq__35173_35202__$1);
var k_35209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35180_35208,(0),null);
var v_35210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35180_35208,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_35209,v_35210);

var G__35211 = cljs.core.next(seq__35173_35202__$1);
var G__35212 = null;
var G__35213 = (0);
var G__35214 = (0);
seq__35173_35190 = G__35211;
chunk__35174_35191 = G__35212;
count__35175_35192 = G__35213;
i__35176_35193 = G__35214;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var G__35183_35215 = c2.dom.__GT_dom(el);
var G__35184_35216 = cljs.core.name(k);
var G__35185_35217 = ((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$bottom,null,cljs.core.cst$kw$top,null,cljs.core.cst$kw$width,null,cljs.core.cst$kw$right,null,cljs.core.cst$kw$height,null,cljs.core.cst$kw$left,null], null), null).call(null,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null));
goog.style.setStyle(G__35183_35215,G__35184_35216,G__35185_35217);

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args35218 = [];
var len__7484__auto___35237 = arguments.length;
var i__7485__auto___35238 = (0);
while(true){
if((i__7485__auto___35238 < len__7484__auto___35237)){
args35218.push((arguments[i__7485__auto___35238]));

var G__35239 = (i__7485__auto___35238 + (1));
i__7485__auto___35238 = G__35239;
continue;
} else {
}
break;
}

var G__35220 = args35218.length;
switch (G__35220) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35218.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom(el).attributes;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (attrs){
return (function c2$dom$iter__35221(s__35222){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__35222__$1 = s__35222;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35222__$1);
if(temp__4657__auto__){
var s__35222__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35222__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35222__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35224 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35223 = (0);
while(true){
if((i__35223 < size__7188__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35223);
cljs.core.chunk_append(b__35224,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null));

var G__35241 = (i__35223 + (1));
i__35223 = G__35241;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35224),c2$dom$iter__35221(cljs.core.chunk_rest(s__35222__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35224),null);
}
} else {
var i = cljs.core.first(s__35222__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__35221(cljs.core.rest(s__35222__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__7189__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name(x));
} else {
if(cljs.core.map_QMARK_(x)){
var seq__35227_35242 = cljs.core.seq(x);
var chunk__35228_35243 = null;
var count__35229_35244 = (0);
var i__35230_35245 = (0);
while(true){
if((i__35230_35245 < count__35229_35244)){
var vec__35231_35246 = chunk__35228_35243.cljs$core$IIndexed$_nth$arity$2(null,i__35230_35245);
var k_35247 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35231_35246,(0),null);
var v_35248 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35231_35246,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_35247,v_35248);

var G__35249 = seq__35227_35242;
var G__35250 = chunk__35228_35243;
var G__35251 = count__35229_35244;
var G__35252 = (i__35230_35245 + (1));
seq__35227_35242 = G__35249;
chunk__35228_35243 = G__35250;
count__35229_35244 = G__35251;
i__35230_35245 = G__35252;
continue;
} else {
var temp__4657__auto___35253 = cljs.core.seq(seq__35227_35242);
if(temp__4657__auto___35253){
var seq__35227_35254__$1 = temp__4657__auto___35253;
if(cljs.core.chunked_seq_QMARK_(seq__35227_35254__$1)){
var c__7220__auto___35255 = cljs.core.chunk_first(seq__35227_35254__$1);
var G__35256 = cljs.core.chunk_rest(seq__35227_35254__$1);
var G__35257 = c__7220__auto___35255;
var G__35258 = cljs.core.count(c__7220__auto___35255);
var G__35259 = (0);
seq__35227_35242 = G__35256;
chunk__35228_35243 = G__35257;
count__35229_35244 = G__35258;
i__35230_35245 = G__35259;
continue;
} else {
var vec__35234_35260 = cljs.core.first(seq__35227_35254__$1);
var k_35261 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35234_35260,(0),null);
var v_35262 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35234_35260,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_35261,v_35262);

var G__35263 = cljs.core.next(seq__35227_35254__$1);
var G__35264 = null;
var G__35265 = (0);
var G__35266 = (0);
seq__35227_35242 = G__35263;
chunk__35228_35243 = G__35264;
count__35229_35244 = G__35265;
i__35230_35245 = G__35266;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom(el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name(k));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$style,k)){
c2.dom.style.cljs$core$IFn$_invoke$arity$2(el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name(k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args35267 = [];
var len__7484__auto___35271 = arguments.length;
var i__7485__auto___35272 = (0);
while(true){
if((i__7485__auto___35272 < len__7484__auto___35271)){
args35267.push((arguments[i__7485__auto___35272]));

var G__35273 = (i__7485__auto___35272 + (1));
i__7485__auto___35272 = G__35273;
continue;
} else {
}
break;
}

var G__35269 = args35267.length;
switch (G__35269) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35267.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__35270 = c2.dom.__GT_dom(el);
return goog.dom.getTextContent(G__35270);
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;

/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args35275 = [];
var len__7484__auto___35279 = arguments.length;
var i__7485__auto___35280 = (0);
while(true){
if((i__7485__auto___35280 < len__7484__auto___35279)){
args35275.push((arguments[i__7485__auto___35280]));

var G__35281 = (i__7485__auto___35280 + (1));
i__7485__auto___35280 = G__35281;
continue;
} else {
}
break;
}

var G__35277 = args35275.length;
switch (G__35277) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35275.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__35278 = c2.dom.__GT_dom(el);
return goog.dom.forms.getValue(G__35278);
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;

/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
var G__35286_35289 = c2.dom.__GT_dom(el);
var G__35287_35290 = cljs.core.name(class$);
var G__35288_35291 = classed_QMARK_;
goog.dom.classes.enable(G__35286_35289,G__35287_35290,G__35288_35291);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6409__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return ((function (or__6409__auto____$1,or__6409__auto__){
return (function (p1__35292_SHARP_){
var G__35293 = ((function (or__6409__auto____$1,or__6409__auto__){
return (function (){
return (p1__35292_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p1__35292_SHARP_.cljs$core$IFn$_invoke$arity$0() : p1__35292_SHARP_.call(null));
});})(or__6409__auto____$1,or__6409__auto__))
;
var G__35294 = (10);
return setTimeout(G__35293,G__35294);
});
;})(or__6409__auto____$1,or__6409__auto__))
}
}
})();
