// Compiled by ClojureScript 1.9.229 {}
goog.provide('chimera.js_interop');
goog.require('cljs.core');
goog.require('cognitect.transit');
goog.require('goog.string');
/**
 * Convert json string to cljs object using transit.
 * Fast, but doesn't preserve keywords.
 */
chimera.js_interop.json__GT_cljs = (function chimera$js_interop$json__GT_cljs(s){
return cognitect.transit.read.call(null,cognitect.transit.reader.call(null,new cljs.core.Keyword(null,"json","json",1279968570)),s);
});
/**
 * Convert json to js using JSON.parse.
 * If error occurs, return the string unmodified.
 */
chimera.js_interop.str__GT_json = (function chimera$js_interop$str__GT_json(string){
try{return JSON.parse(string);
}catch (e10739){if((e10739 instanceof Error)){
var _ = e10739;
return string;
} else {
throw e10739;

}
}});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
chimera.js_interop.json__GT_js__GT_cljs = (function chimera$js_interop$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.call(null,chimera.js_interop.str__GT_json.call(null,s),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
chimera.js_interop.format = (function chimera$js_interop$format(var_args){
var args__7491__auto__ = [];
var len__7484__auto___10742 = arguments.length;
var i__7485__auto___10743 = (0);
while(true){
if((i__7485__auto___10743 < len__7484__auto___10742)){
args__7491__auto__.push((arguments[i__7485__auto___10743]));

var G__10744 = (i__7485__auto___10743 + (1));
i__7485__auto___10743 = G__10744;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.call(null,goog.string.format,fmt,args);
});

chimera.js_interop.format.cljs$lang$maxFixedArity = (1);

chimera.js_interop.format.cljs$lang$applyTo = (function (seq10740){
var G__10741 = cljs.core.first.call(null,seq10740);
var seq10740__$1 = cljs.core.next.call(null,seq10740);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic(G__10741,seq10740__$1);
});

/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
chimera.js_interop.safe_regex = (function chimera$js_interop$safe_regex(var_args){
var args__7491__auto__ = [];
var len__7484__auto___10750 = arguments.length;
var i__7485__auto___10751 = (0);
while(true){
if((i__7485__auto___10751 < len__7484__auto___10750)){
args__7491__auto__.push((arguments[i__7485__auto___10751]));

var G__10752 = (i__7485__auto___10751 + (1));
i__7485__auto___10751 = G__10752;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (query_string,p__10747){
var map__10748 = p__10747;
var map__10748__$1 = ((((!((map__10748 == null)))?((((map__10748.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10748.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10748):map__10748);
var ignore_case_QMARK_ = cljs.core.get.call(null,map__10748__$1,new cljs.core.Keyword(null,"ignore-case?","ignore-case?",-956106212),true);
return cljs.core.re_pattern.call(null,[cljs.core.str((cljs.core.truth_(ignore_case_QMARK_)?"(?i)":null)),cljs.core.str(goog.string.regExpEscape(query_string))].join(''));
});

chimera.js_interop.safe_regex.cljs$lang$maxFixedArity = (1);

chimera.js_interop.safe_regex.cljs$lang$applyTo = (function (seq10745){
var G__10746 = cljs.core.first.call(null,seq10745);
var seq10745__$1 = cljs.core.next.call(null,seq10745);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__10746,seq10745__$1);
});

