// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.viewby');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('hatti.map.utils');
goog.require('hatti.utils.style');
goog.require('hatti.charting');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('clojure.string');
hatti.map.viewby.marker_styler = (function hatti$map$viewby$marker_styler(id_color,id_selected_QMARK_){
return (function (marker){
var id = hatti.map.utils.get_id(marker);
var geotype = hatti.map.utils.marker__GT_geotype(marker);
var color_key = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$line,geotype))?cljs.core.cst$kw$color:cljs.core.cst$kw$fillColor);
return cljs.core.PersistentArrayMap.fromArray([color_key,(cljs.core.truth_((id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(id) : id_selected_QMARK_.call(null,id)))?(id_color.cljs$core$IFn$_invoke$arity$1 ? id_color.cljs$core$IFn$_invoke$arity$1(id) : id_color.call(null,id)):hatti.utils.style.grey)], true, false);
});
});
hatti.map.viewby.move_nil_to_end = (function hatti$map$viewby$move_nil_to_end(s){
var no_nil = cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,s));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s,no_nil)){
return s;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(no_nil,null);
}
});
hatti.map.viewby.all_but_nil_selected = (function hatti$map$viewby$all_but_nil_selected(answers){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(true)),new cljs.core.PersistentArrayMap(null, 1, [null,false], null)], 0));
});
/**
 * Preproccesses answers depending on the field. For multi-selects, return type
 * is a list of list of strings. For other types, a list of strings.
 */
hatti.map.viewby.preprocess_answers = (function hatti$map$viewby$preprocess_answers(field,raw_answers){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return hatti.charting.evenly_spaced_bins(raw_answers,(5),"int");
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return hatti.charting.evenly_spaced_bins(raw_answers,(5),"date");
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35712_SHARP_){
if(cljs.core.truth_(p1__35712_SHARP_)){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__35712_SHARP_,/ /);
} else {
return null;
}
}),raw_answers);
} else {
return null;
}
}
}
}
}
}
});
hatti.map.viewby.has_geolocation_QMARK_ = (function hatti$map$viewby$has_geolocation_QMARK_(p__35713){
var map__35719 = p__35713;
var map__35719__$1 = ((((!((map__35719 == null)))?((((map__35719.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35719.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35719):map__35719);
var vec__35720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35719__$1,"_geolocation");
var lattitude = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35720,(0),null);
var longitude = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35720,(1),null);
var and__6397__auto__ = lattitude;
if(cljs.core.truth_(and__6397__auto__)){
return lattitude;
} else {
return and__6397__auto__;
}
});
/**
 * Produces a set of data structures / functions for view-by.
 * answers are a list of answers, sorted by count;
 * id->answers is a mapping from id to either one or many answers
 * answer->count, answer->selected?, answer->color are maps from answer;
 * used for the legend rendering. An 'answer' is mapped from a data element,
 * eg. a bin for numbers/dates, an option for multiple/single selects.
 */
hatti.map.viewby.viewby_info = (function hatti$map$viewby$viewby_info(p__35727,data){
var map__35730 = p__35727;
var map__35730__$1 = ((((!((map__35730 == null)))?((((map__35730.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35730.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35730):map__35730);
var field = map__35730__$1;
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35730__$1,cljs.core.cst$kw$full_DASH_name);
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__35730,map__35730__$1,field,full_name){
return (function (p1__35724_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__35724_SHARP_,hatti.constants._id);
});})(map__35730,map__35730__$1,field,full_name))
,data);
var raw_answers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ids,map__35730,map__35730__$1,field,full_name){
return (function (p1__35725_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__35725_SHARP_,full_name);
});})(ids,map__35730,map__35730__$1,field,full_name))
,data);
var submissions_with_geolocation = cljs.core.filterv(hatti.map.viewby.has_geolocation_QMARK_,data);
var raw_answers_with_geolocation = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ids,raw_answers,submissions_with_geolocation,map__35730,map__35730__$1,field,full_name){
return (function (p1__35726_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__35726_SHARP_,full_name);
});})(ids,raw_answers,submissions_with_geolocation,map__35730,map__35730__$1,field,full_name))
,submissions_with_geolocation);
var preprocessed_answers = hatti.map.viewby.preprocess_answers(field,raw_answers);
var answer__GT_count = cljs.core.frequencies(cljs.core.flatten(preprocessed_answers));
var answer__GT_count_with_geolocations = cljs.core.frequencies(cljs.core.flatten(hatti.map.viewby.preprocess_answers(field,raw_answers_with_geolocation)));
var sorted_answers = (cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.categorical_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = hatti.ona.forms.text_QMARK_(field);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return hatti.ona.forms.calculate_QMARK_(field);
}
}
})())?cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.second,cljs.core._GT_,answer__GT_count)):(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.time_based_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.numeric_QMARK_(field);
}
})())?cljs.core.cst$kw$bins.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(preprocessed_answers)):null));
var sorted_answers_with_nil_at_end = hatti.map.viewby.move_nil_to_end(sorted_answers);
var answer__GT_color_map = hatti.utils.style.answer__GT_color(field,sorted_answers);
var defaults = new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$id_DASH__GT_answers,cljs.core.zipmap(ids,preprocessed_answers),cljs.core.cst$kw$answer_DASH__GT_count,answer__GT_count,cljs.core.cst$kw$answer_DASH__GT_count_DASH_with_DASH_geolocations,answer__GT_count_with_geolocations,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_,hatti.map.viewby.all_but_nil_selected(sorted_answers),cljs.core.cst$kw$answer_DASH__GT_color,answer__GT_color_map,cljs.core.cst$kw$visible_DASH_answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$field,field], null);
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([defaults,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id_DASH_color,((function (ids,raw_answers,submissions_with_geolocation,raw_answers_with_geolocation,preprocessed_answers,answer__GT_count,answer__GT_count_with_geolocations,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__35730,map__35730__$1,field,full_name){
return (function (){
return cljs.core.first(cljs.core.vals(answer__GT_color_map));
});})(ids,raw_answers,submissions_with_geolocation,raw_answers_with_geolocation,preprocessed_answers,answer__GT_count,answer__GT_count_with_geolocations,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__35730,map__35730__$1,field,full_name))
], null)], 0));
} else {
return defaults;

}
});
/**
 * Produces a set of data structures / functions for view-by.
 * answers are a list of answers, sorted by count;
 * id->answers is a mapping from id to either one or many answers
 * answer->count, answer->selected?, answer->color are maps from answer;
 * used for the legend rendering. An 'answer' is mapped from a data element,
 * eg. a bin for numbers/dates, an option for multiple/single selects.
 */
hatti.map.viewby.viewby_data = (function hatti$map$viewby$viewby_data(p__35734,data){
var map__35737 = p__35734;
var map__35737__$1 = ((((!((map__35737 == null)))?((((map__35737.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35737.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35737):map__35737);
var field = map__35737__$1;
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35737__$1,cljs.core.cst$kw$full_DASH_name);
if(cljs.core.seq_QMARK_(cljs.core.seq(data))){
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__35737,map__35737__$1,field,full_name){
return (function (p1__35732_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__35732_SHARP_,hatti.constants._id);
});})(map__35737,map__35737__$1,field,full_name))
,data);
var raw_answers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ids,map__35737,map__35737__$1,field,full_name){
return (function (p1__35733_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__35733_SHARP_,full_name);
});})(ids,map__35737,map__35737__$1,field,full_name))
,data);
var preprocessed_answers = hatti.map.viewby.preprocess_answers(field,raw_answers);
var answer__GT_count = cljs.core.frequencies(cljs.core.flatten(preprocessed_answers));
var sorted_answers = (cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.categorical_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = hatti.ona.forms.text_QMARK_(field);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return hatti.ona.forms.calculate_QMARK_(field);
}
}
})())?cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.second,cljs.core._GT_,answer__GT_count)):(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.time_based_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.numeric_QMARK_(field);
}
})())?cljs.core.cst$kw$bins.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(preprocessed_answers)):null));
var sorted_answers_with_nil_at_end = hatti.map.viewby.move_nil_to_end(sorted_answers);
var answer__GT_color_map = hatti.utils.style.answer__GT_color(field,sorted_answers);
var defaults = new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$ids,ids,cljs.core.cst$kw$answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$id_DASH__GT_answers,cljs.core.zipmap(ids,preprocessed_answers),cljs.core.cst$kw$answer_DASH__GT_count,answer__GT_count,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_,hatti.map.viewby.all_but_nil_selected(sorted_answers),cljs.core.cst$kw$answer_DASH__GT_color,answer__GT_color_map,cljs.core.cst$kw$visible_DASH_answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$field,field], null);
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([defaults,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id_DASH_color,((function (ids,raw_answers,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__35737,map__35737__$1,field,full_name){
return (function (){
return cljs.core.first(cljs.core.vals(answer__GT_color_map));
});})(ids,raw_answers,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__35737,map__35737__$1,field,full_name))
], null)], 0));
} else {
return defaults;

}
} else {
return null;
}
});
/**
 * Generates id-color and id-selected? functions based on viewby-info.
 */
hatti.map.viewby.id_color_selected = (function hatti$map$viewby$id_color_selected(p__35741){
var map__35747 = p__35741;
var map__35747__$1 = ((((!((map__35747 == null)))?((((map__35747.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35747.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35747):map__35747);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35747__$1,cljs.core.cst$kw$field);
var id__GT_answers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35747__$1,cljs.core.cst$kw$id_DASH__GT_answers);
var answer__GT_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35747__$1,cljs.core.cst$kw$answer_DASH__GT_color);
var answer__GT_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35747__$1,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_);
var G__35749 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(field);
switch (G__35749) {
case "select all that apply":
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id_DASH_color,((function (G__35749,map__35747,map__35747__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (){
return cljs.core.first(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#f30"], null));
});})(G__35749,map__35747,map__35747__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,cljs.core.cst$kw$id_DASH_selected_QMARK_,((function (G__35749,map__35747,map__35747__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (id){
var answers = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(id) : id__GT_answers.call(null,id));
if((answers == null)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(answer__GT_selected_QMARK_,answers);
} else {
return cljs.core.some(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2(answer__GT_selected_QMARK_,answers));
}
});})(G__35749,map__35747,map__35747__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

break;
default:
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id_DASH_color,((function (G__35749,map__35747,map__35747__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__35739_SHARP_){
var G__35750 = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(p1__35739_SHARP_) : id__GT_answers.call(null,p1__35739_SHARP_));
return (answer__GT_color.cljs$core$IFn$_invoke$arity$1 ? answer__GT_color.cljs$core$IFn$_invoke$arity$1(G__35750) : answer__GT_color.call(null,G__35750));
});})(G__35749,map__35747,map__35747__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,cljs.core.cst$kw$id_DASH_selected_QMARK_,((function (G__35749,map__35747,map__35747__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__35740_SHARP_){
var G__35751 = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(p1__35740_SHARP_) : id__GT_answers.call(null,p1__35740_SHARP_));
return (answer__GT_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? answer__GT_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__35751) : answer__GT_selected_QMARK_.call(null,G__35751));
});})(G__35749,map__35747,map__35747__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

}
});
hatti.map.viewby.view_by_BANG_ = (function hatti$map$viewby$view_by_BANG_(view_by_info,markers){
var map__35759 = hatti.map.viewby.id_color_selected(view_by_info);
var map__35759__$1 = ((((!((map__35759 == null)))?((((map__35759.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35759.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35759):map__35759);
var id_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35759__$1,cljs.core.cst$kw$id_DASH_selected_QMARK_);
var id_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35759__$1,cljs.core.cst$kw$id_DASH_color);
var m__GT_s = hatti.map.viewby.marker_styler(id_color,id_selected_QMARK_);
var seq__35761 = cljs.core.seq(markers);
var chunk__35762 = null;
var count__35763 = (0);
var i__35764 = (0);
while(true){
if((i__35764 < count__35763)){
var marker = chunk__35762.cljs$core$IIndexed$_nth$arity$2(null,i__35764);
hatti.map.utils.re_style_marker(m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected(id_selected_QMARK_,marker);

var G__35765 = seq__35761;
var G__35766 = chunk__35762;
var G__35767 = count__35763;
var G__35768 = (i__35764 + (1));
seq__35761 = G__35765;
chunk__35762 = G__35766;
count__35763 = G__35767;
i__35764 = G__35768;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__35761);
if(temp__4657__auto__){
var seq__35761__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35761__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__35761__$1);
var G__35769 = cljs.core.chunk_rest(seq__35761__$1);
var G__35770 = c__7220__auto__;
var G__35771 = cljs.core.count(c__7220__auto__);
var G__35772 = (0);
seq__35761 = G__35769;
chunk__35762 = G__35770;
count__35763 = G__35771;
i__35764 = G__35772;
continue;
} else {
var marker = cljs.core.first(seq__35761__$1);
hatti.map.utils.re_style_marker(m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected(id_selected_QMARK_,marker);

var G__35773 = cljs.core.next(seq__35761__$1);
var G__35774 = null;
var G__35775 = (0);
var G__35776 = (0);
seq__35761 = G__35773;
chunk__35762 = G__35774;
count__35763 = G__35775;
i__35764 = G__35776;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.viewby.apply_view_by_BANG_ = (function hatti$map$viewby$apply_view_by_BANG_(p__35778,owner){
var map__35783 = p__35778;
var map__35783__$1 = ((((!((map__35783 == null)))?((((map__35783.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35783.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35783):map__35783);
var view_by_info = map__35783__$1;
var id__GT_answers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35783__$1,cljs.core.cst$kw$id_DASH__GT_answers);
var map__35785 = hatti.map.viewby.id_color_selected(view_by_info);
var map__35785__$1 = ((((!((map__35785 == null)))?((((map__35785.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35785.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35785):map__35785);
var id_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35785__$1,cljs.core.cst$kw$id_DASH_selected_QMARK_);
var id_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35785__$1,cljs.core.cst$kw$id_DASH_color);
var ids = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.keys(id__GT_answers));
var stops = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (map__35785,map__35785__$1,id_selected_QMARK_,id_color,ids,map__35783,map__35783__$1,view_by_info,id__GT_answers){
return (function (p1__35777_SHARP_){
if(cljs.core.truth_((id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(p1__35777_SHARP_) : id_selected_QMARK_.call(null,p1__35777_SHARP_)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__35777_SHARP_,(id_color.cljs$core$IFn$_invoke$arity$1 ? id_color.cljs$core$IFn$_invoke$arity$1(p1__35777_SHARP_) : id_color.call(null,p1__35777_SHARP_))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__35777_SHARP_,hatti.utils.style.grey], null);
}
});})(map__35785,map__35785__$1,id_selected_QMARK_,id_color,ids,map__35783,map__35783__$1,view_by_info,id__GT_answers))
,ids);
var id_string = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$id_string], null));
var style = om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$style], null));
if(cljs.core.seq_QMARK_(cljs.core.seq(stops))){
hatti.map.utils.set_mapboxgl_paint_property(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$mapboxgl_DASH_map),id_string,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$normal,cljs.core.array_seq([cljs.core.cst$kw$stops,stops], 0)));

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$stops,stops);
} else {
return null;
}
});
/**
 * Given a list of answers + query, returns map from answers to true/false.
 * True if query is in the answer, false if not.
 */
hatti.map.viewby.filter_answer_data_structures = (function hatti$map$viewby$filter_answer_data_structures(answers,query,field,language){
var query_present_QMARK_ = (function (ans){
if(cljs.core.truth_(ans)){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$3(field,ans,language));
} else {
return null;
}
});
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$visible_DASH_answers,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(query_present_QMARK_,answers),cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_,cljs.core.zipmap(answers,cljs.core.map.cljs$core$IFn$_invoke$arity$2(query_present_QMARK_,answers))], null);
});
/**
 * This function appropriately toggles answer->selected? when answer is clicked
 * answer->selected? is a map from answers to true/false. Special rules:
 * First click = select the answer. If nothing clicked, make everything
 * clicked.
 */
hatti.map.viewby.toggle_answer_selected = (function hatti$map$viewby$toggle_answer_selected(answer__GT_selected_QMARK_,visible_answers,answer){
var all_answers = cljs.core.vals(answer__GT_selected_QMARK_);
var all_visible_selected_QMARK_ = ((function (all_answers){
return (function (a__GT_s,visible){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.set(visible),cljs.core.set(cljs.core.keys(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.second,a__GT_s))));
});})(all_answers))
;
if((answer == null)){
return answer__GT_selected_QMARK_;
} else {
if(cljs.core.truth_(all_visible_selected_QMARK_(answer__GT_selected_QMARK_,visible_answers))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(all_answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(false)),cljs.core.PersistentArrayMap.fromArray([answer,true], true, false)], 0));
} else {
var toggled = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(answer__GT_selected_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer], null),cljs.core.not);
if(cljs.core.every_QMARK_(cljs.core.false_QMARK_,cljs.core.vals(toggled))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(all_answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(false)),hatti.map.viewby.all_but_nil_selected(visible_answers)], 0));
} else {
return toggled;
}
}
}
});
