// Compiled by ClojureScript 1.9.229 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__15765__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__15762 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__15763 = cljs.core.seq.call(null,vec__15762);
var first__15764 = cljs.core.first.call(null,seq__15763);
var seq__15763__$1 = cljs.core.next.call(null,seq__15763);
var tag = first__15764;
var body = seq__15763__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__15765 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__15766__i = 0, G__15766__a = new Array(arguments.length -  0);
while (G__15766__i < G__15766__a.length) {G__15766__a[G__15766__i] = arguments[G__15766__i + 0]; ++G__15766__i;}
  args = new cljs.core.IndexedSeq(G__15766__a,0);
} 
return G__15765__delegate.call(this,args);};
G__15765.cljs$lang$maxFixedArity = 0;
G__15765.cljs$lang$applyTo = (function (arglist__15767){
var args = cljs.core.seq(arglist__15767);
return G__15765__delegate(args);
});
G__15765.cljs$core$IFn$_invoke$arity$variadic = G__15765__delegate;
return G__15765;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__15772(s__15773){
return (new cljs.core.LazySeq(null,(function (){
var s__15773__$1 = s__15773;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__15773__$1);
if(temp__4657__auto__){
var s__15773__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15773__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__15773__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__15775 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__15774 = (0);
while(true){
if((i__15774 < size__7188__auto__)){
var args = cljs.core._nth.call(null,c__7187__auto__,i__15774);
cljs.core.chunk_append.call(null,b__15775,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__15776 = (i__15774 + (1));
i__15774 = G__15776;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15775),sablono$core$update_arglists_$_iter__15772.call(null,cljs.core.chunk_rest.call(null,s__15773__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15775),null);
}
} else {
var args = cljs.core.first.call(null,s__15773__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__15772.call(null,cljs.core.rest.call(null,s__15773__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___15782 = arguments.length;
var i__7485__auto___15783 = (0);
while(true){
if((i__7485__auto___15783 < len__7484__auto___15782)){
args__7491__auto__.push((arguments[i__7485__auto___15783]));

var G__15784 = (i__7485__auto___15783 + (1));
i__7485__auto___15783 = G__15784;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__15778(s__15779){
return (new cljs.core.LazySeq(null,(function (){
var s__15779__$1 = s__15779;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__15779__$1);
if(temp__4657__auto__){
var s__15779__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15779__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__15779__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__15781 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__15780 = (0);
while(true){
if((i__15780 < size__7188__auto__)){
var style = cljs.core._nth.call(null,c__7187__auto__,i__15780);
cljs.core.chunk_append.call(null,b__15781,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__15785 = (i__15780 + (1));
i__15780 = G__15785;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15781),sablono$core$iter__15778.call(null,cljs.core.chunk_rest.call(null,s__15779__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15781),null);
}
} else {
var style = cljs.core.first.call(null,s__15779__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__15778.call(null,cljs.core.rest.call(null,s__15779__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq15777){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq15777));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to15786 = (function sablono$core$link_to15786(var_args){
var args__7491__auto__ = [];
var len__7484__auto___15789 = arguments.length;
var i__7485__auto___15790 = (0);
while(true){
if((i__7485__auto___15790 < len__7484__auto___15789)){
args__7491__auto__.push((arguments[i__7485__auto___15790]));

var G__15791 = (i__7485__auto___15790 + (1));
i__7485__auto___15790 = G__15791;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to15786.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to15786.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to15786.cljs$lang$maxFixedArity = (1);

sablono.core.link_to15786.cljs$lang$applyTo = (function (seq15787){
var G__15788 = cljs.core.first.call(null,seq15787);
var seq15787__$1 = cljs.core.next.call(null,seq15787);
return sablono.core.link_to15786.cljs$core$IFn$_invoke$arity$variadic(G__15788,seq15787__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to15786);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to15792 = (function sablono$core$mail_to15792(var_args){
var args__7491__auto__ = [];
var len__7484__auto___15799 = arguments.length;
var i__7485__auto___15800 = (0);
while(true){
if((i__7485__auto___15800 < len__7484__auto___15799)){
args__7491__auto__.push((arguments[i__7485__auto___15800]));

var G__15801 = (i__7485__auto___15800 + (1));
i__7485__auto___15800 = G__15801;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to15792.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to15792.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__15795){
var vec__15796 = p__15795;
var content = cljs.core.nth.call(null,vec__15796,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to15792.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to15792.cljs$lang$applyTo = (function (seq15793){
var G__15794 = cljs.core.first.call(null,seq15793);
var seq15793__$1 = cljs.core.next.call(null,seq15793);
return sablono.core.mail_to15792.cljs$core$IFn$_invoke$arity$variadic(G__15794,seq15793__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to15792);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list15802 = (function sablono$core$unordered_list15802(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__7189__auto__ = (function sablono$core$unordered_list15802_$_iter__15807(s__15808){
return (new cljs.core.LazySeq(null,(function (){
var s__15808__$1 = s__15808;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__15808__$1);
if(temp__4657__auto__){
var s__15808__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15808__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__15808__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__15810 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__15809 = (0);
while(true){
if((i__15809 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__15809);
cljs.core.chunk_append.call(null,b__15810,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__15811 = (i__15809 + (1));
i__15809 = G__15811;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15810),sablono$core$unordered_list15802_$_iter__15807.call(null,cljs.core.chunk_rest.call(null,s__15808__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15810),null);
}
} else {
var x = cljs.core.first.call(null,s__15808__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list15802_$_iter__15807.call(null,cljs.core.rest.call(null,s__15808__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list15802);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list15812 = (function sablono$core$ordered_list15812(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__7189__auto__ = (function sablono$core$ordered_list15812_$_iter__15817(s__15818){
return (new cljs.core.LazySeq(null,(function (){
var s__15818__$1 = s__15818;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__15818__$1);
if(temp__4657__auto__){
var s__15818__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15818__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__15818__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__15820 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__15819 = (0);
while(true){
if((i__15819 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__15819);
cljs.core.chunk_append.call(null,b__15820,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__15821 = (i__15819 + (1));
i__15819 = G__15821;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15820),sablono$core$ordered_list15812_$_iter__15817.call(null,cljs.core.chunk_rest.call(null,s__15818__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15820),null);
}
} else {
var x = cljs.core.first.call(null,s__15818__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list15812_$_iter__15817.call(null,cljs.core.rest.call(null,s__15818__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list15812);
/**
 * Create an image element.
 */
sablono.core.image15822 = (function sablono$core$image15822(var_args){
var args15823 = [];
var len__7484__auto___15826 = arguments.length;
var i__7485__auto___15827 = (0);
while(true){
if((i__7485__auto___15827 < len__7484__auto___15826)){
args15823.push((arguments[i__7485__auto___15827]));

var G__15828 = (i__7485__auto___15827 + (1));
i__7485__auto___15827 = G__15828;
continue;
} else {
}
break;
}

var G__15825 = args15823.length;
switch (G__15825) {
case 1:
return sablono.core.image15822.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image15822.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15823.length)].join('')));

}
});

sablono.core.image15822.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image15822.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image15822.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image15822);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__15830_SHARP_,p2__15831_SHARP_){
return [cljs.core.str(p1__15830_SHARP_),cljs.core.str("["),cljs.core.str(p2__15831_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__15832_SHARP_,p2__15833_SHARP_){
return [cljs.core.str(p1__15832_SHARP_),cljs.core.str("-"),cljs.core.str(p2__15833_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field15834 = (function sablono$core$color_field15834(var_args){
var args15835 = [];
var len__7484__auto___15902 = arguments.length;
var i__7485__auto___15903 = (0);
while(true){
if((i__7485__auto___15903 < len__7484__auto___15902)){
args15835.push((arguments[i__7485__auto___15903]));

var G__15904 = (i__7485__auto___15903 + (1));
i__7485__auto___15903 = G__15904;
continue;
} else {
}
break;
}

var G__15837 = args15835.length;
switch (G__15837) {
case 1:
return sablono.core.color_field15834.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field15834.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15835.length)].join('')));

}
});

sablono.core.color_field15834.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.color_field15834.call(null,name__15679__auto__,null);
});

sablono.core.color_field15834.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.color_field15834.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field15834);

/**
 * Creates a date input field.
 */
sablono.core.date_field15838 = (function sablono$core$date_field15838(var_args){
var args15839 = [];
var len__7484__auto___15906 = arguments.length;
var i__7485__auto___15907 = (0);
while(true){
if((i__7485__auto___15907 < len__7484__auto___15906)){
args15839.push((arguments[i__7485__auto___15907]));

var G__15908 = (i__7485__auto___15907 + (1));
i__7485__auto___15907 = G__15908;
continue;
} else {
}
break;
}

var G__15841 = args15839.length;
switch (G__15841) {
case 1:
return sablono.core.date_field15838.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field15838.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15839.length)].join('')));

}
});

sablono.core.date_field15838.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.date_field15838.call(null,name__15679__auto__,null);
});

sablono.core.date_field15838.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.date_field15838.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field15838);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field15842 = (function sablono$core$datetime_field15842(var_args){
var args15843 = [];
var len__7484__auto___15910 = arguments.length;
var i__7485__auto___15911 = (0);
while(true){
if((i__7485__auto___15911 < len__7484__auto___15910)){
args15843.push((arguments[i__7485__auto___15911]));

var G__15912 = (i__7485__auto___15911 + (1));
i__7485__auto___15911 = G__15912;
continue;
} else {
}
break;
}

var G__15845 = args15843.length;
switch (G__15845) {
case 1:
return sablono.core.datetime_field15842.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field15842.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15843.length)].join('')));

}
});

sablono.core.datetime_field15842.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.datetime_field15842.call(null,name__15679__auto__,null);
});

sablono.core.datetime_field15842.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.datetime_field15842.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field15842);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field15846 = (function sablono$core$datetime_local_field15846(var_args){
var args15847 = [];
var len__7484__auto___15914 = arguments.length;
var i__7485__auto___15915 = (0);
while(true){
if((i__7485__auto___15915 < len__7484__auto___15914)){
args15847.push((arguments[i__7485__auto___15915]));

var G__15916 = (i__7485__auto___15915 + (1));
i__7485__auto___15915 = G__15916;
continue;
} else {
}
break;
}

var G__15849 = args15847.length;
switch (G__15849) {
case 1:
return sablono.core.datetime_local_field15846.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field15846.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15847.length)].join('')));

}
});

sablono.core.datetime_local_field15846.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.datetime_local_field15846.call(null,name__15679__auto__,null);
});

sablono.core.datetime_local_field15846.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.datetime_local_field15846.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field15846);

/**
 * Creates a email input field.
 */
sablono.core.email_field15850 = (function sablono$core$email_field15850(var_args){
var args15851 = [];
var len__7484__auto___15918 = arguments.length;
var i__7485__auto___15919 = (0);
while(true){
if((i__7485__auto___15919 < len__7484__auto___15918)){
args15851.push((arguments[i__7485__auto___15919]));

var G__15920 = (i__7485__auto___15919 + (1));
i__7485__auto___15919 = G__15920;
continue;
} else {
}
break;
}

var G__15853 = args15851.length;
switch (G__15853) {
case 1:
return sablono.core.email_field15850.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field15850.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15851.length)].join('')));

}
});

sablono.core.email_field15850.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.email_field15850.call(null,name__15679__auto__,null);
});

sablono.core.email_field15850.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.email_field15850.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field15850);

/**
 * Creates a file input field.
 */
sablono.core.file_field15854 = (function sablono$core$file_field15854(var_args){
var args15855 = [];
var len__7484__auto___15922 = arguments.length;
var i__7485__auto___15923 = (0);
while(true){
if((i__7485__auto___15923 < len__7484__auto___15922)){
args15855.push((arguments[i__7485__auto___15923]));

var G__15924 = (i__7485__auto___15923 + (1));
i__7485__auto___15923 = G__15924;
continue;
} else {
}
break;
}

var G__15857 = args15855.length;
switch (G__15857) {
case 1:
return sablono.core.file_field15854.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field15854.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15855.length)].join('')));

}
});

sablono.core.file_field15854.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.file_field15854.call(null,name__15679__auto__,null);
});

sablono.core.file_field15854.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.file_field15854.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field15854);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field15858 = (function sablono$core$hidden_field15858(var_args){
var args15859 = [];
var len__7484__auto___15926 = arguments.length;
var i__7485__auto___15927 = (0);
while(true){
if((i__7485__auto___15927 < len__7484__auto___15926)){
args15859.push((arguments[i__7485__auto___15927]));

var G__15928 = (i__7485__auto___15927 + (1));
i__7485__auto___15927 = G__15928;
continue;
} else {
}
break;
}

var G__15861 = args15859.length;
switch (G__15861) {
case 1:
return sablono.core.hidden_field15858.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field15858.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15859.length)].join('')));

}
});

sablono.core.hidden_field15858.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.hidden_field15858.call(null,name__15679__auto__,null);
});

sablono.core.hidden_field15858.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.hidden_field15858.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field15858);

/**
 * Creates a month input field.
 */
sablono.core.month_field15862 = (function sablono$core$month_field15862(var_args){
var args15863 = [];
var len__7484__auto___15930 = arguments.length;
var i__7485__auto___15931 = (0);
while(true){
if((i__7485__auto___15931 < len__7484__auto___15930)){
args15863.push((arguments[i__7485__auto___15931]));

var G__15932 = (i__7485__auto___15931 + (1));
i__7485__auto___15931 = G__15932;
continue;
} else {
}
break;
}

var G__15865 = args15863.length;
switch (G__15865) {
case 1:
return sablono.core.month_field15862.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field15862.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15863.length)].join('')));

}
});

sablono.core.month_field15862.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.month_field15862.call(null,name__15679__auto__,null);
});

sablono.core.month_field15862.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.month_field15862.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field15862);

/**
 * Creates a number input field.
 */
sablono.core.number_field15866 = (function sablono$core$number_field15866(var_args){
var args15867 = [];
var len__7484__auto___15934 = arguments.length;
var i__7485__auto___15935 = (0);
while(true){
if((i__7485__auto___15935 < len__7484__auto___15934)){
args15867.push((arguments[i__7485__auto___15935]));

var G__15936 = (i__7485__auto___15935 + (1));
i__7485__auto___15935 = G__15936;
continue;
} else {
}
break;
}

var G__15869 = args15867.length;
switch (G__15869) {
case 1:
return sablono.core.number_field15866.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field15866.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15867.length)].join('')));

}
});

sablono.core.number_field15866.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.number_field15866.call(null,name__15679__auto__,null);
});

sablono.core.number_field15866.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.number_field15866.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field15866);

/**
 * Creates a password input field.
 */
sablono.core.password_field15870 = (function sablono$core$password_field15870(var_args){
var args15871 = [];
var len__7484__auto___15938 = arguments.length;
var i__7485__auto___15939 = (0);
while(true){
if((i__7485__auto___15939 < len__7484__auto___15938)){
args15871.push((arguments[i__7485__auto___15939]));

var G__15940 = (i__7485__auto___15939 + (1));
i__7485__auto___15939 = G__15940;
continue;
} else {
}
break;
}

var G__15873 = args15871.length;
switch (G__15873) {
case 1:
return sablono.core.password_field15870.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field15870.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15871.length)].join('')));

}
});

sablono.core.password_field15870.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.password_field15870.call(null,name__15679__auto__,null);
});

sablono.core.password_field15870.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.password_field15870.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field15870);

/**
 * Creates a range input field.
 */
sablono.core.range_field15874 = (function sablono$core$range_field15874(var_args){
var args15875 = [];
var len__7484__auto___15942 = arguments.length;
var i__7485__auto___15943 = (0);
while(true){
if((i__7485__auto___15943 < len__7484__auto___15942)){
args15875.push((arguments[i__7485__auto___15943]));

var G__15944 = (i__7485__auto___15943 + (1));
i__7485__auto___15943 = G__15944;
continue;
} else {
}
break;
}

var G__15877 = args15875.length;
switch (G__15877) {
case 1:
return sablono.core.range_field15874.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field15874.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15875.length)].join('')));

}
});

sablono.core.range_field15874.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.range_field15874.call(null,name__15679__auto__,null);
});

sablono.core.range_field15874.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.range_field15874.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field15874);

/**
 * Creates a search input field.
 */
sablono.core.search_field15878 = (function sablono$core$search_field15878(var_args){
var args15879 = [];
var len__7484__auto___15946 = arguments.length;
var i__7485__auto___15947 = (0);
while(true){
if((i__7485__auto___15947 < len__7484__auto___15946)){
args15879.push((arguments[i__7485__auto___15947]));

var G__15948 = (i__7485__auto___15947 + (1));
i__7485__auto___15947 = G__15948;
continue;
} else {
}
break;
}

var G__15881 = args15879.length;
switch (G__15881) {
case 1:
return sablono.core.search_field15878.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field15878.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15879.length)].join('')));

}
});

sablono.core.search_field15878.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.search_field15878.call(null,name__15679__auto__,null);
});

sablono.core.search_field15878.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.search_field15878.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field15878);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field15882 = (function sablono$core$tel_field15882(var_args){
var args15883 = [];
var len__7484__auto___15950 = arguments.length;
var i__7485__auto___15951 = (0);
while(true){
if((i__7485__auto___15951 < len__7484__auto___15950)){
args15883.push((arguments[i__7485__auto___15951]));

var G__15952 = (i__7485__auto___15951 + (1));
i__7485__auto___15951 = G__15952;
continue;
} else {
}
break;
}

var G__15885 = args15883.length;
switch (G__15885) {
case 1:
return sablono.core.tel_field15882.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field15882.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15883.length)].join('')));

}
});

sablono.core.tel_field15882.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.tel_field15882.call(null,name__15679__auto__,null);
});

sablono.core.tel_field15882.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.tel_field15882.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field15882);

/**
 * Creates a text input field.
 */
sablono.core.text_field15886 = (function sablono$core$text_field15886(var_args){
var args15887 = [];
var len__7484__auto___15954 = arguments.length;
var i__7485__auto___15955 = (0);
while(true){
if((i__7485__auto___15955 < len__7484__auto___15954)){
args15887.push((arguments[i__7485__auto___15955]));

var G__15956 = (i__7485__auto___15955 + (1));
i__7485__auto___15955 = G__15956;
continue;
} else {
}
break;
}

var G__15889 = args15887.length;
switch (G__15889) {
case 1:
return sablono.core.text_field15886.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field15886.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15887.length)].join('')));

}
});

sablono.core.text_field15886.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.text_field15886.call(null,name__15679__auto__,null);
});

sablono.core.text_field15886.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.text_field15886.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field15886);

/**
 * Creates a time input field.
 */
sablono.core.time_field15890 = (function sablono$core$time_field15890(var_args){
var args15891 = [];
var len__7484__auto___15958 = arguments.length;
var i__7485__auto___15959 = (0);
while(true){
if((i__7485__auto___15959 < len__7484__auto___15958)){
args15891.push((arguments[i__7485__auto___15959]));

var G__15960 = (i__7485__auto___15959 + (1));
i__7485__auto___15959 = G__15960;
continue;
} else {
}
break;
}

var G__15893 = args15891.length;
switch (G__15893) {
case 1:
return sablono.core.time_field15890.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field15890.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15891.length)].join('')));

}
});

sablono.core.time_field15890.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.time_field15890.call(null,name__15679__auto__,null);
});

sablono.core.time_field15890.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.time_field15890.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field15890);

/**
 * Creates a url input field.
 */
sablono.core.url_field15894 = (function sablono$core$url_field15894(var_args){
var args15895 = [];
var len__7484__auto___15962 = arguments.length;
var i__7485__auto___15963 = (0);
while(true){
if((i__7485__auto___15963 < len__7484__auto___15962)){
args15895.push((arguments[i__7485__auto___15963]));

var G__15964 = (i__7485__auto___15963 + (1));
i__7485__auto___15963 = G__15964;
continue;
} else {
}
break;
}

var G__15897 = args15895.length;
switch (G__15897) {
case 1:
return sablono.core.url_field15894.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field15894.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15895.length)].join('')));

}
});

sablono.core.url_field15894.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.url_field15894.call(null,name__15679__auto__,null);
});

sablono.core.url_field15894.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.url_field15894.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field15894);

/**
 * Creates a week input field.
 */
sablono.core.week_field15898 = (function sablono$core$week_field15898(var_args){
var args15899 = [];
var len__7484__auto___15966 = arguments.length;
var i__7485__auto___15967 = (0);
while(true){
if((i__7485__auto___15967 < len__7484__auto___15966)){
args15899.push((arguments[i__7485__auto___15967]));

var G__15968 = (i__7485__auto___15967 + (1));
i__7485__auto___15967 = G__15968;
continue;
} else {
}
break;
}

var G__15901 = args15899.length;
switch (G__15901) {
case 1:
return sablono.core.week_field15898.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field15898.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15899.length)].join('')));

}
});

sablono.core.week_field15898.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.week_field15898.call(null,name__15679__auto__,null);
});

sablono.core.week_field15898.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.week_field15898.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field15898);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box15970 = (function sablono$core$check_box15970(var_args){
var args15971 = [];
var len__7484__auto___15974 = arguments.length;
var i__7485__auto___15975 = (0);
while(true){
if((i__7485__auto___15975 < len__7484__auto___15974)){
args15971.push((arguments[i__7485__auto___15975]));

var G__15976 = (i__7485__auto___15975 + (1));
i__7485__auto___15975 = G__15976;
continue;
} else {
}
break;
}

var G__15973 = args15971.length;
switch (G__15973) {
case 1:
return sablono.core.check_box15970.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box15970.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box15970.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15971.length)].join('')));

}
});

sablono.core.check_box15970.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box15970.call(null,name,null);
});

sablono.core.check_box15970.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box15970.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box15970.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box15970.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box15970);
/**
 * Creates a radio button.
 */
sablono.core.radio_button15978 = (function sablono$core$radio_button15978(var_args){
var args15979 = [];
var len__7484__auto___15982 = arguments.length;
var i__7485__auto___15983 = (0);
while(true){
if((i__7485__auto___15983 < len__7484__auto___15982)){
args15979.push((arguments[i__7485__auto___15983]));

var G__15984 = (i__7485__auto___15983 + (1));
i__7485__auto___15983 = G__15984;
continue;
} else {
}
break;
}

var G__15981 = args15979.length;
switch (G__15981) {
case 1:
return sablono.core.radio_button15978.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button15978.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button15978.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15979.length)].join('')));

}
});

sablono.core.radio_button15978.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button15978.call(null,group,null);
});

sablono.core.radio_button15978.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button15978.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button15978.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button15978.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button15978);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options15986 = (function sablono$core$select_options15986(var_args){
var args15987 = [];
var len__7484__auto___16006 = arguments.length;
var i__7485__auto___16007 = (0);
while(true){
if((i__7485__auto___16007 < len__7484__auto___16006)){
args15987.push((arguments[i__7485__auto___16007]));

var G__16008 = (i__7485__auto___16007 + (1));
i__7485__auto___16007 = G__16008;
continue;
} else {
}
break;
}

var G__15989 = args15987.length;
switch (G__15989) {
case 1:
return sablono.core.select_options15986.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options15986.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15987.length)].join('')));

}
});

sablono.core.select_options15986.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options15986.call(null,coll,null);
});

sablono.core.select_options15986.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__15990(s__15991){
return (new cljs.core.LazySeq(null,(function (){
var s__15991__$1 = s__15991;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__15991__$1);
if(temp__4657__auto__){
var s__15991__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15991__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__15991__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__15993 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__15992 = (0);
while(true){
if((i__15992 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__15992);
cljs.core.chunk_append.call(null,b__15993,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__16000 = x;
var text = cljs.core.nth.call(null,vec__16000,(0),null);
var val = cljs.core.nth.call(null,vec__16000,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__16000,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options15986.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__16010 = (i__15992 + (1));
i__15992 = G__16010;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15993),sablono$core$iter__15990.call(null,cljs.core.chunk_rest.call(null,s__15991__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15993),null);
}
} else {
var x = cljs.core.first.call(null,s__15991__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__16003 = x;
var text = cljs.core.nth.call(null,vec__16003,(0),null);
var val = cljs.core.nth.call(null,vec__16003,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__16003,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options15986.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__15990.call(null,cljs.core.rest.call(null,s__15991__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
});

sablono.core.select_options15986.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options15986);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down16011 = (function sablono$core$drop_down16011(var_args){
var args16012 = [];
var len__7484__auto___16015 = arguments.length;
var i__7485__auto___16016 = (0);
while(true){
if((i__7485__auto___16016 < len__7484__auto___16015)){
args16012.push((arguments[i__7485__auto___16016]));

var G__16017 = (i__7485__auto___16016 + (1));
i__7485__auto___16016 = G__16017;
continue;
} else {
}
break;
}

var G__16014 = args16012.length;
switch (G__16014) {
case 2:
return sablono.core.drop_down16011.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down16011.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16012.length)].join('')));

}
});

sablono.core.drop_down16011.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down16011.call(null,name,options,null);
});

sablono.core.drop_down16011.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down16011.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down16011);
/**
 * Creates a text area element.
 */
sablono.core.text_area16019 = (function sablono$core$text_area16019(var_args){
var args16020 = [];
var len__7484__auto___16023 = arguments.length;
var i__7485__auto___16024 = (0);
while(true){
if((i__7485__auto___16024 < len__7484__auto___16023)){
args16020.push((arguments[i__7485__auto___16024]));

var G__16025 = (i__7485__auto___16024 + (1));
i__7485__auto___16024 = G__16025;
continue;
} else {
}
break;
}

var G__16022 = args16020.length;
switch (G__16022) {
case 1:
return sablono.core.text_area16019.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area16019.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16020.length)].join('')));

}
});

sablono.core.text_area16019.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area16019.call(null,name,null);
});

sablono.core.text_area16019.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area16019.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area16019);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label16027 = (function sablono$core$label16027(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label16027);
/**
 * Creates a submit button.
 */
sablono.core.submit_button16028 = (function sablono$core$submit_button16028(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button16028);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button16029 = (function sablono$core$reset_button16029(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button16029);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to16030 = (function sablono$core$form_to16030(var_args){
var args__7491__auto__ = [];
var len__7484__auto___16037 = arguments.length;
var i__7485__auto___16038 = (0);
while(true){
if((i__7485__auto___16038 < len__7484__auto___16037)){
args__7491__auto__.push((arguments[i__7485__auto___16038]));

var G__16039 = (i__7485__auto___16038 + (1));
i__7485__auto___16038 = G__16039;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to16030.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to16030.cljs$core$IFn$_invoke$arity$variadic = (function (p__16033,body){
var vec__16034 = p__16033;
var method = cljs.core.nth.call(null,vec__16034,(0),null);
var action = cljs.core.nth.call(null,vec__16034,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to16030.cljs$lang$maxFixedArity = (1);

sablono.core.form_to16030.cljs$lang$applyTo = (function (seq16031){
var G__16032 = cljs.core.first.call(null,seq16031);
var seq16031__$1 = cljs.core.next.call(null,seq16031);
return sablono.core.form_to16030.cljs$core$IFn$_invoke$arity$variadic(G__16032,seq16031__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to16030);
