// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('c2.layout.histogram');
goog.require('cljs.core');
goog.require('c2.maths');
c2.layout.histogram.binary_search = (function c2$layout$histogram$binary_search(v,target){

var low = (0);
var high = (cljs.core.count(v) - (1));
while(true){
if((low > high)){
return (- (low + (1)));
} else {
var mid = cljs.core.quot((low + high),(2));
var mid_val = (v.cljs$core$IFn$_invoke$arity$1 ? v.cljs$core$IFn$_invoke$arity$1(mid) : v.call(null,mid));
if((mid_val < target)){
var G__34290 = (mid + (1));
var G__34291 = high;
low = G__34290;
high = G__34291;
continue;
} else {
if((target < mid_val)){
var G__34292 = low;
var G__34293 = (mid - (1));
low = G__34292;
high = G__34293;
continue;
} else {
return mid;

}
}
}
break;
}
});
/**
 * Calulate reasonable number of bins assuming an approximately normal
 *   distribution
 */
c2.layout.histogram.sturges = (function c2$layout$histogram$sturges(values){
return ((c2.maths.log.cljs$core$IFn$_invoke$arity$2(cljs.core.count(values),(2)) | (0)) + (1));
});
/**
 * Return the inclusive upper threshold of all bins
 */
c2.layout.histogram.fixed_size_bins = (function c2$layout$histogram$fixed_size_bins(p__34294,n){
var vec__34304 = p__34294;
var mn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34304,(0),null);
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34304,(1),null);
var size = ((mx - mn) / n);
return cljs.core.vec((function (){var iter__7189__auto__ = ((function (size,vec__34304,mn,mx){
return (function c2$layout$histogram$fixed_size_bins_$_iter__34307(s__34308){
return (new cljs.core.LazySeq(null,((function (size,vec__34304,mn,mx){
return (function (){
var s__34308__$1 = s__34308;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34308__$1);
if(temp__4657__auto__){
var s__34308__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34308__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__34308__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__34310 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__34309 = (0);
while(true){
if((i__34309 < size__7188__auto__)){
var step = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__34309);
cljs.core.chunk_append(b__34310,(mn + (size * step)));

var G__34313 = (i__34309 + (1));
i__34309 = G__34313;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34310),c2$layout$histogram$fixed_size_bins_$_iter__34307(cljs.core.chunk_rest(s__34308__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34310),null);
}
} else {
var step = cljs.core.first(s__34308__$2);
return cljs.core.cons((mn + (size * step)),c2$layout$histogram$fixed_size_bins_$_iter__34307(cljs.core.rest(s__34308__$2)));
}
} else {
return null;
}
break;
}
});})(size,vec__34304,mn,mx))
,null,null));
});})(size,vec__34304,mn,mx))
;
return iter__7189__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1((n + (1))));
})());
});
/**
 * The histogram layout transforms data by grouping descrete data points into
 *   bins. Returns a collection of values with the following metadata set:
 * 
 *   > *:x* the lower bound of the bin (inclusive).
 * 
 *   > *:dx* the width of the bin; x + dx is the upper bound (exclusive).
 * 
 *   > *:y* the count
 * 
 * Kwargs:
 * 
 * > *:value* fn that calculates value of node, defaults to `:value`
 * 
 * > *:index* opaque value passed to `:bins` and `:range`
 * 
 * > *:range* fn which calculates the minimum and maximum values given the array of values
 * 
 * > *:bins* Number of bins /or/ fn that takes the range, array of values, and current index
 */
c2.layout.histogram.histogram = (function c2$layout$histogram$histogram(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34324 = arguments.length;
var i__7485__auto___34325 = (0);
while(true){
if((i__7485__auto___34325 < len__7484__auto___34324)){
args__7491__auto__.push((arguments[i__7485__auto___34325]));

var G__34326 = (i__7485__auto___34325 + (1));
i__7485__auto___34325 = G__34326;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__34316){
var map__34317 = p__34316;
var map__34317__$1 = ((((!((map__34317 == null)))?((((map__34317.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34317.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34317):map__34317);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34317__$1,cljs.core.cst$kw$value,cljs.core.cst$kw$value);
var index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34317__$1,cljs.core.cst$kw$index);
var range = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34317__$1,cljs.core.cst$kw$range,((function (map__34317,map__34317__$1,value,index){
return (function (xs,_){
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce,cljs.core.min),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce,cljs.core.max)).call(null,xs);
});})(map__34317,map__34317__$1,value,index))
);
var bins = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34317__$1,cljs.core.cst$kw$bins,((function (map__34317,map__34317__$1,value,index,range){
return (function (r,xs,_){
return c2.layout.histogram.fixed_size_bins(r,c2.layout.histogram.sturges(xs));
});})(map__34317,map__34317__$1,value,index,range))
);
var values = cljs.core.map.cljs$core$IFn$_invoke$arity$2(value,data);
var r = ((cljs.core.fn_QMARK_(range))?(range.cljs$core$IFn$_invoke$arity$2 ? range.cljs$core$IFn$_invoke$arity$2(values,index) : range.call(null,values,index)):range
);
var thresholds = ((cljs.core.fn_QMARK_(bins))?(bins.cljs$core$IFn$_invoke$arity$3 ? bins.cljs$core$IFn$_invoke$arity$3(r,values,index) : bins.call(null,r,values,index)):((typeof bins === 'number')?c2.layout.histogram.fixed_size_bins(r,bins):bins
));
var binner = ((function (values,r,thresholds,map__34317,map__34317__$1,value,index,range,bins){
return (function (e){
return ((function (){var G__34319 = (c2.layout.histogram.binary_search(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(thresholds,(0),(cljs.core.count(thresholds) - (1))),(value.cljs$core$IFn$_invoke$arity$1 ? value.cljs$core$IFn$_invoke$arity$1(e) : value.call(null,e))) + (1));
return Math.abs(G__34319);
})() - (1));
});})(values,r,thresholds,map__34317,map__34317__$1,value,index,range,bins))
;
var groups = cljs.core.group_by(binner,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (values,r,thresholds,binner,map__34317,map__34317__$1,value,index,range,bins){
return (function (p1__109951_SHARP_){
return (((value.cljs$core$IFn$_invoke$arity$1 ? value.cljs$core$IFn$_invoke$arity$1(p1__109951_SHARP_) : value.call(null,p1__109951_SHARP_)) >= (r.cljs$core$IFn$_invoke$arity$1 ? r.cljs$core$IFn$_invoke$arity$1((0)) : r.call(null,(0))))) && (((value.cljs$core$IFn$_invoke$arity$1 ? value.cljs$core$IFn$_invoke$arity$1(p1__109951_SHARP_) : value.call(null,p1__109951_SHARP_)) <= (r.cljs$core$IFn$_invoke$arity$1 ? r.cljs$core$IFn$_invoke$arity$1((1)) : r.call(null,(1)))));
});})(values,r,thresholds,binner,map__34317,map__34317__$1,value,index,range,bins))
,data));
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (values,r,thresholds,binner,groups,map__34317,map__34317__$1,value,index,range,bins){
return (function (index__$1,p__34320){
var vec__34321 = p__34320;
var mn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34321,(0),null);
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34321,(1),null);
var group = (function (){var or__6409__auto__ = (groups.cljs$core$IFn$_invoke$arity$1 ? groups.cljs$core$IFn$_invoke$arity$1(index__$1) : groups.call(null,index__$1));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
return cljs.core.with_meta(group,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,mn,cljs.core.cst$kw$dx,(mx - mn),cljs.core.cst$kw$y,cljs.core.count(group)], null));
});})(values,r,thresholds,binner,groups,map__34317,map__34317__$1,value,index,range,bins))
,cljs.core.partition.cljs$core$IFn$_invoke$arity$3((2),(1),thresholds));
});

c2.layout.histogram.histogram.cljs$lang$maxFixedArity = (1);

c2.layout.histogram.histogram.cljs$lang$applyTo = (function (seq34314){
var G__34315 = cljs.core.first(seq34314);
var seq34314__$1 = cljs.core.next(seq34314);
return c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic(G__34315,seq34314__$1);
});

