// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.shared');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('cljs.core.async');
goog.require('sablono.core');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('hatti.utils.om.state');
goog.require('chimera.urls');
hatti.shared.event_chan = cljs.core.async.chan.call(null);
hatti.shared.event_multi_chan = cljs.core.async.mult.call(null,hatti.shared.event_chan);
hatti.shared.event_tap = (function hatti$shared$event_tap(){
return cljs.core.async.tap.call(null,hatti.shared.event_multi_chan,cljs.core.async.chan.call(null));
});
hatti.shared.external_event_chan = cljs.core.async.chan.call(null);
hatti.shared.external_event_multi_chan = cljs.core.async.mult.call(null,hatti.shared.external_event_chan);
hatti.shared.external_event_tap = (function hatti$shared$external_event_tap(){
return cljs.core.async.tap.call(null,hatti.shared.external_event_multi_chan,cljs.core.async.chan.call(null));
});
hatti.shared.default_fields = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),"_submission_time",new cljs.core.Keyword(null,"label","label",1718410804),"Submission Time",new cljs.core.Keyword(null,"name","name",1843675177),"_submission_time",new cljs.core.Keyword(null,"type","type",1174270348),"datetime"], null)], null);
/**
 * An initial, empty, app-state, which can be modified to change dataviews.
 */
hatti.shared.empty_app_state = (function hatti$shared$empty_app_state(){
return cljs.core.atom.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"api-url","api-url",2037917643),new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),new cljs.core.Keyword(null,"chart-page","chart-page",14505465),new cljs.core.Keyword(null,"languages","languages",1471910331),new cljs.core.Keyword(null,"map-page","map-page",108547100),new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"data","data",-232669377)],["//api.ona.io/api/v1/",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),null], null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"total-records","total-records",-1940276645),(0),new cljs.core.Keyword(null,"loading?","loading?",1905707049),true], null),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"visible-charts","visible-charts",-1864927735),hatti.shared.default_fields,new cljs.core.Keyword(null,"chart-data","chart-data",-1181877206),cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"current","current",-1088038603),null,new cljs.core.Keyword(null,"all","all",892129742),cljs.core.PersistentVector.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),null], null),new cljs.core.Keyword(null,"geofield","geofield",578715548),cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"overview","overview",-435037267),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.Keyword(null,"chart","chart",1173225425),new cljs.core.Keyword(null,"saved-charts","saved-charts",2129251691),new cljs.core.Keyword(null,"settings","settings",1556144875)], null),new cljs.core.Keyword(null,"selected","selected",574897764),new cljs.core.Keyword(null,"overview","overview",-435037267),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form-info","form-info",-1650433345),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"basemaps","basemaps",-586181391),new cljs.core.Keyword(null,"integrated-apps","integrated-apps",2094952610),new cljs.core.Keyword(null,"media-files","media-files",-1143893877),new cljs.core.Keyword(null,"xls-reports","xls-reports",-1859694902),new cljs.core.Keyword(null,"service-configuration","service-configuration",-820372483)], null),new cljs.core.Keyword(null,"active-tab","active-tab",1102432568),new cljs.core.Keyword(null,"form-info","form-info",-1650433345),new cljs.core.Keyword(null,"integrated-apps","integrated-apps",2094952610),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"active-section","active-section",1090779410),new cljs.core.Keyword(null,"apps-list","apps-list",590176593),new cljs.core.Keyword(null,"add?","add?",1263018409),false], null)], null)], null),cljs.core.PersistentVector.EMPTY]));
});
hatti.shared.app_state = hatti.shared.empty_app_state.call(null);
/**
 * Given a function over data, run a transact on data inside app-state.
 */
hatti.shared.transact_app_data_BANG_ = (function hatti$shared$transact_app_data_BANG_(app_state,transact_fn){
return chimera.om.state.transact_BANG_.call(null,app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null),transact_fn);
});
/**
 * Given `data` received from the server, update the app-state.
 * Sorts by submission time, and adds rank to the data, for table + map views.
 */
hatti.shared.update_app_data_BANG_ = (function hatti$shared$update_app_data_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18090 = arguments.length;
var i__7485__auto___18091 = (0);
while(true){
if((i__7485__auto___18091 < len__7484__auto___18090)){
args__7491__auto__.push((arguments[i__7485__auto___18091]));

var G__18092 = (i__7485__auto___18091 + (1));
i__7485__auto___18091 = G__18092;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__18087){
var map__18088 = p__18087;
var map__18088__$1 = ((((!((map__18088 == null)))?((((map__18088.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18088.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18088):map__18088);
var rerank_QMARK_ = cljs.core.get.call(null,map__18088__$1,new cljs.core.Keyword(null,"rerank?","rerank?",-177233089));
var completed_QMARK_ = cljs.core.get.call(null,map__18088__$1,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var sort_field = cljs.core.get.call(null,map__18088__$1,new cljs.core.Keyword(null,"sort-field","sort-field",-941433793));
var current_start_index = cljs.core.get.call(null,map__18088__$1,new cljs.core.Keyword(null,"current-start-index","current-start-index",-285076643),(0));
var add_rank = ((function (map__18088,map__18088__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (i,v){
return cljs.core.assoc.call(null,v,hatti.constants._rank,(current_start_index + (i + (1))));
});})(map__18088,map__18088__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
;
var data__$1 = (cljs.core.truth_((function (){var and__6397__auto__ = rerank_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.seq.call(null,data);
} else {
return and__6397__auto__;
}
})())?cljs.core.vec.call(null,cljs.core.map_indexed.call(null,add_rank,cljs.core.sort_by.call(null,((function (add_rank,map__18088,map__18088__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (p1__18083_SHARP_){
return cljs.core.get.call(null,p1__18083_SHARP_,(function (){var or__6409__auto__ = sort_field;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants._submission_time;
}
})());
});})(add_rank,map__18088,map__18088__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
,data))):cljs.core.vec.call(null,cljs.core.map_indexed.call(null,add_rank,data)));
var total_records = cljs.core.count.call(null,data__$1);
hatti.shared.transact_app_data_BANG_.call(null,app_state,((function (add_rank,data__$1,total_records,map__18088,map__18088__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (_){
return data__$1;
});})(add_rank,data__$1,total_records,map__18088,map__18088__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
);

return chimera.om.state.merge_into_app_state_BANG_.call(null,app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"status","status",-1997798413)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"total-records","total-records",-1940276645),total_records,new cljs.core.Keyword(null,"loading?","loading?",1905707049),cljs.core.not.call(null,completed_QMARK_)], null));
});

hatti.shared.update_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.update_app_data_BANG_.cljs$lang$applyTo = (function (seq18084){
var G__18085 = cljs.core.first.call(null,seq18084);
var seq18084__$1 = cljs.core.next.call(null,seq18084);
var G__18086 = cljs.core.first.call(null,seq18084__$1);
var seq18084__$2 = cljs.core.next.call(null,seq18084__$1);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18085,G__18086,seq18084__$2);
});

/**
 * Add to app data.
 */
hatti.shared.add_to_app_data_BANG_ = (function hatti$shared$add_to_app_data_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18099 = arguments.length;
var i__7485__auto___18100 = (0);
while(true){
if((i__7485__auto___18100 < len__7484__auto___18099)){
args__7491__auto__.push((arguments[i__7485__auto___18100]));

var G__18101 = (i__7485__auto___18100 + (1));
i__7485__auto___18100 = G__18101;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__18096){
var map__18097 = p__18096;
var map__18097__$1 = ((((!((map__18097 == null)))?((((map__18097.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18097.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18097):map__18097);
var completed_QMARK_ = cljs.core.get.call(null,map__18097__$1,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var old_data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,app_state));
hatti.shared.update_app_data_BANG_.call(null,app_state,cljs.core.concat.call(null,old_data,data),new cljs.core.Keyword(null,"rerank?","rerank?",-177233089),completed_QMARK_);

return hatti.utils.om.state.update_app_state_BANG_.call(null,app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"loading?","loading?",1905707049)], null),cljs.core.not.call(null,completed_QMARK_));
});

hatti.shared.add_to_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.add_to_app_data_BANG_.cljs$lang$applyTo = (function (seq18093){
var G__18094 = cljs.core.first.call(null,seq18093);
var seq18093__$1 = cljs.core.next.call(null,seq18093);
var G__18095 = cljs.core.first.call(null,seq18093__$1);
var seq18093__$2 = cljs.core.next.call(null,seq18093__$1);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18094,G__18095,seq18093__$2);
});

hatti.shared.language_cursor = (function hatti$shared$language_cursor(){
return om.core.ref_cursor.call(null,new cljs.core.Keyword(null,"languages","languages",1471910331).cljs$core$IFn$_invoke$arity$1(om.core.root_cursor.call(null,hatti.shared.app_state)));
});
/**
 * A language selector and a following divider.
 */
hatti.shared.language_selector = (function hatti$shared$language_selector(_,owner){
if(typeof hatti.shared.t_hatti$shared18119 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.shared.t_hatti$shared18119 = (function (language_selector,_,owner,meta18120){
this.language_selector = language_selector;
this._ = _;
this.owner = owner;
this.meta18120 = meta18120;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.shared.t_hatti$shared18119.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18121,meta18120__$1){
var self__ = this;
var _18121__$1 = this;
return (new hatti.shared.t_hatti$shared18119(self__.language_selector,self__._,self__.owner,meta18120__$1));
});

hatti.shared.t_hatti$shared18119.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18121){
var self__ = this;
var _18121__$1 = this;
return self__.meta18120;
});

hatti.shared.t_hatti$shared18119.prototype.om$core$IRender$ = true;

hatti.shared.t_hatti$shared18119.prototype.om$core$IRender$render$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var map__18122 = om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null));
var map__18122__$1 = ((((!((map__18122 == null)))?((((map__18122.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18122.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18122):map__18122);
var ls = map__18122__$1;
var current = cljs.core.get.call(null,map__18122__$1,new cljs.core.Keyword(null,"current","current",-1088038603));
var all = cljs.core.get.call(null,map__18122__$1,new cljs.core.Keyword(null,"all","all",892129742));
var get_update_handler = ((function (map__18122,map__18122__$1,ls,current,all,___$2){
return (function (language){
return ((function (map__18122,map__18122__$1,ls,current,all,___$2){
return (function (event){
om.core.update_BANG_.call(null,ls,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current","current",-1088038603)], null),language);

return event.preventDefault();
});
;})(map__18122,map__18122__$1,ls,current,all,___$2))
});})(map__18122,map__18122__$1,ls,current,all,___$2))
;
var stringify = ((function (map__18122,map__18122__$1,ls,current,all,get_update_handler,___$2){
return (function (p1__18102_SHARP_){
if((p1__18102_SHARP_ instanceof cljs.core.Keyword)){
return cljs.core.name.call(null,p1__18102_SHARP_);
} else {
return [cljs.core.str(p1__18102_SHARP_)].join('');
}
});})(map__18122,map__18122__$1,ls,current,all,get_update_handler,___$2))
;
return React.DOM.div(({"className": "language-selector-inner"}),React.DOM.span(({"className": "dropdown drop-hover"}),React.DOM.i(({"style": ({"marginRight": ".2em"}), "className": "fa fa-globe"})),(function (){var attrs18126 = (cljs.core.truth_(hatti.ona.forms.english_QMARK_.call(null,current))?"EN":stringify.call(null,current));
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs18126))?sablono.interpreter.attributes.call(null,attrs18126):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs18126))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs18126)], null))));
})(),React.DOM.i(({"style": ({"marginLeft": ".5em"}), "className": "fa fa-angle-down"})),React.DOM.ul(({"className": "submenu"}),cljs.core.into_array.call(null,(function (){var iter__7189__auto__ = ((function (map__18122,map__18122__$1,ls,current,all,get_update_handler,stringify,___$2){
return (function hatti$shared$language_selector_$_iter__18131(s__18132){
return (new cljs.core.LazySeq(null,((function (map__18122,map__18122__$1,ls,current,all,get_update_handler,stringify,___$2){
return (function (){
var s__18132__$1 = s__18132;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__18132__$1);
if(temp__4657__auto__){
var s__18132__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__18132__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__18132__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__18134 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__18133 = (0);
while(true){
if((i__18133 < size__7188__auto__)){
var language = cljs.core._nth.call(null,c__7187__auto__,i__18133);
cljs.core.chunk_append.call(null,b__18134,React.DOM.li(null,React.DOM.a(({"href": "#", "onClick": get_update_handler.call(null,language)}),sablono.interpreter.interpret.call(null,stringify.call(null,language)))));

var G__18135 = (i__18133 + (1));
i__18133 = G__18135;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18134),hatti$shared$language_selector_$_iter__18131.call(null,cljs.core.chunk_rest.call(null,s__18132__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18134),null);
}
} else {
var language = cljs.core.first.call(null,s__18132__$2);
return cljs.core.cons.call(null,React.DOM.li(null,React.DOM.a(({"href": "#", "onClick": get_update_handler.call(null,language)}),sablono.interpreter.interpret.call(null,stringify.call(null,language)))),hatti$shared$language_selector_$_iter__18131.call(null,cljs.core.rest.call(null,s__18132__$2)));
}
} else {
return null;
}
break;
}
});})(map__18122,map__18122__$1,ls,current,all,get_update_handler,stringify,___$2))
,null,null));
});})(map__18122,map__18122__$1,ls,current,all,get_update_handler,stringify,___$2))
;
return iter__7189__auto__.call(null,all);
})()))),React.DOM.div(({"className": "divider"})));
});

hatti.shared.t_hatti$shared18119.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"language-selector","language-selector",-1895427281,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"A language selector and a following divider."], null)),new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta18120","meta18120",1814073951,null)], null);
});

hatti.shared.t_hatti$shared18119.cljs$lang$type = true;

hatti.shared.t_hatti$shared18119.cljs$lang$ctorStr = "hatti.shared/t_hatti$shared18119";

hatti.shared.t_hatti$shared18119.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.shared/t_hatti$shared18119");
});

hatti.shared.__GT_t_hatti$shared18119 = (function hatti$shared$language_selector_$___GT_t_hatti$shared18119(language_selector__$1,___$1,owner__$1,meta18120){
return (new hatti.shared.t_hatti$shared18119(language_selector__$1,___$1,owner__$1,meta18120));
});

}

return (new hatti.shared.t_hatti$shared18119(hatti$shared$language_selector,_,owner,cljs.core.PersistentArrayMap.EMPTY));
});
