// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('clojure.string');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('cljs.reader');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"radius": (6), "fillColor": "#f30", "reset": ({"fillColor": "#f30"}), "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9}),cljs.core.cst$kw$hover,({"fillColor": "#631400"}),cljs.core.cst$kw$clicked,({"fillColor": "#ad2300"})], null),cljs.core.cst$kw$shape,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8}),cljs.core.cst$kw$hover,({"fillColor": "#631400", "color": "#222"}),cljs.core.cst$kw$clicked,({"fillColor": "#ad2300", "color": "#222"})], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"color": "#f30", "opacity": (1), "weight": (6), "reset": ({"color": "#f30"})}),cljs.core.cst$kw$hover,({"color": "#631400"}),cljs.core.cst$kw$clicked,({"color": "#ad2300"})], null)], null);
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(marker_or_keyword,style_type){
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype(marker_or_keyword));
var G__33910 = (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.ona_styles) : kw.call(null,hatti.map.utils.ona_styles));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__33910) : style_type.call(null,G__33910));
});
hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(s);
var tc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(t);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.select_keys(sc,cljs.core.keys(tc)),cljs.core.select_keys(tc,cljs.core.keys(sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args33911 = [];
var len__7484__auto___33915 = arguments.length;
var i__7485__auto___33916 = (0);
while(true){
if((i__7485__auto___33916 < len__7484__auto___33915)){
args33911.push((arguments[i__7485__auto___33916]));

var G__33917 = (i__7485__auto___33916 + (1));
i__7485__auto___33916 = G__33917;
continue;
} else {
}
break;
}

var G__33913 = args33911.length;
switch (G__33913) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33911.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
var G__33914 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker));
return (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(G__33914) : kw.call(null,G__33914));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;

/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker),hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = (marker__GT_style.cljs$core$IFn$_invoke$arity$1 ? marker__GT_style.cljs$core$IFn$_invoke$arity$1(marker) : marker__GT_style.call(null,marker));
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return marker.setStyle(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$reset,style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(style,cljs.core.cst$kw$reset,style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4655__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4655__auto__)){
var rstyle = temp__4655__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.map.utils.is_clicked_QMARK_(marker);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var G__33920 = hatti.map.utils.get_id(marker);
return (id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__33920) : id_selected_QMARK_.call(null,G__33920));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style(marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$hover));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33930 = arguments.length;
var i__7485__auto___33931 = (0);
while(true){
if((i__7485__auto___33931 < len__7484__auto___33930)){
args__7491__auto__.push((arguments[i__7485__auto___33931]));

var G__33932 = (i__7485__auto___33931 + (1));
i__7485__auto___33931 = G__33932;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__33923){
var map__33924 = p__33923;
var map__33924__$1 = ((((!((map__33924 == null)))?((((map__33924.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33924.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33924):map__33924);
var preserve_clicked_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33924__$1,cljs.core.cst$kw$preserve_DASH_clicked_QMARK_,true);
var seq__33926 = cljs.core.seq(markers);
var chunk__33927 = null;
var count__33928 = (0);
var i__33929 = (0);
while(true){
if((i__33929 < count__33928)){
var marker = chunk__33927.cljs$core$IIndexed$_nth$arity$2(null,i__33929);
if(cljs.core.not((function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__33933 = seq__33926;
var G__33934 = chunk__33927;
var G__33935 = count__33928;
var G__33936 = (i__33929 + (1));
seq__33926 = G__33933;
chunk__33927 = G__33934;
count__33928 = G__33935;
i__33929 = G__33936;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__33926);
if(temp__4657__auto__){
var seq__33926__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33926__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__33926__$1);
var G__33937 = cljs.core.chunk_rest(seq__33926__$1);
var G__33938 = c__7220__auto__;
var G__33939 = cljs.core.count(c__7220__auto__);
var G__33940 = (0);
seq__33926 = G__33937;
chunk__33927 = G__33938;
count__33928 = G__33939;
i__33929 = G__33940;
continue;
} else {
var marker = cljs.core.first(seq__33926__$1);
if(cljs.core.not((function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__33941 = cljs.core.next(seq__33926__$1);
var G__33942 = null;
var G__33943 = (0);
var G__33944 = (0);
seq__33926 = G__33941;
chunk__33927 = G__33942;
count__33928 = G__33943;
i__33929 = G__33944;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq33921){
var G__33922 = cljs.core.first(seq33921);
var seq33921__$1 = cljs.core.next(seq33921);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__33922,seq33921__$1);
});

hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string(maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"Feature",cljs.core.cst$kw$properties,cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._rank),(index + (1)),cljs.core.cst$kw$id,record_id,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id),record_id], true, false),cljs.core.cst$kw$geometry,geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__7334__auto__ = (function (){var G__33945 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33945) : cljs.core.atom.call(null,G__33945));
})();
var prefer_table__7335__auto__ = (function (){var G__33946 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33946) : cljs.core.atom.call(null,G__33946));
})();
var method_cache__7336__auto__ = (function (){var G__33947 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33947) : cljs.core.atom.call(null,G__33947));
})();
var cached_hierarchy__7337__auto__ = (function (){var G__33948 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33948) : cljs.core.atom.call(null,G__33948));
})();
var hierarchy__7338__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("hatti.map.utils","get-as-geom"),((function (method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__){
return (function() { 
var G__33953__delegate = function (record,field,p__33949){
var vec__33950 = p__33949;
var repeat_child_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33950,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return cljs.core.cst$kw$repeat;
} else {
return cljs.core.cst$kw$default;

}
};
var G__33953 = function (record,field,var_args){
var p__33949 = null;
if (arguments.length > 2) {
var G__33954__i = 0, G__33954__a = new Array(arguments.length -  2);
while (G__33954__i < G__33954__a.length) {G__33954__a[G__33954__i] = arguments[G__33954__i + 2]; ++G__33954__i;}
  p__33949 = new cljs.core.IndexedSeq(G__33954__a,0);
} 
return G__33953__delegate.call(this,record,field,p__33949);};
G__33953.cljs$lang$maxFixedArity = 2;
G__33953.cljs$lang$applyTo = (function (arglist__33955){
var record = cljs.core.first(arglist__33955);
arglist__33955 = cljs.core.next(arglist__33955);
var field = cljs.core.first(arglist__33955);
var p__33949 = cljs.core.rest(arglist__33955);
return G__33953__delegate(record,field,p__33949);
});
G__33953.cljs$core$IFn$_invoke$arity$variadic = G__33953__delegate;
return G__33953;
})()
;})(method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__))
,cljs.core.cst$kw$default,hierarchy__7338__auto__,method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__));
})();
}
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$repeat,(function (record,p__33956){
var map__33957 = p__33956;
var map__33957__$1 = ((((!((map__33957 == null)))?((((map__33957.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33957.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33957):map__33957);
var field = map__33957__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33957__$1,cljs.core.cst$kw$children);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33957__$1,cljs.core.cst$kw$full_DASH_name);
var iter__7189__auto__ = ((function (map__33957,map__33957__$1,field,children,full_name){
return (function hatti$map$utils$iter__33959(s__33960){
return (new cljs.core.LazySeq(null,((function (map__33957,map__33957__$1,field,children,full_name){
return (function (){
var s__33960__$1 = s__33960;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33960__$1);
if(temp__4657__auto__){
var s__33960__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33960__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33960__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33962 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33961 = (0);
while(true){
if((i__33961 < size__7188__auto__)){
var child_record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33961);
cljs.core.chunk_append(b__33962,(function (){var iter__7189__auto__ = ((function (i__33961,child_record,c__7187__auto__,size__7188__auto__,b__33962,s__33960__$2,temp__4657__auto__,map__33957,map__33957__$1,field,children,full_name){
return (function hatti$map$utils$iter__33959_$_iter__33977(s__33978){
return (new cljs.core.LazySeq(null,((function (i__33961,child_record,c__7187__auto__,size__7188__auto__,b__33962,s__33960__$2,temp__4657__auto__,map__33957,map__33957__$1,field,children,full_name){
return (function (){
var s__33978__$1 = s__33978;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__33978__$1);
if(temp__4657__auto____$1){
var s__33978__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__33978__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first(s__33978__$2);
var size__7188__auto____$1 = cljs.core.count(c__7187__auto____$1);
var b__33980 = cljs.core.chunk_buffer(size__7188__auto____$1);
if((function (){var i__33979 = (0);
while(true){
if((i__33979 < size__7188__auto____$1)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto____$1,i__33979);
cljs.core.chunk_append(b__33980,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__33989 = (i__33979 + (1));
i__33979 = G__33989;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33980),hatti$map$utils$iter__33959_$_iter__33977(cljs.core.chunk_rest(s__33978__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33980),null);
}
} else {
var child = cljs.core.first(s__33978__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__33959_$_iter__33977(cljs.core.rest(s__33978__$2)));
}
} else {
return null;
}
break;
}
});})(i__33961,child_record,c__7187__auto__,size__7188__auto__,b__33962,s__33960__$2,temp__4657__auto__,map__33957,map__33957__$1,field,children,full_name))
,null,null));
});})(i__33961,child_record,c__7187__auto__,size__7188__auto__,b__33962,s__33960__$2,temp__4657__auto__,map__33957,map__33957__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})());

var G__33990 = (i__33961 + (1));
i__33961 = G__33990;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33962),hatti$map$utils$iter__33959(cljs.core.chunk_rest(s__33960__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33962),null);
}
} else {
var child_record = cljs.core.first(s__33960__$2);
return cljs.core.cons((function (){var iter__7189__auto__ = ((function (child_record,s__33960__$2,temp__4657__auto__,map__33957,map__33957__$1,field,children,full_name){
return (function hatti$map$utils$iter__33959_$_iter__33983(s__33984){
return (new cljs.core.LazySeq(null,((function (child_record,s__33960__$2,temp__4657__auto__,map__33957,map__33957__$1,field,children,full_name){
return (function (){
var s__33984__$1 = s__33984;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__33984__$1);
if(temp__4657__auto____$1){
var s__33984__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__33984__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33984__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33986 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33985 = (0);
while(true){
if((i__33985 < size__7188__auto__)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33985);
cljs.core.chunk_append(b__33986,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__33991 = (i__33985 + (1));
i__33985 = G__33991;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33986),hatti$map$utils$iter__33959_$_iter__33983(cljs.core.chunk_rest(s__33984__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33986),null);
}
} else {
var child = cljs.core.first(s__33984__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__33959_$_iter__33983(cljs.core.rest(s__33984__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__33960__$2,temp__4657__auto__,map__33957,map__33957__$1,field,children,full_name))
,null,null));
});})(child_record,s__33960__$2,temp__4657__auto__,map__33957,map__33957__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__33959(cljs.core.rest(s__33960__$2)));
}
} else {
return null;
}
break;
}
});})(map__33957,map__33957__$1,field,children,full_name))
,null,null));
});})(map__33957,map__33957__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,full_name));
}));
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq(s)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(s,"n/a"))){
var iter__7189__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__33994(s__33995){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__33995__$1 = s__33995;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33995__$1);
if(temp__4657__auto__){
var s__33995__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33995__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33995__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33997 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33996 = (0);
while(true){
if((i__33996 < size__7188__auto__)){
var coord_string = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33996);
cljs.core.chunk_append(b__33997,(function (){var vec__34006 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34006,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34006,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34006,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34006,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})());

var G__34013 = (i__33996 + (1));
i__33996 = G__34013;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33997),hatti$map$utils$iter__33994(cljs.core.chunk_rest(s__33995__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33997),null);
}
} else {
var coord_string = cljs.core.first(s__33995__$2);
return cljs.core.cons((function (){var vec__34009 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34009,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34009,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34009,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34009,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})(),hatti$map$utils$iter__33994(cljs.core.rest(s__33995__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__7189__auto__(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__34012 = geotype;
switch (G__34012) {
case "Point":
return ((function (G__34012,geotype,parse){
return (function (p1__33992_SHARP_){
return cljs.core.first(parse(p1__33992_SHARP_));
});
;})(G__34012,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__34012,geotype,parse){
return (function (p1__33993_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse(p1__33993_SHARP_)],null));
});
;})(G__34012,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield));
var coords = (coordfn.cljs$core$IFn$_invoke$arity$1 ? coordfn.cljs$core$IFn$_invoke$arity$1(value) : coordfn.call(null,value));
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(geofield))){
return cljs.core.cst$kw$geom.cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = (coords == null);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return cljs.core.some(cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,geotype,cljs.core.cst$kw$coordinates,coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args34016 = [];
var len__7484__auto___34037 = arguments.length;
var i__7485__auto___34038 = (0);
while(true){
if((i__7485__auto___34038 < len__7484__auto___34037)){
args34016.push((arguments[i__7485__auto___34038]));

var G__34039 = (i__7485__auto___34038 + (1));
i__7485__auto___34038 = G__34039;
continue;
} else {
}
break;
}

var G__34018 = args34016.length;
switch (G__34018) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34016.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3(dataset,form,hatti.ona.forms.default_geofield(form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__7189__auto__ = (function hatti$map$utils$iter__34019(s__34020){
return (new cljs.core.LazySeq(null,(function (){
var s__34020__$1 = s__34020;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34020__$1);
if(temp__4657__auto__){
var s__34020__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34020__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__34020__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__34022 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__34021 = (0);
while(true){
if((i__34021 < size__7188__auto__)){
var vec__34031 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__34021);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34031,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34031,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append(b__34022,((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__34021,s__34020__$1,geom_or_geoms,vec__34031,idx,record,c__7187__auto__,size__7188__auto__,b__34022,s__34020__$2,temp__4657__auto__){
return (function (p1__34015_SHARP_){
return hatti.map.utils.make_feature(p1__34015_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(i__34021,s__34020__$1,geom_or_geoms,vec__34031,idx,record,c__7187__auto__,size__7188__auto__,b__34022,s__34020__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))));

var G__34041 = (i__34021 + (1));
i__34021 = G__34041;
continue;
} else {
var G__34042 = (i__34021 + (1));
i__34021 = G__34042;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34022),hatti$map$utils$iter__34019(cljs.core.chunk_rest(s__34020__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34022),null);
}
} else {
var vec__34034 = cljs.core.first(s__34020__$2);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34034,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34034,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons(((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (s__34020__$1,geom_or_geoms,vec__34034,idx,record,s__34020__$2,temp__4657__auto__){
return (function (p1__34015_SHARP_){
return hatti.map.utils.make_feature(p1__34015_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(s__34020__$1,geom_or_geoms,vec__34034,idx,record,s__34020__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))),hatti$map$utils$iter__34019(cljs.core.rest(s__34020__$2)));
} else {
var G__34043 = cljs.core.rest(s__34020__$2);
s__34020__$1 = G__34043;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(hatti.utils.indexed(dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,cljs.core.flatten(features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;

/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__34045){
var map__34048 = p__34045;
var map__34048__$1 = ((((!((map__34048 == null)))?((((map__34048.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34048.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34048):map__34048);
var mapbox_tiles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34048__$1,cljs.core.cst$kw$mapbox_DASH_tiles);
var include_google_maps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34048__$1,cljs.core.cst$kw$include_DASH_google_DASH_maps_QMARK_);
var layers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__34048,map__34048__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__34044_SHARP_){
return L.tileLayer(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(p1__34044_SHARP_));
});})(map__34048,map__34048__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name,mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js(nlayers));
var m = L.map(id,({"layers": cljs.core.first(layers), "zoomControl": false}));
var z = L.control.zoom.call(null,({"position": "bottomleft"}));
z.addTo(m);

L.control.layers.call(null,named_layers,null,({"position": "bottomleft"})).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank,((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style(marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style(marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not(layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34062 = arguments.length;
var i__7485__auto___34063 = (0);
while(true){
if((i__7485__auto___34063 < len__7484__auto___34062)){
args__7491__auto__.push((arguments[i__7485__auto___34063]));

var G__34064 = (i__7485__auto___34063 + (1));
i__7485__auto___34063 = G__34064;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__34059){
var map__34060 = p__34059;
var map__34060__$1 = ((((!((map__34060 == null)))?((((map__34060.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34060.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34060):map__34060);
var rezoom_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34060__$1,cljs.core.cst$kw$rezoom_QMARK_);
var on_events = ((function (map__34060,map__34060__$1,rezoom_QMARK_){
return (function (p1__34050_SHARP_,p2__34051_SHARP_){
return hatti.map.utils.register_mouse_events(p1__34050_SHARP_,p2__34051_SHARP_,event_chan);
});})(map__34060,map__34060__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__34060,map__34060__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style(geometry_type,cljs.core.cst$kw$normal);
});})(on_events,geometry_type,map__34060,map__34060__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__34060,map__34060__$1,rezoom_QMARK_){
return (function (p1__34053_SHARP_,p2__34052_SHARP_){
return L.circleMarker(p2__34052_SHARP_);
});})(on_events,geometry_type,stylefn,map__34060,map__34060__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js(geojson),({"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn}));
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__34060,map__34060__$1,rezoom_QMARK_){
return (function (p1__34054_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__34054_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$properties,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__34060,map__34060__$1,rezoom_QMARK_))
,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$feature_DASH_layer,feature_layer,cljs.core.cst$kw$markers,markers,cljs.core.cst$kw$id_DASH__GT_marker,cljs.core.zipmap(ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq34055){
var G__34056 = cljs.core.first(seq34055);
var seq34055__$1 = cljs.core.next(seq34055);
var G__34057 = cljs.core.first(seq34055__$1);
var seq34055__$2 = cljs.core.next(seq34055__$1);
var G__34058 = cljs.core.first(seq34055__$2);
var seq34055__$3 = cljs.core.next(seq34055__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__34056,G__34057,G__34058,seq34055__$3);
});

/**
 * Creates a mapboxgl map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_mapboxgl_map = (function hatti$map$utils$create_mapboxgl_map(id){
mapboxgl.accessToken = hatti.constants.mapboxgl_access_token;

var Map = mapboxgl.Map;
var Navigation = mapboxgl.Navigation;
var m = (new Map(({"container": id, "style": "mapbox://styles/mapbox/streets-v9"})));
return m.addControl((new Navigation(({"position": "bottom-left"}))));
});
/**
 * Gets query filter and returns filters based on field type
 */
hatti.map.utils.get_filter = (function hatti$map$utils$get_filter(p__34065,flat_form){
var map__34071 = p__34065;
var map__34071__$1 = ((((!((map__34071 == null)))?((((map__34071.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34071.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34071):map__34071);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34071__$1,cljs.core.cst$kw$column);
var filter = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34071__$1,cljs.core.cst$kw$filter);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34071__$1,cljs.core.cst$kw$value);
var field = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__34071,map__34071__$1,column,filter,value){
return (function (p__34073){
var map__34074 = p__34073;
var map__34074__$1 = ((((!((map__34074 == null)))?((((map__34074.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34074.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34074):map__34074);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34074__$1,cljs.core.cst$kw$full_DASH_name);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(full_name,column);
});})(map__34071,map__34071__$1,column,filter,value))
,flat_form));
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS INT) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS AS TIMESTAMP) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
return [cljs.core.str("json->>'"),cljs.core.str(column),cljs.core.str("' "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');

}
}
});
/**
 * Generates query params filters for filtered datasets 
 */
hatti.map.utils.generate_filter_string = (function hatti$map$utils$generate_filter_string(query,flat_form){
if(cljs.core.truth_(cljs.core.not_empty(query))){
return [cljs.core.str(" and "),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" and ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34076_SHARP_){
return hatti.map.utils.get_filter(p1__34076_SHARP_,flat_form);
}),query)))].join('');
} else {
return null;
}
});
/**
 * Generates tiles url with appropriate filters as query params
 */
hatti.map.utils.get_tiles_endpoint = (function hatti$map$utils$get_tiles_endpoint(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34086 = arguments.length;
var i__7485__auto___34087 = (0);
while(true){
if((i__7485__auto___34087 < len__7484__auto___34086)){
args__7491__auto__.push((arguments[i__7485__auto___34087]));

var G__34088 = (i__7485__auto___34087 + (1));
i__7485__auto___34087 = G__34088;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((4) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((4)),(0),null)):null);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7492__auto__);
});

hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic = (function (tiles_server,formid,fields,flat_form,p__34082){
var vec__34083 = p__34082;
var query = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34083,(0),null);
return [cljs.core.str(tiles_server),cljs.core.str(hatti.constants.tiles_endpoint),cljs.core.str("?where=deleted_at is null and xform_id ="),cljs.core.str(formid),cljs.core.str(hatti.map.utils.generate_filter_string(query,flat_form)),cljs.core.str("&fields="),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",fields))].join('');
});

hatti.map.utils.get_tiles_endpoint.cljs$lang$maxFixedArity = (4);

hatti.map.utils.get_tiles_endpoint.cljs$lang$applyTo = (function (seq34077){
var G__34078 = cljs.core.first(seq34077);
var seq34077__$1 = cljs.core.next(seq34077);
var G__34079 = cljs.core.first(seq34077__$1);
var seq34077__$2 = cljs.core.next(seq34077__$1);
var G__34080 = cljs.core.first(seq34077__$2);
var seq34077__$3 = cljs.core.next(seq34077__$2);
var G__34081 = cljs.core.first(seq34077__$3);
var seq34077__$4 = cljs.core.next(seq34077__$3);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic(G__34078,G__34079,G__34080,G__34081,seq34077__$4);
});

/**
 * Add map source. This is called with either tiles-url or geoson which
 *   determins the source type (Vector or  GeosJSON). 
 */
hatti.map.utils.add_mapboxgl_source = (function hatti$map$utils$add_mapboxgl_source(map,id_string,p__34089){
var map__34092 = p__34089;
var map__34092__$1 = ((((!((map__34092 == null)))?((((map__34092.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34092.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34092):map__34092);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34092__$1,cljs.core.cst$kw$tiles_DASH_url);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34092__$1,cljs.core.cst$kw$geojson);
var tiles = [tiles_url];
var source = (cljs.core.truth_(geojson)?cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"geojson",cljs.core.cst$kw$data,geojson], null)):(cljs.core.truth_(tiles)?({"type": "vector", "tiles": tiles}):null));
if(cljs.core.truth_(map.getSource(id_string))){
return null;
} else {
return map.addSource(id_string,source);
}
});
/**
 * Add map layer from available sources.
 */
hatti.map.utils.add_mapboxgl_layer = (function hatti$map$utils$add_mapboxgl_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34102 = arguments.length;
var i__7485__auto___34103 = (0);
while(true){
if((i__7485__auto___34103 < len__7484__auto___34102)){
args__7491__auto__.push((arguments[i__7485__auto___34103]));

var G__34104 = (i__7485__auto___34103 + (1));
i__7485__auto___34103 = G__34104;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id_string,layer_type,p__34098){
var vec__34099 = p__34098;
var layer_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34099,(0),null);
var paint_properties = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34099,(1),null);
var l_id = (function (){var or__6409__auto__ = layer_id;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id_string;
}
})();
var layer_def = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$id,l_id,cljs.core.cst$kw$type,layer_type,cljs.core.cst$kw$source,id_string,cljs.core.cst$kw$source_DASH_layer,"logger_instance_geom"], null);
var layer = cljs.core.clj__GT_js((cljs.core.truth_(paint_properties)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(layer_def,cljs.core.cst$kw$paint,paint_properties):layer_def));
if(cljs.core.truth_(map.getLayer(l_id))){
return null;
} else {
return map.addLayer(layer,id_string);
}
});

hatti.map.utils.add_mapboxgl_layer.cljs$lang$maxFixedArity = (3);

hatti.map.utils.add_mapboxgl_layer.cljs$lang$applyTo = (function (seq34094){
var G__34095 = cljs.core.first(seq34094);
var seq34094__$1 = cljs.core.next(seq34094);
var G__34096 = cljs.core.first(seq34094__$1);
var seq34094__$2 = cljs.core.next(seq34094__$1);
var G__34097 = cljs.core.first(seq34094__$2);
var seq34094__$3 = cljs.core.next(seq34094__$2);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(G__34095,G__34096,G__34097,seq34094__$3);
});

/**
 * Generates a collection of input - output value pairs known
 * as stops. These stops are used by get-styles function to decide the style
 * output based on an input vaue from the dataset. e.g. _id. By defauly this
 *  function purely generates color stops.
 */
hatti.map.utils.generate_stops = (function hatti$map$utils$generate_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Generates cirlce size property stops base on values from dataset.
 */
hatti.map.utils.generate_size_stops = (function hatti$map$utils$generate_size_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(4)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Gets predefined styles for diffent layer types and states.
 */
hatti.map.utils.get_styles = (function hatti$map$utils$get_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34110 = arguments.length;
var i__7485__auto___34111 = (0);
while(true){
if((i__7485__auto___34111 < len__7484__auto___34110)){
args__7491__auto__.push((arguments[i__7485__auto___34111]));

var G__34112 = (i__7485__auto___34111 + (1));
i__7485__auto___34111 = G__34112;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic = (function (p__34106){
var vec__34107 = p__34106;
var selected_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34107,(0),null);
var stops = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34107,(1),null);
var size_stops = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34107,(2),null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",(4)], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null),cljs.core.cst$kw$sized,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(size_stops)?size_stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(6)], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-opacity",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(3),0.2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(15),0.8], null)], null)], null))], null)], null)], null),cljs.core.cst$kw$fill,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-opacity",0.7], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-outline-color","#666"], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null)], null)], null);
});

hatti.map.utils.get_styles.cljs$lang$maxFixedArity = (0);

hatti.map.utils.get_styles.cljs$lang$applyTo = (function (seq34105){
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34105));
});

/**
 * Get style properties for layer.
 */
hatti.map.utils.get_style_properties = (function hatti$map$utils$get_style_properties(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34121 = arguments.length;
var i__7485__auto___34122 = (0);
while(true){
if((i__7485__auto___34122 < len__7484__auto___34121)){
args__7491__auto__.push((arguments[i__7485__auto___34122]));

var G__34123 = (i__7485__auto___34122 + (1));
i__7485__auto___34122 = G__34123;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic = (function (style_type,style_state,p__34116){
var map__34117 = p__34116;
var map__34117__$1 = ((((!((map__34117 == null)))?((((map__34117.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34117.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34117):map__34117);
var selected_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34117__$1,cljs.core.cst$kw$selected_DASH_id);
var stops = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34117__$1,cljs.core.cst$kw$stops);
var G__34119 = (function (){var G__34120 = hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([selected_id,stops], 0));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__34120) : style_type.call(null,G__34120));
})();
return (style_state.cljs$core$IFn$_invoke$arity$1 ? style_state.cljs$core$IFn$_invoke$arity$1(G__34119) : style_state.call(null,G__34119));
});

hatti.map.utils.get_style_properties.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_style_properties.cljs$lang$applyTo = (function (seq34113){
var G__34114 = cljs.core.first(seq34113);
var seq34113__$1 = cljs.core.next(seq34113);
var G__34115 = cljs.core.first(seq34113__$1);
var seq34113__$2 = cljs.core.next(seq34113__$1);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(G__34114,G__34115,seq34113__$2);
});

/**
 * Sets maps paint properties given layer-id and list of properties to set.
 *   properties should be a list of properties that contains the propery name
 *   and value in a vector. e.g. [[property1 value1] [property2 value2]
 */
hatti.map.utils.set_mapboxgl_paint_property = (function hatti$map$utils$set_mapboxgl_paint_property(map,layer_id,properties){
var seq__34134 = cljs.core.seq(properties);
var chunk__34135 = null;
var count__34136 = (0);
var i__34137 = (0);
while(true){
if((i__34137 < count__34136)){
var vec__34138 = chunk__34135.cljs$core$IIndexed$_nth$arity$2(null,i__34137);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34138,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34138,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__34144 = seq__34134;
var G__34145 = chunk__34135;
var G__34146 = count__34136;
var G__34147 = (i__34137 + (1));
seq__34134 = G__34144;
chunk__34135 = G__34145;
count__34136 = G__34146;
i__34137 = G__34147;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__34134);
if(temp__4657__auto__){
var seq__34134__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34134__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__34134__$1);
var G__34148 = cljs.core.chunk_rest(seq__34134__$1);
var G__34149 = c__7220__auto__;
var G__34150 = cljs.core.count(c__7220__auto__);
var G__34151 = (0);
seq__34134 = G__34148;
chunk__34135 = G__34149;
count__34136 = G__34150;
i__34137 = G__34151;
continue;
} else {
var vec__34141 = cljs.core.first(seq__34134__$1);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34141,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34141,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__34152 = cljs.core.next(seq__34134__$1);
var G__34153 = null;
var G__34154 = (0);
var G__34155 = (0);
seq__34134 = G__34152;
chunk__34135 = G__34153;
count__34136 = G__34154;
i__34137 = G__34155;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.utils.get_id_property = (function hatti$map$utils$get_id_property(features){
var properties = (cljs.core.first(features)["properties"]);
var or__6409__auto__ = (properties["id"]);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return (properties[hatti.constants._id]);
}
});
/**
 * Register map mouse events.
 */
hatti.map.utils.register_mapboxgl_mouse_events = (function hatti$map$utils$register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style){
map.off("mousemove");

map.off("click");

map.on("mousemove",(function (e){
var layer_id = id_string;
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$view_DASH_by], null));
var selected_id = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$id], null));
map.getCanvas().style.cursor = (((features.length > (0)))?"pointer":"");

if(cljs.core.truth_(view_by)){
return null;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(no_of_features,(1))){
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$hover,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,hatti.map.utils.get_id_property(features)], 0)));
} else {
hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties(style,cljs.core.cst$kw$normal));

if(cljs.core.truth_(selected_id)){
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$clicked,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,selected_id], 0)));
} else {
return null;
}
}
}
}));

return map.on("click",(function (e){
var layer_id = id_string;
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$view_DASH_by], null));
if((no_of_features > (0))){
var feature_id = hatti.map.utils.get_id_property(features);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_id,feature_id], null));

if(cljs.core.truth_(view_by)){
return null;
} else {
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$clicked,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,feature_id], 0)));
}
} else {
return null;
}
}));
});
/**
 * Fits map boundaries on rendered features.
 */
hatti.map.utils.fitMapBounds = (function hatti$map$utils$fitMapBounds(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34163 = arguments.length;
var i__7485__auto___34164 = (0);
while(true){
if((i__7485__auto___34164 < len__7484__auto___34163)){
args__7491__auto__.push((arguments[i__7485__auto___34164]));

var G__34165 = (i__7485__auto___34164 + (1));
i__7485__auto___34164 = G__34165;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__34159){
var vec__34160 = p__34159;
var geojson = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34160,(0),null);
var features = (function (){var or__6409__auto__ = cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return map.queryRenderedFeatures(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
}
})();
var layer_data = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,features], null));
}
})();
var bbox = turf.bbox(cljs.core.clj__GT_js(layer_data));
if((cljs.core.count(features) > (0))){
return map.fitBounds(bbox,({"padding": "15", "linear": true}));
} else {
return null;
}
});

hatti.map.utils.fitMapBounds.cljs$lang$maxFixedArity = (2);

hatti.map.utils.fitMapBounds.cljs$lang$applyTo = (function (seq34156){
var G__34157 = cljs.core.first(seq34156);
var seq34156__$1 = cljs.core.next(seq34156);
var G__34158 = cljs.core.first(seq34156__$1);
var seq34156__$2 = cljs.core.next(seq34156__$1);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic(G__34157,G__34158,seq34156__$2);
});

/**
 * Get marker style for field type.
 */
hatti.map.utils.geotype__GT_marker_style = (function hatti$map$utils$geotype__GT_marker_style(field){
if(cljs.core.truth_(hatti.ona.forms.geoshape_QMARK_(field))){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"fill",cljs.core.cst$kw$style,cljs.core.cst$kw$fill], null);
} else {
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(field))){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"fill",cljs.core.cst$kw$style,cljs.core.cst$kw$fill], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"circle",cljs.core.cst$kw$style,cljs.core.cst$kw$point], null);

}
}
});
/**
 * Functions that are called after map is loaded in DOM.
 */
hatti.map.utils.map_on_load = (function hatti$map$utils$map_on_load(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34175 = arguments.length;
var i__7485__auto___34176 = (0);
while(true){
if((i__7485__auto___34176 < len__7484__auto___34175)){
args__7491__auto__.push((arguments[i__7485__auto___34176]));

var G__34177 = (i__7485__auto___34176 + (1));
i__7485__auto___34176 = G__34177;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic = (function (map,event_chan,id_string,p__34170){
var map__34171 = p__34170;
var map__34171__$1 = ((((!((map__34171 == null)))?((((map__34171.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34171.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34171):map__34171);
var map_data = map__34171__$1;
var geofield = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34171__$1,cljs.core.cst$kw$geofield);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34171__$1,cljs.core.cst$kw$owner);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34171__$1,cljs.core.cst$kw$tiles_DASH_url);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34171__$1,cljs.core.cst$kw$geojson);
var map__34173 = hatti.map.utils.geotype__GT_marker_style(geofield);
var map__34173__$1 = ((((!((map__34173 == null)))?((((map__34173.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34173.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34173):map__34173);
var layer_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34173__$1,cljs.core.cst$kw$layer_DASH_type);
var style = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34173__$1,cljs.core.cst$kw$style);
var stops = om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$stops);
var circle_border = "point-casting";
if(cljs.core.truth_((function (){var or__6409__auto__ = (cljs.core.count(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)) > (0));
if(or__6409__auto__){
return or__6409__auto__;
} else {
return tiles_url;
}
})())){
hatti.map.utils.add_mapboxgl_source(map,id_string,map_data);

hatti.map.utils.add_mapboxgl_layer(map,id_string,layer_type);

hatti.map.utils.register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style);

hatti.map.utils.set_mapboxgl_paint_property(map,id_string,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$normal,cljs.core.array_seq([cljs.core.cst$kw$stops,stops], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$point,style)){
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,id_string,layer_type,cljs.core.array_seq([circle_border,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$circle_DASH_color,"#fff",cljs.core.cst$kw$circle_DASH_radius,(6)], null)], 0));
} else {
if(cljs.core.truth_(map.getLayer(circle_border))){
map.removeLayer(circle_border);
} else {
}
}

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$style,style);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$loaded_QMARK_,true);
} else {
return null;
}
});

hatti.map.utils.map_on_load.cljs$lang$maxFixedArity = (3);

hatti.map.utils.map_on_load.cljs$lang$applyTo = (function (seq34166){
var G__34167 = cljs.core.first(seq34166);
var seq34166__$1 = cljs.core.next(seq34166);
var G__34168 = cljs.core.first(seq34166__$1);
var seq34166__$2 = cljs.core.next(seq34166__$1);
var G__34169 = cljs.core.first(seq34166__$2);
var seq34166__$3 = cljs.core.next(seq34166__$2);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic(G__34167,G__34168,G__34169,seq34166__$3);
});

/**
 * Set default style
 */
hatti.map.utils.clear_map_styles = (function hatti$map$utils$clear_map_styles(owner){
return hatti.map.utils.set_mapboxgl_paint_property(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$mapboxgl_DASH_map),om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$layer_DASH_id),hatti.map.utils.get_style_properties(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$style),cljs.core.cst$kw$normal));
});
