// Compiled by ClojureScript 1.9.229 {}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__7072__auto__ = (((x == null))?null:x);
var m__7073__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,x);
} else {
var m__7073__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return c2.dom.select.call(null,selector);
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render.call(null,v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args20462 = [];
var len__7484__auto___20465 = arguments.length;
var i__7485__auto___20466 = (0);
while(true){
if((i__7485__auto___20466 < len__7484__auto___20465)){
args20462.push((arguments[i__7485__auto___20466]));

var G__20467 = (i__7485__auto___20466 + (1));
i__7485__auto___20466 = G__20467;
continue;
} else {
}
break;
}

var G__20464 = args20462.length;
switch (G__20464) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20462.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;

/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args20469 = [];
var len__7484__auto___20472 = arguments.length;
var i__7485__auto___20473 = (0);
while(true){
if((i__7485__auto___20473 < len__7484__auto___20472)){
args20469.push((arguments[i__7485__auto___20473]));

var G__20474 = (i__7485__auto___20473 + (1));
i__7485__auto___20473 = G__20474;
continue;
} else {
}
break;
}

var G__20471 = args20469.length;
switch (G__20471) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20469.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;

/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom.call(null,node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom.call(null,node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.appendChild(c2.dom.__GT_dom.call(null,container),el__$1);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.insertChildAt(c2.dom.__GT_dom.call(null,container),el__$1,(0));

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
return goog.dom.removeNode(c2.dom.__GT_dom.call(null,el));
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom.call(null,new$);
goog.dom.replaceNode(new$__$1,c2.dom.__GT_dom.call(null,old));

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args20476 = [];
var len__7484__auto___20489 = arguments.length;
var i__7485__auto___20490 = (0);
while(true){
if((i__7485__auto___20490 < len__7484__auto___20489)){
args20476.push((arguments[i__7485__auto___20490]));

var G__20491 = (i__7485__auto___20490 + (1));
i__7485__auto___20490 = G__20491;
continue;
} else {
}
break;
}

var G__20478 = args20476.length;
switch (G__20478) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20476.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return goog.style.getComputedStyle(el__$1,cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__20479_20493 = cljs.core.seq.call(null,x);
var chunk__20480_20494 = null;
var count__20481_20495 = (0);
var i__20482_20496 = (0);
while(true){
if((i__20482_20496 < count__20481_20495)){
var vec__20483_20497 = cljs.core._nth.call(null,chunk__20480_20494,i__20482_20496);
var k_20498 = cljs.core.nth.call(null,vec__20483_20497,(0),null);
var v_20499 = cljs.core.nth.call(null,vec__20483_20497,(1),null);
c2.dom.style.call(null,el__$1,k_20498,v_20499);

var G__20500 = seq__20479_20493;
var G__20501 = chunk__20480_20494;
var G__20502 = count__20481_20495;
var G__20503 = (i__20482_20496 + (1));
seq__20479_20493 = G__20500;
chunk__20480_20494 = G__20501;
count__20481_20495 = G__20502;
i__20482_20496 = G__20503;
continue;
} else {
var temp__4657__auto___20504 = cljs.core.seq.call(null,seq__20479_20493);
if(temp__4657__auto___20504){
var seq__20479_20505__$1 = temp__4657__auto___20504;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20479_20505__$1)){
var c__7220__auto___20506 = cljs.core.chunk_first.call(null,seq__20479_20505__$1);
var G__20507 = cljs.core.chunk_rest.call(null,seq__20479_20505__$1);
var G__20508 = c__7220__auto___20506;
var G__20509 = cljs.core.count.call(null,c__7220__auto___20506);
var G__20510 = (0);
seq__20479_20493 = G__20507;
chunk__20480_20494 = G__20508;
count__20481_20495 = G__20509;
i__20482_20496 = G__20510;
continue;
} else {
var vec__20486_20511 = cljs.core.first.call(null,seq__20479_20505__$1);
var k_20512 = cljs.core.nth.call(null,vec__20486_20511,(0),null);
var v_20513 = cljs.core.nth.call(null,vec__20486_20511,(1),null);
c2.dom.style.call(null,el__$1,k_20512,v_20513);

var G__20514 = cljs.core.next.call(null,seq__20479_20505__$1);
var G__20515 = null;
var G__20516 = (0);
var G__20517 = (0);
seq__20479_20493 = G__20514;
chunk__20480_20494 = G__20515;
count__20481_20495 = G__20516;
i__20482_20496 = G__20517;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
goog.style.setStyle(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,k),((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"height","height",1025178622),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null).call(null,cljs.core.keyword.call(null,k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null)));

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args20518 = [];
var len__7484__auto___20535 = arguments.length;
var i__7485__auto___20536 = (0);
while(true){
if((i__7485__auto___20536 < len__7484__auto___20535)){
args20518.push((arguments[i__7485__auto___20536]));

var G__20537 = (i__7485__auto___20536 + (1));
i__7485__auto___20536 = G__20537;
continue;
} else {
}
break;
}

var G__20520 = args20518.length;
switch (G__20520) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20518.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom.call(null,el).attributes;
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (attrs){
return (function c2$dom$iter__20521(s__20522){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__20522__$1 = s__20522;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20522__$1);
if(temp__4657__auto__){
var s__20522__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20522__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20522__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20524 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20523 = (0);
while(true){
if((i__20523 < size__7188__auto__)){
var i = cljs.core._nth.call(null,c__7187__auto__,i__20523);
cljs.core.chunk_append.call(null,b__20524,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null));

var G__20539 = (i__20523 + (1));
i__20523 = G__20539;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20524),c2$dom$iter__20521.call(null,cljs.core.chunk_rest.call(null,s__20522__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20524),null);
}
} else {
var i = cljs.core.first.call(null,s__20522__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__20521.call(null,cljs.core.rest.call(null,s__20522__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__7189__auto__.call(null,cljs.core.range.call(null,attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__20525_20540 = cljs.core.seq.call(null,x);
var chunk__20526_20541 = null;
var count__20527_20542 = (0);
var i__20528_20543 = (0);
while(true){
if((i__20528_20543 < count__20527_20542)){
var vec__20529_20544 = cljs.core._nth.call(null,chunk__20526_20541,i__20528_20543);
var k_20545 = cljs.core.nth.call(null,vec__20529_20544,(0),null);
var v_20546 = cljs.core.nth.call(null,vec__20529_20544,(1),null);
c2.dom.attr.call(null,el__$1,k_20545,v_20546);

var G__20547 = seq__20525_20540;
var G__20548 = chunk__20526_20541;
var G__20549 = count__20527_20542;
var G__20550 = (i__20528_20543 + (1));
seq__20525_20540 = G__20547;
chunk__20526_20541 = G__20548;
count__20527_20542 = G__20549;
i__20528_20543 = G__20550;
continue;
} else {
var temp__4657__auto___20551 = cljs.core.seq.call(null,seq__20525_20540);
if(temp__4657__auto___20551){
var seq__20525_20552__$1 = temp__4657__auto___20551;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20525_20552__$1)){
var c__7220__auto___20553 = cljs.core.chunk_first.call(null,seq__20525_20552__$1);
var G__20554 = cljs.core.chunk_rest.call(null,seq__20525_20552__$1);
var G__20555 = c__7220__auto___20553;
var G__20556 = cljs.core.count.call(null,c__7220__auto___20553);
var G__20557 = (0);
seq__20525_20540 = G__20554;
chunk__20526_20541 = G__20555;
count__20527_20542 = G__20556;
i__20528_20543 = G__20557;
continue;
} else {
var vec__20532_20558 = cljs.core.first.call(null,seq__20525_20552__$1);
var k_20559 = cljs.core.nth.call(null,vec__20532_20558,(0),null);
var v_20560 = cljs.core.nth.call(null,vec__20532_20558,(1),null);
c2.dom.attr.call(null,el__$1,k_20559,v_20560);

var G__20561 = cljs.core.next.call(null,seq__20525_20552__$1);
var G__20562 = null;
var G__20563 = (0);
var G__20564 = (0);
seq__20525_20540 = G__20561;
chunk__20526_20541 = G__20562;
count__20527_20542 = G__20563;
i__20528_20543 = G__20564;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name.call(null,k));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"style","style",-496642736),k)){
c2.dom.style.call(null,el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name.call(null,k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args20565 = [];
var len__7484__auto___20568 = arguments.length;
var i__7485__auto___20569 = (0);
while(true){
if((i__7485__auto___20569 < len__7484__auto___20568)){
args20565.push((arguments[i__7485__auto___20569]));

var G__20570 = (i__7485__auto___20569 + (1));
i__7485__auto___20569 = G__20570;
continue;
} else {
}
break;
}

var G__20567 = args20565.length;
switch (G__20567) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20565.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.getTextContent(c2.dom.__GT_dom.call(null,el));
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;

/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args20572 = [];
var len__7484__auto___20575 = arguments.length;
var i__7485__auto___20576 = (0);
while(true){
if((i__7485__auto___20576 < len__7484__auto___20575)){
args20572.push((arguments[i__7485__auto___20576]));

var G__20577 = (i__7485__auto___20576 + (1));
i__7485__auto___20576 = G__20577;
continue;
} else {
}
break;
}

var G__20574 = args20572.length;
switch (G__20574) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20572.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.forms.getValue(c2.dom.__GT_dom.call(null,el));
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;

/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
goog.dom.classes.enable(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,class$),classed_QMARK_);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6409__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return ((function (or__6409__auto____$1,or__6409__auto__){
return (function (p1__20579_SHARP_){
return setTimeout(((function (or__6409__auto____$1,or__6409__auto__){
return (function (){
return p1__20579_SHARP_.call(null);
});})(or__6409__auto____$1,or__6409__auto__))
,(10));
});
;})(or__6409__auto____$1,or__6409__auto__))
}
}
})();
