// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.dataview');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.views.photos');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.views.map');
goog.require('hatti.views.chart');
goog.require('hatti.shared');
goog.require('hatti.views.saved_charts');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('hatti.views.settings');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('hatti.views.overview');
goog.require('hatti.views.table');
hatti.views.dataview.dataview_map = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$overview,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$overview,cljs.core.cst$kw$label,"Overview",cljs.core.cst$kw$component,hatti.views.overview_page], null),cljs.core.cst$kw$photos,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$photos,cljs.core.cst$kw$label,"Photos",cljs.core.cst$kw$component,hatti.views.photos_page], null),cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$map,cljs.core.cst$kw$label,"Map",cljs.core.cst$kw$component,hatti.views.map_page], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$table,cljs.core.cst$kw$label,"Table",cljs.core.cst$kw$component,hatti.views.table_page], null),cljs.core.cst$kw$chart,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$chart,cljs.core.cst$kw$label,"Charts",cljs.core.cst$kw$component,hatti.views.chart_page], null),cljs.core.cst$kw$saved_DASH_charts,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$label,"Dashboard",cljs.core.cst$kw$component,hatti.views.saved_charts_page], null),cljs.core.cst$kw$settings,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$settings,cljs.core.cst$kw$label,"Settings",cljs.core.cst$kw$component,hatti.views.settings_page], null)], null);
hatti.views.dataview_actions.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.dataview.t_hatti$views$dataview39912 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39912 = (function (cursor,owner,meta39913){
this.cursor = cursor;
this.owner = owner;
this.meta39913 = meta39913;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39912.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39914,meta39913__$1){
var self__ = this;
var _39914__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39912(self__.cursor,self__.owner,meta39913__$1));
});

hatti.views.dataview.t_hatti$views$dataview39912.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39914){
var self__ = this;
var _39914__$1 = this;
return self__.meta39913;
});

hatti.views.dataview.t_hatti$views$dataview39912.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39912.prototype.om$core$IRender$render$arity$1 = (function (this__17298__auto__){
var self__ = this;
var this__17298__auto____$1 = this;
return null;
});

hatti.views.dataview.t_hatti$views$dataview39912.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39913], null);
});

hatti.views.dataview.t_hatti$views$dataview39912.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39912.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39912";

hatti.views.dataview.t_hatti$views$dataview39912.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39912");
});

hatti.views.dataview.__GT_t_hatti$views$dataview39912 = (function hatti$views$dataview$__GT_t_hatti$views$dataview39912(cursor__$1,owner__$1,meta39913){
return (new hatti.views.dataview.t_hatti$views$dataview39912(cursor__$1,owner__$1,meta39913));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview39912(cursor,owner,null));
}));
hatti.views.dataview_infobar.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__39915,owner){
var map__39916 = p__39915;
var map__39916__$1 = ((((!((map__39916 == null)))?((((map__39916.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39916.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39916):map__39916);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39916__$1,cljs.core.cst$kw$dataset_DASH_info);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39916__$1,cljs.core.cst$kw$status);
if(typeof hatti.views.dataview.t_hatti$views$dataview39918 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39918 = (function (p__39915,owner,map__39916,dataset_info,status,meta39919){
this.p__39915 = p__39915;
this.owner = owner;
this.map__39916 = map__39916;
this.dataset_info = dataset_info;
this.status = status;
this.meta39919 = meta39919;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39918.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__39916,map__39916__$1,dataset_info,status){
return (function (_39920,meta39919__$1){
var self__ = this;
var _39920__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39918(self__.p__39915,self__.owner,self__.map__39916,self__.dataset_info,self__.status,meta39919__$1));
});})(map__39916,map__39916__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39918.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__39916,map__39916__$1,dataset_info,status){
return (function (_39920){
var self__ = this;
var _39920__$1 = this;
return self__.meta39919;
});})(map__39916,map__39916__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39918.prototype.om$core$IWillMount$ = true;

hatti.views.dataview.t_hatti$views$dataview39918.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__39916,map__39916__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var langs = hatti.ona.forms.get_languages(form);
var default_lang = hatti.ona.forms.default_lang(langs);
var lang_state = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$all,langs,cljs.core.cst$kw$default,default_lang,cljs.core.cst$kw$current,default_lang], null);
if(cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))){
return chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$languages], null),lang_state);
} else {
return null;
}
});})(map__39916,map__39916__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39918.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39918.prototype.om$core$IRender$render$arity$1 = ((function (map__39916,map__39916__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var map__39921 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39921__$1 = ((((!((map__39921 == null)))?((((map__39921.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39921.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39921):map__39921);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39921__$1,cljs.core.cst$kw$dataset_DASH_id);
var map__39922 = self__.dataset_info;
var map__39922__$1 = ((((!((map__39922 == null)))?((((map__39922.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39922.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39922):map__39922);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39922__$1,cljs.core.cst$kw$num_of_submissions);
var map__39923 = self__.status;
var map__39923__$1 = ((((!((map__39923 == null)))?((((map__39923.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39923.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39923):map__39923);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39923__$1,cljs.core.cst$kw$loading_QMARK_);
var total_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39923__$1,cljs.core.cst$kw$total_DASH_records);
var G__39931 = ({"className": "right rec-summary rec-margin"});
var G__39932 = (function (){var attrs39927 = (cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))?om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.shared.language_selector,null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs39927))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,"language-selector"], null),attrs39927], 0))):({"id": "language-selector"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39927))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39927)], null))));
})();
var G__39933 = (function (){var G__39936 = ({"id": "data-status"});
var G__39937 = (function (){var attrs39928 = (cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs39928))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rec"], null)], null),attrs39928], 0))):({"className": "rec"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39928))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39928),sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null))));
})();
return React.DOM.div(G__39936,G__39937);
})();
var G__39934 = (function (){var G__39938 = ({"className": "divider"});
return React.DOM.div(G__39938);
})();
var G__39935 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_actions,dataset_id));
return React.DOM.div(G__39931,G__39932,G__39933,G__39934,G__39935);
});})(map__39916,map__39916__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39918.getBasis = ((function (map__39916,map__39916__$1,dataset_info,status){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__39915,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__39916,cljs.core.cst$sym$dataset_DASH_info,cljs.core.cst$sym$status,cljs.core.cst$sym$meta39919], null);
});})(map__39916,map__39916__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39918.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39918.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39918";

hatti.views.dataview.t_hatti$views$dataview39918.cljs$lang$ctorPrWriter = ((function (map__39916,map__39916__$1,dataset_info,status){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39918");
});})(map__39916,map__39916__$1,dataset_info,status))
;

hatti.views.dataview.__GT_t_hatti$views$dataview39918 = ((function (map__39916,map__39916__$1,dataset_info,status){
return (function hatti$views$dataview$__GT_t_hatti$views$dataview39918(p__39915__$1,owner__$1,map__39916__$2,dataset_info__$1,status__$1,meta39919){
return (new hatti.views.dataview.t_hatti$views$dataview39918(p__39915__$1,owner__$1,map__39916__$2,dataset_info__$1,status__$1,meta39919));
});})(map__39916,map__39916__$1,dataset_info,status))
;

}

return (new hatti.views.dataview.t_hatti$views$dataview39918(p__39915,owner,map__39916__$1,dataset_info,status,cljs.core.PersistentArrayMap.EMPTY));
}));
hatti.views.dataview.activate_view_BANG_ = (function hatti$views$dataview$activate_view_BANG_(view){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_(cljs.core.set(views),view__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_settings_view_BANG_ = (function hatti$views$dataview$activate_settings_view_BANG_(view,settings_section){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$active_DASH_tab,settings_section__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_integrated_apps_view_BANG_ = (function hatti$views$dataview$activate_integrated_apps_view_BANG_(view,settings_section,app_type){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.app_state,((function (view__$1,settings_section__$1,settings_views){
return (function (app_state){
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$selected], null),view__$1),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$active_DASH_tab], null),settings_section__$1),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps,cljs.core.cst$kw$active_DASH_section], null),app_type);
});})(view__$1,settings_section__$1,settings_views))
);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(app_type,hatti.constants.google_sheets)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$add_QMARK_,true], null));
} else {
}

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.tabbed_dataview.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,opts){
if(typeof hatti.views.dataview.t_hatti$views$dataview39942 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39942 = (function (app_state,owner,opts,meta39943){
this.app_state = app_state;
this.owner = owner;
this.opts = opts;
this.meta39943 = meta39943;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39942.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39944,meta39943__$1){
var self__ = this;
var _39944__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39942(self__.app_state,self__.owner,self__.opts,meta39943__$1));
});

hatti.views.dataview.t_hatti$views$dataview39942.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39944){
var self__ = this;
var _39944__$1 = this;
return self__.meta39943;
});

hatti.views.dataview.t_hatti$views$dataview39942.prototype.om$core$IInitState$ = true;

hatti.views.dataview.t_hatti$views$dataview39942.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var geopoints_QMARK_ = cljs.core.cst$kw$instances_with_geopoints.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state));
var no_geodata_QMARK_ = cljs.core.not((function (){var or__6409__auto__ = geopoints_QMARK_;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = cljs.core.some(hatti.ona.forms.geopoint_QMARK_,form);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return cljs.core.some(hatti.ona.forms.geofield_QMARK_,form);
}
}
})());
if((no_geodata_QMARK_) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$map,cljs.core.cst$kw$selected.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))))){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$selected], null),cljs.core.cst$kw$table);
} else {
}

return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$no_DASH_geodata_QMARK_,no_geodata_QMARK_], null);
});

hatti.views.dataview.t_hatti$views$dataview39942.prototype.om$core$IRenderState$ = true;

hatti.views.dataview.t_hatti$views$dataview39942.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,p__39945){
var self__ = this;
var map__39946 = p__39945;
var map__39946__$1 = ((((!((map__39946 == null)))?((((map__39946.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39946.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39946):map__39946);
var no_geodata_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39946__$1,cljs.core.cst$kw$no_DASH_geodata_QMARK_);
var ___$1 = this;
var active_view = cljs.core.cst$kw$selected.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state));
var view__GT_display = ((function (active_view,___$1,map__39946,map__39946__$1,no_geodata_QMARK_){
return (function (p1__39939_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_view,p1__39939_SHARP_)){
return "block";
} else {
return "none";
}
});})(active_view,___$1,map__39946,map__39946__$1,no_geodata_QMARK_))
;
var view__GT_cls = ((function (active_view,view__GT_display,___$1,map__39946,map__39946__$1,no_geodata_QMARK_){
return (function (p1__39940_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_view,p1__39940_SHARP_)){
return "clicked";
} else {
return null;
}
});})(active_view,view__GT_display,___$1,map__39946,map__39946__$1,no_geodata_QMARK_))
;
var dataviews = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview.dataview_map,cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))));
var dv__GT_link = ((function (active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__39946,map__39946__$1,no_geodata_QMARK_){
return (function (p__39948){
var map__39949 = p__39948;
var map__39949__$1 = ((((!((map__39949 == null)))?((((map__39949.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39949.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39949):map__39949);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39949__$1,cljs.core.cst$kw$view);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39949__$1,cljs.core.cst$kw$label);
var active_QMARK_ = cljs.core.some(((function (map__39949,map__39949__$1,view,label,active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__39946,map__39946__$1,no_geodata_QMARK_){
return (function (p1__39941_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,p1__39941_SHARP_);
});})(map__39949,map__39949__$1,view,label,active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__39946,map__39946__$1,no_geodata_QMARK_))
,cljs.core.cst$kw$active.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state)));
if(cljs.core.truth_((function (){var and__6397__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,cljs.core.cst$kw$map);
if(and__6397__auto__){
return no_geodata_QMARK_;
} else {
return and__6397__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,"inactive",cljs.core.cst$kw$title,"No geodata"], null),cljs.core.name(view)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,(cljs.core.truth_(active_QMARK_)?[cljs.core.str("#/"),cljs.core.str(cljs.core.name(view))].join(''):null),cljs.core.cst$kw$class,(cljs.core.truth_(active_QMARK_)?view__GT_cls(view):"inactive")], null),label], null);

}
});})(active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__39946,map__39946__$1,no_geodata_QMARK_))
;
var G__39952 = ({"className": "tab-container dataset-tabs"});
var G__39953 = (function (){var attrs39951 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(dv__GT_link,dataviews);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs39951))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-bar"], null)], null),attrs39951], 0))):({"className": "tab-bar"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39951))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39951),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null))));
})();
var G__39954 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = ((function (G__39952,G__39953,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__39946,map__39946__$1,no_geodata_QMARK_){
return (function hatti$views$dataview$iter__39955(s__39956){
return (new cljs.core.LazySeq(null,((function (G__39952,G__39953,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__39946,map__39946__$1,no_geodata_QMARK_){
return (function (){
var s__39956__$1 = s__39956;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39956__$1);
if(temp__4657__auto__){
var s__39956__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39956__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39956__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39958 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39957 = (0);
while(true){
if((i__39957 < size__7188__auto__)){
var map__39969 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39957);
var map__39969__$1 = ((((!((map__39969 == null)))?((((map__39969.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39969.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39969):map__39969);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39969__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39969__$1,cljs.core.cst$kw$view);
cljs.core.chunk_append(b__39958,(function (){var G__39971 = ({"style": ({"display": view__GT_display(view)}), "className": [cljs.core.str("tab-page "),cljs.core.str(cljs.core.name(view)),cljs.core.str("-page")].join('')});
var G__39972 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_view,view))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(cljs.core.name(view))].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null):null));
return React.DOM.div(G__39971,G__39972);
})());

var G__39977 = (i__39957 + (1));
i__39957 = G__39977;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39958),hatti$views$dataview$iter__39955(cljs.core.chunk_rest(s__39956__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39958),null);
}
} else {
var map__39973 = cljs.core.first(s__39956__$2);
var map__39973__$1 = ((((!((map__39973 == null)))?((((map__39973.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39973.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39973):map__39973);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39973__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39973__$1,cljs.core.cst$kw$view);
return cljs.core.cons((function (){var G__39975 = ({"style": ({"display": view__GT_display(view)}), "className": [cljs.core.str("tab-page "),cljs.core.str(cljs.core.name(view)),cljs.core.str("-page")].join('')});
var G__39976 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_view,view))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(cljs.core.name(view))].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null):null));
return React.DOM.div(G__39975,G__39976);
})(),hatti$views$dataview$iter__39955(cljs.core.rest(s__39956__$2)));
}
} else {
return null;
}
break;
}
});})(G__39952,G__39953,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__39946,map__39946__$1,no_geodata_QMARK_))
,null,null));
});})(G__39952,G__39953,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__39946,map__39946__$1,no_geodata_QMARK_))
;
return iter__7189__auto__(dataviews);
})());
return React.DOM.div(G__39952,G__39953,G__39954);
});

hatti.views.dataview.t_hatti$views$dataview39942.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta39943], null);
});

hatti.views.dataview.t_hatti$views$dataview39942.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39942.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39942";

hatti.views.dataview.t_hatti$views$dataview39942.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39942");
});

hatti.views.dataview.__GT_t_hatti$views$dataview39942 = (function hatti$views$dataview$__GT_t_hatti$views$dataview39942(app_state__$1,owner__$1,opts__$1,meta39943){
return (new hatti.views.dataview.t_hatti$views$dataview39942(app_state__$1,owner__$1,opts__$1,meta39943));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview39942(app_state,owner,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
