// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('clojure.string');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('cljs.reader');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"point","point",1813198264),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),({"radius": (6), "fillColor": "#f30", "reset": ({"fillColor": "#f30"}), "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9}),new cljs.core.Keyword(null,"hover","hover",-341141711),({"fillColor": "#631400"}),new cljs.core.Keyword(null,"clicked","clicked",114423720),({"fillColor": "#ad2300"})], null),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),({"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8}),new cljs.core.Keyword(null,"hover","hover",-341141711),({"fillColor": "#631400", "color": "#222"}),new cljs.core.Keyword(null,"clicked","clicked",114423720),({"fillColor": "#ad2300", "color": "#222"})], null),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),({"color": "#f30", "opacity": (1), "weight": (6), "reset": ({"color": "#f30"})}),new cljs.core.Keyword(null,"hover","hover",-341141711),({"color": "#631400"}),new cljs.core.Keyword(null,"clicked","clicked",114423720),({"color": "#ad2300"})], null)], null);
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",new cljs.core.Keyword(null,"point","point",1813198264),"Polygon",new cljs.core.Keyword(null,"shape","shape",1190694006),"LineString",new cljs.core.Keyword(null,"line","line",212345235)], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(marker_or_keyword,style_type){
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype.call(null,marker_or_keyword));
return style_type.call(null,kw.call(null,hatti.map.utils.ona_styles));
});
hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.call(null,s);
var tc = cljs.core.js__GT_clj.call(null,t);
return cljs.core._EQ_.call(null,cljs.core.select_keys.call(null,sc,cljs.core.keys.call(null,tc)),cljs.core.select_keys.call(null,tc,cljs.core.keys.call(null,sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args19262 = [];
var len__7484__auto___19265 = arguments.length;
var i__7485__auto___19266 = (0);
while(true){
if((i__7485__auto___19266 < len__7484__auto___19265)){
args19262.push((arguments[i__7485__auto___19266]));

var G__19267 = (i__7485__auto___19266 + (1));
i__7485__auto___19266 = G__19267;
continue;
} else {
}
break;
}

var G__19264 = args19262.length;
switch (G__19264) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19262.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
return kw.call(null,cljs.core.js__GT_clj.call(null,hatti.map.utils.get_style.call(null,marker)));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;

/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style.call(null,hatti.map.utils.get_style.call(null,marker),hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"clicked","clicked",114423720)));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = marker__GT_style.call(null,marker);
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return marker.setStyle(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"reset","reset",-800929946),style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,style,new cljs.core.Keyword(null,"reset","reset",-800929946),style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4655__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4655__auto__)){
var rstyle = temp__4655__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.map.utils.is_clicked_QMARK_.call(null,marker);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id_selected_QMARK_.call(null,hatti.map.utils.get_id.call(null,marker));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"clicked","clicked",114423720)));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style.call(null,marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"hover","hover",-341141711)));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19278 = arguments.length;
var i__7485__auto___19279 = (0);
while(true){
if((i__7485__auto___19279 < len__7484__auto___19278)){
args__7491__auto__.push((arguments[i__7485__auto___19279]));

var G__19280 = (i__7485__auto___19279 + (1));
i__7485__auto___19279 = G__19280;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__19271){
var map__19272 = p__19271;
var map__19272__$1 = ((((!((map__19272 == null)))?((((map__19272.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19272.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19272):map__19272);
var preserve_clicked_QMARK_ = cljs.core.get.call(null,map__19272__$1,new cljs.core.Keyword(null,"preserve-clicked?","preserve-clicked?",-727263842),true);
var seq__19274 = cljs.core.seq.call(null,markers);
var chunk__19275 = null;
var count__19276 = (0);
var i__19277 = (0);
while(true){
if((i__19277 < count__19276)){
var marker = cljs.core._nth.call(null,chunk__19275,i__19277);
if(cljs.core.not.call(null,(function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_.call(null,marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
} else {
}

var G__19281 = seq__19274;
var G__19282 = chunk__19275;
var G__19283 = count__19276;
var G__19284 = (i__19277 + (1));
seq__19274 = G__19281;
chunk__19275 = G__19282;
count__19276 = G__19283;
i__19277 = G__19284;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__19274);
if(temp__4657__auto__){
var seq__19274__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__19274__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__19274__$1);
var G__19285 = cljs.core.chunk_rest.call(null,seq__19274__$1);
var G__19286 = c__7220__auto__;
var G__19287 = cljs.core.count.call(null,c__7220__auto__);
var G__19288 = (0);
seq__19274 = G__19285;
chunk__19275 = G__19286;
count__19276 = G__19287;
i__19277 = G__19288;
continue;
} else {
var marker = cljs.core.first.call(null,seq__19274__$1);
if(cljs.core.not.call(null,(function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_.call(null,marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
} else {
}

var G__19289 = cljs.core.next.call(null,seq__19274__$1);
var G__19290 = null;
var G__19291 = (0);
var G__19292 = (0);
seq__19274 = G__19289;
chunk__19275 = G__19290;
count__19276 = G__19291;
i__19277 = G__19292;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq19269){
var G__19270 = cljs.core.first.call(null,seq19269);
var seq19269__$1 = cljs.core.next.call(null,seq19269);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__19270,seq19269__$1);
});

hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string.call(null,maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"Feature",new cljs.core.Keyword(null,"properties","properties",685819552),cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.call(null,hatti.constants._rank),(index + (1)),new cljs.core.Keyword(null,"id","id",-1388402092),record_id,cljs.core.keyword.call(null,hatti.constants._id),record_id], true, false),new cljs.core.Keyword(null,"geometry","geometry",-405034994),geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__7334__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__7335__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__7336__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__7337__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__7338__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"hatti.map.utils","get-as-geom"),((function (method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__){
return (function() { 
var G__19297__delegate = function (record,field,p__19293){
var vec__19294 = p__19293;
var repeat_child_index = cljs.core.nth.call(null,vec__19294,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,field))){
return new cljs.core.Keyword(null,"repeat","repeat",832692087);
} else {
return new cljs.core.Keyword(null,"default","default",-1987822328);

}
};
var G__19297 = function (record,field,var_args){
var p__19293 = null;
if (arguments.length > 2) {
var G__19298__i = 0, G__19298__a = new Array(arguments.length -  2);
while (G__19298__i < G__19298__a.length) {G__19298__a[G__19298__i] = arguments[G__19298__i + 2]; ++G__19298__i;}
  p__19293 = new cljs.core.IndexedSeq(G__19298__a,0);
} 
return G__19297__delegate.call(this,record,field,p__19293);};
G__19297.cljs$lang$maxFixedArity = 2;
G__19297.cljs$lang$applyTo = (function (arglist__19299){
var record = cljs.core.first(arglist__19299);
arglist__19299 = cljs.core.next(arglist__19299);
var field = cljs.core.first(arglist__19299);
var p__19293 = cljs.core.rest(arglist__19299);
return G__19297__delegate(record,field,p__19293);
});
G__19297.cljs$core$IFn$_invoke$arity$variadic = G__19297__delegate;
return G__19297;
})()
;})(method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__7338__auto__,method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__));
})();
}
cljs.core._add_method.call(null,hatti.map.utils.get_as_geom,new cljs.core.Keyword(null,"repeat","repeat",832692087),(function (record,p__19300){
var map__19301 = p__19300;
var map__19301__$1 = ((((!((map__19301 == null)))?((((map__19301.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19301.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19301):map__19301);
var field = map__19301__$1;
var children = cljs.core.get.call(null,map__19301__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var full_name = cljs.core.get.call(null,map__19301__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var iter__7189__auto__ = ((function (map__19301,map__19301__$1,field,children,full_name){
return (function hatti$map$utils$iter__19303(s__19304){
return (new cljs.core.LazySeq(null,((function (map__19301,map__19301__$1,field,children,full_name){
return (function (){
var s__19304__$1 = s__19304;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19304__$1);
if(temp__4657__auto__){
var s__19304__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19304__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19304__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19306 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19305 = (0);
while(true){
if((i__19305 < size__7188__auto__)){
var child_record = cljs.core._nth.call(null,c__7187__auto__,i__19305);
cljs.core.chunk_append.call(null,b__19306,(function (){var iter__7189__auto__ = ((function (i__19305,child_record,c__7187__auto__,size__7188__auto__,b__19306,s__19304__$2,temp__4657__auto__,map__19301,map__19301__$1,field,children,full_name){
return (function hatti$map$utils$iter__19303_$_iter__19315(s__19316){
return (new cljs.core.LazySeq(null,((function (i__19305,child_record,c__7187__auto__,size__7188__auto__,b__19306,s__19304__$2,temp__4657__auto__,map__19301,map__19301__$1,field,children,full_name){
return (function (){
var s__19316__$1 = s__19316;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__19316__$1);
if(temp__4657__auto____$1){
var s__19316__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19316__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first.call(null,s__19316__$2);
var size__7188__auto____$1 = cljs.core.count.call(null,c__7187__auto____$1);
var b__19318 = cljs.core.chunk_buffer.call(null,size__7188__auto____$1);
if((function (){var i__19317 = (0);
while(true){
if((i__19317 < size__7188__auto____$1)){
var child = cljs.core._nth.call(null,c__7187__auto____$1,i__19317);
cljs.core.chunk_append.call(null,b__19318,hatti.map.utils.get_as_geom.call(null,child_record,child));

var G__19323 = (i__19317 + (1));
i__19317 = G__19323;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19318),hatti$map$utils$iter__19303_$_iter__19315.call(null,cljs.core.chunk_rest.call(null,s__19316__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19318),null);
}
} else {
var child = cljs.core.first.call(null,s__19316__$2);
return cljs.core.cons.call(null,hatti.map.utils.get_as_geom.call(null,child_record,child),hatti$map$utils$iter__19303_$_iter__19315.call(null,cljs.core.rest.call(null,s__19316__$2)));
}
} else {
return null;
}
break;
}
});})(i__19305,child_record,c__7187__auto__,size__7188__auto__,b__19306,s__19304__$2,temp__4657__auto__,map__19301,map__19301__$1,field,children,full_name))
,null,null));
});})(i__19305,child_record,c__7187__auto__,size__7188__auto__,b__19306,s__19304__$2,temp__4657__auto__,map__19301,map__19301__$1,field,children,full_name))
;
return iter__7189__auto__.call(null,cljs.core.filter.call(null,hatti.ona.forms.geofield_QMARK_,children));
})());

var G__19324 = (i__19305 + (1));
i__19305 = G__19324;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19306),hatti$map$utils$iter__19303.call(null,cljs.core.chunk_rest.call(null,s__19304__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19306),null);
}
} else {
var child_record = cljs.core.first.call(null,s__19304__$2);
return cljs.core.cons.call(null,(function (){var iter__7189__auto__ = ((function (child_record,s__19304__$2,temp__4657__auto__,map__19301,map__19301__$1,field,children,full_name){
return (function hatti$map$utils$iter__19303_$_iter__19319(s__19320){
return (new cljs.core.LazySeq(null,((function (child_record,s__19304__$2,temp__4657__auto__,map__19301,map__19301__$1,field,children,full_name){
return (function (){
var s__19320__$1 = s__19320;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__19320__$1);
if(temp__4657__auto____$1){
var s__19320__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19320__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19320__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19322 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19321 = (0);
while(true){
if((i__19321 < size__7188__auto__)){
var child = cljs.core._nth.call(null,c__7187__auto__,i__19321);
cljs.core.chunk_append.call(null,b__19322,hatti.map.utils.get_as_geom.call(null,child_record,child));

var G__19325 = (i__19321 + (1));
i__19321 = G__19325;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19322),hatti$map$utils$iter__19303_$_iter__19319.call(null,cljs.core.chunk_rest.call(null,s__19320__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19322),null);
}
} else {
var child = cljs.core.first.call(null,s__19320__$2);
return cljs.core.cons.call(null,hatti.map.utils.get_as_geom.call(null,child_record,child),hatti$map$utils$iter__19303_$_iter__19319.call(null,cljs.core.rest.call(null,s__19320__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__19304__$2,temp__4657__auto__,map__19301,map__19301__$1,field,children,full_name))
,null,null));
});})(child_record,s__19304__$2,temp__4657__auto__,map__19301,map__19301__$1,field,children,full_name))
;
return iter__7189__auto__.call(null,cljs.core.filter.call(null,hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__19303.call(null,cljs.core.rest.call(null,s__19304__$2)));
}
} else {
return null;
}
break;
}
});})(map__19301,map__19301__$1,field,children,full_name))
,null,null));
});})(map__19301,map__19301__$1,field,children,full_name))
;
return iter__7189__auto__.call(null,cljs.core.get.call(null,record,full_name));
}));
cljs.core._add_method.call(null,hatti.map.utils.get_as_geom,new cljs.core.Keyword(null,"default","default",-1987822328),(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq.call(null,s)) && (cljs.core.not_EQ_.call(null,s,"n/a"))){
var iter__7189__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__19328(s__19329){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__19329__$1 = s__19329;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19329__$1);
if(temp__4657__auto__){
var s__19329__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19329__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19329__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19331 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19330 = (0);
while(true){
if((i__19330 < size__7188__auto__)){
var coord_string = cljs.core._nth.call(null,c__7187__auto__,i__19330);
cljs.core.chunk_append.call(null,b__19331,(function (){var vec__19338 = clojure.string.split.call(null,coord_string,/ /);
var lat = cljs.core.nth.call(null,vec__19338,(0),null);
var lng = cljs.core.nth.call(null,vec__19338,(1),null);
var _ = cljs.core.nth.call(null,vec__19338,(2),null);
var ___$1 = cljs.core.nth.call(null,vec__19338,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string.call(null,lng),cljs.reader.read_string.call(null,lat)], null);
})());

var G__19345 = (i__19330 + (1));
i__19330 = G__19345;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19331),hatti$map$utils$iter__19328.call(null,cljs.core.chunk_rest.call(null,s__19329__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19331),null);
}
} else {
var coord_string = cljs.core.first.call(null,s__19329__$2);
return cljs.core.cons.call(null,(function (){var vec__19341 = clojure.string.split.call(null,coord_string,/ /);
var lat = cljs.core.nth.call(null,vec__19341,(0),null);
var lng = cljs.core.nth.call(null,vec__19341,(1),null);
var _ = cljs.core.nth.call(null,vec__19341,(2),null);
var ___$1 = cljs.core.nth.call(null,vec__19341,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string.call(null,lng),cljs.reader.read_string.call(null,lat)], null);
})(),hatti$map$utils$iter__19328.call(null,cljs.core.rest.call(null,s__19329__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__7189__auto__.call(null,clojure.string.split.call(null,s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__19344 = geotype;
switch (G__19344) {
case "Point":
return ((function (G__19344,geotype,parse){
return (function (p1__19326_SHARP_){
return cljs.core.first.call(null,parse.call(null,p1__19326_SHARP_));
});
;})(G__19344,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__19344,geotype,parse){
return (function (p1__19327_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse.call(null,p1__19327_SHARP_)],null));
});
;})(G__19344,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.call(null,record,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(geofield));
var coords = coordfn.call(null,value);
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_.call(null,geofield))){
return new cljs.core.Keyword(null,"geom","geom",1207084371).cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = (coords == null);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return cljs.core.some.call(null,cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),geotype,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668),coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args19348 = [];
var len__7484__auto___19367 = arguments.length;
var i__7485__auto___19368 = (0);
while(true){
if((i__7485__auto___19368 < len__7484__auto___19367)){
args19348.push((arguments[i__7485__auto___19368]));

var G__19369 = (i__7485__auto___19368 + (1));
i__7485__auto___19368 = G__19369;
continue;
} else {
}
break;
}

var G__19350 = args19348.length;
switch (G__19350) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19348.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.call(null,dataset,form,hatti.ona.forms.default_geofield.call(null,form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__7189__auto__ = (function hatti$map$utils$iter__19351(s__19352){
return (new cljs.core.LazySeq(null,(function (){
var s__19352__$1 = s__19352;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19352__$1);
if(temp__4657__auto__){
var s__19352__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19352__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19352__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19354 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19353 = (0);
while(true){
if((i__19353 < size__7188__auto__)){
var vec__19361 = cljs.core._nth.call(null,c__7187__auto__,i__19353);
var idx = cljs.core.nth.call(null,vec__19361,(0),null);
var record = cljs.core.nth.call(null,vec__19361,(1),null);
var geom_or_geoms = hatti.map.utils.get_as_geom.call(null,record,geofield);
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append.call(null,b__19354,((cljs.core.map_QMARK_.call(null,geom_or_geoms))?hatti.map.utils.make_feature.call(null,geom_or_geoms,record.call(null,hatti.constants._id),idx):cljs.core.map.call(null,((function (i__19353,s__19352__$1,geom_or_geoms,vec__19361,idx,record,c__7187__auto__,size__7188__auto__,b__19354,s__19352__$2,temp__4657__auto__){
return (function (p1__19347_SHARP_){
return hatti.map.utils.make_feature.call(null,p1__19347_SHARP_,record.call(null,hatti.constants._id),idx);
});})(i__19353,s__19352__$1,geom_or_geoms,vec__19361,idx,record,c__7187__auto__,size__7188__auto__,b__19354,s__19352__$2,temp__4657__auto__))
,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,geom_or_geoms)))));

var G__19371 = (i__19353 + (1));
i__19353 = G__19371;
continue;
} else {
var G__19372 = (i__19353 + (1));
i__19353 = G__19372;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19354),hatti$map$utils$iter__19351.call(null,cljs.core.chunk_rest.call(null,s__19352__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19354),null);
}
} else {
var vec__19364 = cljs.core.first.call(null,s__19352__$2);
var idx = cljs.core.nth.call(null,vec__19364,(0),null);
var record = cljs.core.nth.call(null,vec__19364,(1),null);
var geom_or_geoms = hatti.map.utils.get_as_geom.call(null,record,geofield);
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons.call(null,((cljs.core.map_QMARK_.call(null,geom_or_geoms))?hatti.map.utils.make_feature.call(null,geom_or_geoms,record.call(null,hatti.constants._id),idx):cljs.core.map.call(null,((function (s__19352__$1,geom_or_geoms,vec__19364,idx,record,s__19352__$2,temp__4657__auto__){
return (function (p1__19347_SHARP_){
return hatti.map.utils.make_feature.call(null,p1__19347_SHARP_,record.call(null,hatti.constants._id),idx);
});})(s__19352__$1,geom_or_geoms,vec__19364,idx,record,s__19352__$2,temp__4657__auto__))
,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,geom_or_geoms)))),hatti$map$utils$iter__19351.call(null,cljs.core.rest.call(null,s__19352__$2)));
} else {
var G__19373 = cljs.core.rest.call(null,s__19352__$2);
s__19352__$1 = G__19373;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,hatti.utils.indexed.call(null,dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"FeatureCollection",new cljs.core.Keyword(null,"features","features",-1146962336),cljs.core.flatten.call(null,features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;

/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__19375){
var map__19378 = p__19375;
var map__19378__$1 = ((((!((map__19378 == null)))?((((map__19378.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19378.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19378):map__19378);
var mapbox_tiles = cljs.core.get.call(null,map__19378__$1,new cljs.core.Keyword(null,"mapbox-tiles","mapbox-tiles",69952469));
var include_google_maps_QMARK_ = cljs.core.get.call(null,map__19378__$1,new cljs.core.Keyword(null,"include-google-maps?","include-google-maps?",1820261665));
var layers = cljs.core.map.call(null,((function (map__19378,map__19378__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__19374_SHARP_){
return L.tileLayer(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(p1__19374_SHARP_));
});})(map__19378,map__19378__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"name","name",1843675177),mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js.call(null,nlayers));
var m = L.map(id,({"layers": cljs.core.first.call(null,layers), "zoomControl": false}));
var z = L.control.zoom.call(null,({"position": "bottomleft"}));
z.addTo(m);

L.control.layers.call(null,named_layers,null,({"position": "bottomleft"})).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return cljs.core.async.put_BANG_.call(null,event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mapped-submission-to-rank","mapped-submission-to-rank",-1281314361),((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style.call(null,marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style.call(null,marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not.call(null,layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19392 = arguments.length;
var i__7485__auto___19393 = (0);
while(true){
if((i__7485__auto___19393 < len__7484__auto___19392)){
args__7491__auto__.push((arguments[i__7485__auto___19393]));

var G__19394 = (i__7485__auto___19393 + (1));
i__7485__auto___19393 = G__19394;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__19389){
var map__19390 = p__19389;
var map__19390__$1 = ((((!((map__19390 == null)))?((((map__19390.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19390.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19390):map__19390);
var rezoom_QMARK_ = cljs.core.get.call(null,map__19390__$1,new cljs.core.Keyword(null,"rezoom?","rezoom?",746240707));
var on_events = ((function (map__19390,map__19390__$1,rezoom_QMARK_){
return (function (p1__19380_SHARP_,p2__19381_SHARP_){
return hatti.map.utils.register_mouse_events.call(null,p1__19380_SHARP_,p2__19381_SHARP_,event_chan);
});})(map__19390,map__19390__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",new cljs.core.Keyword(null,"point","point",1813198264),"Polygon",new cljs.core.Keyword(null,"shape","shape",1190694006),"LineString",new cljs.core.Keyword(null,"line","line",212345235)], null).call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__19390,map__19390__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style.call(null,geometry_type,new cljs.core.Keyword(null,"normal","normal",-1519123858));
});})(on_events,geometry_type,map__19390,map__19390__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__19390,map__19390__$1,rezoom_QMARK_){
return (function (p1__19383_SHARP_,p2__19382_SHARP_){
return L.circleMarker(p2__19382_SHARP_);
});})(on_events,geometry_type,stylefn,map__19390,map__19390__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js.call(null,geojson),({"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn}));
var ids = cljs.core.map.call(null,((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__19390,map__19390__$1,rezoom_QMARK_){
return (function (p1__19384_SHARP_){
return cljs.core.get_in.call(null,p1__19384_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"properties","properties",685819552),cljs.core.keyword.call(null,hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__19390,map__19390__$1,rezoom_QMARK_))
,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"feature-layer","feature-layer",2086639246),feature_layer,new cljs.core.Keyword(null,"markers","markers",-246919693),markers,new cljs.core.Keyword(null,"id->marker","id->marker",-1702427771),cljs.core.zipmap.call(null,ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq19385){
var G__19386 = cljs.core.first.call(null,seq19385);
var seq19385__$1 = cljs.core.next.call(null,seq19385);
var G__19387 = cljs.core.first.call(null,seq19385__$1);
var seq19385__$2 = cljs.core.next.call(null,seq19385__$1);
var G__19388 = cljs.core.first.call(null,seq19385__$2);
var seq19385__$3 = cljs.core.next.call(null,seq19385__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__19386,G__19387,G__19388,seq19385__$3);
});

/**
 * Creates a mapboxgl map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_mapboxgl_map = (function hatti$map$utils$create_mapboxgl_map(id){
mapboxgl.accessToken = hatti.constants.mapboxgl_access_token;

var Map = mapboxgl.Map;
var Navigation = mapboxgl.Navigation;
var m = (new Map(({"container": id, "style": "mapbox://styles/mapbox/streets-v9"})));
return m.addControl((new Navigation(({"position": "bottom-left"}))));
});
/**
 * Gets query filter and returns filters based on field type
 */
hatti.map.utils.get_filter = (function hatti$map$utils$get_filter(p__19395,flat_form){
var map__19401 = p__19395;
var map__19401__$1 = ((((!((map__19401 == null)))?((((map__19401.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19401.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19401):map__19401);
var column = cljs.core.get.call(null,map__19401__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var filter = cljs.core.get.call(null,map__19401__$1,new cljs.core.Keyword(null,"filter","filter",-948537934));
var value = cljs.core.get.call(null,map__19401__$1,new cljs.core.Keyword(null,"value","value",305978217));
var field = cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__19401,map__19401__$1,column,filter,value){
return (function (p__19403){
var map__19404 = p__19403;
var map__19404__$1 = ((((!((map__19404 == null)))?((((map__19404.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19404.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19404):map__19404);
var full_name = cljs.core.get.call(null,map__19404__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
return cljs.core._EQ_.call(null,full_name,column);
});})(map__19401,map__19401__$1,column,filter,value))
,flat_form));
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS INT) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS AS TIMESTAMP) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
return [cljs.core.str("json->>'"),cljs.core.str(column),cljs.core.str("' "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');

}
}
});
/**
 * Generates query params filters for filtered datasets 
 */
hatti.map.utils.generate_filter_string = (function hatti$map$utils$generate_filter_string(query,flat_form){
if(cljs.core.truth_(cljs.core.not_empty.call(null,query))){
return [cljs.core.str(" and "),cljs.core.str(clojure.string.join.call(null," and ",cljs.core.map.call(null,(function (p1__19406_SHARP_){
return hatti.map.utils.get_filter.call(null,p1__19406_SHARP_,flat_form);
}),query)))].join('');
} else {
return null;
}
});
/**
 * Generates tiles url with appropriate filters as query params
 */
hatti.map.utils.get_tiles_endpoint = (function hatti$map$utils$get_tiles_endpoint(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19416 = arguments.length;
var i__7485__auto___19417 = (0);
while(true){
if((i__7485__auto___19417 < len__7484__auto___19416)){
args__7491__auto__.push((arguments[i__7485__auto___19417]));

var G__19418 = (i__7485__auto___19417 + (1));
i__7485__auto___19417 = G__19418;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((4) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((4)),(0),null)):null);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7492__auto__);
});

hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic = (function (tiles_server,formid,fields,flat_form,p__19412){
var vec__19413 = p__19412;
var query = cljs.core.nth.call(null,vec__19413,(0),null);
return [cljs.core.str(tiles_server),cljs.core.str(hatti.constants.tiles_endpoint),cljs.core.str("?where=deleted_at is null and xform_id ="),cljs.core.str(formid),cljs.core.str(hatti.map.utils.generate_filter_string.call(null,query,flat_form)),cljs.core.str("&fields="),cljs.core.str(clojure.string.join.call(null,",",fields))].join('');
});

hatti.map.utils.get_tiles_endpoint.cljs$lang$maxFixedArity = (4);

hatti.map.utils.get_tiles_endpoint.cljs$lang$applyTo = (function (seq19407){
var G__19408 = cljs.core.first.call(null,seq19407);
var seq19407__$1 = cljs.core.next.call(null,seq19407);
var G__19409 = cljs.core.first.call(null,seq19407__$1);
var seq19407__$2 = cljs.core.next.call(null,seq19407__$1);
var G__19410 = cljs.core.first.call(null,seq19407__$2);
var seq19407__$3 = cljs.core.next.call(null,seq19407__$2);
var G__19411 = cljs.core.first.call(null,seq19407__$3);
var seq19407__$4 = cljs.core.next.call(null,seq19407__$3);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic(G__19408,G__19409,G__19410,G__19411,seq19407__$4);
});

/**
 * Add map source. This is called with either tiles-url or geoson which
 *   determins the source type (Vector or  GeosJSON). 
 */
hatti.map.utils.add_mapboxgl_source = (function hatti$map$utils$add_mapboxgl_source(map,id_string,p__19419){
var map__19422 = p__19419;
var map__19422__$1 = ((((!((map__19422 == null)))?((((map__19422.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19422.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19422):map__19422);
var tiles_url = cljs.core.get.call(null,map__19422__$1,new cljs.core.Keyword(null,"tiles-url","tiles-url",-1343828944));
var geojson = cljs.core.get.call(null,map__19422__$1,new cljs.core.Keyword(null,"geojson","geojson",-719473398));
var tiles = [tiles_url];
var source = (cljs.core.truth_(geojson)?cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"geojson",new cljs.core.Keyword(null,"data","data",-232669377),geojson], null)):(cljs.core.truth_(tiles)?({"type": "vector", "tiles": tiles}):null));
if(cljs.core.truth_(map.getSource(id_string))){
return null;
} else {
return map.addSource(id_string,source);
}
});
/**
 * Add map layer from available sources.
 */
hatti.map.utils.add_mapboxgl_layer = (function hatti$map$utils$add_mapboxgl_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19432 = arguments.length;
var i__7485__auto___19433 = (0);
while(true){
if((i__7485__auto___19433 < len__7484__auto___19432)){
args__7491__auto__.push((arguments[i__7485__auto___19433]));

var G__19434 = (i__7485__auto___19433 + (1));
i__7485__auto___19433 = G__19434;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id_string,layer_type,p__19428){
var vec__19429 = p__19428;
var layer_id = cljs.core.nth.call(null,vec__19429,(0),null);
var paint_properties = cljs.core.nth.call(null,vec__19429,(1),null);
var l_id = (function (){var or__6409__auto__ = layer_id;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id_string;
}
})();
var layer_def = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"id","id",-1388402092),l_id,new cljs.core.Keyword(null,"type","type",1174270348),layer_type,new cljs.core.Keyword(null,"source","source",-433931539),id_string,new cljs.core.Keyword(null,"source-layer","source-layer",-637591060),"logger_instance_geom"], null);
var layer = cljs.core.clj__GT_js.call(null,(cljs.core.truth_(paint_properties)?cljs.core.assoc.call(null,layer_def,new cljs.core.Keyword(null,"paint","paint",1531901299),paint_properties):layer_def));
if(cljs.core.truth_(map.getLayer(l_id))){
return null;
} else {
return map.addLayer(layer,id_string);
}
});

hatti.map.utils.add_mapboxgl_layer.cljs$lang$maxFixedArity = (3);

hatti.map.utils.add_mapboxgl_layer.cljs$lang$applyTo = (function (seq19424){
var G__19425 = cljs.core.first.call(null,seq19424);
var seq19424__$1 = cljs.core.next.call(null,seq19424);
var G__19426 = cljs.core.first.call(null,seq19424__$1);
var seq19424__$2 = cljs.core.next.call(null,seq19424__$1);
var G__19427 = cljs.core.first.call(null,seq19424__$2);
var seq19424__$3 = cljs.core.next.call(null,seq19424__$2);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(G__19425,G__19426,G__19427,seq19424__$3);
});

/**
 * Generates a collection of input - output value pairs known
 * as stops. These stops are used by get-styles function to decide the style
 * output based on an input vaue from the dataset. e.g. _id. By defauly this
 *  function purely generates color stops.
 */
hatti.map.utils.generate_stops = (function hatti$map$utils$generate_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Generates cirlce size property stops base on values from dataset.
 */
hatti.map.utils.generate_size_stops = (function hatti$map$utils$generate_size_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(4)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Gets predefined styles for diffent layer types and states.
 */
hatti.map.utils.get_styles = (function hatti$map$utils$get_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19440 = arguments.length;
var i__7485__auto___19441 = (0);
while(true){
if((i__7485__auto___19441 < len__7484__auto___19440)){
args__7491__auto__.push((arguments[i__7485__auto___19441]));

var G__19442 = (i__7485__auto___19441 + (1));
i__7485__auto___19441 = G__19442;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic = (function (p__19436){
var vec__19437 = p__19436;
var selected_id = cljs.core.nth.call(null,vec__19437,(0),null);
var stops = cljs.core.nth.call(null,vec__19437,(1),null);
var size_stops = cljs.core.nth.call(null,vec__19437,(2),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"point","point",1813198264),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",(4)], null)], null),new cljs.core.Keyword(null,"hover","hover",-341141711),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#631400")], null))], null)], null),new cljs.core.Keyword(null,"clicked","clicked",114423720),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#ad2300")], null))], null)], null),new cljs.core.Keyword(null,"sized","sized",1886245611),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),(cljs.core.truth_(size_stops)?size_stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(6)], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-opacity",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"stops","stops",-1205459005),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(3),0.2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(15),0.8], null)], null)], null))], null)], null)], null),new cljs.core.Keyword(null,"fill","fill",883462889),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-opacity",0.7], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-outline-color","#666"], null)], null),new cljs.core.Keyword(null,"hover","hover",-341141711),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#631400")], null))], null)], null),new cljs.core.Keyword(null,"clicked","clicked",114423720),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#ad2300")], null))], null)], null)], null)], null);
});

hatti.map.utils.get_styles.cljs$lang$maxFixedArity = (0);

hatti.map.utils.get_styles.cljs$lang$applyTo = (function (seq19435){
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19435));
});

/**
 * Get style properties for layer.
 */
hatti.map.utils.get_style_properties = (function hatti$map$utils$get_style_properties(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19449 = arguments.length;
var i__7485__auto___19450 = (0);
while(true){
if((i__7485__auto___19450 < len__7484__auto___19449)){
args__7491__auto__.push((arguments[i__7485__auto___19450]));

var G__19451 = (i__7485__auto___19450 + (1));
i__7485__auto___19450 = G__19451;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic = (function (style_type,style_state,p__19446){
var map__19447 = p__19446;
var map__19447__$1 = ((((!((map__19447 == null)))?((((map__19447.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19447.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19447):map__19447);
var selected_id = cljs.core.get.call(null,map__19447__$1,new cljs.core.Keyword(null,"selected-id","selected-id",-1028389044));
var stops = cljs.core.get.call(null,map__19447__$1,new cljs.core.Keyword(null,"stops","stops",-1205459005));
return style_state.call(null,style_type.call(null,hatti.map.utils.get_styles.call(null,selected_id,stops)));
});

hatti.map.utils.get_style_properties.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_style_properties.cljs$lang$applyTo = (function (seq19443){
var G__19444 = cljs.core.first.call(null,seq19443);
var seq19443__$1 = cljs.core.next.call(null,seq19443);
var G__19445 = cljs.core.first.call(null,seq19443__$1);
var seq19443__$2 = cljs.core.next.call(null,seq19443__$1);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(G__19444,G__19445,seq19443__$2);
});

/**
 * Sets maps paint properties given layer-id and list of properties to set.
 *   properties should be a list of properties that contains the propery name
 *   and value in a vector. e.g. [[property1 value1] [property2 value2]
 */
hatti.map.utils.set_mapboxgl_paint_property = (function hatti$map$utils$set_mapboxgl_paint_property(map,layer_id,properties){
var seq__19462 = cljs.core.seq.call(null,properties);
var chunk__19463 = null;
var count__19464 = (0);
var i__19465 = (0);
while(true){
if((i__19465 < count__19464)){
var vec__19466 = cljs.core._nth.call(null,chunk__19463,i__19465);
var p = cljs.core.nth.call(null,vec__19466,(0),null);
var v = cljs.core.nth.call(null,vec__19466,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__19472 = seq__19462;
var G__19473 = chunk__19463;
var G__19474 = count__19464;
var G__19475 = (i__19465 + (1));
seq__19462 = G__19472;
chunk__19463 = G__19473;
count__19464 = G__19474;
i__19465 = G__19475;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__19462);
if(temp__4657__auto__){
var seq__19462__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__19462__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__19462__$1);
var G__19476 = cljs.core.chunk_rest.call(null,seq__19462__$1);
var G__19477 = c__7220__auto__;
var G__19478 = cljs.core.count.call(null,c__7220__auto__);
var G__19479 = (0);
seq__19462 = G__19476;
chunk__19463 = G__19477;
count__19464 = G__19478;
i__19465 = G__19479;
continue;
} else {
var vec__19469 = cljs.core.first.call(null,seq__19462__$1);
var p = cljs.core.nth.call(null,vec__19469,(0),null);
var v = cljs.core.nth.call(null,vec__19469,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__19480 = cljs.core.next.call(null,seq__19462__$1);
var G__19481 = null;
var G__19482 = (0);
var G__19483 = (0);
seq__19462 = G__19480;
chunk__19463 = G__19481;
count__19464 = G__19482;
i__19465 = G__19483;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.utils.get_id_property = (function hatti$map$utils$get_id_property(features){
var properties = (cljs.core.first.call(null,features)["properties"]);
var or__6409__auto__ = (properties["id"]);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return (properties[hatti.constants._id]);
}
});
/**
 * Register map mouse events.
 */
hatti.map.utils.register_mapboxgl_mouse_events = (function hatti$map$utils$register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style){
map.off("mousemove");

map.off("click");

map.on("mousemove",(function (e){
var layer_id = id_string;
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"layers","layers",1944875032),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.call(null,owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"map-page","map-page",108547100),new cljs.core.Keyword(null,"view-by","view-by",1005248583)], null));
var selected_id = om.core.get_props.call(null,owner,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"map-page","map-page",108547100),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"id","id",-1388402092)], null));
map.getCanvas().style.cursor = (((features.length > (0)))?"pointer":"");

if(cljs.core.truth_(view_by)){
return null;
} else {
if(cljs.core._EQ_.call(null,no_of_features,(1))){
return hatti.map.utils.set_mapboxgl_paint_property.call(null,map,layer_id,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"hover","hover",-341141711),new cljs.core.Keyword(null,"selected-id","selected-id",-1028389044),hatti.map.utils.get_id_property.call(null,features)));
} else {
hatti.map.utils.set_mapboxgl_paint_property.call(null,map,layer_id,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"normal","normal",-1519123858)));

if(cljs.core.truth_(selected_id)){
return hatti.map.utils.set_mapboxgl_paint_property.call(null,map,layer_id,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"clicked","clicked",114423720),new cljs.core.Keyword(null,"selected-id","selected-id",-1028389044),selected_id));
} else {
return null;
}
}
}
}));

return map.on("click",(function (e){
var layer_id = id_string;
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"layers","layers",1944875032),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.call(null,owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"map-page","map-page",108547100),new cljs.core.Keyword(null,"view-by","view-by",1005248583)], null));
if((no_of_features > (0))){
var feature_id = hatti.map.utils.get_id_property.call(null,features);
cljs.core.async.put_BANG_.call(null,event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mapped-submission-to-id","mapped-submission-to-id",-1148058736),feature_id], null));

if(cljs.core.truth_(view_by)){
return null;
} else {
return hatti.map.utils.set_mapboxgl_paint_property.call(null,map,layer_id,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"clicked","clicked",114423720),new cljs.core.Keyword(null,"selected-id","selected-id",-1028389044),feature_id));
}
} else {
return null;
}
}));
});
/**
 * Fits map boundaries on rendered features.
 */
hatti.map.utils.fitMapBounds = (function hatti$map$utils$fitMapBounds(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19491 = arguments.length;
var i__7485__auto___19492 = (0);
while(true){
if((i__7485__auto___19492 < len__7484__auto___19491)){
args__7491__auto__.push((arguments[i__7485__auto___19492]));

var G__19493 = (i__7485__auto___19492 + (1));
i__7485__auto___19492 = G__19493;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__19487){
var vec__19488 = p__19487;
var geojson = cljs.core.nth.call(null,vec__19488,(0),null);
var features = (function (){var or__6409__auto__ = new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return map.queryRenderedFeatures(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"layers","layers",1944875032),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
}
})();
var layer_data = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"FeatureCollection",new cljs.core.Keyword(null,"features","features",-1146962336),features], null));
}
})();
var bbox = turf.bbox(cljs.core.clj__GT_js.call(null,layer_data));
if((cljs.core.count.call(null,features) > (0))){
return map.fitBounds(bbox,({"padding": "15", "linear": true}));
} else {
return null;
}
});

hatti.map.utils.fitMapBounds.cljs$lang$maxFixedArity = (2);

hatti.map.utils.fitMapBounds.cljs$lang$applyTo = (function (seq19484){
var G__19485 = cljs.core.first.call(null,seq19484);
var seq19484__$1 = cljs.core.next.call(null,seq19484);
var G__19486 = cljs.core.first.call(null,seq19484__$1);
var seq19484__$2 = cljs.core.next.call(null,seq19484__$1);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic(G__19485,G__19486,seq19484__$2);
});

/**
 * Get marker style for field type.
 */
hatti.map.utils.geotype__GT_marker_style = (function hatti$map$utils$geotype__GT_marker_style(field){
if(cljs.core.truth_(hatti.ona.forms.geoshape_QMARK_.call(null,field))){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"layer-type","layer-type",816560917),"fill",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"fill","fill",883462889)], null);
} else {
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_.call(null,field))){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"layer-type","layer-type",816560917),"fill",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"fill","fill",883462889)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"layer-type","layer-type",816560917),"circle",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"point","point",1813198264)], null);

}
}
});
/**
 * Functions that are called after map is loaded in DOM.
 */
hatti.map.utils.map_on_load = (function hatti$map$utils$map_on_load(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19503 = arguments.length;
var i__7485__auto___19504 = (0);
while(true){
if((i__7485__auto___19504 < len__7484__auto___19503)){
args__7491__auto__.push((arguments[i__7485__auto___19504]));

var G__19505 = (i__7485__auto___19504 + (1));
i__7485__auto___19504 = G__19505;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic = (function (map,event_chan,id_string,p__19498){
var map__19499 = p__19498;
var map__19499__$1 = ((((!((map__19499 == null)))?((((map__19499.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19499.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19499):map__19499);
var map_data = map__19499__$1;
var geofield = cljs.core.get.call(null,map__19499__$1,new cljs.core.Keyword(null,"geofield","geofield",578715548));
var owner = cljs.core.get.call(null,map__19499__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var tiles_url = cljs.core.get.call(null,map__19499__$1,new cljs.core.Keyword(null,"tiles-url","tiles-url",-1343828944));
var geojson = cljs.core.get.call(null,map__19499__$1,new cljs.core.Keyword(null,"geojson","geojson",-719473398));
var map__19501 = hatti.map.utils.geotype__GT_marker_style.call(null,geofield);
var map__19501__$1 = ((((!((map__19501 == null)))?((((map__19501.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19501.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19501):map__19501);
var layer_type = cljs.core.get.call(null,map__19501__$1,new cljs.core.Keyword(null,"layer-type","layer-type",816560917));
var style = cljs.core.get.call(null,map__19501__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var stops = om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"stops","stops",-1205459005));
var circle_border = "point-casting";
if(cljs.core.truth_((function (){var or__6409__auto__ = (cljs.core.count.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson)) > (0));
if(or__6409__auto__){
return or__6409__auto__;
} else {
return tiles_url;
}
})())){
hatti.map.utils.add_mapboxgl_source.call(null,map,id_string,map_data);

hatti.map.utils.add_mapboxgl_layer.call(null,map,id_string,layer_type);

hatti.map.utils.register_mapboxgl_mouse_events.call(null,owner,map,event_chan,id_string,style);

hatti.map.utils.set_mapboxgl_paint_property.call(null,map,id_string,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.Keyword(null,"stops","stops",-1205459005),stops));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"point","point",1813198264),style)){
hatti.map.utils.add_mapboxgl_layer.call(null,map,id_string,layer_type,circle_border,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"circle-color","circle-color",-304052871),"#fff",new cljs.core.Keyword(null,"circle-radius","circle-radius",-1126504347),(6)], null));
} else {
if(cljs.core.truth_(map.getLayer(circle_border))){
map.removeLayer(circle_border);
} else {
}
}

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"style","style",-496642736),style);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"loaded?","loaded?",-1108015206),true);
} else {
return null;
}
});

hatti.map.utils.map_on_load.cljs$lang$maxFixedArity = (3);

hatti.map.utils.map_on_load.cljs$lang$applyTo = (function (seq19494){
var G__19495 = cljs.core.first.call(null,seq19494);
var seq19494__$1 = cljs.core.next.call(null,seq19494);
var G__19496 = cljs.core.first.call(null,seq19494__$1);
var seq19494__$2 = cljs.core.next.call(null,seq19494__$1);
var G__19497 = cljs.core.first.call(null,seq19494__$2);
var seq19494__$3 = cljs.core.next.call(null,seq19494__$2);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic(G__19495,G__19496,G__19497,seq19494__$3);
});

/**
 * Set default style
 */
hatti.map.utils.clear_map_styles = (function hatti$map$utils$clear_map_styles(owner){
return hatti.map.utils.set_mapboxgl_paint_property.call(null,om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"mapboxgl-map","mapboxgl-map",1585466246)),om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"layer-id","layer-id",576786958)),hatti.map.utils.get_style_properties.call(null,om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"style","style",-496642736)),new cljs.core.Keyword(null,"normal","normal",-1519123858)));
});
