// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args33033 = [];
var len__7484__auto___33039 = arguments.length;
var i__7485__auto___33040 = (0);
while(true){
if((i__7485__auto___33040 < len__7484__auto___33039)){
args33033.push((arguments[i__7485__auto___33040]));

var G__33041 = (i__7485__auto___33040 + (1));
i__7485__auto___33040 = G__33041;
continue;
} else {
}
break;
}

var G__33035 = args33033.length;
switch (G__33035) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33033.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async33036 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33036 = (function (f,blockable,meta33037){
this.f = f;
this.blockable = blockable;
this.meta33037 = meta33037;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33036.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33038,meta33037__$1){
var self__ = this;
var _33038__$1 = this;
return (new cljs.core.async.t_cljs$core$async33036(self__.f,self__.blockable,meta33037__$1));
});

cljs.core.async.t_cljs$core$async33036.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33038){
var self__ = this;
var _33038__$1 = this;
return self__.meta33037;
});

cljs.core.async.t_cljs$core$async33036.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async33036.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async33036.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async33036.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async33036.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta33037], null);
});

cljs.core.async.t_cljs$core$async33036.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33036.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33036";

cljs.core.async.t_cljs$core$async33036.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33036");
});

cljs.core.async.__GT_t_cljs$core$async33036 = (function cljs$core$async$__GT_t_cljs$core$async33036(f__$1,blockable__$1,meta33037){
return (new cljs.core.async.t_cljs$core$async33036(f__$1,blockable__$1,meta33037));
});

}

return (new cljs.core.async.t_cljs$core$async33036(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args33045 = [];
var len__7484__auto___33048 = arguments.length;
var i__7485__auto___33049 = (0);
while(true){
if((i__7485__auto___33049 < len__7484__auto___33048)){
args33045.push((arguments[i__7485__auto___33049]));

var G__33050 = (i__7485__auto___33049 + (1));
i__7485__auto___33049 = G__33050;
continue;
} else {
}
break;
}

var G__33047 = args33045.length;
switch (G__33047) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33045.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args33052 = [];
var len__7484__auto___33055 = arguments.length;
var i__7485__auto___33056 = (0);
while(true){
if((i__7485__auto___33056 < len__7484__auto___33055)){
args33052.push((arguments[i__7485__auto___33056]));

var G__33057 = (i__7485__auto___33056 + (1));
i__7485__auto___33056 = G__33057;
continue;
} else {
}
break;
}

var G__33054 = args33052.length;
switch (G__33054) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33052.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args33059 = [];
var len__7484__auto___33062 = arguments.length;
var i__7485__auto___33063 = (0);
while(true){
if((i__7485__auto___33063 < len__7484__auto___33062)){
args33059.push((arguments[i__7485__auto___33063]));

var G__33064 = (i__7485__auto___33063 + (1));
i__7485__auto___33063 = G__33064;
continue;
} else {
}
break;
}

var G__33061 = args33059.length;
switch (G__33061) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33059.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_33066 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_33066) : fn1.call(null,val_33066));
} else {
cljs.core.async.impl.dispatch.run(((function (val_33066,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_33066) : fn1.call(null,val_33066));
});})(val_33066,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args33067 = [];
var len__7484__auto___33070 = arguments.length;
var i__7485__auto___33071 = (0);
while(true){
if((i__7485__auto___33071 < len__7484__auto___33070)){
args33067.push((arguments[i__7485__auto___33071]));

var G__33072 = (i__7485__auto___33071 + (1));
i__7485__auto___33071 = G__33072;
continue;
} else {
}
break;
}

var G__33069 = args33067.length;
switch (G__33069) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33067.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___33074 = n;
var x_33075 = (0);
while(true){
if((x_33075 < n__7324__auto___33074)){
(a[x_33075] = (0));

var G__33076 = (x_33075 + (1));
x_33075 = G__33076;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__33077 = (i + (1));
i = G__33077;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async33081 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33081 = (function (alt_flag,flag,meta33082){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta33082 = meta33082;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33081.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_33083,meta33082__$1){
var self__ = this;
var _33083__$1 = this;
return (new cljs.core.async.t_cljs$core$async33081(self__.alt_flag,self__.flag,meta33082__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async33081.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_33083){
var self__ = this;
var _33083__$1 = this;
return self__.meta33082;
});})(flag))
;

cljs.core.async.t_cljs$core$async33081.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async33081.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async33081.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async33081.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async33081.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta33082], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async33081.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33081.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33081";

cljs.core.async.t_cljs$core$async33081.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33081");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async33081 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async33081(alt_flag__$1,flag__$1,meta33082){
return (new cljs.core.async.t_cljs$core$async33081(alt_flag__$1,flag__$1,meta33082));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async33081(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async33087 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33087 = (function (alt_handler,flag,cb,meta33088){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta33088 = meta33088;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33087.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33089,meta33088__$1){
var self__ = this;
var _33089__$1 = this;
return (new cljs.core.async.t_cljs$core$async33087(self__.alt_handler,self__.flag,self__.cb,meta33088__$1));
});

cljs.core.async.t_cljs$core$async33087.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33089){
var self__ = this;
var _33089__$1 = this;
return self__.meta33088;
});

cljs.core.async.t_cljs$core$async33087.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async33087.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async33087.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async33087.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async33087.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta33088], null);
});

cljs.core.async.t_cljs$core$async33087.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33087.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33087";

cljs.core.async.t_cljs$core$async33087.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33087");
});

cljs.core.async.__GT_t_cljs$core$async33087 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async33087(alt_handler__$1,flag__$1,cb__$1,meta33088){
return (new cljs.core.async.t_cljs$core$async33087(alt_handler__$1,flag__$1,cb__$1,meta33088));
});

}

return (new cljs.core.async.t_cljs$core$async33087(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__33090_SHARP_){
var G__33094 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__33090_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__33094) : fret.call(null,G__33094));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__33091_SHARP_){
var G__33095 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__33091_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__33095) : fret.call(null,G__33095));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__33096 = (i + (1));
i = G__33096;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33102 = arguments.length;
var i__7485__auto___33103 = (0);
while(true){
if((i__7485__auto___33103 < len__7484__auto___33102)){
args__7491__auto__.push((arguments[i__7485__auto___33103]));

var G__33104 = (i__7485__auto___33103 + (1));
i__7485__auto___33103 = G__33104;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__33099){
var map__33100 = p__33099;
var map__33100__$1 = ((((!((map__33100 == null)))?((((map__33100.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33100.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33100):map__33100);
var opts = map__33100__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq33097){
var G__33098 = cljs.core.first(seq33097);
var seq33097__$1 = cljs.core.next(seq33097);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33098,seq33097__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args33105 = [];
var len__7484__auto___33155 = arguments.length;
var i__7485__auto___33156 = (0);
while(true){
if((i__7485__auto___33156 < len__7484__auto___33155)){
args33105.push((arguments[i__7485__auto___33156]));

var G__33157 = (i__7485__auto___33156 + (1));
i__7485__auto___33156 = G__33157;
continue;
} else {
}
break;
}

var G__33107 = args33105.length;
switch (G__33107) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33105.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12309__auto___33159 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___33159){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___33159){
return (function (state_33131){
var state_val_33132 = (state_33131[(1)]);
if((state_val_33132 === (7))){
var inst_33127 = (state_33131[(2)]);
var state_33131__$1 = state_33131;
var statearr_33133_33160 = state_33131__$1;
(statearr_33133_33160[(2)] = inst_33127);

(statearr_33133_33160[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33132 === (1))){
var state_33131__$1 = state_33131;
var statearr_33134_33161 = state_33131__$1;
(statearr_33134_33161[(2)] = null);

(statearr_33134_33161[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33132 === (4))){
var inst_33110 = (state_33131[(7)]);
var inst_33110__$1 = (state_33131[(2)]);
var inst_33111 = (inst_33110__$1 == null);
var state_33131__$1 = (function (){var statearr_33135 = state_33131;
(statearr_33135[(7)] = inst_33110__$1);

return statearr_33135;
})();
if(cljs.core.truth_(inst_33111)){
var statearr_33136_33162 = state_33131__$1;
(statearr_33136_33162[(1)] = (5));

} else {
var statearr_33137_33163 = state_33131__$1;
(statearr_33137_33163[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33132 === (13))){
var state_33131__$1 = state_33131;
var statearr_33138_33164 = state_33131__$1;
(statearr_33138_33164[(2)] = null);

(statearr_33138_33164[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33132 === (6))){
var inst_33110 = (state_33131[(7)]);
var state_33131__$1 = state_33131;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33131__$1,(11),to,inst_33110);
} else {
if((state_val_33132 === (3))){
var inst_33129 = (state_33131[(2)]);
var state_33131__$1 = state_33131;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33131__$1,inst_33129);
} else {
if((state_val_33132 === (12))){
var state_33131__$1 = state_33131;
var statearr_33139_33165 = state_33131__$1;
(statearr_33139_33165[(2)] = null);

(statearr_33139_33165[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33132 === (2))){
var state_33131__$1 = state_33131;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33131__$1,(4),from);
} else {
if((state_val_33132 === (11))){
var inst_33120 = (state_33131[(2)]);
var state_33131__$1 = state_33131;
if(cljs.core.truth_(inst_33120)){
var statearr_33140_33166 = state_33131__$1;
(statearr_33140_33166[(1)] = (12));

} else {
var statearr_33141_33167 = state_33131__$1;
(statearr_33141_33167[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33132 === (9))){
var state_33131__$1 = state_33131;
var statearr_33142_33168 = state_33131__$1;
(statearr_33142_33168[(2)] = null);

(statearr_33142_33168[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33132 === (5))){
var state_33131__$1 = state_33131;
if(cljs.core.truth_(close_QMARK_)){
var statearr_33143_33169 = state_33131__$1;
(statearr_33143_33169[(1)] = (8));

} else {
var statearr_33144_33170 = state_33131__$1;
(statearr_33144_33170[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33132 === (14))){
var inst_33125 = (state_33131[(2)]);
var state_33131__$1 = state_33131;
var statearr_33145_33171 = state_33131__$1;
(statearr_33145_33171[(2)] = inst_33125);

(statearr_33145_33171[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33132 === (10))){
var inst_33117 = (state_33131[(2)]);
var state_33131__$1 = state_33131;
var statearr_33146_33172 = state_33131__$1;
(statearr_33146_33172[(2)] = inst_33117);

(statearr_33146_33172[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33132 === (8))){
var inst_33114 = cljs.core.async.close_BANG_(to);
var state_33131__$1 = state_33131;
var statearr_33147_33173 = state_33131__$1;
(statearr_33147_33173[(2)] = inst_33114);

(statearr_33147_33173[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___33159))
;
return ((function (switch__12197__auto__,c__12309__auto___33159){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_33151 = [null,null,null,null,null,null,null,null];
(statearr_33151[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_33151[(1)] = (1));

return statearr_33151;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_33131){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33131);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33152){if((e33152 instanceof Object)){
var ex__12201__auto__ = e33152;
var statearr_33153_33174 = state_33131;
(statearr_33153_33174[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33131);

return cljs.core.cst$kw$recur;
} else {
throw e33152;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33175 = state_33131;
state_33131 = G__33175;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_33131){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_33131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___33159))
})();
var state__12311__auto__ = (function (){var statearr_33154 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33154[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___33159);

return statearr_33154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___33159))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__33363){
var vec__33364 = p__33363;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33364,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33364,(1),null);
var job = vec__33364;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__12309__auto___33550 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___33550,res,vec__33364,v,p,job,jobs,results){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___33550,res,vec__33364,v,p,job,jobs,results){
return (function (state_33371){
var state_val_33372 = (state_33371[(1)]);
if((state_val_33372 === (1))){
var state_33371__$1 = state_33371;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33371__$1,(2),res,v);
} else {
if((state_val_33372 === (2))){
var inst_33368 = (state_33371[(2)]);
var inst_33369 = cljs.core.async.close_BANG_(res);
var state_33371__$1 = (function (){var statearr_33373 = state_33371;
(statearr_33373[(7)] = inst_33368);

return statearr_33373;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33371__$1,inst_33369);
} else {
return null;
}
}
});})(c__12309__auto___33550,res,vec__33364,v,p,job,jobs,results))
;
return ((function (switch__12197__auto__,c__12309__auto___33550,res,vec__33364,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_33377 = [null,null,null,null,null,null,null,null];
(statearr_33377[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_33377[(1)] = (1));

return statearr_33377;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_33371){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33371);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33378){if((e33378 instanceof Object)){
var ex__12201__auto__ = e33378;
var statearr_33379_33551 = state_33371;
(statearr_33379_33551[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33371);

return cljs.core.cst$kw$recur;
} else {
throw e33378;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33552 = state_33371;
state_33371 = G__33552;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_33371){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_33371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___33550,res,vec__33364,v,p,job,jobs,results))
})();
var state__12311__auto__ = (function (){var statearr_33380 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33380[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___33550);

return statearr_33380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___33550,res,vec__33364,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__33381){
var vec__33382 = p__33381;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33382,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33382,(1),null);
var job = vec__33382;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___33553 = n;
var __33554 = (0);
while(true){
if((__33554 < n__7324__auto___33553)){
var G__33385_33555 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__33385_33555) {
case "compute":
var c__12309__auto___33557 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33554,c__12309__auto___33557,G__33385_33555,n__7324__auto___33553,jobs,results,process,async){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (__33554,c__12309__auto___33557,G__33385_33555,n__7324__auto___33553,jobs,results,process,async){
return (function (state_33398){
var state_val_33399 = (state_33398[(1)]);
if((state_val_33399 === (1))){
var state_33398__$1 = state_33398;
var statearr_33400_33558 = state_33398__$1;
(statearr_33400_33558[(2)] = null);

(statearr_33400_33558[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33399 === (2))){
var state_33398__$1 = state_33398;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33398__$1,(4),jobs);
} else {
if((state_val_33399 === (3))){
var inst_33396 = (state_33398[(2)]);
var state_33398__$1 = state_33398;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33398__$1,inst_33396);
} else {
if((state_val_33399 === (4))){
var inst_33388 = (state_33398[(2)]);
var inst_33389 = process(inst_33388);
var state_33398__$1 = state_33398;
if(cljs.core.truth_(inst_33389)){
var statearr_33401_33559 = state_33398__$1;
(statearr_33401_33559[(1)] = (5));

} else {
var statearr_33402_33560 = state_33398__$1;
(statearr_33402_33560[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33399 === (5))){
var state_33398__$1 = state_33398;
var statearr_33403_33561 = state_33398__$1;
(statearr_33403_33561[(2)] = null);

(statearr_33403_33561[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33399 === (6))){
var state_33398__$1 = state_33398;
var statearr_33404_33562 = state_33398__$1;
(statearr_33404_33562[(2)] = null);

(statearr_33404_33562[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33399 === (7))){
var inst_33394 = (state_33398[(2)]);
var state_33398__$1 = state_33398;
var statearr_33405_33563 = state_33398__$1;
(statearr_33405_33563[(2)] = inst_33394);

(statearr_33405_33563[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__33554,c__12309__auto___33557,G__33385_33555,n__7324__auto___33553,jobs,results,process,async))
;
return ((function (__33554,switch__12197__auto__,c__12309__auto___33557,G__33385_33555,n__7324__auto___33553,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_33409 = [null,null,null,null,null,null,null];
(statearr_33409[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_33409[(1)] = (1));

return statearr_33409;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_33398){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33398);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33410){if((e33410 instanceof Object)){
var ex__12201__auto__ = e33410;
var statearr_33411_33564 = state_33398;
(statearr_33411_33564[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33398);

return cljs.core.cst$kw$recur;
} else {
throw e33410;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33565 = state_33398;
state_33398 = G__33565;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_33398){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_33398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(__33554,switch__12197__auto__,c__12309__auto___33557,G__33385_33555,n__7324__auto___33553,jobs,results,process,async))
})();
var state__12311__auto__ = (function (){var statearr_33412 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33412[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___33557);

return statearr_33412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(__33554,c__12309__auto___33557,G__33385_33555,n__7324__auto___33553,jobs,results,process,async))
);


break;
case "async":
var c__12309__auto___33566 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33554,c__12309__auto___33566,G__33385_33555,n__7324__auto___33553,jobs,results,process,async){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (__33554,c__12309__auto___33566,G__33385_33555,n__7324__auto___33553,jobs,results,process,async){
return (function (state_33425){
var state_val_33426 = (state_33425[(1)]);
if((state_val_33426 === (1))){
var state_33425__$1 = state_33425;
var statearr_33427_33567 = state_33425__$1;
(statearr_33427_33567[(2)] = null);

(statearr_33427_33567[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33426 === (2))){
var state_33425__$1 = state_33425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33425__$1,(4),jobs);
} else {
if((state_val_33426 === (3))){
var inst_33423 = (state_33425[(2)]);
var state_33425__$1 = state_33425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33425__$1,inst_33423);
} else {
if((state_val_33426 === (4))){
var inst_33415 = (state_33425[(2)]);
var inst_33416 = async(inst_33415);
var state_33425__$1 = state_33425;
if(cljs.core.truth_(inst_33416)){
var statearr_33428_33568 = state_33425__$1;
(statearr_33428_33568[(1)] = (5));

} else {
var statearr_33429_33569 = state_33425__$1;
(statearr_33429_33569[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33426 === (5))){
var state_33425__$1 = state_33425;
var statearr_33430_33570 = state_33425__$1;
(statearr_33430_33570[(2)] = null);

(statearr_33430_33570[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33426 === (6))){
var state_33425__$1 = state_33425;
var statearr_33431_33571 = state_33425__$1;
(statearr_33431_33571[(2)] = null);

(statearr_33431_33571[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33426 === (7))){
var inst_33421 = (state_33425[(2)]);
var state_33425__$1 = state_33425;
var statearr_33432_33572 = state_33425__$1;
(statearr_33432_33572[(2)] = inst_33421);

(statearr_33432_33572[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__33554,c__12309__auto___33566,G__33385_33555,n__7324__auto___33553,jobs,results,process,async))
;
return ((function (__33554,switch__12197__auto__,c__12309__auto___33566,G__33385_33555,n__7324__auto___33553,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_33436 = [null,null,null,null,null,null,null];
(statearr_33436[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_33436[(1)] = (1));

return statearr_33436;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_33425){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33425);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33437){if((e33437 instanceof Object)){
var ex__12201__auto__ = e33437;
var statearr_33438_33573 = state_33425;
(statearr_33438_33573[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33425);

return cljs.core.cst$kw$recur;
} else {
throw e33437;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33574 = state_33425;
state_33425 = G__33574;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_33425){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_33425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(__33554,switch__12197__auto__,c__12309__auto___33566,G__33385_33555,n__7324__auto___33553,jobs,results,process,async))
})();
var state__12311__auto__ = (function (){var statearr_33439 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33439[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___33566);

return statearr_33439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(__33554,c__12309__auto___33566,G__33385_33555,n__7324__auto___33553,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__33575 = (__33554 + (1));
__33554 = G__33575;
continue;
} else {
}
break;
}

var c__12309__auto___33576 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___33576,jobs,results,process,async){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___33576,jobs,results,process,async){
return (function (state_33461){
var state_val_33462 = (state_33461[(1)]);
if((state_val_33462 === (1))){
var state_33461__$1 = state_33461;
var statearr_33463_33577 = state_33461__$1;
(statearr_33463_33577[(2)] = null);

(statearr_33463_33577[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33462 === (2))){
var state_33461__$1 = state_33461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33461__$1,(4),from);
} else {
if((state_val_33462 === (3))){
var inst_33459 = (state_33461[(2)]);
var state_33461__$1 = state_33461;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33461__$1,inst_33459);
} else {
if((state_val_33462 === (4))){
var inst_33442 = (state_33461[(7)]);
var inst_33442__$1 = (state_33461[(2)]);
var inst_33443 = (inst_33442__$1 == null);
var state_33461__$1 = (function (){var statearr_33464 = state_33461;
(statearr_33464[(7)] = inst_33442__$1);

return statearr_33464;
})();
if(cljs.core.truth_(inst_33443)){
var statearr_33465_33578 = state_33461__$1;
(statearr_33465_33578[(1)] = (5));

} else {
var statearr_33466_33579 = state_33461__$1;
(statearr_33466_33579[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33462 === (5))){
var inst_33445 = cljs.core.async.close_BANG_(jobs);
var state_33461__$1 = state_33461;
var statearr_33467_33580 = state_33461__$1;
(statearr_33467_33580[(2)] = inst_33445);

(statearr_33467_33580[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33462 === (6))){
var inst_33442 = (state_33461[(7)]);
var inst_33447 = (state_33461[(8)]);
var inst_33447__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_33448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33449 = [inst_33442,inst_33447__$1];
var inst_33450 = (new cljs.core.PersistentVector(null,2,(5),inst_33448,inst_33449,null));
var state_33461__$1 = (function (){var statearr_33468 = state_33461;
(statearr_33468[(8)] = inst_33447__$1);

return statearr_33468;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33461__$1,(8),jobs,inst_33450);
} else {
if((state_val_33462 === (7))){
var inst_33457 = (state_33461[(2)]);
var state_33461__$1 = state_33461;
var statearr_33469_33581 = state_33461__$1;
(statearr_33469_33581[(2)] = inst_33457);

(statearr_33469_33581[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33462 === (8))){
var inst_33447 = (state_33461[(8)]);
var inst_33452 = (state_33461[(2)]);
var state_33461__$1 = (function (){var statearr_33470 = state_33461;
(statearr_33470[(9)] = inst_33452);

return statearr_33470;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33461__$1,(9),results,inst_33447);
} else {
if((state_val_33462 === (9))){
var inst_33454 = (state_33461[(2)]);
var state_33461__$1 = (function (){var statearr_33471 = state_33461;
(statearr_33471[(10)] = inst_33454);

return statearr_33471;
})();
var statearr_33472_33582 = state_33461__$1;
(statearr_33472_33582[(2)] = null);

(statearr_33472_33582[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___33576,jobs,results,process,async))
;
return ((function (switch__12197__auto__,c__12309__auto___33576,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_33476 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33476[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_33476[(1)] = (1));

return statearr_33476;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_33461){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33461);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33477){if((e33477 instanceof Object)){
var ex__12201__auto__ = e33477;
var statearr_33478_33583 = state_33461;
(statearr_33478_33583[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33461);

return cljs.core.cst$kw$recur;
} else {
throw e33477;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33584 = state_33461;
state_33461 = G__33584;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_33461){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_33461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___33576,jobs,results,process,async))
})();
var state__12311__auto__ = (function (){var statearr_33479 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33479[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___33576);

return statearr_33479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___33576,jobs,results,process,async))
);


var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__,jobs,results,process,async){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__,jobs,results,process,async){
return (function (state_33517){
var state_val_33518 = (state_33517[(1)]);
if((state_val_33518 === (7))){
var inst_33513 = (state_33517[(2)]);
var state_33517__$1 = state_33517;
var statearr_33519_33585 = state_33517__$1;
(statearr_33519_33585[(2)] = inst_33513);

(statearr_33519_33585[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (20))){
var state_33517__$1 = state_33517;
var statearr_33520_33586 = state_33517__$1;
(statearr_33520_33586[(2)] = null);

(statearr_33520_33586[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (1))){
var state_33517__$1 = state_33517;
var statearr_33521_33587 = state_33517__$1;
(statearr_33521_33587[(2)] = null);

(statearr_33521_33587[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (4))){
var inst_33482 = (state_33517[(7)]);
var inst_33482__$1 = (state_33517[(2)]);
var inst_33483 = (inst_33482__$1 == null);
var state_33517__$1 = (function (){var statearr_33522 = state_33517;
(statearr_33522[(7)] = inst_33482__$1);

return statearr_33522;
})();
if(cljs.core.truth_(inst_33483)){
var statearr_33523_33588 = state_33517__$1;
(statearr_33523_33588[(1)] = (5));

} else {
var statearr_33524_33589 = state_33517__$1;
(statearr_33524_33589[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (15))){
var inst_33495 = (state_33517[(8)]);
var state_33517__$1 = state_33517;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33517__$1,(18),to,inst_33495);
} else {
if((state_val_33518 === (21))){
var inst_33508 = (state_33517[(2)]);
var state_33517__$1 = state_33517;
var statearr_33525_33590 = state_33517__$1;
(statearr_33525_33590[(2)] = inst_33508);

(statearr_33525_33590[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (13))){
var inst_33510 = (state_33517[(2)]);
var state_33517__$1 = (function (){var statearr_33526 = state_33517;
(statearr_33526[(9)] = inst_33510);

return statearr_33526;
})();
var statearr_33527_33591 = state_33517__$1;
(statearr_33527_33591[(2)] = null);

(statearr_33527_33591[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (6))){
var inst_33482 = (state_33517[(7)]);
var state_33517__$1 = state_33517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33517__$1,(11),inst_33482);
} else {
if((state_val_33518 === (17))){
var inst_33503 = (state_33517[(2)]);
var state_33517__$1 = state_33517;
if(cljs.core.truth_(inst_33503)){
var statearr_33528_33592 = state_33517__$1;
(statearr_33528_33592[(1)] = (19));

} else {
var statearr_33529_33593 = state_33517__$1;
(statearr_33529_33593[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (3))){
var inst_33515 = (state_33517[(2)]);
var state_33517__$1 = state_33517;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33517__$1,inst_33515);
} else {
if((state_val_33518 === (12))){
var inst_33492 = (state_33517[(10)]);
var state_33517__$1 = state_33517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33517__$1,(14),inst_33492);
} else {
if((state_val_33518 === (2))){
var state_33517__$1 = state_33517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33517__$1,(4),results);
} else {
if((state_val_33518 === (19))){
var state_33517__$1 = state_33517;
var statearr_33530_33594 = state_33517__$1;
(statearr_33530_33594[(2)] = null);

(statearr_33530_33594[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (11))){
var inst_33492 = (state_33517[(2)]);
var state_33517__$1 = (function (){var statearr_33531 = state_33517;
(statearr_33531[(10)] = inst_33492);

return statearr_33531;
})();
var statearr_33532_33595 = state_33517__$1;
(statearr_33532_33595[(2)] = null);

(statearr_33532_33595[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (9))){
var state_33517__$1 = state_33517;
var statearr_33533_33596 = state_33517__$1;
(statearr_33533_33596[(2)] = null);

(statearr_33533_33596[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (5))){
var state_33517__$1 = state_33517;
if(cljs.core.truth_(close_QMARK_)){
var statearr_33534_33597 = state_33517__$1;
(statearr_33534_33597[(1)] = (8));

} else {
var statearr_33535_33598 = state_33517__$1;
(statearr_33535_33598[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (14))){
var inst_33495 = (state_33517[(8)]);
var inst_33497 = (state_33517[(11)]);
var inst_33495__$1 = (state_33517[(2)]);
var inst_33496 = (inst_33495__$1 == null);
var inst_33497__$1 = cljs.core.not(inst_33496);
var state_33517__$1 = (function (){var statearr_33536 = state_33517;
(statearr_33536[(8)] = inst_33495__$1);

(statearr_33536[(11)] = inst_33497__$1);

return statearr_33536;
})();
if(inst_33497__$1){
var statearr_33537_33599 = state_33517__$1;
(statearr_33537_33599[(1)] = (15));

} else {
var statearr_33538_33600 = state_33517__$1;
(statearr_33538_33600[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (16))){
var inst_33497 = (state_33517[(11)]);
var state_33517__$1 = state_33517;
var statearr_33539_33601 = state_33517__$1;
(statearr_33539_33601[(2)] = inst_33497);

(statearr_33539_33601[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (10))){
var inst_33489 = (state_33517[(2)]);
var state_33517__$1 = state_33517;
var statearr_33540_33602 = state_33517__$1;
(statearr_33540_33602[(2)] = inst_33489);

(statearr_33540_33602[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (18))){
var inst_33500 = (state_33517[(2)]);
var state_33517__$1 = state_33517;
var statearr_33541_33603 = state_33517__$1;
(statearr_33541_33603[(2)] = inst_33500);

(statearr_33541_33603[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33518 === (8))){
var inst_33486 = cljs.core.async.close_BANG_(to);
var state_33517__$1 = state_33517;
var statearr_33542_33604 = state_33517__$1;
(statearr_33542_33604[(2)] = inst_33486);

(statearr_33542_33604[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__,jobs,results,process,async))
;
return ((function (switch__12197__auto__,c__12309__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_33546 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33546[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_33546[(1)] = (1));

return statearr_33546;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_33517){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33517);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33547){if((e33547 instanceof Object)){
var ex__12201__auto__ = e33547;
var statearr_33548_33605 = state_33517;
(statearr_33548_33605[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33517);

return cljs.core.cst$kw$recur;
} else {
throw e33547;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33606 = state_33517;
state_33517 = G__33606;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_33517){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_33517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__,jobs,results,process,async))
})();
var state__12311__auto__ = (function (){var statearr_33549 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33549[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_33549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__,jobs,results,process,async))
);

return c__12309__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args33607 = [];
var len__7484__auto___33610 = arguments.length;
var i__7485__auto___33611 = (0);
while(true){
if((i__7485__auto___33611 < len__7484__auto___33610)){
args33607.push((arguments[i__7485__auto___33611]));

var G__33612 = (i__7485__auto___33611 + (1));
i__7485__auto___33611 = G__33612;
continue;
} else {
}
break;
}

var G__33609 = args33607.length;
switch (G__33609) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33607.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args33614 = [];
var len__7484__auto___33617 = arguments.length;
var i__7485__auto___33618 = (0);
while(true){
if((i__7485__auto___33618 < len__7484__auto___33617)){
args33614.push((arguments[i__7485__auto___33618]));

var G__33619 = (i__7485__auto___33618 + (1));
i__7485__auto___33618 = G__33619;
continue;
} else {
}
break;
}

var G__33616 = args33614.length;
switch (G__33616) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33614.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args33621 = [];
var len__7484__auto___33674 = arguments.length;
var i__7485__auto___33675 = (0);
while(true){
if((i__7485__auto___33675 < len__7484__auto___33674)){
args33621.push((arguments[i__7485__auto___33675]));

var G__33676 = (i__7485__auto___33675 + (1));
i__7485__auto___33675 = G__33676;
continue;
} else {
}
break;
}

var G__33623 = args33621.length;
switch (G__33623) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33621.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__12309__auto___33678 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___33678,tc,fc){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___33678,tc,fc){
return (function (state_33649){
var state_val_33650 = (state_33649[(1)]);
if((state_val_33650 === (7))){
var inst_33645 = (state_33649[(2)]);
var state_33649__$1 = state_33649;
var statearr_33651_33679 = state_33649__$1;
(statearr_33651_33679[(2)] = inst_33645);

(statearr_33651_33679[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33650 === (1))){
var state_33649__$1 = state_33649;
var statearr_33652_33680 = state_33649__$1;
(statearr_33652_33680[(2)] = null);

(statearr_33652_33680[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33650 === (4))){
var inst_33626 = (state_33649[(7)]);
var inst_33626__$1 = (state_33649[(2)]);
var inst_33627 = (inst_33626__$1 == null);
var state_33649__$1 = (function (){var statearr_33653 = state_33649;
(statearr_33653[(7)] = inst_33626__$1);

return statearr_33653;
})();
if(cljs.core.truth_(inst_33627)){
var statearr_33654_33681 = state_33649__$1;
(statearr_33654_33681[(1)] = (5));

} else {
var statearr_33655_33682 = state_33649__$1;
(statearr_33655_33682[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33650 === (13))){
var state_33649__$1 = state_33649;
var statearr_33656_33683 = state_33649__$1;
(statearr_33656_33683[(2)] = null);

(statearr_33656_33683[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33650 === (6))){
var inst_33626 = (state_33649[(7)]);
var inst_33632 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33626) : p.call(null,inst_33626));
var state_33649__$1 = state_33649;
if(cljs.core.truth_(inst_33632)){
var statearr_33657_33684 = state_33649__$1;
(statearr_33657_33684[(1)] = (9));

} else {
var statearr_33658_33685 = state_33649__$1;
(statearr_33658_33685[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33650 === (3))){
var inst_33647 = (state_33649[(2)]);
var state_33649__$1 = state_33649;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33649__$1,inst_33647);
} else {
if((state_val_33650 === (12))){
var state_33649__$1 = state_33649;
var statearr_33659_33686 = state_33649__$1;
(statearr_33659_33686[(2)] = null);

(statearr_33659_33686[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33650 === (2))){
var state_33649__$1 = state_33649;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33649__$1,(4),ch);
} else {
if((state_val_33650 === (11))){
var inst_33626 = (state_33649[(7)]);
var inst_33636 = (state_33649[(2)]);
var state_33649__$1 = state_33649;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33649__$1,(8),inst_33636,inst_33626);
} else {
if((state_val_33650 === (9))){
var state_33649__$1 = state_33649;
var statearr_33660_33687 = state_33649__$1;
(statearr_33660_33687[(2)] = tc);

(statearr_33660_33687[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33650 === (5))){
var inst_33629 = cljs.core.async.close_BANG_(tc);
var inst_33630 = cljs.core.async.close_BANG_(fc);
var state_33649__$1 = (function (){var statearr_33661 = state_33649;
(statearr_33661[(8)] = inst_33629);

return statearr_33661;
})();
var statearr_33662_33688 = state_33649__$1;
(statearr_33662_33688[(2)] = inst_33630);

(statearr_33662_33688[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33650 === (14))){
var inst_33643 = (state_33649[(2)]);
var state_33649__$1 = state_33649;
var statearr_33663_33689 = state_33649__$1;
(statearr_33663_33689[(2)] = inst_33643);

(statearr_33663_33689[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33650 === (10))){
var state_33649__$1 = state_33649;
var statearr_33664_33690 = state_33649__$1;
(statearr_33664_33690[(2)] = fc);

(statearr_33664_33690[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33650 === (8))){
var inst_33638 = (state_33649[(2)]);
var state_33649__$1 = state_33649;
if(cljs.core.truth_(inst_33638)){
var statearr_33665_33691 = state_33649__$1;
(statearr_33665_33691[(1)] = (12));

} else {
var statearr_33666_33692 = state_33649__$1;
(statearr_33666_33692[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___33678,tc,fc))
;
return ((function (switch__12197__auto__,c__12309__auto___33678,tc,fc){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_33670 = [null,null,null,null,null,null,null,null,null];
(statearr_33670[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_33670[(1)] = (1));

return statearr_33670;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_33649){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33649);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33671){if((e33671 instanceof Object)){
var ex__12201__auto__ = e33671;
var statearr_33672_33693 = state_33649;
(statearr_33672_33693[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33649);

return cljs.core.cst$kw$recur;
} else {
throw e33671;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33694 = state_33649;
state_33649 = G__33694;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_33649){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_33649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___33678,tc,fc))
})();
var state__12311__auto__ = (function (){var statearr_33673 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33673[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___33678);

return statearr_33673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___33678,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__){
return (function (state_33758){
var state_val_33759 = (state_33758[(1)]);
if((state_val_33759 === (7))){
var inst_33754 = (state_33758[(2)]);
var state_33758__$1 = state_33758;
var statearr_33760_33781 = state_33758__$1;
(statearr_33760_33781[(2)] = inst_33754);

(statearr_33760_33781[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33759 === (1))){
var inst_33738 = init;
var state_33758__$1 = (function (){var statearr_33761 = state_33758;
(statearr_33761[(7)] = inst_33738);

return statearr_33761;
})();
var statearr_33762_33782 = state_33758__$1;
(statearr_33762_33782[(2)] = null);

(statearr_33762_33782[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33759 === (4))){
var inst_33741 = (state_33758[(8)]);
var inst_33741__$1 = (state_33758[(2)]);
var inst_33742 = (inst_33741__$1 == null);
var state_33758__$1 = (function (){var statearr_33763 = state_33758;
(statearr_33763[(8)] = inst_33741__$1);

return statearr_33763;
})();
if(cljs.core.truth_(inst_33742)){
var statearr_33764_33783 = state_33758__$1;
(statearr_33764_33783[(1)] = (5));

} else {
var statearr_33765_33784 = state_33758__$1;
(statearr_33765_33784[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33759 === (6))){
var inst_33745 = (state_33758[(9)]);
var inst_33738 = (state_33758[(7)]);
var inst_33741 = (state_33758[(8)]);
var inst_33745__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_33738,inst_33741) : f.call(null,inst_33738,inst_33741));
var inst_33746 = cljs.core.reduced_QMARK_(inst_33745__$1);
var state_33758__$1 = (function (){var statearr_33766 = state_33758;
(statearr_33766[(9)] = inst_33745__$1);

return statearr_33766;
})();
if(inst_33746){
var statearr_33767_33785 = state_33758__$1;
(statearr_33767_33785[(1)] = (8));

} else {
var statearr_33768_33786 = state_33758__$1;
(statearr_33768_33786[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33759 === (3))){
var inst_33756 = (state_33758[(2)]);
var state_33758__$1 = state_33758;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33758__$1,inst_33756);
} else {
if((state_val_33759 === (2))){
var state_33758__$1 = state_33758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33758__$1,(4),ch);
} else {
if((state_val_33759 === (9))){
var inst_33745 = (state_33758[(9)]);
var inst_33738 = inst_33745;
var state_33758__$1 = (function (){var statearr_33769 = state_33758;
(statearr_33769[(7)] = inst_33738);

return statearr_33769;
})();
var statearr_33770_33787 = state_33758__$1;
(statearr_33770_33787[(2)] = null);

(statearr_33770_33787[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33759 === (5))){
var inst_33738 = (state_33758[(7)]);
var state_33758__$1 = state_33758;
var statearr_33771_33788 = state_33758__$1;
(statearr_33771_33788[(2)] = inst_33738);

(statearr_33771_33788[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33759 === (10))){
var inst_33752 = (state_33758[(2)]);
var state_33758__$1 = state_33758;
var statearr_33772_33789 = state_33758__$1;
(statearr_33772_33789[(2)] = inst_33752);

(statearr_33772_33789[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33759 === (8))){
var inst_33745 = (state_33758[(9)]);
var inst_33748 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_33745) : cljs.core.deref.call(null,inst_33745));
var state_33758__$1 = state_33758;
var statearr_33773_33790 = state_33758__$1;
(statearr_33773_33790[(2)] = inst_33748);

(statearr_33773_33790[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__))
;
return ((function (switch__12197__auto__,c__12309__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__12198__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12198__auto____0 = (function (){
var statearr_33777 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33777[(0)] = cljs$core$async$reduce_$_state_machine__12198__auto__);

(statearr_33777[(1)] = (1));

return statearr_33777;
});
var cljs$core$async$reduce_$_state_machine__12198__auto____1 = (function (state_33758){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33758);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33778){if((e33778 instanceof Object)){
var ex__12201__auto__ = e33778;
var statearr_33779_33791 = state_33758;
(statearr_33779_33791[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33758);

return cljs.core.cst$kw$recur;
} else {
throw e33778;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33792 = state_33758;
state_33758 = G__33792;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12198__auto__ = function(state_33758){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12198__auto____1.call(this,state_33758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12198__auto____0;
cljs$core$async$reduce_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12198__auto____1;
return cljs$core$async$reduce_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__))
})();
var state__12311__auto__ = (function (){var statearr_33780 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33780[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_33780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__))
);

return c__12309__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__,f__$1){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__,f__$1){
return (function (state_33812){
var state_val_33813 = (state_33812[(1)]);
if((state_val_33813 === (1))){
var inst_33807 = cljs.core.async.reduce(f__$1,init,ch);
var state_33812__$1 = state_33812;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33812__$1,(2),inst_33807);
} else {
if((state_val_33813 === (2))){
var inst_33809 = (state_33812[(2)]);
var inst_33810 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_33809) : f__$1.call(null,inst_33809));
var state_33812__$1 = state_33812;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33812__$1,inst_33810);
} else {
return null;
}
}
});})(c__12309__auto__,f__$1))
;
return ((function (switch__12197__auto__,c__12309__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__12198__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12198__auto____0 = (function (){
var statearr_33817 = [null,null,null,null,null,null,null];
(statearr_33817[(0)] = cljs$core$async$transduce_$_state_machine__12198__auto__);

(statearr_33817[(1)] = (1));

return statearr_33817;
});
var cljs$core$async$transduce_$_state_machine__12198__auto____1 = (function (state_33812){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33812);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33818){if((e33818 instanceof Object)){
var ex__12201__auto__ = e33818;
var statearr_33819_33821 = state_33812;
(statearr_33819_33821[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33812);

return cljs.core.cst$kw$recur;
} else {
throw e33818;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33822 = state_33812;
state_33812 = G__33822;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12198__auto__ = function(state_33812){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12198__auto____1.call(this,state_33812);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12198__auto____0;
cljs$core$async$transduce_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12198__auto____1;
return cljs$core$async$transduce_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__,f__$1))
})();
var state__12311__auto__ = (function (){var statearr_33820 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33820[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_33820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__,f__$1))
);

return c__12309__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args33823 = [];
var len__7484__auto___33875 = arguments.length;
var i__7485__auto___33876 = (0);
while(true){
if((i__7485__auto___33876 < len__7484__auto___33875)){
args33823.push((arguments[i__7485__auto___33876]));

var G__33877 = (i__7485__auto___33876 + (1));
i__7485__auto___33876 = G__33877;
continue;
} else {
}
break;
}

var G__33825 = args33823.length;
switch (G__33825) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33823.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__){
return (function (state_33850){
var state_val_33851 = (state_33850[(1)]);
if((state_val_33851 === (7))){
var inst_33832 = (state_33850[(2)]);
var state_33850__$1 = state_33850;
var statearr_33852_33879 = state_33850__$1;
(statearr_33852_33879[(2)] = inst_33832);

(statearr_33852_33879[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33851 === (1))){
var inst_33826 = cljs.core.seq(coll);
var inst_33827 = inst_33826;
var state_33850__$1 = (function (){var statearr_33853 = state_33850;
(statearr_33853[(7)] = inst_33827);

return statearr_33853;
})();
var statearr_33854_33880 = state_33850__$1;
(statearr_33854_33880[(2)] = null);

(statearr_33854_33880[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33851 === (4))){
var inst_33827 = (state_33850[(7)]);
var inst_33830 = cljs.core.first(inst_33827);
var state_33850__$1 = state_33850;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33850__$1,(7),ch,inst_33830);
} else {
if((state_val_33851 === (13))){
var inst_33844 = (state_33850[(2)]);
var state_33850__$1 = state_33850;
var statearr_33855_33881 = state_33850__$1;
(statearr_33855_33881[(2)] = inst_33844);

(statearr_33855_33881[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33851 === (6))){
var inst_33835 = (state_33850[(2)]);
var state_33850__$1 = state_33850;
if(cljs.core.truth_(inst_33835)){
var statearr_33856_33882 = state_33850__$1;
(statearr_33856_33882[(1)] = (8));

} else {
var statearr_33857_33883 = state_33850__$1;
(statearr_33857_33883[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33851 === (3))){
var inst_33848 = (state_33850[(2)]);
var state_33850__$1 = state_33850;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33850__$1,inst_33848);
} else {
if((state_val_33851 === (12))){
var state_33850__$1 = state_33850;
var statearr_33858_33884 = state_33850__$1;
(statearr_33858_33884[(2)] = null);

(statearr_33858_33884[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33851 === (2))){
var inst_33827 = (state_33850[(7)]);
var state_33850__$1 = state_33850;
if(cljs.core.truth_(inst_33827)){
var statearr_33859_33885 = state_33850__$1;
(statearr_33859_33885[(1)] = (4));

} else {
var statearr_33860_33886 = state_33850__$1;
(statearr_33860_33886[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33851 === (11))){
var inst_33841 = cljs.core.async.close_BANG_(ch);
var state_33850__$1 = state_33850;
var statearr_33861_33887 = state_33850__$1;
(statearr_33861_33887[(2)] = inst_33841);

(statearr_33861_33887[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33851 === (9))){
var state_33850__$1 = state_33850;
if(cljs.core.truth_(close_QMARK_)){
var statearr_33862_33888 = state_33850__$1;
(statearr_33862_33888[(1)] = (11));

} else {
var statearr_33863_33889 = state_33850__$1;
(statearr_33863_33889[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33851 === (5))){
var inst_33827 = (state_33850[(7)]);
var state_33850__$1 = state_33850;
var statearr_33864_33890 = state_33850__$1;
(statearr_33864_33890[(2)] = inst_33827);

(statearr_33864_33890[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33851 === (10))){
var inst_33846 = (state_33850[(2)]);
var state_33850__$1 = state_33850;
var statearr_33865_33891 = state_33850__$1;
(statearr_33865_33891[(2)] = inst_33846);

(statearr_33865_33891[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33851 === (8))){
var inst_33827 = (state_33850[(7)]);
var inst_33837 = cljs.core.next(inst_33827);
var inst_33827__$1 = inst_33837;
var state_33850__$1 = (function (){var statearr_33866 = state_33850;
(statearr_33866[(7)] = inst_33827__$1);

return statearr_33866;
})();
var statearr_33867_33892 = state_33850__$1;
(statearr_33867_33892[(2)] = null);

(statearr_33867_33892[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__))
;
return ((function (switch__12197__auto__,c__12309__auto__){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_33871 = [null,null,null,null,null,null,null,null];
(statearr_33871[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_33871[(1)] = (1));

return statearr_33871;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_33850){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33850);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33872){if((e33872 instanceof Object)){
var ex__12201__auto__ = e33872;
var statearr_33873_33893 = state_33850;
(statearr_33873_33893[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33850);

return cljs.core.cst$kw$recur;
} else {
throw e33872;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33894 = state_33850;
state_33850 = G__33894;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_33850){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_33850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__))
})();
var state__12311__auto__ = (function (){var statearr_33874 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33874[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_33874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__))
);

return c__12309__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7073__auto__.call(null,_));
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7073__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7073__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7073__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto__.call(null,m));
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__34123 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__34123) : cljs.core.atom.call(null,G__34123));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async34124 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34124 = (function (mult,ch,cs,meta34125){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta34125 = meta34125;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34124.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_34126,meta34125__$1){
var self__ = this;
var _34126__$1 = this;
return (new cljs.core.async.t_cljs$core$async34124(self__.mult,self__.ch,self__.cs,meta34125__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async34124.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_34126){
var self__ = this;
var _34126__$1 = this;
return self__.meta34125;
});})(cs))
;

cljs.core.async.t_cljs$core$async34124.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async34124.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async34124.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async34124.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34124.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34124.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__34127_34351 = self__.cs;
var G__34128_34352 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__34127_34351,G__34128_34352) : cljs.core.reset_BANG_.call(null,G__34127_34351,G__34128_34352));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34124.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta34125], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async34124.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34124.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34124";

cljs.core.async.t_cljs$core$async34124.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async34124");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async34124 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async34124(mult__$1,ch__$1,cs__$1,meta34125){
return (new cljs.core.async.t_cljs$core$async34124(mult__$1,ch__$1,cs__$1,meta34125));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async34124(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__12309__auto___34353 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___34353,cs,m,dchan,dctr,done){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___34353,cs,m,dchan,dctr,done){
return (function (state_34263){
var state_val_34264 = (state_34263[(1)]);
if((state_val_34264 === (7))){
var inst_34259 = (state_34263[(2)]);
var state_34263__$1 = state_34263;
var statearr_34265_34354 = state_34263__$1;
(statearr_34265_34354[(2)] = inst_34259);

(statearr_34265_34354[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (20))){
var inst_34162 = (state_34263[(7)]);
var inst_34174 = cljs.core.first(inst_34162);
var inst_34175 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34174,(0),null);
var inst_34176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34174,(1),null);
var state_34263__$1 = (function (){var statearr_34266 = state_34263;
(statearr_34266[(8)] = inst_34175);

return statearr_34266;
})();
if(cljs.core.truth_(inst_34176)){
var statearr_34267_34355 = state_34263__$1;
(statearr_34267_34355[(1)] = (22));

} else {
var statearr_34268_34356 = state_34263__$1;
(statearr_34268_34356[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (27))){
var inst_34211 = (state_34263[(9)]);
var inst_34206 = (state_34263[(10)]);
var inst_34204 = (state_34263[(11)]);
var inst_34131 = (state_34263[(12)]);
var inst_34211__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_34204,inst_34206);
var inst_34212 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_34211__$1,inst_34131,done);
var state_34263__$1 = (function (){var statearr_34269 = state_34263;
(statearr_34269[(9)] = inst_34211__$1);

return statearr_34269;
})();
if(cljs.core.truth_(inst_34212)){
var statearr_34270_34357 = state_34263__$1;
(statearr_34270_34357[(1)] = (30));

} else {
var statearr_34271_34358 = state_34263__$1;
(statearr_34271_34358[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (1))){
var state_34263__$1 = state_34263;
var statearr_34272_34359 = state_34263__$1;
(statearr_34272_34359[(2)] = null);

(statearr_34272_34359[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (24))){
var inst_34162 = (state_34263[(7)]);
var inst_34181 = (state_34263[(2)]);
var inst_34182 = cljs.core.next(inst_34162);
var inst_34140 = inst_34182;
var inst_34141 = null;
var inst_34142 = (0);
var inst_34143 = (0);
var state_34263__$1 = (function (){var statearr_34273 = state_34263;
(statearr_34273[(13)] = inst_34142);

(statearr_34273[(14)] = inst_34140);

(statearr_34273[(15)] = inst_34181);

(statearr_34273[(16)] = inst_34141);

(statearr_34273[(17)] = inst_34143);

return statearr_34273;
})();
var statearr_34274_34360 = state_34263__$1;
(statearr_34274_34360[(2)] = null);

(statearr_34274_34360[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (39))){
var state_34263__$1 = state_34263;
var statearr_34278_34361 = state_34263__$1;
(statearr_34278_34361[(2)] = null);

(statearr_34278_34361[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (4))){
var inst_34131 = (state_34263[(12)]);
var inst_34131__$1 = (state_34263[(2)]);
var inst_34132 = (inst_34131__$1 == null);
var state_34263__$1 = (function (){var statearr_34279 = state_34263;
(statearr_34279[(12)] = inst_34131__$1);

return statearr_34279;
})();
if(cljs.core.truth_(inst_34132)){
var statearr_34280_34362 = state_34263__$1;
(statearr_34280_34362[(1)] = (5));

} else {
var statearr_34281_34363 = state_34263__$1;
(statearr_34281_34363[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (15))){
var inst_34142 = (state_34263[(13)]);
var inst_34140 = (state_34263[(14)]);
var inst_34141 = (state_34263[(16)]);
var inst_34143 = (state_34263[(17)]);
var inst_34158 = (state_34263[(2)]);
var inst_34159 = (inst_34143 + (1));
var tmp34275 = inst_34142;
var tmp34276 = inst_34140;
var tmp34277 = inst_34141;
var inst_34140__$1 = tmp34276;
var inst_34141__$1 = tmp34277;
var inst_34142__$1 = tmp34275;
var inst_34143__$1 = inst_34159;
var state_34263__$1 = (function (){var statearr_34282 = state_34263;
(statearr_34282[(18)] = inst_34158);

(statearr_34282[(13)] = inst_34142__$1);

(statearr_34282[(14)] = inst_34140__$1);

(statearr_34282[(16)] = inst_34141__$1);

(statearr_34282[(17)] = inst_34143__$1);

return statearr_34282;
})();
var statearr_34283_34364 = state_34263__$1;
(statearr_34283_34364[(2)] = null);

(statearr_34283_34364[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (21))){
var inst_34185 = (state_34263[(2)]);
var state_34263__$1 = state_34263;
var statearr_34287_34365 = state_34263__$1;
(statearr_34287_34365[(2)] = inst_34185);

(statearr_34287_34365[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (31))){
var inst_34211 = (state_34263[(9)]);
var inst_34215 = done(null);
var inst_34216 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_34211);
var state_34263__$1 = (function (){var statearr_34288 = state_34263;
(statearr_34288[(19)] = inst_34215);

return statearr_34288;
})();
var statearr_34289_34366 = state_34263__$1;
(statearr_34289_34366[(2)] = inst_34216);

(statearr_34289_34366[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (32))){
var inst_34203 = (state_34263[(20)]);
var inst_34205 = (state_34263[(21)]);
var inst_34206 = (state_34263[(10)]);
var inst_34204 = (state_34263[(11)]);
var inst_34218 = (state_34263[(2)]);
var inst_34219 = (inst_34206 + (1));
var tmp34284 = inst_34203;
var tmp34285 = inst_34205;
var tmp34286 = inst_34204;
var inst_34203__$1 = tmp34284;
var inst_34204__$1 = tmp34286;
var inst_34205__$1 = tmp34285;
var inst_34206__$1 = inst_34219;
var state_34263__$1 = (function (){var statearr_34290 = state_34263;
(statearr_34290[(20)] = inst_34203__$1);

(statearr_34290[(22)] = inst_34218);

(statearr_34290[(21)] = inst_34205__$1);

(statearr_34290[(10)] = inst_34206__$1);

(statearr_34290[(11)] = inst_34204__$1);

return statearr_34290;
})();
var statearr_34291_34367 = state_34263__$1;
(statearr_34291_34367[(2)] = null);

(statearr_34291_34367[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (40))){
var inst_34231 = (state_34263[(23)]);
var inst_34235 = done(null);
var inst_34236 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_34231);
var state_34263__$1 = (function (){var statearr_34292 = state_34263;
(statearr_34292[(24)] = inst_34235);

return statearr_34292;
})();
var statearr_34293_34368 = state_34263__$1;
(statearr_34293_34368[(2)] = inst_34236);

(statearr_34293_34368[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (33))){
var inst_34222 = (state_34263[(25)]);
var inst_34224 = cljs.core.chunked_seq_QMARK_(inst_34222);
var state_34263__$1 = state_34263;
if(inst_34224){
var statearr_34294_34369 = state_34263__$1;
(statearr_34294_34369[(1)] = (36));

} else {
var statearr_34295_34370 = state_34263__$1;
(statearr_34295_34370[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (13))){
var inst_34152 = (state_34263[(26)]);
var inst_34155 = cljs.core.async.close_BANG_(inst_34152);
var state_34263__$1 = state_34263;
var statearr_34296_34371 = state_34263__$1;
(statearr_34296_34371[(2)] = inst_34155);

(statearr_34296_34371[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (22))){
var inst_34175 = (state_34263[(8)]);
var inst_34178 = cljs.core.async.close_BANG_(inst_34175);
var state_34263__$1 = state_34263;
var statearr_34297_34372 = state_34263__$1;
(statearr_34297_34372[(2)] = inst_34178);

(statearr_34297_34372[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (36))){
var inst_34222 = (state_34263[(25)]);
var inst_34226 = cljs.core.chunk_first(inst_34222);
var inst_34227 = cljs.core.chunk_rest(inst_34222);
var inst_34228 = cljs.core.count(inst_34226);
var inst_34203 = inst_34227;
var inst_34204 = inst_34226;
var inst_34205 = inst_34228;
var inst_34206 = (0);
var state_34263__$1 = (function (){var statearr_34298 = state_34263;
(statearr_34298[(20)] = inst_34203);

(statearr_34298[(21)] = inst_34205);

(statearr_34298[(10)] = inst_34206);

(statearr_34298[(11)] = inst_34204);

return statearr_34298;
})();
var statearr_34299_34373 = state_34263__$1;
(statearr_34299_34373[(2)] = null);

(statearr_34299_34373[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (41))){
var inst_34222 = (state_34263[(25)]);
var inst_34238 = (state_34263[(2)]);
var inst_34239 = cljs.core.next(inst_34222);
var inst_34203 = inst_34239;
var inst_34204 = null;
var inst_34205 = (0);
var inst_34206 = (0);
var state_34263__$1 = (function (){var statearr_34300 = state_34263;
(statearr_34300[(20)] = inst_34203);

(statearr_34300[(27)] = inst_34238);

(statearr_34300[(21)] = inst_34205);

(statearr_34300[(10)] = inst_34206);

(statearr_34300[(11)] = inst_34204);

return statearr_34300;
})();
var statearr_34301_34374 = state_34263__$1;
(statearr_34301_34374[(2)] = null);

(statearr_34301_34374[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (43))){
var state_34263__$1 = state_34263;
var statearr_34302_34375 = state_34263__$1;
(statearr_34302_34375[(2)] = null);

(statearr_34302_34375[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (29))){
var inst_34247 = (state_34263[(2)]);
var state_34263__$1 = state_34263;
var statearr_34303_34376 = state_34263__$1;
(statearr_34303_34376[(2)] = inst_34247);

(statearr_34303_34376[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (44))){
var inst_34256 = (state_34263[(2)]);
var state_34263__$1 = (function (){var statearr_34304 = state_34263;
(statearr_34304[(28)] = inst_34256);

return statearr_34304;
})();
var statearr_34305_34377 = state_34263__$1;
(statearr_34305_34377[(2)] = null);

(statearr_34305_34377[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (6))){
var inst_34195 = (state_34263[(29)]);
var inst_34194 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_34195__$1 = cljs.core.keys(inst_34194);
var inst_34196 = cljs.core.count(inst_34195__$1);
var inst_34197 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_34196) : cljs.core.reset_BANG_.call(null,dctr,inst_34196));
var inst_34202 = cljs.core.seq(inst_34195__$1);
var inst_34203 = inst_34202;
var inst_34204 = null;
var inst_34205 = (0);
var inst_34206 = (0);
var state_34263__$1 = (function (){var statearr_34306 = state_34263;
(statearr_34306[(20)] = inst_34203);

(statearr_34306[(21)] = inst_34205);

(statearr_34306[(29)] = inst_34195__$1);

(statearr_34306[(10)] = inst_34206);

(statearr_34306[(11)] = inst_34204);

(statearr_34306[(30)] = inst_34197);

return statearr_34306;
})();
var statearr_34307_34378 = state_34263__$1;
(statearr_34307_34378[(2)] = null);

(statearr_34307_34378[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (28))){
var inst_34203 = (state_34263[(20)]);
var inst_34222 = (state_34263[(25)]);
var inst_34222__$1 = cljs.core.seq(inst_34203);
var state_34263__$1 = (function (){var statearr_34308 = state_34263;
(statearr_34308[(25)] = inst_34222__$1);

return statearr_34308;
})();
if(inst_34222__$1){
var statearr_34309_34379 = state_34263__$1;
(statearr_34309_34379[(1)] = (33));

} else {
var statearr_34310_34380 = state_34263__$1;
(statearr_34310_34380[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (25))){
var inst_34205 = (state_34263[(21)]);
var inst_34206 = (state_34263[(10)]);
var inst_34208 = (inst_34206 < inst_34205);
var inst_34209 = inst_34208;
var state_34263__$1 = state_34263;
if(cljs.core.truth_(inst_34209)){
var statearr_34311_34381 = state_34263__$1;
(statearr_34311_34381[(1)] = (27));

} else {
var statearr_34312_34382 = state_34263__$1;
(statearr_34312_34382[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (34))){
var state_34263__$1 = state_34263;
var statearr_34313_34383 = state_34263__$1;
(statearr_34313_34383[(2)] = null);

(statearr_34313_34383[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (17))){
var state_34263__$1 = state_34263;
var statearr_34314_34384 = state_34263__$1;
(statearr_34314_34384[(2)] = null);

(statearr_34314_34384[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (3))){
var inst_34261 = (state_34263[(2)]);
var state_34263__$1 = state_34263;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34263__$1,inst_34261);
} else {
if((state_val_34264 === (12))){
var inst_34190 = (state_34263[(2)]);
var state_34263__$1 = state_34263;
var statearr_34315_34385 = state_34263__$1;
(statearr_34315_34385[(2)] = inst_34190);

(statearr_34315_34385[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (2))){
var state_34263__$1 = state_34263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34263__$1,(4),ch);
} else {
if((state_val_34264 === (23))){
var state_34263__$1 = state_34263;
var statearr_34316_34386 = state_34263__$1;
(statearr_34316_34386[(2)] = null);

(statearr_34316_34386[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (35))){
var inst_34245 = (state_34263[(2)]);
var state_34263__$1 = state_34263;
var statearr_34317_34387 = state_34263__$1;
(statearr_34317_34387[(2)] = inst_34245);

(statearr_34317_34387[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (19))){
var inst_34162 = (state_34263[(7)]);
var inst_34166 = cljs.core.chunk_first(inst_34162);
var inst_34167 = cljs.core.chunk_rest(inst_34162);
var inst_34168 = cljs.core.count(inst_34166);
var inst_34140 = inst_34167;
var inst_34141 = inst_34166;
var inst_34142 = inst_34168;
var inst_34143 = (0);
var state_34263__$1 = (function (){var statearr_34318 = state_34263;
(statearr_34318[(13)] = inst_34142);

(statearr_34318[(14)] = inst_34140);

(statearr_34318[(16)] = inst_34141);

(statearr_34318[(17)] = inst_34143);

return statearr_34318;
})();
var statearr_34319_34388 = state_34263__$1;
(statearr_34319_34388[(2)] = null);

(statearr_34319_34388[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (11))){
var inst_34140 = (state_34263[(14)]);
var inst_34162 = (state_34263[(7)]);
var inst_34162__$1 = cljs.core.seq(inst_34140);
var state_34263__$1 = (function (){var statearr_34320 = state_34263;
(statearr_34320[(7)] = inst_34162__$1);

return statearr_34320;
})();
if(inst_34162__$1){
var statearr_34321_34389 = state_34263__$1;
(statearr_34321_34389[(1)] = (16));

} else {
var statearr_34322_34390 = state_34263__$1;
(statearr_34322_34390[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (9))){
var inst_34192 = (state_34263[(2)]);
var state_34263__$1 = state_34263;
var statearr_34323_34391 = state_34263__$1;
(statearr_34323_34391[(2)] = inst_34192);

(statearr_34323_34391[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (5))){
var inst_34138 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_34139 = cljs.core.seq(inst_34138);
var inst_34140 = inst_34139;
var inst_34141 = null;
var inst_34142 = (0);
var inst_34143 = (0);
var state_34263__$1 = (function (){var statearr_34324 = state_34263;
(statearr_34324[(13)] = inst_34142);

(statearr_34324[(14)] = inst_34140);

(statearr_34324[(16)] = inst_34141);

(statearr_34324[(17)] = inst_34143);

return statearr_34324;
})();
var statearr_34325_34392 = state_34263__$1;
(statearr_34325_34392[(2)] = null);

(statearr_34325_34392[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (14))){
var state_34263__$1 = state_34263;
var statearr_34326_34393 = state_34263__$1;
(statearr_34326_34393[(2)] = null);

(statearr_34326_34393[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (45))){
var inst_34253 = (state_34263[(2)]);
var state_34263__$1 = state_34263;
var statearr_34327_34394 = state_34263__$1;
(statearr_34327_34394[(2)] = inst_34253);

(statearr_34327_34394[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (26))){
var inst_34195 = (state_34263[(29)]);
var inst_34249 = (state_34263[(2)]);
var inst_34250 = cljs.core.seq(inst_34195);
var state_34263__$1 = (function (){var statearr_34328 = state_34263;
(statearr_34328[(31)] = inst_34249);

return statearr_34328;
})();
if(inst_34250){
var statearr_34329_34395 = state_34263__$1;
(statearr_34329_34395[(1)] = (42));

} else {
var statearr_34330_34396 = state_34263__$1;
(statearr_34330_34396[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (16))){
var inst_34162 = (state_34263[(7)]);
var inst_34164 = cljs.core.chunked_seq_QMARK_(inst_34162);
var state_34263__$1 = state_34263;
if(inst_34164){
var statearr_34331_34397 = state_34263__$1;
(statearr_34331_34397[(1)] = (19));

} else {
var statearr_34332_34398 = state_34263__$1;
(statearr_34332_34398[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (38))){
var inst_34242 = (state_34263[(2)]);
var state_34263__$1 = state_34263;
var statearr_34333_34399 = state_34263__$1;
(statearr_34333_34399[(2)] = inst_34242);

(statearr_34333_34399[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (30))){
var state_34263__$1 = state_34263;
var statearr_34334_34400 = state_34263__$1;
(statearr_34334_34400[(2)] = null);

(statearr_34334_34400[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (10))){
var inst_34141 = (state_34263[(16)]);
var inst_34143 = (state_34263[(17)]);
var inst_34151 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_34141,inst_34143);
var inst_34152 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34151,(0),null);
var inst_34153 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34151,(1),null);
var state_34263__$1 = (function (){var statearr_34335 = state_34263;
(statearr_34335[(26)] = inst_34152);

return statearr_34335;
})();
if(cljs.core.truth_(inst_34153)){
var statearr_34336_34401 = state_34263__$1;
(statearr_34336_34401[(1)] = (13));

} else {
var statearr_34337_34402 = state_34263__$1;
(statearr_34337_34402[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (18))){
var inst_34188 = (state_34263[(2)]);
var state_34263__$1 = state_34263;
var statearr_34338_34403 = state_34263__$1;
(statearr_34338_34403[(2)] = inst_34188);

(statearr_34338_34403[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (42))){
var state_34263__$1 = state_34263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34263__$1,(45),dchan);
} else {
if((state_val_34264 === (37))){
var inst_34222 = (state_34263[(25)]);
var inst_34131 = (state_34263[(12)]);
var inst_34231 = (state_34263[(23)]);
var inst_34231__$1 = cljs.core.first(inst_34222);
var inst_34232 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_34231__$1,inst_34131,done);
var state_34263__$1 = (function (){var statearr_34339 = state_34263;
(statearr_34339[(23)] = inst_34231__$1);

return statearr_34339;
})();
if(cljs.core.truth_(inst_34232)){
var statearr_34340_34404 = state_34263__$1;
(statearr_34340_34404[(1)] = (39));

} else {
var statearr_34341_34405 = state_34263__$1;
(statearr_34341_34405[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34264 === (8))){
var inst_34142 = (state_34263[(13)]);
var inst_34143 = (state_34263[(17)]);
var inst_34145 = (inst_34143 < inst_34142);
var inst_34146 = inst_34145;
var state_34263__$1 = state_34263;
if(cljs.core.truth_(inst_34146)){
var statearr_34342_34406 = state_34263__$1;
(statearr_34342_34406[(1)] = (10));

} else {
var statearr_34343_34407 = state_34263__$1;
(statearr_34343_34407[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___34353,cs,m,dchan,dctr,done))
;
return ((function (switch__12197__auto__,c__12309__auto___34353,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__12198__auto__ = null;
var cljs$core$async$mult_$_state_machine__12198__auto____0 = (function (){
var statearr_34347 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34347[(0)] = cljs$core$async$mult_$_state_machine__12198__auto__);

(statearr_34347[(1)] = (1));

return statearr_34347;
});
var cljs$core$async$mult_$_state_machine__12198__auto____1 = (function (state_34263){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_34263);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e34348){if((e34348 instanceof Object)){
var ex__12201__auto__ = e34348;
var statearr_34349_34408 = state_34263;
(statearr_34349_34408[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34263);

return cljs.core.cst$kw$recur;
} else {
throw e34348;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__34409 = state_34263;
state_34263 = G__34409;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12198__auto__ = function(state_34263){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12198__auto____1.call(this,state_34263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12198__auto____0;
cljs$core$async$mult_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12198__auto____1;
return cljs$core$async$mult_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___34353,cs,m,dchan,dctr,done))
})();
var state__12311__auto__ = (function (){var statearr_34350 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_34350[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___34353);

return statearr_34350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___34353,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args34410 = [];
var len__7484__auto___34413 = arguments.length;
var i__7485__auto___34414 = (0);
while(true){
if((i__7485__auto___34414 < len__7484__auto___34413)){
args34410.push((arguments[i__7485__auto___34414]));

var G__34415 = (i__7485__auto___34414 + (1));
i__7485__auto___34414 = G__34415;
continue;
} else {
}
break;
}

var G__34412 = args34410.length;
switch (G__34412) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34410.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto__.call(null,m));
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7073__auto__.call(null,m,state_map));
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7073__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7073__auto__.call(null,m,mode));
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7073__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34427 = arguments.length;
var i__7485__auto___34428 = (0);
while(true){
if((i__7485__auto___34428 < len__7484__auto___34427)){
args__7491__auto__.push((arguments[i__7485__auto___34428]));

var G__34429 = (i__7485__auto___34428 + (1));
i__7485__auto___34428 = G__34429;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__34421){
var map__34422 = p__34421;
var map__34422__$1 = ((((!((map__34422 == null)))?((((map__34422.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34422.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34422):map__34422);
var opts = map__34422__$1;
var statearr_34424_34430 = state;
(statearr_34424_34430[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__34422,map__34422__$1,opts){
return (function (val){
var statearr_34425_34431 = state;
(statearr_34425_34431[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__34422,map__34422__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_34426_34432 = state;
(statearr_34426_34432[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq34417){
var G__34418 = cljs.core.first(seq34417);
var seq34417__$1 = cljs.core.next(seq34417);
var G__34419 = cljs.core.first(seq34417__$1);
var seq34417__$2 = cljs.core.next(seq34417__$1);
var G__34420 = cljs.core.first(seq34417__$2);
var seq34417__$3 = cljs.core.next(seq34417__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34418,G__34419,G__34420,seq34417__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__34602 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__34602) : cljs.core.atom.call(null,G__34602));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__34603 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__34603) : cljs.core.atom.call(null,G__34603));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async34604 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34604 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta34605){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta34605 = meta34605;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34604.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_34606,meta34605__$1){
var self__ = this;
var _34606__$1 = this;
return (new cljs.core.async.t_cljs$core$async34604(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta34605__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34604.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_34606){
var self__ = this;
var _34606__$1 = this;
return self__.meta34605;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34604.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async34604.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34604.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async34604.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34604.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34604.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__34607_34771 = self__.cs;
var G__34608_34772 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__34607_34771,G__34608_34772) : cljs.core.reset_BANG_.call(null,G__34607_34771,G__34608_34772));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34604.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34604.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34604.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta34605], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34604.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34604.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34604";

cljs.core.async.t_cljs$core$async34604.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async34604");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async34604 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async34604(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta34605){
return (new cljs.core.async.t_cljs$core$async34604(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta34605));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async34604(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12309__auto___34773 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___34773,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___34773,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_34708){
var state_val_34709 = (state_34708[(1)]);
if((state_val_34709 === (7))){
var inst_34624 = (state_34708[(2)]);
var state_34708__$1 = state_34708;
var statearr_34710_34774 = state_34708__$1;
(statearr_34710_34774[(2)] = inst_34624);

(statearr_34710_34774[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (20))){
var inst_34636 = (state_34708[(7)]);
var state_34708__$1 = state_34708;
var statearr_34711_34775 = state_34708__$1;
(statearr_34711_34775[(2)] = inst_34636);

(statearr_34711_34775[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (27))){
var state_34708__$1 = state_34708;
var statearr_34712_34776 = state_34708__$1;
(statearr_34712_34776[(2)] = null);

(statearr_34712_34776[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (1))){
var inst_34612 = (state_34708[(8)]);
var inst_34612__$1 = calc_state();
var inst_34614 = (inst_34612__$1 == null);
var inst_34615 = cljs.core.not(inst_34614);
var state_34708__$1 = (function (){var statearr_34713 = state_34708;
(statearr_34713[(8)] = inst_34612__$1);

return statearr_34713;
})();
if(inst_34615){
var statearr_34714_34777 = state_34708__$1;
(statearr_34714_34777[(1)] = (2));

} else {
var statearr_34715_34778 = state_34708__$1;
(statearr_34715_34778[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (24))){
var inst_34659 = (state_34708[(9)]);
var inst_34668 = (state_34708[(10)]);
var inst_34682 = (state_34708[(11)]);
var inst_34682__$1 = (inst_34659.cljs$core$IFn$_invoke$arity$1 ? inst_34659.cljs$core$IFn$_invoke$arity$1(inst_34668) : inst_34659.call(null,inst_34668));
var state_34708__$1 = (function (){var statearr_34716 = state_34708;
(statearr_34716[(11)] = inst_34682__$1);

return statearr_34716;
})();
if(cljs.core.truth_(inst_34682__$1)){
var statearr_34717_34779 = state_34708__$1;
(statearr_34717_34779[(1)] = (29));

} else {
var statearr_34718_34780 = state_34708__$1;
(statearr_34718_34780[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (4))){
var inst_34627 = (state_34708[(2)]);
var state_34708__$1 = state_34708;
if(cljs.core.truth_(inst_34627)){
var statearr_34719_34781 = state_34708__$1;
(statearr_34719_34781[(1)] = (8));

} else {
var statearr_34720_34782 = state_34708__$1;
(statearr_34720_34782[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (15))){
var inst_34653 = (state_34708[(2)]);
var state_34708__$1 = state_34708;
if(cljs.core.truth_(inst_34653)){
var statearr_34721_34783 = state_34708__$1;
(statearr_34721_34783[(1)] = (19));

} else {
var statearr_34722_34784 = state_34708__$1;
(statearr_34722_34784[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (21))){
var inst_34658 = (state_34708[(12)]);
var inst_34658__$1 = (state_34708[(2)]);
var inst_34659 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34658__$1,cljs.core.cst$kw$solos);
var inst_34660 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34658__$1,cljs.core.cst$kw$mutes);
var inst_34661 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34658__$1,cljs.core.cst$kw$reads);
var state_34708__$1 = (function (){var statearr_34723 = state_34708;
(statearr_34723[(9)] = inst_34659);

(statearr_34723[(12)] = inst_34658__$1);

(statearr_34723[(13)] = inst_34660);

return statearr_34723;
})();
return cljs.core.async.ioc_alts_BANG_(state_34708__$1,(22),inst_34661);
} else {
if((state_val_34709 === (31))){
var inst_34690 = (state_34708[(2)]);
var state_34708__$1 = state_34708;
if(cljs.core.truth_(inst_34690)){
var statearr_34724_34785 = state_34708__$1;
(statearr_34724_34785[(1)] = (32));

} else {
var statearr_34725_34786 = state_34708__$1;
(statearr_34725_34786[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (32))){
var inst_34667 = (state_34708[(14)]);
var state_34708__$1 = state_34708;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34708__$1,(35),out,inst_34667);
} else {
if((state_val_34709 === (33))){
var inst_34658 = (state_34708[(12)]);
var inst_34636 = inst_34658;
var state_34708__$1 = (function (){var statearr_34726 = state_34708;
(statearr_34726[(7)] = inst_34636);

return statearr_34726;
})();
var statearr_34727_34787 = state_34708__$1;
(statearr_34727_34787[(2)] = null);

(statearr_34727_34787[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (13))){
var inst_34636 = (state_34708[(7)]);
var inst_34643 = inst_34636.cljs$lang$protocol_mask$partition0$;
var inst_34644 = (inst_34643 & (64));
var inst_34645 = inst_34636.cljs$core$ISeq$;
var inst_34646 = (inst_34644) || (inst_34645);
var state_34708__$1 = state_34708;
if(cljs.core.truth_(inst_34646)){
var statearr_34728_34788 = state_34708__$1;
(statearr_34728_34788[(1)] = (16));

} else {
var statearr_34729_34789 = state_34708__$1;
(statearr_34729_34789[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (22))){
var inst_34668 = (state_34708[(10)]);
var inst_34667 = (state_34708[(14)]);
var inst_34666 = (state_34708[(2)]);
var inst_34667__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34666,(0),null);
var inst_34668__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34666,(1),null);
var inst_34669 = (inst_34667__$1 == null);
var inst_34670 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34668__$1,change);
var inst_34671 = (inst_34669) || (inst_34670);
var state_34708__$1 = (function (){var statearr_34730 = state_34708;
(statearr_34730[(10)] = inst_34668__$1);

(statearr_34730[(14)] = inst_34667__$1);

return statearr_34730;
})();
if(cljs.core.truth_(inst_34671)){
var statearr_34731_34790 = state_34708__$1;
(statearr_34731_34790[(1)] = (23));

} else {
var statearr_34732_34791 = state_34708__$1;
(statearr_34732_34791[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (36))){
var inst_34658 = (state_34708[(12)]);
var inst_34636 = inst_34658;
var state_34708__$1 = (function (){var statearr_34733 = state_34708;
(statearr_34733[(7)] = inst_34636);

return statearr_34733;
})();
var statearr_34734_34792 = state_34708__$1;
(statearr_34734_34792[(2)] = null);

(statearr_34734_34792[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (29))){
var inst_34682 = (state_34708[(11)]);
var state_34708__$1 = state_34708;
var statearr_34735_34793 = state_34708__$1;
(statearr_34735_34793[(2)] = inst_34682);

(statearr_34735_34793[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (6))){
var state_34708__$1 = state_34708;
var statearr_34736_34794 = state_34708__$1;
(statearr_34736_34794[(2)] = false);

(statearr_34736_34794[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (28))){
var inst_34678 = (state_34708[(2)]);
var inst_34679 = calc_state();
var inst_34636 = inst_34679;
var state_34708__$1 = (function (){var statearr_34737 = state_34708;
(statearr_34737[(7)] = inst_34636);

(statearr_34737[(15)] = inst_34678);

return statearr_34737;
})();
var statearr_34738_34795 = state_34708__$1;
(statearr_34738_34795[(2)] = null);

(statearr_34738_34795[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (25))){
var inst_34704 = (state_34708[(2)]);
var state_34708__$1 = state_34708;
var statearr_34739_34796 = state_34708__$1;
(statearr_34739_34796[(2)] = inst_34704);

(statearr_34739_34796[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (34))){
var inst_34702 = (state_34708[(2)]);
var state_34708__$1 = state_34708;
var statearr_34740_34797 = state_34708__$1;
(statearr_34740_34797[(2)] = inst_34702);

(statearr_34740_34797[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (17))){
var state_34708__$1 = state_34708;
var statearr_34741_34798 = state_34708__$1;
(statearr_34741_34798[(2)] = false);

(statearr_34741_34798[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (3))){
var state_34708__$1 = state_34708;
var statearr_34742_34799 = state_34708__$1;
(statearr_34742_34799[(2)] = false);

(statearr_34742_34799[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (12))){
var inst_34706 = (state_34708[(2)]);
var state_34708__$1 = state_34708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34708__$1,inst_34706);
} else {
if((state_val_34709 === (2))){
var inst_34612 = (state_34708[(8)]);
var inst_34617 = inst_34612.cljs$lang$protocol_mask$partition0$;
var inst_34618 = (inst_34617 & (64));
var inst_34619 = inst_34612.cljs$core$ISeq$;
var inst_34620 = (inst_34618) || (inst_34619);
var state_34708__$1 = state_34708;
if(cljs.core.truth_(inst_34620)){
var statearr_34743_34800 = state_34708__$1;
(statearr_34743_34800[(1)] = (5));

} else {
var statearr_34744_34801 = state_34708__$1;
(statearr_34744_34801[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (23))){
var inst_34667 = (state_34708[(14)]);
var inst_34673 = (inst_34667 == null);
var state_34708__$1 = state_34708;
if(cljs.core.truth_(inst_34673)){
var statearr_34745_34802 = state_34708__$1;
(statearr_34745_34802[(1)] = (26));

} else {
var statearr_34746_34803 = state_34708__$1;
(statearr_34746_34803[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (35))){
var inst_34693 = (state_34708[(2)]);
var state_34708__$1 = state_34708;
if(cljs.core.truth_(inst_34693)){
var statearr_34747_34804 = state_34708__$1;
(statearr_34747_34804[(1)] = (36));

} else {
var statearr_34748_34805 = state_34708__$1;
(statearr_34748_34805[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (19))){
var inst_34636 = (state_34708[(7)]);
var inst_34655 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_34636);
var state_34708__$1 = state_34708;
var statearr_34749_34806 = state_34708__$1;
(statearr_34749_34806[(2)] = inst_34655);

(statearr_34749_34806[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (11))){
var inst_34636 = (state_34708[(7)]);
var inst_34640 = (inst_34636 == null);
var inst_34641 = cljs.core.not(inst_34640);
var state_34708__$1 = state_34708;
if(inst_34641){
var statearr_34750_34807 = state_34708__$1;
(statearr_34750_34807[(1)] = (13));

} else {
var statearr_34751_34808 = state_34708__$1;
(statearr_34751_34808[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (9))){
var inst_34612 = (state_34708[(8)]);
var state_34708__$1 = state_34708;
var statearr_34752_34809 = state_34708__$1;
(statearr_34752_34809[(2)] = inst_34612);

(statearr_34752_34809[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (5))){
var state_34708__$1 = state_34708;
var statearr_34753_34810 = state_34708__$1;
(statearr_34753_34810[(2)] = true);

(statearr_34753_34810[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (14))){
var state_34708__$1 = state_34708;
var statearr_34754_34811 = state_34708__$1;
(statearr_34754_34811[(2)] = false);

(statearr_34754_34811[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (26))){
var inst_34668 = (state_34708[(10)]);
var inst_34675 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_34668);
var state_34708__$1 = state_34708;
var statearr_34755_34812 = state_34708__$1;
(statearr_34755_34812[(2)] = inst_34675);

(statearr_34755_34812[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (16))){
var state_34708__$1 = state_34708;
var statearr_34756_34813 = state_34708__$1;
(statearr_34756_34813[(2)] = true);

(statearr_34756_34813[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (38))){
var inst_34698 = (state_34708[(2)]);
var state_34708__$1 = state_34708;
var statearr_34757_34814 = state_34708__$1;
(statearr_34757_34814[(2)] = inst_34698);

(statearr_34757_34814[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (30))){
var inst_34659 = (state_34708[(9)]);
var inst_34668 = (state_34708[(10)]);
var inst_34660 = (state_34708[(13)]);
var inst_34685 = cljs.core.empty_QMARK_(inst_34659);
var inst_34686 = (inst_34660.cljs$core$IFn$_invoke$arity$1 ? inst_34660.cljs$core$IFn$_invoke$arity$1(inst_34668) : inst_34660.call(null,inst_34668));
var inst_34687 = cljs.core.not(inst_34686);
var inst_34688 = (inst_34685) && (inst_34687);
var state_34708__$1 = state_34708;
var statearr_34758_34815 = state_34708__$1;
(statearr_34758_34815[(2)] = inst_34688);

(statearr_34758_34815[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (10))){
var inst_34612 = (state_34708[(8)]);
var inst_34632 = (state_34708[(2)]);
var inst_34633 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34632,cljs.core.cst$kw$solos);
var inst_34634 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34632,cljs.core.cst$kw$mutes);
var inst_34635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34632,cljs.core.cst$kw$reads);
var inst_34636 = inst_34612;
var state_34708__$1 = (function (){var statearr_34759 = state_34708;
(statearr_34759[(16)] = inst_34635);

(statearr_34759[(7)] = inst_34636);

(statearr_34759[(17)] = inst_34633);

(statearr_34759[(18)] = inst_34634);

return statearr_34759;
})();
var statearr_34760_34816 = state_34708__$1;
(statearr_34760_34816[(2)] = null);

(statearr_34760_34816[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (18))){
var inst_34650 = (state_34708[(2)]);
var state_34708__$1 = state_34708;
var statearr_34761_34817 = state_34708__$1;
(statearr_34761_34817[(2)] = inst_34650);

(statearr_34761_34817[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (37))){
var state_34708__$1 = state_34708;
var statearr_34762_34818 = state_34708__$1;
(statearr_34762_34818[(2)] = null);

(statearr_34762_34818[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34709 === (8))){
var inst_34612 = (state_34708[(8)]);
var inst_34629 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_34612);
var state_34708__$1 = state_34708;
var statearr_34763_34819 = state_34708__$1;
(statearr_34763_34819[(2)] = inst_34629);

(statearr_34763_34819[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___34773,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__12197__auto__,c__12309__auto___34773,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__12198__auto__ = null;
var cljs$core$async$mix_$_state_machine__12198__auto____0 = (function (){
var statearr_34767 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34767[(0)] = cljs$core$async$mix_$_state_machine__12198__auto__);

(statearr_34767[(1)] = (1));

return statearr_34767;
});
var cljs$core$async$mix_$_state_machine__12198__auto____1 = (function (state_34708){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_34708);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e34768){if((e34768 instanceof Object)){
var ex__12201__auto__ = e34768;
var statearr_34769_34820 = state_34708;
(statearr_34769_34820[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34708);

return cljs.core.cst$kw$recur;
} else {
throw e34768;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__34821 = state_34708;
state_34708 = G__34821;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12198__auto__ = function(state_34708){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12198__auto____1.call(this,state_34708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12198__auto____0;
cljs$core$async$mix_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12198__auto____1;
return cljs$core$async$mix_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___34773,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__12311__auto__ = (function (){var statearr_34770 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_34770[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___34773);

return statearr_34770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___34773,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7073__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7073__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7073__auto__.call(null,p,v,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7073__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args34822 = [];
var len__7484__auto___34825 = arguments.length;
var i__7485__auto___34826 = (0);
while(true){
if((i__7485__auto___34826 < len__7484__auto___34825)){
args34822.push((arguments[i__7485__auto___34826]));

var G__34827 = (i__7485__auto___34826 + (1));
i__7485__auto___34826 = G__34827;
continue;
} else {
}
break;
}

var G__34824 = args34822.length;
switch (G__34824) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34822.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7073__auto__.call(null,p));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7073__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7073__auto__.call(null,p,v));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7073__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args34830 = [];
var len__7484__auto___34958 = arguments.length;
var i__7485__auto___34959 = (0);
while(true){
if((i__7485__auto___34959 < len__7484__auto___34958)){
args34830.push((arguments[i__7485__auto___34959]));

var G__34960 = (i__7485__auto___34959 + (1));
i__7485__auto___34959 = G__34960;
continue;
} else {
}
break;
}

var G__34832 = args34830.length;
switch (G__34832) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34830.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__34833 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__34833) : cljs.core.atom.call(null,G__34833));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6409__auto__,mults){
return (function (p1__34829_SHARP_){
if(cljs.core.truth_((p1__34829_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34829_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__34829_SHARP_.call(null,topic)))){
return p1__34829_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__34829_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async34834 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34834 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta34835){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta34835 = meta34835;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34834.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_34836,meta34835__$1){
var self__ = this;
var _34836__$1 = this;
return (new cljs.core.async.t_cljs$core$async34834(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta34835__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34834.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_34836){
var self__ = this;
var _34836__$1 = this;
return self__.meta34835;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34834.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async34834.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34834.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async34834.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34834.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34834.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__34837 = self__.mults;
var G__34838 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__34837,G__34838) : cljs.core.reset_BANG_.call(null,G__34837,G__34838));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34834.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34834.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta34835], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34834.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34834.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34834";

cljs.core.async.t_cljs$core$async34834.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async34834");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async34834 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async34834(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta34835){
return (new cljs.core.async.t_cljs$core$async34834(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta34835));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async34834(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12309__auto___34962 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___34962,mults,ensure_mult,p){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___34962,mults,ensure_mult,p){
return (function (state_34910){
var state_val_34911 = (state_34910[(1)]);
if((state_val_34911 === (7))){
var inst_34906 = (state_34910[(2)]);
var state_34910__$1 = state_34910;
var statearr_34912_34963 = state_34910__$1;
(statearr_34912_34963[(2)] = inst_34906);

(statearr_34912_34963[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (20))){
var state_34910__$1 = state_34910;
var statearr_34913_34964 = state_34910__$1;
(statearr_34913_34964[(2)] = null);

(statearr_34913_34964[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (1))){
var state_34910__$1 = state_34910;
var statearr_34914_34965 = state_34910__$1;
(statearr_34914_34965[(2)] = null);

(statearr_34914_34965[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (24))){
var inst_34889 = (state_34910[(7)]);
var inst_34898 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_34889);
var state_34910__$1 = state_34910;
var statearr_34915_34966 = state_34910__$1;
(statearr_34915_34966[(2)] = inst_34898);

(statearr_34915_34966[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (4))){
var inst_34841 = (state_34910[(8)]);
var inst_34841__$1 = (state_34910[(2)]);
var inst_34842 = (inst_34841__$1 == null);
var state_34910__$1 = (function (){var statearr_34916 = state_34910;
(statearr_34916[(8)] = inst_34841__$1);

return statearr_34916;
})();
if(cljs.core.truth_(inst_34842)){
var statearr_34917_34967 = state_34910__$1;
(statearr_34917_34967[(1)] = (5));

} else {
var statearr_34918_34968 = state_34910__$1;
(statearr_34918_34968[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (15))){
var inst_34883 = (state_34910[(2)]);
var state_34910__$1 = state_34910;
var statearr_34919_34969 = state_34910__$1;
(statearr_34919_34969[(2)] = inst_34883);

(statearr_34919_34969[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (21))){
var inst_34903 = (state_34910[(2)]);
var state_34910__$1 = (function (){var statearr_34920 = state_34910;
(statearr_34920[(9)] = inst_34903);

return statearr_34920;
})();
var statearr_34921_34970 = state_34910__$1;
(statearr_34921_34970[(2)] = null);

(statearr_34921_34970[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (13))){
var inst_34865 = (state_34910[(10)]);
var inst_34867 = cljs.core.chunked_seq_QMARK_(inst_34865);
var state_34910__$1 = state_34910;
if(inst_34867){
var statearr_34922_34971 = state_34910__$1;
(statearr_34922_34971[(1)] = (16));

} else {
var statearr_34923_34972 = state_34910__$1;
(statearr_34923_34972[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (22))){
var inst_34895 = (state_34910[(2)]);
var state_34910__$1 = state_34910;
if(cljs.core.truth_(inst_34895)){
var statearr_34924_34973 = state_34910__$1;
(statearr_34924_34973[(1)] = (23));

} else {
var statearr_34925_34974 = state_34910__$1;
(statearr_34925_34974[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (6))){
var inst_34891 = (state_34910[(11)]);
var inst_34841 = (state_34910[(8)]);
var inst_34889 = (state_34910[(7)]);
var inst_34889__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_34841) : topic_fn.call(null,inst_34841));
var inst_34890 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_34891__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34890,inst_34889__$1);
var state_34910__$1 = (function (){var statearr_34926 = state_34910;
(statearr_34926[(11)] = inst_34891__$1);

(statearr_34926[(7)] = inst_34889__$1);

return statearr_34926;
})();
if(cljs.core.truth_(inst_34891__$1)){
var statearr_34927_34975 = state_34910__$1;
(statearr_34927_34975[(1)] = (19));

} else {
var statearr_34928_34976 = state_34910__$1;
(statearr_34928_34976[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (25))){
var inst_34900 = (state_34910[(2)]);
var state_34910__$1 = state_34910;
var statearr_34929_34977 = state_34910__$1;
(statearr_34929_34977[(2)] = inst_34900);

(statearr_34929_34977[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (17))){
var inst_34865 = (state_34910[(10)]);
var inst_34874 = cljs.core.first(inst_34865);
var inst_34875 = cljs.core.async.muxch_STAR_(inst_34874);
var inst_34876 = cljs.core.async.close_BANG_(inst_34875);
var inst_34877 = cljs.core.next(inst_34865);
var inst_34851 = inst_34877;
var inst_34852 = null;
var inst_34853 = (0);
var inst_34854 = (0);
var state_34910__$1 = (function (){var statearr_34930 = state_34910;
(statearr_34930[(12)] = inst_34852);

(statearr_34930[(13)] = inst_34876);

(statearr_34930[(14)] = inst_34851);

(statearr_34930[(15)] = inst_34853);

(statearr_34930[(16)] = inst_34854);

return statearr_34930;
})();
var statearr_34931_34978 = state_34910__$1;
(statearr_34931_34978[(2)] = null);

(statearr_34931_34978[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (3))){
var inst_34908 = (state_34910[(2)]);
var state_34910__$1 = state_34910;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34910__$1,inst_34908);
} else {
if((state_val_34911 === (12))){
var inst_34885 = (state_34910[(2)]);
var state_34910__$1 = state_34910;
var statearr_34932_34979 = state_34910__$1;
(statearr_34932_34979[(2)] = inst_34885);

(statearr_34932_34979[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (2))){
var state_34910__$1 = state_34910;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34910__$1,(4),ch);
} else {
if((state_val_34911 === (23))){
var state_34910__$1 = state_34910;
var statearr_34933_34980 = state_34910__$1;
(statearr_34933_34980[(2)] = null);

(statearr_34933_34980[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (19))){
var inst_34891 = (state_34910[(11)]);
var inst_34841 = (state_34910[(8)]);
var inst_34893 = cljs.core.async.muxch_STAR_(inst_34891);
var state_34910__$1 = state_34910;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34910__$1,(22),inst_34893,inst_34841);
} else {
if((state_val_34911 === (11))){
var inst_34865 = (state_34910[(10)]);
var inst_34851 = (state_34910[(14)]);
var inst_34865__$1 = cljs.core.seq(inst_34851);
var state_34910__$1 = (function (){var statearr_34934 = state_34910;
(statearr_34934[(10)] = inst_34865__$1);

return statearr_34934;
})();
if(inst_34865__$1){
var statearr_34935_34981 = state_34910__$1;
(statearr_34935_34981[(1)] = (13));

} else {
var statearr_34936_34982 = state_34910__$1;
(statearr_34936_34982[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (9))){
var inst_34887 = (state_34910[(2)]);
var state_34910__$1 = state_34910;
var statearr_34937_34983 = state_34910__$1;
(statearr_34937_34983[(2)] = inst_34887);

(statearr_34937_34983[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (5))){
var inst_34848 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_34849 = cljs.core.vals(inst_34848);
var inst_34850 = cljs.core.seq(inst_34849);
var inst_34851 = inst_34850;
var inst_34852 = null;
var inst_34853 = (0);
var inst_34854 = (0);
var state_34910__$1 = (function (){var statearr_34938 = state_34910;
(statearr_34938[(12)] = inst_34852);

(statearr_34938[(14)] = inst_34851);

(statearr_34938[(15)] = inst_34853);

(statearr_34938[(16)] = inst_34854);

return statearr_34938;
})();
var statearr_34939_34984 = state_34910__$1;
(statearr_34939_34984[(2)] = null);

(statearr_34939_34984[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (14))){
var state_34910__$1 = state_34910;
var statearr_34943_34985 = state_34910__$1;
(statearr_34943_34985[(2)] = null);

(statearr_34943_34985[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (16))){
var inst_34865 = (state_34910[(10)]);
var inst_34869 = cljs.core.chunk_first(inst_34865);
var inst_34870 = cljs.core.chunk_rest(inst_34865);
var inst_34871 = cljs.core.count(inst_34869);
var inst_34851 = inst_34870;
var inst_34852 = inst_34869;
var inst_34853 = inst_34871;
var inst_34854 = (0);
var state_34910__$1 = (function (){var statearr_34944 = state_34910;
(statearr_34944[(12)] = inst_34852);

(statearr_34944[(14)] = inst_34851);

(statearr_34944[(15)] = inst_34853);

(statearr_34944[(16)] = inst_34854);

return statearr_34944;
})();
var statearr_34945_34986 = state_34910__$1;
(statearr_34945_34986[(2)] = null);

(statearr_34945_34986[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (10))){
var inst_34852 = (state_34910[(12)]);
var inst_34851 = (state_34910[(14)]);
var inst_34853 = (state_34910[(15)]);
var inst_34854 = (state_34910[(16)]);
var inst_34859 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_34852,inst_34854);
var inst_34860 = cljs.core.async.muxch_STAR_(inst_34859);
var inst_34861 = cljs.core.async.close_BANG_(inst_34860);
var inst_34862 = (inst_34854 + (1));
var tmp34940 = inst_34852;
var tmp34941 = inst_34851;
var tmp34942 = inst_34853;
var inst_34851__$1 = tmp34941;
var inst_34852__$1 = tmp34940;
var inst_34853__$1 = tmp34942;
var inst_34854__$1 = inst_34862;
var state_34910__$1 = (function (){var statearr_34946 = state_34910;
(statearr_34946[(12)] = inst_34852__$1);

(statearr_34946[(14)] = inst_34851__$1);

(statearr_34946[(15)] = inst_34853__$1);

(statearr_34946[(17)] = inst_34861);

(statearr_34946[(16)] = inst_34854__$1);

return statearr_34946;
})();
var statearr_34947_34987 = state_34910__$1;
(statearr_34947_34987[(2)] = null);

(statearr_34947_34987[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (18))){
var inst_34880 = (state_34910[(2)]);
var state_34910__$1 = state_34910;
var statearr_34948_34988 = state_34910__$1;
(statearr_34948_34988[(2)] = inst_34880);

(statearr_34948_34988[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34911 === (8))){
var inst_34853 = (state_34910[(15)]);
var inst_34854 = (state_34910[(16)]);
var inst_34856 = (inst_34854 < inst_34853);
var inst_34857 = inst_34856;
var state_34910__$1 = state_34910;
if(cljs.core.truth_(inst_34857)){
var statearr_34949_34989 = state_34910__$1;
(statearr_34949_34989[(1)] = (10));

} else {
var statearr_34950_34990 = state_34910__$1;
(statearr_34950_34990[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___34962,mults,ensure_mult,p))
;
return ((function (switch__12197__auto__,c__12309__auto___34962,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_34954 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34954[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_34954[(1)] = (1));

return statearr_34954;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_34910){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_34910);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e34955){if((e34955 instanceof Object)){
var ex__12201__auto__ = e34955;
var statearr_34956_34991 = state_34910;
(statearr_34956_34991[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34910);

return cljs.core.cst$kw$recur;
} else {
throw e34955;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__34992 = state_34910;
state_34910 = G__34992;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_34910){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_34910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___34962,mults,ensure_mult,p))
})();
var state__12311__auto__ = (function (){var statearr_34957 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_34957[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___34962);

return statearr_34957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___34962,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args34993 = [];
var len__7484__auto___34996 = arguments.length;
var i__7485__auto___34997 = (0);
while(true){
if((i__7485__auto___34997 < len__7484__auto___34996)){
args34993.push((arguments[i__7485__auto___34997]));

var G__34998 = (i__7485__auto___34997 + (1));
i__7485__auto___34997 = G__34998;
continue;
} else {
}
break;
}

var G__34995 = args34993.length;
switch (G__34995) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34993.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args35000 = [];
var len__7484__auto___35003 = arguments.length;
var i__7485__auto___35004 = (0);
while(true){
if((i__7485__auto___35004 < len__7484__auto___35003)){
args35000.push((arguments[i__7485__auto___35004]));

var G__35005 = (i__7485__auto___35004 + (1));
i__7485__auto___35004 = G__35005;
continue;
} else {
}
break;
}

var G__35002 = args35000.length;
switch (G__35002) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35000.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args35007 = [];
var len__7484__auto___35078 = arguments.length;
var i__7485__auto___35079 = (0);
while(true){
if((i__7485__auto___35079 < len__7484__auto___35078)){
args35007.push((arguments[i__7485__auto___35079]));

var G__35080 = (i__7485__auto___35079 + (1));
i__7485__auto___35079 = G__35080;
continue;
} else {
}
break;
}

var G__35009 = args35007.length;
switch (G__35009) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35007.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__12309__auto___35082 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___35082,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___35082,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_35048){
var state_val_35049 = (state_35048[(1)]);
if((state_val_35049 === (7))){
var state_35048__$1 = state_35048;
var statearr_35050_35083 = state_35048__$1;
(statearr_35050_35083[(2)] = null);

(statearr_35050_35083[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (1))){
var state_35048__$1 = state_35048;
var statearr_35051_35084 = state_35048__$1;
(statearr_35051_35084[(2)] = null);

(statearr_35051_35084[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (4))){
var inst_35012 = (state_35048[(7)]);
var inst_35014 = (inst_35012 < cnt);
var state_35048__$1 = state_35048;
if(cljs.core.truth_(inst_35014)){
var statearr_35052_35085 = state_35048__$1;
(statearr_35052_35085[(1)] = (6));

} else {
var statearr_35053_35086 = state_35048__$1;
(statearr_35053_35086[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (15))){
var inst_35044 = (state_35048[(2)]);
var state_35048__$1 = state_35048;
var statearr_35054_35087 = state_35048__$1;
(statearr_35054_35087[(2)] = inst_35044);

(statearr_35054_35087[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (13))){
var inst_35037 = cljs.core.async.close_BANG_(out);
var state_35048__$1 = state_35048;
var statearr_35055_35088 = state_35048__$1;
(statearr_35055_35088[(2)] = inst_35037);

(statearr_35055_35088[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (6))){
var state_35048__$1 = state_35048;
var statearr_35056_35089 = state_35048__$1;
(statearr_35056_35089[(2)] = null);

(statearr_35056_35089[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (3))){
var inst_35046 = (state_35048[(2)]);
var state_35048__$1 = state_35048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35048__$1,inst_35046);
} else {
if((state_val_35049 === (12))){
var inst_35034 = (state_35048[(8)]);
var inst_35034__$1 = (state_35048[(2)]);
var inst_35035 = cljs.core.some(cljs.core.nil_QMARK_,inst_35034__$1);
var state_35048__$1 = (function (){var statearr_35057 = state_35048;
(statearr_35057[(8)] = inst_35034__$1);

return statearr_35057;
})();
if(cljs.core.truth_(inst_35035)){
var statearr_35058_35090 = state_35048__$1;
(statearr_35058_35090[(1)] = (13));

} else {
var statearr_35059_35091 = state_35048__$1;
(statearr_35059_35091[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (2))){
var inst_35011 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_35012 = (0);
var state_35048__$1 = (function (){var statearr_35060 = state_35048;
(statearr_35060[(7)] = inst_35012);

(statearr_35060[(9)] = inst_35011);

return statearr_35060;
})();
var statearr_35061_35092 = state_35048__$1;
(statearr_35061_35092[(2)] = null);

(statearr_35061_35092[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (11))){
var inst_35012 = (state_35048[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_35048,(10),Object,null,(9));
var inst_35021 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_35012) : chs__$1.call(null,inst_35012));
var inst_35022 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_35012) : done.call(null,inst_35012));
var inst_35023 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_35021,inst_35022);
var state_35048__$1 = state_35048;
var statearr_35062_35093 = state_35048__$1;
(statearr_35062_35093[(2)] = inst_35023);


cljs.core.async.impl.ioc_helpers.process_exception(state_35048__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (9))){
var inst_35012 = (state_35048[(7)]);
var inst_35025 = (state_35048[(2)]);
var inst_35026 = (inst_35012 + (1));
var inst_35012__$1 = inst_35026;
var state_35048__$1 = (function (){var statearr_35063 = state_35048;
(statearr_35063[(7)] = inst_35012__$1);

(statearr_35063[(10)] = inst_35025);

return statearr_35063;
})();
var statearr_35064_35094 = state_35048__$1;
(statearr_35064_35094[(2)] = null);

(statearr_35064_35094[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (5))){
var inst_35032 = (state_35048[(2)]);
var state_35048__$1 = (function (){var statearr_35065 = state_35048;
(statearr_35065[(11)] = inst_35032);

return statearr_35065;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35048__$1,(12),dchan);
} else {
if((state_val_35049 === (14))){
var inst_35034 = (state_35048[(8)]);
var inst_35039 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_35034);
var state_35048__$1 = state_35048;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35048__$1,(16),out,inst_35039);
} else {
if((state_val_35049 === (16))){
var inst_35041 = (state_35048[(2)]);
var state_35048__$1 = (function (){var statearr_35066 = state_35048;
(statearr_35066[(12)] = inst_35041);

return statearr_35066;
})();
var statearr_35067_35095 = state_35048__$1;
(statearr_35067_35095[(2)] = null);

(statearr_35067_35095[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (10))){
var inst_35016 = (state_35048[(2)]);
var inst_35017 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_35048__$1 = (function (){var statearr_35068 = state_35048;
(statearr_35068[(13)] = inst_35016);

return statearr_35068;
})();
var statearr_35069_35096 = state_35048__$1;
(statearr_35069_35096[(2)] = inst_35017);


cljs.core.async.impl.ioc_helpers.process_exception(state_35048__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (8))){
var inst_35030 = (state_35048[(2)]);
var state_35048__$1 = state_35048;
var statearr_35070_35097 = state_35048__$1;
(statearr_35070_35097[(2)] = inst_35030);

(statearr_35070_35097[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___35082,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__12197__auto__,c__12309__auto___35082,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_35074 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35074[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_35074[(1)] = (1));

return statearr_35074;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_35048){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35048);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35075){if((e35075 instanceof Object)){
var ex__12201__auto__ = e35075;
var statearr_35076_35098 = state_35048;
(statearr_35076_35098[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35048);

return cljs.core.cst$kw$recur;
} else {
throw e35075;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35099 = state_35048;
state_35048 = G__35099;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_35048){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_35048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___35082,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__12311__auto__ = (function (){var statearr_35077 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35077[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___35082);

return statearr_35077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___35082,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args35101 = [];
var len__7484__auto___35159 = arguments.length;
var i__7485__auto___35160 = (0);
while(true){
if((i__7485__auto___35160 < len__7484__auto___35159)){
args35101.push((arguments[i__7485__auto___35160]));

var G__35161 = (i__7485__auto___35160 + (1));
i__7485__auto___35160 = G__35161;
continue;
} else {
}
break;
}

var G__35103 = args35101.length;
switch (G__35103) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35101.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12309__auto___35163 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___35163,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___35163,out){
return (function (state_35135){
var state_val_35136 = (state_35135[(1)]);
if((state_val_35136 === (7))){
var inst_35115 = (state_35135[(7)]);
var inst_35114 = (state_35135[(8)]);
var inst_35114__$1 = (state_35135[(2)]);
var inst_35115__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35114__$1,(0),null);
var inst_35116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35114__$1,(1),null);
var inst_35117 = (inst_35115__$1 == null);
var state_35135__$1 = (function (){var statearr_35137 = state_35135;
(statearr_35137[(9)] = inst_35116);

(statearr_35137[(7)] = inst_35115__$1);

(statearr_35137[(8)] = inst_35114__$1);

return statearr_35137;
})();
if(cljs.core.truth_(inst_35117)){
var statearr_35138_35164 = state_35135__$1;
(statearr_35138_35164[(1)] = (8));

} else {
var statearr_35139_35165 = state_35135__$1;
(statearr_35139_35165[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35136 === (1))){
var inst_35104 = cljs.core.vec(chs);
var inst_35105 = inst_35104;
var state_35135__$1 = (function (){var statearr_35140 = state_35135;
(statearr_35140[(10)] = inst_35105);

return statearr_35140;
})();
var statearr_35141_35166 = state_35135__$1;
(statearr_35141_35166[(2)] = null);

(statearr_35141_35166[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35136 === (4))){
var inst_35105 = (state_35135[(10)]);
var state_35135__$1 = state_35135;
return cljs.core.async.ioc_alts_BANG_(state_35135__$1,(7),inst_35105);
} else {
if((state_val_35136 === (6))){
var inst_35131 = (state_35135[(2)]);
var state_35135__$1 = state_35135;
var statearr_35142_35167 = state_35135__$1;
(statearr_35142_35167[(2)] = inst_35131);

(statearr_35142_35167[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35136 === (3))){
var inst_35133 = (state_35135[(2)]);
var state_35135__$1 = state_35135;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35135__$1,inst_35133);
} else {
if((state_val_35136 === (2))){
var inst_35105 = (state_35135[(10)]);
var inst_35107 = cljs.core.count(inst_35105);
var inst_35108 = (inst_35107 > (0));
var state_35135__$1 = state_35135;
if(cljs.core.truth_(inst_35108)){
var statearr_35144_35168 = state_35135__$1;
(statearr_35144_35168[(1)] = (4));

} else {
var statearr_35145_35169 = state_35135__$1;
(statearr_35145_35169[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35136 === (11))){
var inst_35105 = (state_35135[(10)]);
var inst_35124 = (state_35135[(2)]);
var tmp35143 = inst_35105;
var inst_35105__$1 = tmp35143;
var state_35135__$1 = (function (){var statearr_35146 = state_35135;
(statearr_35146[(11)] = inst_35124);

(statearr_35146[(10)] = inst_35105__$1);

return statearr_35146;
})();
var statearr_35147_35170 = state_35135__$1;
(statearr_35147_35170[(2)] = null);

(statearr_35147_35170[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35136 === (9))){
var inst_35115 = (state_35135[(7)]);
var state_35135__$1 = state_35135;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35135__$1,(11),out,inst_35115);
} else {
if((state_val_35136 === (5))){
var inst_35129 = cljs.core.async.close_BANG_(out);
var state_35135__$1 = state_35135;
var statearr_35148_35171 = state_35135__$1;
(statearr_35148_35171[(2)] = inst_35129);

(statearr_35148_35171[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35136 === (10))){
var inst_35127 = (state_35135[(2)]);
var state_35135__$1 = state_35135;
var statearr_35149_35172 = state_35135__$1;
(statearr_35149_35172[(2)] = inst_35127);

(statearr_35149_35172[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35136 === (8))){
var inst_35116 = (state_35135[(9)]);
var inst_35115 = (state_35135[(7)]);
var inst_35105 = (state_35135[(10)]);
var inst_35114 = (state_35135[(8)]);
var inst_35119 = (function (){var cs = inst_35105;
var vec__35110 = inst_35114;
var v = inst_35115;
var c = inst_35116;
return ((function (cs,vec__35110,v,c,inst_35116,inst_35115,inst_35105,inst_35114,state_val_35136,c__12309__auto___35163,out){
return (function (p1__35100_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__35100_SHARP_);
});
;})(cs,vec__35110,v,c,inst_35116,inst_35115,inst_35105,inst_35114,state_val_35136,c__12309__auto___35163,out))
})();
var inst_35120 = cljs.core.filterv(inst_35119,inst_35105);
var inst_35105__$1 = inst_35120;
var state_35135__$1 = (function (){var statearr_35150 = state_35135;
(statearr_35150[(10)] = inst_35105__$1);

return statearr_35150;
})();
var statearr_35151_35173 = state_35135__$1;
(statearr_35151_35173[(2)] = null);

(statearr_35151_35173[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___35163,out))
;
return ((function (switch__12197__auto__,c__12309__auto___35163,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_35155 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35155[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_35155[(1)] = (1));

return statearr_35155;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_35135){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35135);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35156){if((e35156 instanceof Object)){
var ex__12201__auto__ = e35156;
var statearr_35157_35174 = state_35135;
(statearr_35157_35174[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35135);

return cljs.core.cst$kw$recur;
} else {
throw e35156;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35175 = state_35135;
state_35135 = G__35175;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_35135){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_35135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___35163,out))
})();
var state__12311__auto__ = (function (){var statearr_35158 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35158[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___35163);

return statearr_35158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___35163,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args35176 = [];
var len__7484__auto___35225 = arguments.length;
var i__7485__auto___35226 = (0);
while(true){
if((i__7485__auto___35226 < len__7484__auto___35225)){
args35176.push((arguments[i__7485__auto___35226]));

var G__35227 = (i__7485__auto___35226 + (1));
i__7485__auto___35226 = G__35227;
continue;
} else {
}
break;
}

var G__35178 = args35176.length;
switch (G__35178) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35176.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12309__auto___35229 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___35229,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___35229,out){
return (function (state_35202){
var state_val_35203 = (state_35202[(1)]);
if((state_val_35203 === (7))){
var inst_35184 = (state_35202[(7)]);
var inst_35184__$1 = (state_35202[(2)]);
var inst_35185 = (inst_35184__$1 == null);
var inst_35186 = cljs.core.not(inst_35185);
var state_35202__$1 = (function (){var statearr_35204 = state_35202;
(statearr_35204[(7)] = inst_35184__$1);

return statearr_35204;
})();
if(inst_35186){
var statearr_35205_35230 = state_35202__$1;
(statearr_35205_35230[(1)] = (8));

} else {
var statearr_35206_35231 = state_35202__$1;
(statearr_35206_35231[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35203 === (1))){
var inst_35179 = (0);
var state_35202__$1 = (function (){var statearr_35207 = state_35202;
(statearr_35207[(8)] = inst_35179);

return statearr_35207;
})();
var statearr_35208_35232 = state_35202__$1;
(statearr_35208_35232[(2)] = null);

(statearr_35208_35232[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35203 === (4))){
var state_35202__$1 = state_35202;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35202__$1,(7),ch);
} else {
if((state_val_35203 === (6))){
var inst_35197 = (state_35202[(2)]);
var state_35202__$1 = state_35202;
var statearr_35209_35233 = state_35202__$1;
(statearr_35209_35233[(2)] = inst_35197);

(statearr_35209_35233[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35203 === (3))){
var inst_35199 = (state_35202[(2)]);
var inst_35200 = cljs.core.async.close_BANG_(out);
var state_35202__$1 = (function (){var statearr_35210 = state_35202;
(statearr_35210[(9)] = inst_35199);

return statearr_35210;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35202__$1,inst_35200);
} else {
if((state_val_35203 === (2))){
var inst_35179 = (state_35202[(8)]);
var inst_35181 = (inst_35179 < n);
var state_35202__$1 = state_35202;
if(cljs.core.truth_(inst_35181)){
var statearr_35211_35234 = state_35202__$1;
(statearr_35211_35234[(1)] = (4));

} else {
var statearr_35212_35235 = state_35202__$1;
(statearr_35212_35235[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35203 === (11))){
var inst_35179 = (state_35202[(8)]);
var inst_35189 = (state_35202[(2)]);
var inst_35190 = (inst_35179 + (1));
var inst_35179__$1 = inst_35190;
var state_35202__$1 = (function (){var statearr_35213 = state_35202;
(statearr_35213[(10)] = inst_35189);

(statearr_35213[(8)] = inst_35179__$1);

return statearr_35213;
})();
var statearr_35214_35236 = state_35202__$1;
(statearr_35214_35236[(2)] = null);

(statearr_35214_35236[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35203 === (9))){
var state_35202__$1 = state_35202;
var statearr_35215_35237 = state_35202__$1;
(statearr_35215_35237[(2)] = null);

(statearr_35215_35237[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35203 === (5))){
var state_35202__$1 = state_35202;
var statearr_35216_35238 = state_35202__$1;
(statearr_35216_35238[(2)] = null);

(statearr_35216_35238[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35203 === (10))){
var inst_35194 = (state_35202[(2)]);
var state_35202__$1 = state_35202;
var statearr_35217_35239 = state_35202__$1;
(statearr_35217_35239[(2)] = inst_35194);

(statearr_35217_35239[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35203 === (8))){
var inst_35184 = (state_35202[(7)]);
var state_35202__$1 = state_35202;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35202__$1,(11),out,inst_35184);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___35229,out))
;
return ((function (switch__12197__auto__,c__12309__auto___35229,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_35221 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35221[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_35221[(1)] = (1));

return statearr_35221;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_35202){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35202);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35222){if((e35222 instanceof Object)){
var ex__12201__auto__ = e35222;
var statearr_35223_35240 = state_35202;
(statearr_35223_35240[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35202);

return cljs.core.cst$kw$recur;
} else {
throw e35222;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35241 = state_35202;
state_35202 = G__35241;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_35202){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_35202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___35229,out))
})();
var state__12311__auto__ = (function (){var statearr_35224 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35224[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___35229);

return statearr_35224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___35229,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async35251 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35251 = (function (map_LT_,f,ch,meta35252){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta35252 = meta35252;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35251.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35253,meta35252__$1){
var self__ = this;
var _35253__$1 = this;
return (new cljs.core.async.t_cljs$core$async35251(self__.map_LT_,self__.f,self__.ch,meta35252__$1));
});

cljs.core.async.t_cljs$core$async35251.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35253){
var self__ = this;
var _35253__$1 = this;
return self__.meta35252;
});

cljs.core.async.t_cljs$core$async35251.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async35251.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async35251.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async35251.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async35251.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async35254 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35254 = (function (map_LT_,f,ch,meta35252,_,fn1,meta35255){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta35252 = meta35252;
this._ = _;
this.fn1 = fn1;
this.meta35255 = meta35255;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35254.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_35256,meta35255__$1){
var self__ = this;
var _35256__$1 = this;
return (new cljs.core.async.t_cljs$core$async35254(self__.map_LT_,self__.f,self__.ch,self__.meta35252,self__._,self__.fn1,meta35255__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async35254.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_35256){
var self__ = this;
var _35256__$1 = this;
return self__.meta35255;
});})(___$1))
;

cljs.core.async.t_cljs$core$async35254.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async35254.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async35254.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async35254.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__35242_SHARP_){
var G__35257 = (((p1__35242_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__35242_SHARP_) : self__.f.call(null,p1__35242_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__35257) : f1.call(null,G__35257));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async35254.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta35252,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async35251], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta35255], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async35254.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35254.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35254";

cljs.core.async.t_cljs$core$async35254.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async35254");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async35254 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async35254(map_LT___$1,f__$1,ch__$1,meta35252__$1,___$2,fn1__$1,meta35255){
return (new cljs.core.async.t_cljs$core$async35254(map_LT___$1,f__$1,ch__$1,meta35252__$1,___$2,fn1__$1,meta35255));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async35254(self__.map_LT_,self__.f,self__.ch,self__.meta35252,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__35258 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__35258) : self__.f.call(null,G__35258));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async35251.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async35251.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async35251.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta35252], null);
});

cljs.core.async.t_cljs$core$async35251.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35251.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35251";

cljs.core.async.t_cljs$core$async35251.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async35251");
});

cljs.core.async.__GT_t_cljs$core$async35251 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async35251(map_LT___$1,f__$1,ch__$1,meta35252){
return (new cljs.core.async.t_cljs$core$async35251(map_LT___$1,f__$1,ch__$1,meta35252));
});

}

return (new cljs.core.async.t_cljs$core$async35251(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async35262 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35262 = (function (map_GT_,f,ch,meta35263){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta35263 = meta35263;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35262.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35264,meta35263__$1){
var self__ = this;
var _35264__$1 = this;
return (new cljs.core.async.t_cljs$core$async35262(self__.map_GT_,self__.f,self__.ch,meta35263__$1));
});

cljs.core.async.t_cljs$core$async35262.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35264){
var self__ = this;
var _35264__$1 = this;
return self__.meta35263;
});

cljs.core.async.t_cljs$core$async35262.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async35262.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async35262.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async35262.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async35262.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async35262.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async35262.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta35263], null);
});

cljs.core.async.t_cljs$core$async35262.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35262.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35262";

cljs.core.async.t_cljs$core$async35262.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async35262");
});

cljs.core.async.__GT_t_cljs$core$async35262 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async35262(map_GT___$1,f__$1,ch__$1,meta35263){
return (new cljs.core.async.t_cljs$core$async35262(map_GT___$1,f__$1,ch__$1,meta35263));
});

}

return (new cljs.core.async.t_cljs$core$async35262(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async35268 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35268 = (function (filter_GT_,p,ch,meta35269){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta35269 = meta35269;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35268.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35270,meta35269__$1){
var self__ = this;
var _35270__$1 = this;
return (new cljs.core.async.t_cljs$core$async35268(self__.filter_GT_,self__.p,self__.ch,meta35269__$1));
});

cljs.core.async.t_cljs$core$async35268.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35270){
var self__ = this;
var _35270__$1 = this;
return self__.meta35269;
});

cljs.core.async.t_cljs$core$async35268.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async35268.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async35268.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async35268.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async35268.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async35268.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async35268.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async35268.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta35269], null);
});

cljs.core.async.t_cljs$core$async35268.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35268.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35268";

cljs.core.async.t_cljs$core$async35268.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async35268");
});

cljs.core.async.__GT_t_cljs$core$async35268 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async35268(filter_GT___$1,p__$1,ch__$1,meta35269){
return (new cljs.core.async.t_cljs$core$async35268(filter_GT___$1,p__$1,ch__$1,meta35269));
});

}

return (new cljs.core.async.t_cljs$core$async35268(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args35271 = [];
var len__7484__auto___35315 = arguments.length;
var i__7485__auto___35316 = (0);
while(true){
if((i__7485__auto___35316 < len__7484__auto___35315)){
args35271.push((arguments[i__7485__auto___35316]));

var G__35317 = (i__7485__auto___35316 + (1));
i__7485__auto___35316 = G__35317;
continue;
} else {
}
break;
}

var G__35273 = args35271.length;
switch (G__35273) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35271.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12309__auto___35319 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___35319,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___35319,out){
return (function (state_35294){
var state_val_35295 = (state_35294[(1)]);
if((state_val_35295 === (7))){
var inst_35290 = (state_35294[(2)]);
var state_35294__$1 = state_35294;
var statearr_35296_35320 = state_35294__$1;
(statearr_35296_35320[(2)] = inst_35290);

(statearr_35296_35320[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35295 === (1))){
var state_35294__$1 = state_35294;
var statearr_35297_35321 = state_35294__$1;
(statearr_35297_35321[(2)] = null);

(statearr_35297_35321[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35295 === (4))){
var inst_35276 = (state_35294[(7)]);
var inst_35276__$1 = (state_35294[(2)]);
var inst_35277 = (inst_35276__$1 == null);
var state_35294__$1 = (function (){var statearr_35298 = state_35294;
(statearr_35298[(7)] = inst_35276__$1);

return statearr_35298;
})();
if(cljs.core.truth_(inst_35277)){
var statearr_35299_35322 = state_35294__$1;
(statearr_35299_35322[(1)] = (5));

} else {
var statearr_35300_35323 = state_35294__$1;
(statearr_35300_35323[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35295 === (6))){
var inst_35276 = (state_35294[(7)]);
var inst_35281 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_35276) : p.call(null,inst_35276));
var state_35294__$1 = state_35294;
if(cljs.core.truth_(inst_35281)){
var statearr_35301_35324 = state_35294__$1;
(statearr_35301_35324[(1)] = (8));

} else {
var statearr_35302_35325 = state_35294__$1;
(statearr_35302_35325[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35295 === (3))){
var inst_35292 = (state_35294[(2)]);
var state_35294__$1 = state_35294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35294__$1,inst_35292);
} else {
if((state_val_35295 === (2))){
var state_35294__$1 = state_35294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35294__$1,(4),ch);
} else {
if((state_val_35295 === (11))){
var inst_35284 = (state_35294[(2)]);
var state_35294__$1 = state_35294;
var statearr_35303_35326 = state_35294__$1;
(statearr_35303_35326[(2)] = inst_35284);

(statearr_35303_35326[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35295 === (9))){
var state_35294__$1 = state_35294;
var statearr_35304_35327 = state_35294__$1;
(statearr_35304_35327[(2)] = null);

(statearr_35304_35327[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35295 === (5))){
var inst_35279 = cljs.core.async.close_BANG_(out);
var state_35294__$1 = state_35294;
var statearr_35305_35328 = state_35294__$1;
(statearr_35305_35328[(2)] = inst_35279);

(statearr_35305_35328[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35295 === (10))){
var inst_35287 = (state_35294[(2)]);
var state_35294__$1 = (function (){var statearr_35306 = state_35294;
(statearr_35306[(8)] = inst_35287);

return statearr_35306;
})();
var statearr_35307_35329 = state_35294__$1;
(statearr_35307_35329[(2)] = null);

(statearr_35307_35329[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35295 === (8))){
var inst_35276 = (state_35294[(7)]);
var state_35294__$1 = state_35294;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35294__$1,(11),out,inst_35276);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___35319,out))
;
return ((function (switch__12197__auto__,c__12309__auto___35319,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_35311 = [null,null,null,null,null,null,null,null,null];
(statearr_35311[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_35311[(1)] = (1));

return statearr_35311;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_35294){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35294);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35312){if((e35312 instanceof Object)){
var ex__12201__auto__ = e35312;
var statearr_35313_35330 = state_35294;
(statearr_35313_35330[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35294);

return cljs.core.cst$kw$recur;
} else {
throw e35312;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35331 = state_35294;
state_35294 = G__35331;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_35294){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_35294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___35319,out))
})();
var state__12311__auto__ = (function (){var statearr_35314 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35314[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___35319);

return statearr_35314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___35319,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args35332 = [];
var len__7484__auto___35335 = arguments.length;
var i__7485__auto___35336 = (0);
while(true){
if((i__7485__auto___35336 < len__7484__auto___35335)){
args35332.push((arguments[i__7485__auto___35336]));

var G__35337 = (i__7485__auto___35336 + (1));
i__7485__auto___35336 = G__35337;
continue;
} else {
}
break;
}

var G__35334 = args35332.length;
switch (G__35334) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35332.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__){
return (function (state_35504){
var state_val_35505 = (state_35504[(1)]);
if((state_val_35505 === (7))){
var inst_35500 = (state_35504[(2)]);
var state_35504__$1 = state_35504;
var statearr_35506_35547 = state_35504__$1;
(statearr_35506_35547[(2)] = inst_35500);

(statearr_35506_35547[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (20))){
var inst_35470 = (state_35504[(7)]);
var inst_35481 = (state_35504[(2)]);
var inst_35482 = cljs.core.next(inst_35470);
var inst_35456 = inst_35482;
var inst_35457 = null;
var inst_35458 = (0);
var inst_35459 = (0);
var state_35504__$1 = (function (){var statearr_35507 = state_35504;
(statearr_35507[(8)] = inst_35456);

(statearr_35507[(9)] = inst_35458);

(statearr_35507[(10)] = inst_35481);

(statearr_35507[(11)] = inst_35459);

(statearr_35507[(12)] = inst_35457);

return statearr_35507;
})();
var statearr_35508_35548 = state_35504__$1;
(statearr_35508_35548[(2)] = null);

(statearr_35508_35548[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (1))){
var state_35504__$1 = state_35504;
var statearr_35509_35549 = state_35504__$1;
(statearr_35509_35549[(2)] = null);

(statearr_35509_35549[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (4))){
var inst_35445 = (state_35504[(13)]);
var inst_35445__$1 = (state_35504[(2)]);
var inst_35446 = (inst_35445__$1 == null);
var state_35504__$1 = (function (){var statearr_35510 = state_35504;
(statearr_35510[(13)] = inst_35445__$1);

return statearr_35510;
})();
if(cljs.core.truth_(inst_35446)){
var statearr_35511_35550 = state_35504__$1;
(statearr_35511_35550[(1)] = (5));

} else {
var statearr_35512_35551 = state_35504__$1;
(statearr_35512_35551[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (15))){
var state_35504__$1 = state_35504;
var statearr_35516_35552 = state_35504__$1;
(statearr_35516_35552[(2)] = null);

(statearr_35516_35552[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (21))){
var state_35504__$1 = state_35504;
var statearr_35517_35553 = state_35504__$1;
(statearr_35517_35553[(2)] = null);

(statearr_35517_35553[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (13))){
var inst_35456 = (state_35504[(8)]);
var inst_35458 = (state_35504[(9)]);
var inst_35459 = (state_35504[(11)]);
var inst_35457 = (state_35504[(12)]);
var inst_35466 = (state_35504[(2)]);
var inst_35467 = (inst_35459 + (1));
var tmp35513 = inst_35456;
var tmp35514 = inst_35458;
var tmp35515 = inst_35457;
var inst_35456__$1 = tmp35513;
var inst_35457__$1 = tmp35515;
var inst_35458__$1 = tmp35514;
var inst_35459__$1 = inst_35467;
var state_35504__$1 = (function (){var statearr_35518 = state_35504;
(statearr_35518[(8)] = inst_35456__$1);

(statearr_35518[(9)] = inst_35458__$1);

(statearr_35518[(11)] = inst_35459__$1);

(statearr_35518[(14)] = inst_35466);

(statearr_35518[(12)] = inst_35457__$1);

return statearr_35518;
})();
var statearr_35519_35554 = state_35504__$1;
(statearr_35519_35554[(2)] = null);

(statearr_35519_35554[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (22))){
var state_35504__$1 = state_35504;
var statearr_35520_35555 = state_35504__$1;
(statearr_35520_35555[(2)] = null);

(statearr_35520_35555[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (6))){
var inst_35445 = (state_35504[(13)]);
var inst_35454 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_35445) : f.call(null,inst_35445));
var inst_35455 = cljs.core.seq(inst_35454);
var inst_35456 = inst_35455;
var inst_35457 = null;
var inst_35458 = (0);
var inst_35459 = (0);
var state_35504__$1 = (function (){var statearr_35521 = state_35504;
(statearr_35521[(8)] = inst_35456);

(statearr_35521[(9)] = inst_35458);

(statearr_35521[(11)] = inst_35459);

(statearr_35521[(12)] = inst_35457);

return statearr_35521;
})();
var statearr_35522_35556 = state_35504__$1;
(statearr_35522_35556[(2)] = null);

(statearr_35522_35556[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (17))){
var inst_35470 = (state_35504[(7)]);
var inst_35474 = cljs.core.chunk_first(inst_35470);
var inst_35475 = cljs.core.chunk_rest(inst_35470);
var inst_35476 = cljs.core.count(inst_35474);
var inst_35456 = inst_35475;
var inst_35457 = inst_35474;
var inst_35458 = inst_35476;
var inst_35459 = (0);
var state_35504__$1 = (function (){var statearr_35523 = state_35504;
(statearr_35523[(8)] = inst_35456);

(statearr_35523[(9)] = inst_35458);

(statearr_35523[(11)] = inst_35459);

(statearr_35523[(12)] = inst_35457);

return statearr_35523;
})();
var statearr_35524_35557 = state_35504__$1;
(statearr_35524_35557[(2)] = null);

(statearr_35524_35557[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (3))){
var inst_35502 = (state_35504[(2)]);
var state_35504__$1 = state_35504;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35504__$1,inst_35502);
} else {
if((state_val_35505 === (12))){
var inst_35490 = (state_35504[(2)]);
var state_35504__$1 = state_35504;
var statearr_35525_35558 = state_35504__$1;
(statearr_35525_35558[(2)] = inst_35490);

(statearr_35525_35558[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (2))){
var state_35504__$1 = state_35504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35504__$1,(4),in$);
} else {
if((state_val_35505 === (23))){
var inst_35498 = (state_35504[(2)]);
var state_35504__$1 = state_35504;
var statearr_35526_35559 = state_35504__$1;
(statearr_35526_35559[(2)] = inst_35498);

(statearr_35526_35559[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (19))){
var inst_35485 = (state_35504[(2)]);
var state_35504__$1 = state_35504;
var statearr_35527_35560 = state_35504__$1;
(statearr_35527_35560[(2)] = inst_35485);

(statearr_35527_35560[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (11))){
var inst_35456 = (state_35504[(8)]);
var inst_35470 = (state_35504[(7)]);
var inst_35470__$1 = cljs.core.seq(inst_35456);
var state_35504__$1 = (function (){var statearr_35528 = state_35504;
(statearr_35528[(7)] = inst_35470__$1);

return statearr_35528;
})();
if(inst_35470__$1){
var statearr_35529_35561 = state_35504__$1;
(statearr_35529_35561[(1)] = (14));

} else {
var statearr_35530_35562 = state_35504__$1;
(statearr_35530_35562[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (9))){
var inst_35492 = (state_35504[(2)]);
var inst_35493 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_35504__$1 = (function (){var statearr_35531 = state_35504;
(statearr_35531[(15)] = inst_35492);

return statearr_35531;
})();
if(cljs.core.truth_(inst_35493)){
var statearr_35532_35563 = state_35504__$1;
(statearr_35532_35563[(1)] = (21));

} else {
var statearr_35533_35564 = state_35504__$1;
(statearr_35533_35564[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (5))){
var inst_35448 = cljs.core.async.close_BANG_(out);
var state_35504__$1 = state_35504;
var statearr_35534_35565 = state_35504__$1;
(statearr_35534_35565[(2)] = inst_35448);

(statearr_35534_35565[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (14))){
var inst_35470 = (state_35504[(7)]);
var inst_35472 = cljs.core.chunked_seq_QMARK_(inst_35470);
var state_35504__$1 = state_35504;
if(inst_35472){
var statearr_35535_35566 = state_35504__$1;
(statearr_35535_35566[(1)] = (17));

} else {
var statearr_35536_35567 = state_35504__$1;
(statearr_35536_35567[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (16))){
var inst_35488 = (state_35504[(2)]);
var state_35504__$1 = state_35504;
var statearr_35537_35568 = state_35504__$1;
(statearr_35537_35568[(2)] = inst_35488);

(statearr_35537_35568[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35505 === (10))){
var inst_35459 = (state_35504[(11)]);
var inst_35457 = (state_35504[(12)]);
var inst_35464 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_35457,inst_35459);
var state_35504__$1 = state_35504;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35504__$1,(13),out,inst_35464);
} else {
if((state_val_35505 === (18))){
var inst_35470 = (state_35504[(7)]);
var inst_35479 = cljs.core.first(inst_35470);
var state_35504__$1 = state_35504;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35504__$1,(20),out,inst_35479);
} else {
if((state_val_35505 === (8))){
var inst_35458 = (state_35504[(9)]);
var inst_35459 = (state_35504[(11)]);
var inst_35461 = (inst_35459 < inst_35458);
var inst_35462 = inst_35461;
var state_35504__$1 = state_35504;
if(cljs.core.truth_(inst_35462)){
var statearr_35538_35569 = state_35504__$1;
(statearr_35538_35569[(1)] = (10));

} else {
var statearr_35539_35570 = state_35504__$1;
(statearr_35539_35570[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__))
;
return ((function (switch__12197__auto__,c__12309__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_35543 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35543[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__);

(statearr_35543[(1)] = (1));

return statearr_35543;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____1 = (function (state_35504){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35504);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35544){if((e35544 instanceof Object)){
var ex__12201__auto__ = e35544;
var statearr_35545_35571 = state_35504;
(statearr_35545_35571[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35504);

return cljs.core.cst$kw$recur;
} else {
throw e35544;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35572 = state_35504;
state_35504 = G__35572;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__ = function(state_35504){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____1.call(this,state_35504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__))
})();
var state__12311__auto__ = (function (){var statearr_35546 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35546[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_35546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__))
);

return c__12309__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args35573 = [];
var len__7484__auto___35576 = arguments.length;
var i__7485__auto___35577 = (0);
while(true){
if((i__7485__auto___35577 < len__7484__auto___35576)){
args35573.push((arguments[i__7485__auto___35577]));

var G__35578 = (i__7485__auto___35577 + (1));
i__7485__auto___35577 = G__35578;
continue;
} else {
}
break;
}

var G__35575 = args35573.length;
switch (G__35575) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35573.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args35580 = [];
var len__7484__auto___35583 = arguments.length;
var i__7485__auto___35584 = (0);
while(true){
if((i__7485__auto___35584 < len__7484__auto___35583)){
args35580.push((arguments[i__7485__auto___35584]));

var G__35585 = (i__7485__auto___35584 + (1));
i__7485__auto___35584 = G__35585;
continue;
} else {
}
break;
}

var G__35582 = args35580.length;
switch (G__35582) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35580.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args35587 = [];
var len__7484__auto___35638 = arguments.length;
var i__7485__auto___35639 = (0);
while(true){
if((i__7485__auto___35639 < len__7484__auto___35638)){
args35587.push((arguments[i__7485__auto___35639]));

var G__35640 = (i__7485__auto___35639 + (1));
i__7485__auto___35639 = G__35640;
continue;
} else {
}
break;
}

var G__35589 = args35587.length;
switch (G__35589) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35587.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12309__auto___35642 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___35642,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___35642,out){
return (function (state_35613){
var state_val_35614 = (state_35613[(1)]);
if((state_val_35614 === (7))){
var inst_35608 = (state_35613[(2)]);
var state_35613__$1 = state_35613;
var statearr_35615_35643 = state_35613__$1;
(statearr_35615_35643[(2)] = inst_35608);

(statearr_35615_35643[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35614 === (1))){
var inst_35590 = null;
var state_35613__$1 = (function (){var statearr_35616 = state_35613;
(statearr_35616[(7)] = inst_35590);

return statearr_35616;
})();
var statearr_35617_35644 = state_35613__$1;
(statearr_35617_35644[(2)] = null);

(statearr_35617_35644[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35614 === (4))){
var inst_35593 = (state_35613[(8)]);
var inst_35593__$1 = (state_35613[(2)]);
var inst_35594 = (inst_35593__$1 == null);
var inst_35595 = cljs.core.not(inst_35594);
var state_35613__$1 = (function (){var statearr_35618 = state_35613;
(statearr_35618[(8)] = inst_35593__$1);

return statearr_35618;
})();
if(inst_35595){
var statearr_35619_35645 = state_35613__$1;
(statearr_35619_35645[(1)] = (5));

} else {
var statearr_35620_35646 = state_35613__$1;
(statearr_35620_35646[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35614 === (6))){
var state_35613__$1 = state_35613;
var statearr_35621_35647 = state_35613__$1;
(statearr_35621_35647[(2)] = null);

(statearr_35621_35647[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35614 === (3))){
var inst_35610 = (state_35613[(2)]);
var inst_35611 = cljs.core.async.close_BANG_(out);
var state_35613__$1 = (function (){var statearr_35622 = state_35613;
(statearr_35622[(9)] = inst_35610);

return statearr_35622;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35613__$1,inst_35611);
} else {
if((state_val_35614 === (2))){
var state_35613__$1 = state_35613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35613__$1,(4),ch);
} else {
if((state_val_35614 === (11))){
var inst_35593 = (state_35613[(8)]);
var inst_35602 = (state_35613[(2)]);
var inst_35590 = inst_35593;
var state_35613__$1 = (function (){var statearr_35623 = state_35613;
(statearr_35623[(10)] = inst_35602);

(statearr_35623[(7)] = inst_35590);

return statearr_35623;
})();
var statearr_35624_35648 = state_35613__$1;
(statearr_35624_35648[(2)] = null);

(statearr_35624_35648[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35614 === (9))){
var inst_35593 = (state_35613[(8)]);
var state_35613__$1 = state_35613;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35613__$1,(11),out,inst_35593);
} else {
if((state_val_35614 === (5))){
var inst_35590 = (state_35613[(7)]);
var inst_35593 = (state_35613[(8)]);
var inst_35597 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35593,inst_35590);
var state_35613__$1 = state_35613;
if(inst_35597){
var statearr_35626_35649 = state_35613__$1;
(statearr_35626_35649[(1)] = (8));

} else {
var statearr_35627_35650 = state_35613__$1;
(statearr_35627_35650[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35614 === (10))){
var inst_35605 = (state_35613[(2)]);
var state_35613__$1 = state_35613;
var statearr_35628_35651 = state_35613__$1;
(statearr_35628_35651[(2)] = inst_35605);

(statearr_35628_35651[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35614 === (8))){
var inst_35590 = (state_35613[(7)]);
var tmp35625 = inst_35590;
var inst_35590__$1 = tmp35625;
var state_35613__$1 = (function (){var statearr_35629 = state_35613;
(statearr_35629[(7)] = inst_35590__$1);

return statearr_35629;
})();
var statearr_35630_35652 = state_35613__$1;
(statearr_35630_35652[(2)] = null);

(statearr_35630_35652[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___35642,out))
;
return ((function (switch__12197__auto__,c__12309__auto___35642,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_35634 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35634[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_35634[(1)] = (1));

return statearr_35634;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_35613){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35613);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35635){if((e35635 instanceof Object)){
var ex__12201__auto__ = e35635;
var statearr_35636_35653 = state_35613;
(statearr_35636_35653[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35613);

return cljs.core.cst$kw$recur;
} else {
throw e35635;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35654 = state_35613;
state_35613 = G__35654;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_35613){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_35613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___35642,out))
})();
var state__12311__auto__ = (function (){var statearr_35637 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35637[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___35642);

return statearr_35637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___35642,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args35655 = [];
var len__7484__auto___35725 = arguments.length;
var i__7485__auto___35726 = (0);
while(true){
if((i__7485__auto___35726 < len__7484__auto___35725)){
args35655.push((arguments[i__7485__auto___35726]));

var G__35727 = (i__7485__auto___35726 + (1));
i__7485__auto___35726 = G__35727;
continue;
} else {
}
break;
}

var G__35657 = args35655.length;
switch (G__35657) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35655.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12309__auto___35729 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___35729,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___35729,out){
return (function (state_35695){
var state_val_35696 = (state_35695[(1)]);
if((state_val_35696 === (7))){
var inst_35691 = (state_35695[(2)]);
var state_35695__$1 = state_35695;
var statearr_35697_35730 = state_35695__$1;
(statearr_35697_35730[(2)] = inst_35691);

(statearr_35697_35730[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35696 === (1))){
var inst_35658 = (new Array(n));
var inst_35659 = inst_35658;
var inst_35660 = (0);
var state_35695__$1 = (function (){var statearr_35698 = state_35695;
(statearr_35698[(7)] = inst_35659);

(statearr_35698[(8)] = inst_35660);

return statearr_35698;
})();
var statearr_35699_35731 = state_35695__$1;
(statearr_35699_35731[(2)] = null);

(statearr_35699_35731[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35696 === (4))){
var inst_35663 = (state_35695[(9)]);
var inst_35663__$1 = (state_35695[(2)]);
var inst_35664 = (inst_35663__$1 == null);
var inst_35665 = cljs.core.not(inst_35664);
var state_35695__$1 = (function (){var statearr_35700 = state_35695;
(statearr_35700[(9)] = inst_35663__$1);

return statearr_35700;
})();
if(inst_35665){
var statearr_35701_35732 = state_35695__$1;
(statearr_35701_35732[(1)] = (5));

} else {
var statearr_35702_35733 = state_35695__$1;
(statearr_35702_35733[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35696 === (15))){
var inst_35685 = (state_35695[(2)]);
var state_35695__$1 = state_35695;
var statearr_35703_35734 = state_35695__$1;
(statearr_35703_35734[(2)] = inst_35685);

(statearr_35703_35734[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35696 === (13))){
var state_35695__$1 = state_35695;
var statearr_35704_35735 = state_35695__$1;
(statearr_35704_35735[(2)] = null);

(statearr_35704_35735[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35696 === (6))){
var inst_35660 = (state_35695[(8)]);
var inst_35681 = (inst_35660 > (0));
var state_35695__$1 = state_35695;
if(cljs.core.truth_(inst_35681)){
var statearr_35705_35736 = state_35695__$1;
(statearr_35705_35736[(1)] = (12));

} else {
var statearr_35706_35737 = state_35695__$1;
(statearr_35706_35737[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35696 === (3))){
var inst_35693 = (state_35695[(2)]);
var state_35695__$1 = state_35695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35695__$1,inst_35693);
} else {
if((state_val_35696 === (12))){
var inst_35659 = (state_35695[(7)]);
var inst_35683 = cljs.core.vec(inst_35659);
var state_35695__$1 = state_35695;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35695__$1,(15),out,inst_35683);
} else {
if((state_val_35696 === (2))){
var state_35695__$1 = state_35695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35695__$1,(4),ch);
} else {
if((state_val_35696 === (11))){
var inst_35675 = (state_35695[(2)]);
var inst_35676 = (new Array(n));
var inst_35659 = inst_35676;
var inst_35660 = (0);
var state_35695__$1 = (function (){var statearr_35707 = state_35695;
(statearr_35707[(7)] = inst_35659);

(statearr_35707[(8)] = inst_35660);

(statearr_35707[(10)] = inst_35675);

return statearr_35707;
})();
var statearr_35708_35738 = state_35695__$1;
(statearr_35708_35738[(2)] = null);

(statearr_35708_35738[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35696 === (9))){
var inst_35659 = (state_35695[(7)]);
var inst_35673 = cljs.core.vec(inst_35659);
var state_35695__$1 = state_35695;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35695__$1,(11),out,inst_35673);
} else {
if((state_val_35696 === (5))){
var inst_35659 = (state_35695[(7)]);
var inst_35668 = (state_35695[(11)]);
var inst_35660 = (state_35695[(8)]);
var inst_35663 = (state_35695[(9)]);
var inst_35667 = (inst_35659[inst_35660] = inst_35663);
var inst_35668__$1 = (inst_35660 + (1));
var inst_35669 = (inst_35668__$1 < n);
var state_35695__$1 = (function (){var statearr_35709 = state_35695;
(statearr_35709[(12)] = inst_35667);

(statearr_35709[(11)] = inst_35668__$1);

return statearr_35709;
})();
if(cljs.core.truth_(inst_35669)){
var statearr_35710_35739 = state_35695__$1;
(statearr_35710_35739[(1)] = (8));

} else {
var statearr_35711_35740 = state_35695__$1;
(statearr_35711_35740[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35696 === (14))){
var inst_35688 = (state_35695[(2)]);
var inst_35689 = cljs.core.async.close_BANG_(out);
var state_35695__$1 = (function (){var statearr_35713 = state_35695;
(statearr_35713[(13)] = inst_35688);

return statearr_35713;
})();
var statearr_35714_35741 = state_35695__$1;
(statearr_35714_35741[(2)] = inst_35689);

(statearr_35714_35741[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35696 === (10))){
var inst_35679 = (state_35695[(2)]);
var state_35695__$1 = state_35695;
var statearr_35715_35742 = state_35695__$1;
(statearr_35715_35742[(2)] = inst_35679);

(statearr_35715_35742[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35696 === (8))){
var inst_35659 = (state_35695[(7)]);
var inst_35668 = (state_35695[(11)]);
var tmp35712 = inst_35659;
var inst_35659__$1 = tmp35712;
var inst_35660 = inst_35668;
var state_35695__$1 = (function (){var statearr_35716 = state_35695;
(statearr_35716[(7)] = inst_35659__$1);

(statearr_35716[(8)] = inst_35660);

return statearr_35716;
})();
var statearr_35717_35743 = state_35695__$1;
(statearr_35717_35743[(2)] = null);

(statearr_35717_35743[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___35729,out))
;
return ((function (switch__12197__auto__,c__12309__auto___35729,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_35721 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35721[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_35721[(1)] = (1));

return statearr_35721;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_35695){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35695);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35722){if((e35722 instanceof Object)){
var ex__12201__auto__ = e35722;
var statearr_35723_35744 = state_35695;
(statearr_35723_35744[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35695);

return cljs.core.cst$kw$recur;
} else {
throw e35722;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35745 = state_35695;
state_35695 = G__35745;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_35695){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_35695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___35729,out))
})();
var state__12311__auto__ = (function (){var statearr_35724 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35724[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___35729);

return statearr_35724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___35729,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args35746 = [];
var len__7484__auto___35820 = arguments.length;
var i__7485__auto___35821 = (0);
while(true){
if((i__7485__auto___35821 < len__7484__auto___35820)){
args35746.push((arguments[i__7485__auto___35821]));

var G__35822 = (i__7485__auto___35821 + (1));
i__7485__auto___35821 = G__35822;
continue;
} else {
}
break;
}

var G__35748 = args35746.length;
switch (G__35748) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35746.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12309__auto___35824 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___35824,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___35824,out){
return (function (state_35790){
var state_val_35791 = (state_35790[(1)]);
if((state_val_35791 === (7))){
var inst_35786 = (state_35790[(2)]);
var state_35790__$1 = state_35790;
var statearr_35792_35825 = state_35790__$1;
(statearr_35792_35825[(2)] = inst_35786);

(statearr_35792_35825[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35791 === (1))){
var inst_35749 = [];
var inst_35750 = inst_35749;
var inst_35751 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_35790__$1 = (function (){var statearr_35793 = state_35790;
(statearr_35793[(7)] = inst_35750);

(statearr_35793[(8)] = inst_35751);

return statearr_35793;
})();
var statearr_35794_35826 = state_35790__$1;
(statearr_35794_35826[(2)] = null);

(statearr_35794_35826[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35791 === (4))){
var inst_35754 = (state_35790[(9)]);
var inst_35754__$1 = (state_35790[(2)]);
var inst_35755 = (inst_35754__$1 == null);
var inst_35756 = cljs.core.not(inst_35755);
var state_35790__$1 = (function (){var statearr_35795 = state_35790;
(statearr_35795[(9)] = inst_35754__$1);

return statearr_35795;
})();
if(inst_35756){
var statearr_35796_35827 = state_35790__$1;
(statearr_35796_35827[(1)] = (5));

} else {
var statearr_35797_35828 = state_35790__$1;
(statearr_35797_35828[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35791 === (15))){
var inst_35780 = (state_35790[(2)]);
var state_35790__$1 = state_35790;
var statearr_35798_35829 = state_35790__$1;
(statearr_35798_35829[(2)] = inst_35780);

(statearr_35798_35829[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35791 === (13))){
var state_35790__$1 = state_35790;
var statearr_35799_35830 = state_35790__$1;
(statearr_35799_35830[(2)] = null);

(statearr_35799_35830[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35791 === (6))){
var inst_35750 = (state_35790[(7)]);
var inst_35775 = inst_35750.length;
var inst_35776 = (inst_35775 > (0));
var state_35790__$1 = state_35790;
if(cljs.core.truth_(inst_35776)){
var statearr_35800_35831 = state_35790__$1;
(statearr_35800_35831[(1)] = (12));

} else {
var statearr_35801_35832 = state_35790__$1;
(statearr_35801_35832[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35791 === (3))){
var inst_35788 = (state_35790[(2)]);
var state_35790__$1 = state_35790;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35790__$1,inst_35788);
} else {
if((state_val_35791 === (12))){
var inst_35750 = (state_35790[(7)]);
var inst_35778 = cljs.core.vec(inst_35750);
var state_35790__$1 = state_35790;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35790__$1,(15),out,inst_35778);
} else {
if((state_val_35791 === (2))){
var state_35790__$1 = state_35790;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35790__$1,(4),ch);
} else {
if((state_val_35791 === (11))){
var inst_35754 = (state_35790[(9)]);
var inst_35758 = (state_35790[(10)]);
var inst_35768 = (state_35790[(2)]);
var inst_35769 = [];
var inst_35770 = inst_35769.push(inst_35754);
var inst_35750 = inst_35769;
var inst_35751 = inst_35758;
var state_35790__$1 = (function (){var statearr_35802 = state_35790;
(statearr_35802[(7)] = inst_35750);

(statearr_35802[(11)] = inst_35768);

(statearr_35802[(8)] = inst_35751);

(statearr_35802[(12)] = inst_35770);

return statearr_35802;
})();
var statearr_35803_35833 = state_35790__$1;
(statearr_35803_35833[(2)] = null);

(statearr_35803_35833[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35791 === (9))){
var inst_35750 = (state_35790[(7)]);
var inst_35766 = cljs.core.vec(inst_35750);
var state_35790__$1 = state_35790;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35790__$1,(11),out,inst_35766);
} else {
if((state_val_35791 === (5))){
var inst_35754 = (state_35790[(9)]);
var inst_35751 = (state_35790[(8)]);
var inst_35758 = (state_35790[(10)]);
var inst_35758__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_35754) : f.call(null,inst_35754));
var inst_35759 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35758__$1,inst_35751);
var inst_35760 = cljs.core.keyword_identical_QMARK_(inst_35751,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_35761 = (inst_35759) || (inst_35760);
var state_35790__$1 = (function (){var statearr_35804 = state_35790;
(statearr_35804[(10)] = inst_35758__$1);

return statearr_35804;
})();
if(cljs.core.truth_(inst_35761)){
var statearr_35805_35834 = state_35790__$1;
(statearr_35805_35834[(1)] = (8));

} else {
var statearr_35806_35835 = state_35790__$1;
(statearr_35806_35835[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35791 === (14))){
var inst_35783 = (state_35790[(2)]);
var inst_35784 = cljs.core.async.close_BANG_(out);
var state_35790__$1 = (function (){var statearr_35808 = state_35790;
(statearr_35808[(13)] = inst_35783);

return statearr_35808;
})();
var statearr_35809_35836 = state_35790__$1;
(statearr_35809_35836[(2)] = inst_35784);

(statearr_35809_35836[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35791 === (10))){
var inst_35773 = (state_35790[(2)]);
var state_35790__$1 = state_35790;
var statearr_35810_35837 = state_35790__$1;
(statearr_35810_35837[(2)] = inst_35773);

(statearr_35810_35837[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35791 === (8))){
var inst_35754 = (state_35790[(9)]);
var inst_35750 = (state_35790[(7)]);
var inst_35758 = (state_35790[(10)]);
var inst_35763 = inst_35750.push(inst_35754);
var tmp35807 = inst_35750;
var inst_35750__$1 = tmp35807;
var inst_35751 = inst_35758;
var state_35790__$1 = (function (){var statearr_35811 = state_35790;
(statearr_35811[(7)] = inst_35750__$1);

(statearr_35811[(8)] = inst_35751);

(statearr_35811[(14)] = inst_35763);

return statearr_35811;
})();
var statearr_35812_35838 = state_35790__$1;
(statearr_35812_35838[(2)] = null);

(statearr_35812_35838[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___35824,out))
;
return ((function (switch__12197__auto__,c__12309__auto___35824,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_35816 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35816[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_35816[(1)] = (1));

return statearr_35816;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_35790){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35790);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35817){if((e35817 instanceof Object)){
var ex__12201__auto__ = e35817;
var statearr_35818_35839 = state_35790;
(statearr_35818_35839[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35790);

return cljs.core.cst$kw$recur;
} else {
throw e35817;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35840 = state_35790;
state_35790 = G__35840;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_35790){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_35790);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___35824,out))
})();
var state__12311__auto__ = (function (){var statearr_35819 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35819[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___35824);

return statearr_35819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___35824,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

