// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.record');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('clojure.string');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.urls');
/**
 * Wrap-with produces a partial to wrap a set of children.
 * ((wrap-with :div) 1 2 3) => [:div [1 2 3]]
 * ((wrap-with [:div {:class 0}]) 1 2 3) => [:div {:class 0} [1 2 3]]
 */
hatti.views.record.wrap_with = (function hatti$views$record$wrap_with(root){
return (function() { 
var G__41086__delegate = function (children){
if((root instanceof cljs.core.Keyword)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root], null),children);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(root,children);
}
};
var G__41086 = function (var_args){
var children = null;
if (arguments.length > 0) {
var G__41087__i = 0, G__41087__a = new Array(arguments.length -  0);
while (G__41087__i < G__41087__a.length) {G__41087__a[G__41087__i] = arguments[G__41087__i + 0]; ++G__41087__i;}
  children = new cljs.core.IndexedSeq(G__41087__a,0);
} 
return G__41086__delegate.call(this,children);};
G__41086.cljs$lang$maxFixedArity = 0;
G__41086.cljs$lang$applyTo = (function (arglist__41088){
var children = cljs.core.seq(arglist__41088);
return G__41086__delegate(children);
});
G__41086.cljs$core$IFn$_invoke$arity$variadic = G__41086__delegate;
return G__41086;
})()
;
});
hatti.views.record.submission_arrow = (function hatti$views$record$submission_arrow(dir,cur_rank,view){
var icon = [cljs.core.str("fa fa-arrow-"),cljs.core.str(cljs.core.name(dir))].join('');
var new_rank = (function (){var G__41097 = (((dir instanceof cljs.core.Keyword))?dir.fqn:null);
switch (G__41097) {
case "left":
return cljs.core.dec;

break;
case "right":
return cljs.core.inc;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(dir)].join('')));

}
})().call(null,cur_rank);
var event_key = (function (){var pred__41098 = cljs.core._EQ_;
var expr__41099 = view;
if(cljs.core.truth_((function (){var G__41101 = cljs.core.cst$kw$map;
var G__41102 = expr__41099;
return (pred__41098.cljs$core$IFn$_invoke$arity$2 ? pred__41098.cljs$core$IFn$_invoke$arity$2(G__41101,G__41102) : pred__41098.call(null,G__41101,G__41102));
})())){
return cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank;
} else {
if(cljs.core.truth_((function (){var G__41103 = cljs.core.cst$kw$table;
var G__41104 = expr__41099;
return (pred__41098.cljs$core$IFn$_invoke$arity$2 ? pred__41098.cljs$core$IFn$_invoke$arity$2(G__41103,G__41104) : pred__41098.call(null,G__41103,G__41104));
})())){
return cljs.core.cst$kw$submission_DASH_to_DASH_rank;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__41099)].join('')));
}
}
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$pure_DASH_button$btn_DASH_default,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (icon,new_rank,event_key){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,cljs.core.PersistentArrayMap.fromArray([event_key,new_rank], true, false));
});})(icon,new_rank,event_key))
),cljs.core.cst$kw$href,"#"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,icon], null)], null)], null);
});
hatti.views.record.submission_closer = (function hatti$views$record$submission_closer(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$btn_DASH_close$right,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn((function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_unclicked,true], null));
})),cljs.core.cst$kw$href,"#"], null),"\u00D7"], null);
});
hatti.views.print_xls_report_btn.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.record.t_hatti$views$record41106 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record41106 = (function (cursor,owner,meta41107){
this.cursor = cursor;
this.owner = owner;
this.meta41107 = meta41107;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record41106.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_41108,meta41107__$1){
var self__ = this;
var _41108__$1 = this;
return (new hatti.views.record.t_hatti$views$record41106(self__.cursor,self__.owner,meta41107__$1));
});

hatti.views.record.t_hatti$views$record41106.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_41108){
var self__ = this;
var _41108__$1 = this;
return self__.meta41107;
});

hatti.views.record.t_hatti$views$record41106.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record41106.prototype.om$core$IRender$render$arity$1 = (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
var G__41111 = ({"id": "print-xls-report"});
return React.DOM.div(G__41111);
});

hatti.views.record.t_hatti$views$record41106.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta41107], null);
});

hatti.views.record.t_hatti$views$record41106.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record41106.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record41106";

hatti.views.record.t_hatti$views$record41106.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record41106");
});

hatti.views.record.__GT_t_hatti$views$record41106 = (function hatti$views$record$__GT_t_hatti$views$record41106(cursor__$1,owner__$1,meta41107){
return (new hatti.views.record.t_hatti$views$record41106(cursor__$1,owner__$1,meta41107));
});

}

return (new hatti.views.record.t_hatti$views$record41106(cursor,owner,null));
}));
hatti.views.record.qa_elements = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$div$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$span$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$span$answer], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$tr$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$td$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$td$answer], null)], null);
hatti.views.record.format_as_question_answer = (function hatti$views$record$format_as_question_answer(view,field,data,lang){
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var flabel = hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([lang], 0));
var answer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,fname);
var alabel = hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,answer,cljs.core.array_seq([cljs.core.cst$kw$language,lang], 0));
var map__41114 = (hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1(view) : hatti.views.record.qa_elements.call(null,view));
var map__41114__$1 = ((((!((map__41114 == null)))?((((map__41114.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41114.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41114):map__41114);
var row_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41114__$1,cljs.core.cst$kw$row_DASH_el);
var question_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41114__$1,cljs.core.cst$kw$question_DASH_el);
var answer_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41114__$1,cljs.core.cst$kw$answer_DASH_el);
if(cljs.core.truth_((function (){var and__6397__auto__ = alabel;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(alabel,hatti.ona.forms.no_answer);
} else {
return and__6397__auto__;
}
})())){
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.repeat_view,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data,answer,cljs.core.cst$kw$repeat_DASH_field,field,cljs.core.cst$kw$lang,lang], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,view], null)], null));
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,flabel], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,alabel], null)], null);
}
} else {
return null;
}
});
hatti.views.record.submission_elements = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$top_DASH_level_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$legend$infobar$submission$top$right),cljs.core.cst$kw$topbar_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom$legend_DASH_topbar),cljs.core.cst$kw$header_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom$submission_DASH_header),cljs.core.cst$kw$submission_DASH_info_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$submission$info_DASH_scroll),cljs.core.cst$kw$section_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom),cljs.core.cst$kw$h4_DASH_cls,"t-red"], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$top_DASH_level_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$widget_DASH_info_SHARP_single_DASH_submission_DASH_info),cljs.core.cst$kw$topbar_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$topbar),cljs.core.cst$kw$header_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$header),cljs.core.cst$kw$submission_DASH_info_DASH_wrap,(function() { 
var G__41116__delegate = function (tbody){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$submission,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$pure_DASH_table$pure_DASH_table_DASH_bordered,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Question"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Response"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,tbody], null)], null)], null);
};
var G__41116 = function (var_args){
var tbody = null;
if (arguments.length > 0) {
var G__41117__i = 0, G__41117__a = new Array(arguments.length -  0);
while (G__41117__i < G__41117__a.length) {G__41117__a[G__41117__i] = arguments[G__41117__i + 0]; ++G__41117__i;}
  tbody = new cljs.core.IndexedSeq(G__41117__a,0);
} 
return G__41116__delegate.call(this,tbody);};
G__41116.cljs$lang$maxFixedArity = 0;
G__41116.cljs$lang$applyTo = (function (arglist__41118){
var tbody = cljs.core.seq(arglist__41118);
return G__41116__delegate(tbody);
});
G__41116.cljs$core$IFn$_invoke$arity$variadic = G__41116__delegate;
return G__41116;
})()
,cljs.core.cst$kw$section_DASH_wrap,cljs.core.identity,cljs.core.cst$kw$show_DASH_instance_DASH_id,true,cljs.core.cst$kw$h4_DASH_cls,""], null)], null);
hatti.views.repeat_view.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__41120,owner,p__41121){
var map__41122 = p__41120;
var map__41122__$1 = ((((!((map__41122 == null)))?((((map__41122.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41122.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41122):map__41122);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41122__$1,cljs.core.cst$kw$data);
var repeat_field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41122__$1,cljs.core.cst$kw$repeat_DASH_field);
var lang = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41122__$1,cljs.core.cst$kw$lang);
var map__41123 = p__41121;
var map__41123__$1 = ((((!((map__41123 == null)))?((((map__41123.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41123.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41123):map__41123);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41123__$1,cljs.core.cst$kw$view);

if(typeof hatti.views.record.t_hatti$views$record41126 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record41126 = (function (p__41120,owner,p__41121,map__41122,data,repeat_field,lang,map__41123,view,meta41127){
this.p__41120 = p__41120;
this.owner = owner;
this.p__41121 = p__41121;
this.map__41122 = map__41122;
this.data = data;
this.repeat_field = repeat_field;
this.lang = lang;
this.map__41123 = map__41123;
this.view = view;
this.meta41127 = meta41127;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record41126.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function (_41128,meta41127__$1){
var self__ = this;
var _41128__$1 = this;
return (new hatti.views.record.t_hatti$views$record41126(self__.p__41120,self__.owner,self__.p__41121,self__.map__41122,self__.data,self__.repeat_field,self__.lang,self__.map__41123,self__.view,meta41127__$1));
});})(map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
;

hatti.views.record.t_hatti$views$record41126.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function (_41128){
var self__ = this;
var _41128__$1 = this;
return self__.meta41127;
});})(map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
;

hatti.views.record.t_hatti$views$record41126.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record41126.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$collapsed_QMARK_,true], null);
});})(map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
;

hatti.views.record.t_hatti$views$record41126.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record41126.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function (_,p__41129){
var self__ = this;
var map__41130 = p__41129;
var map__41130__$1 = ((((!((map__41130 == null)))?((((map__41130.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41130.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41130):map__41130);
var collapsed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41130__$1,cljs.core.cst$kw$collapsed_QMARK_);
var ___$1 = this;
if(cljs.core.seq(self__.data)){
var collapse_BANG_ = ((function (___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function (p1__41119_SHARP_){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$collapsed_QMARK_,p1__41119_SHARP_);
});})(___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
;
var map__41132 = (hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1(self__.view) : hatti.views.record.qa_elements.call(null,self__.view));
var map__41132__$1 = ((((!((map__41132 == null)))?((((map__41132.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41132.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41132):map__41132);
var row_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41132__$1,cljs.core.cst$kw$row_DASH_el);
var question_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41132__$1,cljs.core.cst$kw$question_DASH_el);
var answer_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41132__$1,cljs.core.cst$kw$answer_DASH_el);
var header = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(self__.repeat_field,cljs.core.array_seq([self__.lang], 0))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,[cljs.core.str(hatti.utils.pluralize_number(cljs.core.count(self__.data)," Repeat")),cljs.core.str(" - ")].join(''),(cljs.core.truth_(collapsed_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function (){
return collapse_BANG_(false);
});})(collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
),cljs.core.cst$kw$href,"#"], null),"Show Repeats"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function (){
return collapse_BANG_(true);
});})(collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
),cljs.core.cst$kw$href,"#"], null),"Hide Repeats"], null))], null)], null);
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.repeat_field);
var render_child = ((function (collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function (d){
var iter__7189__auto__ = ((function (collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function hatti$views$record$iter__41134(s__41135){
return (new cljs.core.LazySeq(null,((function (collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function (){
var s__41135__$1 = s__41135;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__41135__$1);
if(temp__4657__auto__){
var s__41135__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41135__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__41135__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__41137 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__41136 = (0);
while(true){
if((i__41136 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__41136);
cljs.core.chunk_append(b__41137,hatti.views.record.format_as_question_answer(self__.view,field,d,self__.lang));

var G__41153 = (i__41136 + (1));
i__41136 = G__41153;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41137),hatti$views$record$iter__41134(cljs.core.chunk_rest(s__41135__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41137),null);
}
} else {
var field = cljs.core.first(s__41135__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,field,d,self__.lang),hatti$views$record$iter__41134(cljs.core.rest(s__41135__$2)));
}
} else {
return null;
}
break;
}
});})(collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
,null,null));
});})(collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
;
return iter__7189__auto__(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(self__.repeat_field));
});})(collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
;
var tbl = ((function (collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function() { 
var G__41154__delegate = function (cls,body){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cls], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$no_DASH_pad,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(2)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cls], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,body], null)], null)], null)], null);
};
var G__41154 = function (cls,var_args){
var body = null;
if (arguments.length > 1) {
var G__41155__i = 0, G__41155__a = new Array(arguments.length -  1);
while (G__41155__i < G__41155__a.length) {G__41155__a[G__41155__i] = arguments[G__41155__i + 1]; ++G__41155__i;}
  body = new cljs.core.IndexedSeq(G__41155__a,0);
} 
return G__41154__delegate.call(this,cls,body);};
G__41154.cljs$lang$maxFixedArity = 1;
G__41154.cljs$lang$applyTo = (function (arglist__41156){
var cls = cljs.core.first(arglist__41156);
var body = cljs.core.rest(arglist__41156);
return G__41154__delegate(cls,body);
});
G__41154.cljs$core$IFn$_invoke$arity$variadic = G__41154__delegate;
return G__41154;
})()
;})(collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
;
if(cljs.core.truth_(collapsed_QMARK_)){
return sablono.interpreter.interpret(header);
} else {
return sablono.interpreter.interpret((function (){var G__41140 = (((self__.view instanceof cljs.core.Keyword))?self__.view.fqn:null);
switch (G__41140) {
case "map":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$repeat_DASH_block,header,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol$repeat,(function (){var iter__7189__auto__ = ((function (G__41140,collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function hatti$views$record$iter__41141(s__41142){
return (new cljs.core.LazySeq(null,((function (G__41140,collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function (){
var s__41142__$1 = s__41142;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__41142__$1);
if(temp__4657__auto__){
var s__41142__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41142__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__41142__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__41144 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__41143 = (0);
while(true){
if((i__41143 < size__7188__auto__)){
var d = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__41143);
cljs.core.chunk_append(b__41144,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,render_child(d)], null));

var G__41158 = (i__41143 + (1));
i__41143 = G__41158;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41144),hatti$views$record$iter__41141(cljs.core.chunk_rest(s__41142__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41144),null);
}
} else {
var d = cljs.core.first(s__41142__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,render_child(d)], null),hatti$views$record$iter__41141(cljs.core.rest(s__41142__$2)));
}
} else {
return null;
}
break;
}
});})(G__41140,collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
,null,null));
});})(G__41140,collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
;
return iter__7189__auto__(self__.data);
})()], null)], null);

break;
case "table":
return tbl.cljs$core$IFn$_invoke$arity$variadic("repeat-block",cljs.core.array_seq([header,(function (){var iter__7189__auto__ = ((function (G__41140,collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function hatti$views$record$iter__41147(s__41148){
return (new cljs.core.LazySeq(null,((function (G__41140,collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function (){
var s__41148__$1 = s__41148;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__41148__$1);
if(temp__4657__auto__){
var s__41148__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41148__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__41148__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__41150 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__41149 = (0);
while(true){
if((i__41149 < size__7188__auto__)){
var d = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__41149);
cljs.core.chunk_append(b__41150,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody$repeat,render_child(d)], null));

var G__41159 = (i__41149 + (1));
i__41149 = G__41159;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41150),hatti$views$record$iter__41147(cljs.core.chunk_rest(s__41148__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41150),null);
}
} else {
var d = cljs.core.first(s__41148__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody$repeat,render_child(d)], null),hatti$views$record$iter__41147(cljs.core.rest(s__41148__$2)));
}
} else {
return null;
}
break;
}
});})(G__41140,collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
,null,null));
});})(G__41140,collapse_BANG_,map__41132,map__41132__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__41130,map__41130__$1,collapsed_QMARK_,map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
;
return iter__7189__auto__(self__.data);
})()], 0));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(self__.view)].join('')));

}
})());
}
} else {
return null;
}
});})(map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
;

hatti.views.record.t_hatti$views$record41126.getBasis = ((function (map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__41120,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__41121,cljs.core.cst$sym$map__41122,cljs.core.cst$sym$data,cljs.core.cst$sym$repeat_DASH_field,cljs.core.cst$sym$lang,cljs.core.cst$sym$map__41123,cljs.core.cst$sym$view,cljs.core.cst$sym$meta41127], null);
});})(map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
;

hatti.views.record.t_hatti$views$record41126.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record41126.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record41126";

hatti.views.record.t_hatti$views$record41126.cljs$lang$ctorPrWriter = ((function (map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record41126");
});})(map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
;

hatti.views.record.__GT_t_hatti$views$record41126 = ((function (map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view){
return (function hatti$views$record$__GT_t_hatti$views$record41126(p__41120__$1,owner__$1,p__41121__$1,map__41122__$2,data__$1,repeat_field__$1,lang__$1,map__41123__$2,view__$1,meta41127){
return (new hatti.views.record.t_hatti$views$record41126(p__41120__$1,owner__$1,p__41121__$1,map__41122__$2,data__$1,repeat_field__$1,lang__$1,map__41123__$2,view__$1,meta41127));
});})(map__41122,map__41122__$1,data,repeat_field,lang,map__41123,map__41123__$1,view))
;

}

return (new hatti.views.record.t_hatti$views$record41126(p__41120,owner,p__41121,map__41122__$1,data,repeat_field,lang,map__41123__$1,view,cljs.core.PersistentArrayMap.EMPTY));
}));
hatti.views.record.header_note = (function hatti$views$record$header_note(view,p__41160){
var map__41163 = p__41160;
var map__41163__$1 = ((((!((map__41163 == null)))?((((map__41163.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41163.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41163):map__41163);
var geofield = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41163__$1,cljs.core.cst$kw$geofield);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41163__$1,cljs.core.cst$kw$data);
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,cljs.core.cst$kw$map)) && (cljs.core.not(cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$no_DASH_geo$t_DASH_normal$right,"No geodata"], null);
} else {
return null;
}
});
hatti.views.edit_delete.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (instance_id,owner,p__41165){
var map__41166 = p__41165;
var map__41166__$1 = ((((!((map__41166 == null)))?((((map__41166.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41166.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41166):map__41166);
var delete_record_BANG_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41166__$1,cljs.core.cst$kw$delete_DASH_record_BANG_);
if(typeof hatti.views.record.t_hatti$views$record41168 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record41168 = (function (instance_id,owner,p__41165,map__41166,delete_record_BANG_,meta41169){
this.instance_id = instance_id;
this.owner = owner;
this.p__41165 = p__41165;
this.map__41166 = map__41166;
this.delete_record_BANG_ = delete_record_BANG_;
this.meta41169 = meta41169;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record41168.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__41166,map__41166__$1,delete_record_BANG_){
return (function (_41170,meta41169__$1){
var self__ = this;
var _41170__$1 = this;
return (new hatti.views.record.t_hatti$views$record41168(self__.instance_id,self__.owner,self__.p__41165,self__.map__41166,self__.delete_record_BANG_,meta41169__$1));
});})(map__41166,map__41166__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record41168.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__41166,map__41166__$1,delete_record_BANG_){
return (function (_41170){
var self__ = this;
var _41170__$1 = this;
return self__.meta41169;
});})(map__41166,map__41166__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record41168.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record41168.prototype.om$core$IRender$render$arity$1 = ((function (map__41166,map__41166__$1,delete_record_BANG_){
return (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
return null;
});})(map__41166,map__41166__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record41168.getBasis = ((function (map__41166,map__41166__$1,delete_record_BANG_){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$instance_DASH_id,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__41165,cljs.core.cst$sym$map__41166,cljs.core.cst$sym$delete_DASH_record_BANG_,cljs.core.cst$sym$meta41169], null);
});})(map__41166,map__41166__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record41168.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record41168.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record41168";

hatti.views.record.t_hatti$views$record41168.cljs$lang$ctorPrWriter = ((function (map__41166,map__41166__$1,delete_record_BANG_){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record41168");
});})(map__41166,map__41166__$1,delete_record_BANG_))
;

hatti.views.record.__GT_t_hatti$views$record41168 = ((function (map__41166,map__41166__$1,delete_record_BANG_){
return (function hatti$views$record$__GT_t_hatti$views$record41168(instance_id__$1,owner__$1,p__41165__$1,map__41166__$2,delete_record_BANG___$1,meta41169){
return (new hatti.views.record.t_hatti$views$record41168(instance_id__$1,owner__$1,p__41165__$1,map__41166__$2,delete_record_BANG___$1,meta41169));
});})(map__41166,map__41166__$1,delete_record_BANG_))
;

}

return (new hatti.views.record.t_hatti$views$record41168(instance_id,owner,p__41165,map__41166__$1,delete_record_BANG_,null));
}));
hatti.views.submission_view.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner,p__41171){
var map__41172 = p__41171;
var map__41172__$1 = ((((!((map__41172 == null)))?((((map__41172.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41172.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41172):map__41172);
var opts = map__41172__$1;
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41172__$1,cljs.core.cst$kw$view);
if(typeof hatti.views.record.t_hatti$views$record41174 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record41174 = (function (cursor,owner,p__41171,map__41172,opts,view,meta41175){
this.cursor = cursor;
this.owner = owner;
this.p__41171 = p__41171;
this.map__41172 = map__41172;
this.opts = opts;
this.view = view;
this.meta41175 = meta41175;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record41174.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__41172,map__41172__$1,opts,view){
return (function (_41176,meta41175__$1){
var self__ = this;
var _41176__$1 = this;
return (new hatti.views.record.t_hatti$views$record41174(self__.cursor,self__.owner,self__.p__41171,self__.map__41172,self__.opts,self__.view,meta41175__$1));
});})(map__41172,map__41172__$1,opts,view))
;

hatti.views.record.t_hatti$views$record41174.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__41172,map__41172__$1,opts,view){
return (function (_41176){
var self__ = this;
var _41176__$1 = this;
return self__.meta41175;
});})(map__41172,map__41172__$1,opts,view))
;

hatti.views.record.t_hatti$views$record41174.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record41174.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__41172,map__41172__$1,opts,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$expand_DASH_meta_QMARK_,false], null);
});})(map__41172,map__41172__$1,opts,view))
;

hatti.views.record.t_hatti$views$record41174.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record41174.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__41172,map__41172__$1,opts,view){
return (function (_,p__41177){
var self__ = this;
var map__41178 = p__41177;
var map__41178__$1 = ((((!((map__41178 == null)))?((((map__41178.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41178.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41178):map__41178);
var expand_meta_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41178__$1,cljs.core.cst$kw$expand_DASH_meta_QMARK_);
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$flat_DASH_form], null));
var language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var map__41180 = self__.cursor;
var map__41180__$1 = ((((!((map__41180 == null)))?((((map__41180.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41180.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41180):map__41180);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41180__$1,cljs.core.cst$kw$id);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41180__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41180__$1,cljs.core.cst$kw$dataset_DASH_info);
var cur_rank = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,hatti.constants._rank);
var instance_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,"_id");
var sdatetime = (function (){var G__41183 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,"_submission_time");
return moment(G__41183);
})();
var map__41181 = (hatti.views.record.submission_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.submission_elements.cljs$core$IFn$_invoke$arity$1(self__.view) : hatti.views.record.submission_elements.call(null,self__.view));
var map__41181__$1 = ((((!((map__41181 == null)))?((((map__41181.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41181.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41181):map__41181);
var top_level_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41181__$1,cljs.core.cst$kw$top_DASH_level_DASH_wrap);
var topbar_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41181__$1,cljs.core.cst$kw$topbar_DASH_wrap);
var header_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41181__$1,cljs.core.cst$kw$header_DASH_wrap);
var section_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41181__$1,cljs.core.cst$kw$section_DASH_wrap);
var submission_info_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41181__$1,cljs.core.cst$kw$submission_DASH_info_DASH_wrap);
var h4_cls = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41181__$1,cljs.core.cst$kw$h4_DASH_cls);
return sablono.interpreter.interpret((cljs.core.truth_((function (){var or__6409__auto__ = data;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id;
}
})())?(function (){var G__41185 = (function (){var G__41187 = hatti.views.record.submission_arrow(cljs.core.cst$kw$left,cur_rank,self__.view);
var G__41188 = hatti.views.record.submission_arrow(cljs.core.cst$kw$right,cur_rank,self__.view);
var G__41189 = om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.print_xls_report_btn,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$instance_DASH_id,instance_id,cljs.core.cst$kw$dataset_DASH_info,dataset_info], null));
var G__41190 = hatti.views.record.submission_closer();
return (topbar_wrap.cljs$core$IFn$_invoke$arity$4 ? topbar_wrap.cljs$core$IFn$_invoke$arity$4(G__41187,G__41188,G__41189,G__41190) : topbar_wrap.call(null,G__41187,G__41188,G__41189,G__41190));
})();
var G__41186 = (cljs.core.truth_(data)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,(function (){var G__41191 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,h4_cls], null),[cljs.core.str("ID: "),cljs.core.str(instance_id)].join(''),hatti.views.record.header_note(self__.view,self__.cursor)], null);
var G__41192 = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,[cljs.core.str("Submitted at "),cljs.core.str(sdatetime.format("LT")),cljs.core.str(" on "),cljs.core.str(sdatetime.format("ll"))].join(''),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$br], null),om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.edit_delete,instance_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$expand_DASH_meta$right,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (G__41191,G__41185,form,language,map__41180,map__41180__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41181,map__41181__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__41178,map__41178__$1,expand_meta_QMARK_,map__41172,map__41172__$1,opts,view){
return (function (){
return om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$expand_DASH_meta_QMARK_,cljs.core.not);
});})(G__41191,G__41185,form,language,map__41180,map__41180__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41181,map__41181__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__41178,map__41178__$1,expand_meta_QMARK_,map__41172,map__41172__$1,opts,view))
)], null),(cljs.core.truth_(expand_meta_QMARK_)?"Hide Metadata":"Show Metadata")], null)], null)], null);
return (header_wrap.cljs$core$IFn$_invoke$arity$2 ? header_wrap.cljs$core$IFn$_invoke$arity$2(G__41191,G__41192) : header_wrap.call(null,G__41191,G__41192));
})(),(function (){var G__41193 = (cljs.core.truth_(expand_meta_QMARK_)?(function (){var G__41195 = (function (){var iter__7189__auto__ = ((function (G__41185,form,language,map__41180,map__41180__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41181,map__41181__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__41178,map__41178__$1,expand_meta_QMARK_,map__41172,map__41172__$1,opts,view){
return (function hatti$views$record$iter__41196(s__41197){
return (new cljs.core.LazySeq(null,((function (G__41185,form,language,map__41180,map__41180__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41181,map__41181__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__41178,map__41178__$1,expand_meta_QMARK_,map__41172,map__41172__$1,opts,view){
return (function (){
var s__41197__$1 = s__41197;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__41197__$1);
if(temp__4657__auto__){
var s__41197__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41197__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__41197__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__41199 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__41198 = (0);
while(true){
if((i__41198 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__41198);
cljs.core.chunk_append(b__41199,hatti.views.record.format_as_question_answer(self__.view,q,data,language));

var G__41209 = (i__41198 + (1));
i__41198 = G__41209;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41199),hatti$views$record$iter__41196(cljs.core.chunk_rest(s__41197__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41199),null);
}
} else {
var q = cljs.core.first(s__41197__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,q,data,language),hatti$views$record$iter__41196(cljs.core.rest(s__41197__$2)));
}
} else {
return null;
}
break;
}
});})(G__41185,form,language,map__41180,map__41180__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41181,map__41181__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__41178,map__41178__$1,expand_meta_QMARK_,map__41172,map__41172__$1,opts,view))
,null,null));
});})(G__41185,form,language,map__41180,map__41180__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41181,map__41181__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__41178,map__41178__$1,expand_meta_QMARK_,map__41172,map__41172__$1,opts,view))
;
return iter__7189__auto__(hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0)));
})();
return (section_wrap.cljs$core$IFn$_invoke$arity$1 ? section_wrap.cljs$core$IFn$_invoke$arity$1(G__41195) : section_wrap.call(null,G__41195));
})():null);
var G__41194 = (function (){var G__41202 = (function (){var iter__7189__auto__ = ((function (G__41193,G__41185,form,language,map__41180,map__41180__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41181,map__41181__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__41178,map__41178__$1,expand_meta_QMARK_,map__41172,map__41172__$1,opts,view){
return (function hatti$views$record$iter__41203(s__41204){
return (new cljs.core.LazySeq(null,((function (G__41193,G__41185,form,language,map__41180,map__41180__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41181,map__41181__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__41178,map__41178__$1,expand_meta_QMARK_,map__41172,map__41172__$1,opts,view){
return (function (){
var s__41204__$1 = s__41204;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__41204__$1);
if(temp__4657__auto__){
var s__41204__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41204__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__41204__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__41206 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__41205 = (0);
while(true){
if((i__41205 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__41205);
cljs.core.chunk_append(b__41206,hatti.views.record.format_as_question_answer(self__.view,q,data,language));

var G__41210 = (i__41205 + (1));
i__41205 = G__41210;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41206),hatti$views$record$iter__41203(cljs.core.chunk_rest(s__41204__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41206),null);
}
} else {
var q = cljs.core.first(s__41204__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,q,data,language),hatti$views$record$iter__41203(cljs.core.rest(s__41204__$2)));
}
} else {
return null;
}
break;
}
});})(G__41193,G__41185,form,language,map__41180,map__41180__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41181,map__41181__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__41178,map__41178__$1,expand_meta_QMARK_,map__41172,map__41172__$1,opts,view))
,null,null));
});})(G__41193,G__41185,form,language,map__41180,map__41180__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41181,map__41181__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__41178,map__41178__$1,expand_meta_QMARK_,map__41172,map__41172__$1,opts,view))
;
return iter__7189__auto__(hatti.ona.forms.non_meta_fields(form));
})();
return (section_wrap.cljs$core$IFn$_invoke$arity$1 ? section_wrap.cljs$core$IFn$_invoke$arity$1(G__41202) : section_wrap.call(null,G__41202));
})();
return (submission_info_wrap.cljs$core$IFn$_invoke$arity$2 ? submission_info_wrap.cljs$core$IFn$_invoke$arity$2(G__41193,G__41194) : submission_info_wrap.call(null,G__41193,G__41194));
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$t_DASH_center,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null),"Loading data..."], null)], null));
return (top_level_wrap.cljs$core$IFn$_invoke$arity$2 ? top_level_wrap.cljs$core$IFn$_invoke$arity$2(G__41185,G__41186) : top_level_wrap.call(null,G__41185,G__41186));
})():null));
});})(map__41172,map__41172__$1,opts,view))
;

hatti.views.record.t_hatti$views$record41174.getBasis = ((function (map__41172,map__41172__$1,opts,view){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__41171,cljs.core.cst$sym$map__41172,cljs.core.cst$sym$opts,cljs.core.cst$sym$view,cljs.core.cst$sym$meta41175], null);
});})(map__41172,map__41172__$1,opts,view))
;

hatti.views.record.t_hatti$views$record41174.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record41174.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record41174";

hatti.views.record.t_hatti$views$record41174.cljs$lang$ctorPrWriter = ((function (map__41172,map__41172__$1,opts,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record41174");
});})(map__41172,map__41172__$1,opts,view))
;

hatti.views.record.__GT_t_hatti$views$record41174 = ((function (map__41172,map__41172__$1,opts,view){
return (function hatti$views$record$__GT_t_hatti$views$record41174(cursor__$1,owner__$1,p__41171__$1,map__41172__$2,opts__$1,view__$1,meta41175){
return (new hatti.views.record.t_hatti$views$record41174(cursor__$1,owner__$1,p__41171__$1,map__41172__$2,opts__$1,view__$1,meta41175));
});})(map__41172,map__41172__$1,opts,view))
;

}

return (new hatti.views.record.t_hatti$views$record41174(cursor,owner,p__41171,map__41172__$1,opts,view,cljs.core.PersistentArrayMap.EMPTY));
}));
