// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.utils.style');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('hatti.ona.forms');
/**
 * Set of CSS properties that can be modified by a user
 */
hatti.utils.style.user_customizable_styles = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["color",null], null), null);
/**
 * Saturated qualitative palette from colorbrewer.
 * Saturated red+brown disabled due to clash with the :clicked color.
 */
hatti.utils.style.qualitative_palette = new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#1f78b4","#33a02c","#6a3d9a","#ffff99","#b15928","#a6cee3","#b2df8a","#fb9a99","#fdbf6f","#cab2d6"], null);
/**
 * Color palette of YlGnBl from colorbrewer.
 */
hatti.utils.style.sequential_palette = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#ffffcc","#bdd7e7","#6baed6","#3182bd","#08519c"], null);
/**
 * A Grey Color for deselected points.
 */
hatti.utils.style.grey = "#d9d9d9";
/**
 * Check if a user can customize a style
 */
hatti.utils.style.customizable_style_QMARK_ = (function hatti$utils$style$customizable_style_QMARK_(p__20590){
var vec__20594 = p__20590;
var style_name = cljs.core.nth.call(null,vec__20594,(0),null);
var _ = cljs.core.nth.call(null,vec__20594,(1),null);
return cljs.core.contains_QMARK_.call(null,hatti.utils.style.user_customizable_styles,style_name);
});
/**
 * Return a map of a form field answer name to CSS rules
 */
hatti.utils.style.get_css_rule_map = (function hatti$utils$style$get_css_rule_map(appearance_attribute){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__20602){
var vec__20603 = p__20602;
var key = cljs.core.nth.call(null,vec__20603,(0),null);
var value = cljs.core.nth.call(null,vec__20603,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,key),value], null);
}),cljs.core.filter.call(null,hatti.utils.style.customizable_style_QMARK_,cljs.core.map.call(null,(function (p1__20597_SHARP_){
return clojure.string.split.call(null,p1__20597_SHARP_,/:/);
}),clojure.string.split.call(null,appearance_attribute,/;/)))));
});
/**
 * Return a map of answer to associated CSS rules
 */
hatti.utils.style.group_user_defined_styles_by_answer = (function hatti$utils$style$group_user_defined_styles_by_answer(p__20606){
var map__20612 = p__20606;
var map__20612__$1 = ((((!((map__20612 == null)))?((((map__20612.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20612.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20612):map__20612);
var children = cljs.core.get.call(null,map__20612__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,((function (map__20612,map__20612__$1,children){
return (function (p__20614){
var map__20615 = p__20614;
var map__20615__$1 = ((((!((map__20615 == null)))?((((map__20615.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20615.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20615):map__20615);
var name = cljs.core.get.call(null,map__20615__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var appearance = cljs.core.get.call(null,map__20615__$1,new cljs.core.Keyword(null,"appearance","appearance",-216383432));
return cljs.core.PersistentArrayMap.fromArray([name,hatti.utils.style.get_css_rule_map.call(null,appearance)], true, false);
});})(map__20612,map__20612__$1,children))
,children));
});
/**
 * Returns only the color property of the style map, with the answer as the key
 */
hatti.utils.style.style_map__GT_color_map = (function hatti$utils$style$style_map__GT_color_map(p__20617){
var vec__20623 = p__20617;
var answer = cljs.core.nth.call(null,vec__20623,(0),null);
var map__20626 = cljs.core.nth.call(null,vec__20623,(1),null);
var map__20626__$1 = ((((!((map__20626 == null)))?((((map__20626.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20626.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20626):map__20626);
var color = cljs.core.get.call(null,map__20626__$1,new cljs.core.Keyword(null,"color","color",1011675173));
if(cljs.core.truth_(color)){
return cljs.core.PersistentArrayMap.fromArray([answer,color], true, false);
} else {
return null;
}
});
/**
 * Return a map of answers to their associated colors
 */
hatti.utils.style.group_user_defined_colors_by_answer = (function hatti$utils$style$group_user_defined_colors_by_answer(field){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.vec.call(null,cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,hatti.utils.style.style_map__GT_color_map,hatti.utils.style.group_user_defined_styles_by_answer.call(null,field))))));
});
/**
 * Return the appropriate set of colors given the field. For a select_one,
 * returns a mapping of answer to color. Returns a string for all other field
 * types
 */
hatti.utils.style.field__GT_colors = (function hatti$utils$style$field__GT_colors(field){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_.call(null,field))){
if((cljs.core.count.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(field)) <= cljs.core.count.call(null,hatti.utils.style.qualitative_palette))){
return hatti.utils.style.qualitative_palette;
} else {
return cljs.core.repeat.call(null,"#f30");
}
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_.call(null,field))){
return hatti.utils.style.qualitative_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))){
return hatti.utils.style.sequential_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))){
return hatti.utils.style.sequential_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_.call(null,field))){
return cljs.core.repeat.call(null,"#f30");
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_.call(null,field))){
return cljs.core.repeat.call(null,"#f30");
} else {
return null;
}
}
}
}
}
}
});
/**
 * Given a field and set of answers, return a mapping of answer to color
 * defaulting to an inbuilt palette if the field is not a select-one or
 * any of the choices lack an appearance attribute
 */
hatti.utils.style.answer__GT_color = (function hatti$utils$style$answer__GT_color(p__20628,answers){
var map__20631 = p__20628;
var map__20631__$1 = ((((!((map__20631 == null)))?((((map__20631.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20631.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20631):map__20631);
var field = map__20631__$1;
var children = cljs.core.get.call(null,map__20631__$1,new cljs.core.Keyword(null,"children","children",-940561982));
if(cljs.core.truth_((function (){var and__6397__auto__ = hatti.ona.forms.select_one_QMARK_.call(null,field);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.every_QMARK_.call(null,new cljs.core.Keyword(null,"appearance","appearance",-216383432),children);
} else {
return and__6397__auto__;
}
})())){
return hatti.utils.style.group_user_defined_colors_by_answer.call(null,field);
} else {
return cljs.core.zipmap.call(null,answers,hatti.utils.style.field__GT_colors.call(null,field));
}
});
