// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),true))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__25311_SHARP_){
if(typeof p1__25311_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__25311_SHARP_);
} else {
return p1__25311_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__25317){
var vec__25318 = p__25317;
var fname = cljs.core.nth.call(null,vec__25318,(0),null);
var answer = cljs.core.nth.call(null,vec__25318,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__25312_SHARP_){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),[cljs.core.str(p1__25312_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,chimera.string.escape_for_type.call(null,clj_value),new cljs.core.Keyword(null,"language","language",-1591107564),language,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true,new cljs.core.Keyword(null,"field-key","field-key",313262601),field_key);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__25321 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__25321__$1 = ((((!((map__25321 == null)))?((((map__25321.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25321.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25321):map__25321);
var owner__$1 = cljs.core.get.call(null,map__25321__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__25321__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__25321__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = chimera.urls.last_url_param.call(null,owner__$1);
var project_id = chimera.urls.last_url_param.call(null,project);
var edit_link = chimera.urls.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip.middle-right","li.tooltip.middle-right",-548323211),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-clone","i.fa.fa-clone",1946695810),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil-square-o","i.fa.fa-pencil-square-o",1550650091)], null)], null)], null)], null):null));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(70),"",hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___25350 = arguments.length;
var i__7485__auto___25351 = (0);
while(true){
if((i__7485__auto___25351 < len__7484__auto___25350)){
args__7491__auto__.push((arguments[i__7485__auto___25351]));

var G__25352 = (i__7485__auto___25351 + (1));
i__7485__auto___25351 = G__25352;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__25326){
var map__25327 = p__25326;
var map__25327__$1 = ((((!((map__25327 == null)))?((((map__25327.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25327.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25327):map__25327);
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25327__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var get_label_QMARK_ = cljs.core.get.call(null,map__25327__$1,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),true);
var language = cljs.core.get.call(null,map__25327__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var owner = cljs.core.get.call(null,map__25327__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var has_hxl_QMARK_ = chimera.core.any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,((function (map__25327,map__25327__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__25323_SHARP_){
return (new cljs.core.Keyword(null,"hxl","hxl",-849576989).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"instance","instance",-2121349050).cljs$core$IFn$_invoke$arity$1(p1__25323_SHARP_)) == null);
});})(map__25327,map__25327__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,form));
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__25327,map__25327__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__25329(s__25330){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__25327,map__25327__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__25330__$1 = s__25330;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25330__$1);
if(temp__4657__auto__){
var s__25330__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25330__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25330__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25332 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25331 = (0);
while(true){
if((i__25331 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__25331);
cljs.core.chunk_append.call(null,b__25332,(function (){var map__25341 = field;
var map__25341__$1 = ((((!((map__25341 == null)))?((((map__25341.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25341.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25341):map__25341);
var map__25342 = cljs.core.get.call(null,map__25341__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25342__$1 = ((((!((map__25342 == null)))?((((map__25342.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25342.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25342):map__25342);
var hxl = cljs.core.get.call(null,map__25342__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25341__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25341__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25341__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?new cljs.core.Keyword(null,"name","name",1843675177):new cljs.core.Keyword(null,"label","label",1718410804));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__25353 = (i__25331 + (1));
i__25331 = G__25353;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25332),hatti$views$table$iter__25329.call(null,cljs.core.chunk_rest.call(null,s__25330__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25332),null);
}
} else {
var field = cljs.core.first.call(null,s__25330__$2);
return cljs.core.cons.call(null,(function (){var map__25345 = field;
var map__25345__$1 = ((((!((map__25345 == null)))?((((map__25345.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25345.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25345):map__25345);
var map__25346 = cljs.core.get.call(null,map__25345__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25346__$1 = ((((!((map__25346 == null)))?((((map__25346.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25346.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25346):map__25346);
var hxl = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25345__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25345__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25345__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?new cljs.core.Keyword(null,"name","name",1843675177):new cljs.core.Keyword(null,"label","label",1718410804));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__25329.call(null,cljs.core.rest.call(null,s__25330__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__25327,map__25327__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__25327,map__25327__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__.call(null,hatti.views.table.all_fields.call(null,form));
})();
return cljs.core.clj__GT_js.call(null,(function (){var G__25349 = columns;
if(cljs.core.not.call(null,hide_actions_column_QMARK_)){
return cljs.core.conj.call(null,G__25349,hatti.views.table.actions_column.call(null,owner,has_hxl_QMARK_));
} else {
return G__25349;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq25324){
var G__25325 = cljs.core.first.call(null,seq25324);
var seq25324__$1 = cljs.core.next.call(null,seq25324);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__25325,seq25324__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25370(s__25371){
return (new cljs.core.LazySeq(null,(function (){
var s__25371__$1 = s__25371;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25371__$1);
if(temp__4657__auto__){
var s__25371__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25371__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25371__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25373 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25372 = (0);
while(true){
if((i__25372 < size__7188__auto__)){
var vec__25380 = cljs.core._nth.call(null,c__7187__auto__,i__25372);
var handler_key = cljs.core.nth.call(null,vec__25380,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25380,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__25373,event.subscribe(handler_function));

var G__25386 = (i__25372 + (1));
i__25372 = G__25386;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25373),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25370.call(null,cljs.core.chunk_rest.call(null,s__25371__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25373),null);
}
} else {
var vec__25383 = cljs.core.first.call(null,s__25371__$2);
var handler_key = cljs.core.nth.call(null,vec__25383,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25383,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25370.call(null,cljs.core.rest.call(null,s__25371__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25403(s__25404){
return (new cljs.core.LazySeq(null,(function (){
var s__25404__$1 = s__25404;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25404__$1);
if(temp__4657__auto__){
var s__25404__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25404__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25404__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25406 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25405 = (0);
while(true){
if((i__25405 < size__7188__auto__)){
var vec__25413 = cljs.core._nth.call(null,c__7187__auto__,i__25405);
var handler_key = cljs.core.nth.call(null,vec__25413,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25413,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__25406,event.subscribe(handler_function));

var G__25419 = (i__25405 + (1));
i__25405 = G__25419;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25406),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25403.call(null,cljs.core.chunk_rest.call(null,s__25404__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25406),null);
}
} else {
var vec__25416 = cljs.core.first.call(null,s__25404__$2);
var handler_key = cljs.core.nth.call(null,vec__25416,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25416,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25403.call(null,cljs.core.rest.call(null,s__25404__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__25420){
var map__25429 = p__25420;
var map__25429__$1 = ((((!((map__25429 == null)))?((((map__25429.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25429.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25429):map__25429);
var grid_event_handlers = cljs.core.get.call(null,map__25429__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__25429__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var map__25431 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25431__$1 = ((((!((map__25431 == null)))?((((map__25431.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25431.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25431):map__25431);
var map__25432 = cljs.core.get.call(null,map__25431__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__25432__$1 = ((((!((map__25432 == null)))?((((map__25432.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25432.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25432):map__25432);
var map__25433 = cljs.core.get.call(null,map__25432__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__25433__$1 = ((((!((map__25433 == null)))?((((map__25433.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25433.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25433):map__25433);
var num_displayed_records = cljs.core.get.call(null,map__25433__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__25433__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25432__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,new cljs.core.Keyword(null,"language","language",-1591107564),current_language,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754),hide_actions_column_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var _ = console.log(">>> columns: ",cljs.core.clj__GT_js.call(null,columns));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (map__25431,map__25431__$1,map__25432,map__25432__$1,map__25433,map__25433__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__25429,map__25429__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__25431,map__25431__$1,map__25432,map__25432__$1,map__25433,map__25433__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__25429,map__25429__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__25431,map__25431__$1,map__25432,map__25432__$1,map__25433,map__25433__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__25429,map__25429__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(map__25431,map__25431__$1,map__25432,map__25432__$1,map__25433,map__25433__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__25429,map__25429__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__25431,map__25431__$1,map__25432,map__25432__$1,map__25433,map__25433__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__25429,map__25429__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(map__25431,map__25431__$1,map__25432,map__25432__$1,map__25433,map__25433__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__25429,map__25429__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__25431,map__25431__$1,map__25432,map__25432__$1,map__25433,map__25433__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__25429,map__25429__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
});})(map__25431,map__25431__$1,map__25432,map__25432__$1,map__25433,map__25433__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__25429,map__25429__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__12309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto__,event_chan){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__,event_chan){
return (function (state_25698){
var state_val_25699 = (state_25698[(1)]);
if((state_val_25699 === (7))){
var inst_25607 = (state_25698[(7)]);
var inst_25607__$1 = (state_25698[(2)]);
var inst_25609 = (inst_25607__$1 == null);
var inst_25610 = cljs.core.not.call(null,inst_25609);
var state_25698__$1 = (function (){var statearr_25700 = state_25698;
(statearr_25700[(7)] = inst_25607__$1);

return statearr_25700;
})();
if(inst_25610){
var statearr_25701_25768 = state_25698__$1;
(statearr_25701_25768[(1)] = (8));

} else {
var statearr_25702_25769 = state_25698__$1;
(statearr_25702_25769[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (20))){
var inst_25629 = (state_25698[(8)]);
var inst_25637 = (state_25698[(9)]);
var inst_25646 = inst_25637.call(null,inst_25629);
var state_25698__$1 = state_25698;
var statearr_25703_25770 = state_25698__$1;
(statearr_25703_25770[(2)] = inst_25646);

(statearr_25703_25770[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (27))){
var state_25698__$1 = state_25698;
var statearr_25704_25771 = state_25698__$1;
(statearr_25704_25771[(2)] = null);

(statearr_25704_25771[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (1))){
var state_25698__$1 = state_25698;
var statearr_25705_25772 = state_25698__$1;
(statearr_25705_25772[(2)] = null);

(statearr_25705_25772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (24))){
var state_25698__$1 = state_25698;
var statearr_25706_25773 = state_25698__$1;
(statearr_25706_25773[(2)] = null);

(statearr_25706_25773[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (4))){
var state_25698__$1 = state_25698;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25698__$1,(7),event_chan);
} else {
if((state_val_25699 === (15))){
var inst_25607 = (state_25698[(7)]);
var state_25698__$1 = state_25698;
var statearr_25707_25774 = state_25698__$1;
(statearr_25707_25774[(2)] = inst_25607);

(statearr_25707_25774[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (21))){
var state_25698__$1 = state_25698;
var statearr_25708_25775 = state_25698__$1;
(statearr_25708_25775[(2)] = null);

(statearr_25708_25775[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (31))){
var inst_25633 = (state_25698[(10)]);
var inst_25671 = (state_25698[(2)]);
var inst_25672 = cljs.core._EQ_.call(null,inst_25633,new cljs.core.Keyword(null,"table","table",-564943036));
var state_25698__$1 = (function (){var statearr_25709 = state_25698;
(statearr_25709[(11)] = inst_25671);

return statearr_25709;
})();
if(inst_25672){
var statearr_25710_25776 = state_25698__$1;
(statearr_25710_25776[(1)] = (32));

} else {
var statearr_25711_25777 = state_25698__$1;
(statearr_25711_25777[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (32))){
var inst_25631 = (state_25698[(12)]);
var inst_25628 = (state_25698[(13)]);
var inst_25629 = (state_25698[(8)]);
var inst_25637 = (state_25698[(9)]);
var inst_25633 = (state_25698[(10)]);
var inst_25632 = (state_25698[(14)]);
var inst_25627 = (state_25698[(15)]);
var inst_25630 = (state_25698[(16)]);
var inst_25638 = (state_25698[(17)]);
var inst_25685 = cljs.core.async.chan.call(null,(1));
var inst_25686 = (function (){var new_columns = inst_25632;
var submission_clicked = inst_25629;
var submission_unclicked = inst_25630;
var get_submission_data = inst_25638;
var c__12309__auto____$1 = inst_25685;
var re_render = inst_25633;
var update_data_BANG_ = inst_25637;
var submission_to_rank = inst_25628;
var filter_by = inst_25631;
var map__25605 = inst_25627;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25605,inst_25631,inst_25628,inst_25629,inst_25637,inst_25633,inst_25632,inst_25627,inst_25630,inst_25638,inst_25685,state_val_25699,c__12309__auto__,event_chan){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25605,inst_25631,inst_25628,inst_25629,inst_25637,inst_25633,inst_25632,inst_25627,inst_25630,inst_25638,inst_25685,state_val_25699,c__12309__auto__,event_chan){
return (function (state_25683){
var state_val_25684 = (state_25683[(1)]);
if((state_val_25684 === (1))){
var inst_25674 = cljs.core.async.timeout.call(null,(20));
var state_25683__$1 = state_25683;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25683__$1,(2),inst_25674);
} else {
if((state_val_25684 === (2))){
var inst_25676 = (state_25683[(2)]);
var inst_25677 = grid.resizeCanvas();
var inst_25678 = grid.invalidateAllRows();
var inst_25679 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25680 = grid.render();
var inst_25681 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_25683__$1 = (function (){var statearr_25712 = state_25683;
(statearr_25712[(7)] = inst_25680);

(statearr_25712[(8)] = inst_25677);

(statearr_25712[(9)] = inst_25679);

(statearr_25712[(10)] = inst_25678);

(statearr_25712[(11)] = inst_25676);

return statearr_25712;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25683__$1,inst_25681);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25605,inst_25631,inst_25628,inst_25629,inst_25637,inst_25633,inst_25632,inst_25627,inst_25630,inst_25638,inst_25685,state_val_25699,c__12309__auto__,event_chan))
;
return ((function (switch__12197__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25605,inst_25631,inst_25628,inst_25629,inst_25637,inst_25633,inst_25632,inst_25627,inst_25630,inst_25638,inst_25685,state_val_25699,c__12309__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____0 = (function (){
var statearr_25716 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25716[(0)] = hatti$views$table$handle_table_events_$_state_machine__12198__auto__);

(statearr_25716[(1)] = (1));

return statearr_25716;
});
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____1 = (function (state_25683){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_25683);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e25717){if((e25717 instanceof Object)){
var ex__12201__auto__ = e25717;
var statearr_25718_25778 = state_25683;
(statearr_25718_25778[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25683);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25717;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25779 = state_25683;
state_25683 = G__25779;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = function(state_25683){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____1.call(this,state_25683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25605,inst_25631,inst_25628,inst_25629,inst_25637,inst_25633,inst_25632,inst_25627,inst_25630,inst_25638,inst_25685,state_val_25699,c__12309__auto__,event_chan))
})();
var state__12311__auto__ = (function (){var statearr_25719 = f__12310__auto__.call(null);
(statearr_25719[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto____$1);

return statearr_25719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25605,inst_25631,inst_25628,inst_25629,inst_25637,inst_25633,inst_25632,inst_25627,inst_25630,inst_25638,inst_25685,state_val_25699,c__12309__auto__,event_chan))
})();
var inst_25687 = cljs.core.async.impl.dispatch.run.call(null,inst_25686);
var state_25698__$1 = (function (){var statearr_25720 = state_25698;
(statearr_25720[(18)] = inst_25687);

return statearr_25720;
})();
var statearr_25721_25780 = state_25698__$1;
(statearr_25721_25780[(2)] = inst_25685);

(statearr_25721_25780[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (33))){
var state_25698__$1 = state_25698;
var statearr_25722_25781 = state_25698__$1;
(statearr_25722_25781[(2)] = null);

(statearr_25722_25781[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (13))){
var inst_25619 = (state_25698[(2)]);
var state_25698__$1 = state_25698;
var statearr_25723_25782 = state_25698__$1;
(statearr_25723_25782[(2)] = inst_25619);

(statearr_25723_25782[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (22))){
var inst_25630 = (state_25698[(16)]);
var inst_25649 = (state_25698[(2)]);
var state_25698__$1 = (function (){var statearr_25724 = state_25698;
(statearr_25724[(19)] = inst_25649);

return statearr_25724;
})();
if(cljs.core.truth_(inst_25630)){
var statearr_25725_25783 = state_25698__$1;
(statearr_25725_25783[(1)] = (23));

} else {
var statearr_25726_25784 = state_25698__$1;
(statearr_25726_25784[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (29))){
var inst_25631 = (state_25698[(12)]);
var inst_25663 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_25664 = [inst_25631];
var inst_25665 = cljs.core.PersistentHashMap.fromArrays(inst_25663,inst_25664);
var inst_25666 = cljs.core.clj__GT_js.call(null,inst_25665);
var inst_25667 = dataview.setFilterArgs(inst_25666);
var inst_25668 = dataview.refresh();
var state_25698__$1 = (function (){var statearr_25727 = state_25698;
(statearr_25727[(20)] = inst_25667);

return statearr_25727;
})();
var statearr_25728_25785 = state_25698__$1;
(statearr_25728_25785[(2)] = inst_25668);

(statearr_25728_25785[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (6))){
var inst_25694 = (state_25698[(2)]);
var state_25698__$1 = state_25698;
var statearr_25729_25786 = state_25698__$1;
(statearr_25729_25786[(2)] = inst_25694);

(statearr_25729_25786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (28))){
var inst_25631 = (state_25698[(12)]);
var inst_25661 = (state_25698[(2)]);
var state_25698__$1 = (function (){var statearr_25730 = state_25698;
(statearr_25730[(21)] = inst_25661);

return statearr_25730;
})();
if(cljs.core.truth_(inst_25631)){
var statearr_25731_25787 = state_25698__$1;
(statearr_25731_25787[(1)] = (29));

} else {
var statearr_25732_25788 = state_25698__$1;
(statearr_25732_25788[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (25))){
var inst_25632 = (state_25698[(14)]);
var inst_25654 = (state_25698[(2)]);
var state_25698__$1 = (function (){var statearr_25733 = state_25698;
(statearr_25733[(22)] = inst_25654);

return statearr_25733;
})();
if(cljs.core.truth_(inst_25632)){
var statearr_25734_25789 = state_25698__$1;
(statearr_25734_25789[(1)] = (26));

} else {
var statearr_25735_25790 = state_25698__$1;
(statearr_25735_25790[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (34))){
var inst_25690 = (state_25698[(2)]);
var state_25698__$1 = (function (){var statearr_25736 = state_25698;
(statearr_25736[(23)] = inst_25690);

return statearr_25736;
})();
var statearr_25737_25791 = state_25698__$1;
(statearr_25737_25791[(2)] = null);

(statearr_25737_25791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (17))){
var inst_25628 = (state_25698[(13)]);
var inst_25637 = (state_25698[(9)]);
var inst_25638 = (state_25698[(17)]);
var inst_25640 = inst_25638.call(null,hatti.constants._rank,inst_25628);
var inst_25641 = inst_25637.call(null,inst_25640);
var state_25698__$1 = state_25698;
var statearr_25738_25792 = state_25698__$1;
(statearr_25738_25792[(2)] = inst_25641);

(statearr_25738_25792[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (3))){
var inst_25696 = (state_25698[(2)]);
var state_25698__$1 = state_25698;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25698__$1,inst_25696);
} else {
if((state_val_25699 === (12))){
var state_25698__$1 = state_25698;
var statearr_25739_25793 = state_25698__$1;
(statearr_25739_25793[(2)] = false);

(statearr_25739_25793[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (2))){
var state_25698__$1 = state_25698;
var statearr_25740_25794 = state_25698__$1;
(statearr_25740_25794[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (23))){
var inst_25637 = (state_25698[(9)]);
var inst_25651 = inst_25637.call(null,null);
var state_25698__$1 = state_25698;
var statearr_25742_25795 = state_25698__$1;
(statearr_25742_25795[(2)] = inst_25651);

(statearr_25742_25795[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (19))){
var inst_25629 = (state_25698[(8)]);
var inst_25644 = (state_25698[(2)]);
var state_25698__$1 = (function (){var statearr_25743 = state_25698;
(statearr_25743[(24)] = inst_25644);

return statearr_25743;
})();
if(cljs.core.truth_(inst_25629)){
var statearr_25744_25796 = state_25698__$1;
(statearr_25744_25796[(1)] = (20));

} else {
var statearr_25745_25797 = state_25698__$1;
(statearr_25745_25797[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (11))){
var state_25698__$1 = state_25698;
var statearr_25746_25798 = state_25698__$1;
(statearr_25746_25798[(2)] = true);

(statearr_25746_25798[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (9))){
var state_25698__$1 = state_25698;
var statearr_25747_25799 = state_25698__$1;
(statearr_25747_25799[(2)] = false);

(statearr_25747_25799[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (5))){
var state_25698__$1 = state_25698;
var statearr_25748_25800 = state_25698__$1;
(statearr_25748_25800[(2)] = null);

(statearr_25748_25800[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (14))){
var inst_25607 = (state_25698[(7)]);
var inst_25624 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25607);
var state_25698__$1 = state_25698;
var statearr_25749_25801 = state_25698__$1;
(statearr_25749_25801[(2)] = inst_25624);

(statearr_25749_25801[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (26))){
var inst_25632 = (state_25698[(14)]);
var inst_25656 = grid.setColumns(inst_25632);
var inst_25657 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25658 = grid.render();
var state_25698__$1 = (function (){var statearr_25750 = state_25698;
(statearr_25750[(25)] = inst_25657);

(statearr_25750[(26)] = inst_25656);

return statearr_25750;
})();
var statearr_25751_25802 = state_25698__$1;
(statearr_25751_25802[(2)] = inst_25658);

(statearr_25751_25802[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (16))){
var inst_25631 = (state_25698[(12)]);
var inst_25628 = (state_25698[(13)]);
var inst_25629 = (state_25698[(8)]);
var inst_25637 = (state_25698[(9)]);
var inst_25633 = (state_25698[(10)]);
var inst_25632 = (state_25698[(14)]);
var inst_25627 = (state_25698[(15)]);
var inst_25630 = (state_25698[(16)]);
var inst_25627__$1 = (state_25698[(2)]);
var inst_25628__$1 = cljs.core.get.call(null,inst_25627__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_25629__$1 = cljs.core.get.call(null,inst_25627__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_25630__$1 = cljs.core.get.call(null,inst_25627__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_25631__$1 = cljs.core.get.call(null,inst_25627__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_25632__$1 = cljs.core.get.call(null,inst_25627__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_25633__$1 = cljs.core.get.call(null,inst_25627__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_25634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25635 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_25636 = (new cljs.core.PersistentVector(null,3,(5),inst_25634,inst_25635,null));
var inst_25637__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_25636);
var inst_25638 = (function (){var map__25605 = inst_25627__$1;
var submission_to_rank = inst_25628__$1;
var submission_clicked = inst_25629__$1;
var submission_unclicked = inst_25630__$1;
var filter_by = inst_25631__$1;
var new_columns = inst_25632__$1;
var re_render = inst_25633__$1;
var update_data_BANG_ = inst_25637__$1;
return ((function (map__25605,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25631,inst_25628,inst_25629,inst_25637,inst_25633,inst_25632,inst_25627,inst_25630,inst_25627__$1,inst_25628__$1,inst_25629__$1,inst_25630__$1,inst_25631__$1,inst_25632__$1,inst_25633__$1,inst_25634,inst_25635,inst_25636,inst_25637__$1,state_val_25699,c__12309__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__25605,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25631,inst_25628,inst_25629,inst_25637,inst_25633,inst_25632,inst_25627,inst_25630,inst_25627__$1,inst_25628__$1,inst_25629__$1,inst_25630__$1,inst_25631__$1,inst_25632__$1,inst_25633__$1,inst_25634,inst_25635,inst_25636,inst_25637__$1,state_val_25699,c__12309__auto__,event_chan){
return (function (p1__25437_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__25437_SHARP_,field));
});})(map__25605,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25631,inst_25628,inst_25629,inst_25637,inst_25633,inst_25632,inst_25627,inst_25630,inst_25627__$1,inst_25628__$1,inst_25629__$1,inst_25630__$1,inst_25631__$1,inst_25632__$1,inst_25633__$1,inst_25634,inst_25635,inst_25636,inst_25637__$1,state_val_25699,c__12309__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(map__25605,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25631,inst_25628,inst_25629,inst_25637,inst_25633,inst_25632,inst_25627,inst_25630,inst_25627__$1,inst_25628__$1,inst_25629__$1,inst_25630__$1,inst_25631__$1,inst_25632__$1,inst_25633__$1,inst_25634,inst_25635,inst_25636,inst_25637__$1,state_val_25699,c__12309__auto__,event_chan))
})();
var state_25698__$1 = (function (){var statearr_25752 = state_25698;
(statearr_25752[(12)] = inst_25631__$1);

(statearr_25752[(13)] = inst_25628__$1);

(statearr_25752[(8)] = inst_25629__$1);

(statearr_25752[(9)] = inst_25637__$1);

(statearr_25752[(10)] = inst_25633__$1);

(statearr_25752[(14)] = inst_25632__$1);

(statearr_25752[(15)] = inst_25627__$1);

(statearr_25752[(16)] = inst_25630__$1);

(statearr_25752[(17)] = inst_25638);

return statearr_25752;
})();
if(cljs.core.truth_(inst_25628__$1)){
var statearr_25753_25803 = state_25698__$1;
(statearr_25753_25803[(1)] = (17));

} else {
var statearr_25754_25804 = state_25698__$1;
(statearr_25754_25804[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (30))){
var state_25698__$1 = state_25698;
var statearr_25755_25805 = state_25698__$1;
(statearr_25755_25805[(2)] = null);

(statearr_25755_25805[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (10))){
var inst_25622 = (state_25698[(2)]);
var state_25698__$1 = state_25698;
if(cljs.core.truth_(inst_25622)){
var statearr_25756_25806 = state_25698__$1;
(statearr_25756_25806[(1)] = (14));

} else {
var statearr_25757_25807 = state_25698__$1;
(statearr_25757_25807[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (18))){
var state_25698__$1 = state_25698;
var statearr_25758_25808 = state_25698__$1;
(statearr_25758_25808[(2)] = null);

(statearr_25758_25808[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25699 === (8))){
var inst_25607 = (state_25698[(7)]);
var inst_25612 = inst_25607.cljs$lang$protocol_mask$partition0$;
var inst_25613 = (inst_25612 & (64));
var inst_25614 = inst_25607.cljs$core$ISeq$;
var inst_25615 = (inst_25613) || (inst_25614);
var state_25698__$1 = state_25698;
if(cljs.core.truth_(inst_25615)){
var statearr_25759_25809 = state_25698__$1;
(statearr_25759_25809[(1)] = (11));

} else {
var statearr_25760_25810 = state_25698__$1;
(statearr_25760_25810[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__,event_chan))
;
return ((function (switch__12197__auto__,c__12309__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____0 = (function (){
var statearr_25764 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25764[(0)] = hatti$views$table$handle_table_events_$_state_machine__12198__auto__);

(statearr_25764[(1)] = (1));

return statearr_25764;
});
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____1 = (function (state_25698){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_25698);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e25765){if((e25765 instanceof Object)){
var ex__12201__auto__ = e25765;
var statearr_25766_25811 = state_25698;
(statearr_25766_25811[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25698);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25765;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25812 = state_25698;
state_25698 = G__25812;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = function(state_25698){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____1.call(this,state_25698);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__,event_chan))
})();
var state__12311__auto__ = (function (){var statearr_25767 = f__12310__auto__.call(null);
(statearr_25767[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_25767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto__,event_chan))
);

return c__12309__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"field-key","field-key",313262601),k);

return colset_BANG_.call(null,k);
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__25829(s__25830){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__25830__$1 = s__25830;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25830__$1);
if(temp__4657__auto__){
var s__25830__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25830__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25830__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25832 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25831 = (0);
while(true){
if((i__25831 < size__7188__auto__)){
var vec__25839 = cljs.core._nth.call(null,c__7187__auto__,i__25831);
var k = cljs.core.nth.call(null,vec__25839,(0),null);
var v = cljs.core.nth.call(null,vec__25839,(1),null);
cljs.core.chunk_append.call(null,b__25832,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__25831,vec__25839,k,v,c__7187__auto__,size__7188__auto__,b__25832,s__25830__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__25831,vec__25839,k,v,c__7187__auto__,size__7188__auto__,b__25832,s__25830__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__25845 = (i__25831 + (1));
i__25831 = G__25845;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25832),hatti$views$table$render_options_$_iter__25829.call(null,cljs.core.chunk_rest.call(null,s__25830__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25832),null);
}
} else {
var vec__25842 = cljs.core.first.call(null,s__25830__$2);
var k = cljs.core.nth.call(null,vec__25842,(0),null);
var v = cljs.core.nth.call(null,vec__25842,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__25842,k,v,s__25830__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__25842,k,v,s__25830__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__25829.call(null,cljs.core.rest.call(null,s__25830__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table25847 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25847 = (function (_,owner,meta25848){
this._ = _;
this.owner = owner;
this.meta25848 = meta25848;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25847.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25849,meta25848__$1){
var self__ = this;
var _25849__$1 = this;
return (new hatti.views.table.t_hatti$views$table25847(self__._,self__.owner,meta25848__$1));
});

hatti.views.table.t_hatti$views$table25847.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25849){
var self__ = this;
var _25849__$1 = this;
return self__.meta25848;
});

hatti.views.table.t_hatti$views$table25847.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table25847.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field-key","field-key",313262601),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table25847.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table25847.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__25850){
var self__ = this;
var map__25851 = p__25850;
var map__25851__$1 = ((((!((map__25851 == null)))?((((map__25851.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25851.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25851):map__25851);
var field_key = cljs.core.get.call(null,map__25851__$1,new cljs.core.Keyword(null,"field-key","field-key",313262601));
var language = cljs.core.get.call(null,map__25851__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__25853 = om.core.get_shared.call(null,self__.owner);
var map__25853__$1 = ((((!((map__25853 == null)))?((((map__25853.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25853.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25853):map__25853);
var flat_form = cljs.core.get.call(null,map__25853__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__25853,map__25853__$1,flat_form,new_language,___$2,map__25851,map__25851__$1,field_key,language){
return (function (p1__25846_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__25846_SHARP_),new cljs.core.Keyword(null,"language","language",-1591107564),new_language)], null));
});})(options,map__25853,map__25853__$1,flat_form,new_language,___$2,map__25851,map__25851__$1,field_key,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,field_key);
} else {
}

return React.DOM.div(({"className": "label-changer"}),React.DOM.span(({"className": "label-changer-label"}),"Show:"),React.DOM.div(({"id": "header-display-dropdown", "className": "drop-hover"}),(function (){var attrs25857 = options.call(null,field_key);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs25857))?sablono.interpreter.attributes.call(null,attrs25857):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25857))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i(({"className": "fa fa-angle-down"}))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25857),React.DOM.i(({"className": "fa fa-angle-down"}))], null))));
})(),(function (){var attrs25862 = hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_);
return cljs.core.apply.call(null,React.DOM.ul,((cljs.core.map_QMARK_.call(null,attrs25862))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs25862)):({"className": "submenu no-dot"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25862))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25862)], null))));
})()));
});

hatti.views.table.t_hatti$views$table25847.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta25848","meta25848",-899230785,null)], null);
});

hatti.views.table.t_hatti$views$table25847.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25847.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25847";

hatti.views.table.t_hatti$views$table25847.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25847");
});

hatti.views.table.__GT_t_hatti$views$table25847 = (function hatti$views$table$__GT_t_hatti$views$table25847(___$1,owner__$1,meta25848){
return (new hatti.views.table.t_hatti$views$table25847(___$1,owner__$1,meta25848));
});

}

return (new hatti.views.table.t_hatti$views$table25847(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto__,query){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__,query){
return (function (state_25905){
var state_val_25906 = (state_25905[(1)]);
if((state_val_25906 === (1))){
var inst_25891 = cljs.core.async.timeout.call(null,(150));
var state_25905__$1 = state_25905;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25905__$1,(2),inst_25891);
} else {
if((state_val_25906 === (2))){
var inst_25893 = (state_25905[(2)]);
var inst_25894 = input.value;
var inst_25895 = cljs.core._EQ_.call(null,query,inst_25894);
var state_25905__$1 = (function (){var statearr_25907 = state_25905;
(statearr_25907[(7)] = inst_25893);

return statearr_25907;
})();
if(inst_25895){
var statearr_25908_25919 = state_25905__$1;
(statearr_25908_25919[(1)] = (3));

} else {
var statearr_25909_25920 = state_25905__$1;
(statearr_25909_25920[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25906 === (3))){
var inst_25897 = [query_event_key];
var inst_25898 = [query];
var inst_25899 = cljs.core.PersistentHashMap.fromArrays(inst_25897,inst_25898);
var inst_25900 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_25899);
var state_25905__$1 = state_25905;
var statearr_25910_25921 = state_25905__$1;
(statearr_25910_25921[(2)] = inst_25900);

(statearr_25910_25921[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25906 === (4))){
var state_25905__$1 = state_25905;
var statearr_25911_25922 = state_25905__$1;
(statearr_25911_25922[(2)] = null);

(statearr_25911_25922[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25906 === (5))){
var inst_25903 = (state_25905[(2)]);
var state_25905__$1 = state_25905;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25905__$1,inst_25903);
} else {
return null;
}
}
}
}
}
});})(c__12309__auto__,query))
;
return ((function (switch__12197__auto__,c__12309__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12198__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12198__auto____0 = (function (){
var statearr_25915 = [null,null,null,null,null,null,null,null];
(statearr_25915[(0)] = hatti$views$table$delayed_search_$_state_machine__12198__auto__);

(statearr_25915[(1)] = (1));

return statearr_25915;
});
var hatti$views$table$delayed_search_$_state_machine__12198__auto____1 = (function (state_25905){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_25905);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e25916){if((e25916 instanceof Object)){
var ex__12201__auto__ = e25916;
var statearr_25917_25923 = state_25905;
(statearr_25917_25923[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25905);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25916;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25924 = state_25905;
state_25905 = G__25924;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12198__auto__ = function(state_25905){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12198__auto____1.call(this,state_25905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12198__auto____0;
hatti$views$table$delayed_search_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12198__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__,query))
})();
var state__12311__auto__ = (function (){var statearr_25918 = f__12310__auto__.call(null);
(statearr_25918[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_25918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto__,query))
);

return c__12309__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table25926 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25926 = (function (_,owner,meta25927){
this._ = _;
this.owner = owner;
this.meta25927 = meta25927;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25926.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25928,meta25927__$1){
var self__ = this;
var _25928__$1 = this;
return (new hatti.views.table.t_hatti$views$table25926(self__._,self__.owner,meta25927__$1));
});

hatti.views.table.t_hatti$views$table25926.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25928){
var self__ = this;
var _25928__$1 = this;
return self__.meta25927;
});

hatti.views.table.t_hatti$views$table25926.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table25926.prototype.om$core$IRender$render$arity$1 = (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
return React.DOM.div(({"className": "table-search"}),React.DOM.i(({"className": "fa fa-search"})),sablono.interpreter.input.call(null,({"type": "text", "placeholder": "Search", "onChange": ((function (this__18254__auto____$1){
return (function (p1__25925_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__25925_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__18254__auto____$1))
})));
});

hatti.views.table.t_hatti$views$table25926.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta25927","meta25927",128528058,null)], null);
});

hatti.views.table.t_hatti$views$table25926.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25926.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25926";

hatti.views.table.t_hatti$views$table25926.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25926");
});

hatti.views.table.__GT_t_hatti$views$table25926 = (function hatti$views$table$__GT_t_hatti$views$table25926(___$1,owner__$1,meta25927){
return (new hatti.views.table.t_hatti$views$table25926(___$1,owner__$1,meta25927));
});

}

return (new hatti.views.table.t_hatti$views$table25926(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table25931 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25931 = (function (cursor,owner,meta25932){
this.cursor = cursor;
this.owner = owner;
this.meta25932 = meta25932;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25931.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25933,meta25932__$1){
var self__ = this;
var _25933__$1 = this;
return (new hatti.views.table.t_hatti$views$table25931(self__.cursor,self__.owner,meta25932__$1));
});

hatti.views.table.t_hatti$views$table25931.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25933){
var self__ = this;
var _25933__$1 = this;
return self__.meta25932;
});

hatti.views.table.t_hatti$views$table25931.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table25931.prototype.om$core$IRender$render$arity$1 = (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
return React.DOM.div(({"className": "topbar"}),React.DOM.div(({"id": hatti.views.table.pager_id})),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,self__.cursor)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.cursor)),React.DOM.div(({"style": ({"clear": "both"})})));
});

hatti.views.table.t_hatti$views$table25931.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta25932","meta25932",937032430,null)], null);
});

hatti.views.table.t_hatti$views$table25931.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25931.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25931";

hatti.views.table.t_hatti$views$table25931.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25931");
});

hatti.views.table.__GT_t_hatti$views$table25931 = (function hatti$views$table$__GT_t_hatti$views$table25931(cursor__$1,owner__$1,meta25932){
return (new hatti.views.table.t_hatti$views$table25931(cursor__$1,owner__$1,meta25932));
});

}

return (new hatti.views.table.t_hatti$views$table25931(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq.call(null,data)){
var map__25941 = om.core.get_shared.call(null,owner);
var map__25941__$1 = ((((!((map__25941 == null)))?((((map__25941.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25941.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25941):map__25941);
var flat_form = cljs.core.get.call(null,map__25941__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__25942 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__25942,(0),null);
var dataview = cljs.core.nth.call(null,vec__25942,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901),hatti.views.table.get_table_view_height.call(null));
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881),resize_handler);
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__25947,owner,p__25948){
var map__25949 = p__25947;
var map__25949__$1 = ((((!((map__25949 == null)))?((((map__25949.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25949.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25949):map__25949);
var cursor = map__25949__$1;
var map__25950 = cljs.core.get.call(null,map__25949__$1,new cljs.core.Keyword(null,"views","views",1450155487));
var map__25950__$1 = ((((!((map__25950 == null)))?((((map__25950.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25950.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25950):map__25950);
var active = cljs.core.get.call(null,map__25950__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var map__25951 = p__25948;
var map__25951__$1 = ((((!((map__25951 == null)))?((((map__25951.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25951.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25951):map__25951);
var opts = map__25951__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__25951__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

var active_QMARK_ = chimera.seq.in_QMARK_.call(null,active,new cljs.core.Keyword(null,"table","table",-564943036));
if(typeof hatti.views.table.t_hatti$views$table25955 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25955 = (function (map__25951,owner,map__25950,active_QMARK_,slick_grid_event_handlers,cursor,p__25947,map__25949,active,opts,p__25948,meta25956){
this.map__25951 = map__25951;
this.owner = owner;
this.map__25950 = map__25950;
this.active_QMARK_ = active_QMARK_;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.cursor = cursor;
this.p__25947 = p__25947;
this.map__25949 = map__25949;
this.active = active;
this.opts = opts;
this.p__25948 = p__25948;
this.meta25956 = meta25956;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25955.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers){
return (function (_25957,meta25956__$1){
var self__ = this;
var _25957__$1 = this;
return (new hatti.views.table.t_hatti$views$table25955(self__.map__25951,self__.owner,self__.map__25950,self__.active_QMARK_,self__.slick_grid_event_handlers,self__.cursor,self__.p__25947,self__.map__25949,self__.active,self__.opts,self__.p__25948,meta25956__$1));
});})(active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25955.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers){
return (function (_25957){
var self__ = this;
var _25957__$1 = this;
return self__.meta25956;
});})(active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25955.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table25955.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers){
return (function (_,p__25958){
var self__ = this;
var map__25959 = p__25958;
var map__25959__$1 = ((((!((map__25959 == null)))?((((map__25959.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25959.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25959):map__25959);
var table_view_height = cljs.core.get.call(null,map__25959__$1,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901));
var ___$1 = this;
var map__25961 = self__.cursor;
var map__25961__$1 = ((((!((map__25961 == null)))?((((map__25961.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25961.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25961):map__25961);
var map__25962 = cljs.core.get.call(null,map__25961__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__25962__$1 = ((((!((map__25962 == null)))?((((map__25962.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25962.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25962):map__25962);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.call(null,map__25962__$1,new cljs.core.Keyword(null,"prevent-scrolling-in-table-view?","prevent-scrolling-in-table-view?",2053296532));
var submission_clicked = cljs.core.get.call(null,map__25962__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var data = cljs.core.get.call(null,map__25961__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var dataset_info = cljs.core.get.call(null,map__25961__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var map__25963 = dataset_info;
var map__25963__$1 = ((((!((map__25963 == null)))?((((map__25963.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25963.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25963):map__25963);
var num_of_submissions = cljs.core.get.call(null,map__25963__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,data);
var with_info = ((function (map__25961,map__25961__$1,map__25962,map__25962__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__25963,map__25963__$1,num_of_submissions,no_data_QMARK_,___$1,map__25959,map__25959__$1,table_view_height,active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers){
return (function (p1__25946_SHARP_){
return cljs.core.merge.call(null,self__.cursor,p1__25946_SHARP_);
});})(map__25961,map__25961__$1,map__25962,map__25962__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__25963,map__25963__$1,num_of_submissions,no_data_QMARK_,___$1,map__25959,map__25959__$1,table_view_height,active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
return React.DOM.div(({"style": cljs.core.clj__GT_js.call(null,(cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"height","height",1025178622),(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height.call(null);
}
})(),new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null):null)), "className": "table-view"}),sablono.interpreter.interpret.call(null,(cljs.core.truth_(new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.call(null,hatti.views.submission_view,with_info.call(null,submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null)):null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.cursor)),React.DOM.div(({"id": hatti.views.table.table_id, "className": "slickgrid"}),(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.p(({"className": "alert alert-warning"}),"No data"):React.DOM.span(null,React.DOM.i(({"className": "fa fa-spinner fa-pulse"})),"Loading..."))));
} else {
return null;
}
});})(active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25955.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table25955.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler.call(null,self__.owner);

var data = cljs.core.get_in.call(null,self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__25971 = temp__4657__auto__;
var grid = cljs.core.nth.call(null,vec__25971,(0),null);
var dataview = cljs.core.nth.call(null,vec__25971,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25955.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table25955.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.call(null,self__.owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881)));
});})(active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25955.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table25955.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__25974 = om.core.get_state.call(null,self__.owner);
var map__25974__$1 = ((((!((map__25974 == null)))?((((map__25974.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25974.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25974):map__25974);
var grid = cljs.core.get.call(null,map__25974__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__25974__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__25976 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__25976,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__25976,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25955.getBasis = ((function (active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"map__25951","map__25951",1138751490,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"map__25950","map__25950",-1134574105,null),new cljs.core.Symbol(null,"active?","active?",2100031303,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"p__25947","p__25947",-1445426924,null),new cljs.core.Symbol(null,"map__25949","map__25949",-126743244,null),new cljs.core.Symbol(null,"active","active",-758473701,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"p__25948","p__25948",1867337533,null),new cljs.core.Symbol(null,"meta25956","meta25956",-892937676,null)], null);
});})(active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25955.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25955.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25955";

hatti.views.table.t_hatti$views$table25955.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25955");
});})(active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table25955 = ((function (active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table25955(map__25951__$2,owner__$1,map__25950__$2,active_QMARK___$1,slick_grid_event_handlers__$1,cursor__$1,p__25947__$1,map__25949__$2,active__$1,opts__$1,p__25948__$1,meta25956){
return (new hatti.views.table.t_hatti$views$table25955(map__25951__$2,owner__$1,map__25950__$2,active_QMARK___$1,slick_grid_event_handlers__$1,cursor__$1,p__25947__$1,map__25949__$2,active__$1,opts__$1,p__25948__$1,meta25956));
});})(active_QMARK_,map__25949,map__25949__$1,cursor,map__25950,map__25950__$1,active,map__25951,map__25951__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table25955(map__25951__$1,owner,map__25950__$1,active_QMARK_,slick_grid_event_handlers,cursor,p__25947,map__25949__$1,active,opts,p__25948,cljs.core.PersistentArrayMap.EMPTY));
}));
