// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('chimera.seq');
goog.require('hatti.constants');
goog.require('chimera.urls');
goog.require('clojure.string');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__7189__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__35596(s__35597){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__35597__$1 = s__35597;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35597__$1);
if(temp__4657__auto__){
var s__35597__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35597__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35597__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35599 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35598 = (0);
while(true){
if((i__35598 < size__7188__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35598);
cljs.core.chunk_append(b__35599,(function (){var iter__7189__auto__ = ((function (i__35598,datum,c__7187__auto__,size__7188__auto__,b__35599,s__35597__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__35596_$_iter__35614(s__35615){
return (new cljs.core.LazySeq(null,((function (i__35598,datum,c__7187__auto__,size__7188__auto__,b__35599,s__35597__$2,temp__4657__auto__,osmfields){
return (function (){
var s__35615__$1 = s__35615;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__35615__$1);
if(temp__4657__auto____$1){
var s__35615__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__35615__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first(s__35615__$2);
var size__7188__auto____$1 = cljs.core.count(c__7187__auto____$1);
var b__35617 = cljs.core.chunk_buffer(size__7188__auto____$1);
if((function (){var i__35616 = (0);
while(true){
if((i__35616 < size__7188__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto____$1,i__35616);
cljs.core.chunk_append(b__35617,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__35626 = (i__35616 + (1));
i__35616 = G__35626;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35617),hatti$ona$post_process$ona_osm_link_$_iter__35596_$_iter__35614(cljs.core.chunk_rest(s__35615__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35617),null);
}
} else {
var field = cljs.core.first(s__35615__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__35596_$_iter__35614(cljs.core.rest(s__35615__$2)));
}
} else {
return null;
}
break;
}
});})(i__35598,datum,c__7187__auto__,size__7188__auto__,b__35599,s__35597__$2,temp__4657__auto__,osmfields))
,null,null));
});})(i__35598,datum,c__7187__auto__,size__7188__auto__,b__35599,s__35597__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__(osmfields);
})());

var G__35627 = (i__35598 + (1));
i__35598 = G__35627;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35599),hatti$ona$post_process$ona_osm_link_$_iter__35596(cljs.core.chunk_rest(s__35597__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35599),null);
}
} else {
var datum = cljs.core.first(s__35597__$2);
return cljs.core.cons((function (){var iter__7189__auto__ = ((function (datum,s__35597__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__35596_$_iter__35620(s__35621){
return (new cljs.core.LazySeq(null,((function (datum,s__35597__$2,temp__4657__auto__,osmfields){
return (function (){
var s__35621__$1 = s__35621;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__35621__$1);
if(temp__4657__auto____$1){
var s__35621__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__35621__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35621__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35623 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35622 = (0);
while(true){
if((i__35622 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35622);
cljs.core.chunk_append(b__35623,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__35628 = (i__35622 + (1));
i__35622 = G__35628;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35623),hatti$ona$post_process$ona_osm_link_$_iter__35596_$_iter__35620(cljs.core.chunk_rest(s__35621__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35623),null);
}
} else {
var field = cljs.core.first(s__35621__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__35596_$_iter__35620(cljs.core.rest(s__35621__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__35597__$2,temp__4657__auto__,osmfields))
,null,null));
});})(datum,s__35597__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__35596(cljs.core.rest(s__35597__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__7189__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__35630 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__35630);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (function (){var G__35654 = cljs.core.cst$kw$features;
return (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(G__35654) : osmgeo.call(null,G__35654));
})();
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__35655(s__35656){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__35656__$1 = s__35656;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35656__$1);
if(temp__4657__auto__){
var s__35656__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35656__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35656__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35658 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35657 = (0);
while(true){
if((i__35657 < size__7188__auto__)){
var map__35669 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35657);
var map__35669__$1 = ((((!((map__35669 == null)))?((((map__35669.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35669.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35669):map__35669);
var feature = map__35669__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35669__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35669__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35669__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__35658,(function (){var map__35671 = properties;
var map__35671__$1 = ((((!((map__35671 == null)))?((((map__35671.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35671.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35671):map__35671);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35671__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35671__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35671__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__35677 = (i__35657 + (1));
i__35657 = G__35677;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35658),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__35655(cljs.core.chunk_rest(s__35656__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35658),null);
}
} else {
var map__35673 = cljs.core.first(s__35656__$2);
var map__35673__$1 = ((((!((map__35673 == null)))?((((map__35673.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35673.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35673):map__35673);
var feature = map__35673__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35673__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35673__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35673__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__35675 = properties;
var map__35675__$1 = ((((!((map__35675 == null)))?((((map__35675.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35675.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35675):map__35675);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35675__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35675__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35675__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__35655(cljs.core.rest(s__35656__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__7189__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__35678_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__35678_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val,osm_id){
if(typeof osm_val === 'string'){
var temp__4655__auto__ = (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(osm_id) : osm_data.call(null,osm_id));
if(cljs.core.truth_(temp__4655__auto__)){
var osm_submission_data = temp__4655__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__7189__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__35690(s__35691){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__35691__$1 = s__35691;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35691__$1);
if(temp__4657__auto__){
var s__35691__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35691__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35691__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35693 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35692 = (0);
while(true){
if((i__35692 < size__7188__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35692);
cljs.core.chunk_append(b__35693,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (i__35692,osm_id,datum,c__7187__auto__,size__7188__auto__,b__35693,s__35691__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__35679_SHARP_){
return osm_val__GT_osm_data(p1__35679_SHARP_,osm_id);
});})(i__35692,osm_id,datum,c__7187__auto__,size__7188__auto__,b__35693,s__35691__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})());

var G__35700 = (i__35692 + (1));
i__35692 = G__35700;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35693),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__35690(cljs.core.chunk_rest(s__35691__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35693),null);
}
} else {
var datum = cljs.core.first(s__35691__$2);
return cljs.core.cons((function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (osm_id,datum,s__35691__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__35679_SHARP_){
return osm_val__GT_osm_data(p1__35679_SHARP_,osm_id);
});})(osm_id,datum,s__35691__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})(),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__35690(cljs.core.rest(s__35691__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__7189__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__35696 = cljs.core.seq(osm_fields);
var chunk__35697 = null;
var count__35698 = (0);
var i__35699 = (0);
while(true){
if((i__35699 < count__35698)){
var osm_field = chunk__35697.cljs$core$IIndexed$_nth$arity$2(null,i__35699);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__35701 = seq__35696;
var G__35702 = chunk__35697;
var G__35703 = count__35698;
var G__35704 = (i__35699 + (1));
seq__35696 = G__35701;
chunk__35697 = G__35702;
count__35698 = G__35703;
i__35699 = G__35704;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__35696);
if(temp__4657__auto__){
var seq__35696__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35696__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__35696__$1);
var G__35705 = cljs.core.chunk_rest(seq__35696__$1);
var G__35706 = c__7220__auto__;
var G__35707 = cljs.core.count(c__7220__auto__);
var G__35708 = (0);
seq__35696 = G__35705;
chunk__35697 = G__35706;
count__35698 = G__35707;
i__35699 = G__35708;
continue;
} else {
var osm_field = cljs.core.first(seq__35696__$1);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__35709 = cljs.core.next(seq__35696__$1);
var G__35710 = null;
var G__35711 = (0);
var G__35712 = (0);
seq__35696 = G__35709;
chunk__35697 = G__35710;
count__35698 = G__35711;
i__35699 = G__35712;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Gets and returns matching name for an attachment that was renamed by
 *   appending a hash on the S3 server to avoid duplicating names.
 *   e.g. if 1478203839187.jpg was renamed to 1478203839187_wijUzUf.jpg,
 *   it returns 1478203839187_wijUzUf.jpg.
 */
hatti.ona.post_process.get_matching_name = (function hatti$ona$post_process$get_matching_name(fname,fnames){
if(typeof fname === 'string'){
try{var or__6409__auto__ = (function (){var G__35722 = (function (p1__35713_SHARP_){
return cljs.core.re_find(cljs.core.re_pattern(cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(fname,cljs.core.re_pattern("\\.")))),p1__35713_SHARP_);
});
var G__35723 = fnames;
return (chimera.seq.filter_first.cljs$core$IFn$_invoke$arity$2 ? chimera.seq.filter_first.cljs$core$IFn$_invoke$arity$2(G__35722,G__35723) : chimera.seq.filter_first.call(null,G__35722,G__35723));
})();
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return fname;
}
}catch (e35719){if((e35719 instanceof SyntaxError)){
var e = e35719;
return fname;
} else {
throw e35719;

}
}} else {
return fname;
}
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__6409__auto__ = attachments;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,hatti.constants._attachments);
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__35724_SHARP_){
return chimera.urls.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__35724_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,hatti.ona.post_process.get_matching_name(fname,fnames),fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Coll -> Coll
 */
hatti.ona.post_process.filter_media = (function hatti$ona$post_process$filter_media(flat_form){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__35725_SHARP_){
var or__6409__auto__ = hatti.ona.forms.video_QMARK_(p1__35725_SHARP_);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.image_QMARK_(p1__35725_SHARP_);
}
}),flat_form);
});
/**
 * Inlines media data from within _attachments into each record.
 * Coll Coll -> Coll
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__7491__auto__ = [];
var len__7484__auto___35738 = arguments.length;
var i__7485__auto___35739 = (0);
while(true){
if((i__7485__auto___35739 < len__7484__auto___35738)){
args__7491__auto__.push((arguments[i__7485__auto___35739]));

var G__35740 = (i__7485__auto___35739 + (1));
i__7485__auto___35739 = G__35740;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__35729){
var map__35730 = p__35729;
var map__35730__$1 = ((((!((map__35730 == null)))?((((map__35730.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35730.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35730):map__35730);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35730__$1,cljs.core.cst$kw$attachments);
var image_fields = hatti.ona.post_process.filter_media(flat_form);
var iter__7189__auto__ = ((function (image_fields,map__35730,map__35730__$1,attachments){
return (function hatti$ona$post_process$iter__35732(s__35733){
return (new cljs.core.LazySeq(null,((function (image_fields,map__35730,map__35730__$1,attachments){
return (function (){
var s__35733__$1 = s__35733;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35733__$1);
if(temp__4657__auto__){
var s__35733__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35733__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35733__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35735 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35734 = (0);
while(true){
if((i__35734 < size__7188__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35734);
cljs.core.chunk_append(b__35735,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__35734,attach_map,record,c__7187__auto__,size__7188__auto__,b__35735,s__35733__$2,temp__4657__auto__,image_fields,map__35730,map__35730__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__35734,attach_map,record,c__7187__auto__,size__7188__auto__,b__35735,s__35733__$2,temp__4657__auto__,image_fields,map__35730,map__35730__$1,attachments))
,record,image_fields);
})());

var G__35741 = (i__35734 + (1));
i__35734 = G__35741;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35735),hatti$ona$post_process$iter__35732(cljs.core.chunk_rest(s__35733__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35735),null);
}
} else {
var record = cljs.core.first(s__35733__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__35733__$2,temp__4657__auto__,image_fields,map__35730,map__35730__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__35733__$2,temp__4657__auto__,image_fields,map__35730,map__35730__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__35732(cljs.core.rest(s__35733__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__35730,map__35730__$1,attachments))
,null,null));
});})(image_fields,map__35730,map__35730__$1,attachments))
;
return iter__7189__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq35726){
var G__35727 = cljs.core.first(seq35726);
var seq35726__$1 = cljs.core.next(seq35726);
var G__35728 = cljs.core.first(seq35726__$1);
var seq35726__$2 = cljs.core.next(seq35726__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__35727,G__35728,seq35726__$2);
});

/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,hatti.constants._attachments)], 0)));
});})(repeat_fields))
;
var iter__7189__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__35748(s__35749){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__35749__$1 = s__35749;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35749__$1);
if(temp__4657__auto__){
var s__35749__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35749__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35749__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35751 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35750 = (0);
while(true){
if((i__35750 < size__7188__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35750);
cljs.core.chunk_append(b__35751,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__35754 = (i__35750 + (1));
i__35750 = G__35754;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35751),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__35748(cljs.core.chunk_rest(s__35749__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35751),null);
}
} else {
var record = cljs.core.first(s__35749__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__35748(cljs.core.rest(s__35749__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__7189__auto__(data);
});
/**
 * Inlines data from within _attachments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___35762 = arguments.length;
var i__7485__auto___35763 = (0);
while(true){
if((i__7485__auto___35763 < len__7484__auto___35762)){
args__7491__auto__.push((arguments[i__7485__auto___35763]));

var G__35764 = (i__7485__auto___35763 + (1));
i__7485__auto___35763 = G__35764;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__35759){
var map__35760 = p__35759;
var map__35760__$1 = ((((!((map__35760 == null)))?((((map__35760.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35760.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35760):map__35760);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35760__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__35760,map__35760__$1,app_data_keys){
return (function (p1__35755_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__35755_SHARP_));
});})(map__35760,map__35760__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq35756){
var G__35757 = cljs.core.first(seq35756);
var seq35756__$1 = cljs.core.next(seq35756);
var G__35758 = cljs.core.first(seq35756__$1);
var seq35756__$2 = cljs.core.next(seq35756__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35757,G__35758,seq35756__$2);
});

