// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__){
return (function (state_40668){
var state_val_40669 = (state_40668[(1)]);
if((state_val_40669 === (7))){
var inst_40625 = (state_40668[(7)]);
var inst_40625__$1 = (state_40668[(2)]);
var inst_40627 = (inst_40625__$1 == null);
var inst_40628 = cljs.core.not(inst_40627);
var state_40668__$1 = (function (){var statearr_40670 = state_40668;
(statearr_40670[(7)] = inst_40625__$1);

return statearr_40670;
})();
if(inst_40628){
var statearr_40671_40708 = state_40668__$1;
(statearr_40671_40708[(1)] = (8));

} else {
var statearr_40672_40709 = state_40668__$1;
(statearr_40672_40709[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (20))){
var inst_40647 = (state_40668[(8)]);
var inst_40655 = (state_40668[(2)]);
var state_40668__$1 = (function (){var statearr_40673 = state_40668;
(statearr_40673[(9)] = inst_40655);

return statearr_40673;
})();
if(cljs.core.truth_(inst_40647)){
var statearr_40674_40710 = state_40668__$1;
(statearr_40674_40710[(1)] = (21));

} else {
var statearr_40675_40711 = state_40668__$1;
(statearr_40675_40711[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (1))){
var state_40668__$1 = state_40668;
var statearr_40676_40712 = state_40668__$1;
(statearr_40676_40712[(2)] = null);

(statearr_40676_40712[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (4))){
var state_40668__$1 = state_40668;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40668__$1,(7),agg_data_channel);
} else {
if((state_val_40669 === (15))){
var inst_40625 = (state_40668[(7)]);
var state_40668__$1 = state_40668;
var statearr_40677_40713 = state_40668__$1;
(statearr_40677_40713[(2)] = inst_40625);

(statearr_40677_40713[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (21))){
var inst_40657 = cljs.core.async.close_BANG_(agg_data_channel);
var state_40668__$1 = state_40668;
var statearr_40678_40714 = state_40668__$1;
(statearr_40678_40714[(2)] = inst_40657);

(statearr_40678_40714[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (13))){
var inst_40637 = (state_40668[(2)]);
var state_40668__$1 = state_40668;
var statearr_40679_40715 = state_40668__$1;
(statearr_40679_40715[(2)] = inst_40637);

(statearr_40679_40715[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (22))){
var state_40668__$1 = state_40668;
var statearr_40680_40716 = state_40668__$1;
(statearr_40680_40716[(2)] = null);

(statearr_40680_40716[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (6))){
var inst_40664 = (state_40668[(2)]);
var state_40668__$1 = state_40668;
var statearr_40681_40717 = state_40668__$1;
(statearr_40681_40717[(2)] = inst_40664);

(statearr_40681_40717[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (17))){
var inst_40646 = (state_40668[(10)]);
var inst_40647 = (state_40668[(8)]);
var inst_40649 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_40646,inst_40647) : callback.call(null,inst_40646,inst_40647));
var state_40668__$1 = state_40668;
var statearr_40682_40718 = state_40668__$1;
(statearr_40682_40718[(2)] = inst_40649);

(statearr_40682_40718[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (3))){
var inst_40666 = (state_40668[(2)]);
var state_40668__$1 = state_40668;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40668__$1,inst_40666);
} else {
if((state_val_40669 === (12))){
var state_40668__$1 = state_40668;
var statearr_40683_40719 = state_40668__$1;
(statearr_40683_40719[(2)] = false);

(statearr_40683_40719[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (2))){
var state_40668__$1 = state_40668;
var statearr_40684_40720 = state_40668__$1;
(statearr_40684_40720[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (23))){
var inst_40660 = (state_40668[(2)]);
var state_40668__$1 = (function (){var statearr_40686 = state_40668;
(statearr_40686[(11)] = inst_40660);

return statearr_40686;
})();
var statearr_40687_40721 = state_40668__$1;
(statearr_40687_40721[(2)] = null);

(statearr_40687_40721[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (19))){
var inst_40652 = (state_40668[(2)]);
var inst_40653 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_40668__$1 = (function (){var statearr_40688 = state_40668;
(statearr_40688[(12)] = inst_40652);

return statearr_40688;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40668__$1,(20),inst_40653);
} else {
if((state_val_40669 === (11))){
var state_40668__$1 = state_40668;
var statearr_40689_40722 = state_40668__$1;
(statearr_40689_40722[(2)] = true);

(statearr_40689_40722[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (9))){
var state_40668__$1 = state_40668;
var statearr_40690_40723 = state_40668__$1;
(statearr_40690_40723[(2)] = false);

(statearr_40690_40723[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (5))){
var state_40668__$1 = state_40668;
var statearr_40691_40724 = state_40668__$1;
(statearr_40691_40724[(2)] = null);

(statearr_40691_40724[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (14))){
var inst_40625 = (state_40668[(7)]);
var inst_40642 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_40625);
var state_40668__$1 = state_40668;
var statearr_40692_40725 = state_40668__$1;
(statearr_40692_40725[(2)] = inst_40642);

(statearr_40692_40725[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (16))){
var inst_40646 = (state_40668[(10)]);
var inst_40645 = (state_40668[(2)]);
var inst_40646__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40645,cljs.core.cst$kw$data);
var inst_40647 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40645,cljs.core.cst$kw$completed_QMARK_);
var state_40668__$1 = (function (){var statearr_40693 = state_40668;
(statearr_40693[(10)] = inst_40646__$1);

(statearr_40693[(8)] = inst_40647);

return statearr_40693;
})();
if(cljs.core.truth_(inst_40646__$1)){
var statearr_40694_40726 = state_40668__$1;
(statearr_40694_40726[(1)] = (17));

} else {
var statearr_40695_40727 = state_40668__$1;
(statearr_40695_40727[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (10))){
var inst_40640 = (state_40668[(2)]);
var state_40668__$1 = state_40668;
if(cljs.core.truth_(inst_40640)){
var statearr_40696_40728 = state_40668__$1;
(statearr_40696_40728[(1)] = (14));

} else {
var statearr_40697_40729 = state_40668__$1;
(statearr_40697_40729[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (18))){
var state_40668__$1 = state_40668;
var statearr_40698_40730 = state_40668__$1;
(statearr_40698_40730[(2)] = null);

(statearr_40698_40730[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40669 === (8))){
var inst_40625 = (state_40668[(7)]);
var inst_40630 = inst_40625.cljs$lang$protocol_mask$partition0$;
var inst_40631 = (inst_40630 & (64));
var inst_40632 = inst_40625.cljs$core$ISeq$;
var inst_40633 = (inst_40631) || (inst_40632);
var state_40668__$1 = state_40668;
if(cljs.core.truth_(inst_40633)){
var statearr_40699_40731 = state_40668__$1;
(statearr_40699_40731[(1)] = (11));

} else {
var statearr_40700_40732 = state_40668__$1;
(statearr_40700_40732[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__))
;
return ((function (switch__12197__auto__,c__12309__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____0 = (function (){
var statearr_40704 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40704[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__);

(statearr_40704[(1)] = (1));

return statearr_40704;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____1 = (function (state_40668){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_40668);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e40705){if((e40705 instanceof Object)){
var ex__12201__auto__ = e40705;
var statearr_40706_40733 = state_40668;
(statearr_40706_40733[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40668);

return cljs.core.cst$kw$recur;
} else {
throw e40705;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__40734 = state_40668;
state_40668 = G__40734;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__ = function(state_40668){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____1.call(this,state_40668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__))
})();
var state__12311__auto__ = (function (){var statearr_40707 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_40707[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_40707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__))
);

return c__12309__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__40737_40739 = agg;
var G__40738_40740 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__40737_40739,G__40738_40740) : cljs.core.reset_BANG_.call(null,G__40737_40739,G__40738_40740));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___40748 = arguments.length;
var i__7485__auto___40749 = (0);
while(true){
if((i__7485__auto___40749 < len__7484__auto___40748)){
args__7491__auto__.push((arguments[i__7485__auto___40749]));

var G__40750 = (i__7485__auto___40749 + (1));
i__7485__auto___40749 = G__40750;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__40744){
var map__40745 = p__40744;
var map__40745__$1 = ((((!((map__40745 == null)))?((((map__40745.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40745.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40745):map__40745);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40745__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__40747 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__40747) : cljs.core.atom.call(null,G__40747));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__40745,map__40745__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__40745,map__40745__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__40745,map__40745__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__40745,map__40745__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq40741){
var G__40742 = cljs.core.first(seq40741);
var seq40741__$1 = cljs.core.next(seq40741);
var G__40743 = cljs.core.first(seq40741__$1);
var seq40741__$2 = cljs.core.next(seq40741__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__40742,G__40743,seq40741__$2);
});

