// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.shared');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('cljs.core.async');
goog.require('sablono.core');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('hatti.utils.om.state');
goog.require('chimera.urls');
hatti.shared.event_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
hatti.shared.event_multi_chan = cljs.core.async.mult(hatti.shared.event_chan);
hatti.shared.event_tap = (function hatti$shared$event_tap(){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_multi_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
});
hatti.shared.external_event_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
hatti.shared.external_event_multi_chan = cljs.core.async.mult(hatti.shared.external_event_chan);
hatti.shared.external_event_tap = (function hatti$shared$external_event_tap(){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(hatti.shared.external_event_multi_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
});
hatti.shared.default_fields = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,"_submission_time",cljs.core.cst$kw$label,"Submission Time",cljs.core.cst$kw$name,"_submission_time",cljs.core.cst$kw$type,"datetime"], null)], null);
/**
 * An initial, empty, app-state, which can be modified to change dataviews.
 */
hatti.shared.empty_app_state = (function hatti$shared$empty_app_state(){
var G__35165 = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted,cljs.core.cst$kw$api_DASH_url,cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$status,cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$selected_DASH_table_DASH_rows,cljs.core.cst$kw$chart_DASH_page,cljs.core.cst$kw$languages,cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$views,cljs.core.cst$kw$data],[cljs.core.PersistentVector.EMPTY,"//api.ona.io/api/v1/",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$submission_DASH_clicked,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,null], null),cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,false], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$total_DASH_records,(0),cljs.core.cst$kw$loading_QMARK_,true], null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$visible_DASH_charts,hatti.shared.default_fields,cljs.core.cst$kw$chart_DASH_data,cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$current,null,cljs.core.cst$kw$all,cljs.core.PersistentVector.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$submission_DASH_clicked,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,null], null),cljs.core.cst$kw$geofield,cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$all,new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$chart,cljs.core.cst$kw$dashboard,cljs.core.cst$kw$map,cljs.core.cst$kw$overview,cljs.core.cst$kw$photos,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$settings,cljs.core.cst$kw$table,cljs.core.cst$kw$user_DASH_guide], null),cljs.core.cst$kw$disabled,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$selected,cljs.core.cst$kw$overview,cljs.core.cst$kw$settings,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$all,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$basemaps,cljs.core.cst$kw$form_DASH_info,cljs.core.cst$kw$integrated_DASH_apps,cljs.core.cst$kw$media_DASH_files,cljs.core.cst$kw$service_DASH_configuration,cljs.core.cst$kw$settings,cljs.core.cst$kw$xls_DASH_reports], null),cljs.core.cst$kw$active_DASH_tab,cljs.core.cst$kw$form_DASH_info,cljs.core.cst$kw$integrated_DASH_apps,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$active_DASH_section,cljs.core.cst$kw$apps_DASH_list,cljs.core.cst$kw$add_QMARK_,false], null)], null)], null),cljs.core.PersistentVector.EMPTY]);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__35165) : cljs.core.atom.call(null,G__35165));
});
hatti.shared.app_state = hatti.shared.empty_app_state();
/**
 * Given a function over data, run a transact on data inside app-state.
 */
hatti.shared.transact_app_data_BANG_ = (function hatti$shared$transact_app_data_BANG_(app_state,transact_fn){
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null),transact_fn);
});
/**
 * Given `data` received from the server, update the app-state.
 * Sorts by submission time, and adds rank to the data, for table + map views.
 */
hatti.shared.update_app_data_BANG_ = (function hatti$shared$update_app_data_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___35173 = arguments.length;
var i__7485__auto___35174 = (0);
while(true){
if((i__7485__auto___35174 < len__7484__auto___35173)){
args__7491__auto__.push((arguments[i__7485__auto___35174]));

var G__35175 = (i__7485__auto___35174 + (1));
i__7485__auto___35174 = G__35175;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__35170){
var map__35171 = p__35170;
var map__35171__$1 = ((((!((map__35171 == null)))?((((map__35171.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35171.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35171):map__35171);
var rerank_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35171__$1,cljs.core.cst$kw$rerank_QMARK_);
var completed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35171__$1,cljs.core.cst$kw$completed_QMARK_);
var sort_field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35171__$1,cljs.core.cst$kw$sort_DASH_field);
var current_start_index = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35171__$1,cljs.core.cst$kw$current_DASH_start_DASH_index,(0));
var add_rank = ((function (map__35171,map__35171__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (i,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,hatti.constants._rank,(current_start_index + (i + (1))));
});})(map__35171,map__35171__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
;
var data__$1 = (cljs.core.truth_((function (){var and__6397__auto__ = rerank_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.seq(data);
} else {
return and__6397__auto__;
}
})())?cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(add_rank,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (add_rank,map__35171,map__35171__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (p1__35166_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__35166_SHARP_,(function (){var or__6409__auto__ = sort_field;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants._submission_time;
}
})());
});})(add_rank,map__35171,map__35171__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
,data))):cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(add_rank,data)));
var total_records = cljs.core.count(data__$1);
hatti.shared.transact_app_data_BANG_(app_state,((function (add_rank,data__$1,total_records,map__35171,map__35171__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (_){
return data__$1;
});})(add_rank,data__$1,total_records,map__35171,map__35171__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
);

return chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$status], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$total_DASH_records,total_records,cljs.core.cst$kw$loading_QMARK_,cljs.core.not(completed_QMARK_)], null));
});

hatti.shared.update_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.update_app_data_BANG_.cljs$lang$applyTo = (function (seq35167){
var G__35168 = cljs.core.first(seq35167);
var seq35167__$1 = cljs.core.next(seq35167);
var G__35169 = cljs.core.first(seq35167__$1);
var seq35167__$2 = cljs.core.next(seq35167__$1);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35168,G__35169,seq35167__$2);
});

/**
 * Add to app data.
 */
hatti.shared.add_to_app_data_BANG_ = (function hatti$shared$add_to_app_data_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___35182 = arguments.length;
var i__7485__auto___35183 = (0);
while(true){
if((i__7485__auto___35183 < len__7484__auto___35182)){
args__7491__auto__.push((arguments[i__7485__auto___35183]));

var G__35184 = (i__7485__auto___35183 + (1));
i__7485__auto___35183 = G__35184;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__35179){
var map__35180 = p__35179;
var map__35180__$1 = ((((!((map__35180 == null)))?((((map__35180.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35180.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35180):map__35180);
var completed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35180__$1,cljs.core.cst$kw$completed_QMARK_);
var old_data = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)));
hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(app_state,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(old_data,data),cljs.core.array_seq([cljs.core.cst$kw$rerank_QMARK_,completed_QMARK_], 0));

return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$status,cljs.core.cst$kw$loading_QMARK_], null),cljs.core.not(completed_QMARK_));
});

hatti.shared.add_to_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.add_to_app_data_BANG_.cljs$lang$applyTo = (function (seq35176){
var G__35177 = cljs.core.first(seq35176);
var seq35176__$1 = cljs.core.next(seq35176);
var G__35178 = cljs.core.first(seq35176__$1);
var seq35176__$2 = cljs.core.next(seq35176__$1);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35177,G__35178,seq35176__$2);
});

/**
 * Merge languages into the app-state if form is multilingual
 */
hatti.shared.maybe_merge_languages_BANG_ = (function hatti$shared$maybe_merge_languages_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___35191 = arguments.length;
var i__7485__auto___35192 = (0);
while(true){
if((i__7485__auto___35192 < len__7484__auto___35191)){
args__7491__auto__.push((arguments[i__7485__auto___35192]));

var G__35193 = (i__7485__auto___35192 + (1));
i__7485__auto___35192 = G__35193;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.shared.maybe_merge_languages_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.shared.maybe_merge_languages_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__35187){
var vec__35188 = p__35187;
var state = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35188,(0),null);
if(cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))){
var langs = hatti.ona.forms.get_languages(form);
var default_lang = hatti.ona.forms.default_lang(langs);
var lang_state = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$all,langs,cljs.core.cst$kw$default,default_lang,cljs.core.cst$kw$current,default_lang], null);
return chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((function (){var or__6409__auto__ = state;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.shared.app_state;
}
})(),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$languages], null),lang_state);
} else {
return null;
}
});

hatti.shared.maybe_merge_languages_BANG_.cljs$lang$maxFixedArity = (1);

hatti.shared.maybe_merge_languages_BANG_.cljs$lang$applyTo = (function (seq35185){
var G__35186 = cljs.core.first(seq35185);
var seq35185__$1 = cljs.core.next(seq35185);
return hatti.shared.maybe_merge_languages_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35186,seq35185__$1);
});

hatti.shared.language_cursor = (function hatti$shared$language_cursor(var_args){
var args__7491__auto__ = [];
var len__7484__auto___35199 = arguments.length;
var i__7485__auto___35200 = (0);
while(true){
if((i__7485__auto___35200 < len__7484__auto___35199)){
args__7491__auto__.push((arguments[i__7485__auto___35200]));

var G__35201 = (i__7485__auto___35200 + (1));
i__7485__auto___35200 = G__35201;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.shared.language_cursor.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.shared.language_cursor.cljs$core$IFn$_invoke$arity$variadic = (function (p__35195){
var vec__35196 = p__35195;
var state = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35196,(0),null);
return om.core.ref_cursor(cljs.core.cst$kw$languages.cljs$core$IFn$_invoke$arity$1(om.core.root_cursor((function (){var or__6409__auto__ = state;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.shared.app_state;
}
})())));
});

hatti.shared.language_cursor.cljs$lang$maxFixedArity = (0);

hatti.shared.language_cursor.cljs$lang$applyTo = (function (seq35194){
return hatti.shared.language_cursor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35194));
});

/**
 * A language selector and a following divider.
 */
hatti.shared.language_selector = (function hatti$shared$language_selector(_,owner,p__35203){
var map__35253 = p__35203;
var map__35253__$1 = ((((!((map__35253 == null)))?((((map__35253.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35253.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35253):map__35253);
var custom_app_state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35253__$1,cljs.core.cst$kw$app_DASH_state);
if(typeof hatti.shared.t_hatti$shared35255 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.shared.t_hatti$shared35255 = (function (language_selector,_,owner,p__35203,map__35253,custom_app_state,meta35256){
this.language_selector = language_selector;
this._ = _;
this.owner = owner;
this.p__35203 = p__35203;
this.map__35253 = map__35253;
this.custom_app_state = custom_app_state;
this.meta35256 = meta35256;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.shared.t_hatti$shared35255.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__35253,map__35253__$1,custom_app_state){
return (function (_35257,meta35256__$1){
var self__ = this;
var _35257__$1 = this;
return (new hatti.shared.t_hatti$shared35255(self__.language_selector,self__._,self__.owner,self__.p__35203,self__.map__35253,self__.custom_app_state,meta35256__$1));
});})(map__35253,map__35253__$1,custom_app_state))
;

hatti.shared.t_hatti$shared35255.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__35253,map__35253__$1,custom_app_state){
return (function (_35257){
var self__ = this;
var _35257__$1 = this;
return self__.meta35256;
});})(map__35253,map__35253__$1,custom_app_state))
;

hatti.shared.t_hatti$shared35255.prototype.om$core$IRender$ = true;

hatti.shared.t_hatti$shared35255.prototype.om$core$IRender$render$arity$1 = ((function (map__35253,map__35253__$1,custom_app_state){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var map__35258 = om.core.observe(self__.owner,hatti.shared.language_cursor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(function (){var or__6409__auto__ = self__.custom_app_state;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.shared.app_state;
}
})()], 0)));
var map__35258__$1 = ((((!((map__35258 == null)))?((((map__35258.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35258.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35258):map__35258);
var ls = map__35258__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35258__$1,cljs.core.cst$kw$current);
var all = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35258__$1,cljs.core.cst$kw$all);
var get_update_handler = ((function (map__35258,map__35258__$1,ls,current,all,___$2,map__35253,map__35253__$1,custom_app_state){
return (function (language){
return ((function (map__35258,map__35258__$1,ls,current,all,___$2,map__35253,map__35253__$1,custom_app_state){
return (function (event){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(ls,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$current], null),language);

return event.preventDefault();
});
;})(map__35258,map__35258__$1,ls,current,all,___$2,map__35253,map__35253__$1,custom_app_state))
});})(map__35258,map__35258__$1,ls,current,all,___$2,map__35253,map__35253__$1,custom_app_state))
;
var stringify = ((function (map__35258,map__35258__$1,ls,current,all,get_update_handler,___$2,map__35253,map__35253__$1,custom_app_state){
return (function (p1__35202_SHARP_){
if((p1__35202_SHARP_ instanceof cljs.core.Keyword)){
return cljs.core.name(p1__35202_SHARP_);
} else {
return [cljs.core.str(p1__35202_SHARP_)].join('');
}
});})(map__35258,map__35258__$1,ls,current,all,get_update_handler,___$2,map__35253,map__35253__$1,custom_app_state))
;
var G__35267 = ({"className": "language-selector-inner"});
var G__35268 = (function (){var G__35270 = ({"className": "dropdown drop-hover"});
var G__35271 = (function (){var G__35275 = ({"style": ({"marginRight": ".2em"}), "className": "fa fa-globe"});
return React.DOM.i(G__35275);
})();
var G__35272 = (function (){var attrs35262 = (cljs.core.truth_(hatti.ona.forms.english_QMARK_(current))?"EN":stringify(current));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs35262))?sablono.interpreter.attributes(attrs35262):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs35262))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs35262)], null))));
})();
var G__35273 = (function (){var G__35276 = ({"style": ({"marginLeft": ".5em"}), "className": "fa fa-angle-down"});
return React.DOM.i(G__35276);
})();
var G__35274 = (function (){var G__35277 = ({"className": "submenu"});
var G__35278 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = ((function (G__35277,G__35270,G__35271,G__35272,G__35273,G__35267,map__35258,map__35258__$1,ls,current,all,get_update_handler,stringify,___$2,map__35253,map__35253__$1,custom_app_state){
return (function hatti$shared$language_selector_$_iter__35279(s__35280){
return (new cljs.core.LazySeq(null,((function (G__35277,G__35270,G__35271,G__35272,G__35273,G__35267,map__35258,map__35258__$1,ls,current,all,get_update_handler,stringify,___$2,map__35253,map__35253__$1,custom_app_state){
return (function (){
var s__35280__$1 = s__35280;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35280__$1);
if(temp__4657__auto__){
var s__35280__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35280__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35280__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35282 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35281 = (0);
while(true){
if((i__35281 < size__7188__auto__)){
var language = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35281);
cljs.core.chunk_append(b__35282,(function (){var G__35293 = null;
var G__35294 = (function (){var G__35295 = ({"href": "#", "onClick": get_update_handler(language)});
var G__35296 = sablono.interpreter.interpret(stringify(language));
return React.DOM.a(G__35295,G__35296);
})();
return React.DOM.li(G__35293,G__35294);
})());

var G__35302 = (i__35281 + (1));
i__35281 = G__35302;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35282),hatti$shared$language_selector_$_iter__35279(cljs.core.chunk_rest(s__35280__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35282),null);
}
} else {
var language = cljs.core.first(s__35280__$2);
return cljs.core.cons((function (){var G__35297 = null;
var G__35298 = (function (){var G__35299 = ({"href": "#", "onClick": get_update_handler(language)});
var G__35300 = sablono.interpreter.interpret(stringify(language));
return React.DOM.a(G__35299,G__35300);
})();
return React.DOM.li(G__35297,G__35298);
})(),hatti$shared$language_selector_$_iter__35279(cljs.core.rest(s__35280__$2)));
}
} else {
return null;
}
break;
}
});})(G__35277,G__35270,G__35271,G__35272,G__35273,G__35267,map__35258,map__35258__$1,ls,current,all,get_update_handler,stringify,___$2,map__35253,map__35253__$1,custom_app_state))
,null,null));
});})(G__35277,G__35270,G__35271,G__35272,G__35273,G__35267,map__35258,map__35258__$1,ls,current,all,get_update_handler,stringify,___$2,map__35253,map__35253__$1,custom_app_state))
;
return iter__7189__auto__(all);
})());
return React.DOM.ul(G__35277,G__35278);
})();
return React.DOM.span(G__35270,G__35271,G__35272,G__35273,G__35274);
})();
var G__35269 = (function (){var G__35301 = ({"className": "divider"});
return React.DOM.div(G__35301);
})();
return React.DOM.div(G__35267,G__35268,G__35269);
});})(map__35253,map__35253__$1,custom_app_state))
;

hatti.shared.t_hatti$shared35255.getBasis = ((function (map__35253,map__35253__$1,custom_app_state){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$language_DASH_selector,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$custom_DASH_app_DASH_state,cljs.core.cst$kw$app_DASH_state], null)], null))),cljs.core.cst$kw$doc,"A language selector and a following divider."], null)),cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__35203,cljs.core.cst$sym$map__35253,cljs.core.cst$sym$custom_DASH_app_DASH_state,cljs.core.cst$sym$meta35256], null);
});})(map__35253,map__35253__$1,custom_app_state))
;

hatti.shared.t_hatti$shared35255.cljs$lang$type = true;

hatti.shared.t_hatti$shared35255.cljs$lang$ctorStr = "hatti.shared/t_hatti$shared35255";

hatti.shared.t_hatti$shared35255.cljs$lang$ctorPrWriter = ((function (map__35253,map__35253__$1,custom_app_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.shared/t_hatti$shared35255");
});})(map__35253,map__35253__$1,custom_app_state))
;

hatti.shared.__GT_t_hatti$shared35255 = ((function (map__35253,map__35253__$1,custom_app_state){
return (function hatti$shared$language_selector_$___GT_t_hatti$shared35255(language_selector__$1,___$1,owner__$1,p__35203__$1,map__35253__$2,custom_app_state__$1,meta35256){
return (new hatti.shared.t_hatti$shared35255(language_selector__$1,___$1,owner__$1,p__35203__$1,map__35253__$2,custom_app_state__$1,meta35256));
});})(map__35253,map__35253__$1,custom_app_state))
;

}

return (new hatti.shared.t_hatti$shared35255(hatti$shared$language_selector,_,owner,p__35203,map__35253__$1,custom_app_state,cljs.core.PersistentArrayMap.EMPTY));
});
