// Compiled by ClojureScript 1.9.229 {}
goog.provide('c2.maths');
goog.require('cljs.core');
c2.maths.Pi = Math.PI;
c2.maths.Tau = ((2) * c2.maths.Pi);
c2.maths.e = Math.E;
c2.maths.radians_per_degree = (c2.maths.Pi / (180));
c2.maths.rad = (function c2$maths$rad(x){
return (c2.maths.radians_per_degree * x);
});
c2.maths.deg = (function c2$maths$deg(x){
return (x / c2.maths.radians_per_degree);
});
c2.maths.sin = (function c2$maths$sin(x){
return Math.sin(x);
});
c2.maths.asin = (function c2$maths$asin(x){
return Math.asin(x);
});
c2.maths.cos = (function c2$maths$cos(x){
return Math.cos(x);
});
c2.maths.acos = (function c2$maths$acos(x){
return Math.acos(x);
});
c2.maths.tan = (function c2$maths$tan(x){
return Math.tan(x);
});
c2.maths.atan = (function c2$maths$atan(x){
return Math.atan(x);
});
c2.maths.expt = (function c2$maths$expt(var_args){
var args20720 = [];
var len__7484__auto___20723 = arguments.length;
var i__7485__auto___20724 = (0);
while(true){
if((i__7485__auto___20724 < len__7484__auto___20723)){
args20720.push((arguments[i__7485__auto___20724]));

var G__20725 = (i__7485__auto___20724 + (1));
i__7485__auto___20724 = G__20725;
continue;
} else {
}
break;
}

var G__20722 = args20720.length;
switch (G__20722) {
case 1:
return c2.maths.expt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.expt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20720.length)].join('')));

}
});

c2.maths.expt.cljs$core$IFn$_invoke$arity$1 = (function (x){
return Math.exp(x);
});

c2.maths.expt.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return Math.pow(x,y);
});

c2.maths.expt.cljs$lang$maxFixedArity = 2;

c2.maths.sq = (function c2$maths$sq(x){
return c2.maths.expt.call(null,x,(2));
});
c2.maths.sqrt = (function c2$maths$sqrt(x){
return Math.sqrt(x);
});
c2.maths.floor = (function c2$maths$floor(x){
return Math.floor(x);
});
c2.maths.ceil = (function c2$maths$ceil(x){
return Math.ceil(x);
});
c2.maths.abs = (function c2$maths$abs(x){
return Math.abs(x);
});
c2.maths.log = (function c2$maths$log(var_args){
var args20727 = [];
var len__7484__auto___20730 = arguments.length;
var i__7485__auto___20731 = (0);
while(true){
if((i__7485__auto___20731 < len__7484__auto___20730)){
args20727.push((arguments[i__7485__auto___20731]));

var G__20732 = (i__7485__auto___20731 + (1));
i__7485__auto___20731 = G__20732;
continue;
} else {
}
break;
}

var G__20729 = args20727.length;
switch (G__20729) {
case 1:
return c2.maths.log.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.log.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20727.length)].join('')));

}
});

c2.maths.log.cljs$core$IFn$_invoke$arity$1 = (function (x){
return Math.log(x);
});

c2.maths.log.cljs$core$IFn$_invoke$arity$2 = (function (base,x){
return (Math.log(x) / Math.log(base));
});

c2.maths.log.cljs$lang$maxFixedArity = 2;

c2.maths.log10 = (function c2$maths$log10(x){
return (Math.log(x) / Math.LN10);
});
/**
 * Returns 2-vector of min and max elements in xs.
 */
c2.maths.extent = (function c2$maths$extent(xs){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core.min,xs),cljs.core.apply.call(null,cljs.core.max,xs)], null);
});
/**
 * Arithemetic mean of collection
 */
c2.maths.mean = (function c2$maths$mean(xs){
return (cljs.core.reduce.call(null,cljs.core._PLUS_,xs) / cljs.core.count.call(null,xs));
});
/**
 * Median of a collection.
 */
c2.maths.median = (function c2$maths$median(xs){
var sorted = cljs.core.sort.call(null,xs);
var n = cljs.core.count.call(null,xs);
if(cljs.core._EQ_.call(null,n,(1))){
return cljs.core.first.call(null,sorted);
} else {
if(cljs.core.odd_QMARK_.call(null,n)){
return cljs.core.nth.call(null,sorted,((n + (1)) / (2)));
} else {
var mid = (n / (2));
return c2.maths.mean.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nth.call(null,sorted,c2.maths.floor.call(null,mid)),cljs.core.nth.call(null,sorted,c2.maths.ceil.call(null,mid))], null));

}
}
});
/**
 * Inclusive range; same as core/range, but includes the end.
 */
c2.maths.irange = (function c2$maths$irange(var_args){
var args20734 = [];
var len__7484__auto___20737 = arguments.length;
var i__7485__auto___20738 = (0);
while(true){
if((i__7485__auto___20738 < len__7484__auto___20737)){
args20734.push((arguments[i__7485__auto___20738]));

var G__20739 = (i__7485__auto___20738 + (1));
i__7485__auto___20738 = G__20739;
continue;
} else {
}
break;
}

var G__20736 = args20734.length;
switch (G__20736) {
case 1:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20734.length)].join('')));

}
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$1 = (function (start){
return cljs.core.range.call(null,start);
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.concat.call(null,cljs.core.range.call(null,start,end),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
var r = cljs.core.range.call(null,start,end,step);
if((cljs.core.mod.call(null,cljs.core.first.call(null,r),step) === cljs.core.mod.call(null,end,step))){
return cljs.core.concat.call(null,r,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
} else {
return r;
}
});

c2.maths.irange.cljs$lang$maxFixedArity = 3;

/**
 * Checks if bottom <= x <= top.
 */
c2.maths.within_QMARK_ = (function c2$maths$within_QMARK_(x,p__20741){
var vec__20745 = p__20741;
var bottom = cljs.core.nth.call(null,vec__20745,(0),null);
var top = cljs.core.nth.call(null,vec__20745,(1),null);
return ((bottom <= x)) && ((x <= top));
});
c2.maths.add = (function c2$maths$add(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20749 = arguments.length;
var i__7485__auto___20750 = (0);
while(true){
if((i__7485__auto___20750 < len__7484__auto___20749)){
args__7491__auto__.push((arguments[i__7485__auto___20750]));

var G__20751 = (i__7485__auto___20750 + (1));
i__7485__auto___20750 = G__20751;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.maths.add.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.maths.add.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.call(null,(function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A + B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._PLUS_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._PLUS_,cljs.core.replicate.call(null,cljs.core.count.call(null,B),A),B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (typeof B === 'number')){
return cljs.core.map.call(null,cljs.core._PLUS_,A,cljs.core.replicate.call(null,cljs.core.count.call(null,A),B));
} else {
return null;
}
}
}
}
}),args);
});

c2.maths.add.cljs$lang$maxFixedArity = (0);

c2.maths.add.cljs$lang$applyTo = (function (seq20748){
return c2.maths.add.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20748));
});

c2.maths.sub = (function c2$maths$sub(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20753 = arguments.length;
var i__7485__auto___20754 = (0);
while(true){
if((i__7485__auto___20754 < len__7484__auto___20753)){
args__7491__auto__.push((arguments[i__7485__auto___20754]));

var G__20755 = (i__7485__auto___20754 + (1));
i__7485__auto___20754 = G__20755;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,args),(1))){
if((typeof (0) === 'number') && (typeof cljs.core.first.call(null,args) === 'number')){
return ((0) - cljs.core.first.call(null,args));
} else {
if((cljs.core.coll_QMARK_.call(null,(0))) && (cljs.core.coll_QMARK_.call(null,cljs.core.first.call(null,args)))){
return cljs.core.map.call(null,cljs.core._,(0),cljs.core.first.call(null,args));
} else {
if((typeof (0) === 'number') && (cljs.core.coll_QMARK_.call(null,cljs.core.first.call(null,args)))){
return cljs.core.map.call(null,cljs.core._,cljs.core.replicate.call(null,cljs.core.count.call(null,cljs.core.first.call(null,args)),(0)),cljs.core.first.call(null,args));
} else {
if((cljs.core.coll_QMARK_.call(null,(0))) && (typeof cljs.core.first.call(null,args) === 'number')){
return cljs.core.map.call(null,cljs.core._,(0),cljs.core.replicate.call(null,cljs.core.count.call(null,(0)),cljs.core.first.call(null,args)));
} else {
return null;
}
}
}
}
} else {
return cljs.core.reduce.call(null,(function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A - B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._,cljs.core.replicate.call(null,cljs.core.count.call(null,B),A),B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (typeof B === 'number')){
return cljs.core.map.call(null,cljs.core._,A,cljs.core.replicate.call(null,cljs.core.count.call(null,A),B));
} else {
return null;
}
}
}
}
}),args);
}
});

c2.maths.sub.cljs$lang$maxFixedArity = (0);

c2.maths.sub.cljs$lang$applyTo = (function (seq20752){
return c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20752));
});

c2.maths.mul = (function c2$maths$mul(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20757 = arguments.length;
var i__7485__auto___20758 = (0);
while(true){
if((i__7485__auto___20758 < len__7484__auto___20757)){
args__7491__auto__.push((arguments[i__7485__auto___20758]));

var G__20759 = (i__7485__auto___20758 + (1));
i__7485__auto___20758 = G__20759;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.call(null,(function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A * B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._STAR_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._STAR_,cljs.core.replicate.call(null,cljs.core.count.call(null,B),A),B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (typeof B === 'number')){
return cljs.core.map.call(null,cljs.core._STAR_,A,cljs.core.replicate.call(null,cljs.core.count.call(null,A),B));
} else {
return null;
}
}
}
}
}),args);
});

c2.maths.mul.cljs$lang$maxFixedArity = (0);

c2.maths.mul.cljs$lang$applyTo = (function (seq20756){
return c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20756));
});

c2.maths.div = (function c2$maths$div(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20761 = arguments.length;
var i__7485__auto___20762 = (0);
while(true){
if((i__7485__auto___20762 < len__7484__auto___20761)){
args__7491__auto__.push((arguments[i__7485__auto___20762]));

var G__20763 = (i__7485__auto___20762 + (1));
i__7485__auto___20762 = G__20763;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.maths.div.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.maths.div.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,args),(1))){
if((typeof (1) === 'number') && (typeof cljs.core.first.call(null,args) === 'number')){
return ((1) / cljs.core.first.call(null,args));
} else {
if((cljs.core.coll_QMARK_.call(null,(1))) && (cljs.core.coll_QMARK_.call(null,cljs.core.first.call(null,args)))){
return cljs.core.map.call(null,cljs.core._SLASH_,(1),cljs.core.first.call(null,args));
} else {
if((typeof (1) === 'number') && (cljs.core.coll_QMARK_.call(null,cljs.core.first.call(null,args)))){
return cljs.core.map.call(null,cljs.core._SLASH_,cljs.core.replicate.call(null,cljs.core.count.call(null,cljs.core.first.call(null,args)),(1)),cljs.core.first.call(null,args));
} else {
if((cljs.core.coll_QMARK_.call(null,(1))) && (typeof cljs.core.first.call(null,args) === 'number')){
return cljs.core.map.call(null,cljs.core._SLASH_,(1),cljs.core.replicate.call(null,cljs.core.count.call(null,(1)),cljs.core.first.call(null,args)));
} else {
return null;
}
}
}
}
} else {
return cljs.core.reduce.call(null,(function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A / B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._SLASH_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._SLASH_,cljs.core.replicate.call(null,cljs.core.count.call(null,B),A),B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (typeof B === 'number')){
return cljs.core.map.call(null,cljs.core._SLASH_,A,cljs.core.replicate.call(null,cljs.core.count.call(null,A),B));
} else {
return null;
}
}
}
}
}),args);
}
});

c2.maths.div.cljs$lang$maxFixedArity = (0);

c2.maths.div.cljs$lang$applyTo = (function (seq20760){
return c2.maths.div.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20760));
});

/**
 * Returns the quantiles of a dataset.
 * 
 * Kwargs:
 * 
 *   > *:probs*: ntiles of the data to return, defaults to `[0 0.25 0.5 0.75 1]`
 * 
 *   Algorithm is the same as R's quantile type=7.
 *   Transcribed from Jason Davies; https://github.com/jasondavies/science.js/blob/master/src/stats/quantiles.js
 */
c2.maths.quantile = (function c2$maths$quantile(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20773 = arguments.length;
var i__7485__auto___20774 = (0);
while(true){
if((i__7485__auto___20774 < len__7484__auto___20773)){
args__7491__auto__.push((arguments[i__7485__auto___20774]));

var G__20775 = (i__7485__auto___20774 + (1));
i__7485__auto___20774 = G__20775;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__20766){
var map__20767 = p__20766;
var map__20767__$1 = ((((!((map__20767 == null)))?((((map__20767.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20767.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20767):map__20767);
var probs = cljs.core.get.call(null,map__20767__$1,new cljs.core.Keyword(null,"probs","probs",-1201894224),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),0.25,0.5,0.75,(1)], null));
var xs = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.sort.call(null,data));
var n_1 = (cljs.core.count.call(null,xs) - (1));
var iter__7189__auto__ = ((function (xs,n_1,map__20767,map__20767__$1,probs){
return (function c2$maths$iter__20769(s__20770){
return (new cljs.core.LazySeq(null,((function (xs,n_1,map__20767,map__20767__$1,probs){
return (function (){
var s__20770__$1 = s__20770;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20770__$1);
if(temp__4657__auto__){
var s__20770__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20770__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20770__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20772 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20771 = (0);
while(true){
if((i__20771 < size__7188__auto__)){
var q = cljs.core._nth.call(null,c__7187__auto__,i__20771);
cljs.core.chunk_append.call(null,b__20772,(function (){var index = ((q * n_1) + (1));
var lo = (c2.maths.floor.call(null,index) | (0));
var h = (index - lo);
var a = xs.call(null,(lo - (1)));
if(cljs.core._EQ_.call(null,h,(0))){
return a;
} else {
return (a + (h * (xs.call(null,lo) - a)));
}
})());

var G__20776 = (i__20771 + (1));
i__20771 = G__20776;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20772),c2$maths$iter__20769.call(null,cljs.core.chunk_rest.call(null,s__20770__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20772),null);
}
} else {
var q = cljs.core.first.call(null,s__20770__$2);
return cljs.core.cons.call(null,(function (){var index = ((q * n_1) + (1));
var lo = (c2.maths.floor.call(null,index) | (0));
var h = (index - lo);
var a = xs.call(null,(lo - (1)));
if(cljs.core._EQ_.call(null,h,(0))){
return a;
} else {
return (a + (h * (xs.call(null,lo) - a)));
}
})(),c2$maths$iter__20769.call(null,cljs.core.rest.call(null,s__20770__$2)));
}
} else {
return null;
}
break;
}
});})(xs,n_1,map__20767,map__20767__$1,probs))
,null,null));
});})(xs,n_1,map__20767,map__20767__$1,probs))
;
return iter__7189__auto__.call(null,probs);
});

c2.maths.quantile.cljs$lang$maxFixedArity = (1);

c2.maths.quantile.cljs$lang$applyTo = (function (seq20764){
var G__20765 = cljs.core.first.call(null,seq20764);
var seq20764__$1 = cljs.core.next.call(null,seq20764);
return c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic(G__20765,seq20764__$1);
});

