// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('chimera.seq');
goog.require('hatti.constants');
goog.require('chimera.urls');
goog.require('clojure.string');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten.call(null,(function (){var iter__7189__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__22668(s__22669){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__22669__$1 = s__22669;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22669__$1);
if(temp__4657__auto__){
var s__22669__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22669__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22669__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22671 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22670 = (0);
while(true){
if((i__22670 < size__7188__auto__)){
var datum = cljs.core._nth.call(null,c__7187__auto__,i__22670);
cljs.core.chunk_append.call(null,b__22671,(function (){var iter__7189__auto__ = ((function (i__22670,datum,c__7187__auto__,size__7188__auto__,b__22671,s__22669__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__22668_$_iter__22680(s__22681){
return (new cljs.core.LazySeq(null,((function (i__22670,datum,c__7187__auto__,size__7188__auto__,b__22671,s__22669__$2,temp__4657__auto__,osmfields){
return (function (){
var s__22681__$1 = s__22681;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__22681__$1);
if(temp__4657__auto____$1){
var s__22681__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22681__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first.call(null,s__22681__$2);
var size__7188__auto____$1 = cljs.core.count.call(null,c__7187__auto____$1);
var b__22683 = cljs.core.chunk_buffer.call(null,size__7188__auto____$1);
if((function (){var i__22682 = (0);
while(true){
if((i__22682 < size__7188__auto____$1)){
var field = cljs.core._nth.call(null,c__7187__auto____$1,i__22682);
cljs.core.chunk_append.call(null,b__22683,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__22688 = (i__22682 + (1));
i__22682 = G__22688;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22683),hatti$ona$post_process$ona_osm_link_$_iter__22668_$_iter__22680.call(null,cljs.core.chunk_rest.call(null,s__22681__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22683),null);
}
} else {
var field = cljs.core.first.call(null,s__22681__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__22668_$_iter__22680.call(null,cljs.core.rest.call(null,s__22681__$2)));
}
} else {
return null;
}
break;
}
});})(i__22670,datum,c__7187__auto__,size__7188__auto__,b__22671,s__22669__$2,temp__4657__auto__,osmfields))
,null,null));
});})(i__22670,datum,c__7187__auto__,size__7188__auto__,b__22671,s__22669__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__.call(null,osmfields);
})());

var G__22689 = (i__22670 + (1));
i__22670 = G__22689;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22671),hatti$ona$post_process$ona_osm_link_$_iter__22668.call(null,cljs.core.chunk_rest.call(null,s__22669__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22671),null);
}
} else {
var datum = cljs.core.first.call(null,s__22669__$2);
return cljs.core.cons.call(null,(function (){var iter__7189__auto__ = ((function (datum,s__22669__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__22668_$_iter__22684(s__22685){
return (new cljs.core.LazySeq(null,((function (datum,s__22669__$2,temp__4657__auto__,osmfields){
return (function (){
var s__22685__$1 = s__22685;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__22685__$1);
if(temp__4657__auto____$1){
var s__22685__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22685__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22685__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22687 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22686 = (0);
while(true){
if((i__22686 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__22686);
cljs.core.chunk_append.call(null,b__22687,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__22690 = (i__22686 + (1));
i__22686 = G__22690;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22687),hatti$ona$post_process$ona_osm_link_$_iter__22668_$_iter__22684.call(null,cljs.core.chunk_rest.call(null,s__22685__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22687),null);
}
} else {
var field = cljs.core.first.call(null,s__22685__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__22668_$_iter__22684.call(null,cljs.core.rest.call(null,s__22685__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__22669__$2,temp__4657__auto__,osmfields))
,null,null));
});})(datum,s__22669__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__.call(null,osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__22668.call(null,cljs.core.rest.call(null,s__22669__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__7189__auto__.call(null,data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.call(null,osmtogeojson(jQuery.parseXML(osm_xml_string)),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link.call(null,data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson.call(null,osm_xml);
var featureset = osmgeo.call(null,new cljs.core.Keyword(null,"features","features",-1146962336));
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__22711(s__22712){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__22712__$1 = s__22712;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22712__$1);
if(temp__4657__auto__){
var s__22712__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22712__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22712__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22714 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22713 = (0);
while(true){
if((i__22713 < size__7188__auto__)){
var map__22723 = cljs.core._nth.call(null,c__7187__auto__,i__22713);
var map__22723__$1 = ((((!((map__22723 == null)))?((((map__22723.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22723.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22723):map__22723);
var feature = map__22723__$1;
var type = cljs.core.get.call(null,map__22723__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__22723__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__22723__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
cljs.core.chunk_append.call(null,b__22714,(function (){var map__22725 = properties;
var map__22725__$1 = ((((!((map__22725 == null)))?((((map__22725.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22725.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22725):map__22725);
var type__$1 = cljs.core.get.call(null,map__22725__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__22725__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__22725__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})());

var G__22731 = (i__22713 + (1));
i__22713 = G__22731;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22714),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__22711.call(null,cljs.core.chunk_rest.call(null,s__22712__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22714),null);
}
} else {
var map__22727 = cljs.core.first.call(null,s__22712__$2);
var map__22727__$1 = ((((!((map__22727 == null)))?((((map__22727.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22727.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22727):map__22727);
var feature = map__22727__$1;
var type = cljs.core.get.call(null,map__22727__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__22727__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__22727__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
return cljs.core.cons.call(null,(function (){var map__22729 = properties;
var map__22729__$1 = ((((!((map__22729 == null)))?((((map__22729.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22729.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22729):map__22729);
var type__$1 = cljs.core.get.call(null,map__22729__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__22729__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__22729__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__22711.call(null,cljs.core.rest.call(null,s__22712__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__7189__auto__.call(null,featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq.call(null,osm_fields)){
var data = cljs.core.get_in.call(null,app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data.call(null,data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__22732_SHARP_){
return cljs.core.re_find.call(null,/[-]?[0-9]+/,p1__22732_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val,osm_id){
if(typeof osm_val === 'string'){
var temp__4655__auto__ = osm_data.call(null,osm_id);
if(cljs.core.truth_(temp__4655__auto__)){
var osm_submission_data = temp__4655__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__7189__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__22742(s__22743){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__22743__$1 = s__22743;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22743__$1);
if(temp__4657__auto__){
var s__22743__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22743__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22743__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22745 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22744 = (0);
while(true){
if((i__22744 < size__7188__auto__)){
var datum = cljs.core._nth.call(null,c__7187__auto__,i__22744);
cljs.core.chunk_append.call(null,b__22745,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (i__22744,osm_id,datum,c__7187__auto__,size__7188__auto__,b__22745,s__22743__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__22733_SHARP_){
return osm_val__GT_osm_data.call(null,p1__22733_SHARP_,osm_id);
});})(i__22744,osm_id,datum,c__7187__auto__,size__7188__auto__,b__22745,s__22743__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})());

var G__22750 = (i__22744 + (1));
i__22744 = G__22750;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22745),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__22742.call(null,cljs.core.chunk_rest.call(null,s__22743__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22745),null);
}
} else {
var datum = cljs.core.first.call(null,s__22743__$2);
return cljs.core.cons.call(null,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (osm_id,datum,s__22743__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__22733_SHARP_){
return osm_val__GT_osm_data.call(null,p1__22733_SHARP_,osm_id);
});})(osm_id,datum,s__22743__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})(),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__22742.call(null,cljs.core.rest.call(null,s__22743__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__7189__auto__.call(null,data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__22746 = cljs.core.seq.call(null,osm_fields);
var chunk__22747 = null;
var count__22748 = (0);
var i__22749 = (0);
while(true){
if((i__22749 < count__22748)){
var osm_field = cljs.core._nth.call(null,chunk__22747,i__22749);
chimera.om.state.transact_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__22751 = seq__22746;
var G__22752 = chunk__22747;
var G__22753 = count__22748;
var G__22754 = (i__22749 + (1));
seq__22746 = G__22751;
chunk__22747 = G__22752;
count__22748 = G__22753;
i__22749 = G__22754;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__22746);
if(temp__4657__auto__){
var seq__22746__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22746__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__22746__$1);
var G__22755 = cljs.core.chunk_rest.call(null,seq__22746__$1);
var G__22756 = c__7220__auto__;
var G__22757 = cljs.core.count.call(null,c__7220__auto__);
var G__22758 = (0);
seq__22746 = G__22755;
chunk__22747 = G__22756;
count__22748 = G__22757;
i__22749 = G__22758;
continue;
} else {
var osm_field = cljs.core.first.call(null,seq__22746__$1);
chimera.om.state.transact_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__22759 = cljs.core.next.call(null,seq__22746__$1);
var G__22760 = null;
var G__22761 = (0);
var G__22762 = (0);
seq__22746 = G__22759;
chunk__22747 = G__22760;
count__22748 = G__22761;
i__22749 = G__22762;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.call(null,media_obj,"id");
var fname = cljs.core.get.call(null,media_obj,"filename");
var file_url = hatti.ona.urls.media_url.call(null,media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"filename","filename",-1428840783),fname,new cljs.core.Keyword(null,"download_url","download_url",-2115471203),file_url,new cljs.core.Keyword(null,"small_download_url","small_download_url",1654303565),[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Gets and returns matching name for an attachment that was renamed by
 *   appending a hash on the S3 server to avoid duplicating names.
 *   e.g. if 1478203839187.jpg was renamed to 1478203839187_wijUzUf.jpg,
 *   it returns 1478203839187_wijUzUf.jpg.
 */
hatti.ona.post_process.get_matching_name = (function hatti$ona$post_process$get_matching_name(fname,fnames){
if(typeof fname === 'string'){
try{var or__6409__auto__ = chimera.seq.filter_first.call(null,(function (p1__22763_SHARP_){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,cljs.core.first.call(null,clojure.string.split.call(null,fname,cljs.core.re_pattern.call(null,"\\.")))),p1__22763_SHARP_);
}),fnames);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return fname;
}
}catch (e22765){if((e22765 instanceof SyntaxError)){
var e = e22765;
return fname;
} else {
throw e22765;

}
}} else {
return fname;
}
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__6409__auto__ = attachments;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.call(null,record,hatti.constants._attachments);
}
})();
var fnames = cljs.core.map.call(null,((function (attachments__$1){
return (function (p1__22766_SHARP_){
return chimera.urls.last_url_param.call(null,cljs.core.get.call(null,p1__22766_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap.call(null,fnames,cljs.core.map.call(null,hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.call(null,fname__GT_urlobj,hatti.ona.post_process.get_matching_name.call(null,fname,fnames),fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Coll -> Coll
 */
hatti.ona.post_process.filter_media = (function hatti$ona$post_process$filter_media(flat_form){
return cljs.core.filter.call(null,(function (p1__22767_SHARP_){
var or__6409__auto__ = hatti.ona.forms.video_QMARK_.call(null,p1__22767_SHARP_);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.image_QMARK_.call(null,p1__22767_SHARP_);
}
}),flat_form);
});
/**
 * Inlines media data from within _attachments into each record.
 * Coll Coll -> Coll
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22778 = arguments.length;
var i__7485__auto___22779 = (0);
while(true){
if((i__7485__auto___22779 < len__7484__auto___22778)){
args__7491__auto__.push((arguments[i__7485__auto___22779]));

var G__22780 = (i__7485__auto___22779 + (1));
i__7485__auto___22779 = G__22780;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__22771){
var map__22772 = p__22771;
var map__22772__$1 = ((((!((map__22772 == null)))?((((map__22772.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22772.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22772):map__22772);
var attachments = cljs.core.get.call(null,map__22772__$1,new cljs.core.Keyword(null,"attachments","attachments",-1535547830));
var image_fields = hatti.ona.post_process.filter_media.call(null,flat_form);
var iter__7189__auto__ = ((function (image_fields,map__22772,map__22772__$1,attachments){
return (function hatti$ona$post_process$iter__22774(s__22775){
return (new cljs.core.LazySeq(null,((function (image_fields,map__22772,map__22772__$1,attachments){
return (function (){
var s__22775__$1 = s__22775;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22775__$1);
if(temp__4657__auto__){
var s__22775__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22775__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22775__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22777 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22776 = (0);
while(true){
if((i__22776 < size__7188__auto__)){
var record = cljs.core._nth.call(null,c__7187__auto__,i__22776);
cljs.core.chunk_append.call(null,b__22777,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (i__22776,attach_map,record,c__7187__auto__,size__7188__auto__,b__22777,s__22775__$2,temp__4657__auto__,image_fields,map__22772,map__22772__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__22776,attach_map,record,c__7187__auto__,size__7188__auto__,b__22777,s__22775__$2,temp__4657__auto__,image_fields,map__22772,map__22772__$1,attachments))
,record,image_fields);
})());

var G__22781 = (i__22776 + (1));
i__22776 = G__22781;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22777),hatti$ona$post_process$iter__22774.call(null,cljs.core.chunk_rest.call(null,s__22775__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22777),null);
}
} else {
var record = cljs.core.first.call(null,s__22775__$2);
return cljs.core.cons.call(null,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (attach_map,record,s__22775__$2,temp__4657__auto__,image_fields,map__22772,map__22772__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__22775__$2,temp__4657__auto__,image_fields,map__22772,map__22772__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__22774.call(null,cljs.core.rest.call(null,s__22775__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__22772,map__22772__$1,attachments))
,null,null));
});})(image_fields,map__22772,map__22772__$1,attachments))
;
return iter__7189__auto__.call(null,data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq22768){
var G__22769 = cljs.core.first.call(null,seq22768);
var seq22768__$1 = cljs.core.next.call(null,seq22768);
var G__22770 = cljs.core.first.call(null,seq22768__$1);
var seq22768__$2 = cljs.core.next.call(null,seq22768__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__22769,G__22770,seq22768__$2);
});

/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.call(null,hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.call(null,record,key,hatti.ona.post_process.integrate_attachments.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.call(null,record,key),new cljs.core.Keyword(null,"attachments","attachments",-1535547830),cljs.core.get.call(null,record,hatti.constants._attachments)));
});})(repeat_fields))
;
var iter__7189__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__22786(s__22787){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__22787__$1 = s__22787;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22787__$1);
if(temp__4657__auto__){
var s__22787__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22787__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22787__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22789 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22788 = (0);
while(true){
if((i__22788 < size__7188__auto__)){
var record = cljs.core._nth.call(null,c__7187__auto__,i__22788);
cljs.core.chunk_append.call(null,b__22789,cljs.core.reduce.call(null,integrate,record,repeat_fields));

var G__22790 = (i__22788 + (1));
i__22788 = G__22790;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22789),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__22786.call(null,cljs.core.chunk_rest.call(null,s__22787__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22789),null);
}
} else {
var record = cljs.core.first.call(null,s__22787__$2);
return cljs.core.cons.call(null,cljs.core.reduce.call(null,integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__22786.call(null,cljs.core.rest.call(null,s__22787__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__7189__auto__.call(null,data);
});
/**
 * Inlines data from within _attachments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22798 = arguments.length;
var i__7485__auto___22799 = (0);
while(true){
if((i__7485__auto___22799 < len__7484__auto___22798)){
args__7491__auto__.push((arguments[i__7485__auto___22799]));

var G__22800 = (i__7485__auto___22799 + (1));
i__7485__auto___22799 = G__22800;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__22795){
var map__22796 = p__22795;
var map__22796__$1 = ((((!((map__22796 == null)))?((((map__22796.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22796.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22796):map__22796);
var app_data_keys = cljs.core.get.call(null,map__22796__$1,new cljs.core.Keyword(null,"app-data-keys","app-data-keys",-662378404),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
return chimera.om.state.transact_BANG_.call(null,app_state,app_data_keys,((function (map__22796,map__22796__$1,app_data_keys){
return (function (p1__22791_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats.call(null,flat_form,hatti.ona.post_process.integrate_attachments.call(null,flat_form,p1__22791_SHARP_));
});})(map__22796,map__22796__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq22792){
var G__22793 = cljs.core.first.call(null,seq22792);
var seq22792__$1 = cljs.core.next.call(null,seq22792);
var G__22794 = cljs.core.first.call(null,seq22792__$1);
var seq22792__$2 = cljs.core.next.call(null,seq22792__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22793,G__22794,seq22792__$2);
});

