// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.shared');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('cljs.core.async');
goog.require('sablono.core');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('hatti.utils.om.state');
goog.require('chimera.urls');
hatti.shared.event_chan = cljs.core.async.chan.call(null);
hatti.shared.event_multi_chan = cljs.core.async.mult.call(null,hatti.shared.event_chan);
hatti.shared.event_tap = (function hatti$shared$event_tap(){
return cljs.core.async.tap.call(null,hatti.shared.event_multi_chan,cljs.core.async.chan.call(null));
});
hatti.shared.external_event_chan = cljs.core.async.chan.call(null);
hatti.shared.external_event_multi_chan = cljs.core.async.mult.call(null,hatti.shared.external_event_chan);
hatti.shared.external_event_tap = (function hatti$shared$external_event_tap(){
return cljs.core.async.tap.call(null,hatti.shared.external_event_multi_chan,cljs.core.async.chan.call(null));
});
hatti.shared.default_fields = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),"_submission_time",new cljs.core.Keyword(null,"label","label",1718410804),"Submission Time",new cljs.core.Keyword(null,"name","name",1843675177),"_submission_time",new cljs.core.Keyword(null,"type","type",1174270348),"datetime"], null)], null);
/**
 * An initial, empty, app-state, which can be modified to change dataviews.
 */
hatti.shared.empty_app_state = (function hatti$shared$empty_app_state(){
return cljs.core.atom.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634),new cljs.core.Keyword(null,"api-url","api-url",2037917643),new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745),new cljs.core.Keyword(null,"chart-page","chart-page",14505465),new cljs.core.Keyword(null,"languages","languages",1471910331),new cljs.core.Keyword(null,"map-page","map-page",108547100),new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"data","data",-232669377)],[cljs.core.PersistentVector.EMPTY,"//api.ona.io/api/v1/",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),null], null),new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754),false], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"total-records","total-records",-1940276645),(0),new cljs.core.Keyword(null,"loading?","loading?",1905707049),true], null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"visible-charts","visible-charts",-1864927735),hatti.shared.default_fields,new cljs.core.Keyword(null,"chart-data","chart-data",-1181877206),cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"current","current",-1088038603),null,new cljs.core.Keyword(null,"all","all",892129742),cljs.core.PersistentVector.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),null], null),new cljs.core.Keyword(null,"geofield","geofield",578715548),cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"chart","chart",1173225425),new cljs.core.Keyword(null,"dashboard","dashboard",-631747508),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Keyword(null,"overview","overview",-435037267),new cljs.core.Keyword(null,"photos","photos",11691538),new cljs.core.Keyword(null,"report-view","report-view",-1592707414),new cljs.core.Keyword(null,"saved-charts","saved-charts",2129251691),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.Keyword(null,"user-guide","user-guide",774875009)], null),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"selected","selected",574897764),new cljs.core.Keyword(null,"overview","overview",-435037267),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"basemaps","basemaps",-586181391),new cljs.core.Keyword(null,"form-info","form-info",-1650433345),new cljs.core.Keyword(null,"integrated-apps","integrated-apps",2094952610),new cljs.core.Keyword(null,"media-files","media-files",-1143893877),new cljs.core.Keyword(null,"service-configuration","service-configuration",-820372483),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"xls-reports","xls-reports",-1859694902)], null),new cljs.core.Keyword(null,"active-tab","active-tab",1102432568),new cljs.core.Keyword(null,"form-info","form-info",-1650433345),new cljs.core.Keyword(null,"integrated-apps","integrated-apps",2094952610),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"active-section","active-section",1090779410),new cljs.core.Keyword(null,"apps-list","apps-list",590176593),new cljs.core.Keyword(null,"add?","add?",1263018409),false], null)], null)], null),cljs.core.PersistentVector.EMPTY]));
});
hatti.shared.app_state = hatti.shared.empty_app_state.call(null);
/**
 * Given a function over data, run a transact on data inside app-state.
 */
hatti.shared.transact_app_data_BANG_ = (function hatti$shared$transact_app_data_BANG_(app_state,transact_fn){
return chimera.om.state.transact_BANG_.call(null,app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null),transact_fn);
});
/**
 * Given `data` received from the server, update the app-state.
 * Sorts by submission time, and adds rank to the data, for table + map views.
 */
hatti.shared.update_app_data_BANG_ = (function hatti$shared$update_app_data_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22477 = arguments.length;
var i__7485__auto___22478 = (0);
while(true){
if((i__7485__auto___22478 < len__7484__auto___22477)){
args__7491__auto__.push((arguments[i__7485__auto___22478]));

var G__22479 = (i__7485__auto___22478 + (1));
i__7485__auto___22478 = G__22479;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__22474){
var map__22475 = p__22474;
var map__22475__$1 = ((((!((map__22475 == null)))?((((map__22475.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22475.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22475):map__22475);
var rerank_QMARK_ = cljs.core.get.call(null,map__22475__$1,new cljs.core.Keyword(null,"rerank?","rerank?",-177233089));
var completed_QMARK_ = cljs.core.get.call(null,map__22475__$1,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var sort_field = cljs.core.get.call(null,map__22475__$1,new cljs.core.Keyword(null,"sort-field","sort-field",-941433793));
var current_start_index = cljs.core.get.call(null,map__22475__$1,new cljs.core.Keyword(null,"current-start-index","current-start-index",-285076643),(0));
var add_rank = ((function (map__22475,map__22475__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (i,v){
return cljs.core.assoc.call(null,v,hatti.constants._rank,(current_start_index + (i + (1))));
});})(map__22475,map__22475__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
;
var data__$1 = (cljs.core.truth_((function (){var and__6397__auto__ = rerank_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.seq.call(null,data);
} else {
return and__6397__auto__;
}
})())?cljs.core.vec.call(null,cljs.core.map_indexed.call(null,add_rank,cljs.core.sort_by.call(null,((function (add_rank,map__22475,map__22475__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (p1__22470_SHARP_){
return cljs.core.get.call(null,p1__22470_SHARP_,(function (){var or__6409__auto__ = sort_field;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants._submission_time;
}
})());
});})(add_rank,map__22475,map__22475__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
,data))):cljs.core.vec.call(null,cljs.core.map_indexed.call(null,add_rank,data)));
var total_records = cljs.core.count.call(null,data__$1);
hatti.shared.transact_app_data_BANG_.call(null,app_state,((function (add_rank,data__$1,total_records,map__22475,map__22475__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (_){
return data__$1;
});})(add_rank,data__$1,total_records,map__22475,map__22475__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
);

return chimera.om.state.merge_into_app_state_BANG_.call(null,app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"status","status",-1997798413)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"total-records","total-records",-1940276645),total_records,new cljs.core.Keyword(null,"loading?","loading?",1905707049),cljs.core.not.call(null,completed_QMARK_)], null));
});

hatti.shared.update_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.update_app_data_BANG_.cljs$lang$applyTo = (function (seq22471){
var G__22472 = cljs.core.first.call(null,seq22471);
var seq22471__$1 = cljs.core.next.call(null,seq22471);
var G__22473 = cljs.core.first.call(null,seq22471__$1);
var seq22471__$2 = cljs.core.next.call(null,seq22471__$1);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22472,G__22473,seq22471__$2);
});

/**
 * Add to app data.
 */
hatti.shared.add_to_app_data_BANG_ = (function hatti$shared$add_to_app_data_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22486 = arguments.length;
var i__7485__auto___22487 = (0);
while(true){
if((i__7485__auto___22487 < len__7484__auto___22486)){
args__7491__auto__.push((arguments[i__7485__auto___22487]));

var G__22488 = (i__7485__auto___22487 + (1));
i__7485__auto___22487 = G__22488;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__22483){
var map__22484 = p__22483;
var map__22484__$1 = ((((!((map__22484 == null)))?((((map__22484.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22484.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22484):map__22484);
var completed_QMARK_ = cljs.core.get.call(null,map__22484__$1,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var old_data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,app_state));
hatti.shared.update_app_data_BANG_.call(null,app_state,cljs.core.concat.call(null,old_data,data),new cljs.core.Keyword(null,"rerank?","rerank?",-177233089),completed_QMARK_);

return hatti.utils.om.state.update_app_state_BANG_.call(null,app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"loading?","loading?",1905707049)], null),cljs.core.not.call(null,completed_QMARK_));
});

hatti.shared.add_to_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.add_to_app_data_BANG_.cljs$lang$applyTo = (function (seq22480){
var G__22481 = cljs.core.first.call(null,seq22480);
var seq22480__$1 = cljs.core.next.call(null,seq22480);
var G__22482 = cljs.core.first.call(null,seq22480__$1);
var seq22480__$2 = cljs.core.next.call(null,seq22480__$1);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22481,G__22482,seq22480__$2);
});

/**
 * Merge languages into the app-state if form is multilingual
 */
hatti.shared.maybe_merge_languages_BANG_ = (function hatti$shared$maybe_merge_languages_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22495 = arguments.length;
var i__7485__auto___22496 = (0);
while(true){
if((i__7485__auto___22496 < len__7484__auto___22495)){
args__7491__auto__.push((arguments[i__7485__auto___22496]));

var G__22497 = (i__7485__auto___22496 + (1));
i__7485__auto___22496 = G__22497;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.shared.maybe_merge_languages_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.shared.maybe_merge_languages_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__22491){
var vec__22492 = p__22491;
var state = cljs.core.nth.call(null,vec__22492,(0),null);
if(cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_.call(null,form))){
var langs = hatti.ona.forms.get_languages.call(null,form);
var default_lang = hatti.ona.forms.default_lang.call(null,langs);
var lang_state = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"all","all",892129742),langs,new cljs.core.Keyword(null,"default","default",-1987822328),default_lang,new cljs.core.Keyword(null,"current","current",-1088038603),default_lang], null);
return chimera.om.state.merge_into_app_state_BANG_.call(null,(function (){var or__6409__auto__ = state;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.shared.app_state;
}
})(),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"languages","languages",1471910331)], null),lang_state);
} else {
return null;
}
});

hatti.shared.maybe_merge_languages_BANG_.cljs$lang$maxFixedArity = (1);

hatti.shared.maybe_merge_languages_BANG_.cljs$lang$applyTo = (function (seq22489){
var G__22490 = cljs.core.first.call(null,seq22489);
var seq22489__$1 = cljs.core.next.call(null,seq22489);
return hatti.shared.maybe_merge_languages_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22490,seq22489__$1);
});

hatti.shared.language_cursor = (function hatti$shared$language_cursor(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22503 = arguments.length;
var i__7485__auto___22504 = (0);
while(true){
if((i__7485__auto___22504 < len__7484__auto___22503)){
args__7491__auto__.push((arguments[i__7485__auto___22504]));

var G__22505 = (i__7485__auto___22504 + (1));
i__7485__auto___22504 = G__22505;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.shared.language_cursor.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.shared.language_cursor.cljs$core$IFn$_invoke$arity$variadic = (function (p__22499){
var vec__22500 = p__22499;
var state = cljs.core.nth.call(null,vec__22500,(0),null);
return om.core.ref_cursor.call(null,new cljs.core.Keyword(null,"languages","languages",1471910331).cljs$core$IFn$_invoke$arity$1(om.core.root_cursor.call(null,(function (){var or__6409__auto__ = state;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.shared.app_state;
}
})())));
});

hatti.shared.language_cursor.cljs$lang$maxFixedArity = (0);

hatti.shared.language_cursor.cljs$lang$applyTo = (function (seq22498){
return hatti.shared.language_cursor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq22498));
});

/**
 * A language selector and a following divider.
 */
hatti.shared.language_selector = (function hatti$shared$language_selector(_,owner,p__22507){
var map__22526 = p__22507;
var map__22526__$1 = ((((!((map__22526 == null)))?((((map__22526.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22526.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22526):map__22526);
var custom_app_state = cljs.core.get.call(null,map__22526__$1,new cljs.core.Keyword(null,"app-state","app-state",-1509963278));
if(typeof hatti.shared.t_hatti$shared22528 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.shared.t_hatti$shared22528 = (function (language_selector,_,owner,p__22507,map__22526,custom_app_state,meta22529){
this.language_selector = language_selector;
this._ = _;
this.owner = owner;
this.p__22507 = p__22507;
this.map__22526 = map__22526;
this.custom_app_state = custom_app_state;
this.meta22529 = meta22529;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.shared.t_hatti$shared22528.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__22526,map__22526__$1,custom_app_state){
return (function (_22530,meta22529__$1){
var self__ = this;
var _22530__$1 = this;
return (new hatti.shared.t_hatti$shared22528(self__.language_selector,self__._,self__.owner,self__.p__22507,self__.map__22526,self__.custom_app_state,meta22529__$1));
});})(map__22526,map__22526__$1,custom_app_state))
;

hatti.shared.t_hatti$shared22528.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__22526,map__22526__$1,custom_app_state){
return (function (_22530){
var self__ = this;
var _22530__$1 = this;
return self__.meta22529;
});})(map__22526,map__22526__$1,custom_app_state))
;

hatti.shared.t_hatti$shared22528.prototype.om$core$IRender$ = true;

hatti.shared.t_hatti$shared22528.prototype.om$core$IRender$render$arity$1 = ((function (map__22526,map__22526__$1,custom_app_state){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var map__22531 = om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null,(function (){var or__6409__auto__ = self__.custom_app_state;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.shared.app_state;
}
})()));
var map__22531__$1 = ((((!((map__22531 == null)))?((((map__22531.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22531.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22531):map__22531);
var ls = map__22531__$1;
var current = cljs.core.get.call(null,map__22531__$1,new cljs.core.Keyword(null,"current","current",-1088038603));
var all = cljs.core.get.call(null,map__22531__$1,new cljs.core.Keyword(null,"all","all",892129742));
var get_update_handler = ((function (map__22531,map__22531__$1,ls,current,all,___$2,map__22526,map__22526__$1,custom_app_state){
return (function (language){
return ((function (map__22531,map__22531__$1,ls,current,all,___$2,map__22526,map__22526__$1,custom_app_state){
return (function (event){
om.core.update_BANG_.call(null,ls,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current","current",-1088038603)], null),language);

return event.preventDefault();
});
;})(map__22531,map__22531__$1,ls,current,all,___$2,map__22526,map__22526__$1,custom_app_state))
});})(map__22531,map__22531__$1,ls,current,all,___$2,map__22526,map__22526__$1,custom_app_state))
;
var stringify = ((function (map__22531,map__22531__$1,ls,current,all,get_update_handler,___$2,map__22526,map__22526__$1,custom_app_state){
return (function (p1__22506_SHARP_){
if((p1__22506_SHARP_ instanceof cljs.core.Keyword)){
return cljs.core.name.call(null,p1__22506_SHARP_);
} else {
return [cljs.core.str(p1__22506_SHARP_)].join('');
}
});})(map__22531,map__22531__$1,ls,current,all,get_update_handler,___$2,map__22526,map__22526__$1,custom_app_state))
;
return React.DOM.div(({"className": "language-selector-inner"}),React.DOM.span(({"className": "dropdown drop-hover"}),React.DOM.i(({"style": ({"marginRight": ".2em"}), "className": "fa fa-globe"})),(function (){var attrs22535 = (cljs.core.truth_(hatti.ona.forms.english_QMARK_.call(null,current))?"EN":stringify.call(null,current));
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs22535))?sablono.interpreter.attributes.call(null,attrs22535):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs22535))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs22535)], null))));
})(),React.DOM.i(({"style": ({"marginLeft": ".5em"}), "className": "fa fa-angle-down"})),React.DOM.ul(({"className": "submenu"}),cljs.core.into_array.call(null,(function (){var iter__7189__auto__ = ((function (map__22531,map__22531__$1,ls,current,all,get_update_handler,stringify,___$2,map__22526,map__22526__$1,custom_app_state){
return (function hatti$shared$language_selector_$_iter__22540(s__22541){
return (new cljs.core.LazySeq(null,((function (map__22531,map__22531__$1,ls,current,all,get_update_handler,stringify,___$2,map__22526,map__22526__$1,custom_app_state){
return (function (){
var s__22541__$1 = s__22541;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22541__$1);
if(temp__4657__auto__){
var s__22541__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22541__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22541__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22543 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22542 = (0);
while(true){
if((i__22542 < size__7188__auto__)){
var language = cljs.core._nth.call(null,c__7187__auto__,i__22542);
cljs.core.chunk_append.call(null,b__22543,React.DOM.li(null,React.DOM.a(({"href": "#", "onClick": get_update_handler.call(null,language)}),sablono.interpreter.interpret.call(null,stringify.call(null,language)))));

var G__22544 = (i__22542 + (1));
i__22542 = G__22544;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22543),hatti$shared$language_selector_$_iter__22540.call(null,cljs.core.chunk_rest.call(null,s__22541__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22543),null);
}
} else {
var language = cljs.core.first.call(null,s__22541__$2);
return cljs.core.cons.call(null,React.DOM.li(null,React.DOM.a(({"href": "#", "onClick": get_update_handler.call(null,language)}),sablono.interpreter.interpret.call(null,stringify.call(null,language)))),hatti$shared$language_selector_$_iter__22540.call(null,cljs.core.rest.call(null,s__22541__$2)));
}
} else {
return null;
}
break;
}
});})(map__22531,map__22531__$1,ls,current,all,get_update_handler,stringify,___$2,map__22526,map__22526__$1,custom_app_state))
,null,null));
});})(map__22531,map__22531__$1,ls,current,all,get_update_handler,stringify,___$2,map__22526,map__22526__$1,custom_app_state))
;
return iter__7189__auto__.call(null,all);
})()))),React.DOM.div(({"className": "divider"})));
});})(map__22526,map__22526__$1,custom_app_state))
;

hatti.shared.t_hatti$shared22528.getBasis = ((function (map__22526,map__22526__$1,custom_app_state){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"language-selector","language-selector",-1895427281,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"custom-app-state","custom-app-state",-1099238479,null),new cljs.core.Keyword(null,"app-state","app-state",-1509963278)], null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"A language selector and a following divider."], null)),new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__22507","p__22507",-1931866462,null),new cljs.core.Symbol(null,"map__22526","map__22526",2012819892,null),new cljs.core.Symbol(null,"custom-app-state","custom-app-state",-1099238479,null),new cljs.core.Symbol(null,"meta22529","meta22529",923438108,null)], null);
});})(map__22526,map__22526__$1,custom_app_state))
;

hatti.shared.t_hatti$shared22528.cljs$lang$type = true;

hatti.shared.t_hatti$shared22528.cljs$lang$ctorStr = "hatti.shared/t_hatti$shared22528";

hatti.shared.t_hatti$shared22528.cljs$lang$ctorPrWriter = ((function (map__22526,map__22526__$1,custom_app_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.shared/t_hatti$shared22528");
});})(map__22526,map__22526__$1,custom_app_state))
;

hatti.shared.__GT_t_hatti$shared22528 = ((function (map__22526,map__22526__$1,custom_app_state){
return (function hatti$shared$language_selector_$___GT_t_hatti$shared22528(language_selector__$1,___$1,owner__$1,p__22507__$1,map__22526__$2,custom_app_state__$1,meta22529){
return (new hatti.shared.t_hatti$shared22528(language_selector__$1,___$1,owner__$1,p__22507__$1,map__22526__$2,custom_app_state__$1,meta22529));
});})(map__22526,map__22526__$1,custom_app_state))
;

}

return (new hatti.shared.t_hatti$shared22528(hatti$shared$language_selector,_,owner,p__22507,map__22526__$1,custom_app_state,cljs.core.PersistentArrayMap.EMPTY));
});
