// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__7072__auto__ = (((x == null))?null:x);
var m__7073__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7073__auto__.call(null,x));
} else {
var m__7073__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7073__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return (c2.dom.select.cljs$core$IFn$_invoke$arity$1 ? c2.dom.select.cljs$core$IFn$_invoke$arity$1(selector) : c2.dom.select.call(null,selector));
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render(v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args39854 = [];
var len__7484__auto___39857 = arguments.length;
var i__7485__auto___39858 = (0);
while(true){
if((i__7485__auto___39858 < len__7484__auto___39857)){
args39854.push((arguments[i__7485__auto___39858]));

var G__39859 = (i__7485__auto___39858 + (1));
i__7485__auto___39858 = G__39859;
continue;
} else {
}
break;
}

var G__39856 = args39854.length;
switch (G__39856) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39854.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;

/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args39861 = [];
var len__7484__auto___39864 = arguments.length;
var i__7485__auto___39865 = (0);
while(true){
if((i__7485__auto___39865 < len__7484__auto___39864)){
args39861.push((arguments[i__7485__auto___39865]));

var G__39866 = (i__7485__auto___39865 + (1));
i__7485__auto___39865 = G__39866;
continue;
} else {
}
break;
}

var G__39863 = args39861.length;
switch (G__39863) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39861.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;

/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom(node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom(node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__39870_39872 = c2.dom.__GT_dom(container);
var G__39871_39873 = el__$1;
goog.dom.appendChild(G__39870_39872,G__39871_39873);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__39877_39880 = c2.dom.__GT_dom(container);
var G__39878_39881 = el__$1;
var G__39879_39882 = (0);
goog.dom.insertChildAt(G__39877_39880,G__39878_39881,G__39879_39882);

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
var G__39884 = c2.dom.__GT_dom(el);
return goog.dom.removeNode(G__39884);
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom(new$);
var G__39887_39889 = new$__$1;
var G__39888_39890 = c2.dom.__GT_dom(old);
goog.dom.replaceNode(G__39887_39889,G__39888_39890);

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args39891 = [];
var len__7484__auto___39909 = arguments.length;
var i__7485__auto___39910 = (0);
while(true){
if((i__7485__auto___39910 < len__7484__auto___39909)){
args39891.push((arguments[i__7485__auto___39910]));

var G__39911 = (i__7485__auto___39910 + (1));
i__7485__auto___39910 = G__39911;
continue;
} else {
}
break;
}

var G__39893 = args39891.length;
switch (G__39893) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39891.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
var G__39894 = el__$1;
var G__39895 = cljs.core.name(x);
return goog.style.getComputedStyle(G__39894,G__39895);
} else {
if(cljs.core.map_QMARK_(x)){
var seq__39896_39913 = cljs.core.seq(x);
var chunk__39897_39914 = null;
var count__39898_39915 = (0);
var i__39899_39916 = (0);
while(true){
if((i__39899_39916 < count__39898_39915)){
var vec__39900_39917 = chunk__39897_39914.cljs$core$IIndexed$_nth$arity$2(null,i__39899_39916);
var k_39918 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39900_39917,(0),null);
var v_39919 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39900_39917,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_39918,v_39919);

var G__39920 = seq__39896_39913;
var G__39921 = chunk__39897_39914;
var G__39922 = count__39898_39915;
var G__39923 = (i__39899_39916 + (1));
seq__39896_39913 = G__39920;
chunk__39897_39914 = G__39921;
count__39898_39915 = G__39922;
i__39899_39916 = G__39923;
continue;
} else {
var temp__4657__auto___39924 = cljs.core.seq(seq__39896_39913);
if(temp__4657__auto___39924){
var seq__39896_39925__$1 = temp__4657__auto___39924;
if(cljs.core.chunked_seq_QMARK_(seq__39896_39925__$1)){
var c__7220__auto___39926 = cljs.core.chunk_first(seq__39896_39925__$1);
var G__39927 = cljs.core.chunk_rest(seq__39896_39925__$1);
var G__39928 = c__7220__auto___39926;
var G__39929 = cljs.core.count(c__7220__auto___39926);
var G__39930 = (0);
seq__39896_39913 = G__39927;
chunk__39897_39914 = G__39928;
count__39898_39915 = G__39929;
i__39899_39916 = G__39930;
continue;
} else {
var vec__39903_39931 = cljs.core.first(seq__39896_39925__$1);
var k_39932 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39903_39931,(0),null);
var v_39933 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39903_39931,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_39932,v_39933);

var G__39934 = cljs.core.next(seq__39896_39925__$1);
var G__39935 = null;
var G__39936 = (0);
var G__39937 = (0);
seq__39896_39913 = G__39934;
chunk__39897_39914 = G__39935;
count__39898_39915 = G__39936;
i__39899_39916 = G__39937;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var G__39906_39938 = c2.dom.__GT_dom(el);
var G__39907_39939 = cljs.core.name(k);
var G__39908_39940 = ((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$bottom,null,cljs.core.cst$kw$top,null,cljs.core.cst$kw$width,null,cljs.core.cst$kw$right,null,cljs.core.cst$kw$height,null,cljs.core.cst$kw$left,null], null), null).call(null,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null));
goog.style.setStyle(G__39906_39938,G__39907_39939,G__39908_39940);

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args39941 = [];
var len__7484__auto___39960 = arguments.length;
var i__7485__auto___39961 = (0);
while(true){
if((i__7485__auto___39961 < len__7484__auto___39960)){
args39941.push((arguments[i__7485__auto___39961]));

var G__39962 = (i__7485__auto___39961 + (1));
i__7485__auto___39961 = G__39962;
continue;
} else {
}
break;
}

var G__39943 = args39941.length;
switch (G__39943) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39941.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom(el).attributes;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (attrs){
return (function c2$dom$iter__39944(s__39945){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__39945__$1 = s__39945;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39945__$1);
if(temp__4657__auto__){
var s__39945__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39945__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39945__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39947 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39946 = (0);
while(true){
if((i__39946 < size__7188__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39946);
cljs.core.chunk_append(b__39947,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null));

var G__39964 = (i__39946 + (1));
i__39946 = G__39964;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39947),c2$dom$iter__39944(cljs.core.chunk_rest(s__39945__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39947),null);
}
} else {
var i = cljs.core.first(s__39945__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__39944(cljs.core.rest(s__39945__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__7189__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name(x));
} else {
if(cljs.core.map_QMARK_(x)){
var seq__39950_39965 = cljs.core.seq(x);
var chunk__39951_39966 = null;
var count__39952_39967 = (0);
var i__39953_39968 = (0);
while(true){
if((i__39953_39968 < count__39952_39967)){
var vec__39954_39969 = chunk__39951_39966.cljs$core$IIndexed$_nth$arity$2(null,i__39953_39968);
var k_39970 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39954_39969,(0),null);
var v_39971 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39954_39969,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_39970,v_39971);

var G__39972 = seq__39950_39965;
var G__39973 = chunk__39951_39966;
var G__39974 = count__39952_39967;
var G__39975 = (i__39953_39968 + (1));
seq__39950_39965 = G__39972;
chunk__39951_39966 = G__39973;
count__39952_39967 = G__39974;
i__39953_39968 = G__39975;
continue;
} else {
var temp__4657__auto___39976 = cljs.core.seq(seq__39950_39965);
if(temp__4657__auto___39976){
var seq__39950_39977__$1 = temp__4657__auto___39976;
if(cljs.core.chunked_seq_QMARK_(seq__39950_39977__$1)){
var c__7220__auto___39978 = cljs.core.chunk_first(seq__39950_39977__$1);
var G__39979 = cljs.core.chunk_rest(seq__39950_39977__$1);
var G__39980 = c__7220__auto___39978;
var G__39981 = cljs.core.count(c__7220__auto___39978);
var G__39982 = (0);
seq__39950_39965 = G__39979;
chunk__39951_39966 = G__39980;
count__39952_39967 = G__39981;
i__39953_39968 = G__39982;
continue;
} else {
var vec__39957_39983 = cljs.core.first(seq__39950_39977__$1);
var k_39984 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39957_39983,(0),null);
var v_39985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39957_39983,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_39984,v_39985);

var G__39986 = cljs.core.next(seq__39950_39977__$1);
var G__39987 = null;
var G__39988 = (0);
var G__39989 = (0);
seq__39950_39965 = G__39986;
chunk__39951_39966 = G__39987;
count__39952_39967 = G__39988;
i__39953_39968 = G__39989;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom(el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name(k));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$style,k)){
c2.dom.style.cljs$core$IFn$_invoke$arity$2(el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name(k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args39990 = [];
var len__7484__auto___39994 = arguments.length;
var i__7485__auto___39995 = (0);
while(true){
if((i__7485__auto___39995 < len__7484__auto___39994)){
args39990.push((arguments[i__7485__auto___39995]));

var G__39996 = (i__7485__auto___39995 + (1));
i__7485__auto___39995 = G__39996;
continue;
} else {
}
break;
}

var G__39992 = args39990.length;
switch (G__39992) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39990.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__39993 = c2.dom.__GT_dom(el);
return goog.dom.getTextContent(G__39993);
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;

/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args39998 = [];
var len__7484__auto___40002 = arguments.length;
var i__7485__auto___40003 = (0);
while(true){
if((i__7485__auto___40003 < len__7484__auto___40002)){
args39998.push((arguments[i__7485__auto___40003]));

var G__40004 = (i__7485__auto___40003 + (1));
i__7485__auto___40003 = G__40004;
continue;
} else {
}
break;
}

var G__40000 = args39998.length;
switch (G__40000) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39998.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__40001 = c2.dom.__GT_dom(el);
return goog.dom.forms.getValue(G__40001);
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;

/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
var G__40009_40012 = c2.dom.__GT_dom(el);
var G__40010_40013 = cljs.core.name(class$);
var G__40011_40014 = classed_QMARK_;
goog.dom.classes.enable(G__40009_40012,G__40010_40013,G__40011_40014);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6409__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return ((function (or__6409__auto____$1,or__6409__auto__){
return (function (p1__40015_SHARP_){
var G__40016 = ((function (or__6409__auto____$1,or__6409__auto__){
return (function (){
return (p1__40015_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p1__40015_SHARP_.cljs$core$IFn$_invoke$arity$0() : p1__40015_SHARP_.call(null));
});})(or__6409__auto____$1,or__6409__auto__))
;
var G__40017 = (10);
return setTimeout(G__40016,G__40017);
});
;})(or__6409__auto____$1,or__6409__auto__))
}
}
})();
