// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.viewby');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('hatti.map.utils');
goog.require('chimera.seq');
goog.require('hatti.utils.style');
goog.require('hatti.charting');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('clojure.string');
hatti.map.viewby.marker_styler = (function hatti$map$viewby$marker_styler(id_color,id_selected_QMARK_){
return (function (marker){
var id = hatti.map.utils.get_id(marker);
var geotype = hatti.map.utils.marker__GT_geotype(marker);
var color_key = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$line,geotype))?cljs.core.cst$kw$color:cljs.core.cst$kw$fillColor);
return cljs.core.PersistentArrayMap.fromArray([color_key,(cljs.core.truth_((id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(id) : id_selected_QMARK_.call(null,id)))?(id_color.cljs$core$IFn$_invoke$arity$1 ? id_color.cljs$core$IFn$_invoke$arity$1(id) : id_color.call(null,id)):hatti.utils.style.grey)], true, false);
});
});
hatti.map.viewby.move_nil_to_end = (function hatti$map$viewby$move_nil_to_end(s){
var no_nil = cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,s));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s,no_nil)){
return s;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(no_nil,null);
}
});
hatti.map.viewby.all_but_nil_selected = (function hatti$map$viewby$all_but_nil_selected(answers){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(true)),new cljs.core.PersistentArrayMap(null, 1, [null,false], null)], 0));
});
/**
 * Preproccesses answers depending on the field. For multi-selects, return type
 * is a list of list of strings. For other types, a list of strings.
 */
hatti.map.viewby.preprocess_answers = (function hatti$map$viewby$preprocess_answers(field,raw_answers){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return hatti.charting.evenly_spaced_bins(raw_answers,(5),"int");
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return hatti.charting.evenly_spaced_bins(raw_answers,(5),(cljs.core.truth_(cljs.core.re_find(/^..:..$/,cljs.core.first(raw_answers)))?"time":"date"));
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34825_SHARP_){
if(cljs.core.truth_(p1__34825_SHARP_)){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__34825_SHARP_,/ /);
} else {
return null;
}
}),raw_answers);
} else {
return null;
}
}
}
}
}
}
});
hatti.map.viewby.has_geolocation_QMARK_ = (function hatti$map$viewby$has_geolocation_QMARK_(p__34826){
var map__34832 = p__34826;
var map__34832__$1 = ((((!((map__34832 == null)))?((((map__34832.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34832.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34832):map__34832);
var vec__34833 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34832__$1,"_geolocation");
var lattitude = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34833,(0),null);
var longitude = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34833,(1),null);
var and__6397__auto__ = lattitude;
if(cljs.core.truth_(and__6397__auto__)){
return lattitude;
} else {
return and__6397__auto__;
}
});
/**
 * Produces a set of data structures / functions for view-by.
 * answers are a list of answers, sorted by count;
 * id->answers is a mapping from id to either one or many answers
 * answer->count, answer->selected?, answer->color are maps from answer;
 * used for the legend rendering. An 'answer' is mapped from a data element,
 * eg. a bin for numbers/dates, an option for multiple/single selects.
 */
hatti.map.viewby.viewby_info = (function hatti$map$viewby$viewby_info(p__34840,data){
var map__34843 = p__34840;
var map__34843__$1 = ((((!((map__34843 == null)))?((((map__34843.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34843.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34843):map__34843);
var field = map__34843__$1;
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34843__$1,cljs.core.cst$kw$full_DASH_name);
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__34843,map__34843__$1,field,full_name){
return (function (p1__34837_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__34837_SHARP_,hatti.constants._id);
});})(map__34843,map__34843__$1,field,full_name))
,data);
var raw_answers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ids,map__34843,map__34843__$1,field,full_name){
return (function (p1__34838_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__34838_SHARP_,full_name);
});})(ids,map__34843,map__34843__$1,field,full_name))
,data);
var submissions_with_geolocation = cljs.core.filterv(hatti.map.viewby.has_geolocation_QMARK_,data);
var raw_answers_with_geolocation = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ids,raw_answers,submissions_with_geolocation,map__34843,map__34843__$1,field,full_name){
return (function (p1__34839_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__34839_SHARP_,full_name);
});})(ids,raw_answers,submissions_with_geolocation,map__34843,map__34843__$1,field,full_name))
,submissions_with_geolocation);
var preprocessed_answers = hatti.map.viewby.preprocess_answers(field,raw_answers);
var answer__GT_count = cljs.core.frequencies(cljs.core.flatten(preprocessed_answers));
var answer__GT_count_with_geolocations = cljs.core.frequencies(cljs.core.flatten(hatti.map.viewby.preprocess_answers(field,raw_answers_with_geolocation)));
var sorted_answers = (cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.categorical_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = hatti.ona.forms.text_QMARK_(field);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return hatti.ona.forms.calculate_QMARK_(field);
}
}
})())?cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.second,cljs.core._GT_,answer__GT_count)):(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.time_based_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.numeric_QMARK_(field);
}
})())?cljs.core.cst$kw$bins.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(preprocessed_answers)):null));
var sorted_answers_with_nil_at_end = hatti.map.viewby.move_nil_to_end(sorted_answers);
var answer__GT_color_map = hatti.utils.style.answer__GT_color(field,sorted_answers);
var defaults = new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$id_DASH__GT_answers,cljs.core.zipmap(ids,preprocessed_answers),cljs.core.cst$kw$answer_DASH__GT_count,answer__GT_count,cljs.core.cst$kw$answer_DASH__GT_count_DASH_with_DASH_geolocations,answer__GT_count_with_geolocations,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_,hatti.map.viewby.all_but_nil_selected(sorted_answers),cljs.core.cst$kw$answer_DASH__GT_color,answer__GT_color_map,cljs.core.cst$kw$visible_DASH_answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$field,field], null);
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([defaults,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id_DASH_color,((function (ids,raw_answers,submissions_with_geolocation,raw_answers_with_geolocation,preprocessed_answers,answer__GT_count,answer__GT_count_with_geolocations,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__34843,map__34843__$1,field,full_name){
return (function (){
return cljs.core.first(cljs.core.vals(answer__GT_color_map));
});})(ids,raw_answers,submissions_with_geolocation,raw_answers_with_geolocation,preprocessed_answers,answer__GT_count,answer__GT_count_with_geolocations,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__34843,map__34843__$1,field,full_name))
], null)], 0));
} else {
return defaults;

}
});
/**
 * Produces a set of data structures / functions for view-by.
 * answers are a list of answers, sorted by count;
 * id->answers is a mapping from id to either one or many answers
 * answer->count, answer->selected?, answer->color are maps from answer;
 * used for the legend rendering. An 'answer' is mapped from a data element,
 * eg. a bin for numbers/dates, an option for multiple/single selects.
 */
hatti.map.viewby.viewby_data = (function hatti$map$viewby$viewby_data(p__34847,data){
var map__34850 = p__34847;
var map__34850__$1 = ((((!((map__34850 == null)))?((((map__34850.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34850.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34850):map__34850);
var field = map__34850__$1;
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34850__$1,cljs.core.cst$kw$full_DASH_name);
if(cljs.core.seq_QMARK_(cljs.core.seq(data))){
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__34850,map__34850__$1,field,full_name){
return (function (p1__34845_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__34845_SHARP_,hatti.constants._id);
});})(map__34850,map__34850__$1,field,full_name))
,data);
var raw_answers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ids,map__34850,map__34850__$1,field,full_name){
return (function (p1__34846_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__34846_SHARP_,full_name);
});})(ids,map__34850,map__34850__$1,field,full_name))
,data);
var preprocessed_answers = hatti.map.viewby.preprocess_answers(field,raw_answers);
var answer__GT_count = cljs.core.frequencies(cljs.core.flatten(preprocessed_answers));
var sorted_answers = (cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.categorical_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = hatti.ona.forms.text_QMARK_(field);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return hatti.ona.forms.calculate_QMARK_(field);
}
}
})())?cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.second,cljs.core._GT_,answer__GT_count)):(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.time_based_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.numeric_QMARK_(field);
}
})())?cljs.core.cst$kw$bins.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(preprocessed_answers)):null));
var sorted_answers_with_nil_at_end = hatti.map.viewby.move_nil_to_end(sorted_answers);
var answer__GT_color_map = hatti.utils.style.answer__GT_color(field,sorted_answers);
var defaults = new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$ids,ids,cljs.core.cst$kw$answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$id_DASH__GT_answers,cljs.core.zipmap(ids,preprocessed_answers),cljs.core.cst$kw$answer_DASH__GT_count,answer__GT_count,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_,hatti.map.viewby.all_but_nil_selected(sorted_answers),cljs.core.cst$kw$answer_DASH__GT_color,answer__GT_color_map,cljs.core.cst$kw$visible_DASH_answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$field,field], null);
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([defaults,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id_DASH_color,((function (ids,raw_answers,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__34850,map__34850__$1,field,full_name){
return (function (){
return cljs.core.first(cljs.core.vals(answer__GT_color_map));
});})(ids,raw_answers,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__34850,map__34850__$1,field,full_name))
], null)], 0));
} else {
return defaults;

}
} else {
return null;
}
});
/**
 * Generates id-color and id-selected? functions based on viewby-info.
 */
hatti.map.viewby.id_color_selected = (function hatti$map$viewby$id_color_selected(p__34854){
var map__34860 = p__34854;
var map__34860__$1 = ((((!((map__34860 == null)))?((((map__34860.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34860.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34860):map__34860);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34860__$1,cljs.core.cst$kw$field);
var id__GT_answers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34860__$1,cljs.core.cst$kw$id_DASH__GT_answers);
var answer__GT_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34860__$1,cljs.core.cst$kw$answer_DASH__GT_color);
var answer__GT_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34860__$1,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_);
var G__34862 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(field);
switch (G__34862) {
case "select all that apply":
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id_DASH_color,((function (G__34862,map__34860,map__34860__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (){
return cljs.core.first(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#f30"], null));
});})(G__34862,map__34860,map__34860__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,cljs.core.cst$kw$id_DASH_selected_QMARK_,((function (G__34862,map__34860,map__34860__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (id){
var answers = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(id) : id__GT_answers.call(null,id));
if((answers == null)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(answer__GT_selected_QMARK_,answers);
} else {
return cljs.core.some(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2(answer__GT_selected_QMARK_,answers));
}
});})(G__34862,map__34860,map__34860__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

break;
default:
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id_DASH_color,((function (G__34862,map__34860,map__34860__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__34852_SHARP_){
var G__34863 = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(p1__34852_SHARP_) : id__GT_answers.call(null,p1__34852_SHARP_));
return (answer__GT_color.cljs$core$IFn$_invoke$arity$1 ? answer__GT_color.cljs$core$IFn$_invoke$arity$1(G__34863) : answer__GT_color.call(null,G__34863));
});})(G__34862,map__34860,map__34860__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,cljs.core.cst$kw$id_DASH_selected_QMARK_,((function (G__34862,map__34860,map__34860__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__34853_SHARP_){
var G__34864 = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(p1__34853_SHARP_) : id__GT_answers.call(null,p1__34853_SHARP_));
return (answer__GT_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? answer__GT_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__34864) : answer__GT_selected_QMARK_.call(null,G__34864));
});})(G__34862,map__34860,map__34860__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

}
});
hatti.map.viewby.view_by_BANG_ = (function hatti$map$viewby$view_by_BANG_(view_by_info,markers){
var map__34872 = hatti.map.viewby.id_color_selected(view_by_info);
var map__34872__$1 = ((((!((map__34872 == null)))?((((map__34872.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34872.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34872):map__34872);
var id_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34872__$1,cljs.core.cst$kw$id_DASH_selected_QMARK_);
var id_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34872__$1,cljs.core.cst$kw$id_DASH_color);
var m__GT_s = hatti.map.viewby.marker_styler(id_color,id_selected_QMARK_);
var seq__34874 = cljs.core.seq(markers);
var chunk__34875 = null;
var count__34876 = (0);
var i__34877 = (0);
while(true){
if((i__34877 < count__34876)){
var marker = chunk__34875.cljs$core$IIndexed$_nth$arity$2(null,i__34877);
hatti.map.utils.re_style_marker(m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected(id_selected_QMARK_,marker);

var G__34878 = seq__34874;
var G__34879 = chunk__34875;
var G__34880 = count__34876;
var G__34881 = (i__34877 + (1));
seq__34874 = G__34878;
chunk__34875 = G__34879;
count__34876 = G__34880;
i__34877 = G__34881;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__34874);
if(temp__4657__auto__){
var seq__34874__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34874__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__34874__$1);
var G__34882 = cljs.core.chunk_rest(seq__34874__$1);
var G__34883 = c__7220__auto__;
var G__34884 = cljs.core.count(c__7220__auto__);
var G__34885 = (0);
seq__34874 = G__34882;
chunk__34875 = G__34883;
count__34876 = G__34884;
i__34877 = G__34885;
continue;
} else {
var marker = cljs.core.first(seq__34874__$1);
hatti.map.utils.re_style_marker(m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected(id_selected_QMARK_,marker);

var G__34886 = cljs.core.next(seq__34874__$1);
var G__34887 = null;
var G__34888 = (0);
var G__34889 = (0);
seq__34874 = G__34886;
chunk__34875 = G__34887;
count__34876 = G__34888;
i__34877 = G__34889;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.viewby.apply_view_by_BANG_ = (function hatti$map$viewby$apply_view_by_BANG_(p__34891,owner){
var map__34896 = p__34891;
var map__34896__$1 = ((((!((map__34896 == null)))?((((map__34896.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34896.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34896):map__34896);
var view_by_info = map__34896__$1;
var id__GT_answers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34896__$1,cljs.core.cst$kw$id_DASH__GT_answers);
var map__34898 = hatti.map.viewby.id_color_selected(view_by_info);
var map__34898__$1 = ((((!((map__34898 == null)))?((((map__34898.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34898.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34898):map__34898);
var id_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34898__$1,cljs.core.cst$kw$id_DASH_selected_QMARK_);
var id_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34898__$1,cljs.core.cst$kw$id_DASH_color);
var ids = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.keys(id__GT_answers));
var stops = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (map__34898,map__34898__$1,id_selected_QMARK_,id_color,ids,map__34896,map__34896__$1,view_by_info,id__GT_answers){
return (function (p1__34890_SHARP_){
if(cljs.core.truth_((id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(p1__34890_SHARP_) : id_selected_QMARK_.call(null,p1__34890_SHARP_)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__34890_SHARP_,(id_color.cljs$core$IFn$_invoke$arity$1 ? id_color.cljs$core$IFn$_invoke$arity$1(p1__34890_SHARP_) : id_color.call(null,p1__34890_SHARP_))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__34890_SHARP_,hatti.utils.style.grey], null);
}
});})(map__34898,map__34898__$1,id_selected_QMARK_,id_color,ids,map__34896,map__34896__$1,view_by_info,id__GT_answers))
,ids);
var id_string = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$id_string], null));
var style = om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$style], null));
if(cljs.core.seq_QMARK_(cljs.core.seq(stops))){
hatti.map.utils.set_mapboxgl_paint_property(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$mapboxgl_DASH_map),id_string,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$normal,cljs.core.array_seq([cljs.core.cst$kw$stops,stops], 0)));

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$stops,stops);
} else {
return null;
}
});
/**
 * Given a list of answers + query, returns map from answers to true/false.
 * True if query is in the answer, false if not.
 */
hatti.map.viewby.filter_answer_data_structures = (function hatti$map$viewby$filter_answer_data_structures(answers,query,field,language){
var query_present_QMARK_ = (function (ans){
if(cljs.core.truth_(ans)){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,ans,cljs.core.array_seq([cljs.core.cst$kw$language,language], 0)));
} else {
return null;
}
});
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$visible_DASH_answers,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(query_present_QMARK_,answers),cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_,cljs.core.zipmap(answers,cljs.core.map.cljs$core$IFn$_invoke$arity$2(query_present_QMARK_,answers))], null);
});
/**
 * This function appropriately toggles answer->selected? when answer is clicked
 * answer->selected? is a map from answers to true/false. Special rules:
 * First click = select the answer. If nothing clicked, make everything
 * clicked.
 */
hatti.map.viewby.toggle_answer_selected = (function hatti$map$viewby$toggle_answer_selected(answer__GT_selected_QMARK_,visible_answers,answer){
var all_answers = cljs.core.vals(answer__GT_selected_QMARK_);
var all_visible_selected_QMARK_ = ((function (all_answers){
return (function (a__GT_s,visible){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.set(visible),cljs.core.set(cljs.core.keys(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.second,a__GT_s))));
});})(all_answers))
;
if((answer == null)){
return answer__GT_selected_QMARK_;
} else {
if(cljs.core.truth_(all_visible_selected_QMARK_(answer__GT_selected_QMARK_,visible_answers))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(all_answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(false)),cljs.core.PersistentArrayMap.fromArray([answer,true], true, false)], 0));
} else {
var toggled = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(answer__GT_selected_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer], null),cljs.core.not);
if(cljs.core.every_QMARK_(cljs.core.false_QMARK_,cljs.core.vals(toggled))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(all_answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(false)),hatti.map.viewby.all_but_nil_selected(visible_answers)], 0));
} else {
return toggled;
}
}
}
});
/**
 * Returns selected ids from view-by data
 */
hatti.map.viewby.get_selected_ids = (function hatti$map$viewby$get_selected_ids(view_by){
var map__34911 = view_by;
var map__34911__$1 = ((((!((map__34911 == null)))?((((map__34911.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34911.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34911):map__34911);
var answer__GT_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34911__$1,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_);
var id__GT_answers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34911__$1,cljs.core.cst$kw$id_DASH__GT_answers);
var answer__GT_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34911__$1,cljs.core.cst$kw$answer_DASH__GT_color);
var into_map = ((function (map__34911,map__34911__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color){
return (function (p1__34900_SHARP_){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,p1__34900_SHARP_);
});})(map__34911,map__34911__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color))
;
var selected_answers = cljs.core.keys(into_map(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__34911,map__34911__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map){
return (function (p__34913){
var vec__34914 = p__34913;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34914,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34914,(1),null);
return v;
});})(map__34911,map__34911__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map))
,answer__GT_selected_QMARK_)));
var selected_ids = cljs.core.keys(into_map(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__34911,map__34911__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map,selected_answers){
return (function (p__34917){
var vec__34918 = p__34917;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34918,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34918,(1),null);
return chimera.seq.in_QMARK_(selected_answers,v);
});})(map__34911,map__34911__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map,selected_answers))
,id__GT_answers)));
var color = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(selected_answers)))?cljs.core.get.cljs$core$IFn$_invoke$arity$2(answer__GT_color,cljs.core.first(selected_answers)):null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$selected_DASH_ids,selected_ids,cljs.core.cst$kw$cell_DASH_color,color], null);
});
