// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__37649__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__37646 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var seq__37647 = cljs.core.seq(vec__37646);
var first__37648 = cljs.core.first(seq__37647);
var seq__37647__$1 = cljs.core.next(seq__37647);
var tag = first__37648;
var body = seq__37647__$1;
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.first(body),cljs.core.first(args)], 0)),cljs.core.rest(body));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.first(args),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__37649 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__37650__i = 0, G__37650__a = new Array(arguments.length -  0);
while (G__37650__i < G__37650__a.length) {G__37650__a[G__37650__i] = arguments[G__37650__i + 0]; ++G__37650__i;}
  args = new cljs.core.IndexedSeq(G__37650__a,0);
} 
return G__37649__delegate.call(this,args);};
G__37649.cljs$lang$maxFixedArity = 0;
G__37649.cljs$lang$applyTo = (function (arglist__37651){
var args = cljs.core.seq(arglist__37651);
return G__37649__delegate(args);
});
G__37649.cljs$core$IFn$_invoke$arity$variadic = G__37649__delegate;
return G__37649;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__37658(s__37659){
return (new cljs.core.LazySeq(null,(function (){
var s__37659__$1 = s__37659;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37659__$1);
if(temp__4657__auto__){
var s__37659__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37659__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37659__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37661 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37660 = (0);
while(true){
if((i__37660 < size__7188__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37660);
cljs.core.chunk_append(b__37661,cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)));

var G__37664 = (i__37660 + (1));
i__37660 = G__37664;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37661),sablono$core$update_arglists_$_iter__37658(cljs.core.chunk_rest(s__37659__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37661),null);
}
} else {
var args = cljs.core.first(s__37659__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)),sablono$core$update_arglists_$_iter__37658(cljs.core.rest(s__37659__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37672 = arguments.length;
var i__7485__auto___37673 = (0);
while(true){
if((i__7485__auto___37673 < len__7484__auto___37672)){
args__7491__auto__.push((arguments[i__7485__auto___37673]));

var G__37674 = (i__7485__auto___37673 + (1));
i__7485__auto___37673 = G__37674;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__37666(s__37667){
return (new cljs.core.LazySeq(null,(function (){
var s__37667__$1 = s__37667;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37667__$1);
if(temp__4657__auto__){
var s__37667__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37667__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37667__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37669 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37668 = (0);
while(true){
if((i__37668 < size__7188__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37668);
cljs.core.chunk_append(b__37669,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null));

var G__37675 = (i__37668 + (1));
i__37668 = G__37675;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37669),sablono$core$iter__37666(cljs.core.chunk_rest(s__37667__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37669),null);
}
} else {
var style = cljs.core.first(s__37667__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null),sablono$core$iter__37666(cljs.core.rest(s__37667__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq37665){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37665));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__37680 = goog.dom.getDocument().body;
var G__37681 = (function (){var G__37682 = "script";
var G__37683 = ({"src": src});
return goog.dom.createDom(G__37682,G__37683);
})();
return goog.dom.appendChild(G__37680,G__37681);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to37684 = (function sablono$core$link_to37684(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37687 = arguments.length;
var i__7485__auto___37688 = (0);
while(true){
if((i__7485__auto___37688 < len__7484__auto___37687)){
args__7491__auto__.push((arguments[i__7485__auto___37688]));

var G__37689 = (i__7485__auto___37688 + (1));
i__7485__auto___37688 = G__37689;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to37684.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to37684.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([url], 0))], null),content], null);
});

sablono.core.link_to37684.cljs$lang$maxFixedArity = (1);

sablono.core.link_to37684.cljs$lang$applyTo = (function (seq37685){
var G__37686 = cljs.core.first(seq37685);
var seq37685__$1 = cljs.core.next(seq37685);
return sablono.core.link_to37684.cljs$core$IFn$_invoke$arity$variadic(G__37686,seq37685__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to37684);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to37690 = (function sablono$core$mail_to37690(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37697 = arguments.length;
var i__7485__auto___37698 = (0);
while(true){
if((i__7485__auto___37698 < len__7484__auto___37697)){
args__7491__auto__.push((arguments[i__7485__auto___37698]));

var G__37699 = (i__7485__auto___37698 + (1));
i__7485__auto___37698 = G__37699;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to37690.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to37690.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__37693){
var vec__37694 = p__37693;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37694,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to37690.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to37690.cljs$lang$applyTo = (function (seq37691){
var G__37692 = cljs.core.first(seq37691);
var seq37691__$1 = cljs.core.next(seq37691);
return sablono.core.mail_to37690.cljs$core$IFn$_invoke$arity$variadic(G__37692,seq37691__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to37690);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list37700 = (function sablono$core$unordered_list37700(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,(function (){var iter__7189__auto__ = (function sablono$core$unordered_list37700_$_iter__37707(s__37708){
return (new cljs.core.LazySeq(null,(function (){
var s__37708__$1 = s__37708;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37708__$1);
if(temp__4657__auto__){
var s__37708__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37708__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37708__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37710 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37709 = (0);
while(true){
if((i__37709 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37709);
cljs.core.chunk_append(b__37710,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__37713 = (i__37709 + (1));
i__37709 = G__37713;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37710),sablono$core$unordered_list37700_$_iter__37707(cljs.core.chunk_rest(s__37708__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37710),null);
}
} else {
var x = cljs.core.first(s__37708__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$unordered_list37700_$_iter__37707(cljs.core.rest(s__37708__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list37700);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list37714 = (function sablono$core$ordered_list37714(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol,(function (){var iter__7189__auto__ = (function sablono$core$ordered_list37714_$_iter__37721(s__37722){
return (new cljs.core.LazySeq(null,(function (){
var s__37722__$1 = s__37722;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37722__$1);
if(temp__4657__auto__){
var s__37722__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37722__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37722__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37724 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37723 = (0);
while(true){
if((i__37723 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37723);
cljs.core.chunk_append(b__37724,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__37727 = (i__37723 + (1));
i__37723 = G__37727;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37724),sablono$core$ordered_list37714_$_iter__37721(cljs.core.chunk_rest(s__37722__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37724),null);
}
} else {
var x = cljs.core.first(s__37722__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$ordered_list37714_$_iter__37721(cljs.core.rest(s__37722__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list37714);
/**
 * Create an image element.
 */
sablono.core.image37728 = (function sablono$core$image37728(var_args){
var args37729 = [];
var len__7484__auto___37732 = arguments.length;
var i__7485__auto___37733 = (0);
while(true){
if((i__7485__auto___37733 < len__7484__auto___37732)){
args37729.push((arguments[i__7485__auto___37733]));

var G__37734 = (i__7485__auto___37733 + (1));
i__7485__auto___37733 = G__37734;
continue;
} else {
}
break;
}

var G__37731 = args37729.length;
switch (G__37731) {
case 1:
return sablono.core.image37728.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image37728.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37729.length)].join('')));

}
});

sablono.core.image37728.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0))], null)], null);
});

sablono.core.image37728.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0)),cljs.core.cst$kw$alt,alt], null)], null);
});

sablono.core.image37728.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs(sablono.core.image37728);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__37736_SHARP_,p2__37737_SHARP_){
return [cljs.core.str(p1__37736_SHARP_),cljs.core.str("["),cljs.core.str(p2__37737_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__37738_SHARP_,p2__37739_SHARP_){
return [cljs.core.str(p1__37738_SHARP_),cljs.core.str("-"),cljs.core.str(p2__37739_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field37740 = (function sablono$core$color_field37740(var_args){
var args37741 = [];
var len__7484__auto___37808 = arguments.length;
var i__7485__auto___37809 = (0);
while(true){
if((i__7485__auto___37809 < len__7484__auto___37808)){
args37741.push((arguments[i__7485__auto___37809]));

var G__37810 = (i__7485__auto___37809 + (1));
i__7485__auto___37809 = G__37810;
continue;
} else {
}
break;
}

var G__37743 = args37741.length;
switch (G__37743) {
case 1:
return sablono.core.color_field37740.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field37740.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37741.length)].join('')));

}
});

sablono.core.color_field37740.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.color_field37740.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.color_field37740.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$color)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.color_field37740.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field37740);

/**
 * Creates a date input field.
 */
sablono.core.date_field37744 = (function sablono$core$date_field37744(var_args){
var args37745 = [];
var len__7484__auto___37812 = arguments.length;
var i__7485__auto___37813 = (0);
while(true){
if((i__7485__auto___37813 < len__7484__auto___37812)){
args37745.push((arguments[i__7485__auto___37813]));

var G__37814 = (i__7485__auto___37813 + (1));
i__7485__auto___37813 = G__37814;
continue;
} else {
}
break;
}

var G__37747 = args37745.length;
switch (G__37747) {
case 1:
return sablono.core.date_field37744.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field37744.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37745.length)].join('')));

}
});

sablono.core.date_field37744.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.date_field37744.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.date_field37744.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$date)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.date_field37744.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field37744);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field37748 = (function sablono$core$datetime_field37748(var_args){
var args37749 = [];
var len__7484__auto___37816 = arguments.length;
var i__7485__auto___37817 = (0);
while(true){
if((i__7485__auto___37817 < len__7484__auto___37816)){
args37749.push((arguments[i__7485__auto___37817]));

var G__37818 = (i__7485__auto___37817 + (1));
i__7485__auto___37817 = G__37818;
continue;
} else {
}
break;
}

var G__37751 = args37749.length;
switch (G__37751) {
case 1:
return sablono.core.datetime_field37748.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field37748.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37749.length)].join('')));

}
});

sablono.core.datetime_field37748.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.datetime_field37748.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.datetime_field37748.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.datetime_field37748.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field37748);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field37752 = (function sablono$core$datetime_local_field37752(var_args){
var args37753 = [];
var len__7484__auto___37820 = arguments.length;
var i__7485__auto___37821 = (0);
while(true){
if((i__7485__auto___37821 < len__7484__auto___37820)){
args37753.push((arguments[i__7485__auto___37821]));

var G__37822 = (i__7485__auto___37821 + (1));
i__7485__auto___37821 = G__37822;
continue;
} else {
}
break;
}

var G__37755 = args37753.length;
switch (G__37755) {
case 1:
return sablono.core.datetime_local_field37752.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field37752.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37753.length)].join('')));

}
});

sablono.core.datetime_local_field37752.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.datetime_local_field37752.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.datetime_local_field37752.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime_DASH_local)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.datetime_local_field37752.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field37752);

/**
 * Creates a email input field.
 */
sablono.core.email_field37756 = (function sablono$core$email_field37756(var_args){
var args37757 = [];
var len__7484__auto___37824 = arguments.length;
var i__7485__auto___37825 = (0);
while(true){
if((i__7485__auto___37825 < len__7484__auto___37824)){
args37757.push((arguments[i__7485__auto___37825]));

var G__37826 = (i__7485__auto___37825 + (1));
i__7485__auto___37825 = G__37826;
continue;
} else {
}
break;
}

var G__37759 = args37757.length;
switch (G__37759) {
case 1:
return sablono.core.email_field37756.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field37756.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37757.length)].join('')));

}
});

sablono.core.email_field37756.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.email_field37756.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.email_field37756.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$email)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.email_field37756.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field37756);

/**
 * Creates a file input field.
 */
sablono.core.file_field37760 = (function sablono$core$file_field37760(var_args){
var args37761 = [];
var len__7484__auto___37828 = arguments.length;
var i__7485__auto___37829 = (0);
while(true){
if((i__7485__auto___37829 < len__7484__auto___37828)){
args37761.push((arguments[i__7485__auto___37829]));

var G__37830 = (i__7485__auto___37829 + (1));
i__7485__auto___37829 = G__37830;
continue;
} else {
}
break;
}

var G__37763 = args37761.length;
switch (G__37763) {
case 1:
return sablono.core.file_field37760.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field37760.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37761.length)].join('')));

}
});

sablono.core.file_field37760.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.file_field37760.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.file_field37760.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$file)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.file_field37760.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field37760);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field37764 = (function sablono$core$hidden_field37764(var_args){
var args37765 = [];
var len__7484__auto___37832 = arguments.length;
var i__7485__auto___37833 = (0);
while(true){
if((i__7485__auto___37833 < len__7484__auto___37832)){
args37765.push((arguments[i__7485__auto___37833]));

var G__37834 = (i__7485__auto___37833 + (1));
i__7485__auto___37833 = G__37834;
continue;
} else {
}
break;
}

var G__37767 = args37765.length;
switch (G__37767) {
case 1:
return sablono.core.hidden_field37764.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field37764.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37765.length)].join('')));

}
});

sablono.core.hidden_field37764.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.hidden_field37764.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.hidden_field37764.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$hidden)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.hidden_field37764.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field37764);

/**
 * Creates a month input field.
 */
sablono.core.month_field37768 = (function sablono$core$month_field37768(var_args){
var args37769 = [];
var len__7484__auto___37836 = arguments.length;
var i__7485__auto___37837 = (0);
while(true){
if((i__7485__auto___37837 < len__7484__auto___37836)){
args37769.push((arguments[i__7485__auto___37837]));

var G__37838 = (i__7485__auto___37837 + (1));
i__7485__auto___37837 = G__37838;
continue;
} else {
}
break;
}

var G__37771 = args37769.length;
switch (G__37771) {
case 1:
return sablono.core.month_field37768.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field37768.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37769.length)].join('')));

}
});

sablono.core.month_field37768.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.month_field37768.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.month_field37768.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$month)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.month_field37768.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field37768);

/**
 * Creates a number input field.
 */
sablono.core.number_field37772 = (function sablono$core$number_field37772(var_args){
var args37773 = [];
var len__7484__auto___37840 = arguments.length;
var i__7485__auto___37841 = (0);
while(true){
if((i__7485__auto___37841 < len__7484__auto___37840)){
args37773.push((arguments[i__7485__auto___37841]));

var G__37842 = (i__7485__auto___37841 + (1));
i__7485__auto___37841 = G__37842;
continue;
} else {
}
break;
}

var G__37775 = args37773.length;
switch (G__37775) {
case 1:
return sablono.core.number_field37772.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field37772.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37773.length)].join('')));

}
});

sablono.core.number_field37772.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.number_field37772.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.number_field37772.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$number)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.number_field37772.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field37772);

/**
 * Creates a password input field.
 */
sablono.core.password_field37776 = (function sablono$core$password_field37776(var_args){
var args37777 = [];
var len__7484__auto___37844 = arguments.length;
var i__7485__auto___37845 = (0);
while(true){
if((i__7485__auto___37845 < len__7484__auto___37844)){
args37777.push((arguments[i__7485__auto___37845]));

var G__37846 = (i__7485__auto___37845 + (1));
i__7485__auto___37845 = G__37846;
continue;
} else {
}
break;
}

var G__37779 = args37777.length;
switch (G__37779) {
case 1:
return sablono.core.password_field37776.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field37776.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37777.length)].join('')));

}
});

sablono.core.password_field37776.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.password_field37776.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.password_field37776.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$password)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.password_field37776.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field37776);

/**
 * Creates a range input field.
 */
sablono.core.range_field37780 = (function sablono$core$range_field37780(var_args){
var args37781 = [];
var len__7484__auto___37848 = arguments.length;
var i__7485__auto___37849 = (0);
while(true){
if((i__7485__auto___37849 < len__7484__auto___37848)){
args37781.push((arguments[i__7485__auto___37849]));

var G__37850 = (i__7485__auto___37849 + (1));
i__7485__auto___37849 = G__37850;
continue;
} else {
}
break;
}

var G__37783 = args37781.length;
switch (G__37783) {
case 1:
return sablono.core.range_field37780.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field37780.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37781.length)].join('')));

}
});

sablono.core.range_field37780.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.range_field37780.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.range_field37780.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$range)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.range_field37780.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field37780);

/**
 * Creates a search input field.
 */
sablono.core.search_field37784 = (function sablono$core$search_field37784(var_args){
var args37785 = [];
var len__7484__auto___37852 = arguments.length;
var i__7485__auto___37853 = (0);
while(true){
if((i__7485__auto___37853 < len__7484__auto___37852)){
args37785.push((arguments[i__7485__auto___37853]));

var G__37854 = (i__7485__auto___37853 + (1));
i__7485__auto___37853 = G__37854;
continue;
} else {
}
break;
}

var G__37787 = args37785.length;
switch (G__37787) {
case 1:
return sablono.core.search_field37784.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field37784.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37785.length)].join('')));

}
});

sablono.core.search_field37784.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.search_field37784.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.search_field37784.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$search)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.search_field37784.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field37784);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field37788 = (function sablono$core$tel_field37788(var_args){
var args37789 = [];
var len__7484__auto___37856 = arguments.length;
var i__7485__auto___37857 = (0);
while(true){
if((i__7485__auto___37857 < len__7484__auto___37856)){
args37789.push((arguments[i__7485__auto___37857]));

var G__37858 = (i__7485__auto___37857 + (1));
i__7485__auto___37857 = G__37858;
continue;
} else {
}
break;
}

var G__37791 = args37789.length;
switch (G__37791) {
case 1:
return sablono.core.tel_field37788.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field37788.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37789.length)].join('')));

}
});

sablono.core.tel_field37788.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.tel_field37788.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.tel_field37788.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$tel)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.tel_field37788.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field37788);

/**
 * Creates a text input field.
 */
sablono.core.text_field37792 = (function sablono$core$text_field37792(var_args){
var args37793 = [];
var len__7484__auto___37860 = arguments.length;
var i__7485__auto___37861 = (0);
while(true){
if((i__7485__auto___37861 < len__7484__auto___37860)){
args37793.push((arguments[i__7485__auto___37861]));

var G__37862 = (i__7485__auto___37861 + (1));
i__7485__auto___37861 = G__37862;
continue;
} else {
}
break;
}

var G__37795 = args37793.length;
switch (G__37795) {
case 1:
return sablono.core.text_field37792.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field37792.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37793.length)].join('')));

}
});

sablono.core.text_field37792.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.text_field37792.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.text_field37792.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$text)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.text_field37792.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field37792);

/**
 * Creates a time input field.
 */
sablono.core.time_field37796 = (function sablono$core$time_field37796(var_args){
var args37797 = [];
var len__7484__auto___37864 = arguments.length;
var i__7485__auto___37865 = (0);
while(true){
if((i__7485__auto___37865 < len__7484__auto___37864)){
args37797.push((arguments[i__7485__auto___37865]));

var G__37866 = (i__7485__auto___37865 + (1));
i__7485__auto___37865 = G__37866;
continue;
} else {
}
break;
}

var G__37799 = args37797.length;
switch (G__37799) {
case 1:
return sablono.core.time_field37796.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field37796.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37797.length)].join('')));

}
});

sablono.core.time_field37796.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.time_field37796.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.time_field37796.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$time)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.time_field37796.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field37796);

/**
 * Creates a url input field.
 */
sablono.core.url_field37800 = (function sablono$core$url_field37800(var_args){
var args37801 = [];
var len__7484__auto___37868 = arguments.length;
var i__7485__auto___37869 = (0);
while(true){
if((i__7485__auto___37869 < len__7484__auto___37868)){
args37801.push((arguments[i__7485__auto___37869]));

var G__37870 = (i__7485__auto___37869 + (1));
i__7485__auto___37869 = G__37870;
continue;
} else {
}
break;
}

var G__37803 = args37801.length;
switch (G__37803) {
case 1:
return sablono.core.url_field37800.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field37800.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37801.length)].join('')));

}
});

sablono.core.url_field37800.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.url_field37800.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.url_field37800.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$url)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.url_field37800.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field37800);

/**
 * Creates a week input field.
 */
sablono.core.week_field37804 = (function sablono$core$week_field37804(var_args){
var args37805 = [];
var len__7484__auto___37872 = arguments.length;
var i__7485__auto___37873 = (0);
while(true){
if((i__7485__auto___37873 < len__7484__auto___37872)){
args37805.push((arguments[i__7485__auto___37873]));

var G__37874 = (i__7485__auto___37873 + (1));
i__7485__auto___37873 = G__37874;
continue;
} else {
}
break;
}

var G__37807 = args37805.length;
switch (G__37807) {
case 1:
return sablono.core.week_field37804.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field37804.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37805.length)].join('')));

}
});

sablono.core.week_field37804.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.week_field37804.cljs$core$IFn$_invoke$arity$2(name__19451__auto__,null);
});

sablono.core.week_field37804.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$week)].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.week_field37804.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field37804);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box37876 = (function sablono$core$check_box37876(var_args){
var args37877 = [];
var len__7484__auto___37880 = arguments.length;
var i__7485__auto___37881 = (0);
while(true){
if((i__7485__auto___37881 < len__7484__auto___37880)){
args37877.push((arguments[i__7485__auto___37881]));

var G__37882 = (i__7485__auto___37881 + (1));
i__7485__auto___37881 = G__37882;
continue;
} else {
}
break;
}

var G__37879 = args37877.length;
switch (G__37879) {
case 1:
return sablono.core.check_box37876.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box37876.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box37876.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37877.length)].join('')));

}
});

sablono.core.check_box37876.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box37876.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.check_box37876.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box37876.cljs$core$IFn$_invoke$arity$3(name,checked_QMARK_,"true");
});

sablono.core.check_box37876.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.check_box37876.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box37876);
/**
 * Creates a radio button.
 */
sablono.core.radio_button37884 = (function sablono$core$radio_button37884(var_args){
var args37885 = [];
var len__7484__auto___37888 = arguments.length;
var i__7485__auto___37889 = (0);
while(true){
if((i__7485__auto___37889 < len__7484__auto___37888)){
args37885.push((arguments[i__7485__auto___37889]));

var G__37890 = (i__7485__auto___37889 + (1));
i__7485__auto___37889 = G__37890;
continue;
} else {
}
break;
}

var G__37887 = args37885.length;
switch (G__37887) {
case 1:
return sablono.core.radio_button37884.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button37884.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button37884.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37885.length)].join('')));

}
});

sablono.core.radio_button37884.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button37884.cljs$core$IFn$_invoke$arity$2(group,null);
});

sablono.core.radio_button37884.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button37884.cljs$core$IFn$_invoke$arity$3(group,checked_QMARK_,"true");
});

sablono.core.radio_button37884.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"radio",cljs.core.cst$kw$name,sablono.core.make_name(group),cljs.core.cst$kw$id,sablono.core.make_id([cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([group], 0))),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([value], 0)))].join('')),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.radio_button37884.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button37884);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options37892 = (function sablono$core$select_options37892(var_args){
var args37893 = [];
var len__7484__auto___37914 = arguments.length;
var i__7485__auto___37915 = (0);
while(true){
if((i__7485__auto___37915 < len__7484__auto___37914)){
args37893.push((arguments[i__7485__auto___37915]));

var G__37916 = (i__7485__auto___37915 + (1));
i__7485__auto___37915 = G__37916;
continue;
} else {
}
break;
}

var G__37895 = args37893.length;
switch (G__37895) {
case 1:
return sablono.core.select_options37892.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options37892.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37893.length)].join('')));

}
});

sablono.core.select_options37892.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options37892.cljs$core$IFn$_invoke$arity$2(coll,null);
});

sablono.core.select_options37892.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__37896(s__37897){
return (new cljs.core.LazySeq(null,(function (){
var s__37897__$1 = s__37897;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37897__$1);
if(temp__4657__auto__){
var s__37897__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37897__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37897__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37899 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37898 = (0);
while(true){
if((i__37898 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37898);
cljs.core.chunk_append(b__37899,((cljs.core.sequential_QMARK_(x))?(function (){var vec__37908 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37908,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37908,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37908,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options37892.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)));

var G__37918 = (i__37898 + (1));
i__37898 = G__37918;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37899),sablono$core$iter__37896(cljs.core.chunk_rest(s__37897__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37899),null);
}
} else {
var x = cljs.core.first(s__37897__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__37911 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37911,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37911,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37911,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options37892.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)),sablono$core$iter__37896(cljs.core.rest(s__37897__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
});

sablono.core.select_options37892.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options37892);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down37919 = (function sablono$core$drop_down37919(var_args){
var args37920 = [];
var len__7484__auto___37923 = arguments.length;
var i__7485__auto___37924 = (0);
while(true){
if((i__7485__auto___37924 < len__7484__auto___37923)){
args37920.push((arguments[i__7485__auto___37924]));

var G__37925 = (i__7485__auto___37924 + (1));
i__7485__auto___37924 = G__37925;
continue;
} else {
}
break;
}

var G__37922 = args37920.length;
switch (G__37922) {
case 2:
return sablono.core.drop_down37919.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down37919.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37920.length)].join('')));

}
});

sablono.core.drop_down37919.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down37919.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down37919.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down37919.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down37919);
/**
 * Creates a text area element.
 */
sablono.core.text_area37927 = (function sablono$core$text_area37927(var_args){
var args37928 = [];
var len__7484__auto___37931 = arguments.length;
var i__7485__auto___37932 = (0);
while(true){
if((i__7485__auto___37932 < len__7484__auto___37931)){
args37928.push((arguments[i__7485__auto___37932]));

var G__37933 = (i__7485__auto___37932 + (1));
i__7485__auto___37932 = G__37933;
continue;
} else {
}
break;
}

var G__37930 = args37928.length;
switch (G__37930) {
case 1:
return sablono.core.text_area37927.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area37927.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37928.length)].join('')));

}
});

sablono.core.text_area37927.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area37927.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.text_area37927.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});

sablono.core.text_area37927.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area37927);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label37935 = (function sablono$core$label37935(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$htmlFor,sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label37935);
/**
 * Creates a submit button.
 */
sablono.core.submit_button37936 = (function sablono$core$submit_button37936(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button37936);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button37937 = (function sablono$core$reset_button37937(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"reset",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button37937);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to37938 = (function sablono$core$form_to37938(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37945 = arguments.length;
var i__7485__auto___37946 = (0);
while(true){
if((i__7485__auto___37946 < len__7484__auto___37945)){
args__7491__auto__.push((arguments[i__7485__auto___37946]));

var G__37947 = (i__7485__auto___37946 + (1));
i__7485__auto___37946 = G__37947;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to37938.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to37938.cljs$core$IFn$_invoke$arity$variadic = (function (p__37941,body){
var vec__37942 = p__37941;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37942,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37942,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$get,null,cljs.core.cst$kw$post,null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,method_str,cljs.core.cst$kw$action,action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,"POST",cljs.core.cst$kw$action,action_uri], null),(sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2("_method",method_str) : sablono.core.hidden_field.call(null,"_method",method_str))], null)),body));
});

sablono.core.form_to37938.cljs$lang$maxFixedArity = (1);

sablono.core.form_to37938.cljs$lang$applyTo = (function (seq37939){
var G__37940 = cljs.core.first(seq37939);
var seq37939__$1 = cljs.core.next(seq37939);
return sablono.core.form_to37938.cljs$core$IFn$_invoke$arity$variadic(G__37940,seq37939__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to37938);
