// Compiled by ClojureScript 1.9.229 {}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__7072__auto__ = (((x == null))?null:x);
var m__7073__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,x);
} else {
var m__7073__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return c2.dom.select.call(null,selector);
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render.call(null,v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args21608 = [];
var len__7484__auto___21611 = arguments.length;
var i__7485__auto___21612 = (0);
while(true){
if((i__7485__auto___21612 < len__7484__auto___21611)){
args21608.push((arguments[i__7485__auto___21612]));

var G__21613 = (i__7485__auto___21612 + (1));
i__7485__auto___21612 = G__21613;
continue;
} else {
}
break;
}

var G__21610 = args21608.length;
switch (G__21610) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21608.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;

/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args21615 = [];
var len__7484__auto___21618 = arguments.length;
var i__7485__auto___21619 = (0);
while(true){
if((i__7485__auto___21619 < len__7484__auto___21618)){
args21615.push((arguments[i__7485__auto___21619]));

var G__21620 = (i__7485__auto___21619 + (1));
i__7485__auto___21619 = G__21620;
continue;
} else {
}
break;
}

var G__21617 = args21615.length;
switch (G__21617) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21615.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;

/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom.call(null,node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom.call(null,node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.appendChild(c2.dom.__GT_dom.call(null,container),el__$1);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.insertChildAt(c2.dom.__GT_dom.call(null,container),el__$1,(0));

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
return goog.dom.removeNode(c2.dom.__GT_dom.call(null,el));
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom.call(null,new$);
goog.dom.replaceNode(new$__$1,c2.dom.__GT_dom.call(null,old));

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args21622 = [];
var len__7484__auto___21635 = arguments.length;
var i__7485__auto___21636 = (0);
while(true){
if((i__7485__auto___21636 < len__7484__auto___21635)){
args21622.push((arguments[i__7485__auto___21636]));

var G__21637 = (i__7485__auto___21636 + (1));
i__7485__auto___21636 = G__21637;
continue;
} else {
}
break;
}

var G__21624 = args21622.length;
switch (G__21624) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21622.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return goog.style.getComputedStyle(el__$1,cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__21625_21639 = cljs.core.seq.call(null,x);
var chunk__21626_21640 = null;
var count__21627_21641 = (0);
var i__21628_21642 = (0);
while(true){
if((i__21628_21642 < count__21627_21641)){
var vec__21629_21643 = cljs.core._nth.call(null,chunk__21626_21640,i__21628_21642);
var k_21644 = cljs.core.nth.call(null,vec__21629_21643,(0),null);
var v_21645 = cljs.core.nth.call(null,vec__21629_21643,(1),null);
c2.dom.style.call(null,el__$1,k_21644,v_21645);

var G__21646 = seq__21625_21639;
var G__21647 = chunk__21626_21640;
var G__21648 = count__21627_21641;
var G__21649 = (i__21628_21642 + (1));
seq__21625_21639 = G__21646;
chunk__21626_21640 = G__21647;
count__21627_21641 = G__21648;
i__21628_21642 = G__21649;
continue;
} else {
var temp__4657__auto___21650 = cljs.core.seq.call(null,seq__21625_21639);
if(temp__4657__auto___21650){
var seq__21625_21651__$1 = temp__4657__auto___21650;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21625_21651__$1)){
var c__7220__auto___21652 = cljs.core.chunk_first.call(null,seq__21625_21651__$1);
var G__21653 = cljs.core.chunk_rest.call(null,seq__21625_21651__$1);
var G__21654 = c__7220__auto___21652;
var G__21655 = cljs.core.count.call(null,c__7220__auto___21652);
var G__21656 = (0);
seq__21625_21639 = G__21653;
chunk__21626_21640 = G__21654;
count__21627_21641 = G__21655;
i__21628_21642 = G__21656;
continue;
} else {
var vec__21632_21657 = cljs.core.first.call(null,seq__21625_21651__$1);
var k_21658 = cljs.core.nth.call(null,vec__21632_21657,(0),null);
var v_21659 = cljs.core.nth.call(null,vec__21632_21657,(1),null);
c2.dom.style.call(null,el__$1,k_21658,v_21659);

var G__21660 = cljs.core.next.call(null,seq__21625_21651__$1);
var G__21661 = null;
var G__21662 = (0);
var G__21663 = (0);
seq__21625_21639 = G__21660;
chunk__21626_21640 = G__21661;
count__21627_21641 = G__21662;
i__21628_21642 = G__21663;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
goog.style.setStyle(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,k),((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"height","height",1025178622),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null).call(null,cljs.core.keyword.call(null,k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null)));

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args21664 = [];
var len__7484__auto___21681 = arguments.length;
var i__7485__auto___21682 = (0);
while(true){
if((i__7485__auto___21682 < len__7484__auto___21681)){
args21664.push((arguments[i__7485__auto___21682]));

var G__21683 = (i__7485__auto___21682 + (1));
i__7485__auto___21682 = G__21683;
continue;
} else {
}
break;
}

var G__21666 = args21664.length;
switch (G__21666) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21664.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom.call(null,el).attributes;
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (attrs){
return (function c2$dom$iter__21667(s__21668){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__21668__$1 = s__21668;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21668__$1);
if(temp__4657__auto__){
var s__21668__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21668__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__21668__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__21670 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__21669 = (0);
while(true){
if((i__21669 < size__7188__auto__)){
var i = cljs.core._nth.call(null,c__7187__auto__,i__21669);
cljs.core.chunk_append.call(null,b__21670,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null));

var G__21685 = (i__21669 + (1));
i__21669 = G__21685;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21670),c2$dom$iter__21667.call(null,cljs.core.chunk_rest.call(null,s__21668__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21670),null);
}
} else {
var i = cljs.core.first.call(null,s__21668__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__21667.call(null,cljs.core.rest.call(null,s__21668__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__7189__auto__.call(null,cljs.core.range.call(null,attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__21671_21686 = cljs.core.seq.call(null,x);
var chunk__21672_21687 = null;
var count__21673_21688 = (0);
var i__21674_21689 = (0);
while(true){
if((i__21674_21689 < count__21673_21688)){
var vec__21675_21690 = cljs.core._nth.call(null,chunk__21672_21687,i__21674_21689);
var k_21691 = cljs.core.nth.call(null,vec__21675_21690,(0),null);
var v_21692 = cljs.core.nth.call(null,vec__21675_21690,(1),null);
c2.dom.attr.call(null,el__$1,k_21691,v_21692);

var G__21693 = seq__21671_21686;
var G__21694 = chunk__21672_21687;
var G__21695 = count__21673_21688;
var G__21696 = (i__21674_21689 + (1));
seq__21671_21686 = G__21693;
chunk__21672_21687 = G__21694;
count__21673_21688 = G__21695;
i__21674_21689 = G__21696;
continue;
} else {
var temp__4657__auto___21697 = cljs.core.seq.call(null,seq__21671_21686);
if(temp__4657__auto___21697){
var seq__21671_21698__$1 = temp__4657__auto___21697;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21671_21698__$1)){
var c__7220__auto___21699 = cljs.core.chunk_first.call(null,seq__21671_21698__$1);
var G__21700 = cljs.core.chunk_rest.call(null,seq__21671_21698__$1);
var G__21701 = c__7220__auto___21699;
var G__21702 = cljs.core.count.call(null,c__7220__auto___21699);
var G__21703 = (0);
seq__21671_21686 = G__21700;
chunk__21672_21687 = G__21701;
count__21673_21688 = G__21702;
i__21674_21689 = G__21703;
continue;
} else {
var vec__21678_21704 = cljs.core.first.call(null,seq__21671_21698__$1);
var k_21705 = cljs.core.nth.call(null,vec__21678_21704,(0),null);
var v_21706 = cljs.core.nth.call(null,vec__21678_21704,(1),null);
c2.dom.attr.call(null,el__$1,k_21705,v_21706);

var G__21707 = cljs.core.next.call(null,seq__21671_21698__$1);
var G__21708 = null;
var G__21709 = (0);
var G__21710 = (0);
seq__21671_21686 = G__21707;
chunk__21672_21687 = G__21708;
count__21673_21688 = G__21709;
i__21674_21689 = G__21710;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name.call(null,k));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"style","style",-496642736),k)){
c2.dom.style.call(null,el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name.call(null,k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args21711 = [];
var len__7484__auto___21714 = arguments.length;
var i__7485__auto___21715 = (0);
while(true){
if((i__7485__auto___21715 < len__7484__auto___21714)){
args21711.push((arguments[i__7485__auto___21715]));

var G__21716 = (i__7485__auto___21715 + (1));
i__7485__auto___21715 = G__21716;
continue;
} else {
}
break;
}

var G__21713 = args21711.length;
switch (G__21713) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21711.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.getTextContent(c2.dom.__GT_dom.call(null,el));
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;

/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args21718 = [];
var len__7484__auto___21721 = arguments.length;
var i__7485__auto___21722 = (0);
while(true){
if((i__7485__auto___21722 < len__7484__auto___21721)){
args21718.push((arguments[i__7485__auto___21722]));

var G__21723 = (i__7485__auto___21722 + (1));
i__7485__auto___21722 = G__21723;
continue;
} else {
}
break;
}

var G__21720 = args21718.length;
switch (G__21720) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21718.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.forms.getValue(c2.dom.__GT_dom.call(null,el));
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;

/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
goog.dom.classes.enable(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,class$),classed_QMARK_);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6409__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return ((function (or__6409__auto____$1,or__6409__auto__){
return (function (p1__21725_SHARP_){
return setTimeout(((function (or__6409__auto____$1,or__6409__auto__){
return (function (){
return p1__21725_SHARP_.call(null);
});})(or__6409__auto____$1,or__6409__auto__))
,(10));
});
;})(or__6409__auto____$1,or__6409__auto__))
}
}
})();
