// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.record');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('clojure.string');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.urls');
/**
 * Wrap-with produces a partial to wrap a set of children.
 * ((wrap-with :div) 1 2 3) => [:div [1 2 3]]
 * ((wrap-with [:div {:class 0}]) 1 2 3) => [:div {:class 0} [1 2 3]]
 */
hatti.views.record.wrap_with = (function hatti$views$record$wrap_with(root){
return (function() { 
var G__22551__delegate = function (children){
if((root instanceof cljs.core.Keyword)){
return cljs.core.conj.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root], null),children);
} else {
return cljs.core.conj.call(null,root,children);
}
};
var G__22551 = function (var_args){
var children = null;
if (arguments.length > 0) {
var G__22552__i = 0, G__22552__a = new Array(arguments.length -  0);
while (G__22552__i < G__22552__a.length) {G__22552__a[G__22552__i] = arguments[G__22552__i + 0]; ++G__22552__i;}
  children = new cljs.core.IndexedSeq(G__22552__a,0);
} 
return G__22551__delegate.call(this,children);};
G__22551.cljs$lang$maxFixedArity = 0;
G__22551.cljs$lang$applyTo = (function (arglist__22553){
var children = cljs.core.seq(arglist__22553);
return G__22551__delegate(children);
});
G__22551.cljs$core$IFn$_invoke$arity$variadic = G__22551__delegate;
return G__22551;
})()
;
});
hatti.views.record.submission_arrow = (function hatti$views$record$submission_arrow(dir,cur_rank,view){
var icon = [cljs.core.str("fa fa-arrow-"),cljs.core.str(cljs.core.name.call(null,dir))].join('');
var new_rank = (function (){var G__22558 = (((dir instanceof cljs.core.Keyword))?dir.fqn:null);
switch (G__22558) {
case "left":
return cljs.core.dec;

break;
case "right":
return cljs.core.inc;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(dir)].join('')));

}
})().call(null,cur_rank);
var event_key = (function (){var pred__22559 = cljs.core._EQ_;
var expr__22560 = view;
if(cljs.core.truth_(pred__22559.call(null,new cljs.core.Keyword(null,"map","map",1371690461),expr__22560))){
return new cljs.core.Keyword(null,"mapped-submission-to-rank","mapped-submission-to-rank",-1281314361);
} else {
if(cljs.core.truth_(pred__22559.call(null,new cljs.core.Keyword(null,"table","table",-564943036),expr__22560))){
return new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797);
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__22560)].join('')));
}
}
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.pure-button.btn-default","a.pure-button.btn-default",-1117383068),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (icon,new_rank,event_key){
return (function (){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,cljs.core.PersistentArrayMap.fromArray([event_key,new_rank], true, false));
});})(icon,new_rank,event_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),icon], null)], null)], null);
});
hatti.views.record.submission_closer = (function hatti$views$record$submission_closer(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.btn-close.right","a.btn-close.right",-1684667393),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,(function (){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520),true], null));
})),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),"\u00D7"], null);
});
cljs.core._add_method.call(null,hatti.views.print_xls_report_btn,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.record.t_hatti$views$record22563 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record22563 = (function (cursor,owner,meta22564){
this.cursor = cursor;
this.owner = owner;
this.meta22564 = meta22564;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record22563.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22565,meta22564__$1){
var self__ = this;
var _22565__$1 = this;
return (new hatti.views.record.t_hatti$views$record22563(self__.cursor,self__.owner,meta22564__$1));
});

hatti.views.record.t_hatti$views$record22563.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22565){
var self__ = this;
var _22565__$1 = this;
return self__.meta22564;
});

hatti.views.record.t_hatti$views$record22563.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record22563.prototype.om$core$IRender$render$arity$1 = (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
return React.DOM.div(({"id": "print-xls-report"}));
});

hatti.views.record.t_hatti$views$record22563.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta22564","meta22564",1425076538,null)], null);
});

hatti.views.record.t_hatti$views$record22563.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record22563.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record22563";

hatti.views.record.t_hatti$views$record22563.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.record/t_hatti$views$record22563");
});

hatti.views.record.__GT_t_hatti$views$record22563 = (function hatti$views$record$__GT_t_hatti$views$record22563(cursor__$1,owner__$1,meta22564){
return (new hatti.views.record.t_hatti$views$record22563(cursor__$1,owner__$1,meta22564));
});

}

return (new hatti.views.record.t_hatti$views$record22563(cursor,owner,null));
}));
hatti.views.record.qa_elements = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"row-el","row-el",-1433801362),new cljs.core.Keyword(null,"div.question-answer","div.question-answer",370303396),new cljs.core.Keyword(null,"question-el","question-el",-572061899),new cljs.core.Keyword(null,"span.question","span.question",826624133),new cljs.core.Keyword(null,"answer-el","answer-el",-306379371),new cljs.core.Keyword(null,"span.answer","span.answer",1128039098)], null),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"row-el","row-el",-1433801362),new cljs.core.Keyword(null,"tr.question-answer","tr.question-answer",1117674171),new cljs.core.Keyword(null,"question-el","question-el",-572061899),new cljs.core.Keyword(null,"td.question","td.question",-381922608),new cljs.core.Keyword(null,"answer-el","answer-el",-306379371),new cljs.core.Keyword(null,"td.answer","td.answer",1235375692)], null)], null);
hatti.views.record.format_as_question_answer = (function hatti$views$record$format_as_question_answer(view,field,data,lang){
var fname = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var flabel = hatti.ona.forms.get_label.call(null,field,lang);
var answer = cljs.core.get.call(null,data,fname);
var alabel = hatti.ona.forms.format_answer.call(null,field,answer,new cljs.core.Keyword(null,"language","language",-1591107564),lang);
var map__22570 = hatti.views.record.qa_elements.call(null,view);
var map__22570__$1 = ((((!((map__22570 == null)))?((((map__22570.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22570.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22570):map__22570);
var row_el = cljs.core.get.call(null,map__22570__$1,new cljs.core.Keyword(null,"row-el","row-el",-1433801362));
var question_el = cljs.core.get.call(null,map__22570__$1,new cljs.core.Keyword(null,"question-el","question-el",-572061899));
var answer_el = cljs.core.get.call(null,map__22570__$1,new cljs.core.Keyword(null,"answer-el","answer-el",-306379371));
if(cljs.core.truth_((function (){var and__6397__auto__ = alabel;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not_EQ_.call(null,alabel,hatti.ona.forms.no_answer);
} else {
return and__6397__auto__;
}
})())){
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,field))){
return om.core.build.call(null,hatti.views.repeat_view,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data","data",-232669377),answer,new cljs.core.Keyword(null,"repeat-field","repeat-field",-2099292535),field,new cljs.core.Keyword(null,"lang","lang",-1819677104),lang], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),view], null)], null));
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,flabel], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,alabel], null)], null);
}
} else {
return null;
}
});
hatti.views.record.submission_elements = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top-level-wrap","top-level-wrap",366303456),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.legend.infobar.submission.top.right","div.legend.infobar.submission.top.right",726433654)),new cljs.core.Keyword(null,"topbar-wrap","topbar-wrap",1084926998),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.border-bottom.legend-topbar","div.border-bottom.legend-topbar",-1940089808)),new cljs.core.Keyword(null,"header-wrap","header-wrap",517152474),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.border-bottom.submission-header","div.border-bottom.submission-header",1572822310)),new cljs.core.Keyword(null,"submission-info-wrap","submission-info-wrap",-1360099904),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.submission.info-scroll","div.submission.info-scroll",1628305488)),new cljs.core.Keyword(null,"section-wrap","section-wrap",28486716),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.border-bottom","div.border-bottom",1472282167)),new cljs.core.Keyword(null,"h4-cls","h4-cls",-1006591520),"t-red"], null),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"top-level-wrap","top-level-wrap",366303456),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.widget-info#single-submission-info","div.widget-info#single-submission-info",-714613242)),new cljs.core.Keyword(null,"topbar-wrap","topbar-wrap",1084926998),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.topbar","div.topbar",1355117265)),new cljs.core.Keyword(null,"header-wrap","header-wrap",517152474),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.header","div.header",1964513620)),new cljs.core.Keyword(null,"submission-info-wrap","submission-info-wrap",-1360099904),(function() { 
var G__22572__delegate = function (tbody){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.submission","div.submission",1371621120),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table.pure-table.pure-table-bordered","table.pure-table.pure-table-bordered",-1577425751),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),"Question"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),"Response"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),tbody], null)], null)], null);
};
var G__22572 = function (var_args){
var tbody = null;
if (arguments.length > 0) {
var G__22573__i = 0, G__22573__a = new Array(arguments.length -  0);
while (G__22573__i < G__22573__a.length) {G__22573__a[G__22573__i] = arguments[G__22573__i + 0]; ++G__22573__i;}
  tbody = new cljs.core.IndexedSeq(G__22573__a,0);
} 
return G__22572__delegate.call(this,tbody);};
G__22572.cljs$lang$maxFixedArity = 0;
G__22572.cljs$lang$applyTo = (function (arglist__22574){
var tbody = cljs.core.seq(arglist__22574);
return G__22572__delegate(tbody);
});
G__22572.cljs$core$IFn$_invoke$arity$variadic = G__22572__delegate;
return G__22572;
})()
,new cljs.core.Keyword(null,"section-wrap","section-wrap",28486716),cljs.core.identity,new cljs.core.Keyword(null,"show-instance-id","show-instance-id",-2119784356),true,new cljs.core.Keyword(null,"h4-cls","h4-cls",-1006591520),""], null)], null);
cljs.core._add_method.call(null,hatti.views.repeat_view,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__22576,owner,p__22577){
var map__22578 = p__22576;
var map__22578__$1 = ((((!((map__22578 == null)))?((((map__22578.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22578.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22578):map__22578);
var data = cljs.core.get.call(null,map__22578__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var repeat_field = cljs.core.get.call(null,map__22578__$1,new cljs.core.Keyword(null,"repeat-field","repeat-field",-2099292535));
var lang = cljs.core.get.call(null,map__22578__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
var map__22579 = p__22577;
var map__22579__$1 = ((((!((map__22579 == null)))?((((map__22579.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22579.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22579):map__22579);
var view = cljs.core.get.call(null,map__22579__$1,new cljs.core.Keyword(null,"view","view",1247994814));

if(typeof hatti.views.record.t_hatti$views$record22582 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record22582 = (function (p__22576,owner,p__22577,map__22578,data,repeat_field,lang,map__22579,view,meta22583){
this.p__22576 = p__22576;
this.owner = owner;
this.p__22577 = p__22577;
this.map__22578 = map__22578;
this.data = data;
this.repeat_field = repeat_field;
this.lang = lang;
this.map__22579 = map__22579;
this.view = view;
this.meta22583 = meta22583;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record22582.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function (_22584,meta22583__$1){
var self__ = this;
var _22584__$1 = this;
return (new hatti.views.record.t_hatti$views$record22582(self__.p__22576,self__.owner,self__.p__22577,self__.map__22578,self__.data,self__.repeat_field,self__.lang,self__.map__22579,self__.view,meta22583__$1));
});})(map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
;

hatti.views.record.t_hatti$views$record22582.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function (_22584){
var self__ = this;
var _22584__$1 = this;
return self__.meta22583;
});})(map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
;

hatti.views.record.t_hatti$views$record22582.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record22582.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"collapsed?","collapsed?",-1661420674),true], null);
});})(map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
;

hatti.views.record.t_hatti$views$record22582.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record22582.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function (_,p__22585){
var self__ = this;
var map__22586 = p__22585;
var map__22586__$1 = ((((!((map__22586 == null)))?((((map__22586.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22586.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22586):map__22586);
var collapsed_QMARK_ = cljs.core.get.call(null,map__22586__$1,new cljs.core.Keyword(null,"collapsed?","collapsed?",-1661420674));
var ___$1 = this;
if(cljs.core.seq.call(null,self__.data)){
var collapse_BANG_ = ((function (___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function (p1__22575_SHARP_){
return om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"collapsed?","collapsed?",-1661420674),p1__22575_SHARP_);
});})(___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
;
var map__22588 = hatti.views.record.qa_elements.call(null,self__.view);
var map__22588__$1 = ((((!((map__22588 == null)))?((((map__22588.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22588.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22588):map__22588);
var row_el = cljs.core.get.call(null,map__22588__$1,new cljs.core.Keyword(null,"row-el","row-el",-1433801362));
var question_el = cljs.core.get.call(null,map__22588__$1,new cljs.core.Keyword(null,"question-el","question-el",-572061899));
var answer_el = cljs.core.get.call(null,map__22588__$1,new cljs.core.Keyword(null,"answer-el","answer-el",-306379371));
var header = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,hatti.ona.forms.get_label.call(null,self__.repeat_field,self__.lang)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,[cljs.core.str(hatti.utils.pluralize_number.call(null,cljs.core.count.call(null,self__.data)," Repeat")),cljs.core.str(" - ")].join(''),(cljs.core.truth_(collapsed_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function (){
return collapse_BANG_.call(null,false);
});})(collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),"Show Repeats"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function (){
return collapse_BANG_.call(null,true);
});})(collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),"Hide Repeats"], null))], null)], null);
var fname = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(self__.repeat_field);
var render_child = ((function (collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function (d){
var iter__7189__auto__ = ((function (collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function hatti$views$record$iter__22590(s__22591){
return (new cljs.core.LazySeq(null,((function (collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function (){
var s__22591__$1 = s__22591;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22591__$1);
if(temp__4657__auto__){
var s__22591__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22591__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22591__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22593 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22592 = (0);
while(true){
if((i__22592 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__22592);
cljs.core.chunk_append.call(null,b__22593,hatti.views.record.format_as_question_answer.call(null,self__.view,field,d,self__.lang));

var G__22603 = (i__22592 + (1));
i__22592 = G__22603;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22593),hatti$views$record$iter__22590.call(null,cljs.core.chunk_rest.call(null,s__22591__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22593),null);
}
} else {
var field = cljs.core.first.call(null,s__22591__$2);
return cljs.core.cons.call(null,hatti.views.record.format_as_question_answer.call(null,self__.view,field,d,self__.lang),hatti$views$record$iter__22590.call(null,cljs.core.rest.call(null,s__22591__$2)));
}
} else {
return null;
}
break;
}
});})(collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
,null,null));
});})(collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
;
return iter__7189__auto__.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(self__.repeat_field));
});})(collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
;
var tbl = ((function (collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function() { 
var G__22604__delegate = function (cls,body){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),cls], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.no-pad","td.no-pad",1626503288),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"col-span","col-span",-232603210),(2)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),cls], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),body], null)], null)], null)], null);
};
var G__22604 = function (cls,var_args){
var body = null;
if (arguments.length > 1) {
var G__22605__i = 0, G__22605__a = new Array(arguments.length -  1);
while (G__22605__i < G__22605__a.length) {G__22605__a[G__22605__i] = arguments[G__22605__i + 1]; ++G__22605__i;}
  body = new cljs.core.IndexedSeq(G__22605__a,0);
} 
return G__22604__delegate.call(this,cls,body);};
G__22604.cljs$lang$maxFixedArity = 1;
G__22604.cljs$lang$applyTo = (function (arglist__22606){
var cls = cljs.core.first(arglist__22606);
var body = cljs.core.rest(arglist__22606);
return G__22604__delegate(cls,body);
});
G__22604.cljs$core$IFn$_invoke$arity$variadic = G__22604__delegate;
return G__22604;
})()
;})(collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
;
if(cljs.core.truth_(collapsed_QMARK_)){
return sablono.interpreter.interpret.call(null,header);
} else {
return sablono.interpreter.interpret.call(null,(function (){var G__22594 = (((self__.view instanceof cljs.core.Keyword))?self__.view.fqn:null);
switch (G__22594) {
case "map":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.repeat-block","div.repeat-block",500963170),header,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol.repeat","ol.repeat",-1422933218),(function (){var iter__7189__auto__ = ((function (G__22594,collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function hatti$views$record$iter__22595(s__22596){
return (new cljs.core.LazySeq(null,((function (G__22594,collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function (){
var s__22596__$1 = s__22596;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22596__$1);
if(temp__4657__auto__){
var s__22596__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22596__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22596__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22598 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22597 = (0);
while(true){
if((i__22597 < size__7188__auto__)){
var d = cljs.core._nth.call(null,c__7187__auto__,i__22597);
cljs.core.chunk_append.call(null,b__22598,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),render_child.call(null,d)], null));

var G__22608 = (i__22597 + (1));
i__22597 = G__22608;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22598),hatti$views$record$iter__22595.call(null,cljs.core.chunk_rest.call(null,s__22596__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22598),null);
}
} else {
var d = cljs.core.first.call(null,s__22596__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),render_child.call(null,d)], null),hatti$views$record$iter__22595.call(null,cljs.core.rest.call(null,s__22596__$2)));
}
} else {
return null;
}
break;
}
});})(G__22594,collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
,null,null));
});})(G__22594,collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
;
return iter__7189__auto__.call(null,self__.data);
})()], null)], null);

break;
case "table":
return tbl.call(null,"repeat-block",header,(function (){var iter__7189__auto__ = ((function (G__22594,collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function hatti$views$record$iter__22599(s__22600){
return (new cljs.core.LazySeq(null,((function (G__22594,collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function (){
var s__22600__$1 = s__22600;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22600__$1);
if(temp__4657__auto__){
var s__22600__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22600__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22600__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22602 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22601 = (0);
while(true){
if((i__22601 < size__7188__auto__)){
var d = cljs.core._nth.call(null,c__7187__auto__,i__22601);
cljs.core.chunk_append.call(null,b__22602,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody.repeat","tbody.repeat",575514719),render_child.call(null,d)], null));

var G__22609 = (i__22601 + (1));
i__22601 = G__22609;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22602),hatti$views$record$iter__22599.call(null,cljs.core.chunk_rest.call(null,s__22600__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22602),null);
}
} else {
var d = cljs.core.first.call(null,s__22600__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody.repeat","tbody.repeat",575514719),render_child.call(null,d)], null),hatti$views$record$iter__22599.call(null,cljs.core.rest.call(null,s__22600__$2)));
}
} else {
return null;
}
break;
}
});})(G__22594,collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
,null,null));
});})(G__22594,collapse_BANG_,map__22588,map__22588__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22586,map__22586__$1,collapsed_QMARK_,map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
;
return iter__7189__auto__.call(null,self__.data);
})());

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(self__.view)].join('')));

}
})());
}
} else {
return null;
}
});})(map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
;

hatti.views.record.t_hatti$views$record22582.getBasis = ((function (map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__22576","p__22576",1170998647,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__22577","p__22577",981897839,null),new cljs.core.Symbol(null,"map__22578","map__22578",-61588551,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"repeat-field","repeat-field",-458761008,null),new cljs.core.Symbol(null,"lang","lang",-179145577,null),new cljs.core.Symbol(null,"map__22579","map__22579",1041921909,null),new cljs.core.Symbol(null,"view","view",-1406440955,null),new cljs.core.Symbol(null,"meta22583","meta22583",2049475102,null)], null);
});})(map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
;

hatti.views.record.t_hatti$views$record22582.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record22582.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record22582";

hatti.views.record.t_hatti$views$record22582.cljs$lang$ctorPrWriter = ((function (map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.record/t_hatti$views$record22582");
});})(map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
;

hatti.views.record.__GT_t_hatti$views$record22582 = ((function (map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view){
return (function hatti$views$record$__GT_t_hatti$views$record22582(p__22576__$1,owner__$1,p__22577__$1,map__22578__$2,data__$1,repeat_field__$1,lang__$1,map__22579__$2,view__$1,meta22583){
return (new hatti.views.record.t_hatti$views$record22582(p__22576__$1,owner__$1,p__22577__$1,map__22578__$2,data__$1,repeat_field__$1,lang__$1,map__22579__$2,view__$1,meta22583));
});})(map__22578,map__22578__$1,data,repeat_field,lang,map__22579,map__22579__$1,view))
;

}

return (new hatti.views.record.t_hatti$views$record22582(p__22576,owner,p__22577,map__22578__$1,data,repeat_field,lang,map__22579__$1,view,cljs.core.PersistentArrayMap.EMPTY));
}));
hatti.views.record.header_note = (function hatti$views$record$header_note(view,p__22610){
var map__22613 = p__22610;
var map__22613__$1 = ((((!((map__22613 == null)))?((((map__22613.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22613.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22613):map__22613);
var geofield = cljs.core.get.call(null,map__22613__$1,new cljs.core.Keyword(null,"geofield","geofield",578715548));
var data = cljs.core.get.call(null,map__22613__$1,new cljs.core.Keyword(null,"data","data",-232669377));
if((cljs.core._EQ_.call(null,view,new cljs.core.Keyword(null,"map","map",1371690461))) && (cljs.core.not.call(null,cljs.core.get.call(null,data,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(geofield))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.no-geo.t-normal.right","span.no-geo.t-normal.right",-1340634035),"No geodata"], null);
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.edit_delete,new cljs.core.Keyword(null,"default","default",-1987822328),(function (instance_id,owner,p__22615){
var map__22616 = p__22615;
var map__22616__$1 = ((((!((map__22616 == null)))?((((map__22616.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22616.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22616):map__22616);
var delete_record_BANG_ = cljs.core.get.call(null,map__22616__$1,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194));
if(typeof hatti.views.record.t_hatti$views$record22618 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record22618 = (function (instance_id,owner,p__22615,map__22616,delete_record_BANG_,meta22619){
this.instance_id = instance_id;
this.owner = owner;
this.p__22615 = p__22615;
this.map__22616 = map__22616;
this.delete_record_BANG_ = delete_record_BANG_;
this.meta22619 = meta22619;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record22618.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__22616,map__22616__$1,delete_record_BANG_){
return (function (_22620,meta22619__$1){
var self__ = this;
var _22620__$1 = this;
return (new hatti.views.record.t_hatti$views$record22618(self__.instance_id,self__.owner,self__.p__22615,self__.map__22616,self__.delete_record_BANG_,meta22619__$1));
});})(map__22616,map__22616__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record22618.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__22616,map__22616__$1,delete_record_BANG_){
return (function (_22620){
var self__ = this;
var _22620__$1 = this;
return self__.meta22619;
});})(map__22616,map__22616__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record22618.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record22618.prototype.om$core$IRender$render$arity$1 = ((function (map__22616,map__22616__$1,delete_record_BANG_){
return (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
return null;
});})(map__22616,map__22616__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record22618.getBasis = ((function (map__22616,map__22616__$1,delete_record_BANG_){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"instance-id","instance-id",-1703074506,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__22615","p__22615",-1738448834,null),new cljs.core.Symbol(null,"map__22616","map__22616",647659994,null),new cljs.core.Symbol(null,"delete-record!","delete-record!",-1242587575,null),new cljs.core.Symbol(null,"meta22619","meta22619",810990429,null)], null);
});})(map__22616,map__22616__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record22618.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record22618.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record22618";

hatti.views.record.t_hatti$views$record22618.cljs$lang$ctorPrWriter = ((function (map__22616,map__22616__$1,delete_record_BANG_){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.record/t_hatti$views$record22618");
});})(map__22616,map__22616__$1,delete_record_BANG_))
;

hatti.views.record.__GT_t_hatti$views$record22618 = ((function (map__22616,map__22616__$1,delete_record_BANG_){
return (function hatti$views$record$__GT_t_hatti$views$record22618(instance_id__$1,owner__$1,p__22615__$1,map__22616__$2,delete_record_BANG___$1,meta22619){
return (new hatti.views.record.t_hatti$views$record22618(instance_id__$1,owner__$1,p__22615__$1,map__22616__$2,delete_record_BANG___$1,meta22619));
});})(map__22616,map__22616__$1,delete_record_BANG_))
;

}

return (new hatti.views.record.t_hatti$views$record22618(instance_id,owner,p__22615,map__22616__$1,delete_record_BANG_,null));
}));
cljs.core._add_method.call(null,hatti.views.submission_view,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner,p__22621){
var map__22622 = p__22621;
var map__22622__$1 = ((((!((map__22622 == null)))?((((map__22622.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22622.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22622):map__22622);
var opts = map__22622__$1;
var view = cljs.core.get.call(null,map__22622__$1,new cljs.core.Keyword(null,"view","view",1247994814));
if(typeof hatti.views.record.t_hatti$views$record22624 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record22624 = (function (cursor,owner,p__22621,map__22622,opts,view,meta22625){
this.cursor = cursor;
this.owner = owner;
this.p__22621 = p__22621;
this.map__22622 = map__22622;
this.opts = opts;
this.view = view;
this.meta22625 = meta22625;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record22624.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__22622,map__22622__$1,opts,view){
return (function (_22626,meta22625__$1){
var self__ = this;
var _22626__$1 = this;
return (new hatti.views.record.t_hatti$views$record22624(self__.cursor,self__.owner,self__.p__22621,self__.map__22622,self__.opts,self__.view,meta22625__$1));
});})(map__22622,map__22622__$1,opts,view))
;

hatti.views.record.t_hatti$views$record22624.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__22622,map__22622__$1,opts,view){
return (function (_22626){
var self__ = this;
var _22626__$1 = this;
return self__.meta22625;
});})(map__22622,map__22622__$1,opts,view))
;

hatti.views.record.t_hatti$views$record22624.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record22624.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__22622,map__22622__$1,opts,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"expand-meta?","expand-meta?",-1578417082),false], null);
});})(map__22622,map__22622__$1,opts,view))
;

hatti.views.record.t_hatti$views$record22624.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record22624.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__22622,map__22622__$1,opts,view){
return (function (_,p__22627){
var self__ = this;
var map__22628 = p__22627;
var map__22628__$1 = ((((!((map__22628 == null)))?((((map__22628.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22628.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22628):map__22628);
var expand_meta_QMARK_ = cljs.core.get.call(null,map__22628__$1,new cljs.core.Keyword(null,"expand-meta?","expand-meta?",-1578417082));
var ___$1 = this;
var form = om.core.get_shared.call(null,self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flat-form","flat-form",-468858211)], null));
var language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var map__22630 = self__.cursor;
var map__22630__$1 = ((((!((map__22630 == null)))?((((map__22630.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22630.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22630):map__22630);
var id = cljs.core.get.call(null,map__22630__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var data = cljs.core.get.call(null,map__22630__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var dataset_info = cljs.core.get.call(null,map__22630__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var cur_rank = cljs.core.get.call(null,data,hatti.constants._rank);
var instance_id = cljs.core.get.call(null,data,"_id");
var sdatetime = moment(cljs.core.get.call(null,data,"_submission_time"));
var map__22631 = hatti.views.record.submission_elements.call(null,self__.view);
var map__22631__$1 = ((((!((map__22631 == null)))?((((map__22631.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22631.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22631):map__22631);
var top_level_wrap = cljs.core.get.call(null,map__22631__$1,new cljs.core.Keyword(null,"top-level-wrap","top-level-wrap",366303456));
var topbar_wrap = cljs.core.get.call(null,map__22631__$1,new cljs.core.Keyword(null,"topbar-wrap","topbar-wrap",1084926998));
var header_wrap = cljs.core.get.call(null,map__22631__$1,new cljs.core.Keyword(null,"header-wrap","header-wrap",517152474));
var section_wrap = cljs.core.get.call(null,map__22631__$1,new cljs.core.Keyword(null,"section-wrap","section-wrap",28486716));
var submission_info_wrap = cljs.core.get.call(null,map__22631__$1,new cljs.core.Keyword(null,"submission-info-wrap","submission-info-wrap",-1360099904));
var h4_cls = cljs.core.get.call(null,map__22631__$1,new cljs.core.Keyword(null,"h4-cls","h4-cls",-1006591520));
return sablono.interpreter.interpret.call(null,(cljs.core.truth_((function (){var or__6409__auto__ = data;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id;
}
})())?top_level_wrap.call(null,topbar_wrap.call(null,hatti.views.record.submission_arrow.call(null,new cljs.core.Keyword(null,"left","left",-399115937),cur_rank,self__.view),hatti.views.record.submission_arrow.call(null,new cljs.core.Keyword(null,"right","right",-452581833),cur_rank,self__.view),om.core.build.call(null,hatti.views.print_xls_report_btn,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"instance-id","instance-id",951361263),instance_id,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),dataset_info], null)),hatti.views.record.submission_closer.call(null)),(cljs.core.truth_(data)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),header_wrap.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),h4_cls], null),[cljs.core.str("ID: "),cljs.core.str(instance_id)].join(''),hatti.views.record.header_note.call(null,self__.view,self__.cursor)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),[cljs.core.str("Submitted at "),cljs.core.str(sdatetime.format("LT")),cljs.core.str(" on "),cljs.core.str(sdatetime.format("ll"))].join(''),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"br","br",934104792)], null),om.core.build.call(null,hatti.views.edit_delete,instance_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),self__.opts], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.expand-meta.right","span.expand-meta.right",1357089760),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"href","href",-793805698),"#",new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (form,language,map__22630,map__22630__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22631,map__22631__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22628,map__22628__$1,expand_meta_QMARK_,map__22622,map__22622__$1,opts,view){
return (function (){
return om.core.update_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"expand-meta?","expand-meta?",-1578417082),cljs.core.not);
});})(form,language,map__22630,map__22630__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22631,map__22631__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22628,map__22628__$1,expand_meta_QMARK_,map__22622,map__22622__$1,opts,view))
)], null),(cljs.core.truth_(expand_meta_QMARK_)?"Hide Metadata":"Show Metadata")], null)], null)], null)),submission_info_wrap.call(null,(cljs.core.truth_(expand_meta_QMARK_)?section_wrap.call(null,(function (){var iter__7189__auto__ = ((function (form,language,map__22630,map__22630__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22631,map__22631__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22628,map__22628__$1,expand_meta_QMARK_,map__22622,map__22622__$1,opts,view){
return (function hatti$views$record$iter__22634(s__22635){
return (new cljs.core.LazySeq(null,((function (form,language,map__22630,map__22630__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22631,map__22631__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22628,map__22628__$1,expand_meta_QMARK_,map__22622,map__22622__$1,opts,view){
return (function (){
var s__22635__$1 = s__22635;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22635__$1);
if(temp__4657__auto__){
var s__22635__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22635__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22635__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22637 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22636 = (0);
while(true){
if((i__22636 < size__7188__auto__)){
var q = cljs.core._nth.call(null,c__7187__auto__,i__22636);
cljs.core.chunk_append.call(null,b__22637,hatti.views.record.format_as_question_answer.call(null,self__.view,q,data,language));

var G__22642 = (i__22636 + (1));
i__22636 = G__22642;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22637),hatti$views$record$iter__22634.call(null,cljs.core.chunk_rest.call(null,s__22635__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22637),null);
}
} else {
var q = cljs.core.first.call(null,s__22635__$2);
return cljs.core.cons.call(null,hatti.views.record.format_as_question_answer.call(null,self__.view,q,data,language),hatti$views$record$iter__22634.call(null,cljs.core.rest.call(null,s__22635__$2)));
}
} else {
return null;
}
break;
}
});})(form,language,map__22630,map__22630__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22631,map__22631__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22628,map__22628__$1,expand_meta_QMARK_,map__22622,map__22622__$1,opts,view))
,null,null));
});})(form,language,map__22630,map__22630__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22631,map__22631__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22628,map__22628__$1,expand_meta_QMARK_,map__22622,map__22622__$1,opts,view))
;
return iter__7189__auto__.call(null,hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),true));
})()):null),section_wrap.call(null,(function (){var iter__7189__auto__ = ((function (form,language,map__22630,map__22630__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22631,map__22631__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22628,map__22628__$1,expand_meta_QMARK_,map__22622,map__22622__$1,opts,view){
return (function hatti$views$record$iter__22638(s__22639){
return (new cljs.core.LazySeq(null,((function (form,language,map__22630,map__22630__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22631,map__22631__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22628,map__22628__$1,expand_meta_QMARK_,map__22622,map__22622__$1,opts,view){
return (function (){
var s__22639__$1 = s__22639;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22639__$1);
if(temp__4657__auto__){
var s__22639__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22639__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22639__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22641 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22640 = (0);
while(true){
if((i__22640 < size__7188__auto__)){
var q = cljs.core._nth.call(null,c__7187__auto__,i__22640);
cljs.core.chunk_append.call(null,b__22641,hatti.views.record.format_as_question_answer.call(null,self__.view,q,data,language));

var G__22643 = (i__22640 + (1));
i__22640 = G__22643;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22641),hatti$views$record$iter__22638.call(null,cljs.core.chunk_rest.call(null,s__22639__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22641),null);
}
} else {
var q = cljs.core.first.call(null,s__22639__$2);
return cljs.core.cons.call(null,hatti.views.record.format_as_question_answer.call(null,self__.view,q,data,language),hatti$views$record$iter__22638.call(null,cljs.core.rest.call(null,s__22639__$2)));
}
} else {
return null;
}
break;
}
});})(form,language,map__22630,map__22630__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22631,map__22631__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22628,map__22628__$1,expand_meta_QMARK_,map__22622,map__22622__$1,opts,view))
,null,null));
});})(form,language,map__22630,map__22630__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22631,map__22631__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22628,map__22628__$1,expand_meta_QMARK_,map__22622,map__22622__$1,opts,view))
;
return iter__7189__auto__.call(null,hatti.ona.forms.non_meta_fields.call(null,form));
})()))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.t-center","div.t-center",150921790),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-spinner.fa-pulse","i.fa.fa-spinner.fa-pulse",869871146)], null),"Loading data..."], null)], null))):null));
});})(map__22622,map__22622__$1,opts,view))
;

hatti.views.record.t_hatti$views$record22624.getBasis = ((function (map__22622,map__22622__$1,opts,view){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__22621","p__22621",-1357951398,null),new cljs.core.Symbol(null,"map__22622","map__22622",-1144453424,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"view","view",-1406440955,null),new cljs.core.Symbol(null,"meta22625","meta22625",-2125609587,null)], null);
});})(map__22622,map__22622__$1,opts,view))
;

hatti.views.record.t_hatti$views$record22624.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record22624.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record22624";

hatti.views.record.t_hatti$views$record22624.cljs$lang$ctorPrWriter = ((function (map__22622,map__22622__$1,opts,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.record/t_hatti$views$record22624");
});})(map__22622,map__22622__$1,opts,view))
;

hatti.views.record.__GT_t_hatti$views$record22624 = ((function (map__22622,map__22622__$1,opts,view){
return (function hatti$views$record$__GT_t_hatti$views$record22624(cursor__$1,owner__$1,p__22621__$1,map__22622__$2,opts__$1,view__$1,meta22625){
return (new hatti.views.record.t_hatti$views$record22624(cursor__$1,owner__$1,p__22621__$1,map__22622__$2,opts__$1,view__$1,meta22625));
});})(map__22622,map__22622__$1,opts,view))
;

}

return (new hatti.views.record.t_hatti$views$record22624(cursor,owner,p__22621,map__22622__$1,opts,view,cljs.core.PersistentArrayMap.EMPTY));
}));
