// Compiled by ClojureScript 1.9.229 {}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__7072__auto__ = (((x == null))?null:x);
var m__7073__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,x);
} else {
var m__7073__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return c2.dom.select.call(null,selector);
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render.call(null,v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args21616 = [];
var len__7484__auto___21619 = arguments.length;
var i__7485__auto___21620 = (0);
while(true){
if((i__7485__auto___21620 < len__7484__auto___21619)){
args21616.push((arguments[i__7485__auto___21620]));

var G__21621 = (i__7485__auto___21620 + (1));
i__7485__auto___21620 = G__21621;
continue;
} else {
}
break;
}

var G__21618 = args21616.length;
switch (G__21618) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21616.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;

/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args21623 = [];
var len__7484__auto___21626 = arguments.length;
var i__7485__auto___21627 = (0);
while(true){
if((i__7485__auto___21627 < len__7484__auto___21626)){
args21623.push((arguments[i__7485__auto___21627]));

var G__21628 = (i__7485__auto___21627 + (1));
i__7485__auto___21627 = G__21628;
continue;
} else {
}
break;
}

var G__21625 = args21623.length;
switch (G__21625) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21623.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;

/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom.call(null,node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom.call(null,node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.appendChild(c2.dom.__GT_dom.call(null,container),el__$1);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.insertChildAt(c2.dom.__GT_dom.call(null,container),el__$1,(0));

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
return goog.dom.removeNode(c2.dom.__GT_dom.call(null,el));
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom.call(null,new$);
goog.dom.replaceNode(new$__$1,c2.dom.__GT_dom.call(null,old));

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args21630 = [];
var len__7484__auto___21643 = arguments.length;
var i__7485__auto___21644 = (0);
while(true){
if((i__7485__auto___21644 < len__7484__auto___21643)){
args21630.push((arguments[i__7485__auto___21644]));

var G__21645 = (i__7485__auto___21644 + (1));
i__7485__auto___21644 = G__21645;
continue;
} else {
}
break;
}

var G__21632 = args21630.length;
switch (G__21632) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21630.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return goog.style.getComputedStyle(el__$1,cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__21633_21647 = cljs.core.seq.call(null,x);
var chunk__21634_21648 = null;
var count__21635_21649 = (0);
var i__21636_21650 = (0);
while(true){
if((i__21636_21650 < count__21635_21649)){
var vec__21637_21651 = cljs.core._nth.call(null,chunk__21634_21648,i__21636_21650);
var k_21652 = cljs.core.nth.call(null,vec__21637_21651,(0),null);
var v_21653 = cljs.core.nth.call(null,vec__21637_21651,(1),null);
c2.dom.style.call(null,el__$1,k_21652,v_21653);

var G__21654 = seq__21633_21647;
var G__21655 = chunk__21634_21648;
var G__21656 = count__21635_21649;
var G__21657 = (i__21636_21650 + (1));
seq__21633_21647 = G__21654;
chunk__21634_21648 = G__21655;
count__21635_21649 = G__21656;
i__21636_21650 = G__21657;
continue;
} else {
var temp__4657__auto___21658 = cljs.core.seq.call(null,seq__21633_21647);
if(temp__4657__auto___21658){
var seq__21633_21659__$1 = temp__4657__auto___21658;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21633_21659__$1)){
var c__7220__auto___21660 = cljs.core.chunk_first.call(null,seq__21633_21659__$1);
var G__21661 = cljs.core.chunk_rest.call(null,seq__21633_21659__$1);
var G__21662 = c__7220__auto___21660;
var G__21663 = cljs.core.count.call(null,c__7220__auto___21660);
var G__21664 = (0);
seq__21633_21647 = G__21661;
chunk__21634_21648 = G__21662;
count__21635_21649 = G__21663;
i__21636_21650 = G__21664;
continue;
} else {
var vec__21640_21665 = cljs.core.first.call(null,seq__21633_21659__$1);
var k_21666 = cljs.core.nth.call(null,vec__21640_21665,(0),null);
var v_21667 = cljs.core.nth.call(null,vec__21640_21665,(1),null);
c2.dom.style.call(null,el__$1,k_21666,v_21667);

var G__21668 = cljs.core.next.call(null,seq__21633_21659__$1);
var G__21669 = null;
var G__21670 = (0);
var G__21671 = (0);
seq__21633_21647 = G__21668;
chunk__21634_21648 = G__21669;
count__21635_21649 = G__21670;
i__21636_21650 = G__21671;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
goog.style.setStyle(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,k),((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"height","height",1025178622),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null).call(null,cljs.core.keyword.call(null,k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null)));

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args21672 = [];
var len__7484__auto___21689 = arguments.length;
var i__7485__auto___21690 = (0);
while(true){
if((i__7485__auto___21690 < len__7484__auto___21689)){
args21672.push((arguments[i__7485__auto___21690]));

var G__21691 = (i__7485__auto___21690 + (1));
i__7485__auto___21690 = G__21691;
continue;
} else {
}
break;
}

var G__21674 = args21672.length;
switch (G__21674) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21672.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom.call(null,el).attributes;
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (attrs){
return (function c2$dom$iter__21675(s__21676){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__21676__$1 = s__21676;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21676__$1);
if(temp__4657__auto__){
var s__21676__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21676__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__21676__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__21678 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__21677 = (0);
while(true){
if((i__21677 < size__7188__auto__)){
var i = cljs.core._nth.call(null,c__7187__auto__,i__21677);
cljs.core.chunk_append.call(null,b__21678,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null));

var G__21693 = (i__21677 + (1));
i__21677 = G__21693;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21678),c2$dom$iter__21675.call(null,cljs.core.chunk_rest.call(null,s__21676__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21678),null);
}
} else {
var i = cljs.core.first.call(null,s__21676__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__21675.call(null,cljs.core.rest.call(null,s__21676__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__7189__auto__.call(null,cljs.core.range.call(null,attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__21679_21694 = cljs.core.seq.call(null,x);
var chunk__21680_21695 = null;
var count__21681_21696 = (0);
var i__21682_21697 = (0);
while(true){
if((i__21682_21697 < count__21681_21696)){
var vec__21683_21698 = cljs.core._nth.call(null,chunk__21680_21695,i__21682_21697);
var k_21699 = cljs.core.nth.call(null,vec__21683_21698,(0),null);
var v_21700 = cljs.core.nth.call(null,vec__21683_21698,(1),null);
c2.dom.attr.call(null,el__$1,k_21699,v_21700);

var G__21701 = seq__21679_21694;
var G__21702 = chunk__21680_21695;
var G__21703 = count__21681_21696;
var G__21704 = (i__21682_21697 + (1));
seq__21679_21694 = G__21701;
chunk__21680_21695 = G__21702;
count__21681_21696 = G__21703;
i__21682_21697 = G__21704;
continue;
} else {
var temp__4657__auto___21705 = cljs.core.seq.call(null,seq__21679_21694);
if(temp__4657__auto___21705){
var seq__21679_21706__$1 = temp__4657__auto___21705;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21679_21706__$1)){
var c__7220__auto___21707 = cljs.core.chunk_first.call(null,seq__21679_21706__$1);
var G__21708 = cljs.core.chunk_rest.call(null,seq__21679_21706__$1);
var G__21709 = c__7220__auto___21707;
var G__21710 = cljs.core.count.call(null,c__7220__auto___21707);
var G__21711 = (0);
seq__21679_21694 = G__21708;
chunk__21680_21695 = G__21709;
count__21681_21696 = G__21710;
i__21682_21697 = G__21711;
continue;
} else {
var vec__21686_21712 = cljs.core.first.call(null,seq__21679_21706__$1);
var k_21713 = cljs.core.nth.call(null,vec__21686_21712,(0),null);
var v_21714 = cljs.core.nth.call(null,vec__21686_21712,(1),null);
c2.dom.attr.call(null,el__$1,k_21713,v_21714);

var G__21715 = cljs.core.next.call(null,seq__21679_21706__$1);
var G__21716 = null;
var G__21717 = (0);
var G__21718 = (0);
seq__21679_21694 = G__21715;
chunk__21680_21695 = G__21716;
count__21681_21696 = G__21717;
i__21682_21697 = G__21718;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name.call(null,k));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"style","style",-496642736),k)){
c2.dom.style.call(null,el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name.call(null,k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args21719 = [];
var len__7484__auto___21722 = arguments.length;
var i__7485__auto___21723 = (0);
while(true){
if((i__7485__auto___21723 < len__7484__auto___21722)){
args21719.push((arguments[i__7485__auto___21723]));

var G__21724 = (i__7485__auto___21723 + (1));
i__7485__auto___21723 = G__21724;
continue;
} else {
}
break;
}

var G__21721 = args21719.length;
switch (G__21721) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21719.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.getTextContent(c2.dom.__GT_dom.call(null,el));
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;

/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args21726 = [];
var len__7484__auto___21729 = arguments.length;
var i__7485__auto___21730 = (0);
while(true){
if((i__7485__auto___21730 < len__7484__auto___21729)){
args21726.push((arguments[i__7485__auto___21730]));

var G__21731 = (i__7485__auto___21730 + (1));
i__7485__auto___21730 = G__21731;
continue;
} else {
}
break;
}

var G__21728 = args21726.length;
switch (G__21728) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21726.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.forms.getValue(c2.dom.__GT_dom.call(null,el));
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;

/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
goog.dom.classes.enable(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,class$),classed_QMARK_);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6409__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return ((function (or__6409__auto____$1,or__6409__auto__){
return (function (p1__21733_SHARP_){
return setTimeout(((function (or__6409__auto____$1,or__6409__auto__){
return (function (){
return p1__21733_SHARP_.call(null);
});})(or__6409__auto____$1,or__6409__auto__))
,(10));
});
;})(or__6409__auto____$1,or__6409__auto__))
}
}
})();
