// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0))], 0))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__38429_SHARP_){
if(typeof p1__38429_SHARP_ === 'string'){
return clojure.string.lower_case(p1__38429_SHARP_);
} else {
return p1__38429_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__38435){
var vec__38436 = p__38435;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38436,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38436,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,cljs.core.array_seq([cljs.core.cst$kw$compact_QMARK_,true], 0));
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__38430_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__38430_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
var media_count = dataContext._media_count;
var total_media = dataContext._total_media;
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,chimera.string.escape_for_type(clj_value),cljs.core.array_seq([cljs.core.cst$kw$language,language,cljs.core.cst$kw$compact_QMARK_,true,cljs.core.cst$kw$field_DASH_key,field_key,cljs.core.cst$kw$media_DASH_count,media_count,cljs.core.cst$kw$total_DASH_media,total_media], 0));
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__38439 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__38439__$1 = ((((!((map__38439 == null)))?((((map__38439.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38439.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38439):map__38439);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38439__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38439__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38439__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$delete_DASH_record,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$data_DASH_id,value], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip$middle_DASH_right,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_eye,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.select_unselect_all_records_id = "select-unselect-all-records";
hatti.views.table.select_unselect_all_records_element = [cljs.core.str("<input type=\"checkbox\" id=\""),cljs.core.str(hatti.views.table.select_unselect_all_records_id),cljs.core.str("\">")].join('');
hatti.views.table.delete_record_class = "delete-record";
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(100),hatti.views.table.select_unselect_all_records_element,(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38472 = arguments.length;
var i__7485__auto___38473 = (0);
while(true){
if((i__7485__auto___38473 < len__7484__auto___38472)){
args__7491__auto__.push((arguments[i__7485__auto___38473]));

var G__38474 = (i__7485__auto___38473 + (1));
i__7485__auto___38473 = G__38474;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__38444){
var map__38445 = p__38444;
var map__38445__$1 = ((((!((map__38445 == null)))?((((map__38445.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38445.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38445):map__38445);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38445__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var get_label_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38445__$1,cljs.core.cst$kw$get_DASH_label_QMARK_,true);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38445__$1,cljs.core.cst$kw$language);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38445__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = (function (){var G__38447 = cljs.core.false_QMARK_;
var G__38448 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__38447,map__38445,map__38445__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__38441_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__38441_SHARP_)) == null);
});})(G__38447,map__38445,map__38445__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,form);
return (chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__38447,G__38448) : chimera.core.any_QMARK_.call(null,G__38447,G__38448));
})();
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__38445,map__38445__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__38449(s__38450){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__38445,map__38445__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__38450__$1 = s__38450;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38450__$1);
if(temp__4657__auto__){
var s__38450__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38450__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38450__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38452 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38451 = (0);
while(true){
if((i__38451 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38451);
cljs.core.chunk_append(b__38452,(function (){var map__38463 = field;
var map__38463__$1 = ((((!((map__38463 == null)))?((((map__38463.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38463.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38463):map__38463);
var map__38464 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38463__$1,cljs.core.cst$kw$instance);
var map__38464__$1 = ((((!((map__38464 == null)))?((((map__38464.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38464.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38464):map__38464);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38464__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38463__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38463__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38463__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__38475 = (i__38451 + (1));
i__38451 = G__38475;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38452),hatti$views$table$iter__38449(cljs.core.chunk_rest(s__38450__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38452),null);
}
} else {
var field = cljs.core.first(s__38450__$2);
return cljs.core.cons((function (){var map__38467 = field;
var map__38467__$1 = ((((!((map__38467 == null)))?((((map__38467.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38467.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38467):map__38467);
var map__38468 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38467__$1,cljs.core.cst$kw$instance);
var map__38468__$1 = ((((!((map__38468 == null)))?((((map__38468.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38468.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38468):map__38468);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38468__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38467__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38467__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38467__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__38449(cljs.core.rest(s__38450__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__38445,map__38445__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__38445,map__38445__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__(hatti.views.table.all_fields(form));
})();
return cljs.core.clj__GT_js((function (){var G__38471 = columns;
if(cljs.core.not(hide_actions_column_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__38471,hatti.views.table.actions_column(owner,has_hxl_QMARK_));
} else {
return G__38471;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq38442){
var G__38443 = cljs.core.first(seq38442);
var seq38442__$1 = cljs.core.next(seq38442);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__38443,seq38442__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__38477 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__38477);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38496(s__38497){
return (new cljs.core.LazySeq(null,(function (){
var s__38497__$1 = s__38497;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38497__$1);
if(temp__4657__auto__){
var s__38497__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38497__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38497__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38499 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38498 = (0);
while(true){
if((i__38498 < size__7188__auto__)){
var vec__38508 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38498);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38508,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38508,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__38499,event.subscribe(handler_function));

var G__38514 = (i__38498 + (1));
i__38498 = G__38514;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38499),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38496(cljs.core.chunk_rest(s__38497__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38499),null);
}
} else {
var vec__38511 = cljs.core.first(s__38497__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38511,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38511,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38496(cljs.core.rest(s__38497__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38533(s__38534){
return (new cljs.core.LazySeq(null,(function (){
var s__38534__$1 = s__38534;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38534__$1);
if(temp__4657__auto__){
var s__38534__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38534__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38534__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38536 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38535 = (0);
while(true){
if((i__38535 < size__7188__auto__)){
var vec__38545 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38535);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38545,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38545,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__38536,event.subscribe(handler_function));

var G__38551 = (i__38535 + (1));
i__38535 = G__38551;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38536),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38533(cljs.core.chunk_rest(s__38534__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38536),null);
}
} else {
var vec__38548 = cljs.core.first(s__38534__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38548,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38548,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38533(cljs.core.rest(s__38534__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.update_data_to_be_deleted_vector = (function hatti$views$table$update_data_to_be_deleted_vector(checked_QMARK_,data_id){
var map__38554 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38554__$1 = ((((!((map__38554 == null)))?((((map__38554.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38554.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38554):map__38554);
var data_to_be_deleted = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38554__$1,cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted);
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted], null),((function (map__38554,map__38554__$1,data_to_be_deleted,fn){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(data_to_be_deleted,data_id) : fn.call(null,data_to_be_deleted,data_id));
});})(map__38554,map__38554__$1,data_to_be_deleted,fn))
);
});
hatti.views.table.get_elements_count_by_selector = (function hatti$views$table$get_elements_count_by_selector(selector){
return document.querySelectorAll(selector).length;
});
hatti.views.table.check_select_unselect_all_records_element_QMARK_ = (function hatti$views$table$check_select_unselect_all_records_element_QMARK_(){
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
var selected_rows_count = hatti.views.table.get_elements_count_by_selector([cljs.core.str(delete_record_class_selector),cljs.core.str(":checked")].join(''));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected_rows_count,total_rows_count);
});
hatti.views.table.get_checkbox_selector = (function hatti$views$table$get_checkbox_selector(data_id){
return [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class),cljs.core.str("[data-id=\""),cljs.core.str(data_id),cljs.core.str("\"]")].join('');
});
hatti.views.table.get_delete_checkbox_by_data_id = (function hatti$views$table$get_delete_checkbox_by_data_id(data_id){
var selector = hatti.views.table.get_checkbox_selector(data_id);
return document.querySelector(selector);
});
hatti.views.table.select_rows_marked_to_be_deleted = (function hatti$views$table$select_rows_marked_to_be_deleted(){
var seq__38560 = cljs.core.seq(cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var chunk__38561 = null;
var count__38562 = (0);
var i__38563 = (0);
while(true){
if((i__38563 < count__38562)){
var data_id = chunk__38561.cljs$core$IIndexed$_nth$arity$2(null,i__38563);
var element_38564 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38564.checked = true;

var G__38565 = seq__38560;
var G__38566 = chunk__38561;
var G__38567 = count__38562;
var G__38568 = (i__38563 + (1));
seq__38560 = G__38565;
chunk__38561 = G__38566;
count__38562 = G__38567;
i__38563 = G__38568;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__38560);
if(temp__4657__auto__){
var seq__38560__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38560__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__38560__$1);
var G__38569 = cljs.core.chunk_rest(seq__38560__$1);
var G__38570 = c__7220__auto__;
var G__38571 = cljs.core.count(c__7220__auto__);
var G__38572 = (0);
seq__38560 = G__38569;
chunk__38561 = G__38570;
count__38562 = G__38571;
i__38563 = G__38572;
continue;
} else {
var data_id = cljs.core.first(seq__38560__$1);
var element_38573 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38573.checked = true;

var G__38574 = cljs.core.next(seq__38560__$1);
var G__38575 = null;
var G__38576 = (0);
var G__38577 = (0);
seq__38560 = G__38574;
chunk__38561 = G__38575;
count__38562 = G__38576;
i__38563 = G__38577;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.higlight_rows_marked_to_be_deleted = (function hatti$views$table$higlight_rows_marked_to_be_deleted(grid){
var checkboxes = document.getElementsByClassName(hatti.views.table.delete_record_class);
var indexes_of_selected_checkboxes = cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (checkboxes){
return (function (index,checkbox){
if(cljs.core.truth_(checkbox.checked)){
return index;
} else {
return null;
}
});})(checkboxes))
,checkboxes)));
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (checkboxes,indexes_of_selected_checkboxes){
return (function (){
return cljs.core.identity(indexes_of_selected_checkboxes);
});})(checkboxes,indexes_of_selected_checkboxes))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(indexes_of_selected_checkboxes));
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__38578){
var map__38597 = p__38578;
var map__38597__$1 = ((((!((map__38597 == null)))?((((map__38597.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38597.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38597):map__38597);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38597__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38597__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var map__38599 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38599__$1 = ((((!((map__38599 == null)))?((((map__38599.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38599.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38599):map__38599);
var map__38600 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38599__$1,cljs.core.cst$kw$table_DASH_page);
var map__38600__$1 = ((((!((map__38600 == null)))?((((map__38600.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38600.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38600):map__38600);
var map__38601 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38600__$1,cljs.core.cst$kw$paging);
var map__38601__$1 = ((((!((map__38601 == null)))?((((map__38601.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38601.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38601):map__38601);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38601__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38601__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38600__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$language,current_language,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,hide_actions_column_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

grid.setSelectionModel((new Slick.RowSelectionModel(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selectActiveRow,false], null)))));

dataview.onRowCountChanged.subscribe(((function (map__38599,map__38599__$1,map__38600,map__38600__$1,map__38601,map__38601__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38597,map__38597__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__38599,map__38599__$1,map__38600,map__38600__$1,map__38601,map__38601__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38597,map__38597__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__38599,map__38599__$1,map__38600,map__38600__$1,map__38601,map__38601__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38597,map__38597__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

grid.render();

hatti.views.table.select_rows_marked_to_be_deleted();

return hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
});})(map__38599,map__38599__$1,map__38600,map__38600__$1,map__38601,map__38601__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38597,map__38597__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onHeaderClick.subscribe(((function (map__38599,map__38599__$1,map__38600,map__38600__$1,map__38601,map__38601__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38597,map__38597__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var target = e.target;
var id = target.id;
var checked_QMARK_ = target.checked;
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hatti.views.table.select_unselect_all_records_id,id)){
var records_to_be_deleted = document.getElementsByClassName(hatti.views.table.delete_record_class);
var seq__38605_38615 = cljs.core.seq(records_to_be_deleted);
var chunk__38606_38616 = null;
var count__38607_38617 = (0);
var i__38608_38618 = (0);
while(true){
if((i__38608_38618 < count__38607_38617)){
var record_38619 = chunk__38606_38616.cljs$core$IIndexed$_nth$arity$2(null,i__38608_38618);
record_38619.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38609 = record_38619.getAttribute("data-id");
return parseInt(G__38609);
})());

var G__38620 = seq__38605_38615;
var G__38621 = chunk__38606_38616;
var G__38622 = count__38607_38617;
var G__38623 = (i__38608_38618 + (1));
seq__38605_38615 = G__38620;
chunk__38606_38616 = G__38621;
count__38607_38617 = G__38622;
i__38608_38618 = G__38623;
continue;
} else {
var temp__4657__auto___38624 = cljs.core.seq(seq__38605_38615);
if(temp__4657__auto___38624){
var seq__38605_38625__$1 = temp__4657__auto___38624;
if(cljs.core.chunked_seq_QMARK_(seq__38605_38625__$1)){
var c__7220__auto___38626 = cljs.core.chunk_first(seq__38605_38625__$1);
var G__38627 = cljs.core.chunk_rest(seq__38605_38625__$1);
var G__38628 = c__7220__auto___38626;
var G__38629 = cljs.core.count(c__7220__auto___38626);
var G__38630 = (0);
seq__38605_38615 = G__38627;
chunk__38606_38616 = G__38628;
count__38607_38617 = G__38629;
i__38608_38618 = G__38630;
continue;
} else {
var record_38631 = cljs.core.first(seq__38605_38625__$1);
record_38631.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38610 = record_38631.getAttribute("data-id");
return parseInt(G__38610);
})());

var G__38632 = cljs.core.next(seq__38605_38625__$1);
var G__38633 = null;
var G__38634 = (0);
var G__38635 = (0);
seq__38605_38615 = G__38632;
chunk__38606_38616 = G__38633;
count__38607_38617 = G__38634;
i__38608_38618 = G__38635;
continue;
}
} else {
}
}
break;
}

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38599,map__38599__$1,map__38600,map__38600__$1,map__38601,map__38601__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38597,map__38597__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
if(cljs.core.truth_(checked_QMARK_)){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1(total_rows_count);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});})(records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38599,map__38599__$1,map__38600,map__38600__$1,map__38601,map__38601__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38597,map__38597__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
return null;
}
});})(map__38599,map__38599__$1,map__38600,map__38600__$1,map__38601,map__38601__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38597,map__38597__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__38599,map__38599__$1,map__38600,map__38600__$1,map__38601,map__38601__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38597,map__38597__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(map__38599,map__38599__$1,map__38600,map__38600__$1,map__38601,map__38601__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38597,map__38597__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__38599,map__38599__$1,map__38600,map__38600__$1,map__38601,map__38601__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38597,map__38597__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var class_name = elem.className;
var checked_QMARK_ = elem.checked;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__38612 = elem.getAttribute("data-id");
return parseInt(G__38612);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
var select_unselect_all_records_chkbox = document.getElementById(hatti.views.table.select_unselect_all_records_id);
var map__38611 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38611__$1 = ((((!((map__38611 == null)))?((((map__38611.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38611.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38611):map__38611);
var selected_table_rows = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38611__$1,cljs.core.cst$kw$selected_DASH_table_DASH_rows);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(class_name,hatti.views.table.delete_record_class)){
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
var row__$1 = (function (){var G__38614 = grid.getCellFromEvent(e).row;
return parseInt(G__38614);
})();
hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,data_id);

select_unselect_all_records_chkbox.checked = hatti.views.table.check_select_unselect_all_records_element_QMARK_();

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38611,map__38611__$1,selected_table_rows,map__38599,map__38599__$1,map__38600,map__38600__$1,map__38601,map__38601__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38597,map__38597__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(selected_table_rows,row__$1) : fn.call(null,selected_table_rows,row__$1));
});})(fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38611,map__38611__$1,selected_table_rows,map__38599,map__38599__$1,map__38600,map__38600__$1,map__38601,map__38601__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38597,map__38597__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
}
});})(map__38599,map__38599__$1,map__38600,map__38600__$1,map__38601,map__38601__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38597,map__38597__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__13216__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,event_chan){
return (function (state_38927){
var state_val_38928 = (state_38927[(1)]);
if((state_val_38928 === (7))){
var inst_38825 = (state_38927[(7)]);
var inst_38825__$1 = (state_38927[(2)]);
var inst_38827 = (inst_38825__$1 == null);
var inst_38828 = cljs.core.not(inst_38827);
var state_38927__$1 = (function (){var statearr_38929 = state_38927;
(statearr_38929[(7)] = inst_38825__$1);

return statearr_38929;
})();
if(inst_38828){
var statearr_38930_39005 = state_38927__$1;
(statearr_38930_39005[(1)] = (8));

} else {
var statearr_38931_39006 = state_38927__$1;
(statearr_38931_39006[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (20))){
var inst_38847 = (state_38927[(8)]);
var inst_38855 = (state_38927[(9)]);
var inst_38864 = (inst_38855.cljs$core$IFn$_invoke$arity$1 ? inst_38855.cljs$core$IFn$_invoke$arity$1(inst_38847) : inst_38855.call(null,inst_38847));
var state_38927__$1 = state_38927;
var statearr_38932_39007 = state_38927__$1;
(statearr_38932_39007[(2)] = inst_38864);

(statearr_38932_39007[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (27))){
var state_38927__$1 = state_38927;
var statearr_38933_39008 = state_38927__$1;
(statearr_38933_39008[(2)] = null);

(statearr_38933_39008[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (1))){
var state_38927__$1 = state_38927;
var statearr_38934_39009 = state_38927__$1;
(statearr_38934_39009[(2)] = null);

(statearr_38934_39009[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (24))){
var state_38927__$1 = state_38927;
var statearr_38935_39010 = state_38927__$1;
(statearr_38935_39010[(2)] = null);

(statearr_38935_39010[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (4))){
var state_38927__$1 = state_38927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38927__$1,(7),event_chan);
} else {
if((state_val_38928 === (15))){
var inst_38825 = (state_38927[(7)]);
var state_38927__$1 = state_38927;
var statearr_38936_39011 = state_38927__$1;
(statearr_38936_39011[(2)] = inst_38825);

(statearr_38936_39011[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (21))){
var state_38927__$1 = state_38927;
var statearr_38937_39012 = state_38927__$1;
(statearr_38937_39012[(2)] = null);

(statearr_38937_39012[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (31))){
var inst_38851 = (state_38927[(10)]);
var inst_38900 = (state_38927[(2)]);
var inst_38901 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38851,cljs.core.cst$kw$table);
var state_38927__$1 = (function (){var statearr_38938 = state_38927;
(statearr_38938[(11)] = inst_38900);

return statearr_38938;
})();
if(inst_38901){
var statearr_38939_39013 = state_38927__$1;
(statearr_38939_39013[(1)] = (32));

} else {
var statearr_38940_39014 = state_38927__$1;
(statearr_38940_39014[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (32))){
var inst_38847 = (state_38927[(8)]);
var inst_38856 = (state_38927[(12)]);
var inst_38851 = (state_38927[(10)]);
var inst_38855 = (state_38927[(9)]);
var inst_38850 = (state_38927[(13)]);
var inst_38846 = (state_38927[(14)]);
var inst_38848 = (state_38927[(15)]);
var inst_38849 = (state_38927[(16)]);
var inst_38845 = (state_38927[(17)]);
var inst_38914 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38915 = (function (){var map__38823 = inst_38845;
var new_columns = inst_38850;
var submission_clicked = inst_38847;
var submission_unclicked = inst_38848;
var get_submission_data = inst_38856;
var re_render = inst_38851;
var update_data_BANG_ = inst_38855;
var submission_to_rank = inst_38846;
var c__13216__auto____$1 = inst_38914;
var filter_by = inst_38849;
return ((function (map__38823,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,inst_38847,inst_38856,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38914,state_val_38928,c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (map__38823,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,inst_38847,inst_38856,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38914,state_val_38928,c__13216__auto__,event_chan){
return (function (state_38912){
var state_val_38913 = (state_38912[(1)]);
if((state_val_38913 === (1))){
var inst_38903 = cljs.core.async.timeout((20));
var state_38912__$1 = state_38912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38912__$1,(2),inst_38903);
} else {
if((state_val_38913 === (2))){
var inst_38905 = (state_38912[(2)]);
var inst_38906 = grid.resizeCanvas();
var inst_38907 = grid.invalidateAllRows();
var inst_38908 = hatti.views.table.resizeColumns(grid);
var inst_38909 = grid.render();
var inst_38910 = hatti.views.table.init_sg_pager(grid,dataview);
var state_38912__$1 = (function (){var statearr_38941 = state_38912;
(statearr_38941[(7)] = inst_38908);

(statearr_38941[(8)] = inst_38909);

(statearr_38941[(9)] = inst_38906);

(statearr_38941[(10)] = inst_38905);

(statearr_38941[(11)] = inst_38907);

return statearr_38941;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38912__$1,inst_38910);
} else {
return null;
}
}
});})(map__38823,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,inst_38847,inst_38856,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38914,state_val_38928,c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,map__38823,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,inst_38847,inst_38856,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38914,state_val_38928,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_38945 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38945[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_38945[(1)] = (1));

return statearr_38945;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_38912){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_38912);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e38946){if((e38946 instanceof Object)){
var ex__13108__auto__ = e38946;
var statearr_38947_39015 = state_38912;
(statearr_38947_39015[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38912);

return cljs.core.cst$kw$recur;
} else {
throw e38946;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39016 = state_38912;
state_38912 = G__39016;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_38912){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_38912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,map__38823,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,inst_38847,inst_38856,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38914,state_val_38928,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_38948 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_38948[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto____$1);

return statearr_38948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});
;})(map__38823,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,inst_38847,inst_38856,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38914,state_val_38928,c__13216__auto__,event_chan))
})();
var inst_38916 = cljs.core.async.impl.dispatch.run(inst_38915);
var state_38927__$1 = (function (){var statearr_38949 = state_38927;
(statearr_38949[(18)] = inst_38916);

return statearr_38949;
})();
var statearr_38950_39017 = state_38927__$1;
(statearr_38950_39017[(2)] = inst_38914);

(statearr_38950_39017[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (33))){
var state_38927__$1 = state_38927;
var statearr_38951_39018 = state_38927__$1;
(statearr_38951_39018[(2)] = null);

(statearr_38951_39018[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (13))){
var inst_38837 = (state_38927[(2)]);
var state_38927__$1 = state_38927;
var statearr_38952_39019 = state_38927__$1;
(statearr_38952_39019[(2)] = inst_38837);

(statearr_38952_39019[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (22))){
var inst_38848 = (state_38927[(15)]);
var inst_38867 = (state_38927[(2)]);
var state_38927__$1 = (function (){var statearr_38953 = state_38927;
(statearr_38953[(19)] = inst_38867);

return statearr_38953;
})();
if(cljs.core.truth_(inst_38848)){
var statearr_38954_39020 = state_38927__$1;
(statearr_38954_39020[(1)] = (23));

} else {
var statearr_38955_39021 = state_38927__$1;
(statearr_38955_39021[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (29))){
var inst_38849 = (state_38927[(16)]);
var inst_38892 = [cljs.core.cst$kw$query];
var inst_38893 = [inst_38849];
var inst_38894 = cljs.core.PersistentHashMap.fromArrays(inst_38892,inst_38893);
var inst_38895 = cljs.core.clj__GT_js(inst_38894);
var inst_38896 = dataview.setFilterArgs(inst_38895);
var inst_38897 = dataview.refresh();
var state_38927__$1 = (function (){var statearr_38956 = state_38927;
(statearr_38956[(20)] = inst_38896);

return statearr_38956;
})();
var statearr_38957_39022 = state_38927__$1;
(statearr_38957_39022[(2)] = inst_38897);

(statearr_38957_39022[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (6))){
var inst_38923 = (state_38927[(2)]);
var state_38927__$1 = state_38927;
var statearr_38958_39023 = state_38927__$1;
(statearr_38958_39023[(2)] = inst_38923);

(statearr_38958_39023[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (28))){
var inst_38849 = (state_38927[(16)]);
var inst_38890 = (state_38927[(2)]);
var state_38927__$1 = (function (){var statearr_38959 = state_38927;
(statearr_38959[(21)] = inst_38890);

return statearr_38959;
})();
if(cljs.core.truth_(inst_38849)){
var statearr_38960_39024 = state_38927__$1;
(statearr_38960_39024[(1)] = (29));

} else {
var statearr_38961_39025 = state_38927__$1;
(statearr_38961_39025[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (25))){
var inst_38850 = (state_38927[(13)]);
var inst_38872 = (state_38927[(2)]);
var state_38927__$1 = (function (){var statearr_38962 = state_38927;
(statearr_38962[(22)] = inst_38872);

return statearr_38962;
})();
if(cljs.core.truth_(inst_38850)){
var statearr_38963_39026 = state_38927__$1;
(statearr_38963_39026[(1)] = (26));

} else {
var statearr_38964_39027 = state_38927__$1;
(statearr_38964_39027[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (34))){
var inst_38919 = (state_38927[(2)]);
var state_38927__$1 = (function (){var statearr_38965 = state_38927;
(statearr_38965[(23)] = inst_38919);

return statearr_38965;
})();
var statearr_38966_39028 = state_38927__$1;
(statearr_38966_39028[(2)] = null);

(statearr_38966_39028[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (17))){
var inst_38856 = (state_38927[(12)]);
var inst_38855 = (state_38927[(9)]);
var inst_38846 = (state_38927[(14)]);
var inst_38858 = (inst_38856.cljs$core$IFn$_invoke$arity$2 ? inst_38856.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_38846) : inst_38856.call(null,hatti.constants._rank,inst_38846));
var inst_38859 = (inst_38855.cljs$core$IFn$_invoke$arity$1 ? inst_38855.cljs$core$IFn$_invoke$arity$1(inst_38858) : inst_38855.call(null,inst_38858));
var state_38927__$1 = state_38927;
var statearr_38967_39029 = state_38927__$1;
(statearr_38967_39029[(2)] = inst_38859);

(statearr_38967_39029[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (3))){
var inst_38925 = (state_38927[(2)]);
var state_38927__$1 = state_38927;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38927__$1,inst_38925);
} else {
if((state_val_38928 === (12))){
var state_38927__$1 = state_38927;
var statearr_38968_39030 = state_38927__$1;
(statearr_38968_39030[(2)] = false);

(statearr_38968_39030[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (2))){
var state_38927__$1 = state_38927;
var statearr_38969_39031 = state_38927__$1;
(statearr_38969_39031[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (23))){
var inst_38855 = (state_38927[(9)]);
var inst_38869 = (inst_38855.cljs$core$IFn$_invoke$arity$1 ? inst_38855.cljs$core$IFn$_invoke$arity$1(null) : inst_38855.call(null,null));
var state_38927__$1 = state_38927;
var statearr_38971_39032 = state_38927__$1;
(statearr_38971_39032[(2)] = inst_38869);

(statearr_38971_39032[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (19))){
var inst_38847 = (state_38927[(8)]);
var inst_38862 = (state_38927[(2)]);
var state_38927__$1 = (function (){var statearr_38972 = state_38927;
(statearr_38972[(24)] = inst_38862);

return statearr_38972;
})();
if(cljs.core.truth_(inst_38847)){
var statearr_38973_39033 = state_38927__$1;
(statearr_38973_39033[(1)] = (20));

} else {
var statearr_38974_39034 = state_38927__$1;
(statearr_38974_39034[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (11))){
var state_38927__$1 = state_38927;
var statearr_38975_39035 = state_38927__$1;
(statearr_38975_39035[(2)] = true);

(statearr_38975_39035[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (9))){
var state_38927__$1 = state_38927;
var statearr_38976_39036 = state_38927__$1;
(statearr_38976_39036[(2)] = false);

(statearr_38976_39036[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (5))){
var state_38927__$1 = state_38927;
var statearr_38977_39037 = state_38927__$1;
(statearr_38977_39037[(2)] = null);

(statearr_38977_39037[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (14))){
var inst_38825 = (state_38927[(7)]);
var inst_38842 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38825);
var state_38927__$1 = state_38927;
var statearr_38978_39038 = state_38927__$1;
(statearr_38978_39038[(2)] = inst_38842);

(statearr_38978_39038[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (26))){
var inst_38847 = (state_38927[(8)]);
var inst_38856 = (state_38927[(12)]);
var inst_38851 = (state_38927[(10)]);
var inst_38855 = (state_38927[(9)]);
var inst_38850 = (state_38927[(13)]);
var inst_38846 = (state_38927[(14)]);
var inst_38848 = (state_38927[(15)]);
var inst_38849 = (state_38927[(16)]);
var inst_38845 = (state_38927[(17)]);
var inst_38885 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38886 = (function (){var map__38823 = inst_38845;
var new_columns = inst_38850;
var submission_clicked = inst_38847;
var submission_unclicked = inst_38848;
var get_submission_data = inst_38856;
var re_render = inst_38851;
var update_data_BANG_ = inst_38855;
var submission_to_rank = inst_38846;
var c__13216__auto____$1 = inst_38885;
var filter_by = inst_38849;
return ((function (map__38823,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,inst_38847,inst_38856,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38885,state_val_38928,c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (map__38823,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,inst_38847,inst_38856,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38885,state_val_38928,c__13216__auto__,event_chan){
return (function (state_38883){
var state_val_38884 = (state_38883[(1)]);
if((state_val_38884 === (1))){
var inst_38874 = cljs.core.async.timeout((20));
var state_38883__$1 = state_38883;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38883__$1,(2),inst_38874);
} else {
if((state_val_38884 === (2))){
var inst_38876 = (state_38883[(2)]);
var inst_38877 = grid.setColumns(new_columns);
var inst_38878 = hatti.views.table.resizeColumns(grid);
var inst_38879 = grid.render();
var inst_38880 = hatti.views.table.select_rows_marked_to_be_deleted();
var inst_38881 = hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
var state_38883__$1 = (function (){var statearr_38979 = state_38883;
(statearr_38979[(7)] = inst_38878);

(statearr_38979[(8)] = inst_38880);

(statearr_38979[(9)] = inst_38879);

(statearr_38979[(10)] = inst_38877);

(statearr_38979[(11)] = inst_38876);

return statearr_38979;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38883__$1,inst_38881);
} else {
return null;
}
}
});})(map__38823,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,inst_38847,inst_38856,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38885,state_val_38928,c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,map__38823,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,inst_38847,inst_38856,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38885,state_val_38928,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_38983 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38983[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_38983[(1)] = (1));

return statearr_38983;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_38883){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_38883);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e38984){if((e38984 instanceof Object)){
var ex__13108__auto__ = e38984;
var statearr_38985_39039 = state_38883;
(statearr_38985_39039[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38883);

return cljs.core.cst$kw$recur;
} else {
throw e38984;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39040 = state_38883;
state_38883 = G__39040;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_38883){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_38883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,map__38823,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,inst_38847,inst_38856,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38885,state_val_38928,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_38986 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_38986[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto____$1);

return statearr_38986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});
;})(map__38823,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,inst_38847,inst_38856,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38885,state_val_38928,c__13216__auto__,event_chan))
})();
var inst_38887 = cljs.core.async.impl.dispatch.run(inst_38886);
var state_38927__$1 = (function (){var statearr_38987 = state_38927;
(statearr_38987[(25)] = inst_38887);

return statearr_38987;
})();
var statearr_38988_39041 = state_38927__$1;
(statearr_38988_39041[(2)] = inst_38885);

(statearr_38988_39041[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (16))){
var inst_38847 = (state_38927[(8)]);
var inst_38851 = (state_38927[(10)]);
var inst_38855 = (state_38927[(9)]);
var inst_38850 = (state_38927[(13)]);
var inst_38846 = (state_38927[(14)]);
var inst_38848 = (state_38927[(15)]);
var inst_38849 = (state_38927[(16)]);
var inst_38845 = (state_38927[(17)]);
var inst_38845__$1 = (state_38927[(2)]);
var inst_38846__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38845__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_38847__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38845__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_38848__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38845__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_38849__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38845__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_38850__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38845__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_38851__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38845__$1,cljs.core.cst$kw$re_DASH_render);
var inst_38852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38853 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_38854 = (new cljs.core.PersistentVector(null,3,(5),inst_38852,inst_38853,null));
var inst_38855__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_38854);
var inst_38856 = (function (){var map__38823 = inst_38845__$1;
var submission_to_rank = inst_38846__$1;
var submission_clicked = inst_38847__$1;
var submission_unclicked = inst_38848__$1;
var filter_by = inst_38849__$1;
var new_columns = inst_38850__$1;
var re_render = inst_38851__$1;
var update_data_BANG_ = inst_38855__$1;
return ((function (map__38823,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38847,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38845__$1,inst_38846__$1,inst_38847__$1,inst_38848__$1,inst_38849__$1,inst_38850__$1,inst_38851__$1,inst_38852,inst_38853,inst_38854,inst_38855__$1,state_val_38928,c__13216__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__38823,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38847,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38845__$1,inst_38846__$1,inst_38847__$1,inst_38848__$1,inst_38849__$1,inst_38850__$1,inst_38851__$1,inst_38852,inst_38853,inst_38854,inst_38855__$1,state_val_38928,c__13216__auto__,event_chan){
return (function (p1__38636_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__38636_SHARP_,field));
});})(map__38823,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38847,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38845__$1,inst_38846__$1,inst_38847__$1,inst_38848__$1,inst_38849__$1,inst_38850__$1,inst_38851__$1,inst_38852,inst_38853,inst_38854,inst_38855__$1,state_val_38928,c__13216__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(map__38823,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38847,inst_38851,inst_38855,inst_38850,inst_38846,inst_38848,inst_38849,inst_38845,inst_38845__$1,inst_38846__$1,inst_38847__$1,inst_38848__$1,inst_38849__$1,inst_38850__$1,inst_38851__$1,inst_38852,inst_38853,inst_38854,inst_38855__$1,state_val_38928,c__13216__auto__,event_chan))
})();
var state_38927__$1 = (function (){var statearr_38989 = state_38927;
(statearr_38989[(8)] = inst_38847__$1);

(statearr_38989[(12)] = inst_38856);

(statearr_38989[(10)] = inst_38851__$1);

(statearr_38989[(9)] = inst_38855__$1);

(statearr_38989[(13)] = inst_38850__$1);

(statearr_38989[(14)] = inst_38846__$1);

(statearr_38989[(15)] = inst_38848__$1);

(statearr_38989[(16)] = inst_38849__$1);

(statearr_38989[(17)] = inst_38845__$1);

return statearr_38989;
})();
if(cljs.core.truth_(inst_38846__$1)){
var statearr_38990_39042 = state_38927__$1;
(statearr_38990_39042[(1)] = (17));

} else {
var statearr_38991_39043 = state_38927__$1;
(statearr_38991_39043[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (30))){
var state_38927__$1 = state_38927;
var statearr_38992_39044 = state_38927__$1;
(statearr_38992_39044[(2)] = null);

(statearr_38992_39044[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (10))){
var inst_38840 = (state_38927[(2)]);
var state_38927__$1 = state_38927;
if(cljs.core.truth_(inst_38840)){
var statearr_38993_39045 = state_38927__$1;
(statearr_38993_39045[(1)] = (14));

} else {
var statearr_38994_39046 = state_38927__$1;
(statearr_38994_39046[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (18))){
var state_38927__$1 = state_38927;
var statearr_38995_39047 = state_38927__$1;
(statearr_38995_39047[(2)] = null);

(statearr_38995_39047[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38928 === (8))){
var inst_38825 = (state_38927[(7)]);
var inst_38830 = inst_38825.cljs$lang$protocol_mask$partition0$;
var inst_38831 = (inst_38830 & (64));
var inst_38832 = inst_38825.cljs$core$ISeq$;
var inst_38833 = (inst_38831) || (inst_38832);
var state_38927__$1 = state_38927;
if(cljs.core.truth_(inst_38833)){
var statearr_38996_39048 = state_38927__$1;
(statearr_38996_39048[(1)] = (11));

} else {
var statearr_38997_39049 = state_38927__$1;
(statearr_38997_39049[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_39001 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39001[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_39001[(1)] = (1));

return statearr_39001;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_38927){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_38927);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e39002){if((e39002 instanceof Object)){
var ex__13108__auto__ = e39002;
var statearr_39003_39050 = state_38927;
(statearr_39003_39050[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38927);

return cljs.core.cst$kw$recur;
} else {
throw e39002;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39051 = state_38927;
state_38927 = G__39051;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_38927){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_38927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_39004 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_39004[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_39004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto__,event_chan))
);

return c__13216__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$field_DASH_key,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__39070(s__39071){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__39071__$1 = s__39071;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39071__$1);
if(temp__4657__auto__){
var s__39071__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39071__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39071__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39073 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39072 = (0);
while(true){
if((i__39072 < size__7188__auto__)){
var vec__39082 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39072);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39082,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39082,(1),null);
cljs.core.chunk_append(b__39073,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__39072,vec__39082,k,v,c__7187__auto__,size__7188__auto__,b__39073,s__39071__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__39072,vec__39082,k,v,c__7187__auto__,size__7188__auto__,b__39073,s__39071__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__39088 = (i__39072 + (1));
i__39072 = G__39088;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39073),hatti$views$table$render_options_$_iter__39070(cljs.core.chunk_rest(s__39071__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39073),null);
}
} else {
var vec__39085 = cljs.core.first(s__39071__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39085,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39085,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__39085,k,v,s__39071__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__39085,k,v,s__39071__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__39070(cljs.core.rest(s__39071__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39090 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39090 = (function (_,owner,meta39091){
this._ = _;
this.owner = owner;
this.meta39091 = meta39091;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39090.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39092,meta39091__$1){
var self__ = this;
var _39092__$1 = this;
return (new hatti.views.table.t_hatti$views$table39090(self__._,self__.owner,meta39091__$1));
});

hatti.views.table.t_hatti$views$table39090.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39092){
var self__ = this;
var _39092__$1 = this;
return self__.meta39091;
});

hatti.views.table.t_hatti$views$table39090.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table39090.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field_DASH_key,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table39090.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39090.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__39093){
var self__ = this;
var map__39094 = p__39093;
var map__39094__$1 = ((((!((map__39094 == null)))?((((map__39094.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39094.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39094):map__39094);
var field_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39094__$1,cljs.core.cst$kw$field_DASH_key);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39094__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__39096 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39096__$1 = ((((!((map__39096 == null)))?((((map__39096.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39096.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39096):map__39096);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39096__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__39096,map__39096__$1,flat_form,new_language,___$2,map__39094,map__39094__$1,field_key,language){
return (function (p1__39089_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(flat_form,cljs.core.array_seq([cljs.core.cst$kw$get_DASH_label_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__39089_SHARP_),cljs.core.cst$kw$language,new_language], 0))], null));
});})(options,map__39096,map__39096__$1,flat_form,new_language,___$2,map__39094,map__39094__$1,field_key,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(field_key);
} else {
}

var G__39106 = ({"className": "label-changer"});
var G__39107 = (function (){var G__39109 = ({"className": "label-changer-label"});
var G__39110 = "Show:";
return React.DOM.span(G__39109,G__39110);
})();
var G__39108 = (function (){var G__39111 = ({"id": "header-display-dropdown", "className": "drop-hover"});
var G__39112 = (function (){var attrs39100 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(field_key) : options.call(null,field_key));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs39100))?sablono.interpreter.attributes(attrs39100):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39100))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__39114 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39114);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39100),(function (){var G__39115 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39115);
})()], null))));
})();
var G__39113 = (function (){var attrs39105 = hatti.views.table.render_options(options,self__.owner,colset_BANG_);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.ul,((cljs.core.map_QMARK_(attrs39105))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs39105], 0))):({"className": "submenu no-dot"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39105))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39105)], null))));
})();
return React.DOM.div(G__39111,G__39112,G__39113);
})();
return React.DOM.div(G__39106,G__39107,G__39108);
});

hatti.views.table.t_hatti$views$table39090.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39091], null);
});

hatti.views.table.t_hatti$views$table39090.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39090.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39090";

hatti.views.table.t_hatti$views$table39090.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39090");
});

hatti.views.table.__GT_t_hatti$views$table39090 = (function hatti$views$table$__GT_t_hatti$views$table39090(___$1,owner__$1,meta39091){
return (new hatti.views.table.t_hatti$views$table39090(___$1,owner__$1,meta39091));
});

}

return (new hatti.views.table.t_hatti$views$table39090(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__13216__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto__,query){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,query){
return (function (state_39158){
var state_val_39159 = (state_39158[(1)]);
if((state_val_39159 === (1))){
var inst_39144 = cljs.core.async.timeout((150));
var state_39158__$1 = state_39158;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39158__$1,(2),inst_39144);
} else {
if((state_val_39159 === (2))){
var inst_39146 = (state_39158[(2)]);
var inst_39147 = input.value;
var inst_39148 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_39147);
var state_39158__$1 = (function (){var statearr_39160 = state_39158;
(statearr_39160[(7)] = inst_39146);

return statearr_39160;
})();
if(inst_39148){
var statearr_39161_39172 = state_39158__$1;
(statearr_39161_39172[(1)] = (3));

} else {
var statearr_39162_39173 = state_39158__$1;
(statearr_39162_39173[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39159 === (3))){
var inst_39150 = [query_event_key];
var inst_39151 = [query];
var inst_39152 = cljs.core.PersistentHashMap.fromArrays(inst_39150,inst_39151);
var inst_39153 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_39152);
var state_39158__$1 = state_39158;
var statearr_39163_39174 = state_39158__$1;
(statearr_39163_39174[(2)] = inst_39153);

(statearr_39163_39174[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39159 === (4))){
var state_39158__$1 = state_39158;
var statearr_39164_39175 = state_39158__$1;
(statearr_39164_39175[(2)] = null);

(statearr_39164_39175[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39159 === (5))){
var inst_39156 = (state_39158[(2)]);
var state_39158__$1 = state_39158;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39158__$1,inst_39156);
} else {
return null;
}
}
}
}
}
});})(c__13216__auto__,query))
;
return ((function (switch__13104__auto__,c__13216__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__13105__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__13105__auto____0 = (function (){
var statearr_39168 = [null,null,null,null,null,null,null,null];
(statearr_39168[(0)] = hatti$views$table$delayed_search_$_state_machine__13105__auto__);

(statearr_39168[(1)] = (1));

return statearr_39168;
});
var hatti$views$table$delayed_search_$_state_machine__13105__auto____1 = (function (state_39158){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_39158);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e39169){if((e39169 instanceof Object)){
var ex__13108__auto__ = e39169;
var statearr_39170_39176 = state_39158;
(statearr_39170_39176[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39158);

return cljs.core.cst$kw$recur;
} else {
throw e39169;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39177 = state_39158;
state_39158 = G__39177;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__13105__auto__ = function(state_39158){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__13105__auto____1.call(this,state_39158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__13105__auto____0;
hatti$views$table$delayed_search_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__13105__auto____1;
return hatti$views$table$delayed_search_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,query))
})();
var state__13218__auto__ = (function (){var statearr_39171 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_39171[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_39171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto__,query))
);

return c__13216__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39179 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39179 = (function (_,owner,meta39180){
this._ = _;
this.owner = owner;
this.meta39180 = meta39180;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39179.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39181,meta39180__$1){
var self__ = this;
var _39181__$1 = this;
return (new hatti.views.table.t_hatti$views$table39179(self__._,self__.owner,meta39180__$1));
});

hatti.views.table.t_hatti$views$table39179.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39181){
var self__ = this;
var _39181__$1 = this;
return self__.meta39180;
});

hatti.views.table.t_hatti$views$table39179.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39179.prototype.om$core$IRender$render$arity$1 = (function (this__19159__auto__){
var self__ = this;
var this__19159__auto____$1 = this;
var G__39184 = ({"className": "table-search"});
var G__39185 = (function (){var G__39187 = ({"className": "fa fa-search"});
return React.DOM.i(G__39187);
})();
var G__39186 = (function (){var G__39188 = ({"type": "text", "placeholder": "Search", "onChange": ((function (G__39184,G__39185,this__19159__auto____$1){
return (function (p1__39178_SHARP_){
return hatti.views.table.delayed_search(p1__39178_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__39184,G__39185,this__19159__auto____$1))
});
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__39188) : sablono.interpreter.input.call(null,G__39188));
})();
return React.DOM.div(G__39184,G__39185,G__39186);
});

hatti.views.table.t_hatti$views$table39179.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39180], null);
});

hatti.views.table.t_hatti$views$table39179.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39179.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39179";

hatti.views.table.t_hatti$views$table39179.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39179");
});

hatti.views.table.__GT_t_hatti$views$table39179 = (function hatti$views$table$__GT_t_hatti$views$table39179(___$1,owner__$1,meta39180){
return (new hatti.views.table.t_hatti$views$table39179(___$1,owner__$1,meta39180));
});

}

return (new hatti.views.table.t_hatti$views$table39179(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table39189 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39189 = (function (cursor,owner,meta39190){
this.cursor = cursor;
this.owner = owner;
this.meta39190 = meta39190;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39189.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39191,meta39190__$1){
var self__ = this;
var _39191__$1 = this;
return (new hatti.views.table.t_hatti$views$table39189(self__.cursor,self__.owner,meta39190__$1));
});

hatti.views.table.t_hatti$views$table39189.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39191){
var self__ = this;
var _39191__$1 = this;
return self__.meta39190;
});

hatti.views.table.t_hatti$views$table39189.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39189.prototype.om$core$IRender$render$arity$1 = (function (this__19159__auto__){
var self__ = this;
var this__19159__auto____$1 = this;
var G__39194 = ({"className": "topbar"});
var G__39195 = (function (){var G__39199 = ({"id": hatti.views.table.pager_id});
return React.DOM.div(G__39199);
})();
var G__39196 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,self__.cursor));
var G__39197 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.cursor));
var G__39198 = (function (){var G__39200 = ({"style": ({"clear": "both"})});
return React.DOM.div(G__39200);
})();
return React.DOM.div(G__39194,G__39195,G__39196,G__39197,G__39198);
});

hatti.views.table.t_hatti$views$table39189.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39190], null);
});

hatti.views.table.t_hatti$views$table39189.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39189.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39189";

hatti.views.table.t_hatti$views$table39189.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39189");
});

hatti.views.table.__GT_t_hatti$views$table39189 = (function hatti$views$table$__GT_t_hatti$views$table39189(cursor__$1,owner__$1,meta39190){
return (new hatti.views.table.t_hatti$views$table39189(cursor__$1,owner__$1,meta39190));
});

}

return (new hatti.views.table.t_hatti$views$table39189(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq(data)){
var map__39206 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__39206__$1 = ((((!((map__39206 == null)))?((((map__39206.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39206.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39206):map__39206);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39206__$1,cljs.core.cst$kw$flat_DASH_form);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__39207 = hatti.views.table.sg_init(data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39207,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39207,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$table_DASH_view_DASH_height,hatti.views.table.get_table_view_height());
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$resize_DASH_handler,resize_handler);
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__39212,owner,p__39213){
var map__39214 = p__39212;
var map__39214__$1 = ((((!((map__39214 == null)))?((((map__39214.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39214.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39214):map__39214);
var cursor = map__39214__$1;
var map__39215 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39214__$1,cljs.core.cst$kw$views);
var map__39215__$1 = ((((!((map__39215 == null)))?((((map__39215.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39215.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39215):map__39215);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39215__$1,cljs.core.cst$kw$active);
var map__39216 = p__39213;
var map__39216__$1 = ((((!((map__39216 == null)))?((((map__39216.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39216.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39216):map__39216);
var opts = map__39216__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39216__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

var active_QMARK_ = chimera.seq.in_QMARK_(active,cljs.core.cst$kw$table);
if(typeof hatti.views.table.t_hatti$views$table39220 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39220 = (function (owner,map__39214,active_QMARK_,slick_grid_event_handlers,cursor,p__39213,map__39216,active,map__39215,opts,p__39212,meta39221){
this.owner = owner;
this.map__39214 = map__39214;
this.active_QMARK_ = active_QMARK_;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.cursor = cursor;
this.p__39213 = p__39213;
this.map__39216 = map__39216;
this.active = active;
this.map__39215 = map__39215;
this.opts = opts;
this.p__39212 = p__39212;
this.meta39221 = meta39221;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39220.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers){
return (function (_39222,meta39221__$1){
var self__ = this;
var _39222__$1 = this;
return (new hatti.views.table.t_hatti$views$table39220(self__.owner,self__.map__39214,self__.active_QMARK_,self__.slick_grid_event_handlers,self__.cursor,self__.p__39213,self__.map__39216,self__.active,self__.map__39215,self__.opts,self__.p__39212,meta39221__$1));
});})(active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39220.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers){
return (function (_39222){
var self__ = this;
var _39222__$1 = this;
return self__.meta39221;
});})(active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39220.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39220.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers){
return (function (_,p__39223){
var self__ = this;
var map__39224 = p__39223;
var map__39224__$1 = ((((!((map__39224 == null)))?((((map__39224.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39224.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39224):map__39224);
var table_view_height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39224__$1,cljs.core.cst$kw$table_DASH_view_DASH_height);
var ___$1 = this;
var map__39226 = self__.cursor;
var map__39226__$1 = ((((!((map__39226 == null)))?((((map__39226.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39226.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39226):map__39226);
var map__39227 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39226__$1,cljs.core.cst$kw$table_DASH_page);
var map__39227__$1 = ((((!((map__39227 == null)))?((((map__39227.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39227.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39227):map__39227);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39227__$1,cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_);
var submission_clicked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39227__$1,cljs.core.cst$kw$submission_DASH_clicked);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39226__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39226__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__39228 = dataset_info;
var map__39228__$1 = ((((!((map__39228 == null)))?((((map__39228.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39228.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39228):map__39228);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39228__$1,cljs.core.cst$kw$num_of_submissions);
var no_data_QMARK_ = cljs.core.empty_QMARK_(data);
var with_info = ((function (map__39226,map__39226__$1,map__39227,map__39227__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__39228,map__39228__$1,num_of_submissions,no_data_QMARK_,___$1,map__39224,map__39224__$1,table_view_height,active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers){
return (function (p1__39211_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.cursor,p1__39211_SHARP_], 0));
});})(map__39226,map__39226__$1,map__39227,map__39227__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__39228,map__39228__$1,num_of_submissions,no_data_QMARK_,___$1,map__39224,map__39224__$1,table_view_height,active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
var G__39232 = ({"style": cljs.core.clj__GT_js((cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$height,(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height();
}
})(),cljs.core.cst$kw$overflow,"hidden"], null):null)), "className": "table-view"});
var G__39233 = sablono.interpreter.interpret((cljs.core.truth_(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null)):null));
var G__39234 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.cursor));
var G__39235 = (function (){var G__39236 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__39237 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__39242 = ({"className": "alert alert-warning"});
var G__39243 = "No data";
return React.DOM.p(G__39242,G__39243);
})():(function (){var G__39244 = null;
var G__39245 = (function (){var G__39247 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__39247);
})();
var G__39246 = "Loading...";
return React.DOM.span(G__39244,G__39245,G__39246);
})());
return React.DOM.div(G__39236,G__39237);
})();
return React.DOM.div(G__39232,G__39233,G__39234,G__39235);
} else {
return null;
}
});})(active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39220.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table39220.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler(self__.owner);

var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39248 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39248,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39248,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39220.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table39220.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$resize_DASH_handler));
});})(active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39220.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table39220.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__39251 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39251__$1 = ((((!((map__39251 == null)))?((((map__39251.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39251.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39251):map__39251);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39251__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39251__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39253 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39253,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39253,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39220.getBasis = ((function (active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$owner,cljs.core.cst$sym$map__39214,cljs.core.cst$sym$active_QMARK_,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$cursor,cljs.core.cst$sym$p__39213,cljs.core.cst$sym$map__39216,cljs.core.cst$sym$active,cljs.core.cst$sym$map__39215,cljs.core.cst$sym$opts,cljs.core.cst$sym$p__39212,cljs.core.cst$sym$meta39221], null);
});})(active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39220.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39220.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39220";

hatti.views.table.t_hatti$views$table39220.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39220");
});})(active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table39220 = ((function (active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table39220(owner__$1,map__39214__$2,active_QMARK___$1,slick_grid_event_handlers__$1,cursor__$1,p__39213__$1,map__39216__$2,active__$1,map__39215__$2,opts__$1,p__39212__$1,meta39221){
return (new hatti.views.table.t_hatti$views$table39220(owner__$1,map__39214__$2,active_QMARK___$1,slick_grid_event_handlers__$1,cursor__$1,p__39213__$1,map__39216__$2,active__$1,map__39215__$2,opts__$1,p__39212__$1,meta39221));
});})(active_QMARK_,map__39214,map__39214__$1,cursor,map__39215,map__39215__$1,active,map__39216,map__39216__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table39220(owner,map__39214__$1,active_QMARK_,slick_grid_event_handlers,cursor,p__39213,map__39216__$1,active,map__39215__$1,opts,p__39212,cljs.core.PersistentArrayMap.EMPTY));
}));
