// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.dataview');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.views.photos');
goog.require('sablono.core');
goog.require('hatti.views.user_guide');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.views.map');
goog.require('hatti.views.chart');
goog.require('hatti.views.report_view');
goog.require('hatti.shared');
goog.require('chimera.metrics');
goog.require('hatti.views.saved_charts');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('hatti.views.settings');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('hatti.views.overview');
goog.require('hatti.views.table');
hatti.views.dataview.dataview_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$user_DASH_guide,cljs.core.cst$kw$table,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$settings,cljs.core.cst$kw$overview,cljs.core.cst$kw$chart,cljs.core.cst$kw$photos,cljs.core.cst$kw$map],[new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$user_DASH_guide,cljs.core.cst$kw$label,"User Guide",cljs.core.cst$kw$component,hatti.views.user_guide_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$table,cljs.core.cst$kw$label,"Table",cljs.core.cst$kw$component,hatti.views.table_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$label,"Reports",cljs.core.cst$kw$component,hatti.views.report_view_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$label,"Dashboard",cljs.core.cst$kw$component,hatti.views.saved_charts_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$settings,cljs.core.cst$kw$label,"Settings",cljs.core.cst$kw$component,hatti.views.settings_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$overview,cljs.core.cst$kw$label,"Overview",cljs.core.cst$kw$component,hatti.views.overview_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$chart,cljs.core.cst$kw$label,"Charts",cljs.core.cst$kw$component,hatti.views.chart_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$photos,cljs.core.cst$kw$label,"Photos",cljs.core.cst$kw$component,hatti.views.photos_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$map,cljs.core.cst$kw$label,"Map",cljs.core.cst$kw$component,hatti.views.map_page], null)]);
/**
 * Initial Dataview State
 */
hatti.views.dataview.default_dataviews = (function hatti$views$dataview$default_dataviews(){
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(hatti.views.dataview.dataview_map) : cljs.core.atom.call(null,hatti.views.dataview.dataview_map));
});
hatti.views.dataview.view_state = hatti.views.dataview.default_dataviews();
/**
 * Build and set the tooltips for inactive views based on why they are
 * inactive.
 */
hatti.views.dataview.view__GT_inactive_tab = (function hatti$views$dataview$view__GT_inactive_tab(view,label,is_encrypted_QMARK_,not_within_pricing_limits_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$inactive,[cljs.core.str(label),cljs.core.str(" ")].join(''),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$tooltip,(cljs.core.truth_(is_encrypted_QMARK_)?"This tab is disabled because this form is encrypted.":(cljs.core.truth_(not_within_pricing_limits_QMARK_)?"This tab is disabled because you are over the pricing limits.":(function (){var pred__39277 = cljs.core._EQ_;
var expr__39278 = view;
if(cljs.core.truth_((function (){var G__39280 = cljs.core.cst$kw$map;
var G__39281 = expr__39278;
return (pred__39277.cljs$core$IFn$_invoke$arity$2 ? pred__39277.cljs$core$IFn$_invoke$arity$2(G__39280,G__39281) : pred__39277.call(null,G__39280,G__39281));
})())){
return [cljs.core.str("The Map tab is disabled because this form "),cljs.core.str("has no location questions.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39282 = cljs.core.cst$kw$photos;
var G__39283 = expr__39278;
return (pred__39277.cljs$core$IFn$_invoke$arity$2 ? pred__39277.cljs$core$IFn$_invoke$arity$2(G__39282,G__39283) : pred__39277.call(null,G__39282,G__39283));
})())){
return [cljs.core.str("The Photos tab is disabled because this form has no "),cljs.core.str("photo questions.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39284 = cljs.core.cst$kw$table;
var G__39285 = expr__39278;
return (pred__39277.cljs$core$IFn$_invoke$arity$2 ? pred__39277.cljs$core$IFn$_invoke$arity$2(G__39284,G__39285) : pred__39277.call(null,G__39284,G__39285));
})())){
return [cljs.core.str("The table tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39286 = cljs.core.cst$kw$chart;
var G__39287 = expr__39278;
return (pred__39277.cljs$core$IFn$_invoke$arity$2 ? pred__39277.cljs$core$IFn$_invoke$arity$2(G__39286,G__39287) : pred__39277.call(null,G__39286,G__39287));
})())){
return [cljs.core.str("The charts tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39288 = cljs.core.cst$kw$saved_DASH_charts;
var G__39289 = expr__39278;
return (pred__39277.cljs$core$IFn$_invoke$arity$2 ? pred__39277.cljs$core$IFn$_invoke$arity$2(G__39288,G__39289) : pred__39277.call(null,G__39288,G__39289));
})())){
return [cljs.core.str("The dashboards tab is disabled because "),cljs.core.str("you do not have permission to view it.")].join('');
} else {
return "This tab is disabled.";
}
}
}
}
}
})()
))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_question,"?"], null)], null)], null);
});
hatti.views.dataview_actions.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.dataview.t_hatti$views$dataview39290 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39290 = (function (cursor,owner,meta39291){
this.cursor = cursor;
this.owner = owner;
this.meta39291 = meta39291;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39290.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39292,meta39291__$1){
var self__ = this;
var _39292__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39290(self__.cursor,self__.owner,meta39291__$1));
});

hatti.views.dataview.t_hatti$views$dataview39290.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39292){
var self__ = this;
var _39292__$1 = this;
return self__.meta39291;
});

hatti.views.dataview.t_hatti$views$dataview39290.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39290.prototype.om$core$IRender$render$arity$1 = (function (this__19159__auto__){
var self__ = this;
var this__19159__auto____$1 = this;
return null;
});

hatti.views.dataview.t_hatti$views$dataview39290.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39291], null);
});

hatti.views.dataview.t_hatti$views$dataview39290.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39290.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39290";

hatti.views.dataview.t_hatti$views$dataview39290.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39290");
});

hatti.views.dataview.__GT_t_hatti$views$dataview39290 = (function hatti$views$dataview$__GT_t_hatti$views$dataview39290(cursor__$1,owner__$1,meta39291){
return (new hatti.views.dataview.t_hatti$views$dataview39290(cursor__$1,owner__$1,meta39291));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview39290(cursor,owner,null));
}));
hatti.views.dataview_infobar.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__39293,owner){
var map__39294 = p__39293;
var map__39294__$1 = ((((!((map__39294 == null)))?((((map__39294.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39294.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39294):map__39294);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39294__$1,cljs.core.cst$kw$dataset_DASH_info);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39294__$1,cljs.core.cst$kw$status);
if(typeof hatti.views.dataview.t_hatti$views$dataview39296 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39296 = (function (p__39293,owner,map__39294,dataset_info,status,meta39297){
this.p__39293 = p__39293;
this.owner = owner;
this.map__39294 = map__39294;
this.dataset_info = dataset_info;
this.status = status;
this.meta39297 = meta39297;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39296.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__39294,map__39294__$1,dataset_info,status){
return (function (_39298,meta39297__$1){
var self__ = this;
var _39298__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39296(self__.p__39293,self__.owner,self__.map__39294,self__.dataset_info,self__.status,meta39297__$1));
});})(map__39294,map__39294__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39296.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__39294,map__39294__$1,dataset_info,status){
return (function (_39298){
var self__ = this;
var _39298__$1 = this;
return self__.meta39297;
});})(map__39294,map__39294__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39296.prototype.om$core$IWillMount$ = true;

hatti.views.dataview.t_hatti$views$dataview39296.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__39294,map__39294__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
return hatti.shared.maybe_merge_languages_BANG_(om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form));
});})(map__39294,map__39294__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39296.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39296.prototype.om$core$IRender$render$arity$1 = ((function (map__39294,map__39294__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var map__39299 = self__.dataset_info;
var map__39299__$1 = ((((!((map__39299 == null)))?((((map__39299.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39299.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39299):map__39299);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39299__$1,cljs.core.cst$kw$num_of_submissions);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39299__$1,cljs.core.cst$kw$formid);
var map__39300 = self__.status;
var map__39300__$1 = ((((!((map__39300 == null)))?((((map__39300.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39300.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39300):map__39300);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39300__$1,cljs.core.cst$kw$loading_QMARK_);
var total_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39300__$1,cljs.core.cst$kw$total_DASH_records);
var G__39307 = ({"className": "right rec-summary rec-margin"});
var G__39308 = (function (){var attrs39303 = (cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))?om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.shared.language_selector,null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs39303))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,"language-selector"], null),attrs39303], 0))):({"id": "language-selector"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39303))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39303)], null))));
})();
var G__39309 = (function (){var G__39312 = ({"id": "data-status"});
var G__39313 = (function (){var attrs39304 = (cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs39304))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rec"], null)], null),attrs39304], 0))):({"className": "rec"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39304))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39304),sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null))));
})();
return React.DOM.div(G__39312,G__39313);
})();
var G__39310 = (function (){var G__39314 = ({"className": "divider"});
return React.DOM.div(G__39314);
})();
var G__39311 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_actions,formid));
return React.DOM.div(G__39307,G__39308,G__39309,G__39310,G__39311);
});})(map__39294,map__39294__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39296.getBasis = ((function (map__39294,map__39294__$1,dataset_info,status){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__39293,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__39294,cljs.core.cst$sym$dataset_DASH_info,cljs.core.cst$sym$status,cljs.core.cst$sym$meta39297], null);
});})(map__39294,map__39294__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39296.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39296.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39296";

hatti.views.dataview.t_hatti$views$dataview39296.cljs$lang$ctorPrWriter = ((function (map__39294,map__39294__$1,dataset_info,status){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39296");
});})(map__39294,map__39294__$1,dataset_info,status))
;

hatti.views.dataview.__GT_t_hatti$views$dataview39296 = ((function (map__39294,map__39294__$1,dataset_info,status){
return (function hatti$views$dataview$__GT_t_hatti$views$dataview39296(p__39293__$1,owner__$1,map__39294__$2,dataset_info__$1,status__$1,meta39297){
return (new hatti.views.dataview.t_hatti$views$dataview39296(p__39293__$1,owner__$1,map__39294__$2,dataset_info__$1,status__$1,meta39297));
});})(map__39294,map__39294__$1,dataset_info,status))
;

}

return (new hatti.views.dataview.t_hatti$views$dataview39296(p__39293,owner,map__39294__$1,dataset_info,status,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Strip off ampersand suffixes then switch to view if result is a valid view
 */
hatti.views.dataview.activate_view_BANG_ = (function hatti$views$dataview$activate_view_BANG_(view){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((function (){var or__6409__auto__ = cljs.core.last(cljs.core.re_find(/(.*?)&/,view));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return view;
}
})());
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_(cljs.core.set(views),view__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_settings_view_BANG_ = (function hatti$views$dataview$activate_settings_view_BANG_(view,settings_section){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$active_DASH_tab,settings_section__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_integrated_apps_view_BANG_ = (function hatti$views$dataview$activate_integrated_apps_view_BANG_(view,settings_section,app_type){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.app_state,((function (view__$1,settings_section__$1,settings_views){
return (function (app_state){
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$selected], null),view__$1),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$active_DASH_tab], null),settings_section__$1),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps,cljs.core.cst$kw$active_DASH_section], null),app_type);
});})(view__$1,settings_section__$1,settings_views))
);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(app_type,hatti.constants.google_sheets)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$add_QMARK_,true], null));
} else {
}

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.tabbed_dataview.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,opts){
if(typeof hatti.views.dataview.t_hatti$views$dataview39318 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39318 = (function (app_state,owner,opts,meta39319){
this.app_state = app_state;
this.owner = owner;
this.opts = opts;
this.meta39319 = meta39319;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39318.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39320,meta39319__$1){
var self__ = this;
var _39320__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39318(self__.app_state,self__.owner,self__.opts,meta39319__$1));
});

hatti.views.dataview.t_hatti$views$dataview39318.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39320){
var self__ = this;
var _39320__$1 = this;
return self__.meta39319;
});

hatti.views.dataview.t_hatti$views$dataview39318.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39318.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var map__39321 = self__.app_state;
var map__39321__$1 = ((((!((map__39321 == null)))?((((map__39321.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39321.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39321):map__39321);
var map__39322 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39321__$1,cljs.core.cst$kw$views);
var map__39322__$1 = ((((!((map__39322 == null)))?((((map__39322.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39322.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39322):map__39322);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39322__$1,cljs.core.cst$kw$active);
var disabled = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39322__$1,cljs.core.cst$kw$disabled);
var selected = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39322__$1,cljs.core.cst$kw$selected);
var is_encrypted_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39321__$1,cljs.core.cst$kw$is_DASH_encrypted_QMARK_);
var is_within_pricing_limits_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39321__$1,cljs.core.cst$kw$is_DASH_within_DASH_pricing_DASH_limits_QMARK_);
var view__GT_display = ((function (map__39321,map__39321__$1,map__39322,map__39322__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1){
return (function (p1__39315_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,p1__39315_SHARP_)){
return "block";
} else {
return "none";
}
});})(map__39321,map__39321__$1,map__39322,map__39322__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1))
;
var view__GT_cls = ((function (map__39321,map__39321__$1,map__39322,map__39322__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1){
return (function (p1__39316_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,p1__39316_SHARP_)){
return "clicked";
} else {
return null;
}
});})(map__39321,map__39321__$1,map__39322,map__39322__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1))
;
var dataviews = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.views.dataview.view_state) : cljs.core.deref.call(null,hatti.views.dataview.view_state)),cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))));
var dv__GT_link = ((function (map__39321,map__39321__$1,map__39322,map__39322__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p__39325){
var map__39326 = p__39325;
var map__39326__$1 = ((((!((map__39326 == null)))?((((map__39326.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39326.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39326):map__39326);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39326__$1,cljs.core.cst$kw$view);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39326__$1,cljs.core.cst$kw$label);
if(cljs.core.truth_((function (){var and__6397__auto__ = cljs.core.some(((function (map__39326,map__39326__$1,view,label,map__39321,map__39321__$1,map__39322,map__39322__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p1__39317_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,p1__39317_SHARP_);
});})(map__39326,map__39326__$1,view,label,map__39321,map__39321__$1,map__39322,map__39322__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
,active);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not(chimera.seq.in_QMARK_(disabled,view));
} else {
return and__6397__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,view__GT_cls(view),cljs.core.cst$kw$href,[cljs.core.str("#/"),cljs.core.str(cljs.core.name(view))].join('')], null),label], null);
} else {
return hatti.views.dataview.view__GT_inactive_tab(view,label,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_);
}
});})(map__39321,map__39321__$1,map__39322,map__39322__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
;
var G__39329 = ({"className": "tab-container dataset-tabs"});
var G__39330 = (function (){var attrs39328 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(dv__GT_link,dataviews);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs39328))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-bar"], null)], null),attrs39328], 0))):({"className": "tab-bar"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39328))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39328),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null))));
})();
var G__39331 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = ((function (G__39329,G__39330,map__39321,map__39321__$1,map__39322,map__39322__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function hatti$views$dataview$iter__39332(s__39333){
return (new cljs.core.LazySeq(null,((function (G__39329,G__39330,map__39321,map__39321__$1,map__39322,map__39322__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function (){
var s__39333__$1 = s__39333;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39333__$1);
if(temp__4657__auto__){
var s__39333__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39333__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39333__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39335 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39334 = (0);
while(true){
if((i__39334 < size__7188__auto__)){
var map__39346 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39334);
var map__39346__$1 = ((((!((map__39346 == null)))?((((map__39346.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39346.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39346):map__39346);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39346__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39346__$1,cljs.core.cst$kw$view);
var view_name = cljs.core.name(view);
cljs.core.chunk_append(b__39335,(function (){var G__39348 = ({"style": ({"display": view__GT_display(view)}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')});
var G__39349 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,view))?(function (){
chimera.metrics.send_event(cljs.core.cst$kw$Dataview,[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null);
})()
:null));
return React.DOM.div(G__39348,G__39349);
})());

var G__39354 = (i__39334 + (1));
i__39334 = G__39354;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39335),hatti$views$dataview$iter__39332(cljs.core.chunk_rest(s__39333__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39335),null);
}
} else {
var map__39350 = cljs.core.first(s__39333__$2);
var map__39350__$1 = ((((!((map__39350 == null)))?((((map__39350.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39350.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39350):map__39350);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39350__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39350__$1,cljs.core.cst$kw$view);
var view_name = cljs.core.name(view);
return cljs.core.cons((function (){var G__39352 = ({"style": ({"display": view__GT_display(view)}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')});
var G__39353 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,view))?(function (){
chimera.metrics.send_event(cljs.core.cst$kw$Dataview,[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null);
})()
:null));
return React.DOM.div(G__39352,G__39353);
})(),hatti$views$dataview$iter__39332(cljs.core.rest(s__39333__$2)));
}
} else {
return null;
}
break;
}
});})(G__39329,G__39330,map__39321,map__39321__$1,map__39322,map__39322__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
,null,null));
});})(G__39329,G__39330,map__39321,map__39321__$1,map__39322,map__39322__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
;
return iter__7189__auto__(dataviews);
})());
return React.DOM.div(G__39329,G__39330,G__39331);
});

hatti.views.dataview.t_hatti$views$dataview39318.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta39319], null);
});

hatti.views.dataview.t_hatti$views$dataview39318.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39318.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39318";

hatti.views.dataview.t_hatti$views$dataview39318.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39318");
});

hatti.views.dataview.__GT_t_hatti$views$dataview39318 = (function hatti$views$dataview$__GT_t_hatti$views$dataview39318(app_state__$1,owner__$1,opts__$1,meta39319){
return (new hatti.views.dataview.t_hatti$views$dataview39318(app_state__$1,owner__$1,opts__$1,meta39319));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview39318(app_state,owner,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
