// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0))], 0))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__38435_SHARP_){
if(typeof p1__38435_SHARP_ === 'string'){
return clojure.string.lower_case(p1__38435_SHARP_);
} else {
return p1__38435_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__38441){
var vec__38442 = p__38441;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38442,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38442,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,cljs.core.array_seq([cljs.core.cst$kw$compact_QMARK_,true], 0));
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__38436_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__38436_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
var media_count = (dataContext["_media_count"]);
var total_media = (dataContext["_total_media"]);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,chimera.string.escape_for_type(clj_value),cljs.core.array_seq([cljs.core.cst$kw$language,language,cljs.core.cst$kw$compact_QMARK_,true,cljs.core.cst$kw$field_DASH_key,field_key,cljs.core.cst$kw$media_DASH_count,media_count,cljs.core.cst$kw$total_DASH_media,total_media], 0));
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__38445 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__38445__$1 = ((((!((map__38445 == null)))?((((map__38445.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38445.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38445):map__38445);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38445__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38445__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38445__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$delete_DASH_record,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$data_DASH_id,value], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip$middle_DASH_right,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_eye,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.select_unselect_all_records_id = "select-unselect-all-records";
hatti.views.table.select_unselect_all_records_element = [cljs.core.str("<input type=\"checkbox\" id=\""),cljs.core.str(hatti.views.table.select_unselect_all_records_id),cljs.core.str("\">")].join('');
hatti.views.table.delete_record_class = "delete-record";
hatti.views.actions_column.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(100),hatti.views.table.select_unselect_all_records_element,(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
}));
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38478 = arguments.length;
var i__7485__auto___38479 = (0);
while(true){
if((i__7485__auto___38479 < len__7484__auto___38478)){
args__7491__auto__.push((arguments[i__7485__auto___38479]));

var G__38480 = (i__7485__auto___38479 + (1));
i__7485__auto___38479 = G__38480;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__38450){
var map__38451 = p__38450;
var map__38451__$1 = ((((!((map__38451 == null)))?((((map__38451.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38451.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38451):map__38451);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38451__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var get_label_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38451__$1,cljs.core.cst$kw$get_DASH_label_QMARK_,true);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38451__$1,cljs.core.cst$kw$language);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38451__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = (function (){var G__38453 = cljs.core.false_QMARK_;
var G__38454 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__38453,map__38451,map__38451__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__38447_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__38447_SHARP_)) == null);
});})(G__38453,map__38451,map__38451__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,form);
return (chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__38453,G__38454) : chimera.core.any_QMARK_.call(null,G__38453,G__38454));
})();
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__38451,map__38451__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__38455(s__38456){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__38451,map__38451__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__38456__$1 = s__38456;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38456__$1);
if(temp__4657__auto__){
var s__38456__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38456__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38456__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38458 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38457 = (0);
while(true){
if((i__38457 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38457);
cljs.core.chunk_append(b__38458,(function (){var map__38469 = field;
var map__38469__$1 = ((((!((map__38469 == null)))?((((map__38469.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38469.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38469):map__38469);
var map__38470 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38469__$1,cljs.core.cst$kw$instance);
var map__38470__$1 = ((((!((map__38470 == null)))?((((map__38470.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38470.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38470):map__38470);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38470__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38469__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38469__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38469__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__38481 = (i__38457 + (1));
i__38457 = G__38481;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38458),hatti$views$table$iter__38455(cljs.core.chunk_rest(s__38456__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38458),null);
}
} else {
var field = cljs.core.first(s__38456__$2);
return cljs.core.cons((function (){var map__38473 = field;
var map__38473__$1 = ((((!((map__38473 == null)))?((((map__38473.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38473.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38473):map__38473);
var map__38474 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38473__$1,cljs.core.cst$kw$instance);
var map__38474__$1 = ((((!((map__38474 == null)))?((((map__38474.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38474.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38474):map__38474);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38474__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38473__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38473__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38473__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__38455(cljs.core.rest(s__38456__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__38451,map__38451__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__38451,map__38451__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__(hatti.views.table.all_fields(form));
})();
return cljs.core.clj__GT_js((function (){var G__38477 = columns;
if(cljs.core.not(hide_actions_column_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__38477,(hatti.views.actions_column.cljs$core$IFn$_invoke$arity$2 ? hatti.views.actions_column.cljs$core$IFn$_invoke$arity$2(owner,has_hxl_QMARK_) : hatti.views.actions_column.call(null,owner,has_hxl_QMARK_)));
} else {
return G__38477;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq38448){
var G__38449 = cljs.core.first(seq38448);
var seq38448__$1 = cljs.core.next(seq38448);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__38449,seq38448__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__38483 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__38483);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38502(s__38503){
return (new cljs.core.LazySeq(null,(function (){
var s__38503__$1 = s__38503;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38503__$1);
if(temp__4657__auto__){
var s__38503__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38503__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38503__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38505 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38504 = (0);
while(true){
if((i__38504 < size__7188__auto__)){
var vec__38514 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38504);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38514,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38514,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__38505,event.subscribe(handler_function));

var G__38520 = (i__38504 + (1));
i__38504 = G__38520;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38505),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38502(cljs.core.chunk_rest(s__38503__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38505),null);
}
} else {
var vec__38517 = cljs.core.first(s__38503__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38517,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38517,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38502(cljs.core.rest(s__38503__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38539(s__38540){
return (new cljs.core.LazySeq(null,(function (){
var s__38540__$1 = s__38540;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38540__$1);
if(temp__4657__auto__){
var s__38540__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38540__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38540__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38542 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38541 = (0);
while(true){
if((i__38541 < size__7188__auto__)){
var vec__38551 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38541);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38551,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38551,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__38542,event.subscribe(handler_function));

var G__38557 = (i__38541 + (1));
i__38541 = G__38557;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38542),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38539(cljs.core.chunk_rest(s__38540__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38542),null);
}
} else {
var vec__38554 = cljs.core.first(s__38540__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38554,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38554,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38539(cljs.core.rest(s__38540__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.update_data_to_be_deleted_vector = (function hatti$views$table$update_data_to_be_deleted_vector(checked_QMARK_,data_id){
var map__38560 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38560__$1 = ((((!((map__38560 == null)))?((((map__38560.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38560.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38560):map__38560);
var data_to_be_deleted = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38560__$1,cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted);
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted], null),((function (map__38560,map__38560__$1,data_to_be_deleted,fn){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(data_to_be_deleted,data_id) : fn.call(null,data_to_be_deleted,data_id));
});})(map__38560,map__38560__$1,data_to_be_deleted,fn))
);
});
hatti.views.table.get_elements_count_by_selector = (function hatti$views$table$get_elements_count_by_selector(selector){
return document.querySelectorAll(selector).length;
});
hatti.views.table.check_select_unselect_all_records_element_QMARK_ = (function hatti$views$table$check_select_unselect_all_records_element_QMARK_(){
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
var selected_rows_count = hatti.views.table.get_elements_count_by_selector([cljs.core.str(delete_record_class_selector),cljs.core.str(":checked")].join(''));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected_rows_count,total_rows_count);
});
hatti.views.table.get_checkbox_selector = (function hatti$views$table$get_checkbox_selector(data_id){
return [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class),cljs.core.str("[data-id=\""),cljs.core.str(data_id),cljs.core.str("\"]")].join('');
});
hatti.views.table.get_delete_checkbox_by_data_id = (function hatti$views$table$get_delete_checkbox_by_data_id(data_id){
var selector = hatti.views.table.get_checkbox_selector(data_id);
return document.querySelector(selector);
});
hatti.views.table.select_rows_marked_to_be_deleted = (function hatti$views$table$select_rows_marked_to_be_deleted(){
var seq__38566 = cljs.core.seq(cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var chunk__38567 = null;
var count__38568 = (0);
var i__38569 = (0);
while(true){
if((i__38569 < count__38568)){
var data_id = chunk__38567.cljs$core$IIndexed$_nth$arity$2(null,i__38569);
var element_38570 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38570.checked = true;

var G__38571 = seq__38566;
var G__38572 = chunk__38567;
var G__38573 = count__38568;
var G__38574 = (i__38569 + (1));
seq__38566 = G__38571;
chunk__38567 = G__38572;
count__38568 = G__38573;
i__38569 = G__38574;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__38566);
if(temp__4657__auto__){
var seq__38566__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38566__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__38566__$1);
var G__38575 = cljs.core.chunk_rest(seq__38566__$1);
var G__38576 = c__7220__auto__;
var G__38577 = cljs.core.count(c__7220__auto__);
var G__38578 = (0);
seq__38566 = G__38575;
chunk__38567 = G__38576;
count__38568 = G__38577;
i__38569 = G__38578;
continue;
} else {
var data_id = cljs.core.first(seq__38566__$1);
var element_38579 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38579.checked = true;

var G__38580 = cljs.core.next(seq__38566__$1);
var G__38581 = null;
var G__38582 = (0);
var G__38583 = (0);
seq__38566 = G__38580;
chunk__38567 = G__38581;
count__38568 = G__38582;
i__38569 = G__38583;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.higlight_rows_marked_to_be_deleted = (function hatti$views$table$higlight_rows_marked_to_be_deleted(grid){
var checkboxes = document.getElementsByClassName(hatti.views.table.delete_record_class);
var indexes_of_selected_checkboxes = cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (checkboxes){
return (function (index,checkbox){
if(cljs.core.truth_(checkbox.checked)){
return index;
} else {
return null;
}
});})(checkboxes))
,checkboxes)));
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (checkboxes,indexes_of_selected_checkboxes){
return (function (){
return cljs.core.identity(indexes_of_selected_checkboxes);
});})(checkboxes,indexes_of_selected_checkboxes))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(indexes_of_selected_checkboxes));
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__38584){
var map__38603 = p__38584;
var map__38603__$1 = ((((!((map__38603 == null)))?((((map__38603.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38603.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38603):map__38603);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38603__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38603__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var map__38605 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38605__$1 = ((((!((map__38605 == null)))?((((map__38605.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38605.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38605):map__38605);
var map__38606 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38605__$1,cljs.core.cst$kw$table_DASH_page);
var map__38606__$1 = ((((!((map__38606 == null)))?((((map__38606.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38606.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38606):map__38606);
var map__38607 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38606__$1,cljs.core.cst$kw$paging);
var map__38607__$1 = ((((!((map__38607 == null)))?((((map__38607.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38607.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38607):map__38607);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38607__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38607__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38606__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$language,current_language,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,hide_actions_column_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

grid.setSelectionModel((new Slick.RowSelectionModel(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selectActiveRow,false], null)))));

dataview.onRowCountChanged.subscribe(((function (map__38605,map__38605__$1,map__38606,map__38606__$1,map__38607,map__38607__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38603,map__38603__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__38605,map__38605__$1,map__38606,map__38606__$1,map__38607,map__38607__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38603,map__38603__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__38605,map__38605__$1,map__38606,map__38606__$1,map__38607,map__38607__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38603,map__38603__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

grid.render();

hatti.views.table.select_rows_marked_to_be_deleted();

return hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
});})(map__38605,map__38605__$1,map__38606,map__38606__$1,map__38607,map__38607__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38603,map__38603__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onHeaderClick.subscribe(((function (map__38605,map__38605__$1,map__38606,map__38606__$1,map__38607,map__38607__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38603,map__38603__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var target = e.target;
var id = target.id;
var checked_QMARK_ = target.checked;
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hatti.views.table.select_unselect_all_records_id,id)){
var records_to_be_deleted = document.getElementsByClassName(hatti.views.table.delete_record_class);
var seq__38611_38621 = cljs.core.seq(records_to_be_deleted);
var chunk__38612_38622 = null;
var count__38613_38623 = (0);
var i__38614_38624 = (0);
while(true){
if((i__38614_38624 < count__38613_38623)){
var record_38625 = chunk__38612_38622.cljs$core$IIndexed$_nth$arity$2(null,i__38614_38624);
record_38625.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38615 = record_38625.getAttribute("data-id");
return parseInt(G__38615);
})());

var G__38626 = seq__38611_38621;
var G__38627 = chunk__38612_38622;
var G__38628 = count__38613_38623;
var G__38629 = (i__38614_38624 + (1));
seq__38611_38621 = G__38626;
chunk__38612_38622 = G__38627;
count__38613_38623 = G__38628;
i__38614_38624 = G__38629;
continue;
} else {
var temp__4657__auto___38630 = cljs.core.seq(seq__38611_38621);
if(temp__4657__auto___38630){
var seq__38611_38631__$1 = temp__4657__auto___38630;
if(cljs.core.chunked_seq_QMARK_(seq__38611_38631__$1)){
var c__7220__auto___38632 = cljs.core.chunk_first(seq__38611_38631__$1);
var G__38633 = cljs.core.chunk_rest(seq__38611_38631__$1);
var G__38634 = c__7220__auto___38632;
var G__38635 = cljs.core.count(c__7220__auto___38632);
var G__38636 = (0);
seq__38611_38621 = G__38633;
chunk__38612_38622 = G__38634;
count__38613_38623 = G__38635;
i__38614_38624 = G__38636;
continue;
} else {
var record_38637 = cljs.core.first(seq__38611_38631__$1);
record_38637.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38616 = record_38637.getAttribute("data-id");
return parseInt(G__38616);
})());

var G__38638 = cljs.core.next(seq__38611_38631__$1);
var G__38639 = null;
var G__38640 = (0);
var G__38641 = (0);
seq__38611_38621 = G__38638;
chunk__38612_38622 = G__38639;
count__38613_38623 = G__38640;
i__38614_38624 = G__38641;
continue;
}
} else {
}
}
break;
}

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38605,map__38605__$1,map__38606,map__38606__$1,map__38607,map__38607__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38603,map__38603__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
if(cljs.core.truth_(checked_QMARK_)){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1(total_rows_count);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});})(records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38605,map__38605__$1,map__38606,map__38606__$1,map__38607,map__38607__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38603,map__38603__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
return null;
}
});})(map__38605,map__38605__$1,map__38606,map__38606__$1,map__38607,map__38607__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38603,map__38603__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__38605,map__38605__$1,map__38606,map__38606__$1,map__38607,map__38607__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38603,map__38603__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(map__38605,map__38605__$1,map__38606,map__38606__$1,map__38607,map__38607__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38603,map__38603__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__38605,map__38605__$1,map__38606,map__38606__$1,map__38607,map__38607__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38603,map__38603__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var class_name = elem.className;
var checked_QMARK_ = elem.checked;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__38618 = elem.getAttribute("data-id");
return parseInt(G__38618);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
var select_unselect_all_records_chkbox = document.getElementById(hatti.views.table.select_unselect_all_records_id);
var map__38617 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38617__$1 = ((((!((map__38617 == null)))?((((map__38617.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38617.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38617):map__38617);
var selected_table_rows = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38617__$1,cljs.core.cst$kw$selected_DASH_table_DASH_rows);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(class_name,hatti.views.table.delete_record_class)){
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
var row__$1 = (function (){var G__38620 = grid.getCellFromEvent(e).row;
return parseInt(G__38620);
})();
hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,data_id);

select_unselect_all_records_chkbox.checked = hatti.views.table.check_select_unselect_all_records_element_QMARK_();

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38617,map__38617__$1,selected_table_rows,map__38605,map__38605__$1,map__38606,map__38606__$1,map__38607,map__38607__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38603,map__38603__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(selected_table_rows,row__$1) : fn.call(null,selected_table_rows,row__$1));
});})(fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38617,map__38617__$1,selected_table_rows,map__38605,map__38605__$1,map__38606,map__38606__$1,map__38607,map__38607__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38603,map__38603__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
}
});})(map__38605,map__38605__$1,map__38606,map__38606__$1,map__38607,map__38607__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38603,map__38603__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__13216__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,event_chan){
return (function (state_38933){
var state_val_38934 = (state_38933[(1)]);
if((state_val_38934 === (7))){
var inst_38831 = (state_38933[(7)]);
var inst_38831__$1 = (state_38933[(2)]);
var inst_38833 = (inst_38831__$1 == null);
var inst_38834 = cljs.core.not(inst_38833);
var state_38933__$1 = (function (){var statearr_38935 = state_38933;
(statearr_38935[(7)] = inst_38831__$1);

return statearr_38935;
})();
if(inst_38834){
var statearr_38936_39011 = state_38933__$1;
(statearr_38936_39011[(1)] = (8));

} else {
var statearr_38937_39012 = state_38933__$1;
(statearr_38937_39012[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (20))){
var inst_38861 = (state_38933[(8)]);
var inst_38853 = (state_38933[(9)]);
var inst_38870 = (inst_38861.cljs$core$IFn$_invoke$arity$1 ? inst_38861.cljs$core$IFn$_invoke$arity$1(inst_38853) : inst_38861.call(null,inst_38853));
var state_38933__$1 = state_38933;
var statearr_38938_39013 = state_38933__$1;
(statearr_38938_39013[(2)] = inst_38870);

(statearr_38938_39013[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (27))){
var state_38933__$1 = state_38933;
var statearr_38939_39014 = state_38933__$1;
(statearr_38939_39014[(2)] = null);

(statearr_38939_39014[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (1))){
var state_38933__$1 = state_38933;
var statearr_38940_39015 = state_38933__$1;
(statearr_38940_39015[(2)] = null);

(statearr_38940_39015[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (24))){
var state_38933__$1 = state_38933;
var statearr_38941_39016 = state_38933__$1;
(statearr_38941_39016[(2)] = null);

(statearr_38941_39016[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (4))){
var state_38933__$1 = state_38933;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38933__$1,(7),event_chan);
} else {
if((state_val_38934 === (15))){
var inst_38831 = (state_38933[(7)]);
var state_38933__$1 = state_38933;
var statearr_38942_39017 = state_38933__$1;
(statearr_38942_39017[(2)] = inst_38831);

(statearr_38942_39017[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (21))){
var state_38933__$1 = state_38933;
var statearr_38943_39018 = state_38933__$1;
(statearr_38943_39018[(2)] = null);

(statearr_38943_39018[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (31))){
var inst_38857 = (state_38933[(10)]);
var inst_38906 = (state_38933[(2)]);
var inst_38907 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38857,cljs.core.cst$kw$table);
var state_38933__$1 = (function (){var statearr_38944 = state_38933;
(statearr_38944[(11)] = inst_38906);

return statearr_38944;
})();
if(inst_38907){
var statearr_38945_39019 = state_38933__$1;
(statearr_38945_39019[(1)] = (32));

} else {
var statearr_38946_39020 = state_38933__$1;
(statearr_38946_39020[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (32))){
var inst_38856 = (state_38933[(12)]);
var inst_38861 = (state_38933[(8)]);
var inst_38857 = (state_38933[(10)]);
var inst_38862 = (state_38933[(13)]);
var inst_38851 = (state_38933[(14)]);
var inst_38854 = (state_38933[(15)]);
var inst_38853 = (state_38933[(9)]);
var inst_38855 = (state_38933[(16)]);
var inst_38852 = (state_38933[(17)]);
var inst_38920 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38921 = (function (){var new_columns = inst_38856;
var submission_clicked = inst_38853;
var submission_unclicked = inst_38854;
var get_submission_data = inst_38862;
var re_render = inst_38857;
var update_data_BANG_ = inst_38861;
var submission_to_rank = inst_38852;
var map__38829 = inst_38851;
var c__13216__auto____$1 = inst_38920;
var filter_by = inst_38855;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38829,c__13216__auto____$1,filter_by,inst_38856,inst_38861,inst_38857,inst_38862,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38920,state_val_38934,c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38829,c__13216__auto____$1,filter_by,inst_38856,inst_38861,inst_38857,inst_38862,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38920,state_val_38934,c__13216__auto__,event_chan){
return (function (state_38918){
var state_val_38919 = (state_38918[(1)]);
if((state_val_38919 === (1))){
var inst_38909 = cljs.core.async.timeout((20));
var state_38918__$1 = state_38918;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38918__$1,(2),inst_38909);
} else {
if((state_val_38919 === (2))){
var inst_38911 = (state_38918[(2)]);
var inst_38912 = grid.resizeCanvas();
var inst_38913 = grid.invalidateAllRows();
var inst_38914 = hatti.views.table.resizeColumns(grid);
var inst_38915 = grid.render();
var inst_38916 = hatti.views.table.init_sg_pager(grid,dataview);
var state_38918__$1 = (function (){var statearr_38947 = state_38918;
(statearr_38947[(7)] = inst_38915);

(statearr_38947[(8)] = inst_38912);

(statearr_38947[(9)] = inst_38911);

(statearr_38947[(10)] = inst_38913);

(statearr_38947[(11)] = inst_38914);

return statearr_38947;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38918__$1,inst_38916);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38829,c__13216__auto____$1,filter_by,inst_38856,inst_38861,inst_38857,inst_38862,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38920,state_val_38934,c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38829,c__13216__auto____$1,filter_by,inst_38856,inst_38861,inst_38857,inst_38862,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38920,state_val_38934,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_38951 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38951[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_38951[(1)] = (1));

return statearr_38951;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_38918){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_38918);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e38952){if((e38952 instanceof Object)){
var ex__13108__auto__ = e38952;
var statearr_38953_39021 = state_38918;
(statearr_38953_39021[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38918);

return cljs.core.cst$kw$recur;
} else {
throw e38952;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39022 = state_38918;
state_38918 = G__39022;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_38918){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_38918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38829,c__13216__auto____$1,filter_by,inst_38856,inst_38861,inst_38857,inst_38862,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38920,state_val_38934,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_38954 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_38954[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto____$1);

return statearr_38954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38829,c__13216__auto____$1,filter_by,inst_38856,inst_38861,inst_38857,inst_38862,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38920,state_val_38934,c__13216__auto__,event_chan))
})();
var inst_38922 = cljs.core.async.impl.dispatch.run(inst_38921);
var state_38933__$1 = (function (){var statearr_38955 = state_38933;
(statearr_38955[(18)] = inst_38922);

return statearr_38955;
})();
var statearr_38956_39023 = state_38933__$1;
(statearr_38956_39023[(2)] = inst_38920);

(statearr_38956_39023[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (33))){
var state_38933__$1 = state_38933;
var statearr_38957_39024 = state_38933__$1;
(statearr_38957_39024[(2)] = null);

(statearr_38957_39024[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (13))){
var inst_38843 = (state_38933[(2)]);
var state_38933__$1 = state_38933;
var statearr_38958_39025 = state_38933__$1;
(statearr_38958_39025[(2)] = inst_38843);

(statearr_38958_39025[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (22))){
var inst_38854 = (state_38933[(15)]);
var inst_38873 = (state_38933[(2)]);
var state_38933__$1 = (function (){var statearr_38959 = state_38933;
(statearr_38959[(19)] = inst_38873);

return statearr_38959;
})();
if(cljs.core.truth_(inst_38854)){
var statearr_38960_39026 = state_38933__$1;
(statearr_38960_39026[(1)] = (23));

} else {
var statearr_38961_39027 = state_38933__$1;
(statearr_38961_39027[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (29))){
var inst_38855 = (state_38933[(16)]);
var inst_38898 = [cljs.core.cst$kw$query];
var inst_38899 = [inst_38855];
var inst_38900 = cljs.core.PersistentHashMap.fromArrays(inst_38898,inst_38899);
var inst_38901 = cljs.core.clj__GT_js(inst_38900);
var inst_38902 = dataview.setFilterArgs(inst_38901);
var inst_38903 = dataview.refresh();
var state_38933__$1 = (function (){var statearr_38962 = state_38933;
(statearr_38962[(20)] = inst_38902);

return statearr_38962;
})();
var statearr_38963_39028 = state_38933__$1;
(statearr_38963_39028[(2)] = inst_38903);

(statearr_38963_39028[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (6))){
var inst_38929 = (state_38933[(2)]);
var state_38933__$1 = state_38933;
var statearr_38964_39029 = state_38933__$1;
(statearr_38964_39029[(2)] = inst_38929);

(statearr_38964_39029[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (28))){
var inst_38855 = (state_38933[(16)]);
var inst_38896 = (state_38933[(2)]);
var state_38933__$1 = (function (){var statearr_38965 = state_38933;
(statearr_38965[(21)] = inst_38896);

return statearr_38965;
})();
if(cljs.core.truth_(inst_38855)){
var statearr_38966_39030 = state_38933__$1;
(statearr_38966_39030[(1)] = (29));

} else {
var statearr_38967_39031 = state_38933__$1;
(statearr_38967_39031[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (25))){
var inst_38856 = (state_38933[(12)]);
var inst_38878 = (state_38933[(2)]);
var state_38933__$1 = (function (){var statearr_38968 = state_38933;
(statearr_38968[(22)] = inst_38878);

return statearr_38968;
})();
if(cljs.core.truth_(inst_38856)){
var statearr_38969_39032 = state_38933__$1;
(statearr_38969_39032[(1)] = (26));

} else {
var statearr_38970_39033 = state_38933__$1;
(statearr_38970_39033[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (34))){
var inst_38925 = (state_38933[(2)]);
var state_38933__$1 = (function (){var statearr_38971 = state_38933;
(statearr_38971[(23)] = inst_38925);

return statearr_38971;
})();
var statearr_38972_39034 = state_38933__$1;
(statearr_38972_39034[(2)] = null);

(statearr_38972_39034[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (17))){
var inst_38861 = (state_38933[(8)]);
var inst_38862 = (state_38933[(13)]);
var inst_38852 = (state_38933[(17)]);
var inst_38864 = (inst_38862.cljs$core$IFn$_invoke$arity$2 ? inst_38862.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_38852) : inst_38862.call(null,hatti.constants._rank,inst_38852));
var inst_38865 = (inst_38861.cljs$core$IFn$_invoke$arity$1 ? inst_38861.cljs$core$IFn$_invoke$arity$1(inst_38864) : inst_38861.call(null,inst_38864));
var state_38933__$1 = state_38933;
var statearr_38973_39035 = state_38933__$1;
(statearr_38973_39035[(2)] = inst_38865);

(statearr_38973_39035[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (3))){
var inst_38931 = (state_38933[(2)]);
var state_38933__$1 = state_38933;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38933__$1,inst_38931);
} else {
if((state_val_38934 === (12))){
var state_38933__$1 = state_38933;
var statearr_38974_39036 = state_38933__$1;
(statearr_38974_39036[(2)] = false);

(statearr_38974_39036[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (2))){
var state_38933__$1 = state_38933;
var statearr_38975_39037 = state_38933__$1;
(statearr_38975_39037[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (23))){
var inst_38861 = (state_38933[(8)]);
var inst_38875 = (inst_38861.cljs$core$IFn$_invoke$arity$1 ? inst_38861.cljs$core$IFn$_invoke$arity$1(null) : inst_38861.call(null,null));
var state_38933__$1 = state_38933;
var statearr_38977_39038 = state_38933__$1;
(statearr_38977_39038[(2)] = inst_38875);

(statearr_38977_39038[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (19))){
var inst_38853 = (state_38933[(9)]);
var inst_38868 = (state_38933[(2)]);
var state_38933__$1 = (function (){var statearr_38978 = state_38933;
(statearr_38978[(24)] = inst_38868);

return statearr_38978;
})();
if(cljs.core.truth_(inst_38853)){
var statearr_38979_39039 = state_38933__$1;
(statearr_38979_39039[(1)] = (20));

} else {
var statearr_38980_39040 = state_38933__$1;
(statearr_38980_39040[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (11))){
var state_38933__$1 = state_38933;
var statearr_38981_39041 = state_38933__$1;
(statearr_38981_39041[(2)] = true);

(statearr_38981_39041[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (9))){
var state_38933__$1 = state_38933;
var statearr_38982_39042 = state_38933__$1;
(statearr_38982_39042[(2)] = false);

(statearr_38982_39042[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (5))){
var state_38933__$1 = state_38933;
var statearr_38983_39043 = state_38933__$1;
(statearr_38983_39043[(2)] = null);

(statearr_38983_39043[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (14))){
var inst_38831 = (state_38933[(7)]);
var inst_38848 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38831);
var state_38933__$1 = state_38933;
var statearr_38984_39044 = state_38933__$1;
(statearr_38984_39044[(2)] = inst_38848);

(statearr_38984_39044[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (26))){
var inst_38856 = (state_38933[(12)]);
var inst_38861 = (state_38933[(8)]);
var inst_38857 = (state_38933[(10)]);
var inst_38862 = (state_38933[(13)]);
var inst_38851 = (state_38933[(14)]);
var inst_38854 = (state_38933[(15)]);
var inst_38853 = (state_38933[(9)]);
var inst_38855 = (state_38933[(16)]);
var inst_38852 = (state_38933[(17)]);
var inst_38891 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38892 = (function (){var new_columns = inst_38856;
var submission_clicked = inst_38853;
var submission_unclicked = inst_38854;
var get_submission_data = inst_38862;
var re_render = inst_38857;
var update_data_BANG_ = inst_38861;
var submission_to_rank = inst_38852;
var map__38829 = inst_38851;
var c__13216__auto____$1 = inst_38891;
var filter_by = inst_38855;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38829,c__13216__auto____$1,filter_by,inst_38856,inst_38861,inst_38857,inst_38862,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38891,state_val_38934,c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38829,c__13216__auto____$1,filter_by,inst_38856,inst_38861,inst_38857,inst_38862,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38891,state_val_38934,c__13216__auto__,event_chan){
return (function (state_38889){
var state_val_38890 = (state_38889[(1)]);
if((state_val_38890 === (1))){
var inst_38880 = cljs.core.async.timeout((20));
var state_38889__$1 = state_38889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38889__$1,(2),inst_38880);
} else {
if((state_val_38890 === (2))){
var inst_38882 = (state_38889[(2)]);
var inst_38883 = grid.setColumns(new_columns);
var inst_38884 = hatti.views.table.resizeColumns(grid);
var inst_38885 = grid.render();
var inst_38886 = hatti.views.table.select_rows_marked_to_be_deleted();
var inst_38887 = hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
var state_38889__$1 = (function (){var statearr_38985 = state_38889;
(statearr_38985[(7)] = inst_38883);

(statearr_38985[(8)] = inst_38886);

(statearr_38985[(9)] = inst_38882);

(statearr_38985[(10)] = inst_38885);

(statearr_38985[(11)] = inst_38884);

return statearr_38985;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38889__$1,inst_38887);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38829,c__13216__auto____$1,filter_by,inst_38856,inst_38861,inst_38857,inst_38862,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38891,state_val_38934,c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38829,c__13216__auto____$1,filter_by,inst_38856,inst_38861,inst_38857,inst_38862,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38891,state_val_38934,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_38989 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38989[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_38989[(1)] = (1));

return statearr_38989;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_38889){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_38889);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e38990){if((e38990 instanceof Object)){
var ex__13108__auto__ = e38990;
var statearr_38991_39045 = state_38889;
(statearr_38991_39045[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38889);

return cljs.core.cst$kw$recur;
} else {
throw e38990;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39046 = state_38889;
state_38889 = G__39046;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_38889){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_38889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38829,c__13216__auto____$1,filter_by,inst_38856,inst_38861,inst_38857,inst_38862,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38891,state_val_38934,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_38992 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_38992[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto____$1);

return statearr_38992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38829,c__13216__auto____$1,filter_by,inst_38856,inst_38861,inst_38857,inst_38862,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38891,state_val_38934,c__13216__auto__,event_chan))
})();
var inst_38893 = cljs.core.async.impl.dispatch.run(inst_38892);
var state_38933__$1 = (function (){var statearr_38993 = state_38933;
(statearr_38993[(25)] = inst_38893);

return statearr_38993;
})();
var statearr_38994_39047 = state_38933__$1;
(statearr_38994_39047[(2)] = inst_38891);

(statearr_38994_39047[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (16))){
var inst_38856 = (state_38933[(12)]);
var inst_38861 = (state_38933[(8)]);
var inst_38857 = (state_38933[(10)]);
var inst_38851 = (state_38933[(14)]);
var inst_38854 = (state_38933[(15)]);
var inst_38853 = (state_38933[(9)]);
var inst_38855 = (state_38933[(16)]);
var inst_38852 = (state_38933[(17)]);
var inst_38851__$1 = (state_38933[(2)]);
var inst_38852__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38851__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_38853__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38851__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_38854__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38851__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_38855__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38851__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_38856__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38851__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_38857__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38851__$1,cljs.core.cst$kw$re_DASH_render);
var inst_38858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38859 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_38860 = (new cljs.core.PersistentVector(null,3,(5),inst_38858,inst_38859,null));
var inst_38861__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_38860);
var inst_38862 = (function (){var map__38829 = inst_38851__$1;
var submission_to_rank = inst_38852__$1;
var submission_clicked = inst_38853__$1;
var submission_unclicked = inst_38854__$1;
var filter_by = inst_38855__$1;
var new_columns = inst_38856__$1;
var re_render = inst_38857__$1;
var update_data_BANG_ = inst_38861__$1;
return ((function (map__38829,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38856,inst_38861,inst_38857,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38851__$1,inst_38852__$1,inst_38853__$1,inst_38854__$1,inst_38855__$1,inst_38856__$1,inst_38857__$1,inst_38858,inst_38859,inst_38860,inst_38861__$1,state_val_38934,c__13216__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__38829,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38856,inst_38861,inst_38857,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38851__$1,inst_38852__$1,inst_38853__$1,inst_38854__$1,inst_38855__$1,inst_38856__$1,inst_38857__$1,inst_38858,inst_38859,inst_38860,inst_38861__$1,state_val_38934,c__13216__auto__,event_chan){
return (function (p1__38642_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__38642_SHARP_,field));
});})(map__38829,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38856,inst_38861,inst_38857,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38851__$1,inst_38852__$1,inst_38853__$1,inst_38854__$1,inst_38855__$1,inst_38856__$1,inst_38857__$1,inst_38858,inst_38859,inst_38860,inst_38861__$1,state_val_38934,c__13216__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(map__38829,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38856,inst_38861,inst_38857,inst_38851,inst_38854,inst_38853,inst_38855,inst_38852,inst_38851__$1,inst_38852__$1,inst_38853__$1,inst_38854__$1,inst_38855__$1,inst_38856__$1,inst_38857__$1,inst_38858,inst_38859,inst_38860,inst_38861__$1,state_val_38934,c__13216__auto__,event_chan))
})();
var state_38933__$1 = (function (){var statearr_38995 = state_38933;
(statearr_38995[(12)] = inst_38856__$1);

(statearr_38995[(8)] = inst_38861__$1);

(statearr_38995[(10)] = inst_38857__$1);

(statearr_38995[(13)] = inst_38862);

(statearr_38995[(14)] = inst_38851__$1);

(statearr_38995[(15)] = inst_38854__$1);

(statearr_38995[(9)] = inst_38853__$1);

(statearr_38995[(16)] = inst_38855__$1);

(statearr_38995[(17)] = inst_38852__$1);

return statearr_38995;
})();
if(cljs.core.truth_(inst_38852__$1)){
var statearr_38996_39048 = state_38933__$1;
(statearr_38996_39048[(1)] = (17));

} else {
var statearr_38997_39049 = state_38933__$1;
(statearr_38997_39049[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (30))){
var state_38933__$1 = state_38933;
var statearr_38998_39050 = state_38933__$1;
(statearr_38998_39050[(2)] = null);

(statearr_38998_39050[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (10))){
var inst_38846 = (state_38933[(2)]);
var state_38933__$1 = state_38933;
if(cljs.core.truth_(inst_38846)){
var statearr_38999_39051 = state_38933__$1;
(statearr_38999_39051[(1)] = (14));

} else {
var statearr_39000_39052 = state_38933__$1;
(statearr_39000_39052[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (18))){
var state_38933__$1 = state_38933;
var statearr_39001_39053 = state_38933__$1;
(statearr_39001_39053[(2)] = null);

(statearr_39001_39053[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (8))){
var inst_38831 = (state_38933[(7)]);
var inst_38836 = inst_38831.cljs$lang$protocol_mask$partition0$;
var inst_38837 = (inst_38836 & (64));
var inst_38838 = inst_38831.cljs$core$ISeq$;
var inst_38839 = (inst_38837) || (inst_38838);
var state_38933__$1 = state_38933;
if(cljs.core.truth_(inst_38839)){
var statearr_39002_39054 = state_38933__$1;
(statearr_39002_39054[(1)] = (11));

} else {
var statearr_39003_39055 = state_38933__$1;
(statearr_39003_39055[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_39007 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39007[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_39007[(1)] = (1));

return statearr_39007;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_38933){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_38933);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e39008){if((e39008 instanceof Object)){
var ex__13108__auto__ = e39008;
var statearr_39009_39056 = state_38933;
(statearr_39009_39056[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38933);

return cljs.core.cst$kw$recur;
} else {
throw e39008;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39057 = state_38933;
state_38933 = G__39057;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_38933){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_38933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_39010 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_39010[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_39010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto__,event_chan))
);

return c__13216__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$field_DASH_key,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__39076(s__39077){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__39077__$1 = s__39077;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39077__$1);
if(temp__4657__auto__){
var s__39077__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39077__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39077__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39079 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39078 = (0);
while(true){
if((i__39078 < size__7188__auto__)){
var vec__39088 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39078);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39088,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39088,(1),null);
cljs.core.chunk_append(b__39079,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__39078,vec__39088,k,v,c__7187__auto__,size__7188__auto__,b__39079,s__39077__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__39078,vec__39088,k,v,c__7187__auto__,size__7188__auto__,b__39079,s__39077__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__39094 = (i__39078 + (1));
i__39078 = G__39094;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39079),hatti$views$table$render_options_$_iter__39076(cljs.core.chunk_rest(s__39077__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39079),null);
}
} else {
var vec__39091 = cljs.core.first(s__39077__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39091,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39091,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__39091,k,v,s__39077__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__39091,k,v,s__39077__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__39076(cljs.core.rest(s__39077__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39096 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39096 = (function (_,owner,meta39097){
this._ = _;
this.owner = owner;
this.meta39097 = meta39097;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39096.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39098,meta39097__$1){
var self__ = this;
var _39098__$1 = this;
return (new hatti.views.table.t_hatti$views$table39096(self__._,self__.owner,meta39097__$1));
});

hatti.views.table.t_hatti$views$table39096.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39098){
var self__ = this;
var _39098__$1 = this;
return self__.meta39097;
});

hatti.views.table.t_hatti$views$table39096.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table39096.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field_DASH_key,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table39096.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39096.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__39099){
var self__ = this;
var map__39100 = p__39099;
var map__39100__$1 = ((((!((map__39100 == null)))?((((map__39100.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39100.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39100):map__39100);
var field_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39100__$1,cljs.core.cst$kw$field_DASH_key);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39100__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__39102 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39102__$1 = ((((!((map__39102 == null)))?((((map__39102.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39102.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39102):map__39102);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39102__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__39102,map__39102__$1,flat_form,new_language,___$2,map__39100,map__39100__$1,field_key,language){
return (function (p1__39095_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(flat_form,cljs.core.array_seq([cljs.core.cst$kw$get_DASH_label_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__39095_SHARP_),cljs.core.cst$kw$language,new_language,cljs.core.cst$kw$owner,self__.owner], 0))], null));
});})(options,map__39102,map__39102__$1,flat_form,new_language,___$2,map__39100,map__39100__$1,field_key,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(field_key);
} else {
}

var G__39112 = ({"className": "label-changer"});
var G__39113 = (function (){var G__39115 = ({"className": "label-changer-label"});
var G__39116 = "Show:";
return React.DOM.span(G__39115,G__39116);
})();
var G__39114 = (function (){var G__39117 = ({"id": "header-display-dropdown", "className": "drop-hover"});
var G__39118 = (function (){var attrs39106 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(field_key) : options.call(null,field_key));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs39106))?sablono.interpreter.attributes(attrs39106):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39106))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__39120 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39120);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39106),(function (){var G__39121 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39121);
})()], null))));
})();
var G__39119 = (function (){var attrs39111 = hatti.views.table.render_options(options,self__.owner,colset_BANG_);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.ul,((cljs.core.map_QMARK_(attrs39111))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs39111], 0))):({"className": "submenu no-dot"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39111))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39111)], null))));
})();
return React.DOM.div(G__39117,G__39118,G__39119);
})();
return React.DOM.div(G__39112,G__39113,G__39114);
});

hatti.views.table.t_hatti$views$table39096.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39097], null);
});

hatti.views.table.t_hatti$views$table39096.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39096.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39096";

hatti.views.table.t_hatti$views$table39096.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39096");
});

hatti.views.table.__GT_t_hatti$views$table39096 = (function hatti$views$table$__GT_t_hatti$views$table39096(___$1,owner__$1,meta39097){
return (new hatti.views.table.t_hatti$views$table39096(___$1,owner__$1,meta39097));
});

}

return (new hatti.views.table.t_hatti$views$table39096(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__13216__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto__,query){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,query){
return (function (state_39164){
var state_val_39165 = (state_39164[(1)]);
if((state_val_39165 === (1))){
var inst_39150 = cljs.core.async.timeout((150));
var state_39164__$1 = state_39164;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39164__$1,(2),inst_39150);
} else {
if((state_val_39165 === (2))){
var inst_39152 = (state_39164[(2)]);
var inst_39153 = input.value;
var inst_39154 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_39153);
var state_39164__$1 = (function (){var statearr_39166 = state_39164;
(statearr_39166[(7)] = inst_39152);

return statearr_39166;
})();
if(inst_39154){
var statearr_39167_39178 = state_39164__$1;
(statearr_39167_39178[(1)] = (3));

} else {
var statearr_39168_39179 = state_39164__$1;
(statearr_39168_39179[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39165 === (3))){
var inst_39156 = [query_event_key];
var inst_39157 = [query];
var inst_39158 = cljs.core.PersistentHashMap.fromArrays(inst_39156,inst_39157);
var inst_39159 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_39158);
var state_39164__$1 = state_39164;
var statearr_39169_39180 = state_39164__$1;
(statearr_39169_39180[(2)] = inst_39159);

(statearr_39169_39180[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39165 === (4))){
var state_39164__$1 = state_39164;
var statearr_39170_39181 = state_39164__$1;
(statearr_39170_39181[(2)] = null);

(statearr_39170_39181[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39165 === (5))){
var inst_39162 = (state_39164[(2)]);
var state_39164__$1 = state_39164;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39164__$1,inst_39162);
} else {
return null;
}
}
}
}
}
});})(c__13216__auto__,query))
;
return ((function (switch__13104__auto__,c__13216__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__13105__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__13105__auto____0 = (function (){
var statearr_39174 = [null,null,null,null,null,null,null,null];
(statearr_39174[(0)] = hatti$views$table$delayed_search_$_state_machine__13105__auto__);

(statearr_39174[(1)] = (1));

return statearr_39174;
});
var hatti$views$table$delayed_search_$_state_machine__13105__auto____1 = (function (state_39164){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_39164);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e39175){if((e39175 instanceof Object)){
var ex__13108__auto__ = e39175;
var statearr_39176_39182 = state_39164;
(statearr_39176_39182[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39164);

return cljs.core.cst$kw$recur;
} else {
throw e39175;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39183 = state_39164;
state_39164 = G__39183;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__13105__auto__ = function(state_39164){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__13105__auto____1.call(this,state_39164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__13105__auto____0;
hatti$views$table$delayed_search_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__13105__auto____1;
return hatti$views$table$delayed_search_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,query))
})();
var state__13218__auto__ = (function (){var statearr_39177 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_39177[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_39177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto__,query))
);

return c__13216__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39185 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39185 = (function (_,owner,meta39186){
this._ = _;
this.owner = owner;
this.meta39186 = meta39186;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39185.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39187,meta39186__$1){
var self__ = this;
var _39187__$1 = this;
return (new hatti.views.table.t_hatti$views$table39185(self__._,self__.owner,meta39186__$1));
});

hatti.views.table.t_hatti$views$table39185.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39187){
var self__ = this;
var _39187__$1 = this;
return self__.meta39186;
});

hatti.views.table.t_hatti$views$table39185.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39185.prototype.om$core$IRender$render$arity$1 = (function (this__19159__auto__){
var self__ = this;
var this__19159__auto____$1 = this;
var G__39190 = ({"className": "table-search"});
var G__39191 = (function (){var G__39193 = ({"className": "fa fa-search"});
return React.DOM.i(G__39193);
})();
var G__39192 = (function (){var G__39194 = ({"type": "text", "placeholder": "Search", "onChange": ((function (G__39190,G__39191,this__19159__auto____$1){
return (function (p1__39184_SHARP_){
return hatti.views.table.delayed_search(p1__39184_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__39190,G__39191,this__19159__auto____$1))
});
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__39194) : sablono.interpreter.input.call(null,G__39194));
})();
return React.DOM.div(G__39190,G__39191,G__39192);
});

hatti.views.table.t_hatti$views$table39185.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39186], null);
});

hatti.views.table.t_hatti$views$table39185.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39185.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39185";

hatti.views.table.t_hatti$views$table39185.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39185");
});

hatti.views.table.__GT_t_hatti$views$table39185 = (function hatti$views$table$__GT_t_hatti$views$table39185(___$1,owner__$1,meta39186){
return (new hatti.views.table.t_hatti$views$table39185(___$1,owner__$1,meta39186));
});

}

return (new hatti.views.table.t_hatti$views$table39185(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table39195 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39195 = (function (cursor,owner,meta39196){
this.cursor = cursor;
this.owner = owner;
this.meta39196 = meta39196;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39195.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39197,meta39196__$1){
var self__ = this;
var _39197__$1 = this;
return (new hatti.views.table.t_hatti$views$table39195(self__.cursor,self__.owner,meta39196__$1));
});

hatti.views.table.t_hatti$views$table39195.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39197){
var self__ = this;
var _39197__$1 = this;
return self__.meta39196;
});

hatti.views.table.t_hatti$views$table39195.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39195.prototype.om$core$IRender$render$arity$1 = (function (this__19159__auto__){
var self__ = this;
var this__19159__auto____$1 = this;
var G__39200 = ({"className": "topbar"});
var G__39201 = (function (){var G__39205 = ({"id": hatti.views.table.pager_id});
return React.DOM.div(G__39205);
})();
var G__39202 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,self__.cursor));
var G__39203 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.cursor));
var G__39204 = (function (){var G__39206 = ({"style": ({"clear": "both"})});
return React.DOM.div(G__39206);
})();
return React.DOM.div(G__39200,G__39201,G__39202,G__39203,G__39204);
});

hatti.views.table.t_hatti$views$table39195.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39196], null);
});

hatti.views.table.t_hatti$views$table39195.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39195.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39195";

hatti.views.table.t_hatti$views$table39195.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39195");
});

hatti.views.table.__GT_t_hatti$views$table39195 = (function hatti$views$table$__GT_t_hatti$views$table39195(cursor__$1,owner__$1,meta39196){
return (new hatti.views.table.t_hatti$views$table39195(cursor__$1,owner__$1,meta39196));
});

}

return (new hatti.views.table.t_hatti$views$table39195(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq(data)){
var map__39212 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__39212__$1 = ((((!((map__39212 == null)))?((((map__39212.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39212.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39212):map__39212);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39212__$1,cljs.core.cst$kw$flat_DASH_form);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__39213 = hatti.views.table.sg_init(data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39213,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39213,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$table_DASH_view_DASH_height,hatti.views.table.get_table_view_height());
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$resize_DASH_handler,resize_handler);
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__39218,owner,p__39219){
var map__39220 = p__39218;
var map__39220__$1 = ((((!((map__39220 == null)))?((((map__39220.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39220.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39220):map__39220);
var cursor = map__39220__$1;
var map__39221 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39220__$1,cljs.core.cst$kw$views);
var map__39221__$1 = ((((!((map__39221 == null)))?((((map__39221.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39221.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39221):map__39221);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39221__$1,cljs.core.cst$kw$active);
var map__39222 = p__39219;
var map__39222__$1 = ((((!((map__39222 == null)))?((((map__39222.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39222.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39222):map__39222);
var opts = map__39222__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39222__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

var active_QMARK_ = chimera.seq.in_QMARK_(active,cljs.core.cst$kw$table);
if(typeof hatti.views.table.t_hatti$views$table39226 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39226 = (function (p__39218,owner,active_QMARK_,slick_grid_event_handlers,p__39219,cursor,map__39221,map__39222,active,opts,map__39220,meta39227){
this.p__39218 = p__39218;
this.owner = owner;
this.active_QMARK_ = active_QMARK_;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.p__39219 = p__39219;
this.cursor = cursor;
this.map__39221 = map__39221;
this.map__39222 = map__39222;
this.active = active;
this.opts = opts;
this.map__39220 = map__39220;
this.meta39227 = meta39227;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39226.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers){
return (function (_39228,meta39227__$1){
var self__ = this;
var _39228__$1 = this;
return (new hatti.views.table.t_hatti$views$table39226(self__.p__39218,self__.owner,self__.active_QMARK_,self__.slick_grid_event_handlers,self__.p__39219,self__.cursor,self__.map__39221,self__.map__39222,self__.active,self__.opts,self__.map__39220,meta39227__$1));
});})(active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39226.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers){
return (function (_39228){
var self__ = this;
var _39228__$1 = this;
return self__.meta39227;
});})(active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39226.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39226.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers){
return (function (_,p__39229){
var self__ = this;
var map__39230 = p__39229;
var map__39230__$1 = ((((!((map__39230 == null)))?((((map__39230.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39230.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39230):map__39230);
var table_view_height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39230__$1,cljs.core.cst$kw$table_DASH_view_DASH_height);
var ___$1 = this;
var map__39232 = self__.cursor;
var map__39232__$1 = ((((!((map__39232 == null)))?((((map__39232.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39232.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39232):map__39232);
var map__39233 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39232__$1,cljs.core.cst$kw$table_DASH_page);
var map__39233__$1 = ((((!((map__39233 == null)))?((((map__39233.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39233.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39233):map__39233);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39233__$1,cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_);
var submission_clicked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39233__$1,cljs.core.cst$kw$submission_DASH_clicked);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39232__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39232__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__39234 = dataset_info;
var map__39234__$1 = ((((!((map__39234 == null)))?((((map__39234.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39234.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39234):map__39234);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39234__$1,cljs.core.cst$kw$num_of_submissions);
var no_data_QMARK_ = cljs.core.empty_QMARK_(data);
var with_info = ((function (map__39232,map__39232__$1,map__39233,map__39233__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__39234,map__39234__$1,num_of_submissions,no_data_QMARK_,___$1,map__39230,map__39230__$1,table_view_height,active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers){
return (function (p1__39217_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.cursor,p1__39217_SHARP_], 0));
});})(map__39232,map__39232__$1,map__39233,map__39233__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__39234,map__39234__$1,num_of_submissions,no_data_QMARK_,___$1,map__39230,map__39230__$1,table_view_height,active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
var G__39238 = ({"style": cljs.core.clj__GT_js((cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$height,(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height();
}
})(),cljs.core.cst$kw$overflow,"hidden"], null):null)), "className": "table-view"});
var G__39239 = sablono.interpreter.interpret((cljs.core.truth_(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null)):null));
var G__39240 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.cursor));
var G__39241 = (function (){var G__39242 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__39243 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__39248 = ({"className": "alert alert-warning"});
var G__39249 = "No data";
return React.DOM.p(G__39248,G__39249);
})():(function (){var G__39250 = null;
var G__39251 = (function (){var G__39253 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__39253);
})();
var G__39252 = "Loading...";
return React.DOM.span(G__39250,G__39251,G__39252);
})());
return React.DOM.div(G__39242,G__39243);
})();
return React.DOM.div(G__39238,G__39239,G__39240,G__39241);
} else {
return null;
}
});})(active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39226.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table39226.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler(self__.owner);

var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39254 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39254,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39254,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39226.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table39226.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$resize_DASH_handler));
});})(active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39226.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table39226.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__39257 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39257__$1 = ((((!((map__39257 == null)))?((((map__39257.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39257.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39257):map__39257);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39257__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39257__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39259 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39259,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39259,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39226.getBasis = ((function (active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__39218,cljs.core.cst$sym$owner,cljs.core.cst$sym$active_QMARK_,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$p__39219,cljs.core.cst$sym$cursor,cljs.core.cst$sym$map__39221,cljs.core.cst$sym$map__39222,cljs.core.cst$sym$active,cljs.core.cst$sym$opts,cljs.core.cst$sym$map__39220,cljs.core.cst$sym$meta39227], null);
});})(active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39226.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39226.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39226";

hatti.views.table.t_hatti$views$table39226.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39226");
});})(active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table39226 = ((function (active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table39226(p__39218__$1,owner__$1,active_QMARK___$1,slick_grid_event_handlers__$1,p__39219__$1,cursor__$1,map__39221__$2,map__39222__$2,active__$1,opts__$1,map__39220__$2,meta39227){
return (new hatti.views.table.t_hatti$views$table39226(p__39218__$1,owner__$1,active_QMARK___$1,slick_grid_event_handlers__$1,p__39219__$1,cursor__$1,map__39221__$2,map__39222__$2,active__$1,opts__$1,map__39220__$2,meta39227));
});})(active_QMARK_,map__39220,map__39220__$1,cursor,map__39221,map__39221__$1,active,map__39222,map__39222__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table39226(p__39218,owner,active_QMARK_,slick_grid_event_handlers,p__39219,cursor,map__39221__$1,map__39222__$1,active,opts,map__39220__$1,cljs.core.PersistentArrayMap.EMPTY));
}));
