// Compiled by ClojureScript 1.9.229 {}
goog.provide('chimera.js_interop');
goog.require('cljs.core');
goog.require('cognitect.transit');
goog.require('goog.string');
/**
 * Convert json string to cljs object using transit.
 * Fast, but doesn't preserve keywords.
 */
chimera.js_interop.json__GT_cljs = (function chimera$js_interop$json__GT_cljs(s){
return cognitect.transit.read.call(null,cognitect.transit.reader.call(null,new cljs.core.Keyword(null,"json","json",1279968570)),s);
});
/**
 * Convert json to js using JSON.parse.
 * If error occurs, return the string unmodified.
 */
chimera.js_interop.str__GT_json = (function chimera$js_interop$str__GT_json(string){
try{return JSON.parse(string);
}catch (e11816){if((e11816 instanceof Error)){
var _ = e11816;
return string;
} else {
throw e11816;

}
}});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
chimera.js_interop.json__GT_js__GT_cljs = (function chimera$js_interop$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.call(null,chimera.js_interop.str__GT_json.call(null,s),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
chimera.js_interop.format = (function chimera$js_interop$format(var_args){
var args__7491__auto__ = [];
var len__7484__auto___11819 = arguments.length;
var i__7485__auto___11820 = (0);
while(true){
if((i__7485__auto___11820 < len__7484__auto___11819)){
args__7491__auto__.push((arguments[i__7485__auto___11820]));

var G__11821 = (i__7485__auto___11820 + (1));
i__7485__auto___11820 = G__11821;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.call(null,goog.string.format,fmt,args);
});

chimera.js_interop.format.cljs$lang$maxFixedArity = (1);

chimera.js_interop.format.cljs$lang$applyTo = (function (seq11817){
var G__11818 = cljs.core.first.call(null,seq11817);
var seq11817__$1 = cljs.core.next.call(null,seq11817);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic(G__11818,seq11817__$1);
});

/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
chimera.js_interop.safe_regex = (function chimera$js_interop$safe_regex(var_args){
var args__7491__auto__ = [];
var len__7484__auto___11827 = arguments.length;
var i__7485__auto___11828 = (0);
while(true){
if((i__7485__auto___11828 < len__7484__auto___11827)){
args__7491__auto__.push((arguments[i__7485__auto___11828]));

var G__11829 = (i__7485__auto___11828 + (1));
i__7485__auto___11828 = G__11829;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (query_string,p__11824){
var map__11825 = p__11824;
var map__11825__$1 = ((((!((map__11825 == null)))?((((map__11825.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11825.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11825):map__11825);
var ignore_case_QMARK_ = cljs.core.get.call(null,map__11825__$1,new cljs.core.Keyword(null,"ignore-case?","ignore-case?",-956106212),true);
return cljs.core.re_pattern.call(null,[cljs.core.str((cljs.core.truth_(ignore_case_QMARK_)?"(?i)":null)),cljs.core.str(goog.string.regExpEscape(query_string))].join(''));
});

chimera.js_interop.safe_regex.cljs$lang$maxFixedArity = (1);

chimera.js_interop.safe_regex.cljs$lang$applyTo = (function (seq11822){
var G__11823 = cljs.core.first.call(null,seq11822);
var seq11822__$1 = cljs.core.next.call(null,seq11822);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__11823,seq11822__$1);
});

