// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__7072__auto__ = (((x == null))?null:x);
var m__7073__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7073__auto__.call(null,x));
} else {
var m__7073__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7073__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return (c2.dom.select.cljs$core$IFn$_invoke$arity$1 ? c2.dom.select.cljs$core$IFn$_invoke$arity$1(selector) : c2.dom.select.call(null,selector));
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render(v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args39991 = [];
var len__7484__auto___39994 = arguments.length;
var i__7485__auto___39995 = (0);
while(true){
if((i__7485__auto___39995 < len__7484__auto___39994)){
args39991.push((arguments[i__7485__auto___39995]));

var G__39996 = (i__7485__auto___39995 + (1));
i__7485__auto___39995 = G__39996;
continue;
} else {
}
break;
}

var G__39993 = args39991.length;
switch (G__39993) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39991.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;

/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args39998 = [];
var len__7484__auto___40001 = arguments.length;
var i__7485__auto___40002 = (0);
while(true){
if((i__7485__auto___40002 < len__7484__auto___40001)){
args39998.push((arguments[i__7485__auto___40002]));

var G__40003 = (i__7485__auto___40002 + (1));
i__7485__auto___40002 = G__40003;
continue;
} else {
}
break;
}

var G__40000 = args39998.length;
switch (G__40000) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39998.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;

/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom(node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom(node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__40007_40009 = c2.dom.__GT_dom(container);
var G__40008_40010 = el__$1;
goog.dom.appendChild(G__40007_40009,G__40008_40010);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__40014_40017 = c2.dom.__GT_dom(container);
var G__40015_40018 = el__$1;
var G__40016_40019 = (0);
goog.dom.insertChildAt(G__40014_40017,G__40015_40018,G__40016_40019);

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
var G__40021 = c2.dom.__GT_dom(el);
return goog.dom.removeNode(G__40021);
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom(new$);
var G__40024_40026 = new$__$1;
var G__40025_40027 = c2.dom.__GT_dom(old);
goog.dom.replaceNode(G__40024_40026,G__40025_40027);

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args40028 = [];
var len__7484__auto___40046 = arguments.length;
var i__7485__auto___40047 = (0);
while(true){
if((i__7485__auto___40047 < len__7484__auto___40046)){
args40028.push((arguments[i__7485__auto___40047]));

var G__40048 = (i__7485__auto___40047 + (1));
i__7485__auto___40047 = G__40048;
continue;
} else {
}
break;
}

var G__40030 = args40028.length;
switch (G__40030) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40028.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
var G__40031 = el__$1;
var G__40032 = cljs.core.name(x);
return goog.style.getComputedStyle(G__40031,G__40032);
} else {
if(cljs.core.map_QMARK_(x)){
var seq__40033_40050 = cljs.core.seq(x);
var chunk__40034_40051 = null;
var count__40035_40052 = (0);
var i__40036_40053 = (0);
while(true){
if((i__40036_40053 < count__40035_40052)){
var vec__40037_40054 = chunk__40034_40051.cljs$core$IIndexed$_nth$arity$2(null,i__40036_40053);
var k_40055 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40037_40054,(0),null);
var v_40056 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40037_40054,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_40055,v_40056);

var G__40057 = seq__40033_40050;
var G__40058 = chunk__40034_40051;
var G__40059 = count__40035_40052;
var G__40060 = (i__40036_40053 + (1));
seq__40033_40050 = G__40057;
chunk__40034_40051 = G__40058;
count__40035_40052 = G__40059;
i__40036_40053 = G__40060;
continue;
} else {
var temp__4657__auto___40061 = cljs.core.seq(seq__40033_40050);
if(temp__4657__auto___40061){
var seq__40033_40062__$1 = temp__4657__auto___40061;
if(cljs.core.chunked_seq_QMARK_(seq__40033_40062__$1)){
var c__7220__auto___40063 = cljs.core.chunk_first(seq__40033_40062__$1);
var G__40064 = cljs.core.chunk_rest(seq__40033_40062__$1);
var G__40065 = c__7220__auto___40063;
var G__40066 = cljs.core.count(c__7220__auto___40063);
var G__40067 = (0);
seq__40033_40050 = G__40064;
chunk__40034_40051 = G__40065;
count__40035_40052 = G__40066;
i__40036_40053 = G__40067;
continue;
} else {
var vec__40040_40068 = cljs.core.first(seq__40033_40062__$1);
var k_40069 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40040_40068,(0),null);
var v_40070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40040_40068,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_40069,v_40070);

var G__40071 = cljs.core.next(seq__40033_40062__$1);
var G__40072 = null;
var G__40073 = (0);
var G__40074 = (0);
seq__40033_40050 = G__40071;
chunk__40034_40051 = G__40072;
count__40035_40052 = G__40073;
i__40036_40053 = G__40074;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var G__40043_40075 = c2.dom.__GT_dom(el);
var G__40044_40076 = cljs.core.name(k);
var G__40045_40077 = ((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$bottom,null,cljs.core.cst$kw$top,null,cljs.core.cst$kw$width,null,cljs.core.cst$kw$right,null,cljs.core.cst$kw$height,null,cljs.core.cst$kw$left,null], null), null).call(null,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null));
goog.style.setStyle(G__40043_40075,G__40044_40076,G__40045_40077);

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args40078 = [];
var len__7484__auto___40097 = arguments.length;
var i__7485__auto___40098 = (0);
while(true){
if((i__7485__auto___40098 < len__7484__auto___40097)){
args40078.push((arguments[i__7485__auto___40098]));

var G__40099 = (i__7485__auto___40098 + (1));
i__7485__auto___40098 = G__40099;
continue;
} else {
}
break;
}

var G__40080 = args40078.length;
switch (G__40080) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40078.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom(el).attributes;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (attrs){
return (function c2$dom$iter__40081(s__40082){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__40082__$1 = s__40082;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__40082__$1);
if(temp__4657__auto__){
var s__40082__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__40082__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__40082__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__40084 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__40083 = (0);
while(true){
if((i__40083 < size__7188__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__40083);
cljs.core.chunk_append(b__40084,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null));

var G__40101 = (i__40083 + (1));
i__40083 = G__40101;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40084),c2$dom$iter__40081(cljs.core.chunk_rest(s__40082__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40084),null);
}
} else {
var i = cljs.core.first(s__40082__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__40081(cljs.core.rest(s__40082__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__7189__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name(x));
} else {
if(cljs.core.map_QMARK_(x)){
var seq__40087_40102 = cljs.core.seq(x);
var chunk__40088_40103 = null;
var count__40089_40104 = (0);
var i__40090_40105 = (0);
while(true){
if((i__40090_40105 < count__40089_40104)){
var vec__40091_40106 = chunk__40088_40103.cljs$core$IIndexed$_nth$arity$2(null,i__40090_40105);
var k_40107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40091_40106,(0),null);
var v_40108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40091_40106,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_40107,v_40108);

var G__40109 = seq__40087_40102;
var G__40110 = chunk__40088_40103;
var G__40111 = count__40089_40104;
var G__40112 = (i__40090_40105 + (1));
seq__40087_40102 = G__40109;
chunk__40088_40103 = G__40110;
count__40089_40104 = G__40111;
i__40090_40105 = G__40112;
continue;
} else {
var temp__4657__auto___40113 = cljs.core.seq(seq__40087_40102);
if(temp__4657__auto___40113){
var seq__40087_40114__$1 = temp__4657__auto___40113;
if(cljs.core.chunked_seq_QMARK_(seq__40087_40114__$1)){
var c__7220__auto___40115 = cljs.core.chunk_first(seq__40087_40114__$1);
var G__40116 = cljs.core.chunk_rest(seq__40087_40114__$1);
var G__40117 = c__7220__auto___40115;
var G__40118 = cljs.core.count(c__7220__auto___40115);
var G__40119 = (0);
seq__40087_40102 = G__40116;
chunk__40088_40103 = G__40117;
count__40089_40104 = G__40118;
i__40090_40105 = G__40119;
continue;
} else {
var vec__40094_40120 = cljs.core.first(seq__40087_40114__$1);
var k_40121 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40094_40120,(0),null);
var v_40122 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40094_40120,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_40121,v_40122);

var G__40123 = cljs.core.next(seq__40087_40114__$1);
var G__40124 = null;
var G__40125 = (0);
var G__40126 = (0);
seq__40087_40102 = G__40123;
chunk__40088_40103 = G__40124;
count__40089_40104 = G__40125;
i__40090_40105 = G__40126;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom(el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name(k));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$style,k)){
c2.dom.style.cljs$core$IFn$_invoke$arity$2(el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name(k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args40127 = [];
var len__7484__auto___40131 = arguments.length;
var i__7485__auto___40132 = (0);
while(true){
if((i__7485__auto___40132 < len__7484__auto___40131)){
args40127.push((arguments[i__7485__auto___40132]));

var G__40133 = (i__7485__auto___40132 + (1));
i__7485__auto___40132 = G__40133;
continue;
} else {
}
break;
}

var G__40129 = args40127.length;
switch (G__40129) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40127.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__40130 = c2.dom.__GT_dom(el);
return goog.dom.getTextContent(G__40130);
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;

/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args40135 = [];
var len__7484__auto___40139 = arguments.length;
var i__7485__auto___40140 = (0);
while(true){
if((i__7485__auto___40140 < len__7484__auto___40139)){
args40135.push((arguments[i__7485__auto___40140]));

var G__40141 = (i__7485__auto___40140 + (1));
i__7485__auto___40140 = G__40141;
continue;
} else {
}
break;
}

var G__40137 = args40135.length;
switch (G__40137) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40135.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__40138 = c2.dom.__GT_dom(el);
return goog.dom.forms.getValue(G__40138);
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;

/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
var G__40146_40149 = c2.dom.__GT_dom(el);
var G__40147_40150 = cljs.core.name(class$);
var G__40148_40151 = classed_QMARK_;
goog.dom.classes.enable(G__40146_40149,G__40147_40150,G__40148_40151);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6409__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return ((function (or__6409__auto____$1,or__6409__auto__){
return (function (p1__40152_SHARP_){
var G__40153 = ((function (or__6409__auto____$1,or__6409__auto__){
return (function (){
return (p1__40152_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p1__40152_SHARP_.cljs$core$IFn$_invoke$arity$0() : p1__40152_SHARP_.call(null));
});})(or__6409__auto____$1,or__6409__auto__))
;
var G__40154 = (10);
return setTimeout(G__40153,G__40154);
});
;})(or__6409__auto____$1,or__6409__auto__))
}
}
})();
