// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.forms');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.urls');
goog.require('chimera.date');
goog.require('cljs.pprint');
goog.require('clojure.string');
goog.require('hatti.constants');
hatti.ona.forms.currency_regex = /£|$/;
hatti.ona.forms.newline_regex = /[\n\r]/;
hatti.ona.forms.no_answer = "No Answer";
hatti.ona.forms.submission_time_field = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._submission_time,cljs.core.cst$kw$full_DASH_name,hatti.constants._submission_time,cljs.core.cst$kw$label,"Submission Time",cljs.core.cst$kw$type,"dateTime"], null);
hatti.ona.forms.id_field = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"ID",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null);
hatti.ona.forms.submitted_by_field = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._submitted_by,cljs.core.cst$kw$full_DASH_name,hatti.constants._submitted_by,cljs.core.cst$kw$label,"Submitted by",cljs.core.cst$kw$type,"text"], null);
hatti.ona.forms.last_edited = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._last_edited,cljs.core.cst$kw$full_DASH_name,hatti.constants._last_edited,cljs.core.cst$kw$label,"Last Edited",cljs.core.cst$kw$type,"date"], null);
hatti.ona.forms.media_received_field = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._media_all_received,cljs.core.cst$kw$full_DASH_name,hatti.constants._media_all_received,cljs.core.cst$kw$label,"Media attachments received",cljs.core.cst$kw$type,"text"], null);
hatti.ona.forms.review_comment_field = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$id,"_review_comment",cljs.core.cst$kw$name,"Review comment",cljs.core.cst$kw$sortable,true,cljs.core.cst$kw$field,"_review_comment",cljs.core.cst$kw$type,"text"], null);
hatti.ona.forms.review_status_field = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$id,"_review_status",cljs.core.cst$kw$name,"Review status",cljs.core.cst$kw$sortable,true,cljs.core.cst$kw$field,"_review_status",cljs.core.cst$kw$type,"text"], null);
hatti.ona.forms.extra_submission_details = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.ona.forms.last_edited,hatti.ona.forms.submission_time_field,hatti.ona.forms.submitted_by_field,hatti.ona.forms.media_received_field], null);
/**
 * Format multiline answer by introducing html line breaks
 */
hatti.ona.forms.format_multiline_answer = (function hatti$ona$forms$format_multiline_answer(answer){
if(cljs.core.truth_((function (){var and__6397__auto__ = typeof answer === 'string';
if(and__6397__auto__){
return cljs.core.re_find(hatti.ona.forms.newline_regex,answer);
} else {
return and__6397__auto__;
}
})())){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31998_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$p,p1__31998_SHARP_],null));
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(answer,hatti.ona.forms.newline_regex));
} else {
return answer;
}
});
/**
 * Helper function: is the :type of a field among a set of types
 */
hatti.ona.forms.field_type_in_set_QMARK_ = (function hatti$ona$forms$field_type_in_set_QMARK_(types,field){
return cljs.core.contains_QMARK_(types,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(field));
});
/**
 * Helper function: is the :name of a field among a set of names
 */
hatti.ona.forms.field_name_in_set_QMARK_ = (function hatti$ona$forms$field_name_in_set_QMARK_(names,field){
return cljs.core.contains_QMARK_(names,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(field));
});
/**
 * Checks whether a field in a form (ie, a field) is a group field
 */
hatti.ona.forms.group_QMARK_ = (function hatti$ona$forms$group_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["group",null], null), null),field);
});
/**
 * Checks whether a field in a form (ie, a field) is a repeat field
 */
hatti.ona.forms.repeat_QMARK_ = (function hatti$ona$forms$repeat_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["repeat",null], null), null),field);
});
/**
 * Checks whether a field is a numeric field
 */
hatti.ona.forms.numeric_QMARK_ = (function hatti$ona$forms$numeric_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["integer",null,"decimal",null], null), null),field);
});
/**
 * Checks whether a field is a date or a time field
 */
hatti.ona.forms.time_based_QMARK_ = (function hatti$ona$forms$time_based_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, ["today",null,"dateTime",null,"start",null,"time",null,"date",null,"end",null], null), null),field);
});
/**
 * Checks whether a field is a category field (select one or multiple)
 */
hatti.ona.forms.categorical_QMARK_ = (function hatti$ona$forms$categorical_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["select all that apply",null,"select one",null], null), null),field);
});
/**
 * Checks whether a field is a select one field
 */
hatti.ona.forms.select_one_QMARK_ = (function hatti$ona$forms$select_one_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["select one",null], null), null),field);
});
/**
 * Checks whether a field is a select multiple (select all that apply) field
 */
hatti.ona.forms.select_all_QMARK_ = (function hatti$ona$forms$select_all_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["select all that apply",null], null), null),field);
});
/**
 * Checks whether a field is a text / string field.
 */
hatti.ona.forms.text_QMARK_ = (function hatti$ona$forms$text_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["string",null,"text",null], null), null),field);
});
/**
 * Checks whether a field in a form (a field) is a group field
 */
hatti.ona.forms.note_QMARK_ = (function hatti$ona$forms$note_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["note",null], null), null),field);
});
hatti.ona.forms.meta_QMARK_ = (function hatti$ona$forms$meta_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_name_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, ["instanceID",null,"_media_all_received",null,"_duration",null,"meta",null,"__version__",null,"_submitted_by",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, ["subscriberid",null,"phonenumber",null,"instanceID",null,"today",null,"deviceid",null,"_media_all_received",null,"uuid",null,"start",null,"imei",null,"simserial",null,"end",null], null), null),field);
}
});
hatti.ona.forms.geofield_QMARK_ = (function hatti$ona$forms$geofield_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, ["geoshape",null,"geotrace",null,"geopoint",null,"osm",null,"gps",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
var map__32001 = field;
var map__32001__$1 = ((((!((map__32001 == null)))?((((map__32001.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32001.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32001):map__32001);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32001__$1,cljs.core.cst$kw$children);
return cljs.core.some(hatti$ona$forms$geofield_QMARK_,children);
} else {
return null;
}
}
});
hatti.ona.forms.geopoint_QMARK_ = (function hatti$ona$forms$geopoint_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["geopoint",null,"gps",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
var map__32005 = field;
var map__32005__$1 = ((((!((map__32005 == null)))?((((map__32005.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32005.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32005):map__32005);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32005__$1,cljs.core.cst$kw$children);
return cljs.core.some(hatti$ona$forms$geopoint_QMARK_,children);
} else {
return null;
}
}
});
hatti.ona.forms.geoshape_QMARK_ = (function hatti$ona$forms$geoshape_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["geoshape",null], null), null),field);
});
hatti.ona.forms.geotrace_QMARK_ = (function hatti$ona$forms$geotrace_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["geotrace",null], null), null),field);
});
hatti.ona.forms.image_QMARK_ = (function hatti$ona$forms$image_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["image",null,"photo",null], null), null),field);
});
hatti.ona.forms.audio_QMARK_ = (function hatti$ona$forms$audio_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["audio",null], null), null),field);
});
hatti.ona.forms.video_QMARK_ = (function hatti$ona$forms$video_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["video",null], null), null),field);
});
hatti.ona.forms.osm_QMARK_ = (function hatti$ona$forms$osm_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["osm",null], null), null),field);
});
/**
 * Checks whether a field is a calculate field
 */
hatti.ona.forms.calculate_QMARK_ = (function hatti$ona$forms$calculate_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["calculate",null], null), null),field);
});
/**
 * Returns false for fields such as note, group, etc. which don't have data
 */
hatti.ona.forms.has_data_QMARK_ = (function hatti$ona$forms$has_data_QMARK_(field){
return cljs.core.not((function (){var or__6409__auto__ = hatti.ona.forms.note_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.group_QMARK_(field);
}
})());
});
/**
 * Get the icon relevant to the given field (depending on its type).
 */
hatti.ona.forms.get_icon = (function hatti$ona$forms$get_icon(field){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))?"fa fa-font":(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))?"fa fa-clock-o":(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))?"fa fa-bar-chart":(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_(field))?"fa fa-bar-chart":(cljs.core.truth_(hatti.ona.forms.categorical_QMARK_(field))?"fa fa-bar-chart fa-flip-h-rotate-90":""
)))))], null)], null);
});
/**
 * Assign class according to field type category, e.g. integer & decimals are
 * both in the numeric category
 */
hatti.ona.forms.get_column_class = (function hatti$ona$forms$get_column_class(field){
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(field,cljs.core.cst$kw$full_DASH_name),"_media_all_received")){
return "column-string media-attachment";
} else {
return "column-string";
}
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return "column-numeric";
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return "column-datetime";
} else {
if(cljs.core.truth_(hatti.ona.forms.categorical_QMARK_(field))){
return "column-categorical";
} else {
if(cljs.core.truth_(hatti.ona.forms.geofield_QMARK_(field))){
return "column-geofield";
} else {
if(cljs.core.truth_(hatti.ona.forms.image_QMARK_(field))){
return "column-image";
} else {
if(cljs.core.truth_(hatti.ona.forms.audio_QMARK_(field))){
return "column-audio";
} else {
if(cljs.core.truth_(hatti.ona.forms.video_QMARK_(field))){
return "column-video";
} else {
if(cljs.core.truth_(hatti.ona.forms.meta_QMARK_(field))){
return "column-metadata";
} else {
return "";

}
}
}
}
}
}
}
}
}
});
/**
 * Gets the label object out of a map with key :label (eg. a field).
 * If multiple languages, and none specified, picks out alphabetically first.
 */
hatti.ona.forms.get_label = (function hatti$ona$forms$get_label(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32017 = arguments.length;
var i__7485__auto___32018 = (0);
while(true){
if((i__7485__auto___32018 < len__7484__auto___32017)){
args__7491__auto__.push((arguments[i__7485__auto___32018]));

var G__32019 = (i__7485__auto___32018 + (1));
i__7485__auto___32018 = G__32019;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic = (function (p__32009,p__32010){
var map__32011 = p__32009;
var map__32011__$1 = ((((!((map__32011 == null)))?((((map__32011.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32011.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32011):map__32011);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32011__$1,cljs.core.cst$kw$label);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32011__$1,cljs.core.cst$kw$name);
var vec__32012 = p__32010;
var language = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32012,(0),null);
if(!(cljs.core.map_QMARK_(label))){
var or__6409__auto__ = label;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return name;
}
} else {
if(cljs.core.contains_QMARK_(cljs.core.set(cljs.core.keys(label)),language)){
return (label.cljs$core$IFn$_invoke$arity$1 ? label.cljs$core$IFn$_invoke$arity$1(language) : label.call(null,language));
} else {
var G__32016 = cljs.core.first(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.keys(label)));
return (label.cljs$core$IFn$_invoke$arity$1 ? label.cljs$core$IFn$_invoke$arity$1(G__32016) : label.call(null,G__32016));
}
}
});

hatti.ona.forms.get_label.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.get_label.cljs$lang$applyTo = (function (seq32007){
var G__32008 = cljs.core.first(seq32007);
var seq32007__$1 = cljs.core.next(seq32007);
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(G__32008,seq32007__$1);
});

/**
 * Checks if the appearance-value has the search expression
 */
hatti.ona.forms.uses_search_expression_QMARK_ = (function hatti$ona$forms$uses_search_expression_QMARK_(appearance_value){
var and__6397__auto__ = typeof appearance_value === 'string';
if(and__6397__auto__){
return cljs.core.re_matches(/^search\(.*\)$/,appearance_value);
} else {
return and__6397__auto__;
}
});
/**
 * Displays tip question and tooltip msg for failed media files uploads
 */
hatti.ona.forms.media_files_upload_error_component = (function hatti$ona$forms$media_files_upload_error_component(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32025 = arguments.length;
var i__7485__auto___32026 = (0);
while(true){
if((i__7485__auto___32026 < len__7484__auto___32025)){
args__7491__auto__.push((arguments[i__7485__auto___32026]));

var G__32027 = (i__7485__auto___32026 + (1));
i__7485__auto___32026 = G__32027;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.media_files_upload_error_component.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.media_files_upload_error_component.cljs$core$IFn$_invoke$arity$variadic = (function (answer,p__32022){
var map__32023 = p__32022;
var map__32023__$1 = ((((!((map__32023 == null)))?((((map__32023.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32023.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32023):map__32023);
var help_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32023__$1,cljs.core.cst$kw$help_DASH_url);
var error_message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32023__$1,cljs.core.cst$kw$error_DASH_message);
var record_modal_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32023__$1,cljs.core.cst$kw$record_DASH_modal_QMARK_);
if(cljs.core.truth_(record_modal_QMARK_)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$image_DASH_name,answer,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$tooltip,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,help_url,cljs.core.cst$kw$target,"_blank"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,error_message], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_question,"?"], null)], null)], null);
} else {
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("<span class='image-name'> %s </span>\n          <a class='tooltip' href=%s target='_blank'>\n          <span class='tip-info'>%s</span>\n          <span class='tip-question'>?</span></a>",cljs.core.array_seq([answer,help_url,error_message], 0));
}
});

hatti.ona.forms.media_files_upload_error_component.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.media_files_upload_error_component.cljs$lang$applyTo = (function (seq32020){
var G__32021 = cljs.core.first(seq32020);
var seq32020__$1 = cljs.core.next(seq32020);
return hatti.ona.forms.media_files_upload_error_component.cljs$core$IFn$_invoke$arity$variadic(G__32021,seq32020__$1);
});

/**
 * Returns an infor icon with a tooltip message
 */
hatti.ona.forms.infor_icon_component = (function hatti$ona$forms$infor_icon_component(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32033 = arguments.length;
var i__7485__auto___32034 = (0);
while(true){
if((i__7485__auto___32034 < len__7484__auto___32033)){
args__7491__auto__.push((arguments[i__7485__auto___32034]));

var G__32035 = (i__7485__auto___32034 + (1));
i__7485__auto___32034 = G__32035;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.infor_icon_component.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.infor_icon_component.cljs$core$IFn$_invoke$arity$variadic = (function (answer,p__32030){
var map__32031 = p__32030;
var map__32031__$1 = ((((!((map__32031 == null)))?((((map__32031.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32031.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32031):map__32031);
var media_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32031__$1,cljs.core.cst$kw$media_DASH_count);
var total_media = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32031__$1,cljs.core.cst$kw$total_DASH_media);
var help_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32031__$1,cljs.core.cst$kw$help_DASH_url);
return [cljs.core.str("<span>"),cljs.core.str(answer),cljs.core.str("<a class=\"tooltip top-right\" href="),cljs.core.str(help_url),cljs.core.str(" target=\"_blank\">\n       <span class=\"media-status tip-info\">\n       <p><b>Total media files expected</b><span> : </span><span>"),cljs.core.str(total_media),cljs.core.str("</span></p>\n       <p><b>Total media files received</b><span> : </span><span>"),cljs.core.str(media_count),cljs.core.str("</span></p></span><i class='fa fa-info-circle'></i></a></span>")].join('');
});

hatti.ona.forms.infor_icon_component.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.infor_icon_component.cljs$lang$applyTo = (function (seq32028){
var G__32029 = cljs.core.first(seq32028);
var seq32028__$1 = cljs.core.next(seq32028);
return hatti.ona.forms.infor_icon_component.cljs$core$IFn$_invoke$arity$variadic(G__32029,seq32028__$1);
});

/**
 * String representation for a particular field datapoint (answer).
 * re-formatting depends on field type, eg. name->label substitution.
 * Optional: compact? should be true if a short string needs to be returned.
 */
hatti.ona.forms.format_answer = (function hatti$ona$forms$format_answer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32053 = arguments.length;
var i__7485__auto___32054 = (0);
while(true){
if((i__7485__auto___32054 < len__7484__auto___32053)){
args__7491__auto__.push((arguments[i__7485__auto___32054]));

var G__32055 = (i__7485__auto___32054 + (1));
i__7485__auto___32054 = G__32055;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic = (function (field,answer,p__32043){
var map__32044 = p__32043;
var map__32044__$1 = ((((!((map__32044 == null)))?((((map__32044.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32044.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32044):map__32044);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32044__$1,cljs.core.cst$kw$language);
var compact_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32044__$1,cljs.core.cst$kw$compact_QMARK_);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32044__$1,cljs.core.cst$kw$label);
var field_key = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32044__$1,cljs.core.cst$kw$field_DASH_key,cljs.core.cst$kw$name);
var media = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32044__$1,cljs.core.cst$kw$media);
var record_modal_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32044__$1,cljs.core.cst$kw$record_DASH_modal_QMARK_,false);
var media_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32044__$1,cljs.core.cst$kw$media_DASH_count);
var total_media = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32044__$1,cljs.core.cst$kw$total_DASH_media);
if(clojure.string.blank_QMARK_(answer)){
return hatti.ona.forms.no_answer;
} else {
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_(field))){
var option = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__32044,map__32044__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p1__32036_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(answer,(field_key.cljs$core$IFn$_invoke$arity$1 ? field_key.cljs$core$IFn$_invoke$arity$1(p1__32036_SHARP_) : field_key.call(null,p1__32036_SHARP_)));
});})(map__32044,map__32044__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(field)));
var formatted = hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(option,cljs.core.array_seq([language], 0));
var or__6409__auto__ = formatted;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return answer;
}
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
var names = cljs.core.set(clojure.string.split.cljs$core$IFn$_invoke$arity$2(answer,/ /));
var appearance_value = cljs.core.cst$kw$appearance.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$control.cljs$core$IFn$_invoke$arity$1(field));
var multiple_select_values = (cljs.core.truth_(hatti.ona.forms.uses_search_expression_QMARK_(appearance_value))?cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (names,appearance_value,map__32044,map__32044__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p1__32037_SHARP_){
return cljs.core.identity(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,p1__32037_SHARP_], null));
});})(names,appearance_value,map__32044,map__32044__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,names):cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (names,appearance_value,map__32044,map__32044__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p1__32038_SHARP_){
return cljs.core.contains_QMARK_(names,(field_key.cljs$core$IFn$_invoke$arity$1 ? field_key.cljs$core$IFn$_invoke$arity$1(p1__32038_SHARP_) : field_key.call(null,p1__32038_SHARP_)));
});})(names,appearance_value,map__32044,map__32044__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(field)));
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (names,appearance_value,multiple_select_values,map__32044,map__32044__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p1__32039_SHARP_){
return [cljs.core.str("\u2611 "),cljs.core.str(hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(p1__32039_SHARP_,cljs.core.array_seq([language], 0))),cljs.core.str(" ")].join('');
});})(names,appearance_value,multiple_select_values,map__32044,map__32044__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,multiple_select_values));
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return chimera.date.format_date(answer);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.image_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = hatti.ona.forms.audio_QMARK_(field);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return hatti.ona.forms.video_QMARK_(field);
}
}
})())){
var image = cljs.core.cst$kw$download_url.cljs$core$IFn$_invoke$arity$1(answer);
var thumb = (function (){var or__6409__auto__ = cljs.core.cst$kw$small_download_url.cljs$core$IFn$_invoke$arity$1(answer);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return image;
}
})();
var fname = chimera.urls.last_url_param(cljs.core.cst$kw$filename.cljs$core$IFn$_invoke$arity$1(answer));
if((typeof answer === 'string') && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(answer,"null")) && ((thumb == null))){
return hatti.ona.forms.media_files_upload_error_component.cljs$core$IFn$_invoke$arity$variadic(answer,cljs.core.array_seq([cljs.core.cst$kw$help_DASH_url,hatti.constants.help_base_url(hatti.constants.failed_media_upload_help_url),cljs.core.cst$kw$error_DASH_message,hatti.constants.failed_media_upload_error_message,cljs.core.cst$kw$record_DASH_modal_QMARK_,record_modal_QMARK_], 0));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(answer,"null")){
return answer;
} else {
if(cljs.core.truth_(compact_QMARK_)){
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("<a href='%s' target='_blank'>\n                                      <i class='fa fa-external-link'></i>\n                                      %s </a>",cljs.core.array_seq([image,fname], 0));
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,image,cljs.core.cst$kw$target,"_blank"], null),(cljs.core.truth_(hatti.ona.forms.image_QMARK_(field))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,"80px",cljs.core.cst$kw$src,thumb], null)], null):new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_file_DASH_video_DASH_o], null)," ",fname], null))], null);

}
}
}
} else {
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(field))){
var kw__GT_name = cljs.core.name;
var map__32046 = answer;
var map__32046__$1 = ((((!((map__32046 == null)))?((((map__32046.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32046.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32046):map__32046);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32046__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32046__$1,cljs.core.cst$kw$type);
var osm_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32046__$1,cljs.core.cst$kw$osm_DASH_id);
var type_cap = (cljs.core.truth_(type)?clojure.string.capitalize(type):null);
var title = [cljs.core.str("OSM "),cljs.core.str(type_cap),cljs.core.str(": "),cljs.core.str(name),cljs.core.str(" ("),cljs.core.str(osm_id),cljs.core.str(")")].join('');
if(cljs.core.truth_(compact_QMARK_)){
return title;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$osm_DASH_data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(2)], null),title], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (kw__GT_name,map__32046,map__32046__$1,name,type,osm_id,type_cap,title,map__32044,map__32044__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p__32048){
var vec__32049 = p__32048;
var tk = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32049,(0),null);
var tv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32049,(1),null);
if(clojure.string.blank_QMARK_(tv)){
return null;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$question,(kw__GT_name.cljs$core$IFn$_invoke$arity$1 ? kw__GT_name.cljs$core$IFn$_invoke$arity$1(tk) : kw__GT_name.call(null,tk))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$answer,tv], null)], null);
}
});})(kw__GT_name,map__32046,map__32046__$1,name,type,osm_id,type_cap,title,map__32044,map__32044__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(answer))], null)], null);
}
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
if(cljs.core.empty_QMARK_(answer)){
return hatti.ona.forms.no_answer;
} else {
return [cljs.core.str("Repeated data with "),cljs.core.str(cljs.core.count(answer)),cljs.core.str(" answers.")].join('');
}
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
var temp__4655__auto__ = (function (){var G__32052 = label;
if((G__32052 == null)){
return null;
} else {
return cljs.core.re_find(hatti.ona.forms.currency_regex,G__32052);
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var currency = temp__4655__auto__;
return [cljs.core.str(currency),cljs.core.str(cljs.pprint.cl_format.cljs$core$IFn$_invoke$arity$variadic(null,"~:d",cljs.core.array_seq([answer], 0)))].join('');
} else {
return answer;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2([cljs.core.str(answer)].join(''),"false")){
return hatti.ona.forms.infor_icon_component.cljs$core$IFn$_invoke$arity$variadic(answer,cljs.core.array_seq([cljs.core.cst$kw$media_DASH_count,media_count,cljs.core.cst$kw$total_DASH_media,total_media,cljs.core.cst$kw$help_DASH_url,hatti.constants.help_base_url(hatti.constants.failed_media_upload_help_url)], 0));
} else {
return hatti.ona.forms.format_multiline_answer(answer);
}
}

}
}
}
}
}
}
}
});

hatti.ona.forms.format_answer.cljs$lang$maxFixedArity = (2);

hatti.ona.forms.format_answer.cljs$lang$applyTo = (function (seq32040){
var G__32041 = cljs.core.first(seq32040);
var seq32040__$1 = cljs.core.next(seq32040);
var G__32042 = cljs.core.first(seq32040__$1);
var seq32040__$2 = cljs.core.next(seq32040__$1);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(G__32041,G__32042,seq32040__$2);
});

/**
 * Try and produce a label for meta field if non-existent.
 */
hatti.ona.forms.relabel_meta_field = (function hatti$ona$forms$relabel_meta_field(p__32056){
var map__32062 = p__32056;
var map__32062__$1 = ((((!((map__32062 == null)))?((((map__32062.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32062.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32062):map__32062);
var field = map__32062__$1;
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32062__$1,cljs.core.cst$kw$label);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32062__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32062__$1,cljs.core.cst$kw$type);
var label__$1 = (cljs.core.truth_(type)?(function (){var G__32064 = type;
switch (G__32064) {
case "start":
return "Start time";

break;
case "end":
return "End time";

break;
case "today":
return "Day of survey";

break;
case "deviceid":
return "Device ID (IMEI)";

break;
case "imei":
return "IMEI";

break;
case "subscriberid":
return "IMSI";

break;
case "simserial":
return "SIM serial number";

break;
case "uuid":
return "UUID";

break;
case "instanceID":
return "Instance ID";

break;
case "phonenumber":
return "Phone number";

break;
case "_media_all_received":
return "Media attachments received";

break;
default:
return name;

}
})():(function (){var G__32065 = name;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$_submission_time,G__32065)){
return "Submission time";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$_submitted_by,G__32065)){
return "Submitted by";
} else {
return "";

}
}
})());
var G__32066 = field;
if(cljs.core.not(label__$1)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__32066,cljs.core.cst$kw$label,label__$1);
} else {
return G__32066;
}
});
hatti.ona.forms.name_label_map = (function hatti$ona$forms$name_label_map(p__32069,prefix,acc,flatten_repeats_QMARK_){
var map__32076 = p__32069;
var map__32076__$1 = ((((!((map__32076 == null)))?((((map__32076.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32076.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32076):map__32076);
var child = map__32076__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32076__$1,cljs.core.cst$kw$children);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32076__$1,cljs.core.cst$kw$name);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32076__$1,cljs.core.cst$kw$label);
var full_name = (cljs.core.truth_(prefix)?[cljs.core.str(prefix),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
var langs = ((cljs.core.map_QMARK_(label))?cljs.core.keys(label):null);
var updated_child = cljs.core.with_meta(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(child,cljs.core.cst$kw$full_DASH_name,full_name),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$langs,langs], null));
var childless_child = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated_child,cljs.core.cst$kw$children);
var make_new_children = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (full_name,langs,updated_child,childless_child,map__32076,map__32076__$1,child,children,name,label){
return (function (p1__32068_SHARP_){
return hatti$ona$forms$name_label_map(p1__32068_SHARP_,full_name,cljs.core.PersistentVector.EMPTY,flatten_repeats_QMARK_);
});})(full_name,langs,updated_child,childless_child,map__32076,map__32076__$1,child,children,name,label))
,children);
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.group_QMARK_(updated_child);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var and__6397__auto__ = flatten_repeats_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.ona.forms.repeat_QMARK_(updated_child);
} else {
return and__6397__auto__;
}
}
})())){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,childless_child),make_new_children);
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(updated_child))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(updated_child,cljs.core.cst$kw$children,cljs.core.flatten(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,make_new_children))));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,updated_child);

}
}
});
/**
 * Input: map derived from form.json. Output: a flattened vector;
 * each element is a field; a field is a {:name .. :label .. :type ..} map.
 * By default, REPEAT BLOCKS ARE NOT FLATTENED, repeat blocks represent
 * subforms, which need special handling in most cases.
 * :flatten-repeats? overrides default behavior, also flattens repeats.
 */
hatti.ona.forms.flatten_form = (function hatti$ona$forms$flatten_form(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32088 = arguments.length;
var i__7485__auto___32089 = (0);
while(true){
if((i__7485__auto___32089 < len__7484__auto___32088)){
args__7491__auto__.push((arguments[i__7485__auto___32089]));

var G__32090 = (i__7485__auto___32089 + (1));
i__7485__auto___32089 = G__32090;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic = (function (p__32082,p__32083){
var map__32084 = p__32082;
var map__32084__$1 = ((((!((map__32084 == null)))?((((map__32084.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32084.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32084):map__32084);
var form = map__32084__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32084__$1,cljs.core.cst$kw$children);
var map__32085 = p__32083;
var map__32085__$1 = ((((!((map__32085 == null)))?((((map__32085.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32085.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32085):map__32085);
var flatten_repeats_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32085__$1,cljs.core.cst$kw$flatten_DASH_repeats_QMARK_);
var nodes = cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__32084,map__32084__$1,form,children,map__32085,map__32085__$1,flatten_repeats_QMARK_){
return (function (p1__32078_SHARP_){
return hatti.ona.forms.name_label_map(p1__32078_SHARP_,null,cljs.core.PersistentVector.EMPTY,flatten_repeats_QMARK_);
});})(map__32084,map__32084__$1,form,children,map__32085,map__32085__$1,flatten_repeats_QMARK_))
,children));
var langs = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (nodes,map__32084,map__32084__$1,form,children,map__32085,map__32085__$1,flatten_repeats_QMARK_){
return (function (p1__32079_SHARP_){
return cljs.core.cst$kw$langs.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__32079_SHARP_));
});})(nodes,map__32084,map__32084__$1,form,children,map__32085,map__32085__$1,flatten_repeats_QMARK_))
,nodes)));
return cljs.core.with_meta(nodes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$languages,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,langs)], null));
});

hatti.ona.forms.flatten_form.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.flatten_form.cljs$lang$applyTo = (function (seq32080){
var G__32081 = cljs.core.first(seq32080);
var seq32080__$1 = cljs.core.next(seq32080);
return hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic(G__32081,seq32080__$1);
});

/**
 * Get just the meta fields out of the form.
 * Options to re-label meta fields, or include submission time in meta list.
 */
hatti.ona.forms.meta_fields = (function hatti$ona$forms$meta_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32098 = arguments.length;
var i__7485__auto___32099 = (0);
while(true){
if((i__7485__auto___32099 < len__7484__auto___32098)){
args__7491__auto__.push((arguments[i__7485__auto___32099]));

var G__32100 = (i__7485__auto___32099 + (1));
i__7485__auto___32099 = G__32100;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,p__32094){
var map__32095 = p__32094;
var map__32095__$1 = ((((!((map__32095 == null)))?((((map__32095.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32095.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32095):map__32095);
var relabel_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32095__$1,cljs.core.cst$kw$relabel_QMARK_,true);
var with_submission_details_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32095__$1,cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_);
var meta_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.meta_QMARK_,flat_form);
var include_extra_sub_details = (cljs.core.truth_(with_submission_details_QMARK_)?((function (meta_fields,map__32095,map__32095__$1,relabel_QMARK_,with_submission_details_QMARK_){
return (function (p1__32091_SHARP_){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__32091_SHARP_),hatti.ona.forms.extra_submission_details);
});})(meta_fields,map__32095,map__32095__$1,relabel_QMARK_,with_submission_details_QMARK_))
:cljs.core.identity);
var relabel = (cljs.core.truth_(relabel_QMARK_)?hatti.ona.forms.relabel_meta_field:cljs.core.identity);
var G__32097 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(relabel,meta_fields);
return (include_extra_sub_details.cljs$core$IFn$_invoke$arity$1 ? include_extra_sub_details.cljs$core$IFn$_invoke$arity$1(G__32097) : include_extra_sub_details.call(null,G__32097));
});

hatti.ona.forms.meta_fields.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.meta_fields.cljs$lang$applyTo = (function (seq32092){
var G__32093 = cljs.core.first(seq32092);
var seq32092__$1 = cljs.core.next(seq32092);
return hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(G__32093,seq32092__$1);
});

/**
 * Get just the fields in this form that are not meta fields.
 */
hatti.ona.forms.non_meta_fields = (function hatti$ona$forms$non_meta_fields(flat_form){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.meta_QMARK_,flat_form);
});
/**
 * Get just the geofields from the form.
 */
hatti.ona.forms.geofields = (function hatti$ona$forms$geofields(flat_form){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,flat_form);
});
/**
 * From a list of geofields, get the default one to map.
 * Implementation: pick first geoshape if any, else pick first geofield.
 */
hatti.ona.forms.default_geofield = (function hatti$ona$forms$default_geofield(flat_form){
var repeats = cljs.core.flatten(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form));
var geofields = hatti.ona.forms.geofields(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(flat_form,repeats));
var geoshapes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geoshape_QMARK_,geofields);
var geopoints = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geopoint_QMARK_,geofields);
if(cljs.core.seq(geoshapes)){
return cljs.core.first(geoshapes);
} else {
if(cljs.core.seq(geopoints)){
return cljs.core.first(geopoints);
} else {
return cljs.core.first(geofields);

}
}
});
hatti.ona.forms.english_QMARK_ = (function hatti$ona$forms$english_QMARK_(language){
return cljs.core.re_find(/english/i,[cljs.core.str(language)].join(''));
});
/**
 * Get the languages for a given form.
 */
hatti.ona.forms.get_languages = (function hatti$ona$forms$get_languages(form){
return cljs.core.cst$kw$languages.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(form));
});
/**
 * Does this form contain labels in multiple languages?
 */
hatti.ona.forms.multilingual_QMARK_ = (function hatti$ona$forms$multilingual_QMARK_(form){
return cljs.core.seq(hatti.ona.forms.get_languages(form));
});
/**
 * Get default language (English or alphabetical first) from within a list.
 */
hatti.ona.forms.default_lang = (function hatti$ona$forms$default_lang(languages){
var temp__4655__auto__ = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.english_QMARK_,languages));
if(cljs.core.truth_(temp__4655__auto__)){
var eng = temp__4655__auto__;
return eng;
} else {
return cljs.core.first(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(languages));
}
});
