// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('chimera.seq');
goog.require('hatti.constants');
goog.require('chimera.urls');
goog.require('clojure.string');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__7189__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__35558(s__35559){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__35559__$1 = s__35559;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35559__$1);
if(temp__4657__auto__){
var s__35559__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35559__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35559__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35561 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35560 = (0);
while(true){
if((i__35560 < size__7188__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35560);
cljs.core.chunk_append(b__35561,(function (){var iter__7189__auto__ = ((function (i__35560,datum,c__7187__auto__,size__7188__auto__,b__35561,s__35559__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__35558_$_iter__35576(s__35577){
return (new cljs.core.LazySeq(null,((function (i__35560,datum,c__7187__auto__,size__7188__auto__,b__35561,s__35559__$2,temp__4657__auto__,osmfields){
return (function (){
var s__35577__$1 = s__35577;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__35577__$1);
if(temp__4657__auto____$1){
var s__35577__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__35577__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first(s__35577__$2);
var size__7188__auto____$1 = cljs.core.count(c__7187__auto____$1);
var b__35579 = cljs.core.chunk_buffer(size__7188__auto____$1);
if((function (){var i__35578 = (0);
while(true){
if((i__35578 < size__7188__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto____$1,i__35578);
cljs.core.chunk_append(b__35579,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__35588 = (i__35578 + (1));
i__35578 = G__35588;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35579),hatti$ona$post_process$ona_osm_link_$_iter__35558_$_iter__35576(cljs.core.chunk_rest(s__35577__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35579),null);
}
} else {
var field = cljs.core.first(s__35577__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__35558_$_iter__35576(cljs.core.rest(s__35577__$2)));
}
} else {
return null;
}
break;
}
});})(i__35560,datum,c__7187__auto__,size__7188__auto__,b__35561,s__35559__$2,temp__4657__auto__,osmfields))
,null,null));
});})(i__35560,datum,c__7187__auto__,size__7188__auto__,b__35561,s__35559__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__(osmfields);
})());

var G__35589 = (i__35560 + (1));
i__35560 = G__35589;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35561),hatti$ona$post_process$ona_osm_link_$_iter__35558(cljs.core.chunk_rest(s__35559__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35561),null);
}
} else {
var datum = cljs.core.first(s__35559__$2);
return cljs.core.cons((function (){var iter__7189__auto__ = ((function (datum,s__35559__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__35558_$_iter__35582(s__35583){
return (new cljs.core.LazySeq(null,((function (datum,s__35559__$2,temp__4657__auto__,osmfields){
return (function (){
var s__35583__$1 = s__35583;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__35583__$1);
if(temp__4657__auto____$1){
var s__35583__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__35583__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35583__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35585 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35584 = (0);
while(true){
if((i__35584 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35584);
cljs.core.chunk_append(b__35585,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__35590 = (i__35584 + (1));
i__35584 = G__35590;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35585),hatti$ona$post_process$ona_osm_link_$_iter__35558_$_iter__35582(cljs.core.chunk_rest(s__35583__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35585),null);
}
} else {
var field = cljs.core.first(s__35583__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__35558_$_iter__35582(cljs.core.rest(s__35583__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__35559__$2,temp__4657__auto__,osmfields))
,null,null));
});})(datum,s__35559__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__35558(cljs.core.rest(s__35559__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__7189__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__35592 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__35592);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (function (){var G__35616 = cljs.core.cst$kw$features;
return (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(G__35616) : osmgeo.call(null,G__35616));
})();
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__35617(s__35618){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__35618__$1 = s__35618;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35618__$1);
if(temp__4657__auto__){
var s__35618__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35618__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35618__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35620 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35619 = (0);
while(true){
if((i__35619 < size__7188__auto__)){
var map__35631 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35619);
var map__35631__$1 = ((((!((map__35631 == null)))?((((map__35631.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35631.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35631):map__35631);
var feature = map__35631__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35631__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35631__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35631__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__35620,(function (){var map__35633 = properties;
var map__35633__$1 = ((((!((map__35633 == null)))?((((map__35633.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35633.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35633):map__35633);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35633__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35633__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35633__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__35639 = (i__35619 + (1));
i__35619 = G__35639;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35620),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__35617(cljs.core.chunk_rest(s__35618__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35620),null);
}
} else {
var map__35635 = cljs.core.first(s__35618__$2);
var map__35635__$1 = ((((!((map__35635 == null)))?((((map__35635.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35635.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35635):map__35635);
var feature = map__35635__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35635__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35635__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35635__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__35637 = properties;
var map__35637__$1 = ((((!((map__35637 == null)))?((((map__35637.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35637.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35637):map__35637);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35637__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35637__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35637__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__35617(cljs.core.rest(s__35618__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__7189__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__35640_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__35640_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val,osm_id){
if(typeof osm_val === 'string'){
var temp__4655__auto__ = (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(osm_id) : osm_data.call(null,osm_id));
if(cljs.core.truth_(temp__4655__auto__)){
var osm_submission_data = temp__4655__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__7189__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__35652(s__35653){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__35653__$1 = s__35653;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35653__$1);
if(temp__4657__auto__){
var s__35653__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35653__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35653__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35655 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35654 = (0);
while(true){
if((i__35654 < size__7188__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35654);
cljs.core.chunk_append(b__35655,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (i__35654,osm_id,datum,c__7187__auto__,size__7188__auto__,b__35655,s__35653__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__35641_SHARP_){
return osm_val__GT_osm_data(p1__35641_SHARP_,osm_id);
});})(i__35654,osm_id,datum,c__7187__auto__,size__7188__auto__,b__35655,s__35653__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})());

var G__35662 = (i__35654 + (1));
i__35654 = G__35662;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35655),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__35652(cljs.core.chunk_rest(s__35653__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35655),null);
}
} else {
var datum = cljs.core.first(s__35653__$2);
return cljs.core.cons((function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (osm_id,datum,s__35653__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__35641_SHARP_){
return osm_val__GT_osm_data(p1__35641_SHARP_,osm_id);
});})(osm_id,datum,s__35653__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})(),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__35652(cljs.core.rest(s__35653__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__7189__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__35658 = cljs.core.seq(osm_fields);
var chunk__35659 = null;
var count__35660 = (0);
var i__35661 = (0);
while(true){
if((i__35661 < count__35660)){
var osm_field = chunk__35659.cljs$core$IIndexed$_nth$arity$2(null,i__35661);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__35663 = seq__35658;
var G__35664 = chunk__35659;
var G__35665 = count__35660;
var G__35666 = (i__35661 + (1));
seq__35658 = G__35663;
chunk__35659 = G__35664;
count__35660 = G__35665;
i__35661 = G__35666;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__35658);
if(temp__4657__auto__){
var seq__35658__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35658__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__35658__$1);
var G__35667 = cljs.core.chunk_rest(seq__35658__$1);
var G__35668 = c__7220__auto__;
var G__35669 = cljs.core.count(c__7220__auto__);
var G__35670 = (0);
seq__35658 = G__35667;
chunk__35659 = G__35668;
count__35660 = G__35669;
i__35661 = G__35670;
continue;
} else {
var osm_field = cljs.core.first(seq__35658__$1);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__35671 = cljs.core.next(seq__35658__$1);
var G__35672 = null;
var G__35673 = (0);
var G__35674 = (0);
seq__35658 = G__35671;
chunk__35659 = G__35672;
count__35660 = G__35673;
i__35661 = G__35674;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Gets and returns matching name for an attachment that was renamed by
 *   appending a hash on the S3 server to avoid duplicating names.
 *   e.g. if 1478203839187.jpg was renamed to 1478203839187_wijUzUf.jpg,
 *   it returns 1478203839187_wijUzUf.jpg.
 */
hatti.ona.post_process.get_matching_name = (function hatti$ona$post_process$get_matching_name(fname,fnames){
if(typeof fname === 'string'){
try{var or__6409__auto__ = (function (){var G__35684 = (function (p1__35675_SHARP_){
return cljs.core.re_find(cljs.core.re_pattern(cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(fname,cljs.core.re_pattern("\\.")))),p1__35675_SHARP_);
});
var G__35685 = fnames;
return (chimera.seq.filter_first.cljs$core$IFn$_invoke$arity$2 ? chimera.seq.filter_first.cljs$core$IFn$_invoke$arity$2(G__35684,G__35685) : chimera.seq.filter_first.call(null,G__35684,G__35685));
})();
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return fname;
}
}catch (e35681){if((e35681 instanceof SyntaxError)){
var e = e35681;
return fname;
} else {
throw e35681;

}
}} else {
return fname;
}
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__6409__auto__ = attachments;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,hatti.constants._attachments);
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__35686_SHARP_){
return chimera.urls.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__35686_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,hatti.ona.post_process.get_matching_name(fname,fnames),fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Coll -> Coll
 */
hatti.ona.post_process.filter_media = (function hatti$ona$post_process$filter_media(flat_form){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__35687_SHARP_){
var or__6409__auto__ = hatti.ona.forms.video_QMARK_(p1__35687_SHARP_);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = hatti.ona.forms.audio_QMARK_(p1__35687_SHARP_);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return hatti.ona.forms.image_QMARK_(p1__35687_SHARP_);
}
}
}),flat_form);
});
/**
 * Inlines media data from within _attachments into each record.
 * Coll Coll -> Coll
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__7491__auto__ = [];
var len__7484__auto___35700 = arguments.length;
var i__7485__auto___35701 = (0);
while(true){
if((i__7485__auto___35701 < len__7484__auto___35700)){
args__7491__auto__.push((arguments[i__7485__auto___35701]));

var G__35702 = (i__7485__auto___35701 + (1));
i__7485__auto___35701 = G__35702;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__35691){
var map__35692 = p__35691;
var map__35692__$1 = ((((!((map__35692 == null)))?((((map__35692.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35692.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35692):map__35692);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35692__$1,cljs.core.cst$kw$attachments);
var image_fields = hatti.ona.post_process.filter_media(flat_form);
var iter__7189__auto__ = ((function (image_fields,map__35692,map__35692__$1,attachments){
return (function hatti$ona$post_process$iter__35694(s__35695){
return (new cljs.core.LazySeq(null,((function (image_fields,map__35692,map__35692__$1,attachments){
return (function (){
var s__35695__$1 = s__35695;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35695__$1);
if(temp__4657__auto__){
var s__35695__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35695__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35695__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35697 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35696 = (0);
while(true){
if((i__35696 < size__7188__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35696);
cljs.core.chunk_append(b__35697,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__35696,attach_map,record,c__7187__auto__,size__7188__auto__,b__35697,s__35695__$2,temp__4657__auto__,image_fields,map__35692,map__35692__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__35696,attach_map,record,c__7187__auto__,size__7188__auto__,b__35697,s__35695__$2,temp__4657__auto__,image_fields,map__35692,map__35692__$1,attachments))
,record,image_fields);
})());

var G__35703 = (i__35696 + (1));
i__35696 = G__35703;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35697),hatti$ona$post_process$iter__35694(cljs.core.chunk_rest(s__35695__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35697),null);
}
} else {
var record = cljs.core.first(s__35695__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__35695__$2,temp__4657__auto__,image_fields,map__35692,map__35692__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__35695__$2,temp__4657__auto__,image_fields,map__35692,map__35692__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__35694(cljs.core.rest(s__35695__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__35692,map__35692__$1,attachments))
,null,null));
});})(image_fields,map__35692,map__35692__$1,attachments))
;
return iter__7189__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq35688){
var G__35689 = cljs.core.first(seq35688);
var seq35688__$1 = cljs.core.next(seq35688);
var G__35690 = cljs.core.first(seq35688__$1);
var seq35688__$2 = cljs.core.next(seq35688__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__35689,G__35690,seq35688__$2);
});

/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,hatti.constants._attachments)], 0)));
});})(repeat_fields))
;
var iter__7189__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__35710(s__35711){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__35711__$1 = s__35711;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35711__$1);
if(temp__4657__auto__){
var s__35711__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35711__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35711__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35713 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35712 = (0);
while(true){
if((i__35712 < size__7188__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35712);
cljs.core.chunk_append(b__35713,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__35716 = (i__35712 + (1));
i__35712 = G__35716;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35713),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__35710(cljs.core.chunk_rest(s__35711__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35713),null);
}
} else {
var record = cljs.core.first(s__35711__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__35710(cljs.core.rest(s__35711__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__7189__auto__(data);
});
/**
 * Inlines data from within _attachments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___35724 = arguments.length;
var i__7485__auto___35725 = (0);
while(true){
if((i__7485__auto___35725 < len__7484__auto___35724)){
args__7491__auto__.push((arguments[i__7485__auto___35725]));

var G__35726 = (i__7485__auto___35725 + (1));
i__7485__auto___35725 = G__35726;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__35721){
var map__35722 = p__35721;
var map__35722__$1 = ((((!((map__35722 == null)))?((((map__35722.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35722.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35722):map__35722);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35722__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__35722,map__35722__$1,app_data_keys){
return (function (p1__35717_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__35717_SHARP_));
});})(map__35722,map__35722__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq35718){
var G__35719 = cljs.core.first(seq35718);
var seq35718__$1 = cljs.core.next(seq35718);
var G__35720 = cljs.core.first(seq35718__$1);
var seq35718__$2 = cljs.core.next(seq35718__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35719,G__35720,seq35718__$2);
});

