// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.dataview');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.views.photos');
goog.require('sablono.core');
goog.require('hatti.views.user_guide');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.views.map');
goog.require('hatti.views.chart');
goog.require('hatti.views.report_view');
goog.require('hatti.shared');
goog.require('chimera.metrics');
goog.require('hatti.views.saved_charts');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('hatti.views.settings');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('hatti.views.overview');
goog.require('hatti.views.table');
hatti.views.dataview.dataview_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$user_DASH_guide,cljs.core.cst$kw$table,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$settings,cljs.core.cst$kw$overview,cljs.core.cst$kw$chart,cljs.core.cst$kw$photos,cljs.core.cst$kw$map],[new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$user_DASH_guide,cljs.core.cst$kw$label,"User Guide",cljs.core.cst$kw$component,hatti.views.user_guide_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$table,cljs.core.cst$kw$label,"Table",cljs.core.cst$kw$component,hatti.views.table_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$label,"Reports",cljs.core.cst$kw$component,hatti.views.report_view_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$label,"Dashboard",cljs.core.cst$kw$component,hatti.views.saved_charts_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$settings,cljs.core.cst$kw$label,"Settings",cljs.core.cst$kw$component,hatti.views.settings_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$overview,cljs.core.cst$kw$label,"Overview",cljs.core.cst$kw$component,hatti.views.overview_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$chart,cljs.core.cst$kw$label,"Charts",cljs.core.cst$kw$component,hatti.views.chart_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$photos,cljs.core.cst$kw$label,"Photos",cljs.core.cst$kw$component,hatti.views.photos_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$map,cljs.core.cst$kw$label,"Map",cljs.core.cst$kw$component,hatti.views.map_page], null)]);
/**
 * Initial Dataview State
 */
hatti.views.dataview.default_dataviews = (function hatti$views$dataview$default_dataviews(){
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(hatti.views.dataview.dataview_map) : cljs.core.atom.call(null,hatti.views.dataview.dataview_map));
});
hatti.views.dataview.view_state = hatti.views.dataview.default_dataviews();
/**
 * Build and set the tooltips for inactive views based on why they are
 * inactive.
 */
hatti.views.dataview.view__GT_inactive_tab = (function hatti$views$dataview$view__GT_inactive_tab(view,label,is_encrypted_QMARK_,not_within_pricing_limits_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$inactive,[cljs.core.str(label),cljs.core.str(" ")].join(''),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$tooltip,(cljs.core.truth_(is_encrypted_QMARK_)?"This tab is disabled because this form is encrypted.":(cljs.core.truth_(not_within_pricing_limits_QMARK_)?"This tab is disabled because you are over the pricing limits.":(function (){var pred__38801 = cljs.core._EQ_;
var expr__38802 = view;
if(cljs.core.truth_((function (){var G__38804 = cljs.core.cst$kw$map;
var G__38805 = expr__38802;
return (pred__38801.cljs$core$IFn$_invoke$arity$2 ? pred__38801.cljs$core$IFn$_invoke$arity$2(G__38804,G__38805) : pred__38801.call(null,G__38804,G__38805));
})())){
return [cljs.core.str("The Map tab is disabled because this form "),cljs.core.str("has no location questions.")].join('');
} else {
if(cljs.core.truth_((function (){var G__38806 = cljs.core.cst$kw$photos;
var G__38807 = expr__38802;
return (pred__38801.cljs$core$IFn$_invoke$arity$2 ? pred__38801.cljs$core$IFn$_invoke$arity$2(G__38806,G__38807) : pred__38801.call(null,G__38806,G__38807));
})())){
return [cljs.core.str("The Photos tab is disabled because this form has no "),cljs.core.str("photo questions.")].join('');
} else {
if(cljs.core.truth_((function (){var G__38808 = cljs.core.cst$kw$table;
var G__38809 = expr__38802;
return (pred__38801.cljs$core$IFn$_invoke$arity$2 ? pred__38801.cljs$core$IFn$_invoke$arity$2(G__38808,G__38809) : pred__38801.call(null,G__38808,G__38809));
})())){
return [cljs.core.str("The table tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_((function (){var G__38810 = cljs.core.cst$kw$chart;
var G__38811 = expr__38802;
return (pred__38801.cljs$core$IFn$_invoke$arity$2 ? pred__38801.cljs$core$IFn$_invoke$arity$2(G__38810,G__38811) : pred__38801.call(null,G__38810,G__38811));
})())){
return [cljs.core.str("The charts tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_((function (){var G__38812 = cljs.core.cst$kw$saved_DASH_charts;
var G__38813 = expr__38802;
return (pred__38801.cljs$core$IFn$_invoke$arity$2 ? pred__38801.cljs$core$IFn$_invoke$arity$2(G__38812,G__38813) : pred__38801.call(null,G__38812,G__38813));
})())){
return [cljs.core.str("The dashboards tab is disabled because "),cljs.core.str("you do not have permission to view it.")].join('');
} else {
return "This tab is disabled.";
}
}
}
}
}
})()
))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_question,"?"], null)], null)], null);
});
hatti.views.dataview_actions.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.dataview.t_hatti$views$dataview38814 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview38814 = (function (cursor,owner,meta38815){
this.cursor = cursor;
this.owner = owner;
this.meta38815 = meta38815;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview38814.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38816,meta38815__$1){
var self__ = this;
var _38816__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview38814(self__.cursor,self__.owner,meta38815__$1));
});

hatti.views.dataview.t_hatti$views$dataview38814.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38816){
var self__ = this;
var _38816__$1 = this;
return self__.meta38815;
});

hatti.views.dataview.t_hatti$views$dataview38814.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview38814.prototype.om$core$IRender$render$arity$1 = (function (this__18366__auto__){
var self__ = this;
var this__18366__auto____$1 = this;
return null;
});

hatti.views.dataview.t_hatti$views$dataview38814.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta38815], null);
});

hatti.views.dataview.t_hatti$views$dataview38814.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview38814.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview38814";

hatti.views.dataview.t_hatti$views$dataview38814.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview38814");
});

hatti.views.dataview.__GT_t_hatti$views$dataview38814 = (function hatti$views$dataview$__GT_t_hatti$views$dataview38814(cursor__$1,owner__$1,meta38815){
return (new hatti.views.dataview.t_hatti$views$dataview38814(cursor__$1,owner__$1,meta38815));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview38814(cursor,owner,null));
}));
hatti.views.dataview_infobar.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__38817,owner){
var map__38818 = p__38817;
var map__38818__$1 = ((((!((map__38818 == null)))?((((map__38818.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38818.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38818):map__38818);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38818__$1,cljs.core.cst$kw$dataset_DASH_info);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38818__$1,cljs.core.cst$kw$status);
if(typeof hatti.views.dataview.t_hatti$views$dataview38820 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview38820 = (function (p__38817,owner,map__38818,dataset_info,status,meta38821){
this.p__38817 = p__38817;
this.owner = owner;
this.map__38818 = map__38818;
this.dataset_info = dataset_info;
this.status = status;
this.meta38821 = meta38821;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview38820.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__38818,map__38818__$1,dataset_info,status){
return (function (_38822,meta38821__$1){
var self__ = this;
var _38822__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview38820(self__.p__38817,self__.owner,self__.map__38818,self__.dataset_info,self__.status,meta38821__$1));
});})(map__38818,map__38818__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview38820.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__38818,map__38818__$1,dataset_info,status){
return (function (_38822){
var self__ = this;
var _38822__$1 = this;
return self__.meta38821;
});})(map__38818,map__38818__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview38820.prototype.om$core$IWillMount$ = true;

hatti.views.dataview.t_hatti$views$dataview38820.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__38818,map__38818__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
return hatti.shared.maybe_merge_languages_BANG_(om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form));
});})(map__38818,map__38818__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview38820.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview38820.prototype.om$core$IRender$render$arity$1 = ((function (map__38818,map__38818__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var map__38823 = self__.dataset_info;
var map__38823__$1 = ((((!((map__38823 == null)))?((((map__38823.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38823.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38823):map__38823);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38823__$1,cljs.core.cst$kw$num_of_submissions);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38823__$1,cljs.core.cst$kw$formid);
var map__38824 = self__.status;
var map__38824__$1 = ((((!((map__38824 == null)))?((((map__38824.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38824.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38824):map__38824);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38824__$1,cljs.core.cst$kw$loading_QMARK_);
var total_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38824__$1,cljs.core.cst$kw$total_DASH_records);
var G__38831 = ({"className": "right rec-summary rec-margin"});
var G__38832 = (function (){var attrs38827 = (cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))?om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.shared.language_selector,null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs38827))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,"language-selector"], null),attrs38827], 0))):({"id": "language-selector"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs38827))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs38827)], null))));
})();
var G__38833 = (function (){var G__38836 = ({"id": "data-status"});
var G__38837 = (function (){var attrs38828 = (cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs38828))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rec"], null)], null),attrs38828], 0))):({"className": "rec"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs38828))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs38828),sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null))));
})();
return React.DOM.div(G__38836,G__38837);
})();
var G__38834 = (function (){var G__38838 = ({"className": "divider"});
return React.DOM.div(G__38838);
})();
var G__38835 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_actions,formid));
return React.DOM.div(G__38831,G__38832,G__38833,G__38834,G__38835);
});})(map__38818,map__38818__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview38820.getBasis = ((function (map__38818,map__38818__$1,dataset_info,status){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__38817,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__38818,cljs.core.cst$sym$dataset_DASH_info,cljs.core.cst$sym$status,cljs.core.cst$sym$meta38821], null);
});})(map__38818,map__38818__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview38820.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview38820.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview38820";

hatti.views.dataview.t_hatti$views$dataview38820.cljs$lang$ctorPrWriter = ((function (map__38818,map__38818__$1,dataset_info,status){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview38820");
});})(map__38818,map__38818__$1,dataset_info,status))
;

hatti.views.dataview.__GT_t_hatti$views$dataview38820 = ((function (map__38818,map__38818__$1,dataset_info,status){
return (function hatti$views$dataview$__GT_t_hatti$views$dataview38820(p__38817__$1,owner__$1,map__38818__$2,dataset_info__$1,status__$1,meta38821){
return (new hatti.views.dataview.t_hatti$views$dataview38820(p__38817__$1,owner__$1,map__38818__$2,dataset_info__$1,status__$1,meta38821));
});})(map__38818,map__38818__$1,dataset_info,status))
;

}

return (new hatti.views.dataview.t_hatti$views$dataview38820(p__38817,owner,map__38818__$1,dataset_info,status,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Strip off ampersand suffixes then switch to view if result is a valid view
 */
hatti.views.dataview.activate_view_BANG_ = (function hatti$views$dataview$activate_view_BANG_(view){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((function (){var or__6409__auto__ = cljs.core.last(cljs.core.re_find(/(.*?)&/,view));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return view;
}
})());
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_(cljs.core.set(views),view__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_settings_view_BANG_ = (function hatti$views$dataview$activate_settings_view_BANG_(view,settings_section){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$active_DASH_tab,settings_section__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_integrated_apps_view_BANG_ = (function hatti$views$dataview$activate_integrated_apps_view_BANG_(view,settings_section,app_type){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.app_state,((function (view__$1,settings_section__$1,settings_views){
return (function (app_state){
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$selected], null),view__$1),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$active_DASH_tab], null),settings_section__$1),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps,cljs.core.cst$kw$active_DASH_section], null),app_type);
});})(view__$1,settings_section__$1,settings_views))
);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(app_type,hatti.constants.google_sheets)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$add_QMARK_,true], null));
} else {
}

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.tabbed_dataview.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,opts){
if(typeof hatti.views.dataview.t_hatti$views$dataview38842 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview38842 = (function (app_state,owner,opts,meta38843){
this.app_state = app_state;
this.owner = owner;
this.opts = opts;
this.meta38843 = meta38843;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview38842.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38844,meta38843__$1){
var self__ = this;
var _38844__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview38842(self__.app_state,self__.owner,self__.opts,meta38843__$1));
});

hatti.views.dataview.t_hatti$views$dataview38842.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38844){
var self__ = this;
var _38844__$1 = this;
return self__.meta38843;
});

hatti.views.dataview.t_hatti$views$dataview38842.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview38842.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var map__38845 = self__.app_state;
var map__38845__$1 = ((((!((map__38845 == null)))?((((map__38845.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38845.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38845):map__38845);
var map__38846 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38845__$1,cljs.core.cst$kw$views);
var map__38846__$1 = ((((!((map__38846 == null)))?((((map__38846.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38846.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38846):map__38846);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38846__$1,cljs.core.cst$kw$active);
var disabled = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38846__$1,cljs.core.cst$kw$disabled);
var selected = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38846__$1,cljs.core.cst$kw$selected);
var is_encrypted_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38845__$1,cljs.core.cst$kw$is_DASH_encrypted_QMARK_);
var is_within_pricing_limits_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38845__$1,cljs.core.cst$kw$is_DASH_within_DASH_pricing_DASH_limits_QMARK_);
var view__GT_display = ((function (map__38845,map__38845__$1,map__38846,map__38846__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1){
return (function (p1__38839_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,p1__38839_SHARP_)){
return "block";
} else {
return "none";
}
});})(map__38845,map__38845__$1,map__38846,map__38846__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1))
;
var view__GT_cls = ((function (map__38845,map__38845__$1,map__38846,map__38846__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1){
return (function (p1__38840_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,p1__38840_SHARP_)){
return "clicked";
} else {
return null;
}
});})(map__38845,map__38845__$1,map__38846,map__38846__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1))
;
var dataviews = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.views.dataview.view_state) : cljs.core.deref.call(null,hatti.views.dataview.view_state)),cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))));
var dv__GT_link = ((function (map__38845,map__38845__$1,map__38846,map__38846__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p__38849){
var map__38850 = p__38849;
var map__38850__$1 = ((((!((map__38850 == null)))?((((map__38850.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38850.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38850):map__38850);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38850__$1,cljs.core.cst$kw$view);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38850__$1,cljs.core.cst$kw$label);
if(cljs.core.truth_((function (){var and__6397__auto__ = cljs.core.some(((function (map__38850,map__38850__$1,view,label,map__38845,map__38845__$1,map__38846,map__38846__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p1__38841_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,p1__38841_SHARP_);
});})(map__38850,map__38850__$1,view,label,map__38845,map__38845__$1,map__38846,map__38846__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
,active);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not(chimera.seq.in_QMARK_(disabled,view));
} else {
return and__6397__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,view__GT_cls(view),cljs.core.cst$kw$href,[cljs.core.str("#/"),cljs.core.str(cljs.core.name(view))].join('')], null),label], null);
} else {
return hatti.views.dataview.view__GT_inactive_tab(view,label,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_);
}
});})(map__38845,map__38845__$1,map__38846,map__38846__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
;
var G__38853 = ({"className": "tab-container dataset-tabs"});
var G__38854 = (function (){var attrs38852 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(dv__GT_link,dataviews);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs38852))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-bar"], null)], null),attrs38852], 0))):({"className": "tab-bar"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs38852))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs38852),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null))));
})();
var G__38855 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = ((function (G__38853,G__38854,map__38845,map__38845__$1,map__38846,map__38846__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function hatti$views$dataview$iter__38856(s__38857){
return (new cljs.core.LazySeq(null,((function (G__38853,G__38854,map__38845,map__38845__$1,map__38846,map__38846__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function (){
var s__38857__$1 = s__38857;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38857__$1);
if(temp__4657__auto__){
var s__38857__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38857__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38857__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38859 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38858 = (0);
while(true){
if((i__38858 < size__7188__auto__)){
var map__38870 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38858);
var map__38870__$1 = ((((!((map__38870 == null)))?((((map__38870.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38870.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38870):map__38870);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38870__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38870__$1,cljs.core.cst$kw$view);
var view_name = cljs.core.name(view);
cljs.core.chunk_append(b__38859,(function (){var G__38872 = ({"style": ({"height": cljs.core.cst$kw$table_DASH_view_DASH_height.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$table_DASH_page.cljs$core$IFn$_invoke$arity$1(self__.app_state)), "display": view__GT_display(view), "overflowX": (cljs.core.truth_(cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$table_DASH_page.cljs$core$IFn$_invoke$arity$1(self__.app_state)))?"hidden":"scroll")}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')});
var G__38873 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,view))?(function (){
chimera.metrics.send_event(cljs.core.cst$kw$Dataview,[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null);
})()
:null));
return React.DOM.div(G__38872,G__38873);
})());

var G__38878 = (i__38858 + (1));
i__38858 = G__38878;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38859),hatti$views$dataview$iter__38856(cljs.core.chunk_rest(s__38857__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38859),null);
}
} else {
var map__38874 = cljs.core.first(s__38857__$2);
var map__38874__$1 = ((((!((map__38874 == null)))?((((map__38874.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38874.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38874):map__38874);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38874__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38874__$1,cljs.core.cst$kw$view);
var view_name = cljs.core.name(view);
return cljs.core.cons((function (){var G__38876 = ({"style": ({"height": cljs.core.cst$kw$table_DASH_view_DASH_height.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$table_DASH_page.cljs$core$IFn$_invoke$arity$1(self__.app_state)), "display": view__GT_display(view), "overflowX": (cljs.core.truth_(cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$table_DASH_page.cljs$core$IFn$_invoke$arity$1(self__.app_state)))?"hidden":"scroll")}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')});
var G__38877 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,view))?(function (){
chimera.metrics.send_event(cljs.core.cst$kw$Dataview,[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null);
})()
:null));
return React.DOM.div(G__38876,G__38877);
})(),hatti$views$dataview$iter__38856(cljs.core.rest(s__38857__$2)));
}
} else {
return null;
}
break;
}
});})(G__38853,G__38854,map__38845,map__38845__$1,map__38846,map__38846__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
,null,null));
});})(G__38853,G__38854,map__38845,map__38845__$1,map__38846,map__38846__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
;
return iter__7189__auto__(dataviews);
})());
return React.DOM.div(G__38853,G__38854,G__38855);
});

hatti.views.dataview.t_hatti$views$dataview38842.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta38843], null);
});

hatti.views.dataview.t_hatti$views$dataview38842.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview38842.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview38842";

hatti.views.dataview.t_hatti$views$dataview38842.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview38842");
});

hatti.views.dataview.__GT_t_hatti$views$dataview38842 = (function hatti$views$dataview$__GT_t_hatti$views$dataview38842(app_state__$1,owner__$1,opts__$1,meta38843){
return (new hatti.views.dataview.t_hatti$views$dataview38842(app_state__$1,owner__$1,opts__$1,meta38843));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview38842(app_state,owner,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
