// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0))], 0))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__37950_SHARP_){
if(typeof p1__37950_SHARP_ === 'string'){
return clojure.string.lower_case(p1__37950_SHARP_);
} else {
return p1__37950_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__37956){
var vec__37957 = p__37956;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37957,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37957,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,cljs.core.array_seq([cljs.core.cst$kw$compact_QMARK_,true], 0));
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__37951_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__37951_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
var media_count = (dataContext["_media_count"]);
var total_media = (dataContext["_total_media"]);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,chimera.string.escape_for_type(clj_value),cljs.core.array_seq([cljs.core.cst$kw$language,language,cljs.core.cst$kw$compact_QMARK_,true,cljs.core.cst$kw$field_DASH_key,field_key,cljs.core.cst$kw$media_DASH_count,media_count,cljs.core.cst$kw$total_DASH_media,total_media], 0));
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__37960 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__37960__$1 = ((((!((map__37960 == null)))?((((map__37960.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37960.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37960):map__37960);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37960__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37960__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37960__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$delete_DASH_record,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$data_DASH_id,value], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip$middle_DASH_right,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_eye,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.select_unselect_all_records_id = "select-unselect-all-records";
hatti.views.table.select_unselect_all_records_element = [cljs.core.str("<input type=\"checkbox\" id=\""),cljs.core.str(hatti.views.table.select_unselect_all_records_id),cljs.core.str("\">")].join('');
hatti.views.table.delete_record_class = "delete-record";
hatti.views.table.submission_review_fields = (function hatti$views$table$submission_review_fields(cols){
var vec__37965 = cljs.core.split_at((1),cols);
var actions = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37965,(0),null);
var data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37965,(1),null);
return cljs.core.vec(cljs.core.flatten(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(data,hatti.ona.forms.review_comment_field,cljs.core.array_seq([hatti.ona.forms.review_status_field,actions], 0))));
});
hatti.views.actions_column.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(100),hatti.views.table.select_unselect_all_records_element,(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
}));
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37999 = arguments.length;
var i__7485__auto___38000 = (0);
while(true){
if((i__7485__auto___38000 < len__7484__auto___37999)){
args__7491__auto__.push((arguments[i__7485__auto___38000]));

var G__38001 = (i__7485__auto___38000 + (1));
i__7485__auto___38000 = G__38001;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__37971){
var map__37972 = p__37971;
var map__37972__$1 = ((((!((map__37972 == null)))?((((map__37972.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37972.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37972):map__37972);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37972__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var submission_review_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37972__$1,cljs.core.cst$kw$submission_DASH_review_QMARK_);
var get_label_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__37972__$1,cljs.core.cst$kw$get_DASH_label_QMARK_,true);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37972__$1,cljs.core.cst$kw$language);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37972__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = (function (){var G__37974 = cljs.core.false_QMARK_;
var G__37975 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__37974,map__37972,map__37972__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__37968_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__37968_SHARP_)) == null);
});})(G__37974,map__37972,map__37972__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
,form);
return (chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__37974,G__37975) : chimera.core.any_QMARK_.call(null,G__37974,G__37975));
})();
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__37972,map__37972__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__37976(s__37977){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__37972,map__37972__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__37977__$1 = s__37977;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37977__$1);
if(temp__4657__auto__){
var s__37977__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37977__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37977__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37979 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37978 = (0);
while(true){
if((i__37978 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37978);
cljs.core.chunk_append(b__37979,(function (){var map__37990 = field;
var map__37990__$1 = ((((!((map__37990 == null)))?((((map__37990.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37990.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37990):map__37990);
var map__37991 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37990__$1,cljs.core.cst$kw$instance);
var map__37991__$1 = ((((!((map__37991 == null)))?((((map__37991.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37991.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37991):map__37991);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37991__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37990__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37990__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37990__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__38002 = (i__37978 + (1));
i__37978 = G__38002;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37979),hatti$views$table$iter__37976(cljs.core.chunk_rest(s__37977__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37979),null);
}
} else {
var field = cljs.core.first(s__37977__$2);
return cljs.core.cons((function (){var map__37994 = field;
var map__37994__$1 = ((((!((map__37994 == null)))?((((map__37994.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37994.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37994):map__37994);
var map__37995 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37994__$1,cljs.core.cst$kw$instance);
var map__37995__$1 = ((((!((map__37995 == null)))?((((map__37995.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37995.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37995):map__37995);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37995__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37994__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37994__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37994__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__37976(cljs.core.rest(s__37977__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__37972,map__37972__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__37972,map__37972__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__(hatti.views.table.all_fields(form));
})();
return cljs.core.clj__GT_js((function (){var G__37998 = columns;
var G__37998__$1 = ((cljs.core.not(hide_actions_column_QMARK_))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__37998,(hatti.views.actions_column.cljs$core$IFn$_invoke$arity$2 ? hatti.views.actions_column.cljs$core$IFn$_invoke$arity$2(owner,has_hxl_QMARK_) : hatti.views.actions_column.call(null,owner,has_hxl_QMARK_))):G__37998);
if(cljs.core.truth_(submission_review_QMARK_)){
return hatti.views.table.submission_review_fields(G__37998__$1);
} else {
return G__37998__$1;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq37969){
var G__37970 = cljs.core.first(seq37969);
var seq37969__$1 = cljs.core.next(seq37969);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__37970,seq37969__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__38004 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__38004);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38023(s__38024){
return (new cljs.core.LazySeq(null,(function (){
var s__38024__$1 = s__38024;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38024__$1);
if(temp__4657__auto__){
var s__38024__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38024__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38024__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38026 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38025 = (0);
while(true){
if((i__38025 < size__7188__auto__)){
var vec__38035 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38025);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38035,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38035,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__38026,event.subscribe(handler_function));

var G__38041 = (i__38025 + (1));
i__38025 = G__38041;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38026),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38023(cljs.core.chunk_rest(s__38024__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38026),null);
}
} else {
var vec__38038 = cljs.core.first(s__38024__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38038,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38038,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38023(cljs.core.rest(s__38024__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38060(s__38061){
return (new cljs.core.LazySeq(null,(function (){
var s__38061__$1 = s__38061;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38061__$1);
if(temp__4657__auto__){
var s__38061__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38061__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38061__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38063 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38062 = (0);
while(true){
if((i__38062 < size__7188__auto__)){
var vec__38072 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38062);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38072,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38072,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__38063,event.subscribe(handler_function));

var G__38078 = (i__38062 + (1));
i__38062 = G__38078;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38063),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38060(cljs.core.chunk_rest(s__38061__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38063),null);
}
} else {
var vec__38075 = cljs.core.first(s__38061__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38075,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38075,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38060(cljs.core.rest(s__38061__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.update_data_to_be_deleted_vector = (function hatti$views$table$update_data_to_be_deleted_vector(checked_QMARK_,data_id){
var map__38081 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38081__$1 = ((((!((map__38081 == null)))?((((map__38081.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38081.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38081):map__38081);
var data_to_be_deleted = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38081__$1,cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted);
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted], null),((function (map__38081,map__38081__$1,data_to_be_deleted,fn){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(data_to_be_deleted,data_id) : fn.call(null,data_to_be_deleted,data_id));
});})(map__38081,map__38081__$1,data_to_be_deleted,fn))
);
});
hatti.views.table.get_elements_count_by_selector = (function hatti$views$table$get_elements_count_by_selector(selector){
return document.querySelectorAll(selector).length;
});
hatti.views.table.check_select_unselect_all_records_element_QMARK_ = (function hatti$views$table$check_select_unselect_all_records_element_QMARK_(){
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
var selected_rows_count = hatti.views.table.get_elements_count_by_selector([cljs.core.str(delete_record_class_selector),cljs.core.str(":checked")].join(''));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected_rows_count,total_rows_count);
});
hatti.views.table.get_checkbox_selector = (function hatti$views$table$get_checkbox_selector(data_id){
return [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class),cljs.core.str("[data-id=\""),cljs.core.str(data_id),cljs.core.str("\"]")].join('');
});
hatti.views.table.get_delete_checkbox_by_data_id = (function hatti$views$table$get_delete_checkbox_by_data_id(data_id){
var selector = hatti.views.table.get_checkbox_selector(data_id);
return document.querySelector(selector);
});
hatti.views.table.select_rows_marked_to_be_deleted = (function hatti$views$table$select_rows_marked_to_be_deleted(){
var seq__38087 = cljs.core.seq(cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var chunk__38088 = null;
var count__38089 = (0);
var i__38090 = (0);
while(true){
if((i__38090 < count__38089)){
var data_id = chunk__38088.cljs$core$IIndexed$_nth$arity$2(null,i__38090);
var element_38091 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38091.checked = true;

var G__38092 = seq__38087;
var G__38093 = chunk__38088;
var G__38094 = count__38089;
var G__38095 = (i__38090 + (1));
seq__38087 = G__38092;
chunk__38088 = G__38093;
count__38089 = G__38094;
i__38090 = G__38095;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__38087);
if(temp__4657__auto__){
var seq__38087__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38087__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__38087__$1);
var G__38096 = cljs.core.chunk_rest(seq__38087__$1);
var G__38097 = c__7220__auto__;
var G__38098 = cljs.core.count(c__7220__auto__);
var G__38099 = (0);
seq__38087 = G__38096;
chunk__38088 = G__38097;
count__38089 = G__38098;
i__38090 = G__38099;
continue;
} else {
var data_id = cljs.core.first(seq__38087__$1);
var element_38100 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38100.checked = true;

var G__38101 = cljs.core.next(seq__38087__$1);
var G__38102 = null;
var G__38103 = (0);
var G__38104 = (0);
seq__38087 = G__38101;
chunk__38088 = G__38102;
count__38089 = G__38103;
i__38090 = G__38104;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.higlight_rows_marked_to_be_deleted = (function hatti$views$table$higlight_rows_marked_to_be_deleted(grid){
var checkboxes = document.getElementsByClassName(hatti.views.table.delete_record_class);
var indexes_of_selected_checkboxes = cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (checkboxes){
return (function (index,checkbox){
if(cljs.core.truth_(checkbox.checked)){
return index;
} else {
return null;
}
});})(checkboxes))
,checkboxes)));
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (checkboxes,indexes_of_selected_checkboxes){
return (function (){
return cljs.core.identity(indexes_of_selected_checkboxes);
});})(checkboxes,indexes_of_selected_checkboxes))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(indexes_of_selected_checkboxes));
});
hatti.views.table.replace_review_num_status_with_text_status = (function hatti$views$table$replace_review_num_status_with_text_status(data){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (row_map){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(row_map,"_review_status",hatti.utils.get_submission_review_text(row_map));
}),data);
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__38105){
var map__38125 = p__38105;
var map__38125__$1 = ((((!((map__38125 == null)))?((((map__38125.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38125.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38125):map__38125);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38125__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38125__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var map__38127 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38127__$1 = ((((!((map__38127 == null)))?((((map__38127.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38127.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38127):map__38127);
var map__38128 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38127__$1,cljs.core.cst$kw$table_DASH_page);
var map__38128__$1 = ((((!((map__38128 == null)))?((((map__38128.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38128.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38128):map__38128);
var map__38129 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38128__$1,cljs.core.cst$kw$paging);
var map__38129__$1 = ((((!((map__38129 == null)))?((((map__38129.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38129.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38129):map__38129);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38129__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38129__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38128__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var submission_review_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38127__$1,cljs.core.cst$kw$submission_DASH_review_QMARK_);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$language,current_language,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,hide_actions_column_QMARK_,cljs.core.cst$kw$submission_DASH_review_QMARK_,submission_review_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

grid.setSelectionModel((new Slick.RowSelectionModel(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selectActiveRow,false], null)))));

dataview.onRowCountChanged.subscribe(((function (map__38127,map__38127__$1,map__38128,map__38128__$1,map__38129,map__38129__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38125,map__38125__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__38127,map__38127__$1,map__38128,map__38128__$1,map__38129,map__38129__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38125,map__38125__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__38127,map__38127__$1,map__38128,map__38128__$1,map__38129,map__38129__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38125,map__38125__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

grid.render();

hatti.views.table.select_rows_marked_to_be_deleted();

return hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
});})(map__38127,map__38127__$1,map__38128,map__38128__$1,map__38129,map__38129__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38125,map__38125__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onHeaderClick.subscribe(((function (map__38127,map__38127__$1,map__38128,map__38128__$1,map__38129,map__38129__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38125,map__38125__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var target = e.target;
var id = target.id;
var checked_QMARK_ = target.checked;
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hatti.views.table.select_unselect_all_records_id,id)){
var records_to_be_deleted = document.getElementsByClassName(hatti.views.table.delete_record_class);
var seq__38133_38144 = cljs.core.seq(records_to_be_deleted);
var chunk__38134_38145 = null;
var count__38135_38146 = (0);
var i__38136_38147 = (0);
while(true){
if((i__38136_38147 < count__38135_38146)){
var record_38148 = chunk__38134_38145.cljs$core$IIndexed$_nth$arity$2(null,i__38136_38147);
record_38148.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38137 = record_38148.getAttribute("data-id");
return parseInt(G__38137);
})());

var G__38149 = seq__38133_38144;
var G__38150 = chunk__38134_38145;
var G__38151 = count__38135_38146;
var G__38152 = (i__38136_38147 + (1));
seq__38133_38144 = G__38149;
chunk__38134_38145 = G__38150;
count__38135_38146 = G__38151;
i__38136_38147 = G__38152;
continue;
} else {
var temp__4657__auto___38153 = cljs.core.seq(seq__38133_38144);
if(temp__4657__auto___38153){
var seq__38133_38154__$1 = temp__4657__auto___38153;
if(cljs.core.chunked_seq_QMARK_(seq__38133_38154__$1)){
var c__7220__auto___38155 = cljs.core.chunk_first(seq__38133_38154__$1);
var G__38156 = cljs.core.chunk_rest(seq__38133_38154__$1);
var G__38157 = c__7220__auto___38155;
var G__38158 = cljs.core.count(c__7220__auto___38155);
var G__38159 = (0);
seq__38133_38144 = G__38156;
chunk__38134_38145 = G__38157;
count__38135_38146 = G__38158;
i__38136_38147 = G__38159;
continue;
} else {
var record_38160 = cljs.core.first(seq__38133_38154__$1);
record_38160.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38138 = record_38160.getAttribute("data-id");
return parseInt(G__38138);
})());

var G__38161 = cljs.core.next(seq__38133_38154__$1);
var G__38162 = null;
var G__38163 = (0);
var G__38164 = (0);
seq__38133_38144 = G__38161;
chunk__38134_38145 = G__38162;
count__38135_38146 = G__38163;
i__38136_38147 = G__38164;
continue;
}
} else {
}
}
break;
}

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38127,map__38127__$1,map__38128,map__38128__$1,map__38129,map__38129__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38125,map__38125__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
if(cljs.core.truth_(checked_QMARK_)){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1(total_rows_count);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});})(records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38127,map__38127__$1,map__38128,map__38128__$1,map__38129,map__38129__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38125,map__38125__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
return null;
}
});})(map__38127,map__38127__$1,map__38128,map__38128__$1,map__38129,map__38129__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38125,map__38125__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__38127,map__38127__$1,map__38128,map__38128__$1,map__38129,map__38129__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38125,map__38125__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(map__38127,map__38127__$1,map__38128,map__38128__$1,map__38129,map__38129__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38125,map__38125__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__38127,map__38127__$1,map__38128,map__38128__$1,map__38129,map__38129__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38125,map__38125__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var class_name = elem.className;
var checked_QMARK_ = elem.checked;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__38140 = elem.getAttribute("data-id");
return parseInt(G__38140);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
var select_unselect_all_records_chkbox = document.getElementById(hatti.views.table.select_unselect_all_records_id);
var map__38139 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38139__$1 = ((((!((map__38139 == null)))?((((map__38139.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38139.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38139):map__38139);
var selected_table_rows = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38139__$1,cljs.core.cst$kw$selected_DASH_table_DASH_rows);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(class_name,hatti.views.table.delete_record_class)){
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
var row__$1 = (function (){var G__38142 = grid.getCellFromEvent(e).row;
return parseInt(G__38142);
})();
hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,data_id);

select_unselect_all_records_chkbox.checked = hatti.views.table.check_select_unselect_all_records_element_QMARK_();

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38139,map__38139__$1,selected_table_rows,map__38127,map__38127__$1,map__38128,map__38128__$1,map__38129,map__38129__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38125,map__38125__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(selected_table_rows,row__$1) : fn.call(null,selected_table_rows,row__$1));
});})(fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38139,map__38139__$1,selected_table_rows,map__38127,map__38127__$1,map__38128,map__38128__$1,map__38129,map__38129__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38125,map__38125__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
}
});})(map__38127,map__38127__$1,map__38128,map__38128__$1,map__38129,map__38129__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38125,map__38125__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js((function (){var G__38143 = data;
if(cljs.core.truth_(submission_review_QMARK_)){
return hatti.views.table.replace_review_num_status_with_text_status(G__38143);
} else {
return G__38143;
}
})()),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__12283__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto__,event_chan){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__,event_chan){
return (function (state_38456){
var state_val_38457 = (state_38456[(1)]);
if((state_val_38457 === (7))){
var inst_38354 = (state_38456[(7)]);
var inst_38354__$1 = (state_38456[(2)]);
var inst_38356 = (inst_38354__$1 == null);
var inst_38357 = cljs.core.not(inst_38356);
var state_38456__$1 = (function (){var statearr_38458 = state_38456;
(statearr_38458[(7)] = inst_38354__$1);

return statearr_38458;
})();
if(inst_38357){
var statearr_38459_38534 = state_38456__$1;
(statearr_38459_38534[(1)] = (8));

} else {
var statearr_38460_38535 = state_38456__$1;
(statearr_38460_38535[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (20))){
var inst_38384 = (state_38456[(8)]);
var inst_38376 = (state_38456[(9)]);
var inst_38393 = (inst_38384.cljs$core$IFn$_invoke$arity$1 ? inst_38384.cljs$core$IFn$_invoke$arity$1(inst_38376) : inst_38384.call(null,inst_38376));
var state_38456__$1 = state_38456;
var statearr_38461_38536 = state_38456__$1;
(statearr_38461_38536[(2)] = inst_38393);

(statearr_38461_38536[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (27))){
var state_38456__$1 = state_38456;
var statearr_38462_38537 = state_38456__$1;
(statearr_38462_38537[(2)] = null);

(statearr_38462_38537[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (1))){
var state_38456__$1 = state_38456;
var statearr_38463_38538 = state_38456__$1;
(statearr_38463_38538[(2)] = null);

(statearr_38463_38538[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (24))){
var state_38456__$1 = state_38456;
var statearr_38464_38539 = state_38456__$1;
(statearr_38464_38539[(2)] = null);

(statearr_38464_38539[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (4))){
var state_38456__$1 = state_38456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38456__$1,(7),event_chan);
} else {
if((state_val_38457 === (15))){
var inst_38354 = (state_38456[(7)]);
var state_38456__$1 = state_38456;
var statearr_38465_38540 = state_38456__$1;
(statearr_38465_38540[(2)] = inst_38354);

(statearr_38465_38540[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (21))){
var state_38456__$1 = state_38456;
var statearr_38466_38541 = state_38456__$1;
(statearr_38466_38541[(2)] = null);

(statearr_38466_38541[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (31))){
var inst_38380 = (state_38456[(10)]);
var inst_38429 = (state_38456[(2)]);
var inst_38430 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38380,cljs.core.cst$kw$table);
var state_38456__$1 = (function (){var statearr_38467 = state_38456;
(statearr_38467[(11)] = inst_38429);

return statearr_38467;
})();
if(inst_38430){
var statearr_38468_38542 = state_38456__$1;
(statearr_38468_38542[(1)] = (32));

} else {
var statearr_38469_38543 = state_38456__$1;
(statearr_38469_38543[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (32))){
var inst_38378 = (state_38456[(12)]);
var inst_38375 = (state_38456[(13)]);
var inst_38379 = (state_38456[(14)]);
var inst_38385 = (state_38456[(15)]);
var inst_38380 = (state_38456[(10)]);
var inst_38374 = (state_38456[(16)]);
var inst_38377 = (state_38456[(17)]);
var inst_38384 = (state_38456[(8)]);
var inst_38376 = (state_38456[(9)]);
var inst_38443 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38444 = (function (){var new_columns = inst_38379;
var submission_clicked = inst_38376;
var submission_unclicked = inst_38377;
var get_submission_data = inst_38385;
var c__12283__auto____$1 = inst_38443;
var re_render = inst_38380;
var update_data_BANG_ = inst_38384;
var submission_to_rank = inst_38375;
var filter_by = inst_38378;
var map__38352 = inst_38374;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38352,inst_38378,inst_38375,inst_38379,inst_38385,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38443,state_val_38457,c__12283__auto__,event_chan){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38352,inst_38378,inst_38375,inst_38379,inst_38385,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38443,state_val_38457,c__12283__auto__,event_chan){
return (function (state_38441){
var state_val_38442 = (state_38441[(1)]);
if((state_val_38442 === (1))){
var inst_38432 = cljs.core.async.timeout((20));
var state_38441__$1 = state_38441;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38441__$1,(2),inst_38432);
} else {
if((state_val_38442 === (2))){
var inst_38434 = (state_38441[(2)]);
var inst_38435 = grid.resizeCanvas();
var inst_38436 = grid.invalidateAllRows();
var inst_38437 = hatti.views.table.resizeColumns(grid);
var inst_38438 = grid.render();
var inst_38439 = hatti.views.table.init_sg_pager(grid,dataview);
var state_38441__$1 = (function (){var statearr_38470 = state_38441;
(statearr_38470[(7)] = inst_38437);

(statearr_38470[(8)] = inst_38435);

(statearr_38470[(9)] = inst_38434);

(statearr_38470[(10)] = inst_38438);

(statearr_38470[(11)] = inst_38436);

return statearr_38470;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38441__$1,inst_38439);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38352,inst_38378,inst_38375,inst_38379,inst_38385,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38443,state_val_38457,c__12283__auto__,event_chan))
;
return ((function (switch__12171__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38352,inst_38378,inst_38375,inst_38379,inst_38385,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38443,state_val_38457,c__12283__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12172__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12172__auto____0 = (function (){
var statearr_38474 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38474[(0)] = hatti$views$table$handle_table_events_$_state_machine__12172__auto__);

(statearr_38474[(1)] = (1));

return statearr_38474;
});
var hatti$views$table$handle_table_events_$_state_machine__12172__auto____1 = (function (state_38441){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_38441);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e38475){if((e38475 instanceof Object)){
var ex__12175__auto__ = e38475;
var statearr_38476_38544 = state_38441;
(statearr_38476_38544[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38441);

return cljs.core.cst$kw$recur;
} else {
throw e38475;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__38545 = state_38441;
state_38441 = G__38545;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12172__auto__ = function(state_38441){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12172__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12172__auto____1.call(this,state_38441);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12172__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12172__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38352,inst_38378,inst_38375,inst_38379,inst_38385,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38443,state_val_38457,c__12283__auto__,event_chan))
})();
var state__12285__auto__ = (function (){var statearr_38477 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_38477[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto____$1);

return statearr_38477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38352,inst_38378,inst_38375,inst_38379,inst_38385,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38443,state_val_38457,c__12283__auto__,event_chan))
})();
var inst_38445 = cljs.core.async.impl.dispatch.run(inst_38444);
var state_38456__$1 = (function (){var statearr_38478 = state_38456;
(statearr_38478[(18)] = inst_38445);

return statearr_38478;
})();
var statearr_38479_38546 = state_38456__$1;
(statearr_38479_38546[(2)] = inst_38443);

(statearr_38479_38546[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (33))){
var state_38456__$1 = state_38456;
var statearr_38480_38547 = state_38456__$1;
(statearr_38480_38547[(2)] = null);

(statearr_38480_38547[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (13))){
var inst_38366 = (state_38456[(2)]);
var state_38456__$1 = state_38456;
var statearr_38481_38548 = state_38456__$1;
(statearr_38481_38548[(2)] = inst_38366);

(statearr_38481_38548[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (22))){
var inst_38377 = (state_38456[(17)]);
var inst_38396 = (state_38456[(2)]);
var state_38456__$1 = (function (){var statearr_38482 = state_38456;
(statearr_38482[(19)] = inst_38396);

return statearr_38482;
})();
if(cljs.core.truth_(inst_38377)){
var statearr_38483_38549 = state_38456__$1;
(statearr_38483_38549[(1)] = (23));

} else {
var statearr_38484_38550 = state_38456__$1;
(statearr_38484_38550[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (29))){
var inst_38378 = (state_38456[(12)]);
var inst_38421 = [cljs.core.cst$kw$query];
var inst_38422 = [inst_38378];
var inst_38423 = cljs.core.PersistentHashMap.fromArrays(inst_38421,inst_38422);
var inst_38424 = cljs.core.clj__GT_js(inst_38423);
var inst_38425 = dataview.setFilterArgs(inst_38424);
var inst_38426 = dataview.refresh();
var state_38456__$1 = (function (){var statearr_38485 = state_38456;
(statearr_38485[(20)] = inst_38425);

return statearr_38485;
})();
var statearr_38486_38551 = state_38456__$1;
(statearr_38486_38551[(2)] = inst_38426);

(statearr_38486_38551[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (6))){
var inst_38452 = (state_38456[(2)]);
var state_38456__$1 = state_38456;
var statearr_38487_38552 = state_38456__$1;
(statearr_38487_38552[(2)] = inst_38452);

(statearr_38487_38552[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (28))){
var inst_38378 = (state_38456[(12)]);
var inst_38419 = (state_38456[(2)]);
var state_38456__$1 = (function (){var statearr_38488 = state_38456;
(statearr_38488[(21)] = inst_38419);

return statearr_38488;
})();
if(cljs.core.truth_(inst_38378)){
var statearr_38489_38553 = state_38456__$1;
(statearr_38489_38553[(1)] = (29));

} else {
var statearr_38490_38554 = state_38456__$1;
(statearr_38490_38554[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (25))){
var inst_38379 = (state_38456[(14)]);
var inst_38401 = (state_38456[(2)]);
var state_38456__$1 = (function (){var statearr_38491 = state_38456;
(statearr_38491[(22)] = inst_38401);

return statearr_38491;
})();
if(cljs.core.truth_(inst_38379)){
var statearr_38492_38555 = state_38456__$1;
(statearr_38492_38555[(1)] = (26));

} else {
var statearr_38493_38556 = state_38456__$1;
(statearr_38493_38556[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (34))){
var inst_38448 = (state_38456[(2)]);
var state_38456__$1 = (function (){var statearr_38494 = state_38456;
(statearr_38494[(23)] = inst_38448);

return statearr_38494;
})();
var statearr_38495_38557 = state_38456__$1;
(statearr_38495_38557[(2)] = null);

(statearr_38495_38557[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (17))){
var inst_38375 = (state_38456[(13)]);
var inst_38385 = (state_38456[(15)]);
var inst_38384 = (state_38456[(8)]);
var inst_38387 = (inst_38385.cljs$core$IFn$_invoke$arity$2 ? inst_38385.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_38375) : inst_38385.call(null,hatti.constants._rank,inst_38375));
var inst_38388 = (inst_38384.cljs$core$IFn$_invoke$arity$1 ? inst_38384.cljs$core$IFn$_invoke$arity$1(inst_38387) : inst_38384.call(null,inst_38387));
var state_38456__$1 = state_38456;
var statearr_38496_38558 = state_38456__$1;
(statearr_38496_38558[(2)] = inst_38388);

(statearr_38496_38558[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (3))){
var inst_38454 = (state_38456[(2)]);
var state_38456__$1 = state_38456;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38456__$1,inst_38454);
} else {
if((state_val_38457 === (12))){
var state_38456__$1 = state_38456;
var statearr_38497_38559 = state_38456__$1;
(statearr_38497_38559[(2)] = false);

(statearr_38497_38559[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (2))){
var state_38456__$1 = state_38456;
var statearr_38498_38560 = state_38456__$1;
(statearr_38498_38560[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (23))){
var inst_38384 = (state_38456[(8)]);
var inst_38398 = (inst_38384.cljs$core$IFn$_invoke$arity$1 ? inst_38384.cljs$core$IFn$_invoke$arity$1(null) : inst_38384.call(null,null));
var state_38456__$1 = state_38456;
var statearr_38500_38561 = state_38456__$1;
(statearr_38500_38561[(2)] = inst_38398);

(statearr_38500_38561[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (19))){
var inst_38376 = (state_38456[(9)]);
var inst_38391 = (state_38456[(2)]);
var state_38456__$1 = (function (){var statearr_38501 = state_38456;
(statearr_38501[(24)] = inst_38391);

return statearr_38501;
})();
if(cljs.core.truth_(inst_38376)){
var statearr_38502_38562 = state_38456__$1;
(statearr_38502_38562[(1)] = (20));

} else {
var statearr_38503_38563 = state_38456__$1;
(statearr_38503_38563[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (11))){
var state_38456__$1 = state_38456;
var statearr_38504_38564 = state_38456__$1;
(statearr_38504_38564[(2)] = true);

(statearr_38504_38564[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (9))){
var state_38456__$1 = state_38456;
var statearr_38505_38565 = state_38456__$1;
(statearr_38505_38565[(2)] = false);

(statearr_38505_38565[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (5))){
var state_38456__$1 = state_38456;
var statearr_38506_38566 = state_38456__$1;
(statearr_38506_38566[(2)] = null);

(statearr_38506_38566[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (14))){
var inst_38354 = (state_38456[(7)]);
var inst_38371 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38354);
var state_38456__$1 = state_38456;
var statearr_38507_38567 = state_38456__$1;
(statearr_38507_38567[(2)] = inst_38371);

(statearr_38507_38567[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (26))){
var inst_38378 = (state_38456[(12)]);
var inst_38375 = (state_38456[(13)]);
var inst_38379 = (state_38456[(14)]);
var inst_38385 = (state_38456[(15)]);
var inst_38380 = (state_38456[(10)]);
var inst_38374 = (state_38456[(16)]);
var inst_38377 = (state_38456[(17)]);
var inst_38384 = (state_38456[(8)]);
var inst_38376 = (state_38456[(9)]);
var inst_38414 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38415 = (function (){var new_columns = inst_38379;
var submission_clicked = inst_38376;
var submission_unclicked = inst_38377;
var get_submission_data = inst_38385;
var c__12283__auto____$1 = inst_38414;
var re_render = inst_38380;
var update_data_BANG_ = inst_38384;
var submission_to_rank = inst_38375;
var filter_by = inst_38378;
var map__38352 = inst_38374;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38352,inst_38378,inst_38375,inst_38379,inst_38385,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38414,state_val_38457,c__12283__auto__,event_chan){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38352,inst_38378,inst_38375,inst_38379,inst_38385,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38414,state_val_38457,c__12283__auto__,event_chan){
return (function (state_38412){
var state_val_38413 = (state_38412[(1)]);
if((state_val_38413 === (1))){
var inst_38403 = cljs.core.async.timeout((20));
var state_38412__$1 = state_38412;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38412__$1,(2),inst_38403);
} else {
if((state_val_38413 === (2))){
var inst_38405 = (state_38412[(2)]);
var inst_38406 = grid.setColumns(new_columns);
var inst_38407 = hatti.views.table.resizeColumns(grid);
var inst_38408 = grid.render();
var inst_38409 = hatti.views.table.select_rows_marked_to_be_deleted();
var inst_38410 = hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
var state_38412__$1 = (function (){var statearr_38508 = state_38412;
(statearr_38508[(7)] = inst_38408);

(statearr_38508[(8)] = inst_38406);

(statearr_38508[(9)] = inst_38409);

(statearr_38508[(10)] = inst_38405);

(statearr_38508[(11)] = inst_38407);

return statearr_38508;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38412__$1,inst_38410);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38352,inst_38378,inst_38375,inst_38379,inst_38385,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38414,state_val_38457,c__12283__auto__,event_chan))
;
return ((function (switch__12171__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38352,inst_38378,inst_38375,inst_38379,inst_38385,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38414,state_val_38457,c__12283__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12172__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12172__auto____0 = (function (){
var statearr_38512 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38512[(0)] = hatti$views$table$handle_table_events_$_state_machine__12172__auto__);

(statearr_38512[(1)] = (1));

return statearr_38512;
});
var hatti$views$table$handle_table_events_$_state_machine__12172__auto____1 = (function (state_38412){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_38412);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e38513){if((e38513 instanceof Object)){
var ex__12175__auto__ = e38513;
var statearr_38514_38568 = state_38412;
(statearr_38514_38568[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38412);

return cljs.core.cst$kw$recur;
} else {
throw e38513;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__38569 = state_38412;
state_38412 = G__38569;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12172__auto__ = function(state_38412){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12172__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12172__auto____1.call(this,state_38412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12172__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12172__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38352,inst_38378,inst_38375,inst_38379,inst_38385,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38414,state_val_38457,c__12283__auto__,event_chan))
})();
var state__12285__auto__ = (function (){var statearr_38515 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_38515[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto____$1);

return statearr_38515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38352,inst_38378,inst_38375,inst_38379,inst_38385,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38414,state_val_38457,c__12283__auto__,event_chan))
})();
var inst_38416 = cljs.core.async.impl.dispatch.run(inst_38415);
var state_38456__$1 = (function (){var statearr_38516 = state_38456;
(statearr_38516[(25)] = inst_38416);

return statearr_38516;
})();
var statearr_38517_38570 = state_38456__$1;
(statearr_38517_38570[(2)] = inst_38414);

(statearr_38517_38570[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (16))){
var inst_38378 = (state_38456[(12)]);
var inst_38375 = (state_38456[(13)]);
var inst_38379 = (state_38456[(14)]);
var inst_38380 = (state_38456[(10)]);
var inst_38374 = (state_38456[(16)]);
var inst_38377 = (state_38456[(17)]);
var inst_38384 = (state_38456[(8)]);
var inst_38376 = (state_38456[(9)]);
var inst_38374__$1 = (state_38456[(2)]);
var inst_38375__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38374__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_38376__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38374__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_38377__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38374__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_38378__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38374__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_38379__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38374__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_38380__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38374__$1,cljs.core.cst$kw$re_DASH_render);
var inst_38381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38382 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_38383 = (new cljs.core.PersistentVector(null,3,(5),inst_38381,inst_38382,null));
var inst_38384__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_38383);
var inst_38385 = (function (){var map__38352 = inst_38374__$1;
var submission_to_rank = inst_38375__$1;
var submission_clicked = inst_38376__$1;
var submission_unclicked = inst_38377__$1;
var filter_by = inst_38378__$1;
var new_columns = inst_38379__$1;
var re_render = inst_38380__$1;
var update_data_BANG_ = inst_38384__$1;
return ((function (map__38352,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38378,inst_38375,inst_38379,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38374__$1,inst_38375__$1,inst_38376__$1,inst_38377__$1,inst_38378__$1,inst_38379__$1,inst_38380__$1,inst_38381,inst_38382,inst_38383,inst_38384__$1,state_val_38457,c__12283__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__38352,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38378,inst_38375,inst_38379,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38374__$1,inst_38375__$1,inst_38376__$1,inst_38377__$1,inst_38378__$1,inst_38379__$1,inst_38380__$1,inst_38381,inst_38382,inst_38383,inst_38384__$1,state_val_38457,c__12283__auto__,event_chan){
return (function (p1__38165_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__38165_SHARP_,field));
});})(map__38352,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38378,inst_38375,inst_38379,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38374__$1,inst_38375__$1,inst_38376__$1,inst_38377__$1,inst_38378__$1,inst_38379__$1,inst_38380__$1,inst_38381,inst_38382,inst_38383,inst_38384__$1,state_val_38457,c__12283__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(map__38352,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38378,inst_38375,inst_38379,inst_38380,inst_38374,inst_38377,inst_38384,inst_38376,inst_38374__$1,inst_38375__$1,inst_38376__$1,inst_38377__$1,inst_38378__$1,inst_38379__$1,inst_38380__$1,inst_38381,inst_38382,inst_38383,inst_38384__$1,state_val_38457,c__12283__auto__,event_chan))
})();
var state_38456__$1 = (function (){var statearr_38518 = state_38456;
(statearr_38518[(12)] = inst_38378__$1);

(statearr_38518[(13)] = inst_38375__$1);

(statearr_38518[(14)] = inst_38379__$1);

(statearr_38518[(15)] = inst_38385);

(statearr_38518[(10)] = inst_38380__$1);

(statearr_38518[(16)] = inst_38374__$1);

(statearr_38518[(17)] = inst_38377__$1);

(statearr_38518[(8)] = inst_38384__$1);

(statearr_38518[(9)] = inst_38376__$1);

return statearr_38518;
})();
if(cljs.core.truth_(inst_38375__$1)){
var statearr_38519_38571 = state_38456__$1;
(statearr_38519_38571[(1)] = (17));

} else {
var statearr_38520_38572 = state_38456__$1;
(statearr_38520_38572[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (30))){
var state_38456__$1 = state_38456;
var statearr_38521_38573 = state_38456__$1;
(statearr_38521_38573[(2)] = null);

(statearr_38521_38573[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (10))){
var inst_38369 = (state_38456[(2)]);
var state_38456__$1 = state_38456;
if(cljs.core.truth_(inst_38369)){
var statearr_38522_38574 = state_38456__$1;
(statearr_38522_38574[(1)] = (14));

} else {
var statearr_38523_38575 = state_38456__$1;
(statearr_38523_38575[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (18))){
var state_38456__$1 = state_38456;
var statearr_38524_38576 = state_38456__$1;
(statearr_38524_38576[(2)] = null);

(statearr_38524_38576[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38457 === (8))){
var inst_38354 = (state_38456[(7)]);
var inst_38359 = inst_38354.cljs$lang$protocol_mask$partition0$;
var inst_38360 = (inst_38359 & (64));
var inst_38361 = inst_38354.cljs$core$ISeq$;
var inst_38362 = (inst_38360) || (inst_38361);
var state_38456__$1 = state_38456;
if(cljs.core.truth_(inst_38362)){
var statearr_38525_38577 = state_38456__$1;
(statearr_38525_38577[(1)] = (11));

} else {
var statearr_38526_38578 = state_38456__$1;
(statearr_38526_38578[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto__,event_chan))
;
return ((function (switch__12171__auto__,c__12283__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12172__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12172__auto____0 = (function (){
var statearr_38530 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38530[(0)] = hatti$views$table$handle_table_events_$_state_machine__12172__auto__);

(statearr_38530[(1)] = (1));

return statearr_38530;
});
var hatti$views$table$handle_table_events_$_state_machine__12172__auto____1 = (function (state_38456){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_38456);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e38531){if((e38531 instanceof Object)){
var ex__12175__auto__ = e38531;
var statearr_38532_38579 = state_38456;
(statearr_38532_38579[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38456);

return cljs.core.cst$kw$recur;
} else {
throw e38531;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__38580 = state_38456;
state_38456 = G__38580;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12172__auto__ = function(state_38456){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12172__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12172__auto____1.call(this,state_38456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12172__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12172__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__,event_chan))
})();
var state__12285__auto__ = (function (){var statearr_38533 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_38533[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_38533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto__,event_chan))
);

return c__12283__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$field_DASH_key,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__38599(s__38600){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__38600__$1 = s__38600;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38600__$1);
if(temp__4657__auto__){
var s__38600__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38600__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38600__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38602 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38601 = (0);
while(true){
if((i__38601 < size__7188__auto__)){
var vec__38611 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38601);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38611,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38611,(1),null);
cljs.core.chunk_append(b__38602,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__38601,vec__38611,k,v,c__7187__auto__,size__7188__auto__,b__38602,s__38600__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__38601,vec__38611,k,v,c__7187__auto__,size__7188__auto__,b__38602,s__38600__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__38617 = (i__38601 + (1));
i__38601 = G__38617;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38602),hatti$views$table$render_options_$_iter__38599(cljs.core.chunk_rest(s__38600__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38602),null);
}
} else {
var vec__38614 = cljs.core.first(s__38600__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38614,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38614,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__38614,k,v,s__38600__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__38614,k,v,s__38600__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__38599(cljs.core.rest(s__38600__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table38619 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table38619 = (function (_,owner,meta38620){
this._ = _;
this.owner = owner;
this.meta38620 = meta38620;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table38619.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38621,meta38620__$1){
var self__ = this;
var _38621__$1 = this;
return (new hatti.views.table.t_hatti$views$table38619(self__._,self__.owner,meta38620__$1));
});

hatti.views.table.t_hatti$views$table38619.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38621){
var self__ = this;
var _38621__$1 = this;
return self__.meta38620;
});

hatti.views.table.t_hatti$views$table38619.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table38619.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field_DASH_key,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table38619.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table38619.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__38622){
var self__ = this;
var map__38623 = p__38622;
var map__38623__$1 = ((((!((map__38623 == null)))?((((map__38623.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38623.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38623):map__38623);
var field_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38623__$1,cljs.core.cst$kw$field_DASH_key);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38623__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__38625 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__38625__$1 = ((((!((map__38625 == null)))?((((map__38625.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38625.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38625):map__38625);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38625__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__38625,map__38625__$1,flat_form,new_language,___$2,map__38623,map__38623__$1,field_key,language){
return (function (p1__38618_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(flat_form,cljs.core.array_seq([cljs.core.cst$kw$get_DASH_label_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__38618_SHARP_),cljs.core.cst$kw$language,new_language,cljs.core.cst$kw$owner,self__.owner], 0))], null));
});})(options,map__38625,map__38625__$1,flat_form,new_language,___$2,map__38623,map__38623__$1,field_key,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(field_key);
} else {
}

var G__38635 = ({"className": "label-changer"});
var G__38636 = (function (){var G__38638 = ({"className": "label-changer-label"});
var G__38639 = "Show:";
return React.DOM.span(G__38638,G__38639);
})();
var G__38637 = (function (){var G__38640 = ({"id": "header-display-dropdown", "className": "drop-hover"});
var G__38641 = (function (){var attrs38629 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(field_key) : options.call(null,field_key));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs38629))?sablono.interpreter.attributes(attrs38629):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs38629))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__38643 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__38643);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs38629),(function (){var G__38644 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__38644);
})()], null))));
})();
var G__38642 = (function (){var attrs38634 = hatti.views.table.render_options(options,self__.owner,colset_BANG_);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.ul,((cljs.core.map_QMARK_(attrs38634))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs38634], 0))):({"className": "submenu no-dot"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs38634))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs38634)], null))));
})();
return React.DOM.div(G__38640,G__38641,G__38642);
})();
return React.DOM.div(G__38635,G__38636,G__38637);
});

hatti.views.table.t_hatti$views$table38619.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta38620], null);
});

hatti.views.table.t_hatti$views$table38619.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table38619.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table38619";

hatti.views.table.t_hatti$views$table38619.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table38619");
});

hatti.views.table.__GT_t_hatti$views$table38619 = (function hatti$views$table$__GT_t_hatti$views$table38619(___$1,owner__$1,meta38620){
return (new hatti.views.table.t_hatti$views$table38619(___$1,owner__$1,meta38620));
});

}

return (new hatti.views.table.t_hatti$views$table38619(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12283__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto__,query){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__,query){
return (function (state_38687){
var state_val_38688 = (state_38687[(1)]);
if((state_val_38688 === (1))){
var inst_38673 = cljs.core.async.timeout((150));
var state_38687__$1 = state_38687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38687__$1,(2),inst_38673);
} else {
if((state_val_38688 === (2))){
var inst_38675 = (state_38687[(2)]);
var inst_38676 = input.value;
var inst_38677 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_38676);
var state_38687__$1 = (function (){var statearr_38689 = state_38687;
(statearr_38689[(7)] = inst_38675);

return statearr_38689;
})();
if(inst_38677){
var statearr_38690_38701 = state_38687__$1;
(statearr_38690_38701[(1)] = (3));

} else {
var statearr_38691_38702 = state_38687__$1;
(statearr_38691_38702[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38688 === (3))){
var inst_38679 = [query_event_key];
var inst_38680 = [query];
var inst_38681 = cljs.core.PersistentHashMap.fromArrays(inst_38679,inst_38680);
var inst_38682 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_38681);
var state_38687__$1 = state_38687;
var statearr_38692_38703 = state_38687__$1;
(statearr_38692_38703[(2)] = inst_38682);

(statearr_38692_38703[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38688 === (4))){
var state_38687__$1 = state_38687;
var statearr_38693_38704 = state_38687__$1;
(statearr_38693_38704[(2)] = null);

(statearr_38693_38704[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38688 === (5))){
var inst_38685 = (state_38687[(2)]);
var state_38687__$1 = state_38687;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38687__$1,inst_38685);
} else {
return null;
}
}
}
}
}
});})(c__12283__auto__,query))
;
return ((function (switch__12171__auto__,c__12283__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12172__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12172__auto____0 = (function (){
var statearr_38697 = [null,null,null,null,null,null,null,null];
(statearr_38697[(0)] = hatti$views$table$delayed_search_$_state_machine__12172__auto__);

(statearr_38697[(1)] = (1));

return statearr_38697;
});
var hatti$views$table$delayed_search_$_state_machine__12172__auto____1 = (function (state_38687){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_38687);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e38698){if((e38698 instanceof Object)){
var ex__12175__auto__ = e38698;
var statearr_38699_38705 = state_38687;
(statearr_38699_38705[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38687);

return cljs.core.cst$kw$recur;
} else {
throw e38698;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__38706 = state_38687;
state_38687 = G__38706;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12172__auto__ = function(state_38687){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12172__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12172__auto____1.call(this,state_38687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12172__auto____0;
hatti$views$table$delayed_search_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12172__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__,query))
})();
var state__12285__auto__ = (function (){var statearr_38700 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_38700[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_38700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto__,query))
);

return c__12283__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table38708 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table38708 = (function (_,owner,meta38709){
this._ = _;
this.owner = owner;
this.meta38709 = meta38709;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table38708.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38710,meta38709__$1){
var self__ = this;
var _38710__$1 = this;
return (new hatti.views.table.t_hatti$views$table38708(self__._,self__.owner,meta38709__$1));
});

hatti.views.table.t_hatti$views$table38708.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38710){
var self__ = this;
var _38710__$1 = this;
return self__.meta38709;
});

hatti.views.table.t_hatti$views$table38708.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table38708.prototype.om$core$IRender$render$arity$1 = (function (this__18366__auto__){
var self__ = this;
var this__18366__auto____$1 = this;
var G__38713 = ({"className": "table-search"});
var G__38714 = (function (){var G__38716 = ({"className": "fa fa-search"});
return React.DOM.i(G__38716);
})();
var G__38715 = (function (){var G__38717 = ({"type": "text", "placeholder": "Search", "onChange": ((function (G__38713,G__38714,this__18366__auto____$1){
return (function (p1__38707_SHARP_){
return hatti.views.table.delayed_search(p1__38707_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__38713,G__38714,this__18366__auto____$1))
});
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__38717) : sablono.interpreter.input.call(null,G__38717));
})();
return React.DOM.div(G__38713,G__38714,G__38715);
});

hatti.views.table.t_hatti$views$table38708.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta38709], null);
});

hatti.views.table.t_hatti$views$table38708.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table38708.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table38708";

hatti.views.table.t_hatti$views$table38708.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table38708");
});

hatti.views.table.__GT_t_hatti$views$table38708 = (function hatti$views$table$__GT_t_hatti$views$table38708(___$1,owner__$1,meta38709){
return (new hatti.views.table.t_hatti$views$table38708(___$1,owner__$1,meta38709));
});

}

return (new hatti.views.table.t_hatti$views$table38708(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table38718 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table38718 = (function (cursor,owner,meta38719){
this.cursor = cursor;
this.owner = owner;
this.meta38719 = meta38719;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table38718.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38720,meta38719__$1){
var self__ = this;
var _38720__$1 = this;
return (new hatti.views.table.t_hatti$views$table38718(self__.cursor,self__.owner,meta38719__$1));
});

hatti.views.table.t_hatti$views$table38718.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38720){
var self__ = this;
var _38720__$1 = this;
return self__.meta38719;
});

hatti.views.table.t_hatti$views$table38718.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table38718.prototype.om$core$IRender$render$arity$1 = (function (this__18366__auto__){
var self__ = this;
var this__18366__auto____$1 = this;
var G__38723 = ({"className": "topbar"});
var G__38724 = (function (){var G__38728 = ({"id": hatti.views.table.pager_id});
return React.DOM.div(G__38728);
})();
var G__38725 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,self__.cursor));
var G__38726 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.cursor));
var G__38727 = (function (){var G__38729 = ({"style": ({"clear": "both"})});
return React.DOM.div(G__38729);
})();
return React.DOM.div(G__38723,G__38724,G__38725,G__38726,G__38727);
});

hatti.views.table.t_hatti$views$table38718.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta38719], null);
});

hatti.views.table.t_hatti$views$table38718.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table38718.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table38718";

hatti.views.table.t_hatti$views$table38718.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table38718");
});

hatti.views.table.__GT_t_hatti$views$table38718 = (function hatti$views$table$__GT_t_hatti$views$table38718(cursor__$1,owner__$1,meta38719){
return (new hatti.views.table.t_hatti$views$table38718(cursor__$1,owner__$1,meta38719));
});

}

return (new hatti.views.table.t_hatti$views$table38718(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq(data)){
var map__38735 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__38735__$1 = ((((!((map__38735 == null)))?((((map__38735.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38735.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38735):map__38735);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38735__$1,cljs.core.cst$kw$flat_DASH_form);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__38736 = hatti.views.table.sg_init(data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38736,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38736,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".table-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$table_DASH_view_DASH_height,hatti.views.table.get_table_view_height());
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$resize_DASH_handler,resize_handler);
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__38741,owner,p__38742){
var map__38743 = p__38741;
var map__38743__$1 = ((((!((map__38743 == null)))?((((map__38743.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38743.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38743):map__38743);
var cursor = map__38743__$1;
var map__38744 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38743__$1,cljs.core.cst$kw$views);
var map__38744__$1 = ((((!((map__38744 == null)))?((((map__38744.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38744.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38744):map__38744);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38744__$1,cljs.core.cst$kw$active);
var map__38745 = p__38742;
var map__38745__$1 = ((((!((map__38745 == null)))?((((map__38745.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38745.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38745):map__38745);
var opts = map__38745__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38745__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

var active_QMARK_ = chimera.seq.in_QMARK_(active,cljs.core.cst$kw$table);
if(typeof hatti.views.table.t_hatti$views$table38749 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table38749 = (function (map__38744,owner,p__38742,active_QMARK_,map__38745,p__38741,slick_grid_event_handlers,map__38743,cursor,active,opts,meta38750){
this.map__38744 = map__38744;
this.owner = owner;
this.p__38742 = p__38742;
this.active_QMARK_ = active_QMARK_;
this.map__38745 = map__38745;
this.p__38741 = p__38741;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.map__38743 = map__38743;
this.cursor = cursor;
this.active = active;
this.opts = opts;
this.meta38750 = meta38750;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table38749.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers){
return (function (_38751,meta38750__$1){
var self__ = this;
var _38751__$1 = this;
return (new hatti.views.table.t_hatti$views$table38749(self__.map__38744,self__.owner,self__.p__38742,self__.active_QMARK_,self__.map__38745,self__.p__38741,self__.slick_grid_event_handlers,self__.map__38743,self__.cursor,self__.active,self__.opts,meta38750__$1));
});})(active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table38749.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers){
return (function (_38751){
var self__ = this;
var _38751__$1 = this;
return self__.meta38750;
});})(active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table38749.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table38749.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers){
return (function (_,p__38752){
var self__ = this;
var map__38753 = p__38752;
var map__38753__$1 = ((((!((map__38753 == null)))?((((map__38753.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38753.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38753):map__38753);
var table_view_height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38753__$1,cljs.core.cst$kw$table_DASH_view_DASH_height);
var ___$1 = this;
var map__38755 = self__.cursor;
var map__38755__$1 = ((((!((map__38755 == null)))?((((map__38755.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38755.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38755):map__38755);
var map__38756 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38755__$1,cljs.core.cst$kw$table_DASH_page);
var map__38756__$1 = ((((!((map__38756 == null)))?((((map__38756.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38756.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38756):map__38756);
var submission_clicked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38756__$1,cljs.core.cst$kw$submission_DASH_clicked);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38755__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38755__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__38757 = dataset_info;
var map__38757__$1 = ((((!((map__38757 == null)))?((((map__38757.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38757.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38757):map__38757);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38757__$1,cljs.core.cst$kw$num_of_submissions);
var no_data_QMARK_ = cljs.core.empty_QMARK_(data);
var with_info = ((function (map__38755,map__38755__$1,map__38756,map__38756__$1,submission_clicked,data,dataset_info,map__38757,map__38757__$1,num_of_submissions,no_data_QMARK_,___$1,map__38753,map__38753__$1,table_view_height,active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers){
return (function (p1__38740_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.cursor,p1__38740_SHARP_], 0));
});})(map__38755,map__38755__$1,map__38756,map__38756__$1,submission_clicked,data,dataset_info,map__38757,map__38757__$1,num_of_submissions,no_data_QMARK_,___$1,map__38753,map__38753__$1,table_view_height,active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers))
;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(hatti.shared.app_state,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$table_DASH_view_DASH_height], null),(((document.querySelector(".table-page") == null))?null:hatti.views.table.get_table_view_height()));

if(cljs.core.truth_(self__.active_QMARK_)){
var G__38761 = ({"style": ({"overflow": "initial"}), "className": "table-view"});
var G__38762 = sablono.interpreter.interpret((cljs.core.truth_(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null)):null));
var G__38763 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.cursor));
var G__38764 = (function (){var G__38765 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__38766 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__38771 = ({"className": "alert alert-warning"});
var G__38772 = "No data";
return React.DOM.p(G__38771,G__38772);
})():(function (){var G__38773 = null;
var G__38774 = (function (){var G__38776 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__38776);
})();
var G__38775 = "Loading...";
return React.DOM.span(G__38773,G__38774,G__38775);
})());
return React.DOM.div(G__38765,G__38766);
})();
return React.DOM.div(G__38761,G__38762,G__38763,G__38764);
} else {
return null;
}
});})(active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table38749.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table38749.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler(self__.owner);

var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__38777 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38777,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38777,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table38749.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table38749.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$resize_DASH_handler));
});})(active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table38749.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table38749.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__38780 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__38780__$1 = ((((!((map__38780 == null)))?((((map__38780.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38780.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38780):map__38780);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38780__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38780__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__38782 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38782,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38782,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js((function (){var G__38785 = new_data;
if(cljs.core.truth_(cljs.core.cst$kw$submission_DASH_review_QMARK_.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))))){
return hatti.views.table.replace_review_num_status_with_text_status(G__38785);
} else {
return G__38785;
}
})()),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table38749.getBasis = ((function (active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$map__38744,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__38742,cljs.core.cst$sym$active_QMARK_,cljs.core.cst$sym$map__38745,cljs.core.cst$sym$p__38741,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$map__38743,cljs.core.cst$sym$cursor,cljs.core.cst$sym$active,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta38750], null);
});})(active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table38749.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table38749.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table38749";

hatti.views.table.t_hatti$views$table38749.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table38749");
});})(active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table38749 = ((function (active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table38749(map__38744__$2,owner__$1,p__38742__$1,active_QMARK___$1,map__38745__$2,p__38741__$1,slick_grid_event_handlers__$1,map__38743__$2,cursor__$1,active__$1,opts__$1,meta38750){
return (new hatti.views.table.t_hatti$views$table38749(map__38744__$2,owner__$1,p__38742__$1,active_QMARK___$1,map__38745__$2,p__38741__$1,slick_grid_event_handlers__$1,map__38743__$2,cursor__$1,active__$1,opts__$1,meta38750));
});})(active_QMARK_,map__38743,map__38743__$1,cursor,map__38744,map__38744__$1,active,map__38745,map__38745__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table38749(map__38744__$1,owner,p__38742,active_QMARK_,map__38745__$1,p__38741,slick_grid_event_handlers,map__38743__$1,cursor,active,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
