// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args12328 = [];
var len__7484__auto___12334 = arguments.length;
var i__7485__auto___12335 = (0);
while(true){
if((i__7485__auto___12335 < len__7484__auto___12334)){
args12328.push((arguments[i__7485__auto___12335]));

var G__12336 = (i__7485__auto___12335 + (1));
i__7485__auto___12335 = G__12336;
continue;
} else {
}
break;
}

var G__12330 = args12328.length;
switch (G__12330) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12328.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async12331 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12331 = (function (f,blockable,meta12332){
this.f = f;
this.blockable = blockable;
this.meta12332 = meta12332;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12333,meta12332__$1){
var self__ = this;
var _12333__$1 = this;
return (new cljs.core.async.t_cljs$core$async12331(self__.f,self__.blockable,meta12332__$1));
});

cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12333){
var self__ = this;
var _12333__$1 = this;
return self__.meta12332;
});

cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async12331.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta12332","meta12332",-1712896917,null)], null);
});

cljs.core.async.t_cljs$core$async12331.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12331.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12331";

cljs.core.async.t_cljs$core$async12331.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12331");
});

cljs.core.async.__GT_t_cljs$core$async12331 = (function cljs$core$async$__GT_t_cljs$core$async12331(f__$1,blockable__$1,meta12332){
return (new cljs.core.async.t_cljs$core$async12331(f__$1,blockable__$1,meta12332));
});

}

return (new cljs.core.async.t_cljs$core$async12331(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args12340 = [];
var len__7484__auto___12343 = arguments.length;
var i__7485__auto___12344 = (0);
while(true){
if((i__7485__auto___12344 < len__7484__auto___12343)){
args12340.push((arguments[i__7485__auto___12344]));

var G__12345 = (i__7485__auto___12344 + (1));
i__7485__auto___12344 = G__12345;
continue;
} else {
}
break;
}

var G__12342 = args12340.length;
switch (G__12342) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12340.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args12347 = [];
var len__7484__auto___12350 = arguments.length;
var i__7485__auto___12351 = (0);
while(true){
if((i__7485__auto___12351 < len__7484__auto___12350)){
args12347.push((arguments[i__7485__auto___12351]));

var G__12352 = (i__7485__auto___12351 + (1));
i__7485__auto___12351 = G__12352;
continue;
} else {
}
break;
}

var G__12349 = args12347.length;
switch (G__12349) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12347.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args12354 = [];
var len__7484__auto___12357 = arguments.length;
var i__7485__auto___12358 = (0);
while(true){
if((i__7485__auto___12358 < len__7484__auto___12357)){
args12354.push((arguments[i__7485__auto___12358]));

var G__12359 = (i__7485__auto___12358 + (1));
i__7485__auto___12358 = G__12359;
continue;
} else {
}
break;
}

var G__12356 = args12354.length;
switch (G__12356) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12354.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_12361 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_12361);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_12361,ret){
return (function (){
return fn1.call(null,val_12361);
});})(val_12361,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args12362 = [];
var len__7484__auto___12365 = arguments.length;
var i__7485__auto___12366 = (0);
while(true){
if((i__7485__auto___12366 < len__7484__auto___12365)){
args12362.push((arguments[i__7485__auto___12366]));

var G__12367 = (i__7485__auto___12366 + (1));
i__7485__auto___12366 = G__12367;
continue;
} else {
}
break;
}

var G__12364 = args12362.length;
switch (G__12364) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12362.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___12369 = n;
var x_12370 = (0);
while(true){
if((x_12370 < n__7324__auto___12369)){
(a[x_12370] = (0));

var G__12371 = (x_12370 + (1));
x_12370 = G__12371;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__12372 = (i + (1));
i = G__12372;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async12376 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12376 = (function (alt_flag,flag,meta12377){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta12377 = meta12377;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12376.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_12378,meta12377__$1){
var self__ = this;
var _12378__$1 = this;
return (new cljs.core.async.t_cljs$core$async12376(self__.alt_flag,self__.flag,meta12377__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async12376.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_12378){
var self__ = this;
var _12378__$1 = this;
return self__.meta12377;
});})(flag))
;

cljs.core.async.t_cljs$core$async12376.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12376.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async12376.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async12376.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async12376.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta12377","meta12377",1010755319,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async12376.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12376.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12376";

cljs.core.async.t_cljs$core$async12376.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12376");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async12376 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async12376(alt_flag__$1,flag__$1,meta12377){
return (new cljs.core.async.t_cljs$core$async12376(alt_flag__$1,flag__$1,meta12377));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async12376(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async12382 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12382 = (function (alt_handler,flag,cb,meta12383){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta12383 = meta12383;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12382.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12384,meta12383__$1){
var self__ = this;
var _12384__$1 = this;
return (new cljs.core.async.t_cljs$core$async12382(self__.alt_handler,self__.flag,self__.cb,meta12383__$1));
});

cljs.core.async.t_cljs$core$async12382.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12384){
var self__ = this;
var _12384__$1 = this;
return self__.meta12383;
});

cljs.core.async.t_cljs$core$async12382.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12382.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async12382.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async12382.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async12382.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta12383","meta12383",264447517,null)], null);
});

cljs.core.async.t_cljs$core$async12382.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12382.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12382";

cljs.core.async.t_cljs$core$async12382.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12382");
});

cljs.core.async.__GT_t_cljs$core$async12382 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async12382(alt_handler__$1,flag__$1,cb__$1,meta12383){
return (new cljs.core.async.t_cljs$core$async12382(alt_handler__$1,flag__$1,cb__$1,meta12383));
});

}

return (new cljs.core.async.t_cljs$core$async12382(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12385_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12385_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12386_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12386_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__12387 = (i + (1));
i = G__12387;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___12393 = arguments.length;
var i__7485__auto___12394 = (0);
while(true){
if((i__7485__auto___12394 < len__7484__auto___12393)){
args__7491__auto__.push((arguments[i__7485__auto___12394]));

var G__12395 = (i__7485__auto___12394 + (1));
i__7485__auto___12394 = G__12395;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__12390){
var map__12391 = p__12390;
var map__12391__$1 = ((((!((map__12391 == null)))?((((map__12391.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12391.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12391):map__12391);
var opts = map__12391__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq12388){
var G__12389 = cljs.core.first.call(null,seq12388);
var seq12388__$1 = cljs.core.next.call(null,seq12388);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12389,seq12388__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args12396 = [];
var len__7484__auto___12446 = arguments.length;
var i__7485__auto___12447 = (0);
while(true){
if((i__7485__auto___12447 < len__7484__auto___12446)){
args12396.push((arguments[i__7485__auto___12447]));

var G__12448 = (i__7485__auto___12447 + (1));
i__7485__auto___12447 = G__12448;
continue;
} else {
}
break;
}

var G__12398 = args12396.length;
switch (G__12398) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12396.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12283__auto___12450 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto___12450){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___12450){
return (function (state_12422){
var state_val_12423 = (state_12422[(1)]);
if((state_val_12423 === (7))){
var inst_12418 = (state_12422[(2)]);
var state_12422__$1 = state_12422;
var statearr_12424_12451 = state_12422__$1;
(statearr_12424_12451[(2)] = inst_12418);

(statearr_12424_12451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12423 === (1))){
var state_12422__$1 = state_12422;
var statearr_12425_12452 = state_12422__$1;
(statearr_12425_12452[(2)] = null);

(statearr_12425_12452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12423 === (4))){
var inst_12401 = (state_12422[(7)]);
var inst_12401__$1 = (state_12422[(2)]);
var inst_12402 = (inst_12401__$1 == null);
var state_12422__$1 = (function (){var statearr_12426 = state_12422;
(statearr_12426[(7)] = inst_12401__$1);

return statearr_12426;
})();
if(cljs.core.truth_(inst_12402)){
var statearr_12427_12453 = state_12422__$1;
(statearr_12427_12453[(1)] = (5));

} else {
var statearr_12428_12454 = state_12422__$1;
(statearr_12428_12454[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12423 === (13))){
var state_12422__$1 = state_12422;
var statearr_12429_12455 = state_12422__$1;
(statearr_12429_12455[(2)] = null);

(statearr_12429_12455[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12423 === (6))){
var inst_12401 = (state_12422[(7)]);
var state_12422__$1 = state_12422;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12422__$1,(11),to,inst_12401);
} else {
if((state_val_12423 === (3))){
var inst_12420 = (state_12422[(2)]);
var state_12422__$1 = state_12422;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12422__$1,inst_12420);
} else {
if((state_val_12423 === (12))){
var state_12422__$1 = state_12422;
var statearr_12430_12456 = state_12422__$1;
(statearr_12430_12456[(2)] = null);

(statearr_12430_12456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12423 === (2))){
var state_12422__$1 = state_12422;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12422__$1,(4),from);
} else {
if((state_val_12423 === (11))){
var inst_12411 = (state_12422[(2)]);
var state_12422__$1 = state_12422;
if(cljs.core.truth_(inst_12411)){
var statearr_12431_12457 = state_12422__$1;
(statearr_12431_12457[(1)] = (12));

} else {
var statearr_12432_12458 = state_12422__$1;
(statearr_12432_12458[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12423 === (9))){
var state_12422__$1 = state_12422;
var statearr_12433_12459 = state_12422__$1;
(statearr_12433_12459[(2)] = null);

(statearr_12433_12459[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12423 === (5))){
var state_12422__$1 = state_12422;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12434_12460 = state_12422__$1;
(statearr_12434_12460[(1)] = (8));

} else {
var statearr_12435_12461 = state_12422__$1;
(statearr_12435_12461[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12423 === (14))){
var inst_12416 = (state_12422[(2)]);
var state_12422__$1 = state_12422;
var statearr_12436_12462 = state_12422__$1;
(statearr_12436_12462[(2)] = inst_12416);

(statearr_12436_12462[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12423 === (10))){
var inst_12408 = (state_12422[(2)]);
var state_12422__$1 = state_12422;
var statearr_12437_12463 = state_12422__$1;
(statearr_12437_12463[(2)] = inst_12408);

(statearr_12437_12463[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12423 === (8))){
var inst_12405 = cljs.core.async.close_BANG_.call(null,to);
var state_12422__$1 = state_12422;
var statearr_12438_12464 = state_12422__$1;
(statearr_12438_12464[(2)] = inst_12405);

(statearr_12438_12464[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___12450))
;
return ((function (switch__12171__auto__,c__12283__auto___12450){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_12442 = [null,null,null,null,null,null,null,null];
(statearr_12442[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_12442[(1)] = (1));

return statearr_12442;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_12422){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_12422);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e12443){if((e12443 instanceof Object)){
var ex__12175__auto__ = e12443;
var statearr_12444_12465 = state_12422;
(statearr_12444_12465[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12422);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12443;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12466 = state_12422;
state_12422 = G__12466;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_12422){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_12422);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___12450))
})();
var state__12285__auto__ = (function (){var statearr_12445 = f__12284__auto__.call(null);
(statearr_12445[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___12450);

return statearr_12445;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto___12450))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__12654){
var vec__12655 = p__12654;
var v = cljs.core.nth.call(null,vec__12655,(0),null);
var p = cljs.core.nth.call(null,vec__12655,(1),null);
var job = vec__12655;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__12283__auto___12841 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto___12841,res,vec__12655,v,p,job,jobs,results){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___12841,res,vec__12655,v,p,job,jobs,results){
return (function (state_12662){
var state_val_12663 = (state_12662[(1)]);
if((state_val_12663 === (1))){
var state_12662__$1 = state_12662;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12662__$1,(2),res,v);
} else {
if((state_val_12663 === (2))){
var inst_12659 = (state_12662[(2)]);
var inst_12660 = cljs.core.async.close_BANG_.call(null,res);
var state_12662__$1 = (function (){var statearr_12664 = state_12662;
(statearr_12664[(7)] = inst_12659);

return statearr_12664;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12662__$1,inst_12660);
} else {
return null;
}
}
});})(c__12283__auto___12841,res,vec__12655,v,p,job,jobs,results))
;
return ((function (switch__12171__auto__,c__12283__auto___12841,res,vec__12655,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0 = (function (){
var statearr_12668 = [null,null,null,null,null,null,null,null];
(statearr_12668[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__);

(statearr_12668[(1)] = (1));

return statearr_12668;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1 = (function (state_12662){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_12662);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e12669){if((e12669 instanceof Object)){
var ex__12175__auto__ = e12669;
var statearr_12670_12842 = state_12662;
(statearr_12670_12842[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12662);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12669;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12843 = state_12662;
state_12662 = G__12843;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = function(state_12662){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1.call(this,state_12662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___12841,res,vec__12655,v,p,job,jobs,results))
})();
var state__12285__auto__ = (function (){var statearr_12671 = f__12284__auto__.call(null);
(statearr_12671[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___12841);

return statearr_12671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto___12841,res,vec__12655,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__12672){
var vec__12673 = p__12672;
var v = cljs.core.nth.call(null,vec__12673,(0),null);
var p = cljs.core.nth.call(null,vec__12673,(1),null);
var job = vec__12673;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___12844 = n;
var __12845 = (0);
while(true){
if((__12845 < n__7324__auto___12844)){
var G__12676_12846 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__12676_12846) {
case "compute":
var c__12283__auto___12848 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12845,c__12283__auto___12848,G__12676_12846,n__7324__auto___12844,jobs,results,process,async){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (__12845,c__12283__auto___12848,G__12676_12846,n__7324__auto___12844,jobs,results,process,async){
return (function (state_12689){
var state_val_12690 = (state_12689[(1)]);
if((state_val_12690 === (1))){
var state_12689__$1 = state_12689;
var statearr_12691_12849 = state_12689__$1;
(statearr_12691_12849[(2)] = null);

(statearr_12691_12849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12690 === (2))){
var state_12689__$1 = state_12689;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12689__$1,(4),jobs);
} else {
if((state_val_12690 === (3))){
var inst_12687 = (state_12689[(2)]);
var state_12689__$1 = state_12689;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12689__$1,inst_12687);
} else {
if((state_val_12690 === (4))){
var inst_12679 = (state_12689[(2)]);
var inst_12680 = process.call(null,inst_12679);
var state_12689__$1 = state_12689;
if(cljs.core.truth_(inst_12680)){
var statearr_12692_12850 = state_12689__$1;
(statearr_12692_12850[(1)] = (5));

} else {
var statearr_12693_12851 = state_12689__$1;
(statearr_12693_12851[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12690 === (5))){
var state_12689__$1 = state_12689;
var statearr_12694_12852 = state_12689__$1;
(statearr_12694_12852[(2)] = null);

(statearr_12694_12852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12690 === (6))){
var state_12689__$1 = state_12689;
var statearr_12695_12853 = state_12689__$1;
(statearr_12695_12853[(2)] = null);

(statearr_12695_12853[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12690 === (7))){
var inst_12685 = (state_12689[(2)]);
var state_12689__$1 = state_12689;
var statearr_12696_12854 = state_12689__$1;
(statearr_12696_12854[(2)] = inst_12685);

(statearr_12696_12854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12845,c__12283__auto___12848,G__12676_12846,n__7324__auto___12844,jobs,results,process,async))
;
return ((function (__12845,switch__12171__auto__,c__12283__auto___12848,G__12676_12846,n__7324__auto___12844,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0 = (function (){
var statearr_12700 = [null,null,null,null,null,null,null];
(statearr_12700[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__);

(statearr_12700[(1)] = (1));

return statearr_12700;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1 = (function (state_12689){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_12689);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e12701){if((e12701 instanceof Object)){
var ex__12175__auto__ = e12701;
var statearr_12702_12855 = state_12689;
(statearr_12702_12855[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12689);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12701;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12856 = state_12689;
state_12689 = G__12856;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = function(state_12689){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1.call(this,state_12689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__;
})()
;})(__12845,switch__12171__auto__,c__12283__auto___12848,G__12676_12846,n__7324__auto___12844,jobs,results,process,async))
})();
var state__12285__auto__ = (function (){var statearr_12703 = f__12284__auto__.call(null);
(statearr_12703[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___12848);

return statearr_12703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(__12845,c__12283__auto___12848,G__12676_12846,n__7324__auto___12844,jobs,results,process,async))
);


break;
case "async":
var c__12283__auto___12857 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12845,c__12283__auto___12857,G__12676_12846,n__7324__auto___12844,jobs,results,process,async){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (__12845,c__12283__auto___12857,G__12676_12846,n__7324__auto___12844,jobs,results,process,async){
return (function (state_12716){
var state_val_12717 = (state_12716[(1)]);
if((state_val_12717 === (1))){
var state_12716__$1 = state_12716;
var statearr_12718_12858 = state_12716__$1;
(statearr_12718_12858[(2)] = null);

(statearr_12718_12858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12717 === (2))){
var state_12716__$1 = state_12716;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12716__$1,(4),jobs);
} else {
if((state_val_12717 === (3))){
var inst_12714 = (state_12716[(2)]);
var state_12716__$1 = state_12716;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12716__$1,inst_12714);
} else {
if((state_val_12717 === (4))){
var inst_12706 = (state_12716[(2)]);
var inst_12707 = async.call(null,inst_12706);
var state_12716__$1 = state_12716;
if(cljs.core.truth_(inst_12707)){
var statearr_12719_12859 = state_12716__$1;
(statearr_12719_12859[(1)] = (5));

} else {
var statearr_12720_12860 = state_12716__$1;
(statearr_12720_12860[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12717 === (5))){
var state_12716__$1 = state_12716;
var statearr_12721_12861 = state_12716__$1;
(statearr_12721_12861[(2)] = null);

(statearr_12721_12861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12717 === (6))){
var state_12716__$1 = state_12716;
var statearr_12722_12862 = state_12716__$1;
(statearr_12722_12862[(2)] = null);

(statearr_12722_12862[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12717 === (7))){
var inst_12712 = (state_12716[(2)]);
var state_12716__$1 = state_12716;
var statearr_12723_12863 = state_12716__$1;
(statearr_12723_12863[(2)] = inst_12712);

(statearr_12723_12863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12845,c__12283__auto___12857,G__12676_12846,n__7324__auto___12844,jobs,results,process,async))
;
return ((function (__12845,switch__12171__auto__,c__12283__auto___12857,G__12676_12846,n__7324__auto___12844,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0 = (function (){
var statearr_12727 = [null,null,null,null,null,null,null];
(statearr_12727[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__);

(statearr_12727[(1)] = (1));

return statearr_12727;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1 = (function (state_12716){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_12716);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e12728){if((e12728 instanceof Object)){
var ex__12175__auto__ = e12728;
var statearr_12729_12864 = state_12716;
(statearr_12729_12864[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12716);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12728;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12865 = state_12716;
state_12716 = G__12865;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = function(state_12716){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1.call(this,state_12716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__;
})()
;})(__12845,switch__12171__auto__,c__12283__auto___12857,G__12676_12846,n__7324__auto___12844,jobs,results,process,async))
})();
var state__12285__auto__ = (function (){var statearr_12730 = f__12284__auto__.call(null);
(statearr_12730[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___12857);

return statearr_12730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(__12845,c__12283__auto___12857,G__12676_12846,n__7324__auto___12844,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__12866 = (__12845 + (1));
__12845 = G__12866;
continue;
} else {
}
break;
}

var c__12283__auto___12867 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto___12867,jobs,results,process,async){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___12867,jobs,results,process,async){
return (function (state_12752){
var state_val_12753 = (state_12752[(1)]);
if((state_val_12753 === (1))){
var state_12752__$1 = state_12752;
var statearr_12754_12868 = state_12752__$1;
(statearr_12754_12868[(2)] = null);

(statearr_12754_12868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12753 === (2))){
var state_12752__$1 = state_12752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12752__$1,(4),from);
} else {
if((state_val_12753 === (3))){
var inst_12750 = (state_12752[(2)]);
var state_12752__$1 = state_12752;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12752__$1,inst_12750);
} else {
if((state_val_12753 === (4))){
var inst_12733 = (state_12752[(7)]);
var inst_12733__$1 = (state_12752[(2)]);
var inst_12734 = (inst_12733__$1 == null);
var state_12752__$1 = (function (){var statearr_12755 = state_12752;
(statearr_12755[(7)] = inst_12733__$1);

return statearr_12755;
})();
if(cljs.core.truth_(inst_12734)){
var statearr_12756_12869 = state_12752__$1;
(statearr_12756_12869[(1)] = (5));

} else {
var statearr_12757_12870 = state_12752__$1;
(statearr_12757_12870[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12753 === (5))){
var inst_12736 = cljs.core.async.close_BANG_.call(null,jobs);
var state_12752__$1 = state_12752;
var statearr_12758_12871 = state_12752__$1;
(statearr_12758_12871[(2)] = inst_12736);

(statearr_12758_12871[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12753 === (6))){
var inst_12738 = (state_12752[(8)]);
var inst_12733 = (state_12752[(7)]);
var inst_12738__$1 = cljs.core.async.chan.call(null,(1));
var inst_12739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12740 = [inst_12733,inst_12738__$1];
var inst_12741 = (new cljs.core.PersistentVector(null,2,(5),inst_12739,inst_12740,null));
var state_12752__$1 = (function (){var statearr_12759 = state_12752;
(statearr_12759[(8)] = inst_12738__$1);

return statearr_12759;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12752__$1,(8),jobs,inst_12741);
} else {
if((state_val_12753 === (7))){
var inst_12748 = (state_12752[(2)]);
var state_12752__$1 = state_12752;
var statearr_12760_12872 = state_12752__$1;
(statearr_12760_12872[(2)] = inst_12748);

(statearr_12760_12872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12753 === (8))){
var inst_12738 = (state_12752[(8)]);
var inst_12743 = (state_12752[(2)]);
var state_12752__$1 = (function (){var statearr_12761 = state_12752;
(statearr_12761[(9)] = inst_12743);

return statearr_12761;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12752__$1,(9),results,inst_12738);
} else {
if((state_val_12753 === (9))){
var inst_12745 = (state_12752[(2)]);
var state_12752__$1 = (function (){var statearr_12762 = state_12752;
(statearr_12762[(10)] = inst_12745);

return statearr_12762;
})();
var statearr_12763_12873 = state_12752__$1;
(statearr_12763_12873[(2)] = null);

(statearr_12763_12873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___12867,jobs,results,process,async))
;
return ((function (switch__12171__auto__,c__12283__auto___12867,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0 = (function (){
var statearr_12767 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12767[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__);

(statearr_12767[(1)] = (1));

return statearr_12767;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1 = (function (state_12752){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_12752);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e12768){if((e12768 instanceof Object)){
var ex__12175__auto__ = e12768;
var statearr_12769_12874 = state_12752;
(statearr_12769_12874[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12752);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12768;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12875 = state_12752;
state_12752 = G__12875;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = function(state_12752){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1.call(this,state_12752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___12867,jobs,results,process,async))
})();
var state__12285__auto__ = (function (){var statearr_12770 = f__12284__auto__.call(null);
(statearr_12770[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___12867);

return statearr_12770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto___12867,jobs,results,process,async))
);


var c__12283__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto__,jobs,results,process,async){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__,jobs,results,process,async){
return (function (state_12808){
var state_val_12809 = (state_12808[(1)]);
if((state_val_12809 === (7))){
var inst_12804 = (state_12808[(2)]);
var state_12808__$1 = state_12808;
var statearr_12810_12876 = state_12808__$1;
(statearr_12810_12876[(2)] = inst_12804);

(statearr_12810_12876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (20))){
var state_12808__$1 = state_12808;
var statearr_12811_12877 = state_12808__$1;
(statearr_12811_12877[(2)] = null);

(statearr_12811_12877[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (1))){
var state_12808__$1 = state_12808;
var statearr_12812_12878 = state_12808__$1;
(statearr_12812_12878[(2)] = null);

(statearr_12812_12878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (4))){
var inst_12773 = (state_12808[(7)]);
var inst_12773__$1 = (state_12808[(2)]);
var inst_12774 = (inst_12773__$1 == null);
var state_12808__$1 = (function (){var statearr_12813 = state_12808;
(statearr_12813[(7)] = inst_12773__$1);

return statearr_12813;
})();
if(cljs.core.truth_(inst_12774)){
var statearr_12814_12879 = state_12808__$1;
(statearr_12814_12879[(1)] = (5));

} else {
var statearr_12815_12880 = state_12808__$1;
(statearr_12815_12880[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (15))){
var inst_12786 = (state_12808[(8)]);
var state_12808__$1 = state_12808;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12808__$1,(18),to,inst_12786);
} else {
if((state_val_12809 === (21))){
var inst_12799 = (state_12808[(2)]);
var state_12808__$1 = state_12808;
var statearr_12816_12881 = state_12808__$1;
(statearr_12816_12881[(2)] = inst_12799);

(statearr_12816_12881[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (13))){
var inst_12801 = (state_12808[(2)]);
var state_12808__$1 = (function (){var statearr_12817 = state_12808;
(statearr_12817[(9)] = inst_12801);

return statearr_12817;
})();
var statearr_12818_12882 = state_12808__$1;
(statearr_12818_12882[(2)] = null);

(statearr_12818_12882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (6))){
var inst_12773 = (state_12808[(7)]);
var state_12808__$1 = state_12808;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12808__$1,(11),inst_12773);
} else {
if((state_val_12809 === (17))){
var inst_12794 = (state_12808[(2)]);
var state_12808__$1 = state_12808;
if(cljs.core.truth_(inst_12794)){
var statearr_12819_12883 = state_12808__$1;
(statearr_12819_12883[(1)] = (19));

} else {
var statearr_12820_12884 = state_12808__$1;
(statearr_12820_12884[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (3))){
var inst_12806 = (state_12808[(2)]);
var state_12808__$1 = state_12808;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12808__$1,inst_12806);
} else {
if((state_val_12809 === (12))){
var inst_12783 = (state_12808[(10)]);
var state_12808__$1 = state_12808;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12808__$1,(14),inst_12783);
} else {
if((state_val_12809 === (2))){
var state_12808__$1 = state_12808;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12808__$1,(4),results);
} else {
if((state_val_12809 === (19))){
var state_12808__$1 = state_12808;
var statearr_12821_12885 = state_12808__$1;
(statearr_12821_12885[(2)] = null);

(statearr_12821_12885[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (11))){
var inst_12783 = (state_12808[(2)]);
var state_12808__$1 = (function (){var statearr_12822 = state_12808;
(statearr_12822[(10)] = inst_12783);

return statearr_12822;
})();
var statearr_12823_12886 = state_12808__$1;
(statearr_12823_12886[(2)] = null);

(statearr_12823_12886[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (9))){
var state_12808__$1 = state_12808;
var statearr_12824_12887 = state_12808__$1;
(statearr_12824_12887[(2)] = null);

(statearr_12824_12887[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (5))){
var state_12808__$1 = state_12808;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12825_12888 = state_12808__$1;
(statearr_12825_12888[(1)] = (8));

} else {
var statearr_12826_12889 = state_12808__$1;
(statearr_12826_12889[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (14))){
var inst_12786 = (state_12808[(8)]);
var inst_12788 = (state_12808[(11)]);
var inst_12786__$1 = (state_12808[(2)]);
var inst_12787 = (inst_12786__$1 == null);
var inst_12788__$1 = cljs.core.not.call(null,inst_12787);
var state_12808__$1 = (function (){var statearr_12827 = state_12808;
(statearr_12827[(8)] = inst_12786__$1);

(statearr_12827[(11)] = inst_12788__$1);

return statearr_12827;
})();
if(inst_12788__$1){
var statearr_12828_12890 = state_12808__$1;
(statearr_12828_12890[(1)] = (15));

} else {
var statearr_12829_12891 = state_12808__$1;
(statearr_12829_12891[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (16))){
var inst_12788 = (state_12808[(11)]);
var state_12808__$1 = state_12808;
var statearr_12830_12892 = state_12808__$1;
(statearr_12830_12892[(2)] = inst_12788);

(statearr_12830_12892[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (10))){
var inst_12780 = (state_12808[(2)]);
var state_12808__$1 = state_12808;
var statearr_12831_12893 = state_12808__$1;
(statearr_12831_12893[(2)] = inst_12780);

(statearr_12831_12893[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (18))){
var inst_12791 = (state_12808[(2)]);
var state_12808__$1 = state_12808;
var statearr_12832_12894 = state_12808__$1;
(statearr_12832_12894[(2)] = inst_12791);

(statearr_12832_12894[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12809 === (8))){
var inst_12777 = cljs.core.async.close_BANG_.call(null,to);
var state_12808__$1 = state_12808;
var statearr_12833_12895 = state_12808__$1;
(statearr_12833_12895[(2)] = inst_12777);

(statearr_12833_12895[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto__,jobs,results,process,async))
;
return ((function (switch__12171__auto__,c__12283__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0 = (function (){
var statearr_12837 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12837[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__);

(statearr_12837[(1)] = (1));

return statearr_12837;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1 = (function (state_12808){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_12808);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e12838){if((e12838 instanceof Object)){
var ex__12175__auto__ = e12838;
var statearr_12839_12896 = state_12808;
(statearr_12839_12896[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12808);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12838;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12897 = state_12808;
state_12808 = G__12897;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = function(state_12808){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1.call(this,state_12808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__,jobs,results,process,async))
})();
var state__12285__auto__ = (function (){var statearr_12840 = f__12284__auto__.call(null);
(statearr_12840[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_12840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto__,jobs,results,process,async))
);

return c__12283__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args12898 = [];
var len__7484__auto___12901 = arguments.length;
var i__7485__auto___12902 = (0);
while(true){
if((i__7485__auto___12902 < len__7484__auto___12901)){
args12898.push((arguments[i__7485__auto___12902]));

var G__12903 = (i__7485__auto___12902 + (1));
i__7485__auto___12902 = G__12903;
continue;
} else {
}
break;
}

var G__12900 = args12898.length;
switch (G__12900) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12898.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args12905 = [];
var len__7484__auto___12908 = arguments.length;
var i__7485__auto___12909 = (0);
while(true){
if((i__7485__auto___12909 < len__7484__auto___12908)){
args12905.push((arguments[i__7485__auto___12909]));

var G__12910 = (i__7485__auto___12909 + (1));
i__7485__auto___12909 = G__12910;
continue;
} else {
}
break;
}

var G__12907 = args12905.length;
switch (G__12907) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12905.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args12912 = [];
var len__7484__auto___12965 = arguments.length;
var i__7485__auto___12966 = (0);
while(true){
if((i__7485__auto___12966 < len__7484__auto___12965)){
args12912.push((arguments[i__7485__auto___12966]));

var G__12967 = (i__7485__auto___12966 + (1));
i__7485__auto___12966 = G__12967;
continue;
} else {
}
break;
}

var G__12914 = args12912.length;
switch (G__12914) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12912.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__12283__auto___12969 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto___12969,tc,fc){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___12969,tc,fc){
return (function (state_12940){
var state_val_12941 = (state_12940[(1)]);
if((state_val_12941 === (7))){
var inst_12936 = (state_12940[(2)]);
var state_12940__$1 = state_12940;
var statearr_12942_12970 = state_12940__$1;
(statearr_12942_12970[(2)] = inst_12936);

(statearr_12942_12970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (1))){
var state_12940__$1 = state_12940;
var statearr_12943_12971 = state_12940__$1;
(statearr_12943_12971[(2)] = null);

(statearr_12943_12971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (4))){
var inst_12917 = (state_12940[(7)]);
var inst_12917__$1 = (state_12940[(2)]);
var inst_12918 = (inst_12917__$1 == null);
var state_12940__$1 = (function (){var statearr_12944 = state_12940;
(statearr_12944[(7)] = inst_12917__$1);

return statearr_12944;
})();
if(cljs.core.truth_(inst_12918)){
var statearr_12945_12972 = state_12940__$1;
(statearr_12945_12972[(1)] = (5));

} else {
var statearr_12946_12973 = state_12940__$1;
(statearr_12946_12973[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (13))){
var state_12940__$1 = state_12940;
var statearr_12947_12974 = state_12940__$1;
(statearr_12947_12974[(2)] = null);

(statearr_12947_12974[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (6))){
var inst_12917 = (state_12940[(7)]);
var inst_12923 = p.call(null,inst_12917);
var state_12940__$1 = state_12940;
if(cljs.core.truth_(inst_12923)){
var statearr_12948_12975 = state_12940__$1;
(statearr_12948_12975[(1)] = (9));

} else {
var statearr_12949_12976 = state_12940__$1;
(statearr_12949_12976[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (3))){
var inst_12938 = (state_12940[(2)]);
var state_12940__$1 = state_12940;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12940__$1,inst_12938);
} else {
if((state_val_12941 === (12))){
var state_12940__$1 = state_12940;
var statearr_12950_12977 = state_12940__$1;
(statearr_12950_12977[(2)] = null);

(statearr_12950_12977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (2))){
var state_12940__$1 = state_12940;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12940__$1,(4),ch);
} else {
if((state_val_12941 === (11))){
var inst_12917 = (state_12940[(7)]);
var inst_12927 = (state_12940[(2)]);
var state_12940__$1 = state_12940;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12940__$1,(8),inst_12927,inst_12917);
} else {
if((state_val_12941 === (9))){
var state_12940__$1 = state_12940;
var statearr_12951_12978 = state_12940__$1;
(statearr_12951_12978[(2)] = tc);

(statearr_12951_12978[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (5))){
var inst_12920 = cljs.core.async.close_BANG_.call(null,tc);
var inst_12921 = cljs.core.async.close_BANG_.call(null,fc);
var state_12940__$1 = (function (){var statearr_12952 = state_12940;
(statearr_12952[(8)] = inst_12920);

return statearr_12952;
})();
var statearr_12953_12979 = state_12940__$1;
(statearr_12953_12979[(2)] = inst_12921);

(statearr_12953_12979[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (14))){
var inst_12934 = (state_12940[(2)]);
var state_12940__$1 = state_12940;
var statearr_12954_12980 = state_12940__$1;
(statearr_12954_12980[(2)] = inst_12934);

(statearr_12954_12980[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (10))){
var state_12940__$1 = state_12940;
var statearr_12955_12981 = state_12940__$1;
(statearr_12955_12981[(2)] = fc);

(statearr_12955_12981[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12941 === (8))){
var inst_12929 = (state_12940[(2)]);
var state_12940__$1 = state_12940;
if(cljs.core.truth_(inst_12929)){
var statearr_12956_12982 = state_12940__$1;
(statearr_12956_12982[(1)] = (12));

} else {
var statearr_12957_12983 = state_12940__$1;
(statearr_12957_12983[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___12969,tc,fc))
;
return ((function (switch__12171__auto__,c__12283__auto___12969,tc,fc){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_12961 = [null,null,null,null,null,null,null,null,null];
(statearr_12961[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_12961[(1)] = (1));

return statearr_12961;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_12940){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_12940);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e12962){if((e12962 instanceof Object)){
var ex__12175__auto__ = e12962;
var statearr_12963_12984 = state_12940;
(statearr_12963_12984[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12940);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12962;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12985 = state_12940;
state_12940 = G__12985;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_12940){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_12940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___12969,tc,fc))
})();
var state__12285__auto__ = (function (){var statearr_12964 = f__12284__auto__.call(null);
(statearr_12964[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___12969);

return statearr_12964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto___12969,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12283__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto__){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__){
return (function (state_13049){
var state_val_13050 = (state_13049[(1)]);
if((state_val_13050 === (7))){
var inst_13045 = (state_13049[(2)]);
var state_13049__$1 = state_13049;
var statearr_13051_13072 = state_13049__$1;
(statearr_13051_13072[(2)] = inst_13045);

(statearr_13051_13072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13050 === (1))){
var inst_13029 = init;
var state_13049__$1 = (function (){var statearr_13052 = state_13049;
(statearr_13052[(7)] = inst_13029);

return statearr_13052;
})();
var statearr_13053_13073 = state_13049__$1;
(statearr_13053_13073[(2)] = null);

(statearr_13053_13073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13050 === (4))){
var inst_13032 = (state_13049[(8)]);
var inst_13032__$1 = (state_13049[(2)]);
var inst_13033 = (inst_13032__$1 == null);
var state_13049__$1 = (function (){var statearr_13054 = state_13049;
(statearr_13054[(8)] = inst_13032__$1);

return statearr_13054;
})();
if(cljs.core.truth_(inst_13033)){
var statearr_13055_13074 = state_13049__$1;
(statearr_13055_13074[(1)] = (5));

} else {
var statearr_13056_13075 = state_13049__$1;
(statearr_13056_13075[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13050 === (6))){
var inst_13036 = (state_13049[(9)]);
var inst_13032 = (state_13049[(8)]);
var inst_13029 = (state_13049[(7)]);
var inst_13036__$1 = f.call(null,inst_13029,inst_13032);
var inst_13037 = cljs.core.reduced_QMARK_.call(null,inst_13036__$1);
var state_13049__$1 = (function (){var statearr_13057 = state_13049;
(statearr_13057[(9)] = inst_13036__$1);

return statearr_13057;
})();
if(inst_13037){
var statearr_13058_13076 = state_13049__$1;
(statearr_13058_13076[(1)] = (8));

} else {
var statearr_13059_13077 = state_13049__$1;
(statearr_13059_13077[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13050 === (3))){
var inst_13047 = (state_13049[(2)]);
var state_13049__$1 = state_13049;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13049__$1,inst_13047);
} else {
if((state_val_13050 === (2))){
var state_13049__$1 = state_13049;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13049__$1,(4),ch);
} else {
if((state_val_13050 === (9))){
var inst_13036 = (state_13049[(9)]);
var inst_13029 = inst_13036;
var state_13049__$1 = (function (){var statearr_13060 = state_13049;
(statearr_13060[(7)] = inst_13029);

return statearr_13060;
})();
var statearr_13061_13078 = state_13049__$1;
(statearr_13061_13078[(2)] = null);

(statearr_13061_13078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13050 === (5))){
var inst_13029 = (state_13049[(7)]);
var state_13049__$1 = state_13049;
var statearr_13062_13079 = state_13049__$1;
(statearr_13062_13079[(2)] = inst_13029);

(statearr_13062_13079[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13050 === (10))){
var inst_13043 = (state_13049[(2)]);
var state_13049__$1 = state_13049;
var statearr_13063_13080 = state_13049__$1;
(statearr_13063_13080[(2)] = inst_13043);

(statearr_13063_13080[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13050 === (8))){
var inst_13036 = (state_13049[(9)]);
var inst_13039 = cljs.core.deref.call(null,inst_13036);
var state_13049__$1 = state_13049;
var statearr_13064_13081 = state_13049__$1;
(statearr_13064_13081[(2)] = inst_13039);

(statearr_13064_13081[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto__))
;
return ((function (switch__12171__auto__,c__12283__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__12172__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12172__auto____0 = (function (){
var statearr_13068 = [null,null,null,null,null,null,null,null,null,null];
(statearr_13068[(0)] = cljs$core$async$reduce_$_state_machine__12172__auto__);

(statearr_13068[(1)] = (1));

return statearr_13068;
});
var cljs$core$async$reduce_$_state_machine__12172__auto____1 = (function (state_13049){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_13049);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e13069){if((e13069 instanceof Object)){
var ex__12175__auto__ = e13069;
var statearr_13070_13082 = state_13049;
(statearr_13070_13082[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13049);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13069;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13083 = state_13049;
state_13049 = G__13083;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12172__auto__ = function(state_13049){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12172__auto____1.call(this,state_13049);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12172__auto____0;
cljs$core$async$reduce_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12172__auto____1;
return cljs$core$async$reduce_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__))
})();
var state__12285__auto__ = (function (){var statearr_13071 = f__12284__auto__.call(null);
(statearr_13071[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_13071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto__))
);

return c__12283__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__12283__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto__,f__$1){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__,f__$1){
return (function (state_13103){
var state_val_13104 = (state_13103[(1)]);
if((state_val_13104 === (1))){
var inst_13098 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_13103__$1 = state_13103;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13103__$1,(2),inst_13098);
} else {
if((state_val_13104 === (2))){
var inst_13100 = (state_13103[(2)]);
var inst_13101 = f__$1.call(null,inst_13100);
var state_13103__$1 = state_13103;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13103__$1,inst_13101);
} else {
return null;
}
}
});})(c__12283__auto__,f__$1))
;
return ((function (switch__12171__auto__,c__12283__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__12172__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12172__auto____0 = (function (){
var statearr_13108 = [null,null,null,null,null,null,null];
(statearr_13108[(0)] = cljs$core$async$transduce_$_state_machine__12172__auto__);

(statearr_13108[(1)] = (1));

return statearr_13108;
});
var cljs$core$async$transduce_$_state_machine__12172__auto____1 = (function (state_13103){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_13103);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e13109){if((e13109 instanceof Object)){
var ex__12175__auto__ = e13109;
var statearr_13110_13112 = state_13103;
(statearr_13110_13112[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13103);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13109;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13113 = state_13103;
state_13103 = G__13113;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12172__auto__ = function(state_13103){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12172__auto____1.call(this,state_13103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12172__auto____0;
cljs$core$async$transduce_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12172__auto____1;
return cljs$core$async$transduce_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__,f__$1))
})();
var state__12285__auto__ = (function (){var statearr_13111 = f__12284__auto__.call(null);
(statearr_13111[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_13111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto__,f__$1))
);

return c__12283__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args13114 = [];
var len__7484__auto___13166 = arguments.length;
var i__7485__auto___13167 = (0);
while(true){
if((i__7485__auto___13167 < len__7484__auto___13166)){
args13114.push((arguments[i__7485__auto___13167]));

var G__13168 = (i__7485__auto___13167 + (1));
i__7485__auto___13167 = G__13168;
continue;
} else {
}
break;
}

var G__13116 = args13114.length;
switch (G__13116) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13114.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12283__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto__){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__){
return (function (state_13141){
var state_val_13142 = (state_13141[(1)]);
if((state_val_13142 === (7))){
var inst_13123 = (state_13141[(2)]);
var state_13141__$1 = state_13141;
var statearr_13143_13170 = state_13141__$1;
(statearr_13143_13170[(2)] = inst_13123);

(statearr_13143_13170[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (1))){
var inst_13117 = cljs.core.seq.call(null,coll);
var inst_13118 = inst_13117;
var state_13141__$1 = (function (){var statearr_13144 = state_13141;
(statearr_13144[(7)] = inst_13118);

return statearr_13144;
})();
var statearr_13145_13171 = state_13141__$1;
(statearr_13145_13171[(2)] = null);

(statearr_13145_13171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (4))){
var inst_13118 = (state_13141[(7)]);
var inst_13121 = cljs.core.first.call(null,inst_13118);
var state_13141__$1 = state_13141;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13141__$1,(7),ch,inst_13121);
} else {
if((state_val_13142 === (13))){
var inst_13135 = (state_13141[(2)]);
var state_13141__$1 = state_13141;
var statearr_13146_13172 = state_13141__$1;
(statearr_13146_13172[(2)] = inst_13135);

(statearr_13146_13172[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (6))){
var inst_13126 = (state_13141[(2)]);
var state_13141__$1 = state_13141;
if(cljs.core.truth_(inst_13126)){
var statearr_13147_13173 = state_13141__$1;
(statearr_13147_13173[(1)] = (8));

} else {
var statearr_13148_13174 = state_13141__$1;
(statearr_13148_13174[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (3))){
var inst_13139 = (state_13141[(2)]);
var state_13141__$1 = state_13141;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13141__$1,inst_13139);
} else {
if((state_val_13142 === (12))){
var state_13141__$1 = state_13141;
var statearr_13149_13175 = state_13141__$1;
(statearr_13149_13175[(2)] = null);

(statearr_13149_13175[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (2))){
var inst_13118 = (state_13141[(7)]);
var state_13141__$1 = state_13141;
if(cljs.core.truth_(inst_13118)){
var statearr_13150_13176 = state_13141__$1;
(statearr_13150_13176[(1)] = (4));

} else {
var statearr_13151_13177 = state_13141__$1;
(statearr_13151_13177[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (11))){
var inst_13132 = cljs.core.async.close_BANG_.call(null,ch);
var state_13141__$1 = state_13141;
var statearr_13152_13178 = state_13141__$1;
(statearr_13152_13178[(2)] = inst_13132);

(statearr_13152_13178[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (9))){
var state_13141__$1 = state_13141;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13153_13179 = state_13141__$1;
(statearr_13153_13179[(1)] = (11));

} else {
var statearr_13154_13180 = state_13141__$1;
(statearr_13154_13180[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (5))){
var inst_13118 = (state_13141[(7)]);
var state_13141__$1 = state_13141;
var statearr_13155_13181 = state_13141__$1;
(statearr_13155_13181[(2)] = inst_13118);

(statearr_13155_13181[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (10))){
var inst_13137 = (state_13141[(2)]);
var state_13141__$1 = state_13141;
var statearr_13156_13182 = state_13141__$1;
(statearr_13156_13182[(2)] = inst_13137);

(statearr_13156_13182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (8))){
var inst_13118 = (state_13141[(7)]);
var inst_13128 = cljs.core.next.call(null,inst_13118);
var inst_13118__$1 = inst_13128;
var state_13141__$1 = (function (){var statearr_13157 = state_13141;
(statearr_13157[(7)] = inst_13118__$1);

return statearr_13157;
})();
var statearr_13158_13183 = state_13141__$1;
(statearr_13158_13183[(2)] = null);

(statearr_13158_13183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto__))
;
return ((function (switch__12171__auto__,c__12283__auto__){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_13162 = [null,null,null,null,null,null,null,null];
(statearr_13162[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_13162[(1)] = (1));

return statearr_13162;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_13141){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_13141);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e13163){if((e13163 instanceof Object)){
var ex__12175__auto__ = e13163;
var statearr_13164_13184 = state_13141;
(statearr_13164_13184[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13141);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13163;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13185 = state_13141;
state_13141 = G__13185;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_13141){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_13141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__))
})();
var state__12285__auto__ = (function (){var statearr_13165 = f__12284__auto__.call(null);
(statearr_13165[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_13165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto__))
);

return c__12283__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,_);
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async13411 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13411 = (function (mult,ch,cs,meta13412){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta13412 = meta13412;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13411.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_13413,meta13412__$1){
var self__ = this;
var _13413__$1 = this;
return (new cljs.core.async.t_cljs$core$async13411(self__.mult,self__.ch,self__.cs,meta13412__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async13411.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_13413){
var self__ = this;
var _13413__$1 = this;
return self__.meta13412;
});})(cs))
;

cljs.core.async.t_cljs$core$async13411.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async13411.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async13411.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async13411.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13411.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13411.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13411.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta13412","meta13412",1857503817,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async13411.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13411.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13411";

cljs.core.async.t_cljs$core$async13411.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13411");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async13411 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async13411(mult__$1,ch__$1,cs__$1,meta13412){
return (new cljs.core.async.t_cljs$core$async13411(mult__$1,ch__$1,cs__$1,meta13412));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async13411(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__12283__auto___13636 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto___13636,cs,m,dchan,dctr,done){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___13636,cs,m,dchan,dctr,done){
return (function (state_13548){
var state_val_13549 = (state_13548[(1)]);
if((state_val_13549 === (7))){
var inst_13544 = (state_13548[(2)]);
var state_13548__$1 = state_13548;
var statearr_13550_13637 = state_13548__$1;
(statearr_13550_13637[(2)] = inst_13544);

(statearr_13550_13637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (20))){
var inst_13447 = (state_13548[(7)]);
var inst_13459 = cljs.core.first.call(null,inst_13447);
var inst_13460 = cljs.core.nth.call(null,inst_13459,(0),null);
var inst_13461 = cljs.core.nth.call(null,inst_13459,(1),null);
var state_13548__$1 = (function (){var statearr_13551 = state_13548;
(statearr_13551[(8)] = inst_13460);

return statearr_13551;
})();
if(cljs.core.truth_(inst_13461)){
var statearr_13552_13638 = state_13548__$1;
(statearr_13552_13638[(1)] = (22));

} else {
var statearr_13553_13639 = state_13548__$1;
(statearr_13553_13639[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (27))){
var inst_13416 = (state_13548[(9)]);
var inst_13491 = (state_13548[(10)]);
var inst_13489 = (state_13548[(11)]);
var inst_13496 = (state_13548[(12)]);
var inst_13496__$1 = cljs.core._nth.call(null,inst_13489,inst_13491);
var inst_13497 = cljs.core.async.put_BANG_.call(null,inst_13496__$1,inst_13416,done);
var state_13548__$1 = (function (){var statearr_13554 = state_13548;
(statearr_13554[(12)] = inst_13496__$1);

return statearr_13554;
})();
if(cljs.core.truth_(inst_13497)){
var statearr_13555_13640 = state_13548__$1;
(statearr_13555_13640[(1)] = (30));

} else {
var statearr_13556_13641 = state_13548__$1;
(statearr_13556_13641[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (1))){
var state_13548__$1 = state_13548;
var statearr_13557_13642 = state_13548__$1;
(statearr_13557_13642[(2)] = null);

(statearr_13557_13642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (24))){
var inst_13447 = (state_13548[(7)]);
var inst_13466 = (state_13548[(2)]);
var inst_13467 = cljs.core.next.call(null,inst_13447);
var inst_13425 = inst_13467;
var inst_13426 = null;
var inst_13427 = (0);
var inst_13428 = (0);
var state_13548__$1 = (function (){var statearr_13558 = state_13548;
(statearr_13558[(13)] = inst_13428);

(statearr_13558[(14)] = inst_13427);

(statearr_13558[(15)] = inst_13426);

(statearr_13558[(16)] = inst_13425);

(statearr_13558[(17)] = inst_13466);

return statearr_13558;
})();
var statearr_13559_13643 = state_13548__$1;
(statearr_13559_13643[(2)] = null);

(statearr_13559_13643[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (39))){
var state_13548__$1 = state_13548;
var statearr_13563_13644 = state_13548__$1;
(statearr_13563_13644[(2)] = null);

(statearr_13563_13644[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (4))){
var inst_13416 = (state_13548[(9)]);
var inst_13416__$1 = (state_13548[(2)]);
var inst_13417 = (inst_13416__$1 == null);
var state_13548__$1 = (function (){var statearr_13564 = state_13548;
(statearr_13564[(9)] = inst_13416__$1);

return statearr_13564;
})();
if(cljs.core.truth_(inst_13417)){
var statearr_13565_13645 = state_13548__$1;
(statearr_13565_13645[(1)] = (5));

} else {
var statearr_13566_13646 = state_13548__$1;
(statearr_13566_13646[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (15))){
var inst_13428 = (state_13548[(13)]);
var inst_13427 = (state_13548[(14)]);
var inst_13426 = (state_13548[(15)]);
var inst_13425 = (state_13548[(16)]);
var inst_13443 = (state_13548[(2)]);
var inst_13444 = (inst_13428 + (1));
var tmp13560 = inst_13427;
var tmp13561 = inst_13426;
var tmp13562 = inst_13425;
var inst_13425__$1 = tmp13562;
var inst_13426__$1 = tmp13561;
var inst_13427__$1 = tmp13560;
var inst_13428__$1 = inst_13444;
var state_13548__$1 = (function (){var statearr_13567 = state_13548;
(statearr_13567[(18)] = inst_13443);

(statearr_13567[(13)] = inst_13428__$1);

(statearr_13567[(14)] = inst_13427__$1);

(statearr_13567[(15)] = inst_13426__$1);

(statearr_13567[(16)] = inst_13425__$1);

return statearr_13567;
})();
var statearr_13568_13647 = state_13548__$1;
(statearr_13568_13647[(2)] = null);

(statearr_13568_13647[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (21))){
var inst_13470 = (state_13548[(2)]);
var state_13548__$1 = state_13548;
var statearr_13572_13648 = state_13548__$1;
(statearr_13572_13648[(2)] = inst_13470);

(statearr_13572_13648[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (31))){
var inst_13496 = (state_13548[(12)]);
var inst_13500 = done.call(null,null);
var inst_13501 = cljs.core.async.untap_STAR_.call(null,m,inst_13496);
var state_13548__$1 = (function (){var statearr_13573 = state_13548;
(statearr_13573[(19)] = inst_13500);

return statearr_13573;
})();
var statearr_13574_13649 = state_13548__$1;
(statearr_13574_13649[(2)] = inst_13501);

(statearr_13574_13649[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (32))){
var inst_13490 = (state_13548[(20)]);
var inst_13491 = (state_13548[(10)]);
var inst_13489 = (state_13548[(11)]);
var inst_13488 = (state_13548[(21)]);
var inst_13503 = (state_13548[(2)]);
var inst_13504 = (inst_13491 + (1));
var tmp13569 = inst_13490;
var tmp13570 = inst_13489;
var tmp13571 = inst_13488;
var inst_13488__$1 = tmp13571;
var inst_13489__$1 = tmp13570;
var inst_13490__$1 = tmp13569;
var inst_13491__$1 = inst_13504;
var state_13548__$1 = (function (){var statearr_13575 = state_13548;
(statearr_13575[(20)] = inst_13490__$1);

(statearr_13575[(22)] = inst_13503);

(statearr_13575[(10)] = inst_13491__$1);

(statearr_13575[(11)] = inst_13489__$1);

(statearr_13575[(21)] = inst_13488__$1);

return statearr_13575;
})();
var statearr_13576_13650 = state_13548__$1;
(statearr_13576_13650[(2)] = null);

(statearr_13576_13650[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (40))){
var inst_13516 = (state_13548[(23)]);
var inst_13520 = done.call(null,null);
var inst_13521 = cljs.core.async.untap_STAR_.call(null,m,inst_13516);
var state_13548__$1 = (function (){var statearr_13577 = state_13548;
(statearr_13577[(24)] = inst_13520);

return statearr_13577;
})();
var statearr_13578_13651 = state_13548__$1;
(statearr_13578_13651[(2)] = inst_13521);

(statearr_13578_13651[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (33))){
var inst_13507 = (state_13548[(25)]);
var inst_13509 = cljs.core.chunked_seq_QMARK_.call(null,inst_13507);
var state_13548__$1 = state_13548;
if(inst_13509){
var statearr_13579_13652 = state_13548__$1;
(statearr_13579_13652[(1)] = (36));

} else {
var statearr_13580_13653 = state_13548__$1;
(statearr_13580_13653[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (13))){
var inst_13437 = (state_13548[(26)]);
var inst_13440 = cljs.core.async.close_BANG_.call(null,inst_13437);
var state_13548__$1 = state_13548;
var statearr_13581_13654 = state_13548__$1;
(statearr_13581_13654[(2)] = inst_13440);

(statearr_13581_13654[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (22))){
var inst_13460 = (state_13548[(8)]);
var inst_13463 = cljs.core.async.close_BANG_.call(null,inst_13460);
var state_13548__$1 = state_13548;
var statearr_13582_13655 = state_13548__$1;
(statearr_13582_13655[(2)] = inst_13463);

(statearr_13582_13655[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (36))){
var inst_13507 = (state_13548[(25)]);
var inst_13511 = cljs.core.chunk_first.call(null,inst_13507);
var inst_13512 = cljs.core.chunk_rest.call(null,inst_13507);
var inst_13513 = cljs.core.count.call(null,inst_13511);
var inst_13488 = inst_13512;
var inst_13489 = inst_13511;
var inst_13490 = inst_13513;
var inst_13491 = (0);
var state_13548__$1 = (function (){var statearr_13583 = state_13548;
(statearr_13583[(20)] = inst_13490);

(statearr_13583[(10)] = inst_13491);

(statearr_13583[(11)] = inst_13489);

(statearr_13583[(21)] = inst_13488);

return statearr_13583;
})();
var statearr_13584_13656 = state_13548__$1;
(statearr_13584_13656[(2)] = null);

(statearr_13584_13656[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (41))){
var inst_13507 = (state_13548[(25)]);
var inst_13523 = (state_13548[(2)]);
var inst_13524 = cljs.core.next.call(null,inst_13507);
var inst_13488 = inst_13524;
var inst_13489 = null;
var inst_13490 = (0);
var inst_13491 = (0);
var state_13548__$1 = (function (){var statearr_13585 = state_13548;
(statearr_13585[(20)] = inst_13490);

(statearr_13585[(27)] = inst_13523);

(statearr_13585[(10)] = inst_13491);

(statearr_13585[(11)] = inst_13489);

(statearr_13585[(21)] = inst_13488);

return statearr_13585;
})();
var statearr_13586_13657 = state_13548__$1;
(statearr_13586_13657[(2)] = null);

(statearr_13586_13657[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (43))){
var state_13548__$1 = state_13548;
var statearr_13587_13658 = state_13548__$1;
(statearr_13587_13658[(2)] = null);

(statearr_13587_13658[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (29))){
var inst_13532 = (state_13548[(2)]);
var state_13548__$1 = state_13548;
var statearr_13588_13659 = state_13548__$1;
(statearr_13588_13659[(2)] = inst_13532);

(statearr_13588_13659[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (44))){
var inst_13541 = (state_13548[(2)]);
var state_13548__$1 = (function (){var statearr_13589 = state_13548;
(statearr_13589[(28)] = inst_13541);

return statearr_13589;
})();
var statearr_13590_13660 = state_13548__$1;
(statearr_13590_13660[(2)] = null);

(statearr_13590_13660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (6))){
var inst_13480 = (state_13548[(29)]);
var inst_13479 = cljs.core.deref.call(null,cs);
var inst_13480__$1 = cljs.core.keys.call(null,inst_13479);
var inst_13481 = cljs.core.count.call(null,inst_13480__$1);
var inst_13482 = cljs.core.reset_BANG_.call(null,dctr,inst_13481);
var inst_13487 = cljs.core.seq.call(null,inst_13480__$1);
var inst_13488 = inst_13487;
var inst_13489 = null;
var inst_13490 = (0);
var inst_13491 = (0);
var state_13548__$1 = (function (){var statearr_13591 = state_13548;
(statearr_13591[(20)] = inst_13490);

(statearr_13591[(30)] = inst_13482);

(statearr_13591[(10)] = inst_13491);

(statearr_13591[(11)] = inst_13489);

(statearr_13591[(21)] = inst_13488);

(statearr_13591[(29)] = inst_13480__$1);

return statearr_13591;
})();
var statearr_13592_13661 = state_13548__$1;
(statearr_13592_13661[(2)] = null);

(statearr_13592_13661[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (28))){
var inst_13507 = (state_13548[(25)]);
var inst_13488 = (state_13548[(21)]);
var inst_13507__$1 = cljs.core.seq.call(null,inst_13488);
var state_13548__$1 = (function (){var statearr_13593 = state_13548;
(statearr_13593[(25)] = inst_13507__$1);

return statearr_13593;
})();
if(inst_13507__$1){
var statearr_13594_13662 = state_13548__$1;
(statearr_13594_13662[(1)] = (33));

} else {
var statearr_13595_13663 = state_13548__$1;
(statearr_13595_13663[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (25))){
var inst_13490 = (state_13548[(20)]);
var inst_13491 = (state_13548[(10)]);
var inst_13493 = (inst_13491 < inst_13490);
var inst_13494 = inst_13493;
var state_13548__$1 = state_13548;
if(cljs.core.truth_(inst_13494)){
var statearr_13596_13664 = state_13548__$1;
(statearr_13596_13664[(1)] = (27));

} else {
var statearr_13597_13665 = state_13548__$1;
(statearr_13597_13665[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (34))){
var state_13548__$1 = state_13548;
var statearr_13598_13666 = state_13548__$1;
(statearr_13598_13666[(2)] = null);

(statearr_13598_13666[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (17))){
var state_13548__$1 = state_13548;
var statearr_13599_13667 = state_13548__$1;
(statearr_13599_13667[(2)] = null);

(statearr_13599_13667[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (3))){
var inst_13546 = (state_13548[(2)]);
var state_13548__$1 = state_13548;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13548__$1,inst_13546);
} else {
if((state_val_13549 === (12))){
var inst_13475 = (state_13548[(2)]);
var state_13548__$1 = state_13548;
var statearr_13600_13668 = state_13548__$1;
(statearr_13600_13668[(2)] = inst_13475);

(statearr_13600_13668[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (2))){
var state_13548__$1 = state_13548;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13548__$1,(4),ch);
} else {
if((state_val_13549 === (23))){
var state_13548__$1 = state_13548;
var statearr_13601_13669 = state_13548__$1;
(statearr_13601_13669[(2)] = null);

(statearr_13601_13669[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (35))){
var inst_13530 = (state_13548[(2)]);
var state_13548__$1 = state_13548;
var statearr_13602_13670 = state_13548__$1;
(statearr_13602_13670[(2)] = inst_13530);

(statearr_13602_13670[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (19))){
var inst_13447 = (state_13548[(7)]);
var inst_13451 = cljs.core.chunk_first.call(null,inst_13447);
var inst_13452 = cljs.core.chunk_rest.call(null,inst_13447);
var inst_13453 = cljs.core.count.call(null,inst_13451);
var inst_13425 = inst_13452;
var inst_13426 = inst_13451;
var inst_13427 = inst_13453;
var inst_13428 = (0);
var state_13548__$1 = (function (){var statearr_13603 = state_13548;
(statearr_13603[(13)] = inst_13428);

(statearr_13603[(14)] = inst_13427);

(statearr_13603[(15)] = inst_13426);

(statearr_13603[(16)] = inst_13425);

return statearr_13603;
})();
var statearr_13604_13671 = state_13548__$1;
(statearr_13604_13671[(2)] = null);

(statearr_13604_13671[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (11))){
var inst_13447 = (state_13548[(7)]);
var inst_13425 = (state_13548[(16)]);
var inst_13447__$1 = cljs.core.seq.call(null,inst_13425);
var state_13548__$1 = (function (){var statearr_13605 = state_13548;
(statearr_13605[(7)] = inst_13447__$1);

return statearr_13605;
})();
if(inst_13447__$1){
var statearr_13606_13672 = state_13548__$1;
(statearr_13606_13672[(1)] = (16));

} else {
var statearr_13607_13673 = state_13548__$1;
(statearr_13607_13673[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (9))){
var inst_13477 = (state_13548[(2)]);
var state_13548__$1 = state_13548;
var statearr_13608_13674 = state_13548__$1;
(statearr_13608_13674[(2)] = inst_13477);

(statearr_13608_13674[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (5))){
var inst_13423 = cljs.core.deref.call(null,cs);
var inst_13424 = cljs.core.seq.call(null,inst_13423);
var inst_13425 = inst_13424;
var inst_13426 = null;
var inst_13427 = (0);
var inst_13428 = (0);
var state_13548__$1 = (function (){var statearr_13609 = state_13548;
(statearr_13609[(13)] = inst_13428);

(statearr_13609[(14)] = inst_13427);

(statearr_13609[(15)] = inst_13426);

(statearr_13609[(16)] = inst_13425);

return statearr_13609;
})();
var statearr_13610_13675 = state_13548__$1;
(statearr_13610_13675[(2)] = null);

(statearr_13610_13675[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (14))){
var state_13548__$1 = state_13548;
var statearr_13611_13676 = state_13548__$1;
(statearr_13611_13676[(2)] = null);

(statearr_13611_13676[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (45))){
var inst_13538 = (state_13548[(2)]);
var state_13548__$1 = state_13548;
var statearr_13612_13677 = state_13548__$1;
(statearr_13612_13677[(2)] = inst_13538);

(statearr_13612_13677[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (26))){
var inst_13480 = (state_13548[(29)]);
var inst_13534 = (state_13548[(2)]);
var inst_13535 = cljs.core.seq.call(null,inst_13480);
var state_13548__$1 = (function (){var statearr_13613 = state_13548;
(statearr_13613[(31)] = inst_13534);

return statearr_13613;
})();
if(inst_13535){
var statearr_13614_13678 = state_13548__$1;
(statearr_13614_13678[(1)] = (42));

} else {
var statearr_13615_13679 = state_13548__$1;
(statearr_13615_13679[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (16))){
var inst_13447 = (state_13548[(7)]);
var inst_13449 = cljs.core.chunked_seq_QMARK_.call(null,inst_13447);
var state_13548__$1 = state_13548;
if(inst_13449){
var statearr_13616_13680 = state_13548__$1;
(statearr_13616_13680[(1)] = (19));

} else {
var statearr_13617_13681 = state_13548__$1;
(statearr_13617_13681[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (38))){
var inst_13527 = (state_13548[(2)]);
var state_13548__$1 = state_13548;
var statearr_13618_13682 = state_13548__$1;
(statearr_13618_13682[(2)] = inst_13527);

(statearr_13618_13682[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (30))){
var state_13548__$1 = state_13548;
var statearr_13619_13683 = state_13548__$1;
(statearr_13619_13683[(2)] = null);

(statearr_13619_13683[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (10))){
var inst_13428 = (state_13548[(13)]);
var inst_13426 = (state_13548[(15)]);
var inst_13436 = cljs.core._nth.call(null,inst_13426,inst_13428);
var inst_13437 = cljs.core.nth.call(null,inst_13436,(0),null);
var inst_13438 = cljs.core.nth.call(null,inst_13436,(1),null);
var state_13548__$1 = (function (){var statearr_13620 = state_13548;
(statearr_13620[(26)] = inst_13437);

return statearr_13620;
})();
if(cljs.core.truth_(inst_13438)){
var statearr_13621_13684 = state_13548__$1;
(statearr_13621_13684[(1)] = (13));

} else {
var statearr_13622_13685 = state_13548__$1;
(statearr_13622_13685[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (18))){
var inst_13473 = (state_13548[(2)]);
var state_13548__$1 = state_13548;
var statearr_13623_13686 = state_13548__$1;
(statearr_13623_13686[(2)] = inst_13473);

(statearr_13623_13686[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (42))){
var state_13548__$1 = state_13548;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13548__$1,(45),dchan);
} else {
if((state_val_13549 === (37))){
var inst_13507 = (state_13548[(25)]);
var inst_13416 = (state_13548[(9)]);
var inst_13516 = (state_13548[(23)]);
var inst_13516__$1 = cljs.core.first.call(null,inst_13507);
var inst_13517 = cljs.core.async.put_BANG_.call(null,inst_13516__$1,inst_13416,done);
var state_13548__$1 = (function (){var statearr_13624 = state_13548;
(statearr_13624[(23)] = inst_13516__$1);

return statearr_13624;
})();
if(cljs.core.truth_(inst_13517)){
var statearr_13625_13687 = state_13548__$1;
(statearr_13625_13687[(1)] = (39));

} else {
var statearr_13626_13688 = state_13548__$1;
(statearr_13626_13688[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13549 === (8))){
var inst_13428 = (state_13548[(13)]);
var inst_13427 = (state_13548[(14)]);
var inst_13430 = (inst_13428 < inst_13427);
var inst_13431 = inst_13430;
var state_13548__$1 = state_13548;
if(cljs.core.truth_(inst_13431)){
var statearr_13627_13689 = state_13548__$1;
(statearr_13627_13689[(1)] = (10));

} else {
var statearr_13628_13690 = state_13548__$1;
(statearr_13628_13690[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___13636,cs,m,dchan,dctr,done))
;
return ((function (switch__12171__auto__,c__12283__auto___13636,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__12172__auto__ = null;
var cljs$core$async$mult_$_state_machine__12172__auto____0 = (function (){
var statearr_13632 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13632[(0)] = cljs$core$async$mult_$_state_machine__12172__auto__);

(statearr_13632[(1)] = (1));

return statearr_13632;
});
var cljs$core$async$mult_$_state_machine__12172__auto____1 = (function (state_13548){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_13548);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e13633){if((e13633 instanceof Object)){
var ex__12175__auto__ = e13633;
var statearr_13634_13691 = state_13548;
(statearr_13634_13691[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13548);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13633;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13692 = state_13548;
state_13548 = G__13692;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12172__auto__ = function(state_13548){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12172__auto____1.call(this,state_13548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12172__auto____0;
cljs$core$async$mult_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12172__auto____1;
return cljs$core$async$mult_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___13636,cs,m,dchan,dctr,done))
})();
var state__12285__auto__ = (function (){var statearr_13635 = f__12284__auto__.call(null);
(statearr_13635[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___13636);

return statearr_13635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto___13636,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args13693 = [];
var len__7484__auto___13696 = arguments.length;
var i__7485__auto___13697 = (0);
while(true){
if((i__7485__auto___13697 < len__7484__auto___13696)){
args13693.push((arguments[i__7485__auto___13697]));

var G__13698 = (i__7485__auto___13697 + (1));
i__7485__auto___13697 = G__13698;
continue;
} else {
}
break;
}

var G__13695 = args13693.length;
switch (G__13695) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13693.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,state_map);
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,mode);
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___13710 = arguments.length;
var i__7485__auto___13711 = (0);
while(true){
if((i__7485__auto___13711 < len__7484__auto___13710)){
args__7491__auto__.push((arguments[i__7485__auto___13711]));

var G__13712 = (i__7485__auto___13711 + (1));
i__7485__auto___13711 = G__13712;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13704){
var map__13705 = p__13704;
var map__13705__$1 = ((((!((map__13705 == null)))?((((map__13705.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13705.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13705):map__13705);
var opts = map__13705__$1;
var statearr_13707_13713 = state;
(statearr_13707_13713[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__13705,map__13705__$1,opts){
return (function (val){
var statearr_13708_13714 = state;
(statearr_13708_13714[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__13705,map__13705__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_13709_13715 = state;
(statearr_13709_13715[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13700){
var G__13701 = cljs.core.first.call(null,seq13700);
var seq13700__$1 = cljs.core.next.call(null,seq13700);
var G__13702 = cljs.core.first.call(null,seq13700__$1);
var seq13700__$2 = cljs.core.next.call(null,seq13700__$1);
var G__13703 = cljs.core.first.call(null,seq13700__$2);
var seq13700__$3 = cljs.core.next.call(null,seq13700__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13701,G__13702,G__13703,seq13700__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async13881 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13881 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13882){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13882 = meta13882;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13881.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13883,meta13882__$1){
var self__ = this;
var _13883__$1 = this;
return (new cljs.core.async.t_cljs$core$async13881(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13882__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13881.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13883){
var self__ = this;
var _13883__$1 = this;
return self__.meta13882;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13881.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async13881.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13881.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async13881.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13881.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13881.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13881.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13881.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13881.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta13882","meta13882",-2110911338,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13881.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13881.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13881";

cljs.core.async.t_cljs$core$async13881.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13881");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async13881 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async13881(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13882){
return (new cljs.core.async.t_cljs$core$async13881(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13882));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async13881(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12283__auto___14046 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto___14046,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___14046,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_13983){
var state_val_13984 = (state_13983[(1)]);
if((state_val_13984 === (7))){
var inst_13899 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
var statearr_13985_14047 = state_13983__$1;
(statearr_13985_14047[(2)] = inst_13899);

(statearr_13985_14047[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (20))){
var inst_13911 = (state_13983[(7)]);
var state_13983__$1 = state_13983;
var statearr_13986_14048 = state_13983__$1;
(statearr_13986_14048[(2)] = inst_13911);

(statearr_13986_14048[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (27))){
var state_13983__$1 = state_13983;
var statearr_13987_14049 = state_13983__$1;
(statearr_13987_14049[(2)] = null);

(statearr_13987_14049[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (1))){
var inst_13887 = (state_13983[(8)]);
var inst_13887__$1 = calc_state.call(null);
var inst_13889 = (inst_13887__$1 == null);
var inst_13890 = cljs.core.not.call(null,inst_13889);
var state_13983__$1 = (function (){var statearr_13988 = state_13983;
(statearr_13988[(8)] = inst_13887__$1);

return statearr_13988;
})();
if(inst_13890){
var statearr_13989_14050 = state_13983__$1;
(statearr_13989_14050[(1)] = (2));

} else {
var statearr_13990_14051 = state_13983__$1;
(statearr_13990_14051[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (24))){
var inst_13957 = (state_13983[(9)]);
var inst_13934 = (state_13983[(10)]);
var inst_13943 = (state_13983[(11)]);
var inst_13957__$1 = inst_13934.call(null,inst_13943);
var state_13983__$1 = (function (){var statearr_13991 = state_13983;
(statearr_13991[(9)] = inst_13957__$1);

return statearr_13991;
})();
if(cljs.core.truth_(inst_13957__$1)){
var statearr_13992_14052 = state_13983__$1;
(statearr_13992_14052[(1)] = (29));

} else {
var statearr_13993_14053 = state_13983__$1;
(statearr_13993_14053[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (4))){
var inst_13902 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
if(cljs.core.truth_(inst_13902)){
var statearr_13994_14054 = state_13983__$1;
(statearr_13994_14054[(1)] = (8));

} else {
var statearr_13995_14055 = state_13983__$1;
(statearr_13995_14055[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (15))){
var inst_13928 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
if(cljs.core.truth_(inst_13928)){
var statearr_13996_14056 = state_13983__$1;
(statearr_13996_14056[(1)] = (19));

} else {
var statearr_13997_14057 = state_13983__$1;
(statearr_13997_14057[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (21))){
var inst_13933 = (state_13983[(12)]);
var inst_13933__$1 = (state_13983[(2)]);
var inst_13934 = cljs.core.get.call(null,inst_13933__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13935 = cljs.core.get.call(null,inst_13933__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13936 = cljs.core.get.call(null,inst_13933__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_13983__$1 = (function (){var statearr_13998 = state_13983;
(statearr_13998[(13)] = inst_13935);

(statearr_13998[(10)] = inst_13934);

(statearr_13998[(12)] = inst_13933__$1);

return statearr_13998;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_13983__$1,(22),inst_13936);
} else {
if((state_val_13984 === (31))){
var inst_13965 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
if(cljs.core.truth_(inst_13965)){
var statearr_13999_14058 = state_13983__$1;
(statearr_13999_14058[(1)] = (32));

} else {
var statearr_14000_14059 = state_13983__$1;
(statearr_14000_14059[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (32))){
var inst_13942 = (state_13983[(14)]);
var state_13983__$1 = state_13983;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13983__$1,(35),out,inst_13942);
} else {
if((state_val_13984 === (33))){
var inst_13933 = (state_13983[(12)]);
var inst_13911 = inst_13933;
var state_13983__$1 = (function (){var statearr_14001 = state_13983;
(statearr_14001[(7)] = inst_13911);

return statearr_14001;
})();
var statearr_14002_14060 = state_13983__$1;
(statearr_14002_14060[(2)] = null);

(statearr_14002_14060[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (13))){
var inst_13911 = (state_13983[(7)]);
var inst_13918 = inst_13911.cljs$lang$protocol_mask$partition0$;
var inst_13919 = (inst_13918 & (64));
var inst_13920 = inst_13911.cljs$core$ISeq$;
var inst_13921 = (inst_13919) || (inst_13920);
var state_13983__$1 = state_13983;
if(cljs.core.truth_(inst_13921)){
var statearr_14003_14061 = state_13983__$1;
(statearr_14003_14061[(1)] = (16));

} else {
var statearr_14004_14062 = state_13983__$1;
(statearr_14004_14062[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (22))){
var inst_13942 = (state_13983[(14)]);
var inst_13943 = (state_13983[(11)]);
var inst_13941 = (state_13983[(2)]);
var inst_13942__$1 = cljs.core.nth.call(null,inst_13941,(0),null);
var inst_13943__$1 = cljs.core.nth.call(null,inst_13941,(1),null);
var inst_13944 = (inst_13942__$1 == null);
var inst_13945 = cljs.core._EQ_.call(null,inst_13943__$1,change);
var inst_13946 = (inst_13944) || (inst_13945);
var state_13983__$1 = (function (){var statearr_14005 = state_13983;
(statearr_14005[(14)] = inst_13942__$1);

(statearr_14005[(11)] = inst_13943__$1);

return statearr_14005;
})();
if(cljs.core.truth_(inst_13946)){
var statearr_14006_14063 = state_13983__$1;
(statearr_14006_14063[(1)] = (23));

} else {
var statearr_14007_14064 = state_13983__$1;
(statearr_14007_14064[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (36))){
var inst_13933 = (state_13983[(12)]);
var inst_13911 = inst_13933;
var state_13983__$1 = (function (){var statearr_14008 = state_13983;
(statearr_14008[(7)] = inst_13911);

return statearr_14008;
})();
var statearr_14009_14065 = state_13983__$1;
(statearr_14009_14065[(2)] = null);

(statearr_14009_14065[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (29))){
var inst_13957 = (state_13983[(9)]);
var state_13983__$1 = state_13983;
var statearr_14010_14066 = state_13983__$1;
(statearr_14010_14066[(2)] = inst_13957);

(statearr_14010_14066[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (6))){
var state_13983__$1 = state_13983;
var statearr_14011_14067 = state_13983__$1;
(statearr_14011_14067[(2)] = false);

(statearr_14011_14067[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (28))){
var inst_13953 = (state_13983[(2)]);
var inst_13954 = calc_state.call(null);
var inst_13911 = inst_13954;
var state_13983__$1 = (function (){var statearr_14012 = state_13983;
(statearr_14012[(15)] = inst_13953);

(statearr_14012[(7)] = inst_13911);

return statearr_14012;
})();
var statearr_14013_14068 = state_13983__$1;
(statearr_14013_14068[(2)] = null);

(statearr_14013_14068[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (25))){
var inst_13979 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
var statearr_14014_14069 = state_13983__$1;
(statearr_14014_14069[(2)] = inst_13979);

(statearr_14014_14069[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (34))){
var inst_13977 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
var statearr_14015_14070 = state_13983__$1;
(statearr_14015_14070[(2)] = inst_13977);

(statearr_14015_14070[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (17))){
var state_13983__$1 = state_13983;
var statearr_14016_14071 = state_13983__$1;
(statearr_14016_14071[(2)] = false);

(statearr_14016_14071[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (3))){
var state_13983__$1 = state_13983;
var statearr_14017_14072 = state_13983__$1;
(statearr_14017_14072[(2)] = false);

(statearr_14017_14072[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (12))){
var inst_13981 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13983__$1,inst_13981);
} else {
if((state_val_13984 === (2))){
var inst_13887 = (state_13983[(8)]);
var inst_13892 = inst_13887.cljs$lang$protocol_mask$partition0$;
var inst_13893 = (inst_13892 & (64));
var inst_13894 = inst_13887.cljs$core$ISeq$;
var inst_13895 = (inst_13893) || (inst_13894);
var state_13983__$1 = state_13983;
if(cljs.core.truth_(inst_13895)){
var statearr_14018_14073 = state_13983__$1;
(statearr_14018_14073[(1)] = (5));

} else {
var statearr_14019_14074 = state_13983__$1;
(statearr_14019_14074[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (23))){
var inst_13942 = (state_13983[(14)]);
var inst_13948 = (inst_13942 == null);
var state_13983__$1 = state_13983;
if(cljs.core.truth_(inst_13948)){
var statearr_14020_14075 = state_13983__$1;
(statearr_14020_14075[(1)] = (26));

} else {
var statearr_14021_14076 = state_13983__$1;
(statearr_14021_14076[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (35))){
var inst_13968 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
if(cljs.core.truth_(inst_13968)){
var statearr_14022_14077 = state_13983__$1;
(statearr_14022_14077[(1)] = (36));

} else {
var statearr_14023_14078 = state_13983__$1;
(statearr_14023_14078[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (19))){
var inst_13911 = (state_13983[(7)]);
var inst_13930 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13911);
var state_13983__$1 = state_13983;
var statearr_14024_14079 = state_13983__$1;
(statearr_14024_14079[(2)] = inst_13930);

(statearr_14024_14079[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (11))){
var inst_13911 = (state_13983[(7)]);
var inst_13915 = (inst_13911 == null);
var inst_13916 = cljs.core.not.call(null,inst_13915);
var state_13983__$1 = state_13983;
if(inst_13916){
var statearr_14025_14080 = state_13983__$1;
(statearr_14025_14080[(1)] = (13));

} else {
var statearr_14026_14081 = state_13983__$1;
(statearr_14026_14081[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (9))){
var inst_13887 = (state_13983[(8)]);
var state_13983__$1 = state_13983;
var statearr_14027_14082 = state_13983__$1;
(statearr_14027_14082[(2)] = inst_13887);

(statearr_14027_14082[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (5))){
var state_13983__$1 = state_13983;
var statearr_14028_14083 = state_13983__$1;
(statearr_14028_14083[(2)] = true);

(statearr_14028_14083[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (14))){
var state_13983__$1 = state_13983;
var statearr_14029_14084 = state_13983__$1;
(statearr_14029_14084[(2)] = false);

(statearr_14029_14084[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (26))){
var inst_13943 = (state_13983[(11)]);
var inst_13950 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_13943);
var state_13983__$1 = state_13983;
var statearr_14030_14085 = state_13983__$1;
(statearr_14030_14085[(2)] = inst_13950);

(statearr_14030_14085[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (16))){
var state_13983__$1 = state_13983;
var statearr_14031_14086 = state_13983__$1;
(statearr_14031_14086[(2)] = true);

(statearr_14031_14086[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (38))){
var inst_13973 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
var statearr_14032_14087 = state_13983__$1;
(statearr_14032_14087[(2)] = inst_13973);

(statearr_14032_14087[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (30))){
var inst_13935 = (state_13983[(13)]);
var inst_13934 = (state_13983[(10)]);
var inst_13943 = (state_13983[(11)]);
var inst_13960 = cljs.core.empty_QMARK_.call(null,inst_13934);
var inst_13961 = inst_13935.call(null,inst_13943);
var inst_13962 = cljs.core.not.call(null,inst_13961);
var inst_13963 = (inst_13960) && (inst_13962);
var state_13983__$1 = state_13983;
var statearr_14033_14088 = state_13983__$1;
(statearr_14033_14088[(2)] = inst_13963);

(statearr_14033_14088[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (10))){
var inst_13887 = (state_13983[(8)]);
var inst_13907 = (state_13983[(2)]);
var inst_13908 = cljs.core.get.call(null,inst_13907,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13909 = cljs.core.get.call(null,inst_13907,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13910 = cljs.core.get.call(null,inst_13907,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13911 = inst_13887;
var state_13983__$1 = (function (){var statearr_14034 = state_13983;
(statearr_14034[(7)] = inst_13911);

(statearr_14034[(16)] = inst_13910);

(statearr_14034[(17)] = inst_13908);

(statearr_14034[(18)] = inst_13909);

return statearr_14034;
})();
var statearr_14035_14089 = state_13983__$1;
(statearr_14035_14089[(2)] = null);

(statearr_14035_14089[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (18))){
var inst_13925 = (state_13983[(2)]);
var state_13983__$1 = state_13983;
var statearr_14036_14090 = state_13983__$1;
(statearr_14036_14090[(2)] = inst_13925);

(statearr_14036_14090[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (37))){
var state_13983__$1 = state_13983;
var statearr_14037_14091 = state_13983__$1;
(statearr_14037_14091[(2)] = null);

(statearr_14037_14091[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13984 === (8))){
var inst_13887 = (state_13983[(8)]);
var inst_13904 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13887);
var state_13983__$1 = state_13983;
var statearr_14038_14092 = state_13983__$1;
(statearr_14038_14092[(2)] = inst_13904);

(statearr_14038_14092[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___14046,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__12171__auto__,c__12283__auto___14046,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__12172__auto__ = null;
var cljs$core$async$mix_$_state_machine__12172__auto____0 = (function (){
var statearr_14042 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14042[(0)] = cljs$core$async$mix_$_state_machine__12172__auto__);

(statearr_14042[(1)] = (1));

return statearr_14042;
});
var cljs$core$async$mix_$_state_machine__12172__auto____1 = (function (state_13983){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_13983);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e14043){if((e14043 instanceof Object)){
var ex__12175__auto__ = e14043;
var statearr_14044_14093 = state_13983;
(statearr_14044_14093[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13983);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14043;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14094 = state_13983;
state_13983 = G__14094;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12172__auto__ = function(state_13983){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12172__auto____1.call(this,state_13983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12172__auto____0;
cljs$core$async$mix_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12172__auto____1;
return cljs$core$async$mix_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___14046,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__12285__auto__ = (function (){var statearr_14045 = f__12284__auto__.call(null);
(statearr_14045[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___14046);

return statearr_14045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto___14046,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args14095 = [];
var len__7484__auto___14098 = arguments.length;
var i__7485__auto___14099 = (0);
while(true){
if((i__7485__auto___14099 < len__7484__auto___14098)){
args14095.push((arguments[i__7485__auto___14099]));

var G__14100 = (i__7485__auto___14099 + (1));
i__7485__auto___14099 = G__14100;
continue;
} else {
}
break;
}

var G__14097 = args14095.length;
switch (G__14097) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14095.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args14103 = [];
var len__7484__auto___14228 = arguments.length;
var i__7485__auto___14229 = (0);
while(true){
if((i__7485__auto___14229 < len__7484__auto___14228)){
args14103.push((arguments[i__7485__auto___14229]));

var G__14230 = (i__7485__auto___14229 + (1));
i__7485__auto___14229 = G__14230;
continue;
} else {
}
break;
}

var G__14105 = args14103.length;
switch (G__14105) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14103.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6409__auto__,mults){
return (function (p1__14102_SHARP_){
if(cljs.core.truth_(p1__14102_SHARP_.call(null,topic))){
return p1__14102_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__14102_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async14106 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14106 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta14107){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta14107 = meta14107;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14106.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_14108,meta14107__$1){
var self__ = this;
var _14108__$1 = this;
return (new cljs.core.async.t_cljs$core$async14106(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta14107__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14106.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_14108){
var self__ = this;
var _14108__$1 = this;
return self__.meta14107;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14106.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async14106.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14106.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async14106.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14106.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14106.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14106.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14106.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta14107","meta14107",33199402,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14106.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14106.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14106";

cljs.core.async.t_cljs$core$async14106.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14106");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async14106 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async14106(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta14107){
return (new cljs.core.async.t_cljs$core$async14106(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta14107));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async14106(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12283__auto___14232 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto___14232,mults,ensure_mult,p){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___14232,mults,ensure_mult,p){
return (function (state_14180){
var state_val_14181 = (state_14180[(1)]);
if((state_val_14181 === (7))){
var inst_14176 = (state_14180[(2)]);
var state_14180__$1 = state_14180;
var statearr_14182_14233 = state_14180__$1;
(statearr_14182_14233[(2)] = inst_14176);

(statearr_14182_14233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (20))){
var state_14180__$1 = state_14180;
var statearr_14183_14234 = state_14180__$1;
(statearr_14183_14234[(2)] = null);

(statearr_14183_14234[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (1))){
var state_14180__$1 = state_14180;
var statearr_14184_14235 = state_14180__$1;
(statearr_14184_14235[(2)] = null);

(statearr_14184_14235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (24))){
var inst_14159 = (state_14180[(7)]);
var inst_14168 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_14159);
var state_14180__$1 = state_14180;
var statearr_14185_14236 = state_14180__$1;
(statearr_14185_14236[(2)] = inst_14168);

(statearr_14185_14236[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (4))){
var inst_14111 = (state_14180[(8)]);
var inst_14111__$1 = (state_14180[(2)]);
var inst_14112 = (inst_14111__$1 == null);
var state_14180__$1 = (function (){var statearr_14186 = state_14180;
(statearr_14186[(8)] = inst_14111__$1);

return statearr_14186;
})();
if(cljs.core.truth_(inst_14112)){
var statearr_14187_14237 = state_14180__$1;
(statearr_14187_14237[(1)] = (5));

} else {
var statearr_14188_14238 = state_14180__$1;
(statearr_14188_14238[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (15))){
var inst_14153 = (state_14180[(2)]);
var state_14180__$1 = state_14180;
var statearr_14189_14239 = state_14180__$1;
(statearr_14189_14239[(2)] = inst_14153);

(statearr_14189_14239[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (21))){
var inst_14173 = (state_14180[(2)]);
var state_14180__$1 = (function (){var statearr_14190 = state_14180;
(statearr_14190[(9)] = inst_14173);

return statearr_14190;
})();
var statearr_14191_14240 = state_14180__$1;
(statearr_14191_14240[(2)] = null);

(statearr_14191_14240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (13))){
var inst_14135 = (state_14180[(10)]);
var inst_14137 = cljs.core.chunked_seq_QMARK_.call(null,inst_14135);
var state_14180__$1 = state_14180;
if(inst_14137){
var statearr_14192_14241 = state_14180__$1;
(statearr_14192_14241[(1)] = (16));

} else {
var statearr_14193_14242 = state_14180__$1;
(statearr_14193_14242[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (22))){
var inst_14165 = (state_14180[(2)]);
var state_14180__$1 = state_14180;
if(cljs.core.truth_(inst_14165)){
var statearr_14194_14243 = state_14180__$1;
(statearr_14194_14243[(1)] = (23));

} else {
var statearr_14195_14244 = state_14180__$1;
(statearr_14195_14244[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (6))){
var inst_14161 = (state_14180[(11)]);
var inst_14159 = (state_14180[(7)]);
var inst_14111 = (state_14180[(8)]);
var inst_14159__$1 = topic_fn.call(null,inst_14111);
var inst_14160 = cljs.core.deref.call(null,mults);
var inst_14161__$1 = cljs.core.get.call(null,inst_14160,inst_14159__$1);
var state_14180__$1 = (function (){var statearr_14196 = state_14180;
(statearr_14196[(11)] = inst_14161__$1);

(statearr_14196[(7)] = inst_14159__$1);

return statearr_14196;
})();
if(cljs.core.truth_(inst_14161__$1)){
var statearr_14197_14245 = state_14180__$1;
(statearr_14197_14245[(1)] = (19));

} else {
var statearr_14198_14246 = state_14180__$1;
(statearr_14198_14246[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (25))){
var inst_14170 = (state_14180[(2)]);
var state_14180__$1 = state_14180;
var statearr_14199_14247 = state_14180__$1;
(statearr_14199_14247[(2)] = inst_14170);

(statearr_14199_14247[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (17))){
var inst_14135 = (state_14180[(10)]);
var inst_14144 = cljs.core.first.call(null,inst_14135);
var inst_14145 = cljs.core.async.muxch_STAR_.call(null,inst_14144);
var inst_14146 = cljs.core.async.close_BANG_.call(null,inst_14145);
var inst_14147 = cljs.core.next.call(null,inst_14135);
var inst_14121 = inst_14147;
var inst_14122 = null;
var inst_14123 = (0);
var inst_14124 = (0);
var state_14180__$1 = (function (){var statearr_14200 = state_14180;
(statearr_14200[(12)] = inst_14121);

(statearr_14200[(13)] = inst_14123);

(statearr_14200[(14)] = inst_14122);

(statearr_14200[(15)] = inst_14146);

(statearr_14200[(16)] = inst_14124);

return statearr_14200;
})();
var statearr_14201_14248 = state_14180__$1;
(statearr_14201_14248[(2)] = null);

(statearr_14201_14248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (3))){
var inst_14178 = (state_14180[(2)]);
var state_14180__$1 = state_14180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14180__$1,inst_14178);
} else {
if((state_val_14181 === (12))){
var inst_14155 = (state_14180[(2)]);
var state_14180__$1 = state_14180;
var statearr_14202_14249 = state_14180__$1;
(statearr_14202_14249[(2)] = inst_14155);

(statearr_14202_14249[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (2))){
var state_14180__$1 = state_14180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14180__$1,(4),ch);
} else {
if((state_val_14181 === (23))){
var state_14180__$1 = state_14180;
var statearr_14203_14250 = state_14180__$1;
(statearr_14203_14250[(2)] = null);

(statearr_14203_14250[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (19))){
var inst_14161 = (state_14180[(11)]);
var inst_14111 = (state_14180[(8)]);
var inst_14163 = cljs.core.async.muxch_STAR_.call(null,inst_14161);
var state_14180__$1 = state_14180;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14180__$1,(22),inst_14163,inst_14111);
} else {
if((state_val_14181 === (11))){
var inst_14121 = (state_14180[(12)]);
var inst_14135 = (state_14180[(10)]);
var inst_14135__$1 = cljs.core.seq.call(null,inst_14121);
var state_14180__$1 = (function (){var statearr_14204 = state_14180;
(statearr_14204[(10)] = inst_14135__$1);

return statearr_14204;
})();
if(inst_14135__$1){
var statearr_14205_14251 = state_14180__$1;
(statearr_14205_14251[(1)] = (13));

} else {
var statearr_14206_14252 = state_14180__$1;
(statearr_14206_14252[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (9))){
var inst_14157 = (state_14180[(2)]);
var state_14180__$1 = state_14180;
var statearr_14207_14253 = state_14180__$1;
(statearr_14207_14253[(2)] = inst_14157);

(statearr_14207_14253[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (5))){
var inst_14118 = cljs.core.deref.call(null,mults);
var inst_14119 = cljs.core.vals.call(null,inst_14118);
var inst_14120 = cljs.core.seq.call(null,inst_14119);
var inst_14121 = inst_14120;
var inst_14122 = null;
var inst_14123 = (0);
var inst_14124 = (0);
var state_14180__$1 = (function (){var statearr_14208 = state_14180;
(statearr_14208[(12)] = inst_14121);

(statearr_14208[(13)] = inst_14123);

(statearr_14208[(14)] = inst_14122);

(statearr_14208[(16)] = inst_14124);

return statearr_14208;
})();
var statearr_14209_14254 = state_14180__$1;
(statearr_14209_14254[(2)] = null);

(statearr_14209_14254[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (14))){
var state_14180__$1 = state_14180;
var statearr_14213_14255 = state_14180__$1;
(statearr_14213_14255[(2)] = null);

(statearr_14213_14255[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (16))){
var inst_14135 = (state_14180[(10)]);
var inst_14139 = cljs.core.chunk_first.call(null,inst_14135);
var inst_14140 = cljs.core.chunk_rest.call(null,inst_14135);
var inst_14141 = cljs.core.count.call(null,inst_14139);
var inst_14121 = inst_14140;
var inst_14122 = inst_14139;
var inst_14123 = inst_14141;
var inst_14124 = (0);
var state_14180__$1 = (function (){var statearr_14214 = state_14180;
(statearr_14214[(12)] = inst_14121);

(statearr_14214[(13)] = inst_14123);

(statearr_14214[(14)] = inst_14122);

(statearr_14214[(16)] = inst_14124);

return statearr_14214;
})();
var statearr_14215_14256 = state_14180__$1;
(statearr_14215_14256[(2)] = null);

(statearr_14215_14256[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (10))){
var inst_14121 = (state_14180[(12)]);
var inst_14123 = (state_14180[(13)]);
var inst_14122 = (state_14180[(14)]);
var inst_14124 = (state_14180[(16)]);
var inst_14129 = cljs.core._nth.call(null,inst_14122,inst_14124);
var inst_14130 = cljs.core.async.muxch_STAR_.call(null,inst_14129);
var inst_14131 = cljs.core.async.close_BANG_.call(null,inst_14130);
var inst_14132 = (inst_14124 + (1));
var tmp14210 = inst_14121;
var tmp14211 = inst_14123;
var tmp14212 = inst_14122;
var inst_14121__$1 = tmp14210;
var inst_14122__$1 = tmp14212;
var inst_14123__$1 = tmp14211;
var inst_14124__$1 = inst_14132;
var state_14180__$1 = (function (){var statearr_14216 = state_14180;
(statearr_14216[(12)] = inst_14121__$1);

(statearr_14216[(13)] = inst_14123__$1);

(statearr_14216[(14)] = inst_14122__$1);

(statearr_14216[(16)] = inst_14124__$1);

(statearr_14216[(17)] = inst_14131);

return statearr_14216;
})();
var statearr_14217_14257 = state_14180__$1;
(statearr_14217_14257[(2)] = null);

(statearr_14217_14257[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (18))){
var inst_14150 = (state_14180[(2)]);
var state_14180__$1 = state_14180;
var statearr_14218_14258 = state_14180__$1;
(statearr_14218_14258[(2)] = inst_14150);

(statearr_14218_14258[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14181 === (8))){
var inst_14123 = (state_14180[(13)]);
var inst_14124 = (state_14180[(16)]);
var inst_14126 = (inst_14124 < inst_14123);
var inst_14127 = inst_14126;
var state_14180__$1 = state_14180;
if(cljs.core.truth_(inst_14127)){
var statearr_14219_14259 = state_14180__$1;
(statearr_14219_14259[(1)] = (10));

} else {
var statearr_14220_14260 = state_14180__$1;
(statearr_14220_14260[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___14232,mults,ensure_mult,p))
;
return ((function (switch__12171__auto__,c__12283__auto___14232,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_14224 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14224[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_14224[(1)] = (1));

return statearr_14224;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_14180){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_14180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e14225){if((e14225 instanceof Object)){
var ex__12175__auto__ = e14225;
var statearr_14226_14261 = state_14180;
(statearr_14226_14261[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14180);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14225;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14262 = state_14180;
state_14180 = G__14262;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_14180){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_14180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___14232,mults,ensure_mult,p))
})();
var state__12285__auto__ = (function (){var statearr_14227 = f__12284__auto__.call(null);
(statearr_14227[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___14232);

return statearr_14227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto___14232,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args14263 = [];
var len__7484__auto___14266 = arguments.length;
var i__7485__auto___14267 = (0);
while(true){
if((i__7485__auto___14267 < len__7484__auto___14266)){
args14263.push((arguments[i__7485__auto___14267]));

var G__14268 = (i__7485__auto___14267 + (1));
i__7485__auto___14267 = G__14268;
continue;
} else {
}
break;
}

var G__14265 = args14263.length;
switch (G__14265) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14263.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args14270 = [];
var len__7484__auto___14273 = arguments.length;
var i__7485__auto___14274 = (0);
while(true){
if((i__7485__auto___14274 < len__7484__auto___14273)){
args14270.push((arguments[i__7485__auto___14274]));

var G__14275 = (i__7485__auto___14274 + (1));
i__7485__auto___14274 = G__14275;
continue;
} else {
}
break;
}

var G__14272 = args14270.length;
switch (G__14272) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14270.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args14277 = [];
var len__7484__auto___14348 = arguments.length;
var i__7485__auto___14349 = (0);
while(true){
if((i__7485__auto___14349 < len__7484__auto___14348)){
args14277.push((arguments[i__7485__auto___14349]));

var G__14350 = (i__7485__auto___14349 + (1));
i__7485__auto___14349 = G__14350;
continue;
} else {
}
break;
}

var G__14279 = args14277.length;
switch (G__14279) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14277.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__12283__auto___14352 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto___14352,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___14352,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_14318){
var state_val_14319 = (state_14318[(1)]);
if((state_val_14319 === (7))){
var state_14318__$1 = state_14318;
var statearr_14320_14353 = state_14318__$1;
(statearr_14320_14353[(2)] = null);

(statearr_14320_14353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14319 === (1))){
var state_14318__$1 = state_14318;
var statearr_14321_14354 = state_14318__$1;
(statearr_14321_14354[(2)] = null);

(statearr_14321_14354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14319 === (4))){
var inst_14282 = (state_14318[(7)]);
var inst_14284 = (inst_14282 < cnt);
var state_14318__$1 = state_14318;
if(cljs.core.truth_(inst_14284)){
var statearr_14322_14355 = state_14318__$1;
(statearr_14322_14355[(1)] = (6));

} else {
var statearr_14323_14356 = state_14318__$1;
(statearr_14323_14356[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14319 === (15))){
var inst_14314 = (state_14318[(2)]);
var state_14318__$1 = state_14318;
var statearr_14324_14357 = state_14318__$1;
(statearr_14324_14357[(2)] = inst_14314);

(statearr_14324_14357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14319 === (13))){
var inst_14307 = cljs.core.async.close_BANG_.call(null,out);
var state_14318__$1 = state_14318;
var statearr_14325_14358 = state_14318__$1;
(statearr_14325_14358[(2)] = inst_14307);

(statearr_14325_14358[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14319 === (6))){
var state_14318__$1 = state_14318;
var statearr_14326_14359 = state_14318__$1;
(statearr_14326_14359[(2)] = null);

(statearr_14326_14359[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14319 === (3))){
var inst_14316 = (state_14318[(2)]);
var state_14318__$1 = state_14318;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14318__$1,inst_14316);
} else {
if((state_val_14319 === (12))){
var inst_14304 = (state_14318[(8)]);
var inst_14304__$1 = (state_14318[(2)]);
var inst_14305 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_14304__$1);
var state_14318__$1 = (function (){var statearr_14327 = state_14318;
(statearr_14327[(8)] = inst_14304__$1);

return statearr_14327;
})();
if(cljs.core.truth_(inst_14305)){
var statearr_14328_14360 = state_14318__$1;
(statearr_14328_14360[(1)] = (13));

} else {
var statearr_14329_14361 = state_14318__$1;
(statearr_14329_14361[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14319 === (2))){
var inst_14281 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_14282 = (0);
var state_14318__$1 = (function (){var statearr_14330 = state_14318;
(statearr_14330[(7)] = inst_14282);

(statearr_14330[(9)] = inst_14281);

return statearr_14330;
})();
var statearr_14331_14362 = state_14318__$1;
(statearr_14331_14362[(2)] = null);

(statearr_14331_14362[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14319 === (11))){
var inst_14282 = (state_14318[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_14318,(10),Object,null,(9));
var inst_14291 = chs__$1.call(null,inst_14282);
var inst_14292 = done.call(null,inst_14282);
var inst_14293 = cljs.core.async.take_BANG_.call(null,inst_14291,inst_14292);
var state_14318__$1 = state_14318;
var statearr_14332_14363 = state_14318__$1;
(statearr_14332_14363[(2)] = inst_14293);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14318__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14319 === (9))){
var inst_14282 = (state_14318[(7)]);
var inst_14295 = (state_14318[(2)]);
var inst_14296 = (inst_14282 + (1));
var inst_14282__$1 = inst_14296;
var state_14318__$1 = (function (){var statearr_14333 = state_14318;
(statearr_14333[(7)] = inst_14282__$1);

(statearr_14333[(10)] = inst_14295);

return statearr_14333;
})();
var statearr_14334_14364 = state_14318__$1;
(statearr_14334_14364[(2)] = null);

(statearr_14334_14364[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14319 === (5))){
var inst_14302 = (state_14318[(2)]);
var state_14318__$1 = (function (){var statearr_14335 = state_14318;
(statearr_14335[(11)] = inst_14302);

return statearr_14335;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14318__$1,(12),dchan);
} else {
if((state_val_14319 === (14))){
var inst_14304 = (state_14318[(8)]);
var inst_14309 = cljs.core.apply.call(null,f,inst_14304);
var state_14318__$1 = state_14318;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14318__$1,(16),out,inst_14309);
} else {
if((state_val_14319 === (16))){
var inst_14311 = (state_14318[(2)]);
var state_14318__$1 = (function (){var statearr_14336 = state_14318;
(statearr_14336[(12)] = inst_14311);

return statearr_14336;
})();
var statearr_14337_14365 = state_14318__$1;
(statearr_14337_14365[(2)] = null);

(statearr_14337_14365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14319 === (10))){
var inst_14286 = (state_14318[(2)]);
var inst_14287 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_14318__$1 = (function (){var statearr_14338 = state_14318;
(statearr_14338[(13)] = inst_14286);

return statearr_14338;
})();
var statearr_14339_14366 = state_14318__$1;
(statearr_14339_14366[(2)] = inst_14287);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14318__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14319 === (8))){
var inst_14300 = (state_14318[(2)]);
var state_14318__$1 = state_14318;
var statearr_14340_14367 = state_14318__$1;
(statearr_14340_14367[(2)] = inst_14300);

(statearr_14340_14367[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___14352,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__12171__auto__,c__12283__auto___14352,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_14344 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14344[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_14344[(1)] = (1));

return statearr_14344;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_14318){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_14318);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e14345){if((e14345 instanceof Object)){
var ex__12175__auto__ = e14345;
var statearr_14346_14368 = state_14318;
(statearr_14346_14368[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14318);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14345;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14369 = state_14318;
state_14318 = G__14369;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_14318){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_14318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___14352,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__12285__auto__ = (function (){var statearr_14347 = f__12284__auto__.call(null);
(statearr_14347[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___14352);

return statearr_14347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto___14352,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args14371 = [];
var len__7484__auto___14429 = arguments.length;
var i__7485__auto___14430 = (0);
while(true){
if((i__7485__auto___14430 < len__7484__auto___14429)){
args14371.push((arguments[i__7485__auto___14430]));

var G__14431 = (i__7485__auto___14430 + (1));
i__7485__auto___14430 = G__14431;
continue;
} else {
}
break;
}

var G__14373 = args14371.length;
switch (G__14373) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14371.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12283__auto___14433 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto___14433,out){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___14433,out){
return (function (state_14405){
var state_val_14406 = (state_14405[(1)]);
if((state_val_14406 === (7))){
var inst_14385 = (state_14405[(7)]);
var inst_14384 = (state_14405[(8)]);
var inst_14384__$1 = (state_14405[(2)]);
var inst_14385__$1 = cljs.core.nth.call(null,inst_14384__$1,(0),null);
var inst_14386 = cljs.core.nth.call(null,inst_14384__$1,(1),null);
var inst_14387 = (inst_14385__$1 == null);
var state_14405__$1 = (function (){var statearr_14407 = state_14405;
(statearr_14407[(9)] = inst_14386);

(statearr_14407[(7)] = inst_14385__$1);

(statearr_14407[(8)] = inst_14384__$1);

return statearr_14407;
})();
if(cljs.core.truth_(inst_14387)){
var statearr_14408_14434 = state_14405__$1;
(statearr_14408_14434[(1)] = (8));

} else {
var statearr_14409_14435 = state_14405__$1;
(statearr_14409_14435[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14406 === (1))){
var inst_14374 = cljs.core.vec.call(null,chs);
var inst_14375 = inst_14374;
var state_14405__$1 = (function (){var statearr_14410 = state_14405;
(statearr_14410[(10)] = inst_14375);

return statearr_14410;
})();
var statearr_14411_14436 = state_14405__$1;
(statearr_14411_14436[(2)] = null);

(statearr_14411_14436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14406 === (4))){
var inst_14375 = (state_14405[(10)]);
var state_14405__$1 = state_14405;
return cljs.core.async.ioc_alts_BANG_.call(null,state_14405__$1,(7),inst_14375);
} else {
if((state_val_14406 === (6))){
var inst_14401 = (state_14405[(2)]);
var state_14405__$1 = state_14405;
var statearr_14412_14437 = state_14405__$1;
(statearr_14412_14437[(2)] = inst_14401);

(statearr_14412_14437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14406 === (3))){
var inst_14403 = (state_14405[(2)]);
var state_14405__$1 = state_14405;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14405__$1,inst_14403);
} else {
if((state_val_14406 === (2))){
var inst_14375 = (state_14405[(10)]);
var inst_14377 = cljs.core.count.call(null,inst_14375);
var inst_14378 = (inst_14377 > (0));
var state_14405__$1 = state_14405;
if(cljs.core.truth_(inst_14378)){
var statearr_14414_14438 = state_14405__$1;
(statearr_14414_14438[(1)] = (4));

} else {
var statearr_14415_14439 = state_14405__$1;
(statearr_14415_14439[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14406 === (11))){
var inst_14375 = (state_14405[(10)]);
var inst_14394 = (state_14405[(2)]);
var tmp14413 = inst_14375;
var inst_14375__$1 = tmp14413;
var state_14405__$1 = (function (){var statearr_14416 = state_14405;
(statearr_14416[(11)] = inst_14394);

(statearr_14416[(10)] = inst_14375__$1);

return statearr_14416;
})();
var statearr_14417_14440 = state_14405__$1;
(statearr_14417_14440[(2)] = null);

(statearr_14417_14440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14406 === (9))){
var inst_14385 = (state_14405[(7)]);
var state_14405__$1 = state_14405;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14405__$1,(11),out,inst_14385);
} else {
if((state_val_14406 === (5))){
var inst_14399 = cljs.core.async.close_BANG_.call(null,out);
var state_14405__$1 = state_14405;
var statearr_14418_14441 = state_14405__$1;
(statearr_14418_14441[(2)] = inst_14399);

(statearr_14418_14441[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14406 === (10))){
var inst_14397 = (state_14405[(2)]);
var state_14405__$1 = state_14405;
var statearr_14419_14442 = state_14405__$1;
(statearr_14419_14442[(2)] = inst_14397);

(statearr_14419_14442[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14406 === (8))){
var inst_14386 = (state_14405[(9)]);
var inst_14385 = (state_14405[(7)]);
var inst_14384 = (state_14405[(8)]);
var inst_14375 = (state_14405[(10)]);
var inst_14389 = (function (){var cs = inst_14375;
var vec__14380 = inst_14384;
var v = inst_14385;
var c = inst_14386;
return ((function (cs,vec__14380,v,c,inst_14386,inst_14385,inst_14384,inst_14375,state_val_14406,c__12283__auto___14433,out){
return (function (p1__14370_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__14370_SHARP_);
});
;})(cs,vec__14380,v,c,inst_14386,inst_14385,inst_14384,inst_14375,state_val_14406,c__12283__auto___14433,out))
})();
var inst_14390 = cljs.core.filterv.call(null,inst_14389,inst_14375);
var inst_14375__$1 = inst_14390;
var state_14405__$1 = (function (){var statearr_14420 = state_14405;
(statearr_14420[(10)] = inst_14375__$1);

return statearr_14420;
})();
var statearr_14421_14443 = state_14405__$1;
(statearr_14421_14443[(2)] = null);

(statearr_14421_14443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___14433,out))
;
return ((function (switch__12171__auto__,c__12283__auto___14433,out){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_14425 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14425[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_14425[(1)] = (1));

return statearr_14425;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_14405){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_14405);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e14426){if((e14426 instanceof Object)){
var ex__12175__auto__ = e14426;
var statearr_14427_14444 = state_14405;
(statearr_14427_14444[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14405);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14426;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14445 = state_14405;
state_14405 = G__14445;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_14405){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_14405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___14433,out))
})();
var state__12285__auto__ = (function (){var statearr_14428 = f__12284__auto__.call(null);
(statearr_14428[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___14433);

return statearr_14428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto___14433,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args14446 = [];
var len__7484__auto___14495 = arguments.length;
var i__7485__auto___14496 = (0);
while(true){
if((i__7485__auto___14496 < len__7484__auto___14495)){
args14446.push((arguments[i__7485__auto___14496]));

var G__14497 = (i__7485__auto___14496 + (1));
i__7485__auto___14496 = G__14497;
continue;
} else {
}
break;
}

var G__14448 = args14446.length;
switch (G__14448) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14446.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12283__auto___14499 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto___14499,out){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___14499,out){
return (function (state_14472){
var state_val_14473 = (state_14472[(1)]);
if((state_val_14473 === (7))){
var inst_14454 = (state_14472[(7)]);
var inst_14454__$1 = (state_14472[(2)]);
var inst_14455 = (inst_14454__$1 == null);
var inst_14456 = cljs.core.not.call(null,inst_14455);
var state_14472__$1 = (function (){var statearr_14474 = state_14472;
(statearr_14474[(7)] = inst_14454__$1);

return statearr_14474;
})();
if(inst_14456){
var statearr_14475_14500 = state_14472__$1;
(statearr_14475_14500[(1)] = (8));

} else {
var statearr_14476_14501 = state_14472__$1;
(statearr_14476_14501[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14473 === (1))){
var inst_14449 = (0);
var state_14472__$1 = (function (){var statearr_14477 = state_14472;
(statearr_14477[(8)] = inst_14449);

return statearr_14477;
})();
var statearr_14478_14502 = state_14472__$1;
(statearr_14478_14502[(2)] = null);

(statearr_14478_14502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14473 === (4))){
var state_14472__$1 = state_14472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14472__$1,(7),ch);
} else {
if((state_val_14473 === (6))){
var inst_14467 = (state_14472[(2)]);
var state_14472__$1 = state_14472;
var statearr_14479_14503 = state_14472__$1;
(statearr_14479_14503[(2)] = inst_14467);

(statearr_14479_14503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14473 === (3))){
var inst_14469 = (state_14472[(2)]);
var inst_14470 = cljs.core.async.close_BANG_.call(null,out);
var state_14472__$1 = (function (){var statearr_14480 = state_14472;
(statearr_14480[(9)] = inst_14469);

return statearr_14480;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14472__$1,inst_14470);
} else {
if((state_val_14473 === (2))){
var inst_14449 = (state_14472[(8)]);
var inst_14451 = (inst_14449 < n);
var state_14472__$1 = state_14472;
if(cljs.core.truth_(inst_14451)){
var statearr_14481_14504 = state_14472__$1;
(statearr_14481_14504[(1)] = (4));

} else {
var statearr_14482_14505 = state_14472__$1;
(statearr_14482_14505[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14473 === (11))){
var inst_14449 = (state_14472[(8)]);
var inst_14459 = (state_14472[(2)]);
var inst_14460 = (inst_14449 + (1));
var inst_14449__$1 = inst_14460;
var state_14472__$1 = (function (){var statearr_14483 = state_14472;
(statearr_14483[(8)] = inst_14449__$1);

(statearr_14483[(10)] = inst_14459);

return statearr_14483;
})();
var statearr_14484_14506 = state_14472__$1;
(statearr_14484_14506[(2)] = null);

(statearr_14484_14506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14473 === (9))){
var state_14472__$1 = state_14472;
var statearr_14485_14507 = state_14472__$1;
(statearr_14485_14507[(2)] = null);

(statearr_14485_14507[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14473 === (5))){
var state_14472__$1 = state_14472;
var statearr_14486_14508 = state_14472__$1;
(statearr_14486_14508[(2)] = null);

(statearr_14486_14508[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14473 === (10))){
var inst_14464 = (state_14472[(2)]);
var state_14472__$1 = state_14472;
var statearr_14487_14509 = state_14472__$1;
(statearr_14487_14509[(2)] = inst_14464);

(statearr_14487_14509[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14473 === (8))){
var inst_14454 = (state_14472[(7)]);
var state_14472__$1 = state_14472;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14472__$1,(11),out,inst_14454);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___14499,out))
;
return ((function (switch__12171__auto__,c__12283__auto___14499,out){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_14491 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14491[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_14491[(1)] = (1));

return statearr_14491;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_14472){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_14472);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e14492){if((e14492 instanceof Object)){
var ex__12175__auto__ = e14492;
var statearr_14493_14510 = state_14472;
(statearr_14493_14510[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14472);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14492;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14511 = state_14472;
state_14472 = G__14511;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_14472){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_14472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___14499,out))
})();
var state__12285__auto__ = (function (){var statearr_14494 = f__12284__auto__.call(null);
(statearr_14494[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___14499);

return statearr_14494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto___14499,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async14519 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14519 = (function (map_LT_,f,ch,meta14520){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14520 = meta14520;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14519.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14521,meta14520__$1){
var self__ = this;
var _14521__$1 = this;
return (new cljs.core.async.t_cljs$core$async14519(self__.map_LT_,self__.f,self__.ch,meta14520__$1));
});

cljs.core.async.t_cljs$core$async14519.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14521){
var self__ = this;
var _14521__$1 = this;
return self__.meta14520;
});

cljs.core.async.t_cljs$core$async14519.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14519.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14519.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14519.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14519.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async14522 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14522 = (function (map_LT_,f,ch,meta14520,_,fn1,meta14523){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14520 = meta14520;
this._ = _;
this.fn1 = fn1;
this.meta14523 = meta14523;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14522.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_14524,meta14523__$1){
var self__ = this;
var _14524__$1 = this;
return (new cljs.core.async.t_cljs$core$async14522(self__.map_LT_,self__.f,self__.ch,self__.meta14520,self__._,self__.fn1,meta14523__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async14522.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_14524){
var self__ = this;
var _14524__$1 = this;
return self__.meta14523;
});})(___$1))
;

cljs.core.async.t_cljs$core$async14522.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14522.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async14522.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async14522.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__14512_SHARP_){
return f1.call(null,(((p1__14512_SHARP_ == null))?null:self__.f.call(null,p1__14512_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async14522.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14520","meta14520",1475010453,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async14519","cljs.core.async/t_cljs$core$async14519",-103435293,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta14523","meta14523",-1321139597,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async14522.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14522.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14522";

cljs.core.async.t_cljs$core$async14522.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14522");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async14522 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14522(map_LT___$1,f__$1,ch__$1,meta14520__$1,___$2,fn1__$1,meta14523){
return (new cljs.core.async.t_cljs$core$async14522(map_LT___$1,f__$1,ch__$1,meta14520__$1,___$2,fn1__$1,meta14523));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async14522(self__.map_LT_,self__.f,self__.ch,self__.meta14520,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async14519.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14519.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async14519.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14520","meta14520",1475010453,null)], null);
});

cljs.core.async.t_cljs$core$async14519.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14519.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14519";

cljs.core.async.t_cljs$core$async14519.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14519");
});

cljs.core.async.__GT_t_cljs$core$async14519 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14519(map_LT___$1,f__$1,ch__$1,meta14520){
return (new cljs.core.async.t_cljs$core$async14519(map_LT___$1,f__$1,ch__$1,meta14520));
});

}

return (new cljs.core.async.t_cljs$core$async14519(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async14528 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14528 = (function (map_GT_,f,ch,meta14529){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta14529 = meta14529;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14528.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14530,meta14529__$1){
var self__ = this;
var _14530__$1 = this;
return (new cljs.core.async.t_cljs$core$async14528(self__.map_GT_,self__.f,self__.ch,meta14529__$1));
});

cljs.core.async.t_cljs$core$async14528.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14530){
var self__ = this;
var _14530__$1 = this;
return self__.meta14529;
});

cljs.core.async.t_cljs$core$async14528.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14528.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14528.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14528.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async14528.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14528.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async14528.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14529","meta14529",-1812467128,null)], null);
});

cljs.core.async.t_cljs$core$async14528.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14528.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14528";

cljs.core.async.t_cljs$core$async14528.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14528");
});

cljs.core.async.__GT_t_cljs$core$async14528 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async14528(map_GT___$1,f__$1,ch__$1,meta14529){
return (new cljs.core.async.t_cljs$core$async14528(map_GT___$1,f__$1,ch__$1,meta14529));
});

}

return (new cljs.core.async.t_cljs$core$async14528(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async14534 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14534 = (function (filter_GT_,p,ch,meta14535){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta14535 = meta14535;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14534.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14536,meta14535__$1){
var self__ = this;
var _14536__$1 = this;
return (new cljs.core.async.t_cljs$core$async14534(self__.filter_GT_,self__.p,self__.ch,meta14535__$1));
});

cljs.core.async.t_cljs$core$async14534.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14536){
var self__ = this;
var _14536__$1 = this;
return self__.meta14535;
});

cljs.core.async.t_cljs$core$async14534.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14534.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14534.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14534.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14534.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async14534.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14534.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async14534.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14535","meta14535",1247762447,null)], null);
});

cljs.core.async.t_cljs$core$async14534.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14534.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14534";

cljs.core.async.t_cljs$core$async14534.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14534");
});

cljs.core.async.__GT_t_cljs$core$async14534 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async14534(filter_GT___$1,p__$1,ch__$1,meta14535){
return (new cljs.core.async.t_cljs$core$async14534(filter_GT___$1,p__$1,ch__$1,meta14535));
});

}

return (new cljs.core.async.t_cljs$core$async14534(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args14537 = [];
var len__7484__auto___14581 = arguments.length;
var i__7485__auto___14582 = (0);
while(true){
if((i__7485__auto___14582 < len__7484__auto___14581)){
args14537.push((arguments[i__7485__auto___14582]));

var G__14583 = (i__7485__auto___14582 + (1));
i__7485__auto___14582 = G__14583;
continue;
} else {
}
break;
}

var G__14539 = args14537.length;
switch (G__14539) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14537.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12283__auto___14585 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto___14585,out){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___14585,out){
return (function (state_14560){
var state_val_14561 = (state_14560[(1)]);
if((state_val_14561 === (7))){
var inst_14556 = (state_14560[(2)]);
var state_14560__$1 = state_14560;
var statearr_14562_14586 = state_14560__$1;
(statearr_14562_14586[(2)] = inst_14556);

(statearr_14562_14586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14561 === (1))){
var state_14560__$1 = state_14560;
var statearr_14563_14587 = state_14560__$1;
(statearr_14563_14587[(2)] = null);

(statearr_14563_14587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14561 === (4))){
var inst_14542 = (state_14560[(7)]);
var inst_14542__$1 = (state_14560[(2)]);
var inst_14543 = (inst_14542__$1 == null);
var state_14560__$1 = (function (){var statearr_14564 = state_14560;
(statearr_14564[(7)] = inst_14542__$1);

return statearr_14564;
})();
if(cljs.core.truth_(inst_14543)){
var statearr_14565_14588 = state_14560__$1;
(statearr_14565_14588[(1)] = (5));

} else {
var statearr_14566_14589 = state_14560__$1;
(statearr_14566_14589[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14561 === (6))){
var inst_14542 = (state_14560[(7)]);
var inst_14547 = p.call(null,inst_14542);
var state_14560__$1 = state_14560;
if(cljs.core.truth_(inst_14547)){
var statearr_14567_14590 = state_14560__$1;
(statearr_14567_14590[(1)] = (8));

} else {
var statearr_14568_14591 = state_14560__$1;
(statearr_14568_14591[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14561 === (3))){
var inst_14558 = (state_14560[(2)]);
var state_14560__$1 = state_14560;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14560__$1,inst_14558);
} else {
if((state_val_14561 === (2))){
var state_14560__$1 = state_14560;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14560__$1,(4),ch);
} else {
if((state_val_14561 === (11))){
var inst_14550 = (state_14560[(2)]);
var state_14560__$1 = state_14560;
var statearr_14569_14592 = state_14560__$1;
(statearr_14569_14592[(2)] = inst_14550);

(statearr_14569_14592[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14561 === (9))){
var state_14560__$1 = state_14560;
var statearr_14570_14593 = state_14560__$1;
(statearr_14570_14593[(2)] = null);

(statearr_14570_14593[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14561 === (5))){
var inst_14545 = cljs.core.async.close_BANG_.call(null,out);
var state_14560__$1 = state_14560;
var statearr_14571_14594 = state_14560__$1;
(statearr_14571_14594[(2)] = inst_14545);

(statearr_14571_14594[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14561 === (10))){
var inst_14553 = (state_14560[(2)]);
var state_14560__$1 = (function (){var statearr_14572 = state_14560;
(statearr_14572[(8)] = inst_14553);

return statearr_14572;
})();
var statearr_14573_14595 = state_14560__$1;
(statearr_14573_14595[(2)] = null);

(statearr_14573_14595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14561 === (8))){
var inst_14542 = (state_14560[(7)]);
var state_14560__$1 = state_14560;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14560__$1,(11),out,inst_14542);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___14585,out))
;
return ((function (switch__12171__auto__,c__12283__auto___14585,out){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_14577 = [null,null,null,null,null,null,null,null,null];
(statearr_14577[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_14577[(1)] = (1));

return statearr_14577;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_14560){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_14560);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e14578){if((e14578 instanceof Object)){
var ex__12175__auto__ = e14578;
var statearr_14579_14596 = state_14560;
(statearr_14579_14596[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14560);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14578;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14597 = state_14560;
state_14560 = G__14597;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_14560){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_14560);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___14585,out))
})();
var state__12285__auto__ = (function (){var statearr_14580 = f__12284__auto__.call(null);
(statearr_14580[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___14585);

return statearr_14580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto___14585,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args14598 = [];
var len__7484__auto___14601 = arguments.length;
var i__7485__auto___14602 = (0);
while(true){
if((i__7485__auto___14602 < len__7484__auto___14601)){
args14598.push((arguments[i__7485__auto___14602]));

var G__14603 = (i__7485__auto___14602 + (1));
i__7485__auto___14602 = G__14603;
continue;
} else {
}
break;
}

var G__14600 = args14598.length;
switch (G__14600) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14598.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12283__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto__){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__){
return (function (state_14770){
var state_val_14771 = (state_14770[(1)]);
if((state_val_14771 === (7))){
var inst_14766 = (state_14770[(2)]);
var state_14770__$1 = state_14770;
var statearr_14772_14813 = state_14770__$1;
(statearr_14772_14813[(2)] = inst_14766);

(statearr_14772_14813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (20))){
var inst_14736 = (state_14770[(7)]);
var inst_14747 = (state_14770[(2)]);
var inst_14748 = cljs.core.next.call(null,inst_14736);
var inst_14722 = inst_14748;
var inst_14723 = null;
var inst_14724 = (0);
var inst_14725 = (0);
var state_14770__$1 = (function (){var statearr_14773 = state_14770;
(statearr_14773[(8)] = inst_14747);

(statearr_14773[(9)] = inst_14725);

(statearr_14773[(10)] = inst_14724);

(statearr_14773[(11)] = inst_14722);

(statearr_14773[(12)] = inst_14723);

return statearr_14773;
})();
var statearr_14774_14814 = state_14770__$1;
(statearr_14774_14814[(2)] = null);

(statearr_14774_14814[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (1))){
var state_14770__$1 = state_14770;
var statearr_14775_14815 = state_14770__$1;
(statearr_14775_14815[(2)] = null);

(statearr_14775_14815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (4))){
var inst_14711 = (state_14770[(13)]);
var inst_14711__$1 = (state_14770[(2)]);
var inst_14712 = (inst_14711__$1 == null);
var state_14770__$1 = (function (){var statearr_14776 = state_14770;
(statearr_14776[(13)] = inst_14711__$1);

return statearr_14776;
})();
if(cljs.core.truth_(inst_14712)){
var statearr_14777_14816 = state_14770__$1;
(statearr_14777_14816[(1)] = (5));

} else {
var statearr_14778_14817 = state_14770__$1;
(statearr_14778_14817[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (15))){
var state_14770__$1 = state_14770;
var statearr_14782_14818 = state_14770__$1;
(statearr_14782_14818[(2)] = null);

(statearr_14782_14818[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (21))){
var state_14770__$1 = state_14770;
var statearr_14783_14819 = state_14770__$1;
(statearr_14783_14819[(2)] = null);

(statearr_14783_14819[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (13))){
var inst_14725 = (state_14770[(9)]);
var inst_14724 = (state_14770[(10)]);
var inst_14722 = (state_14770[(11)]);
var inst_14723 = (state_14770[(12)]);
var inst_14732 = (state_14770[(2)]);
var inst_14733 = (inst_14725 + (1));
var tmp14779 = inst_14724;
var tmp14780 = inst_14722;
var tmp14781 = inst_14723;
var inst_14722__$1 = tmp14780;
var inst_14723__$1 = tmp14781;
var inst_14724__$1 = tmp14779;
var inst_14725__$1 = inst_14733;
var state_14770__$1 = (function (){var statearr_14784 = state_14770;
(statearr_14784[(9)] = inst_14725__$1);

(statearr_14784[(10)] = inst_14724__$1);

(statearr_14784[(11)] = inst_14722__$1);

(statearr_14784[(12)] = inst_14723__$1);

(statearr_14784[(14)] = inst_14732);

return statearr_14784;
})();
var statearr_14785_14820 = state_14770__$1;
(statearr_14785_14820[(2)] = null);

(statearr_14785_14820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (22))){
var state_14770__$1 = state_14770;
var statearr_14786_14821 = state_14770__$1;
(statearr_14786_14821[(2)] = null);

(statearr_14786_14821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (6))){
var inst_14711 = (state_14770[(13)]);
var inst_14720 = f.call(null,inst_14711);
var inst_14721 = cljs.core.seq.call(null,inst_14720);
var inst_14722 = inst_14721;
var inst_14723 = null;
var inst_14724 = (0);
var inst_14725 = (0);
var state_14770__$1 = (function (){var statearr_14787 = state_14770;
(statearr_14787[(9)] = inst_14725);

(statearr_14787[(10)] = inst_14724);

(statearr_14787[(11)] = inst_14722);

(statearr_14787[(12)] = inst_14723);

return statearr_14787;
})();
var statearr_14788_14822 = state_14770__$1;
(statearr_14788_14822[(2)] = null);

(statearr_14788_14822[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (17))){
var inst_14736 = (state_14770[(7)]);
var inst_14740 = cljs.core.chunk_first.call(null,inst_14736);
var inst_14741 = cljs.core.chunk_rest.call(null,inst_14736);
var inst_14742 = cljs.core.count.call(null,inst_14740);
var inst_14722 = inst_14741;
var inst_14723 = inst_14740;
var inst_14724 = inst_14742;
var inst_14725 = (0);
var state_14770__$1 = (function (){var statearr_14789 = state_14770;
(statearr_14789[(9)] = inst_14725);

(statearr_14789[(10)] = inst_14724);

(statearr_14789[(11)] = inst_14722);

(statearr_14789[(12)] = inst_14723);

return statearr_14789;
})();
var statearr_14790_14823 = state_14770__$1;
(statearr_14790_14823[(2)] = null);

(statearr_14790_14823[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (3))){
var inst_14768 = (state_14770[(2)]);
var state_14770__$1 = state_14770;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14770__$1,inst_14768);
} else {
if((state_val_14771 === (12))){
var inst_14756 = (state_14770[(2)]);
var state_14770__$1 = state_14770;
var statearr_14791_14824 = state_14770__$1;
(statearr_14791_14824[(2)] = inst_14756);

(statearr_14791_14824[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (2))){
var state_14770__$1 = state_14770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14770__$1,(4),in$);
} else {
if((state_val_14771 === (23))){
var inst_14764 = (state_14770[(2)]);
var state_14770__$1 = state_14770;
var statearr_14792_14825 = state_14770__$1;
(statearr_14792_14825[(2)] = inst_14764);

(statearr_14792_14825[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (19))){
var inst_14751 = (state_14770[(2)]);
var state_14770__$1 = state_14770;
var statearr_14793_14826 = state_14770__$1;
(statearr_14793_14826[(2)] = inst_14751);

(statearr_14793_14826[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (11))){
var inst_14736 = (state_14770[(7)]);
var inst_14722 = (state_14770[(11)]);
var inst_14736__$1 = cljs.core.seq.call(null,inst_14722);
var state_14770__$1 = (function (){var statearr_14794 = state_14770;
(statearr_14794[(7)] = inst_14736__$1);

return statearr_14794;
})();
if(inst_14736__$1){
var statearr_14795_14827 = state_14770__$1;
(statearr_14795_14827[(1)] = (14));

} else {
var statearr_14796_14828 = state_14770__$1;
(statearr_14796_14828[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (9))){
var inst_14758 = (state_14770[(2)]);
var inst_14759 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_14770__$1 = (function (){var statearr_14797 = state_14770;
(statearr_14797[(15)] = inst_14758);

return statearr_14797;
})();
if(cljs.core.truth_(inst_14759)){
var statearr_14798_14829 = state_14770__$1;
(statearr_14798_14829[(1)] = (21));

} else {
var statearr_14799_14830 = state_14770__$1;
(statearr_14799_14830[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (5))){
var inst_14714 = cljs.core.async.close_BANG_.call(null,out);
var state_14770__$1 = state_14770;
var statearr_14800_14831 = state_14770__$1;
(statearr_14800_14831[(2)] = inst_14714);

(statearr_14800_14831[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (14))){
var inst_14736 = (state_14770[(7)]);
var inst_14738 = cljs.core.chunked_seq_QMARK_.call(null,inst_14736);
var state_14770__$1 = state_14770;
if(inst_14738){
var statearr_14801_14832 = state_14770__$1;
(statearr_14801_14832[(1)] = (17));

} else {
var statearr_14802_14833 = state_14770__$1;
(statearr_14802_14833[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (16))){
var inst_14754 = (state_14770[(2)]);
var state_14770__$1 = state_14770;
var statearr_14803_14834 = state_14770__$1;
(statearr_14803_14834[(2)] = inst_14754);

(statearr_14803_14834[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14771 === (10))){
var inst_14725 = (state_14770[(9)]);
var inst_14723 = (state_14770[(12)]);
var inst_14730 = cljs.core._nth.call(null,inst_14723,inst_14725);
var state_14770__$1 = state_14770;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14770__$1,(13),out,inst_14730);
} else {
if((state_val_14771 === (18))){
var inst_14736 = (state_14770[(7)]);
var inst_14745 = cljs.core.first.call(null,inst_14736);
var state_14770__$1 = state_14770;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14770__$1,(20),out,inst_14745);
} else {
if((state_val_14771 === (8))){
var inst_14725 = (state_14770[(9)]);
var inst_14724 = (state_14770[(10)]);
var inst_14727 = (inst_14725 < inst_14724);
var inst_14728 = inst_14727;
var state_14770__$1 = state_14770;
if(cljs.core.truth_(inst_14728)){
var statearr_14804_14835 = state_14770__$1;
(statearr_14804_14835[(1)] = (10));

} else {
var statearr_14805_14836 = state_14770__$1;
(statearr_14805_14836[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto__))
;
return ((function (switch__12171__auto__,c__12283__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12172__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12172__auto____0 = (function (){
var statearr_14809 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14809[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12172__auto__);

(statearr_14809[(1)] = (1));

return statearr_14809;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12172__auto____1 = (function (state_14770){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_14770);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e14810){if((e14810 instanceof Object)){
var ex__12175__auto__ = e14810;
var statearr_14811_14837 = state_14770;
(statearr_14811_14837[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14770);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14810;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14838 = state_14770;
state_14770 = G__14838;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12172__auto__ = function(state_14770){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12172__auto____1.call(this,state_14770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12172__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12172__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__))
})();
var state__12285__auto__ = (function (){var statearr_14812 = f__12284__auto__.call(null);
(statearr_14812[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_14812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto__))
);

return c__12283__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args14839 = [];
var len__7484__auto___14842 = arguments.length;
var i__7485__auto___14843 = (0);
while(true){
if((i__7485__auto___14843 < len__7484__auto___14842)){
args14839.push((arguments[i__7485__auto___14843]));

var G__14844 = (i__7485__auto___14843 + (1));
i__7485__auto___14843 = G__14844;
continue;
} else {
}
break;
}

var G__14841 = args14839.length;
switch (G__14841) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14839.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args14846 = [];
var len__7484__auto___14849 = arguments.length;
var i__7485__auto___14850 = (0);
while(true){
if((i__7485__auto___14850 < len__7484__auto___14849)){
args14846.push((arguments[i__7485__auto___14850]));

var G__14851 = (i__7485__auto___14850 + (1));
i__7485__auto___14850 = G__14851;
continue;
} else {
}
break;
}

var G__14848 = args14846.length;
switch (G__14848) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14846.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args14853 = [];
var len__7484__auto___14904 = arguments.length;
var i__7485__auto___14905 = (0);
while(true){
if((i__7485__auto___14905 < len__7484__auto___14904)){
args14853.push((arguments[i__7485__auto___14905]));

var G__14906 = (i__7485__auto___14905 + (1));
i__7485__auto___14905 = G__14906;
continue;
} else {
}
break;
}

var G__14855 = args14853.length;
switch (G__14855) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14853.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12283__auto___14908 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto___14908,out){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___14908,out){
return (function (state_14879){
var state_val_14880 = (state_14879[(1)]);
if((state_val_14880 === (7))){
var inst_14874 = (state_14879[(2)]);
var state_14879__$1 = state_14879;
var statearr_14881_14909 = state_14879__$1;
(statearr_14881_14909[(2)] = inst_14874);

(statearr_14881_14909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14880 === (1))){
var inst_14856 = null;
var state_14879__$1 = (function (){var statearr_14882 = state_14879;
(statearr_14882[(7)] = inst_14856);

return statearr_14882;
})();
var statearr_14883_14910 = state_14879__$1;
(statearr_14883_14910[(2)] = null);

(statearr_14883_14910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14880 === (4))){
var inst_14859 = (state_14879[(8)]);
var inst_14859__$1 = (state_14879[(2)]);
var inst_14860 = (inst_14859__$1 == null);
var inst_14861 = cljs.core.not.call(null,inst_14860);
var state_14879__$1 = (function (){var statearr_14884 = state_14879;
(statearr_14884[(8)] = inst_14859__$1);

return statearr_14884;
})();
if(inst_14861){
var statearr_14885_14911 = state_14879__$1;
(statearr_14885_14911[(1)] = (5));

} else {
var statearr_14886_14912 = state_14879__$1;
(statearr_14886_14912[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14880 === (6))){
var state_14879__$1 = state_14879;
var statearr_14887_14913 = state_14879__$1;
(statearr_14887_14913[(2)] = null);

(statearr_14887_14913[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14880 === (3))){
var inst_14876 = (state_14879[(2)]);
var inst_14877 = cljs.core.async.close_BANG_.call(null,out);
var state_14879__$1 = (function (){var statearr_14888 = state_14879;
(statearr_14888[(9)] = inst_14876);

return statearr_14888;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14879__$1,inst_14877);
} else {
if((state_val_14880 === (2))){
var state_14879__$1 = state_14879;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14879__$1,(4),ch);
} else {
if((state_val_14880 === (11))){
var inst_14859 = (state_14879[(8)]);
var inst_14868 = (state_14879[(2)]);
var inst_14856 = inst_14859;
var state_14879__$1 = (function (){var statearr_14889 = state_14879;
(statearr_14889[(10)] = inst_14868);

(statearr_14889[(7)] = inst_14856);

return statearr_14889;
})();
var statearr_14890_14914 = state_14879__$1;
(statearr_14890_14914[(2)] = null);

(statearr_14890_14914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14880 === (9))){
var inst_14859 = (state_14879[(8)]);
var state_14879__$1 = state_14879;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14879__$1,(11),out,inst_14859);
} else {
if((state_val_14880 === (5))){
var inst_14856 = (state_14879[(7)]);
var inst_14859 = (state_14879[(8)]);
var inst_14863 = cljs.core._EQ_.call(null,inst_14859,inst_14856);
var state_14879__$1 = state_14879;
if(inst_14863){
var statearr_14892_14915 = state_14879__$1;
(statearr_14892_14915[(1)] = (8));

} else {
var statearr_14893_14916 = state_14879__$1;
(statearr_14893_14916[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14880 === (10))){
var inst_14871 = (state_14879[(2)]);
var state_14879__$1 = state_14879;
var statearr_14894_14917 = state_14879__$1;
(statearr_14894_14917[(2)] = inst_14871);

(statearr_14894_14917[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14880 === (8))){
var inst_14856 = (state_14879[(7)]);
var tmp14891 = inst_14856;
var inst_14856__$1 = tmp14891;
var state_14879__$1 = (function (){var statearr_14895 = state_14879;
(statearr_14895[(7)] = inst_14856__$1);

return statearr_14895;
})();
var statearr_14896_14918 = state_14879__$1;
(statearr_14896_14918[(2)] = null);

(statearr_14896_14918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___14908,out))
;
return ((function (switch__12171__auto__,c__12283__auto___14908,out){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_14900 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14900[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_14900[(1)] = (1));

return statearr_14900;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_14879){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_14879);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e14901){if((e14901 instanceof Object)){
var ex__12175__auto__ = e14901;
var statearr_14902_14919 = state_14879;
(statearr_14902_14919[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14879);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14901;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14920 = state_14879;
state_14879 = G__14920;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_14879){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_14879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___14908,out))
})();
var state__12285__auto__ = (function (){var statearr_14903 = f__12284__auto__.call(null);
(statearr_14903[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___14908);

return statearr_14903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto___14908,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args14921 = [];
var len__7484__auto___14991 = arguments.length;
var i__7485__auto___14992 = (0);
while(true){
if((i__7485__auto___14992 < len__7484__auto___14991)){
args14921.push((arguments[i__7485__auto___14992]));

var G__14993 = (i__7485__auto___14992 + (1));
i__7485__auto___14992 = G__14993;
continue;
} else {
}
break;
}

var G__14923 = args14921.length;
switch (G__14923) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14921.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12283__auto___14995 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto___14995,out){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___14995,out){
return (function (state_14961){
var state_val_14962 = (state_14961[(1)]);
if((state_val_14962 === (7))){
var inst_14957 = (state_14961[(2)]);
var state_14961__$1 = state_14961;
var statearr_14963_14996 = state_14961__$1;
(statearr_14963_14996[(2)] = inst_14957);

(statearr_14963_14996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14962 === (1))){
var inst_14924 = (new Array(n));
var inst_14925 = inst_14924;
var inst_14926 = (0);
var state_14961__$1 = (function (){var statearr_14964 = state_14961;
(statearr_14964[(7)] = inst_14925);

(statearr_14964[(8)] = inst_14926);

return statearr_14964;
})();
var statearr_14965_14997 = state_14961__$1;
(statearr_14965_14997[(2)] = null);

(statearr_14965_14997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14962 === (4))){
var inst_14929 = (state_14961[(9)]);
var inst_14929__$1 = (state_14961[(2)]);
var inst_14930 = (inst_14929__$1 == null);
var inst_14931 = cljs.core.not.call(null,inst_14930);
var state_14961__$1 = (function (){var statearr_14966 = state_14961;
(statearr_14966[(9)] = inst_14929__$1);

return statearr_14966;
})();
if(inst_14931){
var statearr_14967_14998 = state_14961__$1;
(statearr_14967_14998[(1)] = (5));

} else {
var statearr_14968_14999 = state_14961__$1;
(statearr_14968_14999[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14962 === (15))){
var inst_14951 = (state_14961[(2)]);
var state_14961__$1 = state_14961;
var statearr_14969_15000 = state_14961__$1;
(statearr_14969_15000[(2)] = inst_14951);

(statearr_14969_15000[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14962 === (13))){
var state_14961__$1 = state_14961;
var statearr_14970_15001 = state_14961__$1;
(statearr_14970_15001[(2)] = null);

(statearr_14970_15001[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14962 === (6))){
var inst_14926 = (state_14961[(8)]);
var inst_14947 = (inst_14926 > (0));
var state_14961__$1 = state_14961;
if(cljs.core.truth_(inst_14947)){
var statearr_14971_15002 = state_14961__$1;
(statearr_14971_15002[(1)] = (12));

} else {
var statearr_14972_15003 = state_14961__$1;
(statearr_14972_15003[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14962 === (3))){
var inst_14959 = (state_14961[(2)]);
var state_14961__$1 = state_14961;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14961__$1,inst_14959);
} else {
if((state_val_14962 === (12))){
var inst_14925 = (state_14961[(7)]);
var inst_14949 = cljs.core.vec.call(null,inst_14925);
var state_14961__$1 = state_14961;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14961__$1,(15),out,inst_14949);
} else {
if((state_val_14962 === (2))){
var state_14961__$1 = state_14961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14961__$1,(4),ch);
} else {
if((state_val_14962 === (11))){
var inst_14941 = (state_14961[(2)]);
var inst_14942 = (new Array(n));
var inst_14925 = inst_14942;
var inst_14926 = (0);
var state_14961__$1 = (function (){var statearr_14973 = state_14961;
(statearr_14973[(7)] = inst_14925);

(statearr_14973[(8)] = inst_14926);

(statearr_14973[(10)] = inst_14941);

return statearr_14973;
})();
var statearr_14974_15004 = state_14961__$1;
(statearr_14974_15004[(2)] = null);

(statearr_14974_15004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14962 === (9))){
var inst_14925 = (state_14961[(7)]);
var inst_14939 = cljs.core.vec.call(null,inst_14925);
var state_14961__$1 = state_14961;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14961__$1,(11),out,inst_14939);
} else {
if((state_val_14962 === (5))){
var inst_14925 = (state_14961[(7)]);
var inst_14929 = (state_14961[(9)]);
var inst_14926 = (state_14961[(8)]);
var inst_14934 = (state_14961[(11)]);
var inst_14933 = (inst_14925[inst_14926] = inst_14929);
var inst_14934__$1 = (inst_14926 + (1));
var inst_14935 = (inst_14934__$1 < n);
var state_14961__$1 = (function (){var statearr_14975 = state_14961;
(statearr_14975[(12)] = inst_14933);

(statearr_14975[(11)] = inst_14934__$1);

return statearr_14975;
})();
if(cljs.core.truth_(inst_14935)){
var statearr_14976_15005 = state_14961__$1;
(statearr_14976_15005[(1)] = (8));

} else {
var statearr_14977_15006 = state_14961__$1;
(statearr_14977_15006[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14962 === (14))){
var inst_14954 = (state_14961[(2)]);
var inst_14955 = cljs.core.async.close_BANG_.call(null,out);
var state_14961__$1 = (function (){var statearr_14979 = state_14961;
(statearr_14979[(13)] = inst_14954);

return statearr_14979;
})();
var statearr_14980_15007 = state_14961__$1;
(statearr_14980_15007[(2)] = inst_14955);

(statearr_14980_15007[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14962 === (10))){
var inst_14945 = (state_14961[(2)]);
var state_14961__$1 = state_14961;
var statearr_14981_15008 = state_14961__$1;
(statearr_14981_15008[(2)] = inst_14945);

(statearr_14981_15008[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14962 === (8))){
var inst_14925 = (state_14961[(7)]);
var inst_14934 = (state_14961[(11)]);
var tmp14978 = inst_14925;
var inst_14925__$1 = tmp14978;
var inst_14926 = inst_14934;
var state_14961__$1 = (function (){var statearr_14982 = state_14961;
(statearr_14982[(7)] = inst_14925__$1);

(statearr_14982[(8)] = inst_14926);

return statearr_14982;
})();
var statearr_14983_15009 = state_14961__$1;
(statearr_14983_15009[(2)] = null);

(statearr_14983_15009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___14995,out))
;
return ((function (switch__12171__auto__,c__12283__auto___14995,out){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_14987 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14987[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_14987[(1)] = (1));

return statearr_14987;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_14961){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_14961);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e14988){if((e14988 instanceof Object)){
var ex__12175__auto__ = e14988;
var statearr_14989_15010 = state_14961;
(statearr_14989_15010[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14961);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14988;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15011 = state_14961;
state_14961 = G__15011;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_14961){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_14961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___14995,out))
})();
var state__12285__auto__ = (function (){var statearr_14990 = f__12284__auto__.call(null);
(statearr_14990[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___14995);

return statearr_14990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto___14995,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args15012 = [];
var len__7484__auto___15086 = arguments.length;
var i__7485__auto___15087 = (0);
while(true){
if((i__7485__auto___15087 < len__7484__auto___15086)){
args15012.push((arguments[i__7485__auto___15087]));

var G__15088 = (i__7485__auto___15087 + (1));
i__7485__auto___15087 = G__15088;
continue;
} else {
}
break;
}

var G__15014 = args15012.length;
switch (G__15014) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15012.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12283__auto___15090 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto___15090,out){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___15090,out){
return (function (state_15056){
var state_val_15057 = (state_15056[(1)]);
if((state_val_15057 === (7))){
var inst_15052 = (state_15056[(2)]);
var state_15056__$1 = state_15056;
var statearr_15058_15091 = state_15056__$1;
(statearr_15058_15091[(2)] = inst_15052);

(statearr_15058_15091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15057 === (1))){
var inst_15015 = [];
var inst_15016 = inst_15015;
var inst_15017 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_15056__$1 = (function (){var statearr_15059 = state_15056;
(statearr_15059[(7)] = inst_15016);

(statearr_15059[(8)] = inst_15017);

return statearr_15059;
})();
var statearr_15060_15092 = state_15056__$1;
(statearr_15060_15092[(2)] = null);

(statearr_15060_15092[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15057 === (4))){
var inst_15020 = (state_15056[(9)]);
var inst_15020__$1 = (state_15056[(2)]);
var inst_15021 = (inst_15020__$1 == null);
var inst_15022 = cljs.core.not.call(null,inst_15021);
var state_15056__$1 = (function (){var statearr_15061 = state_15056;
(statearr_15061[(9)] = inst_15020__$1);

return statearr_15061;
})();
if(inst_15022){
var statearr_15062_15093 = state_15056__$1;
(statearr_15062_15093[(1)] = (5));

} else {
var statearr_15063_15094 = state_15056__$1;
(statearr_15063_15094[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15057 === (15))){
var inst_15046 = (state_15056[(2)]);
var state_15056__$1 = state_15056;
var statearr_15064_15095 = state_15056__$1;
(statearr_15064_15095[(2)] = inst_15046);

(statearr_15064_15095[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15057 === (13))){
var state_15056__$1 = state_15056;
var statearr_15065_15096 = state_15056__$1;
(statearr_15065_15096[(2)] = null);

(statearr_15065_15096[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15057 === (6))){
var inst_15016 = (state_15056[(7)]);
var inst_15041 = inst_15016.length;
var inst_15042 = (inst_15041 > (0));
var state_15056__$1 = state_15056;
if(cljs.core.truth_(inst_15042)){
var statearr_15066_15097 = state_15056__$1;
(statearr_15066_15097[(1)] = (12));

} else {
var statearr_15067_15098 = state_15056__$1;
(statearr_15067_15098[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15057 === (3))){
var inst_15054 = (state_15056[(2)]);
var state_15056__$1 = state_15056;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15056__$1,inst_15054);
} else {
if((state_val_15057 === (12))){
var inst_15016 = (state_15056[(7)]);
var inst_15044 = cljs.core.vec.call(null,inst_15016);
var state_15056__$1 = state_15056;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15056__$1,(15),out,inst_15044);
} else {
if((state_val_15057 === (2))){
var state_15056__$1 = state_15056;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15056__$1,(4),ch);
} else {
if((state_val_15057 === (11))){
var inst_15024 = (state_15056[(10)]);
var inst_15020 = (state_15056[(9)]);
var inst_15034 = (state_15056[(2)]);
var inst_15035 = [];
var inst_15036 = inst_15035.push(inst_15020);
var inst_15016 = inst_15035;
var inst_15017 = inst_15024;
var state_15056__$1 = (function (){var statearr_15068 = state_15056;
(statearr_15068[(7)] = inst_15016);

(statearr_15068[(8)] = inst_15017);

(statearr_15068[(11)] = inst_15036);

(statearr_15068[(12)] = inst_15034);

return statearr_15068;
})();
var statearr_15069_15099 = state_15056__$1;
(statearr_15069_15099[(2)] = null);

(statearr_15069_15099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15057 === (9))){
var inst_15016 = (state_15056[(7)]);
var inst_15032 = cljs.core.vec.call(null,inst_15016);
var state_15056__$1 = state_15056;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15056__$1,(11),out,inst_15032);
} else {
if((state_val_15057 === (5))){
var inst_15024 = (state_15056[(10)]);
var inst_15020 = (state_15056[(9)]);
var inst_15017 = (state_15056[(8)]);
var inst_15024__$1 = f.call(null,inst_15020);
var inst_15025 = cljs.core._EQ_.call(null,inst_15024__$1,inst_15017);
var inst_15026 = cljs.core.keyword_identical_QMARK_.call(null,inst_15017,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_15027 = (inst_15025) || (inst_15026);
var state_15056__$1 = (function (){var statearr_15070 = state_15056;
(statearr_15070[(10)] = inst_15024__$1);

return statearr_15070;
})();
if(cljs.core.truth_(inst_15027)){
var statearr_15071_15100 = state_15056__$1;
(statearr_15071_15100[(1)] = (8));

} else {
var statearr_15072_15101 = state_15056__$1;
(statearr_15072_15101[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15057 === (14))){
var inst_15049 = (state_15056[(2)]);
var inst_15050 = cljs.core.async.close_BANG_.call(null,out);
var state_15056__$1 = (function (){var statearr_15074 = state_15056;
(statearr_15074[(13)] = inst_15049);

return statearr_15074;
})();
var statearr_15075_15102 = state_15056__$1;
(statearr_15075_15102[(2)] = inst_15050);

(statearr_15075_15102[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15057 === (10))){
var inst_15039 = (state_15056[(2)]);
var state_15056__$1 = state_15056;
var statearr_15076_15103 = state_15056__$1;
(statearr_15076_15103[(2)] = inst_15039);

(statearr_15076_15103[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15057 === (8))){
var inst_15016 = (state_15056[(7)]);
var inst_15024 = (state_15056[(10)]);
var inst_15020 = (state_15056[(9)]);
var inst_15029 = inst_15016.push(inst_15020);
var tmp15073 = inst_15016;
var inst_15016__$1 = tmp15073;
var inst_15017 = inst_15024;
var state_15056__$1 = (function (){var statearr_15077 = state_15056;
(statearr_15077[(7)] = inst_15016__$1);

(statearr_15077[(8)] = inst_15017);

(statearr_15077[(14)] = inst_15029);

return statearr_15077;
})();
var statearr_15078_15104 = state_15056__$1;
(statearr_15078_15104[(2)] = null);

(statearr_15078_15104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___15090,out))
;
return ((function (switch__12171__auto__,c__12283__auto___15090,out){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_15082 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15082[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_15082[(1)] = (1));

return statearr_15082;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_15056){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_15056);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e15083){if((e15083 instanceof Object)){
var ex__12175__auto__ = e15083;
var statearr_15084_15105 = state_15056;
(statearr_15084_15105[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15056);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15083;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15106 = state_15056;
state_15056 = G__15106;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_15056){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_15056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___15090,out))
})();
var state__12285__auto__ = (function (){var statearr_15085 = f__12284__auto__.call(null);
(statearr_15085[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___15090);

return statearr_15085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto___15090,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

