// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__12283__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto__){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__){
return (function (state_22352){
var state_val_22353 = (state_22352[(1)]);
if((state_val_22353 === (7))){
var inst_22309 = (state_22352[(7)]);
var inst_22309__$1 = (state_22352[(2)]);
var inst_22311 = (inst_22309__$1 == null);
var inst_22312 = cljs.core.not.call(null,inst_22311);
var state_22352__$1 = (function (){var statearr_22354 = state_22352;
(statearr_22354[(7)] = inst_22309__$1);

return statearr_22354;
})();
if(inst_22312){
var statearr_22355_22392 = state_22352__$1;
(statearr_22355_22392[(1)] = (8));

} else {
var statearr_22356_22393 = state_22352__$1;
(statearr_22356_22393[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (20))){
var inst_22331 = (state_22352[(8)]);
var inst_22339 = (state_22352[(2)]);
var state_22352__$1 = (function (){var statearr_22357 = state_22352;
(statearr_22357[(9)] = inst_22339);

return statearr_22357;
})();
if(cljs.core.truth_(inst_22331)){
var statearr_22358_22394 = state_22352__$1;
(statearr_22358_22394[(1)] = (21));

} else {
var statearr_22359_22395 = state_22352__$1;
(statearr_22359_22395[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (1))){
var state_22352__$1 = state_22352;
var statearr_22360_22396 = state_22352__$1;
(statearr_22360_22396[(2)] = null);

(statearr_22360_22396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (4))){
var state_22352__$1 = state_22352;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22352__$1,(7),agg_data_channel);
} else {
if((state_val_22353 === (15))){
var inst_22309 = (state_22352[(7)]);
var state_22352__$1 = state_22352;
var statearr_22361_22397 = state_22352__$1;
(statearr_22361_22397[(2)] = inst_22309);

(statearr_22361_22397[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (21))){
var inst_22341 = cljs.core.async.close_BANG_.call(null,agg_data_channel);
var state_22352__$1 = state_22352;
var statearr_22362_22398 = state_22352__$1;
(statearr_22362_22398[(2)] = inst_22341);

(statearr_22362_22398[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (13))){
var inst_22321 = (state_22352[(2)]);
var state_22352__$1 = state_22352;
var statearr_22363_22399 = state_22352__$1;
(statearr_22363_22399[(2)] = inst_22321);

(statearr_22363_22399[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (22))){
var state_22352__$1 = state_22352;
var statearr_22364_22400 = state_22352__$1;
(statearr_22364_22400[(2)] = null);

(statearr_22364_22400[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (6))){
var inst_22348 = (state_22352[(2)]);
var state_22352__$1 = state_22352;
var statearr_22365_22401 = state_22352__$1;
(statearr_22365_22401[(2)] = inst_22348);

(statearr_22365_22401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (17))){
var inst_22330 = (state_22352[(10)]);
var inst_22331 = (state_22352[(8)]);
var inst_22333 = callback.call(null,inst_22330,inst_22331);
var state_22352__$1 = state_22352;
var statearr_22366_22402 = state_22352__$1;
(statearr_22366_22402[(2)] = inst_22333);

(statearr_22366_22402[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (3))){
var inst_22350 = (state_22352[(2)]);
var state_22352__$1 = state_22352;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22352__$1,inst_22350);
} else {
if((state_val_22353 === (12))){
var state_22352__$1 = state_22352;
var statearr_22367_22403 = state_22352__$1;
(statearr_22367_22403[(2)] = false);

(statearr_22367_22403[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (2))){
var state_22352__$1 = state_22352;
var statearr_22368_22404 = state_22352__$1;
(statearr_22368_22404[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (23))){
var inst_22344 = (state_22352[(2)]);
var state_22352__$1 = (function (){var statearr_22370 = state_22352;
(statearr_22370[(11)] = inst_22344);

return statearr_22370;
})();
var statearr_22371_22405 = state_22352__$1;
(statearr_22371_22405[(2)] = null);

(statearr_22371_22405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (19))){
var inst_22336 = (state_22352[(2)]);
var inst_22337 = cljs.core.async.timeout.call(null,hatti.ona.stream.small_delay);
var state_22352__$1 = (function (){var statearr_22372 = state_22352;
(statearr_22372[(12)] = inst_22336);

return statearr_22372;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22352__$1,(20),inst_22337);
} else {
if((state_val_22353 === (11))){
var state_22352__$1 = state_22352;
var statearr_22373_22406 = state_22352__$1;
(statearr_22373_22406[(2)] = true);

(statearr_22373_22406[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (9))){
var state_22352__$1 = state_22352;
var statearr_22374_22407 = state_22352__$1;
(statearr_22374_22407[(2)] = false);

(statearr_22374_22407[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (5))){
var state_22352__$1 = state_22352;
var statearr_22375_22408 = state_22352__$1;
(statearr_22375_22408[(2)] = null);

(statearr_22375_22408[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (14))){
var inst_22309 = (state_22352[(7)]);
var inst_22326 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22309);
var state_22352__$1 = state_22352;
var statearr_22376_22409 = state_22352__$1;
(statearr_22376_22409[(2)] = inst_22326);

(statearr_22376_22409[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (16))){
var inst_22330 = (state_22352[(10)]);
var inst_22329 = (state_22352[(2)]);
var inst_22330__$1 = cljs.core.get.call(null,inst_22329,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_22331 = cljs.core.get.call(null,inst_22329,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var state_22352__$1 = (function (){var statearr_22377 = state_22352;
(statearr_22377[(10)] = inst_22330__$1);

(statearr_22377[(8)] = inst_22331);

return statearr_22377;
})();
if(cljs.core.truth_(inst_22330__$1)){
var statearr_22378_22410 = state_22352__$1;
(statearr_22378_22410[(1)] = (17));

} else {
var statearr_22379_22411 = state_22352__$1;
(statearr_22379_22411[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (10))){
var inst_22324 = (state_22352[(2)]);
var state_22352__$1 = state_22352;
if(cljs.core.truth_(inst_22324)){
var statearr_22380_22412 = state_22352__$1;
(statearr_22380_22412[(1)] = (14));

} else {
var statearr_22381_22413 = state_22352__$1;
(statearr_22381_22413[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (18))){
var state_22352__$1 = state_22352;
var statearr_22382_22414 = state_22352__$1;
(statearr_22382_22414[(2)] = null);

(statearr_22382_22414[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (8))){
var inst_22309 = (state_22352[(7)]);
var inst_22314 = inst_22309.cljs$lang$protocol_mask$partition0$;
var inst_22315 = (inst_22314 & (64));
var inst_22316 = inst_22309.cljs$core$ISeq$;
var inst_22317 = (inst_22315) || (inst_22316);
var state_22352__$1 = state_22352;
if(cljs.core.truth_(inst_22317)){
var statearr_22383_22415 = state_22352__$1;
(statearr_22383_22415[(1)] = (11));

} else {
var statearr_22384_22416 = state_22352__$1;
(statearr_22384_22416[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto__))
;
return ((function (switch__12171__auto__,c__12283__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto____0 = (function (){
var statearr_22388 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22388[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto__);

(statearr_22388[(1)] = (1));

return statearr_22388;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto____1 = (function (state_22352){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_22352);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e22389){if((e22389 instanceof Object)){
var ex__12175__auto__ = e22389;
var statearr_22390_22417 = state_22352;
(statearr_22390_22417[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22352);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22389;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22418 = state_22352;
state_22352 = G__22418;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto__ = function(state_22352){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto____1.call(this,state_22352);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__))
})();
var state__12285__auto__ = (function (){var statearr_22391 = f__12284__auto__.call(null);
(statearr_22391[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_22391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto__))
);

return c__12283__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.call(null,read_count,cljs.core.inc);

cljs.core.swap_BANG_.call(null,agg,cljs.core.conj,data_chunk);

if(((cljs.core.deref.call(null,read_count) >= (100))) && (cljs.core.integer_QMARK_.call(null,Math.log10(cljs.core.deref.call(null,read_count))))){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg)], null));

cljs.core.reset_BANG_.call(null,agg,cljs.core.PersistentVector.EMPTY);

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22425 = arguments.length;
var i__7485__auto___22426 = (0);
while(true){
if((i__7485__auto___22426 < len__7484__auto___22425)){
args__7491__auto__.push((arguments[i__7485__auto___22426]));

var G__22427 = (i__7485__auto___22426 + (1));
i__7485__auto___22426 = G__22427;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__22422){
var map__22423 = p__22422;
var map__22423__$1 = ((((!((map__22423 == null)))?((((map__22423.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22423.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22423):map__22423);
var oboe_headers = cljs.core.get.call(null,map__22423__$1,new cljs.core.Keyword(null,"oboe-headers","oboe-headers",-764778163));
var read_count = cljs.core.atom.call(null,(0));
var agg = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
var channel = cljs.core.async.chan.call(null);
var return_channel = cljs.core.async.chan.call(null);
var oboe_params = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"headers","headers",-835030129),oboe_headers,new cljs.core.Keyword(null,"withCredentials","withCredentials",1719959454),true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__22423,map__22423__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_.call(null,cljs.core.js__GT_clj.call(null,line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__22423,map__22423__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__22423,map__22423__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg),new cljs.core.Keyword(null,"completed?","completed?",946828354),true], null));

return cljs.core.async.close_BANG_.call(null,return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__22423,map__22423__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_.call(null,channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq22419){
var G__22420 = cljs.core.first.call(null,seq22419);
var seq22419__$1 = cljs.core.next.call(null,seq22419);
var G__22421 = cljs.core.first.call(null,seq22419__$1);
var seq22419__$2 = cljs.core.next.call(null,seq22419__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22420,G__22421,seq22419__$2);
});

