// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('inflections.core');
goog.require('sablono.core');
/**
 * Convert json to js using JSON.parse
 */
hatti.utils.json__GT_js = (function hatti$utils$json__GT_js(s){
return JSON.parse(s);
});
/**
 * Given a seq, produces a two-el seq. [a b c] => [[0 a] [1 b] [2 c]].
 */
hatti.utils.indexed = (function hatti$utils$indexed(coll){
return cljs.core.map_indexed.call(null,cljs.core.vector,coll);
});
/**
 * Helper function to create a click function that prevents default
 */
hatti.utils.click_fn = (function hatti$utils$click_fn(f){
return (function (event){
event.preventDefault();

return f.call(null);
});
});
/**
 * Create an appropriately pluralized string prefix by number.
 */
hatti.utils.pluralize_number = (function hatti$utils$pluralize_number(number,kind){
return clojure.string.join.call(null," ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [number,((cljs.core._EQ_.call(null,(1),number))?kind:inflections.core.plural.call(null,kind))], null));
});
/**
 * True if substring is a substring of string
 */
hatti.utils.substring_QMARK_ = (function hatti$utils$substring_QMARK_(var_args){
var args20285 = [];
var len__7484__auto___20294 = arguments.length;
var i__7485__auto___20295 = (0);
while(true){
if((i__7485__auto___20295 < len__7484__auto___20294)){
args20285.push((arguments[i__7485__auto___20295]));

var G__20296 = (i__7485__auto___20295 + (1));
i__7485__auto___20295 = G__20296;
continue;
} else {
}
break;
}

var G__20290 = args20285.length;
switch (G__20290) {
case 2:
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7503__auto__ = (new cljs.core.IndexedSeq(args20285.slice((2)),(0),null));
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7503__auto__);

}
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (substring,string){
return cljs.core.complement.call(null,cljs.core.nil_QMARK_).call(null,cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,substring),string));
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,string,p__20291){
var map__20292 = p__20291;
var map__20292__$1 = ((((!((map__20292 == null)))?((((map__20292.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20292.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20292):map__20292);
var case_sensitive_QMARK_ = cljs.core.get.call(null,map__20292__$1,new cljs.core.Keyword(null,"case-sensitive?","case-sensitive?",-2133754107));
if(cljs.core.truth_(case_sensitive_QMARK_)){
return hatti.utils.substring_QMARK_.call(null,substring,string);
} else {
return hatti.utils.substring_QMARK_.call(null,clojure.string.lower_case.call(null,substring),clojure.string.lower_case.call(null,string));
}
});

hatti.utils.substring_QMARK_.cljs$lang$applyTo = (function (seq20286){
var G__20287 = cljs.core.first.call(null,seq20286);
var seq20286__$1 = cljs.core.next.call(null,seq20286);
var G__20288 = cljs.core.first.call(null,seq20286__$1);
var seq20286__$2 = cljs.core.next.call(null,seq20286__$1);
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__20287,G__20288,seq20286__$2);
});

hatti.utils.substring_QMARK_.cljs$lang$maxFixedArity = (2);

hatti.utils.hyphen__GT_camel_case = (function hatti$utils$hyphen__GT_camel_case(source_string){
return clojure.string.replace.call(null,source_string,/(-)(.)/,(function (p1__20298_SHARP_){
var vec__20302 = p1__20298_SHARP_;
var _ = cljs.core.nth.call(null,vec__20302,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__20302,(1),null);
var letter_to_uppercase = cljs.core.nth.call(null,vec__20302,(2),null);
return clojure.string.upper_case.call(null,letter_to_uppercase);
}));
});
hatti.utils.generate_component = (function hatti$utils$generate_component(element_definition_vector){
return sablono.interpreter.interpret.call(null,element_definition_vector);
});
/**
 * This function generates HTML from hiccup-style vectors, and concatenates
 *   the resulting markup. Strings are returned unaffected.
 */
hatti.utils.generate_html = (function hatti$utils$generate_html(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20306 = arguments.length;
var i__7485__auto___20307 = (0);
while(true){
if((i__7485__auto___20307 < len__7484__auto___20306)){
args__7491__auto__.push((arguments[i__7485__auto___20307]));

var G__20308 = (i__7485__auto___20307 + (1));
i__7485__auto___20307 = G__20308;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic = (function (element_definition_vectors){
var components = cljs.core.map.call(null,hatti.utils.generate_component,element_definition_vectors);
var components_as_static_markup = cljs.core.map.call(null,((function (components){
return (function (component){
if(typeof component === 'string'){
return component;
} else {
return sablono.core.render_static.call(null,component);
}
});})(components))
,components);
return clojure.string.join.call(null,components_as_static_markup);
});

hatti.utils.generate_html.cljs$lang$maxFixedArity = (0);

hatti.utils.generate_html.cljs$lang$applyTo = (function (seq20305){
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20305));
});

hatti.utils.approved_text = "Approved";
hatti.utils.approved_status = "1";
hatti.utils.rejected_text = "Rejected";
hatti.utils.rejected_status = "2";
hatti.utils.pending_text = "Pending";
hatti.utils.pending_status = "3";
/**
 * This hash-map contains the supported statuses that a form submission can be
 * assigned.
 */
hatti.utils.review_status_map = cljs.core.PersistentArrayMap.fromArray([hatti.utils.approved_status,hatti.utils.approved_text,hatti.utils.rejected_status,hatti.utils.rejected_text,hatti.utils.pending_status,hatti.utils.pending_text], true, false);
hatti.utils.review_status_list = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"review-status","review-status",-1441957429),hatti.utils.approved_status,new cljs.core.Keyword(null,"review-text","review-text",-141513322),hatti.utils.approved_text], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"review-status","review-status",-1441957429),hatti.utils.rejected_status,new cljs.core.Keyword(null,"review-text","review-text",-141513322),hatti.utils.rejected_text], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"review-status","review-status",-1441957429),hatti.utils.pending_status,new cljs.core.Keyword(null,"review-text","review-text",-141513322),hatti.utils.pending_text], null)], null);
hatti.utils.get_submission_review_text = (function hatti$utils$get_submission_review_text(row_map){
return cljs.core.get.call(null,hatti.utils.review_status_map,(function (){var temp__4655__auto__ = cljs.core.get.call(null,row_map,"_review_status");
if(cljs.core.truth_(temp__4655__auto__)){
var r_status = temp__4655__auto__;
return r_status;
} else {
return hatti.utils.pending_status;
}
})());
});
