// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),true))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__25327_SHARP_){
if(typeof p1__25327_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__25327_SHARP_);
} else {
return p1__25327_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__25333){
var vec__25334 = p__25333;
var fname = cljs.core.nth.call(null,vec__25334,(0),null);
var answer = cljs.core.nth.call(null,vec__25334,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__25328_SHARP_){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),[cljs.core.str(p1__25328_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var media_count = (dataContext["_media_count"]);
var total_media = (dataContext["_total_media"]);
return hatti.ona.forms.format_answer.call(null,field,chimera.string.escape_for_type.call(null,clj_value),new cljs.core.Keyword(null,"language","language",-1591107564),language,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true,new cljs.core.Keyword(null,"field-key","field-key",313262601),field_key,new cljs.core.Keyword(null,"media-count","media-count",1579124405),media_count,new cljs.core.Keyword(null,"total-media","total-media",1031250100),total_media);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__25337 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__25337__$1 = ((((!((map__25337 == null)))?((((map__25337.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25337.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25337):map__25337);
var owner__$1 = cljs.core.get.call(null,map__25337__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__25337__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__25337__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = chimera.urls.last_url_param.call(null,owner__$1);
var project_id = chimera.urls.last_url_param.call(null,project);
var edit_link = chimera.urls.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input.delete-record","input.delete-record",-1708576930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip.middle-right","li.tooltip.middle-right",-548323211),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-eye","i.fa.fa-eye",-1428531423),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil","i.fa.fa-pencil",1547895857)], null)], null)], null)], null):null));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.select_unselect_all_records_id = "select-unselect-all-records";
hatti.views.table.select_unselect_all_records_element = [cljs.core.str("<input type=\"checkbox\" id=\""),cljs.core.str(hatti.views.table.select_unselect_all_records_id),cljs.core.str("\">")].join('');
hatti.views.table.delete_record_class = "delete-record";
hatti.views.table.submission_review_fields = (function hatti$views$table$submission_review_fields(cols){
var vec__25342 = cljs.core.split_at.call(null,(1),cols);
var actions = cljs.core.nth.call(null,vec__25342,(0),null);
var data = cljs.core.nth.call(null,vec__25342,(1),null);
return cljs.core.vec.call(null,cljs.core.flatten.call(null,cljs.core.conj.call(null,data,hatti.ona.forms.review_comment_field,hatti.ona.forms.review_status_field,actions)));
});
cljs.core._add_method.call(null,hatti.views.actions_column,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(100),hatti.views.table.select_unselect_all_records_element,hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
}));
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___25372 = arguments.length;
var i__7485__auto___25373 = (0);
while(true){
if((i__7485__auto___25373 < len__7484__auto___25372)){
args__7491__auto__.push((arguments[i__7485__auto___25373]));

var G__25374 = (i__7485__auto___25373 + (1));
i__7485__auto___25373 = G__25374;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__25348){
var map__25349 = p__25348;
var map__25349__$1 = ((((!((map__25349 == null)))?((((map__25349.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25349.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25349):map__25349);
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var submission_review_QMARK_ = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375));
var get_label_QMARK_ = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),true);
var language = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var owner = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var has_hxl_QMARK_ = chimera.core.any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,((function (map__25349,map__25349__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__25345_SHARP_){
return (new cljs.core.Keyword(null,"hxl","hxl",-849576989).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"instance","instance",-2121349050).cljs$core$IFn$_invoke$arity$1(p1__25345_SHARP_)) == null);
});})(map__25349,map__25349__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
,form));
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__25349,map__25349__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__25351(s__25352){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__25349,map__25349__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__25352__$1 = s__25352;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25352__$1);
if(temp__4657__auto__){
var s__25352__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25352__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25352__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25354 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25353 = (0);
while(true){
if((i__25353 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__25353);
cljs.core.chunk_append.call(null,b__25354,(function (){var map__25363 = field;
var map__25363__$1 = ((((!((map__25363 == null)))?((((map__25363.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25363.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25363):map__25363);
var map__25364 = cljs.core.get.call(null,map__25363__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25364__$1 = ((((!((map__25364 == null)))?((((map__25364.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25364.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25364):map__25364);
var hxl = cljs.core.get.call(null,map__25364__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25363__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25363__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25363__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?new cljs.core.Keyword(null,"name","name",1843675177):new cljs.core.Keyword(null,"label","label",1718410804));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__25375 = (i__25353 + (1));
i__25353 = G__25375;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25354),hatti$views$table$iter__25351.call(null,cljs.core.chunk_rest.call(null,s__25352__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25354),null);
}
} else {
var field = cljs.core.first.call(null,s__25352__$2);
return cljs.core.cons.call(null,(function (){var map__25367 = field;
var map__25367__$1 = ((((!((map__25367 == null)))?((((map__25367.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25367.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25367):map__25367);
var map__25368 = cljs.core.get.call(null,map__25367__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25368__$1 = ((((!((map__25368 == null)))?((((map__25368.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25368.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25368):map__25368);
var hxl = cljs.core.get.call(null,map__25368__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25367__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25367__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25367__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?new cljs.core.Keyword(null,"name","name",1843675177):new cljs.core.Keyword(null,"label","label",1718410804));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__25351.call(null,cljs.core.rest.call(null,s__25352__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__25349,map__25349__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__25349,map__25349__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__.call(null,hatti.views.table.all_fields.call(null,form));
})();
return cljs.core.clj__GT_js.call(null,(function (){var G__25371 = columns;
var G__25371__$1 = ((cljs.core.not.call(null,hide_actions_column_QMARK_))?cljs.core.conj.call(null,G__25371,hatti.views.actions_column.call(null,owner,has_hxl_QMARK_)):G__25371);
if(cljs.core.truth_(submission_review_QMARK_)){
return hatti.views.table.submission_review_fields.call(null,G__25371__$1);
} else {
return G__25371__$1;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq25346){
var G__25347 = cljs.core.first.call(null,seq25346);
var seq25346__$1 = cljs.core.next.call(null,seq25346);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__25347,seq25346__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25392(s__25393){
return (new cljs.core.LazySeq(null,(function (){
var s__25393__$1 = s__25393;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25393__$1);
if(temp__4657__auto__){
var s__25393__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25393__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25393__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25395 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25394 = (0);
while(true){
if((i__25394 < size__7188__auto__)){
var vec__25402 = cljs.core._nth.call(null,c__7187__auto__,i__25394);
var handler_key = cljs.core.nth.call(null,vec__25402,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25402,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__25395,event.subscribe(handler_function));

var G__25408 = (i__25394 + (1));
i__25394 = G__25408;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25395),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25392.call(null,cljs.core.chunk_rest.call(null,s__25393__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25395),null);
}
} else {
var vec__25405 = cljs.core.first.call(null,s__25393__$2);
var handler_key = cljs.core.nth.call(null,vec__25405,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25405,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25392.call(null,cljs.core.rest.call(null,s__25393__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25425(s__25426){
return (new cljs.core.LazySeq(null,(function (){
var s__25426__$1 = s__25426;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25426__$1);
if(temp__4657__auto__){
var s__25426__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25426__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25426__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25428 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25427 = (0);
while(true){
if((i__25427 < size__7188__auto__)){
var vec__25435 = cljs.core._nth.call(null,c__7187__auto__,i__25427);
var handler_key = cljs.core.nth.call(null,vec__25435,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25435,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__25428,event.subscribe(handler_function));

var G__25441 = (i__25427 + (1));
i__25427 = G__25441;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25428),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25425.call(null,cljs.core.chunk_rest.call(null,s__25426__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25428),null);
}
} else {
var vec__25438 = cljs.core.first.call(null,s__25426__$2);
var handler_key = cljs.core.nth.call(null,vec__25438,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25438,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25425.call(null,cljs.core.rest.call(null,s__25426__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.update_data_to_be_deleted_vector = (function hatti$views$table$update_data_to_be_deleted_vector(checked_QMARK_,data_id){
var map__25444 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25444__$1 = ((((!((map__25444 == null)))?((((map__25444.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25444.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25444):map__25444);
var data_to_be_deleted = cljs.core.get.call(null,map__25444__$1,new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634));
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
return chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634)], null),((function (map__25444,map__25444__$1,data_to_be_deleted,fn){
return (function (){
return fn.call(null,data_to_be_deleted,data_id);
});})(map__25444,map__25444__$1,data_to_be_deleted,fn))
);
});
hatti.views.table.get_elements_count_by_selector = (function hatti$views$table$get_elements_count_by_selector(selector){
return document.querySelectorAll(selector).length;
});
hatti.views.table.check_select_unselect_all_records_element_QMARK_ = (function hatti$views$table$check_select_unselect_all_records_element_QMARK_(){
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,delete_record_class_selector);
var selected_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,[cljs.core.str(delete_record_class_selector),cljs.core.str(":checked")].join(''));
return cljs.core._EQ_.call(null,selected_rows_count,total_rows_count);
});
hatti.views.table.get_checkbox_selector = (function hatti$views$table$get_checkbox_selector(data_id){
return [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class),cljs.core.str("[data-id=\""),cljs.core.str(data_id),cljs.core.str("\"]")].join('');
});
hatti.views.table.get_delete_checkbox_by_data_id = (function hatti$views$table$get_delete_checkbox_by_data_id(data_id){
var selector = hatti.views.table.get_checkbox_selector.call(null,data_id);
return document.querySelector(selector);
});
hatti.views.table.select_rows_marked_to_be_deleted = (function hatti$views$table$select_rows_marked_to_be_deleted(){
var seq__25450 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)));
var chunk__25451 = null;
var count__25452 = (0);
var i__25453 = (0);
while(true){
if((i__25453 < count__25452)){
var data_id = cljs.core._nth.call(null,chunk__25451,i__25453);
var element_25454 = hatti.views.table.get_delete_checkbox_by_data_id.call(null,data_id);
element_25454.checked = true;

var G__25455 = seq__25450;
var G__25456 = chunk__25451;
var G__25457 = count__25452;
var G__25458 = (i__25453 + (1));
seq__25450 = G__25455;
chunk__25451 = G__25456;
count__25452 = G__25457;
i__25453 = G__25458;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__25450);
if(temp__4657__auto__){
var seq__25450__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25450__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__25450__$1);
var G__25459 = cljs.core.chunk_rest.call(null,seq__25450__$1);
var G__25460 = c__7220__auto__;
var G__25461 = cljs.core.count.call(null,c__7220__auto__);
var G__25462 = (0);
seq__25450 = G__25459;
chunk__25451 = G__25460;
count__25452 = G__25461;
i__25453 = G__25462;
continue;
} else {
var data_id = cljs.core.first.call(null,seq__25450__$1);
var element_25463 = hatti.views.table.get_delete_checkbox_by_data_id.call(null,data_id);
element_25463.checked = true;

var G__25464 = cljs.core.next.call(null,seq__25450__$1);
var G__25465 = null;
var G__25466 = (0);
var G__25467 = (0);
seq__25450 = G__25464;
chunk__25451 = G__25465;
count__25452 = G__25466;
i__25453 = G__25467;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.higlight_rows_marked_to_be_deleted = (function hatti$views$table$higlight_rows_marked_to_be_deleted(grid){
var checkboxes = document.getElementsByClassName(hatti.views.table.delete_record_class);
var indexes_of_selected_checkboxes = cljs.core.vec.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map_indexed.call(null,((function (checkboxes){
return (function (index,checkbox){
if(cljs.core.truth_(checkbox.checked)){
return index;
} else {
return null;
}
});})(checkboxes))
,checkboxes)));
chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (checkboxes,indexes_of_selected_checkboxes){
return (function (){
return cljs.core.identity.call(null,indexes_of_selected_checkboxes);
});})(checkboxes,indexes_of_selected_checkboxes))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,indexes_of_selected_checkboxes));
});
hatti.views.table.replace_review_num_status_with_text_status = (function hatti$views$table$replace_review_num_status_with_text_status(data){
return cljs.core.map.call(null,(function (row_map){
return cljs.core.assoc.call(null,row_map,"_review_status",hatti.utils.get_submission_review_text.call(null,row_map));
}),data);
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__25468){
var map__25484 = p__25468;
var map__25484__$1 = ((((!((map__25484 == null)))?((((map__25484.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25484.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25484):map__25484);
var grid_event_handlers = cljs.core.get.call(null,map__25484__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__25484__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var map__25486 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25486__$1 = ((((!((map__25486 == null)))?((((map__25486.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25486.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25486):map__25486);
var map__25487 = cljs.core.get.call(null,map__25486__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__25487__$1 = ((((!((map__25487 == null)))?((((map__25487.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25487.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25487):map__25487);
var map__25488 = cljs.core.get.call(null,map__25487__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__25488__$1 = ((((!((map__25488 == null)))?((((map__25488.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25488.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25488):map__25488);
var num_displayed_records = cljs.core.get.call(null,map__25488__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__25488__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25487__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var submission_review_QMARK_ = cljs.core.get.call(null,map__25486__$1,new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,new cljs.core.Keyword(null,"language","language",-1591107564),current_language,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754),hide_actions_column_QMARK_,new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375),submission_review_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

grid.setSelectionModel((new Slick.RowSelectionModel(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selectActiveRow","selectActiveRow",-841772687),false], null)))));

dataview.onRowCountChanged.subscribe(((function (map__25486,map__25486__$1,map__25487,map__25487__$1,map__25488,map__25488__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25484,map__25484__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__25486,map__25486__$1,map__25487,map__25487__$1,map__25488,map__25488__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25484,map__25484__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__25486,map__25486__$1,map__25487,map__25487__$1,map__25488,map__25488__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25484,map__25484__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

grid.render();

hatti.views.table.select_rows_marked_to_be_deleted.call(null);

return hatti.views.table.higlight_rows_marked_to_be_deleted.call(null,grid);
});})(map__25486,map__25486__$1,map__25487,map__25487__$1,map__25488,map__25488__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25484,map__25484__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onHeaderClick.subscribe(((function (map__25486,map__25486__$1,map__25487,map__25487__$1,map__25488,map__25488__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25484,map__25484__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var target = e.target;
var id = target.id;
var checked_QMARK_ = target.checked;
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,delete_record_class_selector);
if(cljs.core._EQ_.call(null,hatti.views.table.select_unselect_all_records_id,id)){
var records_to_be_deleted = document.getElementsByClassName(hatti.views.table.delete_record_class);
var seq__25492_25499 = cljs.core.seq.call(null,records_to_be_deleted);
var chunk__25493_25500 = null;
var count__25494_25501 = (0);
var i__25495_25502 = (0);
while(true){
if((i__25495_25502 < count__25494_25501)){
var record_25503 = cljs.core._nth.call(null,chunk__25493_25500,i__25495_25502);
record_25503.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,parseInt(record_25503.getAttribute("data-id")));

var G__25504 = seq__25492_25499;
var G__25505 = chunk__25493_25500;
var G__25506 = count__25494_25501;
var G__25507 = (i__25495_25502 + (1));
seq__25492_25499 = G__25504;
chunk__25493_25500 = G__25505;
count__25494_25501 = G__25506;
i__25495_25502 = G__25507;
continue;
} else {
var temp__4657__auto___25508 = cljs.core.seq.call(null,seq__25492_25499);
if(temp__4657__auto___25508){
var seq__25492_25509__$1 = temp__4657__auto___25508;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25492_25509__$1)){
var c__7220__auto___25510 = cljs.core.chunk_first.call(null,seq__25492_25509__$1);
var G__25511 = cljs.core.chunk_rest.call(null,seq__25492_25509__$1);
var G__25512 = c__7220__auto___25510;
var G__25513 = cljs.core.count.call(null,c__7220__auto___25510);
var G__25514 = (0);
seq__25492_25499 = G__25511;
chunk__25493_25500 = G__25512;
count__25494_25501 = G__25513;
i__25495_25502 = G__25514;
continue;
} else {
var record_25515 = cljs.core.first.call(null,seq__25492_25509__$1);
record_25515.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,parseInt(record_25515.getAttribute("data-id")));

var G__25516 = cljs.core.next.call(null,seq__25492_25509__$1);
var G__25517 = null;
var G__25518 = (0);
var G__25519 = (0);
seq__25492_25499 = G__25516;
chunk__25493_25500 = G__25517;
count__25494_25501 = G__25518;
i__25495_25502 = G__25519;
continue;
}
} else {
}
}
break;
}

chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__25486,map__25486__$1,map__25487,map__25487__$1,map__25488,map__25488__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25484,map__25484__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
if(cljs.core.truth_(checked_QMARK_)){
return cljs.core.range.call(null,total_rows_count);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});})(records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__25486,map__25486__$1,map__25487,map__25487__$1,map__25488,map__25488__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25484,map__25484__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
} else {
return null;
}
});})(map__25486,map__25486__$1,map__25487,map__25487__$1,map__25488,map__25488__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25484,map__25484__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__25486,map__25486__$1,map__25487,map__25487__$1,map__25488,map__25488__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25484,map__25484__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(map__25486,map__25486__$1,map__25487,map__25487__$1,map__25488,map__25488__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25484,map__25484__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__25486,map__25486__$1,map__25487,map__25487__$1,map__25488,map__25488__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25484,map__25484__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var class_name = elem.className;
var checked_QMARK_ = elem.checked;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
var select_unselect_all_records_chkbox = document.getElementById(hatti.views.table.select_unselect_all_records_id);
var map__25496 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25496__$1 = ((((!((map__25496 == null)))?((((map__25496.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25496.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25496):map__25496);
var selected_table_rows = cljs.core.get.call(null,map__25496__$1,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745));
if(cljs.core._EQ_.call(null,class_name,hatti.views.table.delete_record_class)){
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
var row__$1 = parseInt(grid.getCellFromEvent(e).row);
hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,data_id);

select_unselect_all_records_chkbox.checked = hatti.views.table.check_select_unselect_all_records_element_QMARK_.call(null);

chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__25496,map__25496__$1,selected_table_rows,map__25486,map__25486__$1,map__25487,map__25487__$1,map__25488,map__25488__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25484,map__25484__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
return fn.call(null,selected_table_rows,row__$1);
});})(fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__25496,map__25496__$1,selected_table_rows,map__25486,map__25486__$1,map__25487,map__25487__$1,map__25488,map__25488__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25484,map__25484__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
} else {
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
}
});})(map__25486,map__25486__$1,map__25487,map__25487__$1,map__25488,map__25488__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25484,map__25484__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,(function (){var G__25498 = data;
if(cljs.core.truth_(submission_review_QMARK_)){
return hatti.views.table.replace_review_num_status_with_text_status.call(null,G__25498);
} else {
return G__25498;
}
})()),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__12283__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto__,event_chan){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__,event_chan){
return (function (state_25811){
var state_val_25812 = (state_25811[(1)]);
if((state_val_25812 === (7))){
var inst_25709 = (state_25811[(7)]);
var inst_25709__$1 = (state_25811[(2)]);
var inst_25711 = (inst_25709__$1 == null);
var inst_25712 = cljs.core.not.call(null,inst_25711);
var state_25811__$1 = (function (){var statearr_25813 = state_25811;
(statearr_25813[(7)] = inst_25709__$1);

return statearr_25813;
})();
if(inst_25712){
var statearr_25814_25889 = state_25811__$1;
(statearr_25814_25889[(1)] = (8));

} else {
var statearr_25815_25890 = state_25811__$1;
(statearr_25815_25890[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (20))){
var inst_25731 = (state_25811[(8)]);
var inst_25739 = (state_25811[(9)]);
var inst_25748 = inst_25739.call(null,inst_25731);
var state_25811__$1 = state_25811;
var statearr_25816_25891 = state_25811__$1;
(statearr_25816_25891[(2)] = inst_25748);

(statearr_25816_25891[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (27))){
var state_25811__$1 = state_25811;
var statearr_25817_25892 = state_25811__$1;
(statearr_25817_25892[(2)] = null);

(statearr_25817_25892[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (1))){
var state_25811__$1 = state_25811;
var statearr_25818_25893 = state_25811__$1;
(statearr_25818_25893[(2)] = null);

(statearr_25818_25893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (24))){
var state_25811__$1 = state_25811;
var statearr_25819_25894 = state_25811__$1;
(statearr_25819_25894[(2)] = null);

(statearr_25819_25894[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (4))){
var state_25811__$1 = state_25811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25811__$1,(7),event_chan);
} else {
if((state_val_25812 === (15))){
var inst_25709 = (state_25811[(7)]);
var state_25811__$1 = state_25811;
var statearr_25820_25895 = state_25811__$1;
(statearr_25820_25895[(2)] = inst_25709);

(statearr_25820_25895[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (21))){
var state_25811__$1 = state_25811;
var statearr_25821_25896 = state_25811__$1;
(statearr_25821_25896[(2)] = null);

(statearr_25821_25896[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (31))){
var inst_25735 = (state_25811[(10)]);
var inst_25784 = (state_25811[(2)]);
var inst_25785 = cljs.core._EQ_.call(null,inst_25735,new cljs.core.Keyword(null,"table","table",-564943036));
var state_25811__$1 = (function (){var statearr_25822 = state_25811;
(statearr_25822[(11)] = inst_25784);

return statearr_25822;
})();
if(inst_25785){
var statearr_25823_25897 = state_25811__$1;
(statearr_25823_25897[(1)] = (32));

} else {
var statearr_25824_25898 = state_25811__$1;
(statearr_25824_25898[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (32))){
var inst_25740 = (state_25811[(12)]);
var inst_25731 = (state_25811[(8)]);
var inst_25735 = (state_25811[(10)]);
var inst_25734 = (state_25811[(13)]);
var inst_25732 = (state_25811[(14)]);
var inst_25739 = (state_25811[(9)]);
var inst_25730 = (state_25811[(15)]);
var inst_25733 = (state_25811[(16)]);
var inst_25729 = (state_25811[(17)]);
var inst_25798 = cljs.core.async.chan.call(null,(1));
var inst_25799 = (function (){var new_columns = inst_25734;
var submission_clicked = inst_25731;
var submission_unclicked = inst_25732;
var get_submission_data = inst_25740;
var c__12283__auto____$1 = inst_25798;
var re_render = inst_25735;
var update_data_BANG_ = inst_25739;
var submission_to_rank = inst_25730;
var filter_by = inst_25733;
var map__25707 = inst_25729;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25707,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25798,state_val_25812,c__12283__auto__,event_chan){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25707,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25798,state_val_25812,c__12283__auto__,event_chan){
return (function (state_25796){
var state_val_25797 = (state_25796[(1)]);
if((state_val_25797 === (1))){
var inst_25787 = cljs.core.async.timeout.call(null,(20));
var state_25796__$1 = state_25796;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25796__$1,(2),inst_25787);
} else {
if((state_val_25797 === (2))){
var inst_25789 = (state_25796[(2)]);
var inst_25790 = grid.resizeCanvas();
var inst_25791 = grid.invalidateAllRows();
var inst_25792 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25793 = grid.render();
var inst_25794 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_25796__$1 = (function (){var statearr_25825 = state_25796;
(statearr_25825[(7)] = inst_25789);

(statearr_25825[(8)] = inst_25793);

(statearr_25825[(9)] = inst_25792);

(statearr_25825[(10)] = inst_25790);

(statearr_25825[(11)] = inst_25791);

return statearr_25825;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25796__$1,inst_25794);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25707,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25798,state_val_25812,c__12283__auto__,event_chan))
;
return ((function (switch__12171__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25707,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25798,state_val_25812,c__12283__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12172__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12172__auto____0 = (function (){
var statearr_25829 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25829[(0)] = hatti$views$table$handle_table_events_$_state_machine__12172__auto__);

(statearr_25829[(1)] = (1));

return statearr_25829;
});
var hatti$views$table$handle_table_events_$_state_machine__12172__auto____1 = (function (state_25796){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_25796);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e25830){if((e25830 instanceof Object)){
var ex__12175__auto__ = e25830;
var statearr_25831_25899 = state_25796;
(statearr_25831_25899[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25796);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25830;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25900 = state_25796;
state_25796 = G__25900;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12172__auto__ = function(state_25796){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12172__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12172__auto____1.call(this,state_25796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12172__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12172__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25707,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25798,state_val_25812,c__12283__auto__,event_chan))
})();
var state__12285__auto__ = (function (){var statearr_25832 = f__12284__auto__.call(null);
(statearr_25832[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto____$1);

return statearr_25832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25707,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25798,state_val_25812,c__12283__auto__,event_chan))
})();
var inst_25800 = cljs.core.async.impl.dispatch.run.call(null,inst_25799);
var state_25811__$1 = (function (){var statearr_25833 = state_25811;
(statearr_25833[(18)] = inst_25800);

return statearr_25833;
})();
var statearr_25834_25901 = state_25811__$1;
(statearr_25834_25901[(2)] = inst_25798);

(statearr_25834_25901[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (33))){
var state_25811__$1 = state_25811;
var statearr_25835_25902 = state_25811__$1;
(statearr_25835_25902[(2)] = null);

(statearr_25835_25902[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (13))){
var inst_25721 = (state_25811[(2)]);
var state_25811__$1 = state_25811;
var statearr_25836_25903 = state_25811__$1;
(statearr_25836_25903[(2)] = inst_25721);

(statearr_25836_25903[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (22))){
var inst_25732 = (state_25811[(14)]);
var inst_25751 = (state_25811[(2)]);
var state_25811__$1 = (function (){var statearr_25837 = state_25811;
(statearr_25837[(19)] = inst_25751);

return statearr_25837;
})();
if(cljs.core.truth_(inst_25732)){
var statearr_25838_25904 = state_25811__$1;
(statearr_25838_25904[(1)] = (23));

} else {
var statearr_25839_25905 = state_25811__$1;
(statearr_25839_25905[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (29))){
var inst_25733 = (state_25811[(16)]);
var inst_25776 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_25777 = [inst_25733];
var inst_25778 = cljs.core.PersistentHashMap.fromArrays(inst_25776,inst_25777);
var inst_25779 = cljs.core.clj__GT_js.call(null,inst_25778);
var inst_25780 = dataview.setFilterArgs(inst_25779);
var inst_25781 = dataview.refresh();
var state_25811__$1 = (function (){var statearr_25840 = state_25811;
(statearr_25840[(20)] = inst_25780);

return statearr_25840;
})();
var statearr_25841_25906 = state_25811__$1;
(statearr_25841_25906[(2)] = inst_25781);

(statearr_25841_25906[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (6))){
var inst_25807 = (state_25811[(2)]);
var state_25811__$1 = state_25811;
var statearr_25842_25907 = state_25811__$1;
(statearr_25842_25907[(2)] = inst_25807);

(statearr_25842_25907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (28))){
var inst_25733 = (state_25811[(16)]);
var inst_25774 = (state_25811[(2)]);
var state_25811__$1 = (function (){var statearr_25843 = state_25811;
(statearr_25843[(21)] = inst_25774);

return statearr_25843;
})();
if(cljs.core.truth_(inst_25733)){
var statearr_25844_25908 = state_25811__$1;
(statearr_25844_25908[(1)] = (29));

} else {
var statearr_25845_25909 = state_25811__$1;
(statearr_25845_25909[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (25))){
var inst_25734 = (state_25811[(13)]);
var inst_25756 = (state_25811[(2)]);
var state_25811__$1 = (function (){var statearr_25846 = state_25811;
(statearr_25846[(22)] = inst_25756);

return statearr_25846;
})();
if(cljs.core.truth_(inst_25734)){
var statearr_25847_25910 = state_25811__$1;
(statearr_25847_25910[(1)] = (26));

} else {
var statearr_25848_25911 = state_25811__$1;
(statearr_25848_25911[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (34))){
var inst_25803 = (state_25811[(2)]);
var state_25811__$1 = (function (){var statearr_25849 = state_25811;
(statearr_25849[(23)] = inst_25803);

return statearr_25849;
})();
var statearr_25850_25912 = state_25811__$1;
(statearr_25850_25912[(2)] = null);

(statearr_25850_25912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (17))){
var inst_25740 = (state_25811[(12)]);
var inst_25739 = (state_25811[(9)]);
var inst_25730 = (state_25811[(15)]);
var inst_25742 = inst_25740.call(null,hatti.constants._rank,inst_25730);
var inst_25743 = inst_25739.call(null,inst_25742);
var state_25811__$1 = state_25811;
var statearr_25851_25913 = state_25811__$1;
(statearr_25851_25913[(2)] = inst_25743);

(statearr_25851_25913[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (3))){
var inst_25809 = (state_25811[(2)]);
var state_25811__$1 = state_25811;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25811__$1,inst_25809);
} else {
if((state_val_25812 === (12))){
var state_25811__$1 = state_25811;
var statearr_25852_25914 = state_25811__$1;
(statearr_25852_25914[(2)] = false);

(statearr_25852_25914[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (2))){
var state_25811__$1 = state_25811;
var statearr_25853_25915 = state_25811__$1;
(statearr_25853_25915[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (23))){
var inst_25739 = (state_25811[(9)]);
var inst_25753 = inst_25739.call(null,null);
var state_25811__$1 = state_25811;
var statearr_25855_25916 = state_25811__$1;
(statearr_25855_25916[(2)] = inst_25753);

(statearr_25855_25916[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (19))){
var inst_25731 = (state_25811[(8)]);
var inst_25746 = (state_25811[(2)]);
var state_25811__$1 = (function (){var statearr_25856 = state_25811;
(statearr_25856[(24)] = inst_25746);

return statearr_25856;
})();
if(cljs.core.truth_(inst_25731)){
var statearr_25857_25917 = state_25811__$1;
(statearr_25857_25917[(1)] = (20));

} else {
var statearr_25858_25918 = state_25811__$1;
(statearr_25858_25918[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (11))){
var state_25811__$1 = state_25811;
var statearr_25859_25919 = state_25811__$1;
(statearr_25859_25919[(2)] = true);

(statearr_25859_25919[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (9))){
var state_25811__$1 = state_25811;
var statearr_25860_25920 = state_25811__$1;
(statearr_25860_25920[(2)] = false);

(statearr_25860_25920[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (5))){
var state_25811__$1 = state_25811;
var statearr_25861_25921 = state_25811__$1;
(statearr_25861_25921[(2)] = null);

(statearr_25861_25921[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (14))){
var inst_25709 = (state_25811[(7)]);
var inst_25726 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25709);
var state_25811__$1 = state_25811;
var statearr_25862_25922 = state_25811__$1;
(statearr_25862_25922[(2)] = inst_25726);

(statearr_25862_25922[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (26))){
var inst_25740 = (state_25811[(12)]);
var inst_25731 = (state_25811[(8)]);
var inst_25735 = (state_25811[(10)]);
var inst_25734 = (state_25811[(13)]);
var inst_25732 = (state_25811[(14)]);
var inst_25739 = (state_25811[(9)]);
var inst_25730 = (state_25811[(15)]);
var inst_25733 = (state_25811[(16)]);
var inst_25729 = (state_25811[(17)]);
var inst_25769 = cljs.core.async.chan.call(null,(1));
var inst_25770 = (function (){var new_columns = inst_25734;
var submission_clicked = inst_25731;
var submission_unclicked = inst_25732;
var get_submission_data = inst_25740;
var c__12283__auto____$1 = inst_25769;
var re_render = inst_25735;
var update_data_BANG_ = inst_25739;
var submission_to_rank = inst_25730;
var filter_by = inst_25733;
var map__25707 = inst_25729;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25707,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25769,state_val_25812,c__12283__auto__,event_chan){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25707,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25769,state_val_25812,c__12283__auto__,event_chan){
return (function (state_25767){
var state_val_25768 = (state_25767[(1)]);
if((state_val_25768 === (1))){
var inst_25758 = cljs.core.async.timeout.call(null,(20));
var state_25767__$1 = state_25767;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25767__$1,(2),inst_25758);
} else {
if((state_val_25768 === (2))){
var inst_25760 = (state_25767[(2)]);
var inst_25761 = grid.setColumns(new_columns);
var inst_25762 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25763 = grid.render();
var inst_25764 = hatti.views.table.select_rows_marked_to_be_deleted.call(null);
var inst_25765 = hatti.views.table.higlight_rows_marked_to_be_deleted.call(null,grid);
var state_25767__$1 = (function (){var statearr_25863 = state_25767;
(statearr_25863[(7)] = inst_25761);

(statearr_25863[(8)] = inst_25762);

(statearr_25863[(9)] = inst_25764);

(statearr_25863[(10)] = inst_25760);

(statearr_25863[(11)] = inst_25763);

return statearr_25863;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25767__$1,inst_25765);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25707,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25769,state_val_25812,c__12283__auto__,event_chan))
;
return ((function (switch__12171__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25707,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25769,state_val_25812,c__12283__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12172__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12172__auto____0 = (function (){
var statearr_25867 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25867[(0)] = hatti$views$table$handle_table_events_$_state_machine__12172__auto__);

(statearr_25867[(1)] = (1));

return statearr_25867;
});
var hatti$views$table$handle_table_events_$_state_machine__12172__auto____1 = (function (state_25767){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_25767);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e25868){if((e25868 instanceof Object)){
var ex__12175__auto__ = e25868;
var statearr_25869_25923 = state_25767;
(statearr_25869_25923[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25767);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25868;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25924 = state_25767;
state_25767 = G__25924;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12172__auto__ = function(state_25767){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12172__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12172__auto____1.call(this,state_25767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12172__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12172__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25707,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25769,state_val_25812,c__12283__auto__,event_chan))
})();
var state__12285__auto__ = (function (){var statearr_25870 = f__12284__auto__.call(null);
(statearr_25870[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto____$1);

return statearr_25870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12283__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25707,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25769,state_val_25812,c__12283__auto__,event_chan))
})();
var inst_25771 = cljs.core.async.impl.dispatch.run.call(null,inst_25770);
var state_25811__$1 = (function (){var statearr_25871 = state_25811;
(statearr_25871[(25)] = inst_25771);

return statearr_25871;
})();
var statearr_25872_25925 = state_25811__$1;
(statearr_25872_25925[(2)] = inst_25769);

(statearr_25872_25925[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (16))){
var inst_25731 = (state_25811[(8)]);
var inst_25735 = (state_25811[(10)]);
var inst_25734 = (state_25811[(13)]);
var inst_25732 = (state_25811[(14)]);
var inst_25739 = (state_25811[(9)]);
var inst_25730 = (state_25811[(15)]);
var inst_25733 = (state_25811[(16)]);
var inst_25729 = (state_25811[(17)]);
var inst_25729__$1 = (state_25811[(2)]);
var inst_25730__$1 = cljs.core.get.call(null,inst_25729__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_25731__$1 = cljs.core.get.call(null,inst_25729__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_25732__$1 = cljs.core.get.call(null,inst_25729__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_25733__$1 = cljs.core.get.call(null,inst_25729__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_25734__$1 = cljs.core.get.call(null,inst_25729__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_25735__$1 = cljs.core.get.call(null,inst_25729__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_25736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25737 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_25738 = (new cljs.core.PersistentVector(null,3,(5),inst_25736,inst_25737,null));
var inst_25739__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_25738);
var inst_25740 = (function (){var map__25707 = inst_25729__$1;
var submission_to_rank = inst_25730__$1;
var submission_clicked = inst_25731__$1;
var submission_unclicked = inst_25732__$1;
var filter_by = inst_25733__$1;
var new_columns = inst_25734__$1;
var re_render = inst_25735__$1;
var update_data_BANG_ = inst_25739__$1;
return ((function (map__25707,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25729__$1,inst_25730__$1,inst_25731__$1,inst_25732__$1,inst_25733__$1,inst_25734__$1,inst_25735__$1,inst_25736,inst_25737,inst_25738,inst_25739__$1,state_val_25812,c__12283__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__25707,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25729__$1,inst_25730__$1,inst_25731__$1,inst_25732__$1,inst_25733__$1,inst_25734__$1,inst_25735__$1,inst_25736,inst_25737,inst_25738,inst_25739__$1,state_val_25812,c__12283__auto__,event_chan){
return (function (p1__25520_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__25520_SHARP_,field));
});})(map__25707,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25729__$1,inst_25730__$1,inst_25731__$1,inst_25732__$1,inst_25733__$1,inst_25734__$1,inst_25735__$1,inst_25736,inst_25737,inst_25738,inst_25739__$1,state_val_25812,c__12283__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(map__25707,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25731,inst_25735,inst_25734,inst_25732,inst_25739,inst_25730,inst_25733,inst_25729,inst_25729__$1,inst_25730__$1,inst_25731__$1,inst_25732__$1,inst_25733__$1,inst_25734__$1,inst_25735__$1,inst_25736,inst_25737,inst_25738,inst_25739__$1,state_val_25812,c__12283__auto__,event_chan))
})();
var state_25811__$1 = (function (){var statearr_25873 = state_25811;
(statearr_25873[(12)] = inst_25740);

(statearr_25873[(8)] = inst_25731__$1);

(statearr_25873[(10)] = inst_25735__$1);

(statearr_25873[(13)] = inst_25734__$1);

(statearr_25873[(14)] = inst_25732__$1);

(statearr_25873[(9)] = inst_25739__$1);

(statearr_25873[(15)] = inst_25730__$1);

(statearr_25873[(16)] = inst_25733__$1);

(statearr_25873[(17)] = inst_25729__$1);

return statearr_25873;
})();
if(cljs.core.truth_(inst_25730__$1)){
var statearr_25874_25926 = state_25811__$1;
(statearr_25874_25926[(1)] = (17));

} else {
var statearr_25875_25927 = state_25811__$1;
(statearr_25875_25927[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (30))){
var state_25811__$1 = state_25811;
var statearr_25876_25928 = state_25811__$1;
(statearr_25876_25928[(2)] = null);

(statearr_25876_25928[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (10))){
var inst_25724 = (state_25811[(2)]);
var state_25811__$1 = state_25811;
if(cljs.core.truth_(inst_25724)){
var statearr_25877_25929 = state_25811__$1;
(statearr_25877_25929[(1)] = (14));

} else {
var statearr_25878_25930 = state_25811__$1;
(statearr_25878_25930[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (18))){
var state_25811__$1 = state_25811;
var statearr_25879_25931 = state_25811__$1;
(statearr_25879_25931[(2)] = null);

(statearr_25879_25931[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25812 === (8))){
var inst_25709 = (state_25811[(7)]);
var inst_25714 = inst_25709.cljs$lang$protocol_mask$partition0$;
var inst_25715 = (inst_25714 & (64));
var inst_25716 = inst_25709.cljs$core$ISeq$;
var inst_25717 = (inst_25715) || (inst_25716);
var state_25811__$1 = state_25811;
if(cljs.core.truth_(inst_25717)){
var statearr_25880_25932 = state_25811__$1;
(statearr_25880_25932[(1)] = (11));

} else {
var statearr_25881_25933 = state_25811__$1;
(statearr_25881_25933[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto__,event_chan))
;
return ((function (switch__12171__auto__,c__12283__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12172__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12172__auto____0 = (function (){
var statearr_25885 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25885[(0)] = hatti$views$table$handle_table_events_$_state_machine__12172__auto__);

(statearr_25885[(1)] = (1));

return statearr_25885;
});
var hatti$views$table$handle_table_events_$_state_machine__12172__auto____1 = (function (state_25811){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_25811);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e25886){if((e25886 instanceof Object)){
var ex__12175__auto__ = e25886;
var statearr_25887_25934 = state_25811;
(statearr_25887_25934[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25811);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25886;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25935 = state_25811;
state_25811 = G__25935;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12172__auto__ = function(state_25811){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12172__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12172__auto____1.call(this,state_25811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12172__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12172__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__,event_chan))
})();
var state__12285__auto__ = (function (){var statearr_25888 = f__12284__auto__.call(null);
(statearr_25888[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_25888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto__,event_chan))
);

return c__12283__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"field-key","field-key",313262601),k);

return colset_BANG_.call(null,k);
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__25952(s__25953){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__25953__$1 = s__25953;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25953__$1);
if(temp__4657__auto__){
var s__25953__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25953__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25953__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25955 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25954 = (0);
while(true){
if((i__25954 < size__7188__auto__)){
var vec__25962 = cljs.core._nth.call(null,c__7187__auto__,i__25954);
var k = cljs.core.nth.call(null,vec__25962,(0),null);
var v = cljs.core.nth.call(null,vec__25962,(1),null);
cljs.core.chunk_append.call(null,b__25955,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__25954,vec__25962,k,v,c__7187__auto__,size__7188__auto__,b__25955,s__25953__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__25954,vec__25962,k,v,c__7187__auto__,size__7188__auto__,b__25955,s__25953__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__25968 = (i__25954 + (1));
i__25954 = G__25968;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25955),hatti$views$table$render_options_$_iter__25952.call(null,cljs.core.chunk_rest.call(null,s__25953__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25955),null);
}
} else {
var vec__25965 = cljs.core.first.call(null,s__25953__$2);
var k = cljs.core.nth.call(null,vec__25965,(0),null);
var v = cljs.core.nth.call(null,vec__25965,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__25965,k,v,s__25953__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__25965,k,v,s__25953__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__25952.call(null,cljs.core.rest.call(null,s__25953__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table25970 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25970 = (function (_,owner,meta25971){
this._ = _;
this.owner = owner;
this.meta25971 = meta25971;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25970.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25972,meta25971__$1){
var self__ = this;
var _25972__$1 = this;
return (new hatti.views.table.t_hatti$views$table25970(self__._,self__.owner,meta25971__$1));
});

hatti.views.table.t_hatti$views$table25970.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25972){
var self__ = this;
var _25972__$1 = this;
return self__.meta25971;
});

hatti.views.table.t_hatti$views$table25970.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table25970.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field-key","field-key",313262601),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table25970.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table25970.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__25973){
var self__ = this;
var map__25974 = p__25973;
var map__25974__$1 = ((((!((map__25974 == null)))?((((map__25974.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25974.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25974):map__25974);
var field_key = cljs.core.get.call(null,map__25974__$1,new cljs.core.Keyword(null,"field-key","field-key",313262601));
var language = cljs.core.get.call(null,map__25974__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__25976 = om.core.get_shared.call(null,self__.owner);
var map__25976__$1 = ((((!((map__25976 == null)))?((((map__25976.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25976.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25976):map__25976);
var flat_form = cljs.core.get.call(null,map__25976__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__25976,map__25976__$1,flat_form,new_language,___$2,map__25974,map__25974__$1,field_key,language){
return (function (p1__25969_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__25969_SHARP_),new cljs.core.Keyword(null,"language","language",-1591107564),new_language,new cljs.core.Keyword(null,"owner","owner",-392611939),self__.owner)], null));
});})(options,map__25976,map__25976__$1,flat_form,new_language,___$2,map__25974,map__25974__$1,field_key,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,field_key);
} else {
}

return React.DOM.div(({"className": "label-changer"}),React.DOM.span(({"className": "label-changer-label"}),"Show:"),React.DOM.div(({"id": "header-display-dropdown", "className": "drop-hover"}),(function (){var attrs25980 = options.call(null,field_key);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs25980))?sablono.interpreter.attributes.call(null,attrs25980):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25980))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i(({"className": "fa fa-angle-down"}))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25980),React.DOM.i(({"className": "fa fa-angle-down"}))], null))));
})(),(function (){var attrs25985 = hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_);
return cljs.core.apply.call(null,React.DOM.ul,((cljs.core.map_QMARK_.call(null,attrs25985))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs25985)):({"className": "submenu no-dot"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25985))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25985)], null))));
})()));
});

hatti.views.table.t_hatti$views$table25970.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta25971","meta25971",-1841489365,null)], null);
});

hatti.views.table.t_hatti$views$table25970.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25970.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25970";

hatti.views.table.t_hatti$views$table25970.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25970");
});

hatti.views.table.__GT_t_hatti$views$table25970 = (function hatti$views$table$__GT_t_hatti$views$table25970(___$1,owner__$1,meta25971){
return (new hatti.views.table.t_hatti$views$table25970(___$1,owner__$1,meta25971));
});

}

return (new hatti.views.table.t_hatti$views$table25970(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12283__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12283__auto__,query){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__,query){
return (function (state_26028){
var state_val_26029 = (state_26028[(1)]);
if((state_val_26029 === (1))){
var inst_26014 = cljs.core.async.timeout.call(null,(150));
var state_26028__$1 = state_26028;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26028__$1,(2),inst_26014);
} else {
if((state_val_26029 === (2))){
var inst_26016 = (state_26028[(2)]);
var inst_26017 = input.value;
var inst_26018 = cljs.core._EQ_.call(null,query,inst_26017);
var state_26028__$1 = (function (){var statearr_26030 = state_26028;
(statearr_26030[(7)] = inst_26016);

return statearr_26030;
})();
if(inst_26018){
var statearr_26031_26042 = state_26028__$1;
(statearr_26031_26042[(1)] = (3));

} else {
var statearr_26032_26043 = state_26028__$1;
(statearr_26032_26043[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26029 === (3))){
var inst_26020 = [query_event_key];
var inst_26021 = [query];
var inst_26022 = cljs.core.PersistentHashMap.fromArrays(inst_26020,inst_26021);
var inst_26023 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_26022);
var state_26028__$1 = state_26028;
var statearr_26033_26044 = state_26028__$1;
(statearr_26033_26044[(2)] = inst_26023);

(statearr_26033_26044[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26029 === (4))){
var state_26028__$1 = state_26028;
var statearr_26034_26045 = state_26028__$1;
(statearr_26034_26045[(2)] = null);

(statearr_26034_26045[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26029 === (5))){
var inst_26026 = (state_26028[(2)]);
var state_26028__$1 = state_26028;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26028__$1,inst_26026);
} else {
return null;
}
}
}
}
}
});})(c__12283__auto__,query))
;
return ((function (switch__12171__auto__,c__12283__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12172__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12172__auto____0 = (function (){
var statearr_26038 = [null,null,null,null,null,null,null,null];
(statearr_26038[(0)] = hatti$views$table$delayed_search_$_state_machine__12172__auto__);

(statearr_26038[(1)] = (1));

return statearr_26038;
});
var hatti$views$table$delayed_search_$_state_machine__12172__auto____1 = (function (state_26028){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__.call(null,state_26028);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12174__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e26039){if((e26039 instanceof Object)){
var ex__12175__auto__ = e26039;
var statearr_26040_26046 = state_26028;
(statearr_26040_26046[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26028);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26039;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12173__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26047 = state_26028;
state_26028 = G__26047;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12172__auto__ = function(state_26028){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12172__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12172__auto____1.call(this,state_26028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12172__auto____0;
hatti$views$table$delayed_search_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12172__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__,query))
})();
var state__12285__auto__ = (function (){var statearr_26041 = f__12284__auto__.call(null);
(statearr_26041[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_26041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12285__auto__);
});})(c__12283__auto__,query))
);

return c__12283__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table26049 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26049 = (function (_,owner,meta26050){
this._ = _;
this.owner = owner;
this.meta26050 = meta26050;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26049.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26051,meta26050__$1){
var self__ = this;
var _26051__$1 = this;
return (new hatti.views.table.t_hatti$views$table26049(self__._,self__.owner,meta26050__$1));
});

hatti.views.table.t_hatti$views$table26049.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26051){
var self__ = this;
var _26051__$1 = this;
return self__.meta26050;
});

hatti.views.table.t_hatti$views$table26049.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table26049.prototype.om$core$IRender$render$arity$1 = (function (this__18366__auto__){
var self__ = this;
var this__18366__auto____$1 = this;
return React.DOM.div(({"className": "table-search"}),React.DOM.i(({"className": "fa fa-search"})),sablono.interpreter.input.call(null,({"type": "text", "placeholder": "Search", "onChange": ((function (this__18366__auto____$1){
return (function (p1__26048_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__26048_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__18366__auto____$1))
})));
});

hatti.views.table.t_hatti$views$table26049.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta26050","meta26050",-1813340745,null)], null);
});

hatti.views.table.t_hatti$views$table26049.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26049.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26049";

hatti.views.table.t_hatti$views$table26049.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26049");
});

hatti.views.table.__GT_t_hatti$views$table26049 = (function hatti$views$table$__GT_t_hatti$views$table26049(___$1,owner__$1,meta26050){
return (new hatti.views.table.t_hatti$views$table26049(___$1,owner__$1,meta26050));
});

}

return (new hatti.views.table.t_hatti$views$table26049(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table26054 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26054 = (function (cursor,owner,meta26055){
this.cursor = cursor;
this.owner = owner;
this.meta26055 = meta26055;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26054.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26056,meta26055__$1){
var self__ = this;
var _26056__$1 = this;
return (new hatti.views.table.t_hatti$views$table26054(self__.cursor,self__.owner,meta26055__$1));
});

hatti.views.table.t_hatti$views$table26054.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26056){
var self__ = this;
var _26056__$1 = this;
return self__.meta26055;
});

hatti.views.table.t_hatti$views$table26054.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table26054.prototype.om$core$IRender$render$arity$1 = (function (this__18366__auto__){
var self__ = this;
var this__18366__auto____$1 = this;
return React.DOM.div(({"className": "topbar"}),React.DOM.div(({"id": hatti.views.table.pager_id})),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,self__.cursor)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.cursor)),React.DOM.div(({"style": ({"clear": "both"})})));
});

hatti.views.table.t_hatti$views$table26054.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta26055","meta26055",-562425111,null)], null);
});

hatti.views.table.t_hatti$views$table26054.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26054.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26054";

hatti.views.table.t_hatti$views$table26054.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26054");
});

hatti.views.table.__GT_t_hatti$views$table26054 = (function hatti$views$table$__GT_t_hatti$views$table26054(cursor__$1,owner__$1,meta26055){
return (new hatti.views.table.t_hatti$views$table26054(cursor__$1,owner__$1,meta26055));
});

}

return (new hatti.views.table.t_hatti$views$table26054(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq.call(null,data)){
var map__26064 = om.core.get_shared.call(null,owner);
var map__26064__$1 = ((((!((map__26064 == null)))?((((map__26064.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26064.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26064):map__26064);
var flat_form = cljs.core.get.call(null,map__26064__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__26065 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__26065,(0),null);
var dataview = cljs.core.nth.call(null,vec__26065,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".table-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901),hatti.views.table.get_table_view_height.call(null));
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881),resize_handler);
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__26070,owner,p__26071){
var map__26072 = p__26070;
var map__26072__$1 = ((((!((map__26072 == null)))?((((map__26072.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26072.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26072):map__26072);
var cursor = map__26072__$1;
var map__26073 = cljs.core.get.call(null,map__26072__$1,new cljs.core.Keyword(null,"views","views",1450155487));
var map__26073__$1 = ((((!((map__26073 == null)))?((((map__26073.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26073.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26073):map__26073);
var active = cljs.core.get.call(null,map__26073__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var map__26074 = p__26071;
var map__26074__$1 = ((((!((map__26074 == null)))?((((map__26074.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26074.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26074):map__26074);
var opts = map__26074__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__26074__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

var active_QMARK_ = chimera.seq.in_QMARK_.call(null,active,new cljs.core.Keyword(null,"table","table",-564943036));
if(typeof hatti.views.table.t_hatti$views$table26078 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26078 = (function (owner,map__26074,map__26073,p__26070,active_QMARK_,slick_grid_event_handlers,map__26072,p__26071,cursor,active,opts,meta26079){
this.owner = owner;
this.map__26074 = map__26074;
this.map__26073 = map__26073;
this.p__26070 = p__26070;
this.active_QMARK_ = active_QMARK_;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.map__26072 = map__26072;
this.p__26071 = p__26071;
this.cursor = cursor;
this.active = active;
this.opts = opts;
this.meta26079 = meta26079;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26078.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers){
return (function (_26080,meta26079__$1){
var self__ = this;
var _26080__$1 = this;
return (new hatti.views.table.t_hatti$views$table26078(self__.owner,self__.map__26074,self__.map__26073,self__.p__26070,self__.active_QMARK_,self__.slick_grid_event_handlers,self__.map__26072,self__.p__26071,self__.cursor,self__.active,self__.opts,meta26079__$1));
});})(active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26078.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers){
return (function (_26080){
var self__ = this;
var _26080__$1 = this;
return self__.meta26079;
});})(active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26078.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table26078.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers){
return (function (_,p__26081){
var self__ = this;
var map__26082 = p__26081;
var map__26082__$1 = ((((!((map__26082 == null)))?((((map__26082.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26082.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26082):map__26082);
var table_view_height = cljs.core.get.call(null,map__26082__$1,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901));
var ___$1 = this;
var map__26084 = self__.cursor;
var map__26084__$1 = ((((!((map__26084 == null)))?((((map__26084.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26084.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26084):map__26084);
var map__26085 = cljs.core.get.call(null,map__26084__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__26085__$1 = ((((!((map__26085 == null)))?((((map__26085.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26085.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26085):map__26085);
var submission_clicked = cljs.core.get.call(null,map__26085__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var data = cljs.core.get.call(null,map__26084__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var dataset_info = cljs.core.get.call(null,map__26084__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var map__26086 = dataset_info;
var map__26086__$1 = ((((!((map__26086 == null)))?((((map__26086.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26086.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26086):map__26086);
var num_of_submissions = cljs.core.get.call(null,map__26086__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,data);
var with_info = ((function (map__26084,map__26084__$1,map__26085,map__26085__$1,submission_clicked,data,dataset_info,map__26086,map__26086__$1,num_of_submissions,no_data_QMARK_,___$1,map__26082,map__26082__$1,table_view_height,active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers){
return (function (p1__26069_SHARP_){
return cljs.core.merge.call(null,self__.cursor,p1__26069_SHARP_);
});})(map__26084,map__26084__$1,map__26085,map__26085__$1,submission_clicked,data,dataset_info,map__26086,map__26086__$1,num_of_submissions,no_data_QMARK_,___$1,map__26082,map__26082__$1,table_view_height,active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers))
;
cljs.core.swap_BANG_.call(null,hatti.shared.app_state,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901)], null),(((document.querySelector(".table-page") == null))?null:hatti.views.table.get_table_view_height.call(null)));

if(cljs.core.truth_(self__.active_QMARK_)){
return React.DOM.div(({"style": ({"overflow": "initial"}), "className": "table-view"}),sablono.interpreter.interpret.call(null,(cljs.core.truth_(new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.call(null,hatti.views.submission_view,with_info.call(null,submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null)):null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.cursor)),React.DOM.div(({"id": hatti.views.table.table_id, "className": "slickgrid"}),(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.p(({"className": "alert alert-warning"}),"No data"):React.DOM.span(null,React.DOM.i(({"className": "fa fa-spinner fa-pulse"})),"Loading..."))));
} else {
return null;
}
});})(active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26078.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table26078.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler.call(null,self__.owner);

var data = cljs.core.get_in.call(null,self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__26094 = temp__4657__auto__;
var grid = cljs.core.nth.call(null,vec__26094,(0),null);
var dataview = cljs.core.nth.call(null,vec__26094,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26078.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table26078.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.call(null,self__.owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881)));
});})(active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26078.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table26078.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__26097 = om.core.get_state.call(null,self__.owner);
var map__26097__$1 = ((((!((map__26097 == null)))?((((map__26097.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26097.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26097):map__26097);
var grid = cljs.core.get.call(null,map__26097__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__26097__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__26099 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__26099,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__26099,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,(function (){var G__26102 = new_data;
if(cljs.core.truth_(new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)))){
return hatti.views.table.replace_review_num_status_with_text_status.call(null,G__26102);
} else {
return G__26102;
}
})()),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26078.getBasis = ((function (active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"map__26074","map__26074",1404857446,null),new cljs.core.Symbol(null,"map__26073","map__26073",774270822,null),new cljs.core.Symbol(null,"p__26070","p__26070",1242972359,null),new cljs.core.Symbol(null,"active?","active?",2100031303,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"map__26072","map__26072",862211341,null),new cljs.core.Symbol(null,"p__26071","p__26071",-1812750447,null),new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"active","active",-758473701,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"meta26079","meta26079",-1166238005,null)], null);
});})(active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26078.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26078.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26078";

hatti.views.table.t_hatti$views$table26078.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26078");
});})(active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table26078 = ((function (active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table26078(owner__$1,map__26074__$2,map__26073__$2,p__26070__$1,active_QMARK___$1,slick_grid_event_handlers__$1,map__26072__$2,p__26071__$1,cursor__$1,active__$1,opts__$1,meta26079){
return (new hatti.views.table.t_hatti$views$table26078(owner__$1,map__26074__$2,map__26073__$2,p__26070__$1,active_QMARK___$1,slick_grid_event_handlers__$1,map__26072__$2,p__26071__$1,cursor__$1,active__$1,opts__$1,meta26079));
});})(active_QMARK_,map__26072,map__26072__$1,cursor,map__26073,map__26073__$1,active,map__26074,map__26074__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table26078(owner,map__26074__$1,map__26073__$1,p__26070,active_QMARK_,slick_grid_event_handlers,map__26072__$1,p__26071,cursor,active,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
