// Compiled by ClojureScript 1.9.229 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__19697__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__19694 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__19695 = cljs.core.seq.call(null,vec__19694);
var first__19696 = cljs.core.first.call(null,seq__19695);
var seq__19695__$1 = cljs.core.next.call(null,seq__19695);
var tag = first__19696;
var body = seq__19695__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__19697 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__19698__i = 0, G__19698__a = new Array(arguments.length -  0);
while (G__19698__i < G__19698__a.length) {G__19698__a[G__19698__i] = arguments[G__19698__i + 0]; ++G__19698__i;}
  args = new cljs.core.IndexedSeq(G__19698__a,0);
} 
return G__19697__delegate.call(this,args);};
G__19697.cljs$lang$maxFixedArity = 0;
G__19697.cljs$lang$applyTo = (function (arglist__19699){
var args = cljs.core.seq(arglist__19699);
return G__19697__delegate(args);
});
G__19697.cljs$core$IFn$_invoke$arity$variadic = G__19697__delegate;
return G__19697;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__19704(s__19705){
return (new cljs.core.LazySeq(null,(function (){
var s__19705__$1 = s__19705;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19705__$1);
if(temp__4657__auto__){
var s__19705__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19705__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19705__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19707 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19706 = (0);
while(true){
if((i__19706 < size__7188__auto__)){
var args = cljs.core._nth.call(null,c__7187__auto__,i__19706);
cljs.core.chunk_append.call(null,b__19707,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__19708 = (i__19706 + (1));
i__19706 = G__19708;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19707),sablono$core$update_arglists_$_iter__19704.call(null,cljs.core.chunk_rest.call(null,s__19705__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19707),null);
}
} else {
var args = cljs.core.first.call(null,s__19705__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__19704.call(null,cljs.core.rest.call(null,s__19705__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19714 = arguments.length;
var i__7485__auto___19715 = (0);
while(true){
if((i__7485__auto___19715 < len__7484__auto___19714)){
args__7491__auto__.push((arguments[i__7485__auto___19715]));

var G__19716 = (i__7485__auto___19715 + (1));
i__7485__auto___19715 = G__19716;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__19710(s__19711){
return (new cljs.core.LazySeq(null,(function (){
var s__19711__$1 = s__19711;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19711__$1);
if(temp__4657__auto__){
var s__19711__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19711__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19711__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19713 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19712 = (0);
while(true){
if((i__19712 < size__7188__auto__)){
var style = cljs.core._nth.call(null,c__7187__auto__,i__19712);
cljs.core.chunk_append.call(null,b__19713,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__19717 = (i__19712 + (1));
i__19712 = G__19717;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19713),sablono$core$iter__19710.call(null,cljs.core.chunk_rest.call(null,s__19711__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19713),null);
}
} else {
var style = cljs.core.first.call(null,s__19711__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__19710.call(null,cljs.core.rest.call(null,s__19711__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq19709){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19709));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to19718 = (function sablono$core$link_to19718(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19721 = arguments.length;
var i__7485__auto___19722 = (0);
while(true){
if((i__7485__auto___19722 < len__7484__auto___19721)){
args__7491__auto__.push((arguments[i__7485__auto___19722]));

var G__19723 = (i__7485__auto___19722 + (1));
i__7485__auto___19722 = G__19723;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to19718.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to19718.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to19718.cljs$lang$maxFixedArity = (1);

sablono.core.link_to19718.cljs$lang$applyTo = (function (seq19719){
var G__19720 = cljs.core.first.call(null,seq19719);
var seq19719__$1 = cljs.core.next.call(null,seq19719);
return sablono.core.link_to19718.cljs$core$IFn$_invoke$arity$variadic(G__19720,seq19719__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to19718);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to19724 = (function sablono$core$mail_to19724(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19731 = arguments.length;
var i__7485__auto___19732 = (0);
while(true){
if((i__7485__auto___19732 < len__7484__auto___19731)){
args__7491__auto__.push((arguments[i__7485__auto___19732]));

var G__19733 = (i__7485__auto___19732 + (1));
i__7485__auto___19732 = G__19733;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to19724.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to19724.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__19727){
var vec__19728 = p__19727;
var content = cljs.core.nth.call(null,vec__19728,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to19724.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to19724.cljs$lang$applyTo = (function (seq19725){
var G__19726 = cljs.core.first.call(null,seq19725);
var seq19725__$1 = cljs.core.next.call(null,seq19725);
return sablono.core.mail_to19724.cljs$core$IFn$_invoke$arity$variadic(G__19726,seq19725__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to19724);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list19734 = (function sablono$core$unordered_list19734(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__7189__auto__ = (function sablono$core$unordered_list19734_$_iter__19739(s__19740){
return (new cljs.core.LazySeq(null,(function (){
var s__19740__$1 = s__19740;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19740__$1);
if(temp__4657__auto__){
var s__19740__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19740__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19740__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19742 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19741 = (0);
while(true){
if((i__19741 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19741);
cljs.core.chunk_append.call(null,b__19742,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__19743 = (i__19741 + (1));
i__19741 = G__19743;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19742),sablono$core$unordered_list19734_$_iter__19739.call(null,cljs.core.chunk_rest.call(null,s__19740__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19742),null);
}
} else {
var x = cljs.core.first.call(null,s__19740__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list19734_$_iter__19739.call(null,cljs.core.rest.call(null,s__19740__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list19734);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list19744 = (function sablono$core$ordered_list19744(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__7189__auto__ = (function sablono$core$ordered_list19744_$_iter__19749(s__19750){
return (new cljs.core.LazySeq(null,(function (){
var s__19750__$1 = s__19750;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19750__$1);
if(temp__4657__auto__){
var s__19750__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19750__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19750__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19752 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19751 = (0);
while(true){
if((i__19751 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19751);
cljs.core.chunk_append.call(null,b__19752,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__19753 = (i__19751 + (1));
i__19751 = G__19753;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19752),sablono$core$ordered_list19744_$_iter__19749.call(null,cljs.core.chunk_rest.call(null,s__19750__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19752),null);
}
} else {
var x = cljs.core.first.call(null,s__19750__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list19744_$_iter__19749.call(null,cljs.core.rest.call(null,s__19750__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list19744);
/**
 * Create an image element.
 */
sablono.core.image19754 = (function sablono$core$image19754(var_args){
var args19755 = [];
var len__7484__auto___19758 = arguments.length;
var i__7485__auto___19759 = (0);
while(true){
if((i__7485__auto___19759 < len__7484__auto___19758)){
args19755.push((arguments[i__7485__auto___19759]));

var G__19760 = (i__7485__auto___19759 + (1));
i__7485__auto___19759 = G__19760;
continue;
} else {
}
break;
}

var G__19757 = args19755.length;
switch (G__19757) {
case 1:
return sablono.core.image19754.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image19754.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19755.length)].join('')));

}
});

sablono.core.image19754.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image19754.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image19754.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image19754);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__19762_SHARP_,p2__19763_SHARP_){
return [cljs.core.str(p1__19762_SHARP_),cljs.core.str("["),cljs.core.str(p2__19763_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__19764_SHARP_,p2__19765_SHARP_){
return [cljs.core.str(p1__19764_SHARP_),cljs.core.str("-"),cljs.core.str(p2__19765_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field19766 = (function sablono$core$color_field19766(var_args){
var args19767 = [];
var len__7484__auto___19834 = arguments.length;
var i__7485__auto___19835 = (0);
while(true){
if((i__7485__auto___19835 < len__7484__auto___19834)){
args19767.push((arguments[i__7485__auto___19835]));

var G__19836 = (i__7485__auto___19835 + (1));
i__7485__auto___19835 = G__19836;
continue;
} else {
}
break;
}

var G__19769 = args19767.length;
switch (G__19769) {
case 1:
return sablono.core.color_field19766.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field19766.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19767.length)].join('')));

}
});

sablono.core.color_field19766.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.color_field19766.call(null,name__19611__auto__,null);
});

sablono.core.color_field19766.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.color_field19766.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field19766);

/**
 * Creates a date input field.
 */
sablono.core.date_field19770 = (function sablono$core$date_field19770(var_args){
var args19771 = [];
var len__7484__auto___19838 = arguments.length;
var i__7485__auto___19839 = (0);
while(true){
if((i__7485__auto___19839 < len__7484__auto___19838)){
args19771.push((arguments[i__7485__auto___19839]));

var G__19840 = (i__7485__auto___19839 + (1));
i__7485__auto___19839 = G__19840;
continue;
} else {
}
break;
}

var G__19773 = args19771.length;
switch (G__19773) {
case 1:
return sablono.core.date_field19770.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field19770.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19771.length)].join('')));

}
});

sablono.core.date_field19770.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.date_field19770.call(null,name__19611__auto__,null);
});

sablono.core.date_field19770.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.date_field19770.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field19770);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field19774 = (function sablono$core$datetime_field19774(var_args){
var args19775 = [];
var len__7484__auto___19842 = arguments.length;
var i__7485__auto___19843 = (0);
while(true){
if((i__7485__auto___19843 < len__7484__auto___19842)){
args19775.push((arguments[i__7485__auto___19843]));

var G__19844 = (i__7485__auto___19843 + (1));
i__7485__auto___19843 = G__19844;
continue;
} else {
}
break;
}

var G__19777 = args19775.length;
switch (G__19777) {
case 1:
return sablono.core.datetime_field19774.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field19774.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19775.length)].join('')));

}
});

sablono.core.datetime_field19774.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.datetime_field19774.call(null,name__19611__auto__,null);
});

sablono.core.datetime_field19774.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.datetime_field19774.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field19774);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field19778 = (function sablono$core$datetime_local_field19778(var_args){
var args19779 = [];
var len__7484__auto___19846 = arguments.length;
var i__7485__auto___19847 = (0);
while(true){
if((i__7485__auto___19847 < len__7484__auto___19846)){
args19779.push((arguments[i__7485__auto___19847]));

var G__19848 = (i__7485__auto___19847 + (1));
i__7485__auto___19847 = G__19848;
continue;
} else {
}
break;
}

var G__19781 = args19779.length;
switch (G__19781) {
case 1:
return sablono.core.datetime_local_field19778.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field19778.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19779.length)].join('')));

}
});

sablono.core.datetime_local_field19778.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.datetime_local_field19778.call(null,name__19611__auto__,null);
});

sablono.core.datetime_local_field19778.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.datetime_local_field19778.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field19778);

/**
 * Creates a email input field.
 */
sablono.core.email_field19782 = (function sablono$core$email_field19782(var_args){
var args19783 = [];
var len__7484__auto___19850 = arguments.length;
var i__7485__auto___19851 = (0);
while(true){
if((i__7485__auto___19851 < len__7484__auto___19850)){
args19783.push((arguments[i__7485__auto___19851]));

var G__19852 = (i__7485__auto___19851 + (1));
i__7485__auto___19851 = G__19852;
continue;
} else {
}
break;
}

var G__19785 = args19783.length;
switch (G__19785) {
case 1:
return sablono.core.email_field19782.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field19782.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19783.length)].join('')));

}
});

sablono.core.email_field19782.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.email_field19782.call(null,name__19611__auto__,null);
});

sablono.core.email_field19782.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.email_field19782.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field19782);

/**
 * Creates a file input field.
 */
sablono.core.file_field19786 = (function sablono$core$file_field19786(var_args){
var args19787 = [];
var len__7484__auto___19854 = arguments.length;
var i__7485__auto___19855 = (0);
while(true){
if((i__7485__auto___19855 < len__7484__auto___19854)){
args19787.push((arguments[i__7485__auto___19855]));

var G__19856 = (i__7485__auto___19855 + (1));
i__7485__auto___19855 = G__19856;
continue;
} else {
}
break;
}

var G__19789 = args19787.length;
switch (G__19789) {
case 1:
return sablono.core.file_field19786.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field19786.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19787.length)].join('')));

}
});

sablono.core.file_field19786.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.file_field19786.call(null,name__19611__auto__,null);
});

sablono.core.file_field19786.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.file_field19786.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field19786);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field19790 = (function sablono$core$hidden_field19790(var_args){
var args19791 = [];
var len__7484__auto___19858 = arguments.length;
var i__7485__auto___19859 = (0);
while(true){
if((i__7485__auto___19859 < len__7484__auto___19858)){
args19791.push((arguments[i__7485__auto___19859]));

var G__19860 = (i__7485__auto___19859 + (1));
i__7485__auto___19859 = G__19860;
continue;
} else {
}
break;
}

var G__19793 = args19791.length;
switch (G__19793) {
case 1:
return sablono.core.hidden_field19790.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field19790.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19791.length)].join('')));

}
});

sablono.core.hidden_field19790.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.hidden_field19790.call(null,name__19611__auto__,null);
});

sablono.core.hidden_field19790.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.hidden_field19790.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field19790);

/**
 * Creates a month input field.
 */
sablono.core.month_field19794 = (function sablono$core$month_field19794(var_args){
var args19795 = [];
var len__7484__auto___19862 = arguments.length;
var i__7485__auto___19863 = (0);
while(true){
if((i__7485__auto___19863 < len__7484__auto___19862)){
args19795.push((arguments[i__7485__auto___19863]));

var G__19864 = (i__7485__auto___19863 + (1));
i__7485__auto___19863 = G__19864;
continue;
} else {
}
break;
}

var G__19797 = args19795.length;
switch (G__19797) {
case 1:
return sablono.core.month_field19794.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field19794.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19795.length)].join('')));

}
});

sablono.core.month_field19794.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.month_field19794.call(null,name__19611__auto__,null);
});

sablono.core.month_field19794.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.month_field19794.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field19794);

/**
 * Creates a number input field.
 */
sablono.core.number_field19798 = (function sablono$core$number_field19798(var_args){
var args19799 = [];
var len__7484__auto___19866 = arguments.length;
var i__7485__auto___19867 = (0);
while(true){
if((i__7485__auto___19867 < len__7484__auto___19866)){
args19799.push((arguments[i__7485__auto___19867]));

var G__19868 = (i__7485__auto___19867 + (1));
i__7485__auto___19867 = G__19868;
continue;
} else {
}
break;
}

var G__19801 = args19799.length;
switch (G__19801) {
case 1:
return sablono.core.number_field19798.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field19798.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19799.length)].join('')));

}
});

sablono.core.number_field19798.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.number_field19798.call(null,name__19611__auto__,null);
});

sablono.core.number_field19798.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.number_field19798.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field19798);

/**
 * Creates a password input field.
 */
sablono.core.password_field19802 = (function sablono$core$password_field19802(var_args){
var args19803 = [];
var len__7484__auto___19870 = arguments.length;
var i__7485__auto___19871 = (0);
while(true){
if((i__7485__auto___19871 < len__7484__auto___19870)){
args19803.push((arguments[i__7485__auto___19871]));

var G__19872 = (i__7485__auto___19871 + (1));
i__7485__auto___19871 = G__19872;
continue;
} else {
}
break;
}

var G__19805 = args19803.length;
switch (G__19805) {
case 1:
return sablono.core.password_field19802.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field19802.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19803.length)].join('')));

}
});

sablono.core.password_field19802.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.password_field19802.call(null,name__19611__auto__,null);
});

sablono.core.password_field19802.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.password_field19802.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field19802);

/**
 * Creates a range input field.
 */
sablono.core.range_field19806 = (function sablono$core$range_field19806(var_args){
var args19807 = [];
var len__7484__auto___19874 = arguments.length;
var i__7485__auto___19875 = (0);
while(true){
if((i__7485__auto___19875 < len__7484__auto___19874)){
args19807.push((arguments[i__7485__auto___19875]));

var G__19876 = (i__7485__auto___19875 + (1));
i__7485__auto___19875 = G__19876;
continue;
} else {
}
break;
}

var G__19809 = args19807.length;
switch (G__19809) {
case 1:
return sablono.core.range_field19806.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field19806.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19807.length)].join('')));

}
});

sablono.core.range_field19806.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.range_field19806.call(null,name__19611__auto__,null);
});

sablono.core.range_field19806.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.range_field19806.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field19806);

/**
 * Creates a search input field.
 */
sablono.core.search_field19810 = (function sablono$core$search_field19810(var_args){
var args19811 = [];
var len__7484__auto___19878 = arguments.length;
var i__7485__auto___19879 = (0);
while(true){
if((i__7485__auto___19879 < len__7484__auto___19878)){
args19811.push((arguments[i__7485__auto___19879]));

var G__19880 = (i__7485__auto___19879 + (1));
i__7485__auto___19879 = G__19880;
continue;
} else {
}
break;
}

var G__19813 = args19811.length;
switch (G__19813) {
case 1:
return sablono.core.search_field19810.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field19810.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19811.length)].join('')));

}
});

sablono.core.search_field19810.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.search_field19810.call(null,name__19611__auto__,null);
});

sablono.core.search_field19810.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.search_field19810.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field19810);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field19814 = (function sablono$core$tel_field19814(var_args){
var args19815 = [];
var len__7484__auto___19882 = arguments.length;
var i__7485__auto___19883 = (0);
while(true){
if((i__7485__auto___19883 < len__7484__auto___19882)){
args19815.push((arguments[i__7485__auto___19883]));

var G__19884 = (i__7485__auto___19883 + (1));
i__7485__auto___19883 = G__19884;
continue;
} else {
}
break;
}

var G__19817 = args19815.length;
switch (G__19817) {
case 1:
return sablono.core.tel_field19814.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field19814.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19815.length)].join('')));

}
});

sablono.core.tel_field19814.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.tel_field19814.call(null,name__19611__auto__,null);
});

sablono.core.tel_field19814.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.tel_field19814.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field19814);

/**
 * Creates a text input field.
 */
sablono.core.text_field19818 = (function sablono$core$text_field19818(var_args){
var args19819 = [];
var len__7484__auto___19886 = arguments.length;
var i__7485__auto___19887 = (0);
while(true){
if((i__7485__auto___19887 < len__7484__auto___19886)){
args19819.push((arguments[i__7485__auto___19887]));

var G__19888 = (i__7485__auto___19887 + (1));
i__7485__auto___19887 = G__19888;
continue;
} else {
}
break;
}

var G__19821 = args19819.length;
switch (G__19821) {
case 1:
return sablono.core.text_field19818.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field19818.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19819.length)].join('')));

}
});

sablono.core.text_field19818.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.text_field19818.call(null,name__19611__auto__,null);
});

sablono.core.text_field19818.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.text_field19818.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field19818);

/**
 * Creates a time input field.
 */
sablono.core.time_field19822 = (function sablono$core$time_field19822(var_args){
var args19823 = [];
var len__7484__auto___19890 = arguments.length;
var i__7485__auto___19891 = (0);
while(true){
if((i__7485__auto___19891 < len__7484__auto___19890)){
args19823.push((arguments[i__7485__auto___19891]));

var G__19892 = (i__7485__auto___19891 + (1));
i__7485__auto___19891 = G__19892;
continue;
} else {
}
break;
}

var G__19825 = args19823.length;
switch (G__19825) {
case 1:
return sablono.core.time_field19822.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field19822.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19823.length)].join('')));

}
});

sablono.core.time_field19822.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.time_field19822.call(null,name__19611__auto__,null);
});

sablono.core.time_field19822.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.time_field19822.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field19822);

/**
 * Creates a url input field.
 */
sablono.core.url_field19826 = (function sablono$core$url_field19826(var_args){
var args19827 = [];
var len__7484__auto___19894 = arguments.length;
var i__7485__auto___19895 = (0);
while(true){
if((i__7485__auto___19895 < len__7484__auto___19894)){
args19827.push((arguments[i__7485__auto___19895]));

var G__19896 = (i__7485__auto___19895 + (1));
i__7485__auto___19895 = G__19896;
continue;
} else {
}
break;
}

var G__19829 = args19827.length;
switch (G__19829) {
case 1:
return sablono.core.url_field19826.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field19826.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19827.length)].join('')));

}
});

sablono.core.url_field19826.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.url_field19826.call(null,name__19611__auto__,null);
});

sablono.core.url_field19826.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.url_field19826.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field19826);

/**
 * Creates a week input field.
 */
sablono.core.week_field19830 = (function sablono$core$week_field19830(var_args){
var args19831 = [];
var len__7484__auto___19898 = arguments.length;
var i__7485__auto___19899 = (0);
while(true){
if((i__7485__auto___19899 < len__7484__auto___19898)){
args19831.push((arguments[i__7485__auto___19899]));

var G__19900 = (i__7485__auto___19899 + (1));
i__7485__auto___19899 = G__19900;
continue;
} else {
}
break;
}

var G__19833 = args19831.length;
switch (G__19833) {
case 1:
return sablono.core.week_field19830.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field19830.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19831.length)].join('')));

}
});

sablono.core.week_field19830.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.week_field19830.call(null,name__19611__auto__,null);
});

sablono.core.week_field19830.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.week_field19830.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field19830);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box19902 = (function sablono$core$check_box19902(var_args){
var args19903 = [];
var len__7484__auto___19906 = arguments.length;
var i__7485__auto___19907 = (0);
while(true){
if((i__7485__auto___19907 < len__7484__auto___19906)){
args19903.push((arguments[i__7485__auto___19907]));

var G__19908 = (i__7485__auto___19907 + (1));
i__7485__auto___19907 = G__19908;
continue;
} else {
}
break;
}

var G__19905 = args19903.length;
switch (G__19905) {
case 1:
return sablono.core.check_box19902.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box19902.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box19902.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19903.length)].join('')));

}
});

sablono.core.check_box19902.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box19902.call(null,name,null);
});

sablono.core.check_box19902.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box19902.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box19902.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box19902.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box19902);
/**
 * Creates a radio button.
 */
sablono.core.radio_button19910 = (function sablono$core$radio_button19910(var_args){
var args19911 = [];
var len__7484__auto___19914 = arguments.length;
var i__7485__auto___19915 = (0);
while(true){
if((i__7485__auto___19915 < len__7484__auto___19914)){
args19911.push((arguments[i__7485__auto___19915]));

var G__19916 = (i__7485__auto___19915 + (1));
i__7485__auto___19915 = G__19916;
continue;
} else {
}
break;
}

var G__19913 = args19911.length;
switch (G__19913) {
case 1:
return sablono.core.radio_button19910.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button19910.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button19910.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19911.length)].join('')));

}
});

sablono.core.radio_button19910.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button19910.call(null,group,null);
});

sablono.core.radio_button19910.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button19910.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button19910.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button19910.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button19910);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options19918 = (function sablono$core$select_options19918(var_args){
var args19919 = [];
var len__7484__auto___19938 = arguments.length;
var i__7485__auto___19939 = (0);
while(true){
if((i__7485__auto___19939 < len__7484__auto___19938)){
args19919.push((arguments[i__7485__auto___19939]));

var G__19940 = (i__7485__auto___19939 + (1));
i__7485__auto___19939 = G__19940;
continue;
} else {
}
break;
}

var G__19921 = args19919.length;
switch (G__19921) {
case 1:
return sablono.core.select_options19918.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options19918.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19919.length)].join('')));

}
});

sablono.core.select_options19918.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options19918.call(null,coll,null);
});

sablono.core.select_options19918.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__19922(s__19923){
return (new cljs.core.LazySeq(null,(function (){
var s__19923__$1 = s__19923;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19923__$1);
if(temp__4657__auto__){
var s__19923__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19923__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19923__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19925 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19924 = (0);
while(true){
if((i__19924 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19924);
cljs.core.chunk_append.call(null,b__19925,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__19932 = x;
var text = cljs.core.nth.call(null,vec__19932,(0),null);
var val = cljs.core.nth.call(null,vec__19932,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__19932,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options19918.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__19942 = (i__19924 + (1));
i__19924 = G__19942;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19925),sablono$core$iter__19922.call(null,cljs.core.chunk_rest.call(null,s__19923__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19925),null);
}
} else {
var x = cljs.core.first.call(null,s__19923__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__19935 = x;
var text = cljs.core.nth.call(null,vec__19935,(0),null);
var val = cljs.core.nth.call(null,vec__19935,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__19935,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options19918.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__19922.call(null,cljs.core.rest.call(null,s__19923__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
});

sablono.core.select_options19918.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options19918);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down19943 = (function sablono$core$drop_down19943(var_args){
var args19944 = [];
var len__7484__auto___19947 = arguments.length;
var i__7485__auto___19948 = (0);
while(true){
if((i__7485__auto___19948 < len__7484__auto___19947)){
args19944.push((arguments[i__7485__auto___19948]));

var G__19949 = (i__7485__auto___19948 + (1));
i__7485__auto___19948 = G__19949;
continue;
} else {
}
break;
}

var G__19946 = args19944.length;
switch (G__19946) {
case 2:
return sablono.core.drop_down19943.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down19943.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19944.length)].join('')));

}
});

sablono.core.drop_down19943.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down19943.call(null,name,options,null);
});

sablono.core.drop_down19943.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down19943.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down19943);
/**
 * Creates a text area element.
 */
sablono.core.text_area19951 = (function sablono$core$text_area19951(var_args){
var args19952 = [];
var len__7484__auto___19955 = arguments.length;
var i__7485__auto___19956 = (0);
while(true){
if((i__7485__auto___19956 < len__7484__auto___19955)){
args19952.push((arguments[i__7485__auto___19956]));

var G__19957 = (i__7485__auto___19956 + (1));
i__7485__auto___19956 = G__19957;
continue;
} else {
}
break;
}

var G__19954 = args19952.length;
switch (G__19954) {
case 1:
return sablono.core.text_area19951.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area19951.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19952.length)].join('')));

}
});

sablono.core.text_area19951.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area19951.call(null,name,null);
});

sablono.core.text_area19951.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area19951.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area19951);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label19959 = (function sablono$core$label19959(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label19959);
/**
 * Creates a submit button.
 */
sablono.core.submit_button19960 = (function sablono$core$submit_button19960(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button19960);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button19961 = (function sablono$core$reset_button19961(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button19961);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to19962 = (function sablono$core$form_to19962(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19969 = arguments.length;
var i__7485__auto___19970 = (0);
while(true){
if((i__7485__auto___19970 < len__7484__auto___19969)){
args__7491__auto__.push((arguments[i__7485__auto___19970]));

var G__19971 = (i__7485__auto___19970 + (1));
i__7485__auto___19970 = G__19971;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to19962.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to19962.cljs$core$IFn$_invoke$arity$variadic = (function (p__19965,body){
var vec__19966 = p__19965;
var method = cljs.core.nth.call(null,vec__19966,(0),null);
var action = cljs.core.nth.call(null,vec__19966,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to19962.cljs$lang$maxFixedArity = (1);

sablono.core.form_to19962.cljs$lang$applyTo = (function (seq19963){
var G__19964 = cljs.core.first.call(null,seq19963);
var seq19963__$1 = cljs.core.next.call(null,seq19963);
return sablono.core.form_to19962.cljs$core$IFn$_invoke$arity$variadic(G__19964,seq19963__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to19962);
