// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('chimera.metrics');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('clojure.string');
/**
 * In CLJ, return a string that is a valid JS function call to `ga` passing
 * it the non-nil `args`.
 * In CLJS, get google analytics `ga` object and call with the non-nil `args`.
 * If `ga` does not exist do nothing.
 */
chimera.metrics.call_ga = (function chimera$metrics$call_ga(var_args){
var args__7491__auto__ = [];
var len__7484__auto___44041 = arguments.length;
var i__7485__auto___44042 = (0);
while(true){
if((i__7485__auto___44042 < len__7484__auto___44041)){
args__7491__auto__.push((arguments[i__7485__auto___44042]));

var G__44043 = (i__7485__auto___44042 + (1));
i__7485__auto___44042 = G__44043;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return chimera.metrics.call_ga.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

chimera.metrics.call_ga.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var final_args = chimera.seq.remove_nil(args);
var temp__4657__auto__ = (window["ga"]);
if(cljs.core.truth_(temp__4657__auto__)){
var g = temp__4657__auto__;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(g,final_args);
} else {
return null;
}
});

chimera.metrics.call_ga.cljs$lang$maxFixedArity = (0);

chimera.metrics.call_ga.cljs$lang$applyTo = (function (seq44040){
return chimera.metrics.call_ga.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44040));
});


/**
 * Generic protocol for analytics events.
 * @interface
 */
chimera.metrics.AnalyticsEvent = function(){};

/**
 * Call the event appropriately for the target.
 */
chimera.metrics.call_analytics_event = (function chimera$metrics$call_analytics_event(x,event_label,event_value){
if((!((x == null))) && (!((x.chimera$metrics$AnalyticsEvent$call_analytics_event$arity$3 == null)))){
return x.chimera$metrics$AnalyticsEvent$call_analytics_event$arity$3(x,event_label,event_value);
} else {
var x__7072__auto__ = (((x == null))?null:x);
var m__7073__auto__ = (chimera.metrics.call_analytics_event[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(x,event_label,event_value) : m__7073__auto__.call(null,x,event_label,event_value));
} else {
var m__7073__auto____$1 = (chimera.metrics.call_analytics_event["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(x,event_label,event_value) : m__7073__auto____$1.call(null,x,event_label,event_value));
} else {
throw cljs.core.missing_protocol("AnalyticsEvent.call-analytics-event",x);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {chimera.metrics.AnalyticsEvent}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
chimera.metrics.GaEvent = (function (event_category,event_action,__meta,__extmap,__hash){
this.event_category = event_category;
this.event_action = event_action;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
chimera.metrics.GaEvent.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7031__auto__,k__7032__auto__){
var self__ = this;
var this__7031__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__7031__auto____$1,k__7032__auto__,null);
});

chimera.metrics.GaEvent.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7033__auto__,k44045,else__7034__auto__){
var self__ = this;
var this__7033__auto____$1 = this;
var G__44047 = (((k44045 instanceof cljs.core.Keyword))?k44045.fqn:null);
switch (G__44047) {
case "event-category":
return self__.event_category;

break;
case "event-action":
return self__.event_action;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k44045,else__7034__auto__);

}
});

chimera.metrics.GaEvent.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7045__auto__,writer__7046__auto__,opts__7047__auto__){
var self__ = this;
var this__7045__auto____$1 = this;
var pr_pair__7048__auto__ = ((function (this__7045__auto____$1){
return (function (keyval__7049__auto__){
return cljs.core.pr_sequential_writer(writer__7046__auto__,cljs.core.pr_writer,""," ","",opts__7047__auto__,keyval__7049__auto__);
});})(this__7045__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7046__auto__,pr_pair__7048__auto__,"#chimera.metrics.GaEvent{",", ","}",opts__7047__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$event_DASH_category,self__.event_category],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$event_DASH_action,self__.event_action],null))], null),self__.__extmap));
});

chimera.metrics.GaEvent.prototype.cljs$core$IIterable$ = true;

chimera.metrics.GaEvent.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__44044){
var self__ = this;
var G__44044__$1 = this;
return (new cljs.core.RecordIter((0),G__44044__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$event_DASH_category,cljs.core.cst$kw$event_DASH_action], null),cljs.core._iterator(self__.__extmap)));
});

chimera.metrics.GaEvent.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7029__auto__){
var self__ = this;
var this__7029__auto____$1 = this;
return self__.__meta;
});

chimera.metrics.GaEvent.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7025__auto__){
var self__ = this;
var this__7025__auto____$1 = this;
return (new chimera.metrics.GaEvent(self__.event_category,self__.event_action,self__.__meta,self__.__extmap,self__.__hash));
});

chimera.metrics.GaEvent.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7035__auto__){
var self__ = this;
var this__7035__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

chimera.metrics.GaEvent.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7026__auto__){
var self__ = this;
var this__7026__auto____$1 = this;
var h__6844__auto__ = self__.__hash;
if(!((h__6844__auto__ == null))){
return h__6844__auto__;
} else {
var h__6844__auto____$1 = cljs.core.hash_imap(this__7026__auto____$1);
self__.__hash = h__6844__auto____$1;

return h__6844__auto____$1;
}
});

chimera.metrics.GaEvent.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7027__auto__,other__7028__auto__){
var self__ = this;
var this__7027__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6397__auto__ = other__7028__auto__;
if(cljs.core.truth_(and__6397__auto__)){
var and__6397__auto____$1 = (this__7027__auto____$1.constructor === other__7028__auto__.constructor);
if(and__6397__auto____$1){
return cljs.core.equiv_map(this__7027__auto____$1,other__7028__auto__);
} else {
return and__6397__auto____$1;
}
} else {
return and__6397__auto__;
}
})())){
return true;
} else {
return false;
}
});

chimera.metrics.GaEvent.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7040__auto__,k__7041__auto__){
var self__ = this;
var this__7040__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$event_DASH_category,null,cljs.core.cst$kw$event_DASH_action,null], null), null),k__7041__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7040__auto____$1),self__.__meta),k__7041__auto__);
} else {
return (new chimera.metrics.GaEvent(self__.event_category,self__.event_action,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7041__auto__)),null));
}
});

chimera.metrics.GaEvent.prototype.chimera$metrics$AnalyticsEvent$ = true;

chimera.metrics.GaEvent.prototype.chimera$metrics$AnalyticsEvent$call_analytics_event$arity$3 = (function (x,event_label,event_value){
var self__ = this;
var x__$1 = this;
return chimera.metrics.call_ga.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["send","event",self__.event_category,self__.event_action,event_label,event_value], 0));
});

chimera.metrics.GaEvent.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7038__auto__,k__7039__auto__,G__44044){
var self__ = this;
var this__7038__auto____$1 = this;
var pred__44048 = cljs.core.keyword_identical_QMARK_;
var expr__44049 = k__7039__auto__;
if(cljs.core.truth_((function (){var G__44051 = cljs.core.cst$kw$event_DASH_category;
var G__44052 = expr__44049;
return (pred__44048.cljs$core$IFn$_invoke$arity$2 ? pred__44048.cljs$core$IFn$_invoke$arity$2(G__44051,G__44052) : pred__44048.call(null,G__44051,G__44052));
})())){
return (new chimera.metrics.GaEvent(G__44044,self__.event_action,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__44053 = cljs.core.cst$kw$event_DASH_action;
var G__44054 = expr__44049;
return (pred__44048.cljs$core$IFn$_invoke$arity$2 ? pred__44048.cljs$core$IFn$_invoke$arity$2(G__44053,G__44054) : pred__44048.call(null,G__44053,G__44054));
})())){
return (new chimera.metrics.GaEvent(self__.event_category,G__44044,self__.__meta,self__.__extmap,null));
} else {
return (new chimera.metrics.GaEvent(self__.event_category,self__.event_action,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7039__auto__,G__44044),null));
}
}
});

chimera.metrics.GaEvent.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7043__auto__){
var self__ = this;
var this__7043__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$event_DASH_category,self__.event_category],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$event_DASH_action,self__.event_action],null))], null),self__.__extmap));
});

chimera.metrics.GaEvent.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7030__auto__,G__44044){
var self__ = this;
var this__7030__auto____$1 = this;
return (new chimera.metrics.GaEvent(self__.event_category,self__.event_action,G__44044,self__.__extmap,self__.__hash));
});

chimera.metrics.GaEvent.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7036__auto__,entry__7037__auto__){
var self__ = this;
var this__7036__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7037__auto__)){
return cljs.core._assoc(this__7036__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7036__auto____$1,entry__7037__auto__);
}
});

chimera.metrics.GaEvent.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$event_DASH_category,cljs.core.cst$sym$event_DASH_action], null);
});

chimera.metrics.GaEvent.cljs$lang$type = true;

chimera.metrics.GaEvent.cljs$lang$ctorPrSeq = (function (this__7065__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"chimera.metrics/GaEvent");
});

chimera.metrics.GaEvent.cljs$lang$ctorPrWriter = (function (this__7065__auto__,writer__7066__auto__){
return cljs.core._write(writer__7066__auto__,"chimera.metrics/GaEvent");
});

chimera.metrics.__GT_GaEvent = (function chimera$metrics$__GT_GaEvent(event_category,event_action){
return (new chimera.metrics.GaEvent(event_category,event_action,null,null,null));
});

chimera.metrics.map__GT_GaEvent = (function chimera$metrics$map__GT_GaEvent(G__44046){
return (new chimera.metrics.GaEvent(cljs.core.cst$kw$event_DASH_category.cljs$core$IFn$_invoke$arity$1(G__44046),cljs.core.cst$kw$event_DASH_action.cljs$core$IFn$_invoke$arity$1(G__44046),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__44046,cljs.core.cst$kw$event_DASH_category,cljs.core.array_seq([cljs.core.cst$kw$event_DASH_action], 0)),null));
});

/**
 * Generic event handler. Add other external metric services here.
 */
chimera.metrics.send_event = (function chimera$metrics$send_event(var_args){
var args__7491__auto__ = [];
var len__7484__auto___44062 = arguments.length;
var i__7485__auto___44063 = (0);
while(true){
if((i__7485__auto___44063 < len__7484__auto___44062)){
args__7491__auto__.push((arguments[i__7485__auto___44063]));

var G__44064 = (i__7485__auto___44063 + (1));
i__7485__auto___44063 = G__44064;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return chimera.metrics.send_event.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

chimera.metrics.send_event.cljs$core$IFn$_invoke$arity$variadic = (function (event_category,event_action,p__44059){
var map__44060 = p__44059;
var map__44060__$1 = ((((!((map__44060 == null)))?((((map__44060.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44060.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44060):map__44060);
var event_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44060__$1,cljs.core.cst$kw$event_DASH_label);
var event_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44060__$1,cljs.core.cst$kw$event_DASH_value);
return (new chimera.metrics.GaEvent(event_category,event_action,null,null,null)).chimera$metrics$AnalyticsEvent$call_analytics_event$arity$3(null,event_label,event_value);
});

chimera.metrics.send_event.cljs$lang$maxFixedArity = (2);

chimera.metrics.send_event.cljs$lang$applyTo = (function (seq44056){
var G__44057 = cljs.core.first(seq44056);
var seq44056__$1 = cljs.core.next(seq44056);
var G__44058 = cljs.core.first(seq44056__$1);
var seq44056__$2 = cljs.core.next(seq44056__$1);
return chimera.metrics.send_event.cljs$core$IFn$_invoke$arity$variadic(G__44057,G__44058,seq44056__$2);
});

