// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.dataview');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.views.photos');
goog.require('sablono.core');
goog.require('hatti.views.user_guide');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.views.map');
goog.require('hatti.views.chart');
goog.require('hatti.views.report_view');
goog.require('hatti.shared');
goog.require('chimera.metrics');
goog.require('hatti.views.saved_charts');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('hatti.views.settings');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('hatti.views.overview');
goog.require('hatti.views.table');
hatti.views.dataview.dataview_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$user_DASH_guide,cljs.core.cst$kw$table,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$settings,cljs.core.cst$kw$overview,cljs.core.cst$kw$chart,cljs.core.cst$kw$photos,cljs.core.cst$kw$map],[new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$user_DASH_guide,cljs.core.cst$kw$label,"User Guide",cljs.core.cst$kw$component,hatti.views.user_guide_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$table,cljs.core.cst$kw$label,"Table",cljs.core.cst$kw$component,hatti.views.table_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$label,"Reports",cljs.core.cst$kw$component,hatti.views.report_view_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$label,"Dashboard",cljs.core.cst$kw$component,hatti.views.saved_charts_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$settings,cljs.core.cst$kw$label,"Settings",cljs.core.cst$kw$component,hatti.views.settings_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$overview,cljs.core.cst$kw$label,"Overview",cljs.core.cst$kw$component,hatti.views.overview_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$chart,cljs.core.cst$kw$label,"Charts",cljs.core.cst$kw$component,hatti.views.chart_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$photos,cljs.core.cst$kw$label,"Photos",cljs.core.cst$kw$component,hatti.views.photos_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$map,cljs.core.cst$kw$label,"Map",cljs.core.cst$kw$component,hatti.views.map_page], null)]);
/**
 * Initial Dataview State
 */
hatti.views.dataview.default_dataviews = (function hatti$views$dataview$default_dataviews(){
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(hatti.views.dataview.dataview_map) : cljs.core.atom.call(null,hatti.views.dataview.dataview_map));
});
hatti.views.dataview.view_state = hatti.views.dataview.default_dataviews();
/**
 * Build and set the tooltips for inactive views based on why they are
 * inactive.
 */
hatti.views.dataview.view__GT_inactive_tab = (function hatti$views$dataview$view__GT_inactive_tab(view,label,is_encrypted_QMARK_,not_within_pricing_limits_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$inactive,[cljs.core.str(label),cljs.core.str(" ")].join(''),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$tooltip,(cljs.core.truth_(is_encrypted_QMARK_)?"This tab is disabled because this form is encrypted.":(cljs.core.truth_(not_within_pricing_limits_QMARK_)?"This tab is disabled because you are over the pricing limits.":(function (){var pred__39301 = cljs.core._EQ_;
var expr__39302 = view;
if(cljs.core.truth_((function (){var G__39304 = cljs.core.cst$kw$map;
var G__39305 = expr__39302;
return (pred__39301.cljs$core$IFn$_invoke$arity$2 ? pred__39301.cljs$core$IFn$_invoke$arity$2(G__39304,G__39305) : pred__39301.call(null,G__39304,G__39305));
})())){
return [cljs.core.str("The Map tab is disabled because this form "),cljs.core.str("has no location questions.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39306 = cljs.core.cst$kw$photos;
var G__39307 = expr__39302;
return (pred__39301.cljs$core$IFn$_invoke$arity$2 ? pred__39301.cljs$core$IFn$_invoke$arity$2(G__39306,G__39307) : pred__39301.call(null,G__39306,G__39307));
})())){
return [cljs.core.str("The Photos tab is disabled because this form has no "),cljs.core.str("photo questions.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39308 = cljs.core.cst$kw$table;
var G__39309 = expr__39302;
return (pred__39301.cljs$core$IFn$_invoke$arity$2 ? pred__39301.cljs$core$IFn$_invoke$arity$2(G__39308,G__39309) : pred__39301.call(null,G__39308,G__39309));
})())){
return [cljs.core.str("The table tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39310 = cljs.core.cst$kw$chart;
var G__39311 = expr__39302;
return (pred__39301.cljs$core$IFn$_invoke$arity$2 ? pred__39301.cljs$core$IFn$_invoke$arity$2(G__39310,G__39311) : pred__39301.call(null,G__39310,G__39311));
})())){
return [cljs.core.str("The charts tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39312 = cljs.core.cst$kw$saved_DASH_charts;
var G__39313 = expr__39302;
return (pred__39301.cljs$core$IFn$_invoke$arity$2 ? pred__39301.cljs$core$IFn$_invoke$arity$2(G__39312,G__39313) : pred__39301.call(null,G__39312,G__39313));
})())){
return [cljs.core.str("The dashboards tab is disabled because "),cljs.core.str("you do not have permission to view it.")].join('');
} else {
return "This tab is disabled.";
}
}
}
}
}
})()
))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_question,"?"], null)], null)], null);
});
hatti.views.dataview_actions.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.dataview.t_hatti$views$dataview39314 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39314 = (function (cursor,owner,meta39315){
this.cursor = cursor;
this.owner = owner;
this.meta39315 = meta39315;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39314.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39316,meta39315__$1){
var self__ = this;
var _39316__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39314(self__.cursor,self__.owner,meta39315__$1));
});

hatti.views.dataview.t_hatti$views$dataview39314.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39316){
var self__ = this;
var _39316__$1 = this;
return self__.meta39315;
});

hatti.views.dataview.t_hatti$views$dataview39314.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39314.prototype.om$core$IRender$render$arity$1 = (function (this__18222__auto__){
var self__ = this;
var this__18222__auto____$1 = this;
return null;
});

hatti.views.dataview.t_hatti$views$dataview39314.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39315], null);
});

hatti.views.dataview.t_hatti$views$dataview39314.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39314.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39314";

hatti.views.dataview.t_hatti$views$dataview39314.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39314");
});

hatti.views.dataview.__GT_t_hatti$views$dataview39314 = (function hatti$views$dataview$__GT_t_hatti$views$dataview39314(cursor__$1,owner__$1,meta39315){
return (new hatti.views.dataview.t_hatti$views$dataview39314(cursor__$1,owner__$1,meta39315));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview39314(cursor,owner,null));
}));
hatti.views.dataview_infobar.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__39317,owner){
var map__39318 = p__39317;
var map__39318__$1 = ((((!((map__39318 == null)))?((((map__39318.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39318.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39318):map__39318);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39318__$1,cljs.core.cst$kw$dataset_DASH_info);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39318__$1,cljs.core.cst$kw$status);
if(typeof hatti.views.dataview.t_hatti$views$dataview39320 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39320 = (function (p__39317,owner,map__39318,dataset_info,status,meta39321){
this.p__39317 = p__39317;
this.owner = owner;
this.map__39318 = map__39318;
this.dataset_info = dataset_info;
this.status = status;
this.meta39321 = meta39321;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39320.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__39318,map__39318__$1,dataset_info,status){
return (function (_39322,meta39321__$1){
var self__ = this;
var _39322__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39320(self__.p__39317,self__.owner,self__.map__39318,self__.dataset_info,self__.status,meta39321__$1));
});})(map__39318,map__39318__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39320.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__39318,map__39318__$1,dataset_info,status){
return (function (_39322){
var self__ = this;
var _39322__$1 = this;
return self__.meta39321;
});})(map__39318,map__39318__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39320.prototype.om$core$IWillMount$ = true;

hatti.views.dataview.t_hatti$views$dataview39320.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__39318,map__39318__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
return hatti.shared.maybe_merge_languages_BANG_(om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form));
});})(map__39318,map__39318__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39320.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39320.prototype.om$core$IRender$render$arity$1 = ((function (map__39318,map__39318__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var map__39323 = self__.dataset_info;
var map__39323__$1 = ((((!((map__39323 == null)))?((((map__39323.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39323.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39323):map__39323);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39323__$1,cljs.core.cst$kw$num_of_submissions);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39323__$1,cljs.core.cst$kw$formid);
var map__39324 = self__.status;
var map__39324__$1 = ((((!((map__39324 == null)))?((((map__39324.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39324.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39324):map__39324);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39324__$1,cljs.core.cst$kw$loading_QMARK_);
var total_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39324__$1,cljs.core.cst$kw$total_DASH_records);
var G__39331 = ({"className": "right rec-summary rec-margin"});
var G__39332 = (function (){var attrs39327 = (cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))?om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.shared.language_selector,null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs39327))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,"language-selector"], null),attrs39327], 0))):({"id": "language-selector"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39327))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39327)], null))));
})();
var G__39333 = (function (){var G__39336 = ({"id": "data-status"});
var G__39337 = (function (){var attrs39328 = (cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs39328))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rec"], null)], null),attrs39328], 0))):({"className": "rec"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39328))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39328),sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null))));
})();
return React.DOM.div(G__39336,G__39337);
})();
var G__39334 = (function (){var G__39338 = ({"className": "divider"});
return React.DOM.div(G__39338);
})();
var G__39335 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_actions,formid));
return React.DOM.div(G__39331,G__39332,G__39333,G__39334,G__39335);
});})(map__39318,map__39318__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39320.getBasis = ((function (map__39318,map__39318__$1,dataset_info,status){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__39317,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__39318,cljs.core.cst$sym$dataset_DASH_info,cljs.core.cst$sym$status,cljs.core.cst$sym$meta39321], null);
});})(map__39318,map__39318__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39320.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39320.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39320";

hatti.views.dataview.t_hatti$views$dataview39320.cljs$lang$ctorPrWriter = ((function (map__39318,map__39318__$1,dataset_info,status){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39320");
});})(map__39318,map__39318__$1,dataset_info,status))
;

hatti.views.dataview.__GT_t_hatti$views$dataview39320 = ((function (map__39318,map__39318__$1,dataset_info,status){
return (function hatti$views$dataview$__GT_t_hatti$views$dataview39320(p__39317__$1,owner__$1,map__39318__$2,dataset_info__$1,status__$1,meta39321){
return (new hatti.views.dataview.t_hatti$views$dataview39320(p__39317__$1,owner__$1,map__39318__$2,dataset_info__$1,status__$1,meta39321));
});})(map__39318,map__39318__$1,dataset_info,status))
;

}

return (new hatti.views.dataview.t_hatti$views$dataview39320(p__39317,owner,map__39318__$1,dataset_info,status,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Strip off ampersand suffixes then switch to view if result is a valid view
 */
hatti.views.dataview.activate_view_BANG_ = (function hatti$views$dataview$activate_view_BANG_(view){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((function (){var or__6409__auto__ = cljs.core.last(cljs.core.re_find(/(.*?)&/,view));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return view;
}
})());
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_(cljs.core.set(views),view__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_settings_view_BANG_ = (function hatti$views$dataview$activate_settings_view_BANG_(view,settings_section){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$active_DASH_tab,settings_section__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_integrated_apps_view_BANG_ = (function hatti$views$dataview$activate_integrated_apps_view_BANG_(view,settings_section,app_type){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.app_state,((function (view__$1,settings_section__$1,settings_views){
return (function (app_state){
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$selected], null),view__$1),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$active_DASH_tab], null),settings_section__$1),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps,cljs.core.cst$kw$active_DASH_section], null),app_type);
});})(view__$1,settings_section__$1,settings_views))
);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(app_type,hatti.constants.google_sheets)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$add_QMARK_,true], null));
} else {
}

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.tabbed_dataview.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,opts){
if(typeof hatti.views.dataview.t_hatti$views$dataview39342 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39342 = (function (app_state,owner,opts,meta39343){
this.app_state = app_state;
this.owner = owner;
this.opts = opts;
this.meta39343 = meta39343;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39342.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39344,meta39343__$1){
var self__ = this;
var _39344__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39342(self__.app_state,self__.owner,self__.opts,meta39343__$1));
});

hatti.views.dataview.t_hatti$views$dataview39342.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39344){
var self__ = this;
var _39344__$1 = this;
return self__.meta39343;
});

hatti.views.dataview.t_hatti$views$dataview39342.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39342.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var map__39345 = self__.app_state;
var map__39345__$1 = ((((!((map__39345 == null)))?((((map__39345.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39345.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39345):map__39345);
var map__39346 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39345__$1,cljs.core.cst$kw$views);
var map__39346__$1 = ((((!((map__39346 == null)))?((((map__39346.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39346.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39346):map__39346);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39346__$1,cljs.core.cst$kw$active);
var disabled = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39346__$1,cljs.core.cst$kw$disabled);
var selected = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39346__$1,cljs.core.cst$kw$selected);
var is_encrypted_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39345__$1,cljs.core.cst$kw$is_DASH_encrypted_QMARK_);
var is_within_pricing_limits_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39345__$1,cljs.core.cst$kw$is_DASH_within_DASH_pricing_DASH_limits_QMARK_);
var view__GT_display = ((function (map__39345,map__39345__$1,map__39346,map__39346__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1){
return (function (p1__39339_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,p1__39339_SHARP_)){
return "block";
} else {
return "none";
}
});})(map__39345,map__39345__$1,map__39346,map__39346__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1))
;
var view__GT_cls = ((function (map__39345,map__39345__$1,map__39346,map__39346__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1){
return (function (p1__39340_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,p1__39340_SHARP_)){
return "clicked";
} else {
return null;
}
});})(map__39345,map__39345__$1,map__39346,map__39346__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1))
;
var dataviews = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.views.dataview.view_state) : cljs.core.deref.call(null,hatti.views.dataview.view_state)),cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))));
var dv__GT_link = ((function (map__39345,map__39345__$1,map__39346,map__39346__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p__39349){
var map__39350 = p__39349;
var map__39350__$1 = ((((!((map__39350 == null)))?((((map__39350.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39350.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39350):map__39350);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39350__$1,cljs.core.cst$kw$view);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39350__$1,cljs.core.cst$kw$label);
if(cljs.core.truth_((function (){var and__6397__auto__ = cljs.core.some(((function (map__39350,map__39350__$1,view,label,map__39345,map__39345__$1,map__39346,map__39346__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p1__39341_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,p1__39341_SHARP_);
});})(map__39350,map__39350__$1,view,label,map__39345,map__39345__$1,map__39346,map__39346__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
,active);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not(chimera.seq.in_QMARK_(disabled,view));
} else {
return and__6397__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,view__GT_cls(view),cljs.core.cst$kw$href,[cljs.core.str("#/"),cljs.core.str(cljs.core.name(view))].join('')], null),label], null);
} else {
return hatti.views.dataview.view__GT_inactive_tab(view,label,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_);
}
});})(map__39345,map__39345__$1,map__39346,map__39346__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
;
var G__39353 = ({"className": "tab-container dataset-tabs"});
var G__39354 = (function (){var attrs39352 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(dv__GT_link,dataviews);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs39352))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-bar"], null)], null),attrs39352], 0))):({"className": "tab-bar"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39352))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39352),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null))));
})();
var G__39355 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = ((function (G__39353,G__39354,map__39345,map__39345__$1,map__39346,map__39346__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function hatti$views$dataview$iter__39356(s__39357){
return (new cljs.core.LazySeq(null,((function (G__39353,G__39354,map__39345,map__39345__$1,map__39346,map__39346__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function (){
var s__39357__$1 = s__39357;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39357__$1);
if(temp__4657__auto__){
var s__39357__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39357__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39357__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39359 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39358 = (0);
while(true){
if((i__39358 < size__7188__auto__)){
var map__39370 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39358);
var map__39370__$1 = ((((!((map__39370 == null)))?((((map__39370.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39370.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39370):map__39370);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39370__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39370__$1,cljs.core.cst$kw$view);
var view_name = cljs.core.name(view);
cljs.core.chunk_append(b__39359,(function (){var G__39372 = ({"style": ({"height": cljs.core.cst$kw$table_DASH_view_DASH_height.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$table_DASH_page.cljs$core$IFn$_invoke$arity$1(self__.app_state)), "display": view__GT_display(view), "overflowX": (cljs.core.truth_(cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$table_DASH_page.cljs$core$IFn$_invoke$arity$1(self__.app_state)))?"hidden":"scroll")}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')});
var G__39373 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,view))?(function (){
chimera.metrics.send_event(cljs.core.cst$kw$Dataview,[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null);
})()
:null));
return React.DOM.div(G__39372,G__39373);
})());

var G__39378 = (i__39358 + (1));
i__39358 = G__39378;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39359),hatti$views$dataview$iter__39356(cljs.core.chunk_rest(s__39357__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39359),null);
}
} else {
var map__39374 = cljs.core.first(s__39357__$2);
var map__39374__$1 = ((((!((map__39374 == null)))?((((map__39374.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39374.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39374):map__39374);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39374__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39374__$1,cljs.core.cst$kw$view);
var view_name = cljs.core.name(view);
return cljs.core.cons((function (){var G__39376 = ({"style": ({"height": cljs.core.cst$kw$table_DASH_view_DASH_height.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$table_DASH_page.cljs$core$IFn$_invoke$arity$1(self__.app_state)), "display": view__GT_display(view), "overflowX": (cljs.core.truth_(cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$table_DASH_page.cljs$core$IFn$_invoke$arity$1(self__.app_state)))?"hidden":"scroll")}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')});
var G__39377 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,view))?(function (){
chimera.metrics.send_event(cljs.core.cst$kw$Dataview,[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null);
})()
:null));
return React.DOM.div(G__39376,G__39377);
})(),hatti$views$dataview$iter__39356(cljs.core.rest(s__39357__$2)));
}
} else {
return null;
}
break;
}
});})(G__39353,G__39354,map__39345,map__39345__$1,map__39346,map__39346__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
,null,null));
});})(G__39353,G__39354,map__39345,map__39345__$1,map__39346,map__39346__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
;
return iter__7189__auto__(dataviews);
})());
return React.DOM.div(G__39353,G__39354,G__39355);
});

hatti.views.dataview.t_hatti$views$dataview39342.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta39343], null);
});

hatti.views.dataview.t_hatti$views$dataview39342.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39342.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39342";

hatti.views.dataview.t_hatti$views$dataview39342.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39342");
});

hatti.views.dataview.__GT_t_hatti$views$dataview39342 = (function hatti$views$dataview$__GT_t_hatti$views$dataview39342(app_state__$1,owner__$1,opts__$1,meta39343){
return (new hatti.views.dataview.t_hatti$views$dataview39342(app_state__$1,owner__$1,opts__$1,meta39343));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview39342(app_state,owner,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
