// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.record');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('clojure.string');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.urls');
/**
 * Wrap-with produces a partial to wrap a set of children.
 * ((wrap-with :div) 1 2 3) => [:div [1 2 3]]
 * ((wrap-with [:div {:class 0}]) 1 2 3) => [:div {:class 0} [1 2 3]]
 */
hatti.views.record.wrap_with = (function hatti$views$record$wrap_with(root){
return (function() { 
var G__35407__delegate = function (children){
if((root instanceof cljs.core.Keyword)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root], null),children);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(root,children);
}
};
var G__35407 = function (var_args){
var children = null;
if (arguments.length > 0) {
var G__35408__i = 0, G__35408__a = new Array(arguments.length -  0);
while (G__35408__i < G__35408__a.length) {G__35408__a[G__35408__i] = arguments[G__35408__i + 0]; ++G__35408__i;}
  children = new cljs.core.IndexedSeq(G__35408__a,0);
} 
return G__35407__delegate.call(this,children);};
G__35407.cljs$lang$maxFixedArity = 0;
G__35407.cljs$lang$applyTo = (function (arglist__35409){
var children = cljs.core.seq(arglist__35409);
return G__35407__delegate(children);
});
G__35407.cljs$core$IFn$_invoke$arity$variadic = G__35407__delegate;
return G__35407;
})()
;
});
hatti.views.record.submission_arrow = (function hatti$views$record$submission_arrow(dir,cur_rank,view){
var icon = [cljs.core.str("fa fa-arrow-"),cljs.core.str(cljs.core.name(dir))].join('');
var new_rank = (function (){var G__35418 = (((dir instanceof cljs.core.Keyword))?dir.fqn:null);
switch (G__35418) {
case "left":
return cljs.core.dec;

break;
case "right":
return cljs.core.inc;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(dir)].join('')));

}
})().call(null,cur_rank);
var event_key = (function (){var pred__35419 = cljs.core._EQ_;
var expr__35420 = view;
if(cljs.core.truth_((function (){var G__35422 = cljs.core.cst$kw$map;
var G__35423 = expr__35420;
return (pred__35419.cljs$core$IFn$_invoke$arity$2 ? pred__35419.cljs$core$IFn$_invoke$arity$2(G__35422,G__35423) : pred__35419.call(null,G__35422,G__35423));
})())){
return cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank;
} else {
if(cljs.core.truth_((function (){var G__35424 = cljs.core.cst$kw$table;
var G__35425 = expr__35420;
return (pred__35419.cljs$core$IFn$_invoke$arity$2 ? pred__35419.cljs$core$IFn$_invoke$arity$2(G__35424,G__35425) : pred__35419.call(null,G__35424,G__35425));
})())){
return cljs.core.cst$kw$submission_DASH_to_DASH_rank;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__35420)].join('')));
}
}
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$pure_DASH_button$btn_DASH_default,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (icon,new_rank,event_key){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,cljs.core.PersistentArrayMap.fromArray([event_key,new_rank], true, false));
});})(icon,new_rank,event_key))
),cljs.core.cst$kw$href,"#"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,icon], null)], null)], null);
});
hatti.views.record.submission_closer = (function hatti$views$record$submission_closer(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$btn_DASH_close$right,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn((function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_unclicked,true], null));
})),cljs.core.cst$kw$href,"#"], null),"\u00D7"], null);
});
hatti.views.print_xls_report_btn.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.record.t_hatti$views$record35427 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record35427 = (function (cursor,owner,meta35428){
this.cursor = cursor;
this.owner = owner;
this.meta35428 = meta35428;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record35427.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35429,meta35428__$1){
var self__ = this;
var _35429__$1 = this;
return (new hatti.views.record.t_hatti$views$record35427(self__.cursor,self__.owner,meta35428__$1));
});

hatti.views.record.t_hatti$views$record35427.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35429){
var self__ = this;
var _35429__$1 = this;
return self__.meta35428;
});

hatti.views.record.t_hatti$views$record35427.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record35427.prototype.om$core$IRender$render$arity$1 = (function (this__18222__auto__){
var self__ = this;
var this__18222__auto____$1 = this;
var G__35432 = ({"id": "print-xls-report"});
return React.DOM.div(G__35432);
});

hatti.views.record.t_hatti$views$record35427.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta35428], null);
});

hatti.views.record.t_hatti$views$record35427.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record35427.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record35427";

hatti.views.record.t_hatti$views$record35427.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record35427");
});

hatti.views.record.__GT_t_hatti$views$record35427 = (function hatti$views$record$__GT_t_hatti$views$record35427(cursor__$1,owner__$1,meta35428){
return (new hatti.views.record.t_hatti$views$record35427(cursor__$1,owner__$1,meta35428));
});

}

return (new hatti.views.record.t_hatti$views$record35427(cursor,owner,null));
}));
hatti.views.record.qa_elements = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$div$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$span$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$span$answer], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$tr$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$td$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$td$answer], null),cljs.core.cst$kw$comment,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$tr$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$td$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$td$answer,cljs.core.cst$kw$comment_DASH_el,cljs.core.cst$kw$td], null)], null);
hatti.views.record.format_as_question_answer = (function hatti$views$record$format_as_question_answer(view,field,data,lang){
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var flabel = hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([lang], 0));
var answer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,fname);
var alabel = hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,answer,cljs.core.array_seq([cljs.core.cst$kw$language,lang], 0));
var map__35435 = (hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1(view) : hatti.views.record.qa_elements.call(null,view));
var map__35435__$1 = ((((!((map__35435 == null)))?((((map__35435.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35435.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35435):map__35435);
var row_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35435__$1,cljs.core.cst$kw$row_DASH_el);
var question_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35435__$1,cljs.core.cst$kw$question_DASH_el);
var answer_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35435__$1,cljs.core.cst$kw$answer_DASH_el);
if(cljs.core.truth_((function (){var and__6397__auto__ = alabel;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(alabel,hatti.ona.forms.no_answer);
} else {
return and__6397__auto__;
}
})())){
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.repeat_view,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data,answer,cljs.core.cst$kw$repeat_DASH_field,field,cljs.core.cst$kw$lang,lang], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,view], null)], null));
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,flabel], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,alabel], null)], null);
}
} else {
return null;
}
});
hatti.views.record.submission_elements = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$top_DASH_level_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$legend$infobar$submission$top$right),cljs.core.cst$kw$topbar_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom$legend_DASH_topbar),cljs.core.cst$kw$header_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom$submission_DASH_header),cljs.core.cst$kw$submission_DASH_info_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$submission$info_DASH_scroll),cljs.core.cst$kw$section_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom),cljs.core.cst$kw$h4_DASH_cls,"t-red"], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$top_DASH_level_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$widget_DASH_info_SHARP_single_DASH_submission_DASH_info),cljs.core.cst$kw$topbar_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$topbar),cljs.core.cst$kw$header_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$header),cljs.core.cst$kw$submission_DASH_info_DASH_wrap,(function() { 
var G__35437__delegate = function (tbody){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$submission,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$pure_DASH_table$pure_DASH_table_DASH_bordered,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Question"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Response"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,tbody], null)], null)], null);
};
var G__35437 = function (var_args){
var tbody = null;
if (arguments.length > 0) {
var G__35438__i = 0, G__35438__a = new Array(arguments.length -  0);
while (G__35438__i < G__35438__a.length) {G__35438__a[G__35438__i] = arguments[G__35438__i + 0]; ++G__35438__i;}
  tbody = new cljs.core.IndexedSeq(G__35438__a,0);
} 
return G__35437__delegate.call(this,tbody);};
G__35437.cljs$lang$maxFixedArity = 0;
G__35437.cljs$lang$applyTo = (function (arglist__35439){
var tbody = cljs.core.seq(arglist__35439);
return G__35437__delegate(tbody);
});
G__35437.cljs$core$IFn$_invoke$arity$variadic = G__35437__delegate;
return G__35437;
})()
,cljs.core.cst$kw$section_DASH_wrap,cljs.core.identity,cljs.core.cst$kw$show_DASH_instance_DASH_id,true,cljs.core.cst$kw$h4_DASH_cls,""], null)], null);
hatti.views.repeat_view.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__35441,owner,p__35442){
var map__35443 = p__35441;
var map__35443__$1 = ((((!((map__35443 == null)))?((((map__35443.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35443.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35443):map__35443);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35443__$1,cljs.core.cst$kw$data);
var repeat_field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35443__$1,cljs.core.cst$kw$repeat_DASH_field);
var lang = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35443__$1,cljs.core.cst$kw$lang);
var map__35444 = p__35442;
var map__35444__$1 = ((((!((map__35444 == null)))?((((map__35444.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35444.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35444):map__35444);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35444__$1,cljs.core.cst$kw$view);

if(typeof hatti.views.record.t_hatti$views$record35447 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record35447 = (function (p__35441,owner,p__35442,map__35443,data,repeat_field,lang,map__35444,view,meta35448){
this.p__35441 = p__35441;
this.owner = owner;
this.p__35442 = p__35442;
this.map__35443 = map__35443;
this.data = data;
this.repeat_field = repeat_field;
this.lang = lang;
this.map__35444 = map__35444;
this.view = view;
this.meta35448 = meta35448;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record35447.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function (_35449,meta35448__$1){
var self__ = this;
var _35449__$1 = this;
return (new hatti.views.record.t_hatti$views$record35447(self__.p__35441,self__.owner,self__.p__35442,self__.map__35443,self__.data,self__.repeat_field,self__.lang,self__.map__35444,self__.view,meta35448__$1));
});})(map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
;

hatti.views.record.t_hatti$views$record35447.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function (_35449){
var self__ = this;
var _35449__$1 = this;
return self__.meta35448;
});})(map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
;

hatti.views.record.t_hatti$views$record35447.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record35447.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$collapsed_QMARK_,true], null);
});})(map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
;

hatti.views.record.t_hatti$views$record35447.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record35447.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function (_,p__35450){
var self__ = this;
var map__35451 = p__35450;
var map__35451__$1 = ((((!((map__35451 == null)))?((((map__35451.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35451.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35451):map__35451);
var collapsed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35451__$1,cljs.core.cst$kw$collapsed_QMARK_);
var ___$1 = this;
if(cljs.core.seq(self__.data)){
var collapse_BANG_ = ((function (___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function (p1__35440_SHARP_){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$collapsed_QMARK_,p1__35440_SHARP_);
});})(___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
;
var map__35453 = (hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1(self__.view) : hatti.views.record.qa_elements.call(null,self__.view));
var map__35453__$1 = ((((!((map__35453 == null)))?((((map__35453.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35453.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35453):map__35453);
var row_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35453__$1,cljs.core.cst$kw$row_DASH_el);
var question_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35453__$1,cljs.core.cst$kw$question_DASH_el);
var answer_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35453__$1,cljs.core.cst$kw$answer_DASH_el);
var header = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(self__.repeat_field,cljs.core.array_seq([self__.lang], 0))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,[cljs.core.str(hatti.utils.pluralize_number(cljs.core.count(self__.data)," Repeat")),cljs.core.str(" - ")].join(''),(cljs.core.truth_(collapsed_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function (){
return collapse_BANG_(false);
});})(collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
),cljs.core.cst$kw$href,"#"], null),"Show Repeats"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function (){
return collapse_BANG_(true);
});})(collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
),cljs.core.cst$kw$href,"#"], null),"Hide Repeats"], null))], null)], null);
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.repeat_field);
var render_child = ((function (collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function (d){
var iter__7189__auto__ = ((function (collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function hatti$views$record$iter__35455(s__35456){
return (new cljs.core.LazySeq(null,((function (collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function (){
var s__35456__$1 = s__35456;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35456__$1);
if(temp__4657__auto__){
var s__35456__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35456__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35456__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35458 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35457 = (0);
while(true){
if((i__35457 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35457);
cljs.core.chunk_append(b__35458,hatti.views.record.format_as_question_answer(self__.view,field,d,self__.lang));

var G__35474 = (i__35457 + (1));
i__35457 = G__35474;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35458),hatti$views$record$iter__35455(cljs.core.chunk_rest(s__35456__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35458),null);
}
} else {
var field = cljs.core.first(s__35456__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,field,d,self__.lang),hatti$views$record$iter__35455(cljs.core.rest(s__35456__$2)));
}
} else {
return null;
}
break;
}
});})(collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
,null,null));
});})(collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
;
return iter__7189__auto__(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(self__.repeat_field));
});})(collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
;
var tbl = ((function (collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function() { 
var G__35475__delegate = function (cls,body){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cls], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$no_DASH_pad,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(2)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cls], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,body], null)], null)], null)], null);
};
var G__35475 = function (cls,var_args){
var body = null;
if (arguments.length > 1) {
var G__35476__i = 0, G__35476__a = new Array(arguments.length -  1);
while (G__35476__i < G__35476__a.length) {G__35476__a[G__35476__i] = arguments[G__35476__i + 1]; ++G__35476__i;}
  body = new cljs.core.IndexedSeq(G__35476__a,0);
} 
return G__35475__delegate.call(this,cls,body);};
G__35475.cljs$lang$maxFixedArity = 1;
G__35475.cljs$lang$applyTo = (function (arglist__35477){
var cls = cljs.core.first(arglist__35477);
var body = cljs.core.rest(arglist__35477);
return G__35475__delegate(cls,body);
});
G__35475.cljs$core$IFn$_invoke$arity$variadic = G__35475__delegate;
return G__35475;
})()
;})(collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
;
if(cljs.core.truth_(collapsed_QMARK_)){
return sablono.interpreter.interpret(header);
} else {
return sablono.interpreter.interpret((function (){var G__35461 = (((self__.view instanceof cljs.core.Keyword))?self__.view.fqn:null);
switch (G__35461) {
case "map":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$repeat_DASH_block,header,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol$repeat,(function (){var iter__7189__auto__ = ((function (G__35461,collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function hatti$views$record$iter__35462(s__35463){
return (new cljs.core.LazySeq(null,((function (G__35461,collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function (){
var s__35463__$1 = s__35463;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35463__$1);
if(temp__4657__auto__){
var s__35463__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35463__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35463__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35465 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35464 = (0);
while(true){
if((i__35464 < size__7188__auto__)){
var d = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35464);
cljs.core.chunk_append(b__35465,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,render_child(d)], null));

var G__35479 = (i__35464 + (1));
i__35464 = G__35479;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35465),hatti$views$record$iter__35462(cljs.core.chunk_rest(s__35463__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35465),null);
}
} else {
var d = cljs.core.first(s__35463__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,render_child(d)], null),hatti$views$record$iter__35462(cljs.core.rest(s__35463__$2)));
}
} else {
return null;
}
break;
}
});})(G__35461,collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
,null,null));
});})(G__35461,collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
;
return iter__7189__auto__(self__.data);
})()], null)], null);

break;
case "table":
return tbl.cljs$core$IFn$_invoke$arity$variadic("repeat-block",cljs.core.array_seq([header,(function (){var iter__7189__auto__ = ((function (G__35461,collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function hatti$views$record$iter__35468(s__35469){
return (new cljs.core.LazySeq(null,((function (G__35461,collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function (){
var s__35469__$1 = s__35469;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35469__$1);
if(temp__4657__auto__){
var s__35469__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35469__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35469__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35471 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35470 = (0);
while(true){
if((i__35470 < size__7188__auto__)){
var d = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35470);
cljs.core.chunk_append(b__35471,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody$repeat,render_child(d)], null));

var G__35480 = (i__35470 + (1));
i__35470 = G__35480;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35471),hatti$views$record$iter__35468(cljs.core.chunk_rest(s__35469__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35471),null);
}
} else {
var d = cljs.core.first(s__35469__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody$repeat,render_child(d)], null),hatti$views$record$iter__35468(cljs.core.rest(s__35469__$2)));
}
} else {
return null;
}
break;
}
});})(G__35461,collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
,null,null));
});})(G__35461,collapse_BANG_,map__35453,map__35453__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35451,map__35451__$1,collapsed_QMARK_,map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
;
return iter__7189__auto__(self__.data);
})()], 0));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(self__.view)].join('')));

}
})());
}
} else {
return null;
}
});})(map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
;

hatti.views.record.t_hatti$views$record35447.getBasis = ((function (map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__35441,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__35442,cljs.core.cst$sym$map__35443,cljs.core.cst$sym$data,cljs.core.cst$sym$repeat_DASH_field,cljs.core.cst$sym$lang,cljs.core.cst$sym$map__35444,cljs.core.cst$sym$view,cljs.core.cst$sym$meta35448], null);
});})(map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
;

hatti.views.record.t_hatti$views$record35447.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record35447.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record35447";

hatti.views.record.t_hatti$views$record35447.cljs$lang$ctorPrWriter = ((function (map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record35447");
});})(map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
;

hatti.views.record.__GT_t_hatti$views$record35447 = ((function (map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view){
return (function hatti$views$record$__GT_t_hatti$views$record35447(p__35441__$1,owner__$1,p__35442__$1,map__35443__$2,data__$1,repeat_field__$1,lang__$1,map__35444__$2,view__$1,meta35448){
return (new hatti.views.record.t_hatti$views$record35447(p__35441__$1,owner__$1,p__35442__$1,map__35443__$2,data__$1,repeat_field__$1,lang__$1,map__35444__$2,view__$1,meta35448));
});})(map__35443,map__35443__$1,data,repeat_field,lang,map__35444,map__35444__$1,view))
;

}

return (new hatti.views.record.t_hatti$views$record35447(p__35441,owner,p__35442,map__35443__$1,data,repeat_field,lang,map__35444__$1,view,cljs.core.PersistentArrayMap.EMPTY));
}));
hatti.views.record.header_note = (function hatti$views$record$header_note(view,p__35481){
var map__35484 = p__35481;
var map__35484__$1 = ((((!((map__35484 == null)))?((((map__35484.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35484.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35484):map__35484);
var geofield = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35484__$1,cljs.core.cst$kw$geofield);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35484__$1,cljs.core.cst$kw$data);
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,cljs.core.cst$kw$map)) && (cljs.core.not(cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$no_DASH_geo$t_DASH_normal$right,"No geodata"], null);
} else {
return null;
}
});
hatti.views.edit_delete.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (instance_id,owner,p__35486){
var map__35487 = p__35486;
var map__35487__$1 = ((((!((map__35487 == null)))?((((map__35487.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35487.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35487):map__35487);
var delete_record_BANG_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35487__$1,cljs.core.cst$kw$delete_DASH_record_BANG_);
if(typeof hatti.views.record.t_hatti$views$record35489 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record35489 = (function (instance_id,owner,p__35486,map__35487,delete_record_BANG_,meta35490){
this.instance_id = instance_id;
this.owner = owner;
this.p__35486 = p__35486;
this.map__35487 = map__35487;
this.delete_record_BANG_ = delete_record_BANG_;
this.meta35490 = meta35490;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record35489.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__35487,map__35487__$1,delete_record_BANG_){
return (function (_35491,meta35490__$1){
var self__ = this;
var _35491__$1 = this;
return (new hatti.views.record.t_hatti$views$record35489(self__.instance_id,self__.owner,self__.p__35486,self__.map__35487,self__.delete_record_BANG_,meta35490__$1));
});})(map__35487,map__35487__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record35489.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__35487,map__35487__$1,delete_record_BANG_){
return (function (_35491){
var self__ = this;
var _35491__$1 = this;
return self__.meta35490;
});})(map__35487,map__35487__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record35489.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record35489.prototype.om$core$IRender$render$arity$1 = ((function (map__35487,map__35487__$1,delete_record_BANG_){
return (function (this__18222__auto__){
var self__ = this;
var this__18222__auto____$1 = this;
return null;
});})(map__35487,map__35487__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record35489.getBasis = ((function (map__35487,map__35487__$1,delete_record_BANG_){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$instance_DASH_id,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__35486,cljs.core.cst$sym$map__35487,cljs.core.cst$sym$delete_DASH_record_BANG_,cljs.core.cst$sym$meta35490], null);
});})(map__35487,map__35487__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record35489.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record35489.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record35489";

hatti.views.record.t_hatti$views$record35489.cljs$lang$ctorPrWriter = ((function (map__35487,map__35487__$1,delete_record_BANG_){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record35489");
});})(map__35487,map__35487__$1,delete_record_BANG_))
;

hatti.views.record.__GT_t_hatti$views$record35489 = ((function (map__35487,map__35487__$1,delete_record_BANG_){
return (function hatti$views$record$__GT_t_hatti$views$record35489(instance_id__$1,owner__$1,p__35486__$1,map__35487__$2,delete_record_BANG___$1,meta35490){
return (new hatti.views.record.t_hatti$views$record35489(instance_id__$1,owner__$1,p__35486__$1,map__35487__$2,delete_record_BANG___$1,meta35490));
});})(map__35487,map__35487__$1,delete_record_BANG_))
;

}

return (new hatti.views.record.t_hatti$views$record35489(instance_id,owner,p__35486,map__35487__$1,delete_record_BANG_,null));
}));
hatti.views.submission_view.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner,p__35492){
var map__35493 = p__35492;
var map__35493__$1 = ((((!((map__35493 == null)))?((((map__35493.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35493.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35493):map__35493);
var opts = map__35493__$1;
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35493__$1,cljs.core.cst$kw$view);
if(typeof hatti.views.record.t_hatti$views$record35495 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record35495 = (function (cursor,owner,p__35492,map__35493,opts,view,meta35496){
this.cursor = cursor;
this.owner = owner;
this.p__35492 = p__35492;
this.map__35493 = map__35493;
this.opts = opts;
this.view = view;
this.meta35496 = meta35496;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record35495.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__35493,map__35493__$1,opts,view){
return (function (_35497,meta35496__$1){
var self__ = this;
var _35497__$1 = this;
return (new hatti.views.record.t_hatti$views$record35495(self__.cursor,self__.owner,self__.p__35492,self__.map__35493,self__.opts,self__.view,meta35496__$1));
});})(map__35493,map__35493__$1,opts,view))
;

hatti.views.record.t_hatti$views$record35495.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__35493,map__35493__$1,opts,view){
return (function (_35497){
var self__ = this;
var _35497__$1 = this;
return self__.meta35496;
});})(map__35493,map__35493__$1,opts,view))
;

hatti.views.record.t_hatti$views$record35495.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record35495.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__35493,map__35493__$1,opts,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$expand_DASH_meta_QMARK_,false], null);
});})(map__35493,map__35493__$1,opts,view))
;

hatti.views.record.t_hatti$views$record35495.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record35495.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__35493,map__35493__$1,opts,view){
return (function (_,p__35498){
var self__ = this;
var map__35499 = p__35498;
var map__35499__$1 = ((((!((map__35499 == null)))?((((map__35499.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35499.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35499):map__35499);
var expand_meta_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35499__$1,cljs.core.cst$kw$expand_DASH_meta_QMARK_);
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$flat_DASH_form], null));
var language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var map__35501 = self__.cursor;
var map__35501__$1 = ((((!((map__35501 == null)))?((((map__35501.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35501.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35501):map__35501);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35501__$1,cljs.core.cst$kw$id);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35501__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35501__$1,cljs.core.cst$kw$dataset_DASH_info);
var cur_rank = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,hatti.constants._rank);
var instance_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,"_id");
var sdatetime = (function (){var G__35504 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,"_submission_time");
return moment(G__35504);
})();
var map__35502 = (hatti.views.record.submission_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.submission_elements.cljs$core$IFn$_invoke$arity$1(self__.view) : hatti.views.record.submission_elements.call(null,self__.view));
var map__35502__$1 = ((((!((map__35502 == null)))?((((map__35502.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35502.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35502):map__35502);
var top_level_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35502__$1,cljs.core.cst$kw$top_DASH_level_DASH_wrap);
var topbar_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35502__$1,cljs.core.cst$kw$topbar_DASH_wrap);
var header_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35502__$1,cljs.core.cst$kw$header_DASH_wrap);
var section_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35502__$1,cljs.core.cst$kw$section_DASH_wrap);
var submission_info_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35502__$1,cljs.core.cst$kw$submission_DASH_info_DASH_wrap);
var h4_cls = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35502__$1,cljs.core.cst$kw$h4_DASH_cls);
return sablono.interpreter.interpret((cljs.core.truth_((function (){var or__6409__auto__ = data;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id;
}
})())?(function (){var G__35506 = (function (){var G__35508 = hatti.views.record.submission_arrow(cljs.core.cst$kw$left,cur_rank,self__.view);
var G__35509 = hatti.views.record.submission_arrow(cljs.core.cst$kw$right,cur_rank,self__.view);
var G__35510 = om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.print_xls_report_btn,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$instance_DASH_id,instance_id,cljs.core.cst$kw$dataset_DASH_info,dataset_info], null));
var G__35511 = hatti.views.record.submission_closer();
return (topbar_wrap.cljs$core$IFn$_invoke$arity$4 ? topbar_wrap.cljs$core$IFn$_invoke$arity$4(G__35508,G__35509,G__35510,G__35511) : topbar_wrap.call(null,G__35508,G__35509,G__35510,G__35511));
})();
var G__35507 = (cljs.core.truth_(data)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,(function (){var G__35512 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,h4_cls], null),[cljs.core.str("ID: "),cljs.core.str(instance_id)].join(''),hatti.views.record.header_note(self__.view,self__.cursor)], null);
var G__35513 = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,[cljs.core.str("Submitted at "),cljs.core.str(sdatetime.format("LT")),cljs.core.str(" on "),cljs.core.str(sdatetime.format("ll"))].join(''),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$br], null),om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.edit_delete,instance_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$expand_DASH_meta$right,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (G__35512,G__35506,form,language,map__35501,map__35501__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35502,map__35502__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35499,map__35499__$1,expand_meta_QMARK_,map__35493,map__35493__$1,opts,view){
return (function (){
return om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$expand_DASH_meta_QMARK_,cljs.core.not);
});})(G__35512,G__35506,form,language,map__35501,map__35501__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35502,map__35502__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35499,map__35499__$1,expand_meta_QMARK_,map__35493,map__35493__$1,opts,view))
)], null),(cljs.core.truth_(expand_meta_QMARK_)?"Hide Metadata":"Show Metadata")], null)], null)], null);
return (header_wrap.cljs$core$IFn$_invoke$arity$2 ? header_wrap.cljs$core$IFn$_invoke$arity$2(G__35512,G__35513) : header_wrap.call(null,G__35512,G__35513));
})(),(function (){var G__35514 = (cljs.core.truth_(expand_meta_QMARK_)?(function (){var G__35516 = (function (){var iter__7189__auto__ = ((function (G__35506,form,language,map__35501,map__35501__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35502,map__35502__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35499,map__35499__$1,expand_meta_QMARK_,map__35493,map__35493__$1,opts,view){
return (function hatti$views$record$iter__35517(s__35518){
return (new cljs.core.LazySeq(null,((function (G__35506,form,language,map__35501,map__35501__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35502,map__35502__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35499,map__35499__$1,expand_meta_QMARK_,map__35493,map__35493__$1,opts,view){
return (function (){
var s__35518__$1 = s__35518;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35518__$1);
if(temp__4657__auto__){
var s__35518__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35518__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35518__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35520 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35519 = (0);
while(true){
if((i__35519 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35519);
cljs.core.chunk_append(b__35520,hatti.views.record.format_as_question_answer(self__.view,q,data,language));

var G__35530 = (i__35519 + (1));
i__35519 = G__35530;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35520),hatti$views$record$iter__35517(cljs.core.chunk_rest(s__35518__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35520),null);
}
} else {
var q = cljs.core.first(s__35518__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,q,data,language),hatti$views$record$iter__35517(cljs.core.rest(s__35518__$2)));
}
} else {
return null;
}
break;
}
});})(G__35506,form,language,map__35501,map__35501__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35502,map__35502__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35499,map__35499__$1,expand_meta_QMARK_,map__35493,map__35493__$1,opts,view))
,null,null));
});})(G__35506,form,language,map__35501,map__35501__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35502,map__35502__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35499,map__35499__$1,expand_meta_QMARK_,map__35493,map__35493__$1,opts,view))
;
return iter__7189__auto__(hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0)));
})();
return (section_wrap.cljs$core$IFn$_invoke$arity$1 ? section_wrap.cljs$core$IFn$_invoke$arity$1(G__35516) : section_wrap.call(null,G__35516));
})():null);
var G__35515 = (function (){var G__35523 = (function (){var iter__7189__auto__ = ((function (G__35514,G__35506,form,language,map__35501,map__35501__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35502,map__35502__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35499,map__35499__$1,expand_meta_QMARK_,map__35493,map__35493__$1,opts,view){
return (function hatti$views$record$iter__35524(s__35525){
return (new cljs.core.LazySeq(null,((function (G__35514,G__35506,form,language,map__35501,map__35501__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35502,map__35502__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35499,map__35499__$1,expand_meta_QMARK_,map__35493,map__35493__$1,opts,view){
return (function (){
var s__35525__$1 = s__35525;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35525__$1);
if(temp__4657__auto__){
var s__35525__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35525__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35525__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35527 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35526 = (0);
while(true){
if((i__35526 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35526);
cljs.core.chunk_append(b__35527,hatti.views.record.format_as_question_answer(self__.view,q,data,language));

var G__35531 = (i__35526 + (1));
i__35526 = G__35531;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35527),hatti$views$record$iter__35524(cljs.core.chunk_rest(s__35525__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35527),null);
}
} else {
var q = cljs.core.first(s__35525__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,q,data,language),hatti$views$record$iter__35524(cljs.core.rest(s__35525__$2)));
}
} else {
return null;
}
break;
}
});})(G__35514,G__35506,form,language,map__35501,map__35501__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35502,map__35502__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35499,map__35499__$1,expand_meta_QMARK_,map__35493,map__35493__$1,opts,view))
,null,null));
});})(G__35514,G__35506,form,language,map__35501,map__35501__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35502,map__35502__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35499,map__35499__$1,expand_meta_QMARK_,map__35493,map__35493__$1,opts,view))
;
return iter__7189__auto__(hatti.ona.forms.non_meta_fields(form));
})();
return (section_wrap.cljs$core$IFn$_invoke$arity$1 ? section_wrap.cljs$core$IFn$_invoke$arity$1(G__35523) : section_wrap.call(null,G__35523));
})();
return (submission_info_wrap.cljs$core$IFn$_invoke$arity$2 ? submission_info_wrap.cljs$core$IFn$_invoke$arity$2(G__35514,G__35515) : submission_info_wrap.call(null,G__35514,G__35515));
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$t_DASH_center,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null),"Loading data..."], null)], null));
return (top_level_wrap.cljs$core$IFn$_invoke$arity$2 ? top_level_wrap.cljs$core$IFn$_invoke$arity$2(G__35506,G__35507) : top_level_wrap.call(null,G__35506,G__35507));
})():null));
});})(map__35493,map__35493__$1,opts,view))
;

hatti.views.record.t_hatti$views$record35495.getBasis = ((function (map__35493,map__35493__$1,opts,view){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__35492,cljs.core.cst$sym$map__35493,cljs.core.cst$sym$opts,cljs.core.cst$sym$view,cljs.core.cst$sym$meta35496], null);
});})(map__35493,map__35493__$1,opts,view))
;

hatti.views.record.t_hatti$views$record35495.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record35495.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record35495";

hatti.views.record.t_hatti$views$record35495.cljs$lang$ctorPrWriter = ((function (map__35493,map__35493__$1,opts,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record35495");
});})(map__35493,map__35493__$1,opts,view))
;

hatti.views.record.__GT_t_hatti$views$record35495 = ((function (map__35493,map__35493__$1,opts,view){
return (function hatti$views$record$__GT_t_hatti$views$record35495(cursor__$1,owner__$1,p__35492__$1,map__35493__$2,opts__$1,view__$1,meta35496){
return (new hatti.views.record.t_hatti$views$record35495(cursor__$1,owner__$1,p__35492__$1,map__35493__$2,opts__$1,view__$1,meta35496));
});})(map__35493,map__35493__$1,opts,view))
;

}

return (new hatti.views.record.t_hatti$views$record35495(cursor,owner,p__35492,map__35493__$1,opts,view,cljs.core.PersistentArrayMap.EMPTY));
}));
