// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0))], 0))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__38447_SHARP_){
if(typeof p1__38447_SHARP_ === 'string'){
return clojure.string.lower_case(p1__38447_SHARP_);
} else {
return p1__38447_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__38453){
var vec__38454 = p__38453;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38454,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38454,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,cljs.core.array_seq([cljs.core.cst$kw$compact_QMARK_,true], 0));
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__38448_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__38448_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
var media_count = (dataContext["_media_count"]);
var total_media = (dataContext["_total_media"]);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,chimera.string.escape_for_type(clj_value),cljs.core.array_seq([cljs.core.cst$kw$language,language,cljs.core.cst$kw$compact_QMARK_,true,cljs.core.cst$kw$field_DASH_key,field_key,cljs.core.cst$kw$media_DASH_count,media_count,cljs.core.cst$kw$total_DASH_media,total_media], 0));
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__38457 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__38457__$1 = ((((!((map__38457 == null)))?((((map__38457.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38457.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38457):map__38457);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38457__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38457__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38457__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$delete_DASH_record,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$data_DASH_id,value], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip$middle_DASH_right,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_eye,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.select_unselect_all_records_id = "select-unselect-all-records";
hatti.views.table.select_unselect_all_records_element = [cljs.core.str("<input type=\"checkbox\" id=\""),cljs.core.str(hatti.views.table.select_unselect_all_records_id),cljs.core.str("\">")].join('');
hatti.views.table.delete_record_class = "delete-record";
hatti.views.table.submission_review_fields = (function hatti$views$table$submission_review_fields(cols){
var vec__38462 = cljs.core.split_at((1),cols);
var actions = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38462,(0),null);
var data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38462,(1),null);
return cljs.core.vec(cljs.core.flatten(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(data,hatti.ona.forms.review_comment_field,cljs.core.array_seq([hatti.ona.forms.review_status_field,actions], 0))));
});
hatti.views.actions_column.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(100),hatti.views.table.select_unselect_all_records_element,(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
}));
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38497 = arguments.length;
var i__7485__auto___38498 = (0);
while(true){
if((i__7485__auto___38498 < len__7484__auto___38497)){
args__7491__auto__.push((arguments[i__7485__auto___38498]));

var G__38499 = (i__7485__auto___38498 + (1));
i__7485__auto___38498 = G__38499;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__38468){
var map__38469 = p__38468;
var map__38469__$1 = ((((!((map__38469 == null)))?((((map__38469.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38469.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38469):map__38469);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38469__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var submission_review_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38469__$1,cljs.core.cst$kw$submission_DASH_review_QMARK_);
var get_label_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38469__$1,cljs.core.cst$kw$get_DASH_label_QMARK_,true);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38469__$1,cljs.core.cst$kw$language);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38469__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = (function (){var G__38471 = cljs.core.false_QMARK_;
var G__38472 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__38471,map__38469,map__38469__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__38465_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__38465_SHARP_)) == null);
});})(G__38471,map__38469,map__38469__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
,form);
return (chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__38471,G__38472) : chimera.core.any_QMARK_.call(null,G__38471,G__38472));
})();
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__38469,map__38469__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__38473(s__38474){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__38469,map__38469__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__38474__$1 = s__38474;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38474__$1);
if(temp__4657__auto__){
var s__38474__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38474__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38474__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38476 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38475 = (0);
while(true){
if((i__38475 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38475);
cljs.core.chunk_append(b__38476,(function (){var map__38487 = field;
var map__38487__$1 = ((((!((map__38487 == null)))?((((map__38487.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38487.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38487):map__38487);
var map__38488 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38487__$1,cljs.core.cst$kw$instance);
var map__38488__$1 = ((((!((map__38488 == null)))?((((map__38488.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38488.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38488):map__38488);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38488__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38487__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38487__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38487__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__38500 = (i__38475 + (1));
i__38475 = G__38500;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38476),hatti$views$table$iter__38473(cljs.core.chunk_rest(s__38474__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38476),null);
}
} else {
var field = cljs.core.first(s__38474__$2);
return cljs.core.cons((function (){var map__38491 = field;
var map__38491__$1 = ((((!((map__38491 == null)))?((((map__38491.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38491.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38491):map__38491);
var map__38492 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38491__$1,cljs.core.cst$kw$instance);
var map__38492__$1 = ((((!((map__38492 == null)))?((((map__38492.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38492.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38492):map__38492);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38492__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38491__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38491__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38491__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__38473(cljs.core.rest(s__38474__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__38469,map__38469__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__38469,map__38469__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__((function (){var G__38495 = hatti.views.table.all_fields(form);
if(cljs.core.truth_(submission_review_QMARK_)){
return hatti.views.table.submission_review_fields(G__38495);
} else {
return G__38495;
}
})());
})();
return cljs.core.clj__GT_js((function (){var G__38496 = columns;
if(cljs.core.not(hide_actions_column_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__38496,(hatti.views.actions_column.cljs$core$IFn$_invoke$arity$2 ? hatti.views.actions_column.cljs$core$IFn$_invoke$arity$2(owner,has_hxl_QMARK_) : hatti.views.actions_column.call(null,owner,has_hxl_QMARK_)));
} else {
return G__38496;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq38466){
var G__38467 = cljs.core.first(seq38466);
var seq38466__$1 = cljs.core.next(seq38466);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__38467,seq38466__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__38502 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__38502);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38521(s__38522){
return (new cljs.core.LazySeq(null,(function (){
var s__38522__$1 = s__38522;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38522__$1);
if(temp__4657__auto__){
var s__38522__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38522__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38522__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38524 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38523 = (0);
while(true){
if((i__38523 < size__7188__auto__)){
var vec__38533 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38523);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38533,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38533,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__38524,event.subscribe(handler_function));

var G__38539 = (i__38523 + (1));
i__38523 = G__38539;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38524),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38521(cljs.core.chunk_rest(s__38522__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38524),null);
}
} else {
var vec__38536 = cljs.core.first(s__38522__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38536,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38536,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38521(cljs.core.rest(s__38522__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38558(s__38559){
return (new cljs.core.LazySeq(null,(function (){
var s__38559__$1 = s__38559;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38559__$1);
if(temp__4657__auto__){
var s__38559__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38559__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38559__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38561 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38560 = (0);
while(true){
if((i__38560 < size__7188__auto__)){
var vec__38570 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38560);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38570,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38570,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__38561,event.subscribe(handler_function));

var G__38576 = (i__38560 + (1));
i__38560 = G__38576;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38561),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38558(cljs.core.chunk_rest(s__38559__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38561),null);
}
} else {
var vec__38573 = cljs.core.first(s__38559__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38573,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38573,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38558(cljs.core.rest(s__38559__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.update_data_to_be_deleted_vector = (function hatti$views$table$update_data_to_be_deleted_vector(checked_QMARK_,data_id){
var map__38579 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38579__$1 = ((((!((map__38579 == null)))?((((map__38579.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38579.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38579):map__38579);
var data_to_be_deleted = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38579__$1,cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted);
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted], null),((function (map__38579,map__38579__$1,data_to_be_deleted,fn){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(data_to_be_deleted,data_id) : fn.call(null,data_to_be_deleted,data_id));
});})(map__38579,map__38579__$1,data_to_be_deleted,fn))
);
});
hatti.views.table.get_elements_count_by_selector = (function hatti$views$table$get_elements_count_by_selector(selector){
return document.querySelectorAll(selector).length;
});
hatti.views.table.check_select_unselect_all_records_element_QMARK_ = (function hatti$views$table$check_select_unselect_all_records_element_QMARK_(){
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
var selected_rows_count = hatti.views.table.get_elements_count_by_selector([cljs.core.str(delete_record_class_selector),cljs.core.str(":checked")].join(''));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected_rows_count,total_rows_count);
});
hatti.views.table.get_checkbox_selector = (function hatti$views$table$get_checkbox_selector(data_id){
return [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class),cljs.core.str("[data-id=\""),cljs.core.str(data_id),cljs.core.str("\"]")].join('');
});
hatti.views.table.get_delete_checkbox_by_data_id = (function hatti$views$table$get_delete_checkbox_by_data_id(data_id){
var selector = hatti.views.table.get_checkbox_selector(data_id);
return document.querySelector(selector);
});
hatti.views.table.select_rows_marked_to_be_deleted = (function hatti$views$table$select_rows_marked_to_be_deleted(){
var seq__38585 = cljs.core.seq(cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var chunk__38586 = null;
var count__38587 = (0);
var i__38588 = (0);
while(true){
if((i__38588 < count__38587)){
var data_id = chunk__38586.cljs$core$IIndexed$_nth$arity$2(null,i__38588);
var element_38589 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38589.checked = true;

var G__38590 = seq__38585;
var G__38591 = chunk__38586;
var G__38592 = count__38587;
var G__38593 = (i__38588 + (1));
seq__38585 = G__38590;
chunk__38586 = G__38591;
count__38587 = G__38592;
i__38588 = G__38593;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__38585);
if(temp__4657__auto__){
var seq__38585__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38585__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__38585__$1);
var G__38594 = cljs.core.chunk_rest(seq__38585__$1);
var G__38595 = c__7220__auto__;
var G__38596 = cljs.core.count(c__7220__auto__);
var G__38597 = (0);
seq__38585 = G__38594;
chunk__38586 = G__38595;
count__38587 = G__38596;
i__38588 = G__38597;
continue;
} else {
var data_id = cljs.core.first(seq__38585__$1);
var element_38598 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38598.checked = true;

var G__38599 = cljs.core.next(seq__38585__$1);
var G__38600 = null;
var G__38601 = (0);
var G__38602 = (0);
seq__38585 = G__38599;
chunk__38586 = G__38600;
count__38587 = G__38601;
i__38588 = G__38602;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.higlight_rows_marked_to_be_deleted = (function hatti$views$table$higlight_rows_marked_to_be_deleted(grid){
var checkboxes = document.getElementsByClassName(hatti.views.table.delete_record_class);
var indexes_of_selected_checkboxes = cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (checkboxes){
return (function (index,checkbox){
if(cljs.core.truth_(checkbox.checked)){
return index;
} else {
return null;
}
});})(checkboxes))
,checkboxes)));
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (checkboxes,indexes_of_selected_checkboxes){
return (function (){
return cljs.core.identity(indexes_of_selected_checkboxes);
});})(checkboxes,indexes_of_selected_checkboxes))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(indexes_of_selected_checkboxes));
});
hatti.views.table.replace_review_num_status_with_text_status = (function hatti$views$table$replace_review_num_status_with_text_status(data){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (row_map){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(row_map,"_review_status",hatti.utils.get_submission_review_text(row_map));
}),data);
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__38603){
var map__38623 = p__38603;
var map__38623__$1 = ((((!((map__38623 == null)))?((((map__38623.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38623.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38623):map__38623);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38623__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38623__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var map__38625 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38625__$1 = ((((!((map__38625 == null)))?((((map__38625.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38625.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38625):map__38625);
var map__38626 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38625__$1,cljs.core.cst$kw$table_DASH_page);
var map__38626__$1 = ((((!((map__38626 == null)))?((((map__38626.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38626.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38626):map__38626);
var map__38627 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38626__$1,cljs.core.cst$kw$paging);
var map__38627__$1 = ((((!((map__38627 == null)))?((((map__38627.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38627.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38627):map__38627);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38627__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38627__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38626__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var submission_review_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38625__$1,cljs.core.cst$kw$submission_DASH_review_QMARK_);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$language,current_language,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,hide_actions_column_QMARK_,cljs.core.cst$kw$submission_DASH_review_QMARK_,submission_review_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

grid.setSelectionModel((new Slick.RowSelectionModel(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selectActiveRow,false], null)))));

dataview.onRowCountChanged.subscribe(((function (map__38625,map__38625__$1,map__38626,map__38626__$1,map__38627,map__38627__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38623,map__38623__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__38625,map__38625__$1,map__38626,map__38626__$1,map__38627,map__38627__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38623,map__38623__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__38625,map__38625__$1,map__38626,map__38626__$1,map__38627,map__38627__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38623,map__38623__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

grid.render();

hatti.views.table.select_rows_marked_to_be_deleted();

return hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
});})(map__38625,map__38625__$1,map__38626,map__38626__$1,map__38627,map__38627__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38623,map__38623__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onHeaderClick.subscribe(((function (map__38625,map__38625__$1,map__38626,map__38626__$1,map__38627,map__38627__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38623,map__38623__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var target = e.target;
var id = target.id;
var checked_QMARK_ = target.checked;
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hatti.views.table.select_unselect_all_records_id,id)){
var records_to_be_deleted = document.getElementsByClassName(hatti.views.table.delete_record_class);
var seq__38631_38642 = cljs.core.seq(records_to_be_deleted);
var chunk__38632_38643 = null;
var count__38633_38644 = (0);
var i__38634_38645 = (0);
while(true){
if((i__38634_38645 < count__38633_38644)){
var record_38646 = chunk__38632_38643.cljs$core$IIndexed$_nth$arity$2(null,i__38634_38645);
record_38646.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38635 = record_38646.getAttribute("data-id");
return parseInt(G__38635);
})());

var G__38647 = seq__38631_38642;
var G__38648 = chunk__38632_38643;
var G__38649 = count__38633_38644;
var G__38650 = (i__38634_38645 + (1));
seq__38631_38642 = G__38647;
chunk__38632_38643 = G__38648;
count__38633_38644 = G__38649;
i__38634_38645 = G__38650;
continue;
} else {
var temp__4657__auto___38651 = cljs.core.seq(seq__38631_38642);
if(temp__4657__auto___38651){
var seq__38631_38652__$1 = temp__4657__auto___38651;
if(cljs.core.chunked_seq_QMARK_(seq__38631_38652__$1)){
var c__7220__auto___38653 = cljs.core.chunk_first(seq__38631_38652__$1);
var G__38654 = cljs.core.chunk_rest(seq__38631_38652__$1);
var G__38655 = c__7220__auto___38653;
var G__38656 = cljs.core.count(c__7220__auto___38653);
var G__38657 = (0);
seq__38631_38642 = G__38654;
chunk__38632_38643 = G__38655;
count__38633_38644 = G__38656;
i__38634_38645 = G__38657;
continue;
} else {
var record_38658 = cljs.core.first(seq__38631_38652__$1);
record_38658.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38636 = record_38658.getAttribute("data-id");
return parseInt(G__38636);
})());

var G__38659 = cljs.core.next(seq__38631_38652__$1);
var G__38660 = null;
var G__38661 = (0);
var G__38662 = (0);
seq__38631_38642 = G__38659;
chunk__38632_38643 = G__38660;
count__38633_38644 = G__38661;
i__38634_38645 = G__38662;
continue;
}
} else {
}
}
break;
}

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38625,map__38625__$1,map__38626,map__38626__$1,map__38627,map__38627__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38623,map__38623__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
if(cljs.core.truth_(checked_QMARK_)){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1(total_rows_count);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});})(records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38625,map__38625__$1,map__38626,map__38626__$1,map__38627,map__38627__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38623,map__38623__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
return null;
}
});})(map__38625,map__38625__$1,map__38626,map__38626__$1,map__38627,map__38627__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38623,map__38623__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__38625,map__38625__$1,map__38626,map__38626__$1,map__38627,map__38627__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38623,map__38623__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(map__38625,map__38625__$1,map__38626,map__38626__$1,map__38627,map__38627__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38623,map__38623__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__38625,map__38625__$1,map__38626,map__38626__$1,map__38627,map__38627__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38623,map__38623__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var class_name = elem.className;
var checked_QMARK_ = elem.checked;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__38638 = elem.getAttribute("data-id");
return parseInt(G__38638);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
var select_unselect_all_records_chkbox = document.getElementById(hatti.views.table.select_unselect_all_records_id);
var map__38637 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38637__$1 = ((((!((map__38637 == null)))?((((map__38637.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38637.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38637):map__38637);
var selected_table_rows = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38637__$1,cljs.core.cst$kw$selected_DASH_table_DASH_rows);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(class_name,hatti.views.table.delete_record_class)){
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
var row__$1 = (function (){var G__38640 = grid.getCellFromEvent(e).row;
return parseInt(G__38640);
})();
hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,data_id);

select_unselect_all_records_chkbox.checked = hatti.views.table.check_select_unselect_all_records_element_QMARK_();

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38637,map__38637__$1,selected_table_rows,map__38625,map__38625__$1,map__38626,map__38626__$1,map__38627,map__38627__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38623,map__38623__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(selected_table_rows,row__$1) : fn.call(null,selected_table_rows,row__$1));
});})(fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38637,map__38637__$1,selected_table_rows,map__38625,map__38625__$1,map__38626,map__38626__$1,map__38627,map__38627__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38623,map__38623__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
}
});})(map__38625,map__38625__$1,map__38626,map__38626__$1,map__38627,map__38627__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38623,map__38623__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js((function (){var G__38641 = data;
if(cljs.core.truth_(submission_review_QMARK_)){
return hatti.views.table.replace_review_num_status_with_text_status(G__38641);
} else {
return G__38641;
}
})()),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__13879__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13879__auto__,event_chan){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto__,event_chan){
return (function (state_38954){
var state_val_38955 = (state_38954[(1)]);
if((state_val_38955 === (7))){
var inst_38852 = (state_38954[(7)]);
var inst_38852__$1 = (state_38954[(2)]);
var inst_38854 = (inst_38852__$1 == null);
var inst_38855 = cljs.core.not(inst_38854);
var state_38954__$1 = (function (){var statearr_38956 = state_38954;
(statearr_38956[(7)] = inst_38852__$1);

return statearr_38956;
})();
if(inst_38855){
var statearr_38957_39032 = state_38954__$1;
(statearr_38957_39032[(1)] = (8));

} else {
var statearr_38958_39033 = state_38954__$1;
(statearr_38958_39033[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (20))){
var inst_38874 = (state_38954[(8)]);
var inst_38882 = (state_38954[(9)]);
var inst_38891 = (inst_38882.cljs$core$IFn$_invoke$arity$1 ? inst_38882.cljs$core$IFn$_invoke$arity$1(inst_38874) : inst_38882.call(null,inst_38874));
var state_38954__$1 = state_38954;
var statearr_38959_39034 = state_38954__$1;
(statearr_38959_39034[(2)] = inst_38891);

(statearr_38959_39034[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (27))){
var state_38954__$1 = state_38954;
var statearr_38960_39035 = state_38954__$1;
(statearr_38960_39035[(2)] = null);

(statearr_38960_39035[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (1))){
var state_38954__$1 = state_38954;
var statearr_38961_39036 = state_38954__$1;
(statearr_38961_39036[(2)] = null);

(statearr_38961_39036[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (24))){
var state_38954__$1 = state_38954;
var statearr_38962_39037 = state_38954__$1;
(statearr_38962_39037[(2)] = null);

(statearr_38962_39037[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (4))){
var state_38954__$1 = state_38954;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38954__$1,(7),event_chan);
} else {
if((state_val_38955 === (15))){
var inst_38852 = (state_38954[(7)]);
var state_38954__$1 = state_38954;
var statearr_38963_39038 = state_38954__$1;
(statearr_38963_39038[(2)] = inst_38852);

(statearr_38963_39038[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (21))){
var state_38954__$1 = state_38954;
var statearr_38964_39039 = state_38954__$1;
(statearr_38964_39039[(2)] = null);

(statearr_38964_39039[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (31))){
var inst_38878 = (state_38954[(10)]);
var inst_38927 = (state_38954[(2)]);
var inst_38928 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38878,cljs.core.cst$kw$table);
var state_38954__$1 = (function (){var statearr_38965 = state_38954;
(statearr_38965[(11)] = inst_38927);

return statearr_38965;
})();
if(inst_38928){
var statearr_38966_39040 = state_38954__$1;
(statearr_38966_39040[(1)] = (32));

} else {
var statearr_38967_39041 = state_38954__$1;
(statearr_38967_39041[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (32))){
var inst_38883 = (state_38954[(12)]);
var inst_38873 = (state_38954[(13)]);
var inst_38878 = (state_38954[(10)]);
var inst_38875 = (state_38954[(14)]);
var inst_38872 = (state_38954[(15)]);
var inst_38874 = (state_38954[(8)]);
var inst_38882 = (state_38954[(9)]);
var inst_38877 = (state_38954[(16)]);
var inst_38876 = (state_38954[(17)]);
var inst_38941 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38942 = (function (){var new_columns = inst_38877;
var submission_clicked = inst_38874;
var submission_unclicked = inst_38875;
var get_submission_data = inst_38883;
var re_render = inst_38878;
var update_data_BANG_ = inst_38882;
var submission_to_rank = inst_38873;
var filter_by = inst_38876;
var c__13879__auto____$1 = inst_38941;
var map__38850 = inst_38872;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,map__38850,inst_38883,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38941,state_val_38955,c__13879__auto__,event_chan){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,map__38850,inst_38883,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38941,state_val_38955,c__13879__auto__,event_chan){
return (function (state_38939){
var state_val_38940 = (state_38939[(1)]);
if((state_val_38940 === (1))){
var inst_38930 = cljs.core.async.timeout((20));
var state_38939__$1 = state_38939;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38939__$1,(2),inst_38930);
} else {
if((state_val_38940 === (2))){
var inst_38932 = (state_38939[(2)]);
var inst_38933 = grid.resizeCanvas();
var inst_38934 = grid.invalidateAllRows();
var inst_38935 = hatti.views.table.resizeColumns(grid);
var inst_38936 = grid.render();
var inst_38937 = hatti.views.table.init_sg_pager(grid,dataview);
var state_38939__$1 = (function (){var statearr_38968 = state_38939;
(statearr_38968[(7)] = inst_38935);

(statearr_38968[(8)] = inst_38936);

(statearr_38968[(9)] = inst_38934);

(statearr_38968[(10)] = inst_38932);

(statearr_38968[(11)] = inst_38933);

return statearr_38968;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38939__$1,inst_38937);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,map__38850,inst_38883,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38941,state_val_38955,c__13879__auto__,event_chan))
;
return ((function (switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,map__38850,inst_38883,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38941,state_val_38955,c__13879__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____0 = (function (){
var statearr_38972 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38972[(0)] = hatti$views$table$handle_table_events_$_state_machine__13768__auto__);

(statearr_38972[(1)] = (1));

return statearr_38972;
});
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____1 = (function (state_38939){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__(state_38939);
if(cljs.core.keyword_identical_QMARK_(result__13770__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e38973){if((e38973 instanceof Object)){
var ex__13771__auto__ = e38973;
var statearr_38974_39042 = state_38939;
(statearr_38974_39042[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38939);

return cljs.core.cst$kw$recur;
} else {
throw e38973;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13769__auto__,cljs.core.cst$kw$recur)){
var G__39043 = state_38939;
state_38939 = G__39043;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = function(state_38939){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____1.call(this,state_38939);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,map__38850,inst_38883,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38941,state_val_38955,c__13879__auto__,event_chan))
})();
var state__13881__auto__ = (function (){var statearr_38975 = (f__13880__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13880__auto__.cljs$core$IFn$_invoke$arity$0() : f__13880__auto__.call(null));
(statearr_38975[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto____$1);

return statearr_38975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13881__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,map__38850,inst_38883,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38941,state_val_38955,c__13879__auto__,event_chan))
})();
var inst_38943 = cljs.core.async.impl.dispatch.run(inst_38942);
var state_38954__$1 = (function (){var statearr_38976 = state_38954;
(statearr_38976[(18)] = inst_38943);

return statearr_38976;
})();
var statearr_38977_39044 = state_38954__$1;
(statearr_38977_39044[(2)] = inst_38941);

(statearr_38977_39044[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (33))){
var state_38954__$1 = state_38954;
var statearr_38978_39045 = state_38954__$1;
(statearr_38978_39045[(2)] = null);

(statearr_38978_39045[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (13))){
var inst_38864 = (state_38954[(2)]);
var state_38954__$1 = state_38954;
var statearr_38979_39046 = state_38954__$1;
(statearr_38979_39046[(2)] = inst_38864);

(statearr_38979_39046[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (22))){
var inst_38875 = (state_38954[(14)]);
var inst_38894 = (state_38954[(2)]);
var state_38954__$1 = (function (){var statearr_38980 = state_38954;
(statearr_38980[(19)] = inst_38894);

return statearr_38980;
})();
if(cljs.core.truth_(inst_38875)){
var statearr_38981_39047 = state_38954__$1;
(statearr_38981_39047[(1)] = (23));

} else {
var statearr_38982_39048 = state_38954__$1;
(statearr_38982_39048[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (29))){
var inst_38876 = (state_38954[(17)]);
var inst_38919 = [cljs.core.cst$kw$query];
var inst_38920 = [inst_38876];
var inst_38921 = cljs.core.PersistentHashMap.fromArrays(inst_38919,inst_38920);
var inst_38922 = cljs.core.clj__GT_js(inst_38921);
var inst_38923 = dataview.setFilterArgs(inst_38922);
var inst_38924 = dataview.refresh();
var state_38954__$1 = (function (){var statearr_38983 = state_38954;
(statearr_38983[(20)] = inst_38923);

return statearr_38983;
})();
var statearr_38984_39049 = state_38954__$1;
(statearr_38984_39049[(2)] = inst_38924);

(statearr_38984_39049[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (6))){
var inst_38950 = (state_38954[(2)]);
var state_38954__$1 = state_38954;
var statearr_38985_39050 = state_38954__$1;
(statearr_38985_39050[(2)] = inst_38950);

(statearr_38985_39050[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (28))){
var inst_38876 = (state_38954[(17)]);
var inst_38917 = (state_38954[(2)]);
var state_38954__$1 = (function (){var statearr_38986 = state_38954;
(statearr_38986[(21)] = inst_38917);

return statearr_38986;
})();
if(cljs.core.truth_(inst_38876)){
var statearr_38987_39051 = state_38954__$1;
(statearr_38987_39051[(1)] = (29));

} else {
var statearr_38988_39052 = state_38954__$1;
(statearr_38988_39052[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (25))){
var inst_38877 = (state_38954[(16)]);
var inst_38899 = (state_38954[(2)]);
var state_38954__$1 = (function (){var statearr_38989 = state_38954;
(statearr_38989[(22)] = inst_38899);

return statearr_38989;
})();
if(cljs.core.truth_(inst_38877)){
var statearr_38990_39053 = state_38954__$1;
(statearr_38990_39053[(1)] = (26));

} else {
var statearr_38991_39054 = state_38954__$1;
(statearr_38991_39054[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (34))){
var inst_38946 = (state_38954[(2)]);
var state_38954__$1 = (function (){var statearr_38992 = state_38954;
(statearr_38992[(23)] = inst_38946);

return statearr_38992;
})();
var statearr_38993_39055 = state_38954__$1;
(statearr_38993_39055[(2)] = null);

(statearr_38993_39055[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (17))){
var inst_38883 = (state_38954[(12)]);
var inst_38873 = (state_38954[(13)]);
var inst_38882 = (state_38954[(9)]);
var inst_38885 = (inst_38883.cljs$core$IFn$_invoke$arity$2 ? inst_38883.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_38873) : inst_38883.call(null,hatti.constants._rank,inst_38873));
var inst_38886 = (inst_38882.cljs$core$IFn$_invoke$arity$1 ? inst_38882.cljs$core$IFn$_invoke$arity$1(inst_38885) : inst_38882.call(null,inst_38885));
var state_38954__$1 = state_38954;
var statearr_38994_39056 = state_38954__$1;
(statearr_38994_39056[(2)] = inst_38886);

(statearr_38994_39056[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (3))){
var inst_38952 = (state_38954[(2)]);
var state_38954__$1 = state_38954;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38954__$1,inst_38952);
} else {
if((state_val_38955 === (12))){
var state_38954__$1 = state_38954;
var statearr_38995_39057 = state_38954__$1;
(statearr_38995_39057[(2)] = false);

(statearr_38995_39057[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (2))){
var state_38954__$1 = state_38954;
var statearr_38996_39058 = state_38954__$1;
(statearr_38996_39058[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (23))){
var inst_38882 = (state_38954[(9)]);
var inst_38896 = (inst_38882.cljs$core$IFn$_invoke$arity$1 ? inst_38882.cljs$core$IFn$_invoke$arity$1(null) : inst_38882.call(null,null));
var state_38954__$1 = state_38954;
var statearr_38998_39059 = state_38954__$1;
(statearr_38998_39059[(2)] = inst_38896);

(statearr_38998_39059[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (19))){
var inst_38874 = (state_38954[(8)]);
var inst_38889 = (state_38954[(2)]);
var state_38954__$1 = (function (){var statearr_38999 = state_38954;
(statearr_38999[(24)] = inst_38889);

return statearr_38999;
})();
if(cljs.core.truth_(inst_38874)){
var statearr_39000_39060 = state_38954__$1;
(statearr_39000_39060[(1)] = (20));

} else {
var statearr_39001_39061 = state_38954__$1;
(statearr_39001_39061[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (11))){
var state_38954__$1 = state_38954;
var statearr_39002_39062 = state_38954__$1;
(statearr_39002_39062[(2)] = true);

(statearr_39002_39062[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (9))){
var state_38954__$1 = state_38954;
var statearr_39003_39063 = state_38954__$1;
(statearr_39003_39063[(2)] = false);

(statearr_39003_39063[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (5))){
var state_38954__$1 = state_38954;
var statearr_39004_39064 = state_38954__$1;
(statearr_39004_39064[(2)] = null);

(statearr_39004_39064[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (14))){
var inst_38852 = (state_38954[(7)]);
var inst_38869 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38852);
var state_38954__$1 = state_38954;
var statearr_39005_39065 = state_38954__$1;
(statearr_39005_39065[(2)] = inst_38869);

(statearr_39005_39065[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (26))){
var inst_38883 = (state_38954[(12)]);
var inst_38873 = (state_38954[(13)]);
var inst_38878 = (state_38954[(10)]);
var inst_38875 = (state_38954[(14)]);
var inst_38872 = (state_38954[(15)]);
var inst_38874 = (state_38954[(8)]);
var inst_38882 = (state_38954[(9)]);
var inst_38877 = (state_38954[(16)]);
var inst_38876 = (state_38954[(17)]);
var inst_38912 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38913 = (function (){var new_columns = inst_38877;
var submission_clicked = inst_38874;
var submission_unclicked = inst_38875;
var get_submission_data = inst_38883;
var re_render = inst_38878;
var update_data_BANG_ = inst_38882;
var submission_to_rank = inst_38873;
var filter_by = inst_38876;
var c__13879__auto____$1 = inst_38912;
var map__38850 = inst_38872;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,map__38850,inst_38883,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38912,state_val_38955,c__13879__auto__,event_chan){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,map__38850,inst_38883,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38912,state_val_38955,c__13879__auto__,event_chan){
return (function (state_38910){
var state_val_38911 = (state_38910[(1)]);
if((state_val_38911 === (1))){
var inst_38901 = cljs.core.async.timeout((20));
var state_38910__$1 = state_38910;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38910__$1,(2),inst_38901);
} else {
if((state_val_38911 === (2))){
var inst_38903 = (state_38910[(2)]);
var inst_38904 = grid.setColumns(new_columns);
var inst_38905 = hatti.views.table.resizeColumns(grid);
var inst_38906 = grid.render();
var inst_38907 = hatti.views.table.select_rows_marked_to_be_deleted();
var inst_38908 = hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
var state_38910__$1 = (function (){var statearr_39006 = state_38910;
(statearr_39006[(7)] = inst_38906);

(statearr_39006[(8)] = inst_38904);

(statearr_39006[(9)] = inst_38903);

(statearr_39006[(10)] = inst_38905);

(statearr_39006[(11)] = inst_38907);

return statearr_39006;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38910__$1,inst_38908);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,map__38850,inst_38883,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38912,state_val_38955,c__13879__auto__,event_chan))
;
return ((function (switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,map__38850,inst_38883,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38912,state_val_38955,c__13879__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____0 = (function (){
var statearr_39010 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39010[(0)] = hatti$views$table$handle_table_events_$_state_machine__13768__auto__);

(statearr_39010[(1)] = (1));

return statearr_39010;
});
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____1 = (function (state_38910){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__(state_38910);
if(cljs.core.keyword_identical_QMARK_(result__13770__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e39011){if((e39011 instanceof Object)){
var ex__13771__auto__ = e39011;
var statearr_39012_39066 = state_38910;
(statearr_39012_39066[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38910);

return cljs.core.cst$kw$recur;
} else {
throw e39011;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13769__auto__,cljs.core.cst$kw$recur)){
var G__39067 = state_38910;
state_38910 = G__39067;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = function(state_38910){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____1.call(this,state_38910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,map__38850,inst_38883,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38912,state_val_38955,c__13879__auto__,event_chan))
})();
var state__13881__auto__ = (function (){var statearr_39013 = (f__13880__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13880__auto__.cljs$core$IFn$_invoke$arity$0() : f__13880__auto__.call(null));
(statearr_39013[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto____$1);

return statearr_39013;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13881__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,map__38850,inst_38883,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38912,state_val_38955,c__13879__auto__,event_chan))
})();
var inst_38914 = cljs.core.async.impl.dispatch.run(inst_38913);
var state_38954__$1 = (function (){var statearr_39014 = state_38954;
(statearr_39014[(25)] = inst_38914);

return statearr_39014;
})();
var statearr_39015_39068 = state_38954__$1;
(statearr_39015_39068[(2)] = inst_38912);

(statearr_39015_39068[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (16))){
var inst_38873 = (state_38954[(13)]);
var inst_38878 = (state_38954[(10)]);
var inst_38875 = (state_38954[(14)]);
var inst_38872 = (state_38954[(15)]);
var inst_38874 = (state_38954[(8)]);
var inst_38882 = (state_38954[(9)]);
var inst_38877 = (state_38954[(16)]);
var inst_38876 = (state_38954[(17)]);
var inst_38872__$1 = (state_38954[(2)]);
var inst_38873__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38872__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_38874__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38872__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_38875__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38872__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_38876__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38872__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_38877__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38872__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_38878__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38872__$1,cljs.core.cst$kw$re_DASH_render);
var inst_38879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38880 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_38881 = (new cljs.core.PersistentVector(null,3,(5),inst_38879,inst_38880,null));
var inst_38882__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_38881);
var inst_38883 = (function (){var map__38850 = inst_38872__$1;
var submission_to_rank = inst_38873__$1;
var submission_clicked = inst_38874__$1;
var submission_unclicked = inst_38875__$1;
var filter_by = inst_38876__$1;
var new_columns = inst_38877__$1;
var re_render = inst_38878__$1;
var update_data_BANG_ = inst_38882__$1;
return ((function (map__38850,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38872__$1,inst_38873__$1,inst_38874__$1,inst_38875__$1,inst_38876__$1,inst_38877__$1,inst_38878__$1,inst_38879,inst_38880,inst_38881,inst_38882__$1,state_val_38955,c__13879__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__38850,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38872__$1,inst_38873__$1,inst_38874__$1,inst_38875__$1,inst_38876__$1,inst_38877__$1,inst_38878__$1,inst_38879,inst_38880,inst_38881,inst_38882__$1,state_val_38955,c__13879__auto__,event_chan){
return (function (p1__38663_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__38663_SHARP_,field));
});})(map__38850,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38872__$1,inst_38873__$1,inst_38874__$1,inst_38875__$1,inst_38876__$1,inst_38877__$1,inst_38878__$1,inst_38879,inst_38880,inst_38881,inst_38882__$1,state_val_38955,c__13879__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(map__38850,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38873,inst_38878,inst_38875,inst_38872,inst_38874,inst_38882,inst_38877,inst_38876,inst_38872__$1,inst_38873__$1,inst_38874__$1,inst_38875__$1,inst_38876__$1,inst_38877__$1,inst_38878__$1,inst_38879,inst_38880,inst_38881,inst_38882__$1,state_val_38955,c__13879__auto__,event_chan))
})();
var state_38954__$1 = (function (){var statearr_39016 = state_38954;
(statearr_39016[(12)] = inst_38883);

(statearr_39016[(13)] = inst_38873__$1);

(statearr_39016[(10)] = inst_38878__$1);

(statearr_39016[(14)] = inst_38875__$1);

(statearr_39016[(15)] = inst_38872__$1);

(statearr_39016[(8)] = inst_38874__$1);

(statearr_39016[(9)] = inst_38882__$1);

(statearr_39016[(16)] = inst_38877__$1);

(statearr_39016[(17)] = inst_38876__$1);

return statearr_39016;
})();
if(cljs.core.truth_(inst_38873__$1)){
var statearr_39017_39069 = state_38954__$1;
(statearr_39017_39069[(1)] = (17));

} else {
var statearr_39018_39070 = state_38954__$1;
(statearr_39018_39070[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (30))){
var state_38954__$1 = state_38954;
var statearr_39019_39071 = state_38954__$1;
(statearr_39019_39071[(2)] = null);

(statearr_39019_39071[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (10))){
var inst_38867 = (state_38954[(2)]);
var state_38954__$1 = state_38954;
if(cljs.core.truth_(inst_38867)){
var statearr_39020_39072 = state_38954__$1;
(statearr_39020_39072[(1)] = (14));

} else {
var statearr_39021_39073 = state_38954__$1;
(statearr_39021_39073[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (18))){
var state_38954__$1 = state_38954;
var statearr_39022_39074 = state_38954__$1;
(statearr_39022_39074[(2)] = null);

(statearr_39022_39074[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38955 === (8))){
var inst_38852 = (state_38954[(7)]);
var inst_38857 = inst_38852.cljs$lang$protocol_mask$partition0$;
var inst_38858 = (inst_38857 & (64));
var inst_38859 = inst_38852.cljs$core$ISeq$;
var inst_38860 = (inst_38858) || (inst_38859);
var state_38954__$1 = state_38954;
if(cljs.core.truth_(inst_38860)){
var statearr_39023_39075 = state_38954__$1;
(statearr_39023_39075[(1)] = (11));

} else {
var statearr_39024_39076 = state_38954__$1;
(statearr_39024_39076[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto__,event_chan))
;
return ((function (switch__13767__auto__,c__13879__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____0 = (function (){
var statearr_39028 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39028[(0)] = hatti$views$table$handle_table_events_$_state_machine__13768__auto__);

(statearr_39028[(1)] = (1));

return statearr_39028;
});
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____1 = (function (state_38954){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__(state_38954);
if(cljs.core.keyword_identical_QMARK_(result__13770__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e39029){if((e39029 instanceof Object)){
var ex__13771__auto__ = e39029;
var statearr_39030_39077 = state_38954;
(statearr_39030_39077[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38954);

return cljs.core.cst$kw$recur;
} else {
throw e39029;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13769__auto__,cljs.core.cst$kw$recur)){
var G__39078 = state_38954;
state_38954 = G__39078;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = function(state_38954){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____1.call(this,state_38954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto__,event_chan))
})();
var state__13881__auto__ = (function (){var statearr_39031 = (f__13880__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13880__auto__.cljs$core$IFn$_invoke$arity$0() : f__13880__auto__.call(null));
(statearr_39031[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto__);

return statearr_39031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13881__auto__);
});})(c__13879__auto__,event_chan))
);

return c__13879__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$field_DASH_key,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__39097(s__39098){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__39098__$1 = s__39098;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39098__$1);
if(temp__4657__auto__){
var s__39098__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39098__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39098__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39100 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39099 = (0);
while(true){
if((i__39099 < size__7188__auto__)){
var vec__39109 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39099);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39109,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39109,(1),null);
cljs.core.chunk_append(b__39100,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__39099,vec__39109,k,v,c__7187__auto__,size__7188__auto__,b__39100,s__39098__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__39099,vec__39109,k,v,c__7187__auto__,size__7188__auto__,b__39100,s__39098__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__39115 = (i__39099 + (1));
i__39099 = G__39115;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39100),hatti$views$table$render_options_$_iter__39097(cljs.core.chunk_rest(s__39098__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39100),null);
}
} else {
var vec__39112 = cljs.core.first(s__39098__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39112,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39112,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__39112,k,v,s__39098__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__39112,k,v,s__39098__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__39097(cljs.core.rest(s__39098__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39117 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39117 = (function (_,owner,meta39118){
this._ = _;
this.owner = owner;
this.meta39118 = meta39118;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39117.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39119,meta39118__$1){
var self__ = this;
var _39119__$1 = this;
return (new hatti.views.table.t_hatti$views$table39117(self__._,self__.owner,meta39118__$1));
});

hatti.views.table.t_hatti$views$table39117.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39119){
var self__ = this;
var _39119__$1 = this;
return self__.meta39118;
});

hatti.views.table.t_hatti$views$table39117.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table39117.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field_DASH_key,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table39117.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39117.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__39120){
var self__ = this;
var map__39121 = p__39120;
var map__39121__$1 = ((((!((map__39121 == null)))?((((map__39121.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39121.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39121):map__39121);
var field_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39121__$1,cljs.core.cst$kw$field_DASH_key);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39121__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__39123 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39123__$1 = ((((!((map__39123 == null)))?((((map__39123.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39123.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39123):map__39123);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39123__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var map__39124 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__39124__$1 = ((((!((map__39124 == null)))?((((map__39124.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39124.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39124):map__39124);
var submission_review_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39124__$1,cljs.core.cst$kw$submission_DASH_review_QMARK_);
var colset_BANG_ = ((function (options,map__39123,map__39123__$1,flat_form,new_language,map__39124,map__39124__$1,submission_review_QMARK_,___$2,map__39121,map__39121__$1,field_key,language){
return (function (p1__39116_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(flat_form,cljs.core.array_seq([cljs.core.cst$kw$get_DASH_label_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__39116_SHARP_),cljs.core.cst$kw$language,new_language,cljs.core.cst$kw$submission_DASH_review_QMARK_,submission_review_QMARK_,cljs.core.cst$kw$owner,self__.owner], 0))], null));
});})(options,map__39123,map__39123__$1,flat_form,new_language,map__39124,map__39124__$1,submission_review_QMARK_,___$2,map__39121,map__39121__$1,field_key,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(field_key);
} else {
}

var G__39135 = ({"className": "label-changer"});
var G__39136 = (function (){var G__39138 = ({"className": "label-changer-label"});
var G__39139 = "Show:";
return React.DOM.span(G__39138,G__39139);
})();
var G__39137 = (function (){var G__39140 = ({"id": "header-display-dropdown", "className": "drop-hover"});
var G__39141 = (function (){var attrs39129 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(field_key) : options.call(null,field_key));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs39129))?sablono.interpreter.attributes(attrs39129):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39129))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__39143 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39143);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39129),(function (){var G__39144 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39144);
})()], null))));
})();
var G__39142 = (function (){var attrs39134 = hatti.views.table.render_options(options,self__.owner,colset_BANG_);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.ul,((cljs.core.map_QMARK_(attrs39134))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs39134], 0))):({"className": "submenu no-dot"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39134))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39134)], null))));
})();
return React.DOM.div(G__39140,G__39141,G__39142);
})();
return React.DOM.div(G__39135,G__39136,G__39137);
});

hatti.views.table.t_hatti$views$table39117.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39118], null);
});

hatti.views.table.t_hatti$views$table39117.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39117.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39117";

hatti.views.table.t_hatti$views$table39117.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39117");
});

hatti.views.table.__GT_t_hatti$views$table39117 = (function hatti$views$table$__GT_t_hatti$views$table39117(___$1,owner__$1,meta39118){
return (new hatti.views.table.t_hatti$views$table39117(___$1,owner__$1,meta39118));
});

}

return (new hatti.views.table.t_hatti$views$table39117(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__13879__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13879__auto__,query){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto__,query){
return (function (state_39187){
var state_val_39188 = (state_39187[(1)]);
if((state_val_39188 === (1))){
var inst_39173 = cljs.core.async.timeout((150));
var state_39187__$1 = state_39187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39187__$1,(2),inst_39173);
} else {
if((state_val_39188 === (2))){
var inst_39175 = (state_39187[(2)]);
var inst_39176 = input.value;
var inst_39177 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_39176);
var state_39187__$1 = (function (){var statearr_39189 = state_39187;
(statearr_39189[(7)] = inst_39175);

return statearr_39189;
})();
if(inst_39177){
var statearr_39190_39201 = state_39187__$1;
(statearr_39190_39201[(1)] = (3));

} else {
var statearr_39191_39202 = state_39187__$1;
(statearr_39191_39202[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39188 === (3))){
var inst_39179 = [query_event_key];
var inst_39180 = [query];
var inst_39181 = cljs.core.PersistentHashMap.fromArrays(inst_39179,inst_39180);
var inst_39182 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_39181);
var state_39187__$1 = state_39187;
var statearr_39192_39203 = state_39187__$1;
(statearr_39192_39203[(2)] = inst_39182);

(statearr_39192_39203[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39188 === (4))){
var state_39187__$1 = state_39187;
var statearr_39193_39204 = state_39187__$1;
(statearr_39193_39204[(2)] = null);

(statearr_39193_39204[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39188 === (5))){
var inst_39185 = (state_39187[(2)]);
var state_39187__$1 = state_39187;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39187__$1,inst_39185);
} else {
return null;
}
}
}
}
}
});})(c__13879__auto__,query))
;
return ((function (switch__13767__auto__,c__13879__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__13768__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__13768__auto____0 = (function (){
var statearr_39197 = [null,null,null,null,null,null,null,null];
(statearr_39197[(0)] = hatti$views$table$delayed_search_$_state_machine__13768__auto__);

(statearr_39197[(1)] = (1));

return statearr_39197;
});
var hatti$views$table$delayed_search_$_state_machine__13768__auto____1 = (function (state_39187){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__(state_39187);
if(cljs.core.keyword_identical_QMARK_(result__13770__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e39198){if((e39198 instanceof Object)){
var ex__13771__auto__ = e39198;
var statearr_39199_39205 = state_39187;
(statearr_39199_39205[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39187);

return cljs.core.cst$kw$recur;
} else {
throw e39198;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13769__auto__,cljs.core.cst$kw$recur)){
var G__39206 = state_39187;
state_39187 = G__39206;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__13768__auto__ = function(state_39187){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__13768__auto____1.call(this,state_39187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__13768__auto____0;
hatti$views$table$delayed_search_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__13768__auto____1;
return hatti$views$table$delayed_search_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto__,query))
})();
var state__13881__auto__ = (function (){var statearr_39200 = (f__13880__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13880__auto__.cljs$core$IFn$_invoke$arity$0() : f__13880__auto__.call(null));
(statearr_39200[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto__);

return statearr_39200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13881__auto__);
});})(c__13879__auto__,query))
);

return c__13879__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39208 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39208 = (function (_,owner,meta39209){
this._ = _;
this.owner = owner;
this.meta39209 = meta39209;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39208.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39210,meta39209__$1){
var self__ = this;
var _39210__$1 = this;
return (new hatti.views.table.t_hatti$views$table39208(self__._,self__.owner,meta39209__$1));
});

hatti.views.table.t_hatti$views$table39208.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39210){
var self__ = this;
var _39210__$1 = this;
return self__.meta39209;
});

hatti.views.table.t_hatti$views$table39208.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39208.prototype.om$core$IRender$render$arity$1 = (function (this__18222__auto__){
var self__ = this;
var this__18222__auto____$1 = this;
var G__39213 = ({"className": "table-search"});
var G__39214 = (function (){var G__39216 = ({"className": "fa fa-search"});
return React.DOM.i(G__39216);
})();
var G__39215 = (function (){var G__39217 = ({"type": "text", "placeholder": "Search", "onChange": ((function (G__39213,G__39214,this__18222__auto____$1){
return (function (p1__39207_SHARP_){
return hatti.views.table.delayed_search(p1__39207_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__39213,G__39214,this__18222__auto____$1))
});
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__39217) : sablono.interpreter.input.call(null,G__39217));
})();
return React.DOM.div(G__39213,G__39214,G__39215);
});

hatti.views.table.t_hatti$views$table39208.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39209], null);
});

hatti.views.table.t_hatti$views$table39208.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39208.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39208";

hatti.views.table.t_hatti$views$table39208.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39208");
});

hatti.views.table.__GT_t_hatti$views$table39208 = (function hatti$views$table$__GT_t_hatti$views$table39208(___$1,owner__$1,meta39209){
return (new hatti.views.table.t_hatti$views$table39208(___$1,owner__$1,meta39209));
});

}

return (new hatti.views.table.t_hatti$views$table39208(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table39218 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39218 = (function (cursor,owner,meta39219){
this.cursor = cursor;
this.owner = owner;
this.meta39219 = meta39219;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39218.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39220,meta39219__$1){
var self__ = this;
var _39220__$1 = this;
return (new hatti.views.table.t_hatti$views$table39218(self__.cursor,self__.owner,meta39219__$1));
});

hatti.views.table.t_hatti$views$table39218.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39220){
var self__ = this;
var _39220__$1 = this;
return self__.meta39219;
});

hatti.views.table.t_hatti$views$table39218.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39218.prototype.om$core$IRender$render$arity$1 = (function (this__18222__auto__){
var self__ = this;
var this__18222__auto____$1 = this;
var G__39223 = ({"className": "topbar"});
var G__39224 = (function (){var G__39228 = ({"id": hatti.views.table.pager_id});
return React.DOM.div(G__39228);
})();
var G__39225 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,self__.cursor));
var G__39226 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.cursor));
var G__39227 = (function (){var G__39229 = ({"style": ({"clear": "both"})});
return React.DOM.div(G__39229);
})();
return React.DOM.div(G__39223,G__39224,G__39225,G__39226,G__39227);
});

hatti.views.table.t_hatti$views$table39218.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39219], null);
});

hatti.views.table.t_hatti$views$table39218.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39218.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39218";

hatti.views.table.t_hatti$views$table39218.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39218");
});

hatti.views.table.__GT_t_hatti$views$table39218 = (function hatti$views$table$__GT_t_hatti$views$table39218(cursor__$1,owner__$1,meta39219){
return (new hatti.views.table.t_hatti$views$table39218(cursor__$1,owner__$1,meta39219));
});

}

return (new hatti.views.table.t_hatti$views$table39218(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq(data)){
var map__39235 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__39235__$1 = ((((!((map__39235 == null)))?((((map__39235.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39235.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39235):map__39235);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39235__$1,cljs.core.cst$kw$flat_DASH_form);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__39236 = hatti.views.table.sg_init(data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39236,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39236,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".table-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$table_DASH_view_DASH_height,hatti.views.table.get_table_view_height());
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$resize_DASH_handler,resize_handler);
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__39241,owner,p__39242){
var map__39243 = p__39241;
var map__39243__$1 = ((((!((map__39243 == null)))?((((map__39243.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39243.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39243):map__39243);
var cursor = map__39243__$1;
var map__39244 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39243__$1,cljs.core.cst$kw$views);
var map__39244__$1 = ((((!((map__39244 == null)))?((((map__39244.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39244.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39244):map__39244);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39244__$1,cljs.core.cst$kw$active);
var map__39245 = p__39242;
var map__39245__$1 = ((((!((map__39245 == null)))?((((map__39245.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39245.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39245):map__39245);
var opts = map__39245__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39245__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

var active_QMARK_ = chimera.seq.in_QMARK_(active,cljs.core.cst$kw$table);
if(typeof hatti.views.table.t_hatti$views$table39249 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39249 = (function (p__39241,owner,map__39244,map__39243,active_QMARK_,p__39242,slick_grid_event_handlers,cursor,map__39245,active,opts,meta39250){
this.p__39241 = p__39241;
this.owner = owner;
this.map__39244 = map__39244;
this.map__39243 = map__39243;
this.active_QMARK_ = active_QMARK_;
this.p__39242 = p__39242;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.cursor = cursor;
this.map__39245 = map__39245;
this.active = active;
this.opts = opts;
this.meta39250 = meta39250;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39249.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers){
return (function (_39251,meta39250__$1){
var self__ = this;
var _39251__$1 = this;
return (new hatti.views.table.t_hatti$views$table39249(self__.p__39241,self__.owner,self__.map__39244,self__.map__39243,self__.active_QMARK_,self__.p__39242,self__.slick_grid_event_handlers,self__.cursor,self__.map__39245,self__.active,self__.opts,meta39250__$1));
});})(active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39249.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers){
return (function (_39251){
var self__ = this;
var _39251__$1 = this;
return self__.meta39250;
});})(active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39249.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39249.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers){
return (function (_,p__39252){
var self__ = this;
var map__39253 = p__39252;
var map__39253__$1 = ((((!((map__39253 == null)))?((((map__39253.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39253.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39253):map__39253);
var table_view_height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39253__$1,cljs.core.cst$kw$table_DASH_view_DASH_height);
var ___$1 = this;
var map__39255 = self__.cursor;
var map__39255__$1 = ((((!((map__39255 == null)))?((((map__39255.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39255.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39255):map__39255);
var map__39256 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39255__$1,cljs.core.cst$kw$table_DASH_page);
var map__39256__$1 = ((((!((map__39256 == null)))?((((map__39256.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39256.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39256):map__39256);
var submission_clicked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39256__$1,cljs.core.cst$kw$submission_DASH_clicked);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39255__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39255__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__39257 = dataset_info;
var map__39257__$1 = ((((!((map__39257 == null)))?((((map__39257.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39257.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39257):map__39257);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39257__$1,cljs.core.cst$kw$num_of_submissions);
var no_data_QMARK_ = cljs.core.empty_QMARK_(data);
var with_info = ((function (map__39255,map__39255__$1,map__39256,map__39256__$1,submission_clicked,data,dataset_info,map__39257,map__39257__$1,num_of_submissions,no_data_QMARK_,___$1,map__39253,map__39253__$1,table_view_height,active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers){
return (function (p1__39240_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.cursor,p1__39240_SHARP_], 0));
});})(map__39255,map__39255__$1,map__39256,map__39256__$1,submission_clicked,data,dataset_info,map__39257,map__39257__$1,num_of_submissions,no_data_QMARK_,___$1,map__39253,map__39253__$1,table_view_height,active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers))
;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(hatti.shared.app_state,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$table_DASH_view_DASH_height], null),(((document.querySelector(".table-page") == null))?null:hatti.views.table.get_table_view_height()));

if(cljs.core.truth_(self__.active_QMARK_)){
var G__39261 = ({"style": ({"overflow": "initial"}), "className": "table-view"});
var G__39262 = sablono.interpreter.interpret((cljs.core.truth_(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null)):null));
var G__39263 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.cursor));
var G__39264 = (function (){var G__39265 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__39266 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__39271 = ({"className": "alert alert-warning"});
var G__39272 = "No data";
return React.DOM.p(G__39271,G__39272);
})():(function (){var G__39273 = null;
var G__39274 = (function (){var G__39276 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__39276);
})();
var G__39275 = "Loading...";
return React.DOM.span(G__39273,G__39274,G__39275);
})());
return React.DOM.div(G__39265,G__39266);
})();
return React.DOM.div(G__39261,G__39262,G__39263,G__39264);
} else {
return null;
}
});})(active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39249.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table39249.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler(self__.owner);

var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39277 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39277,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39277,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39249.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table39249.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$resize_DASH_handler));
});})(active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39249.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table39249.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__39280 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39280__$1 = ((((!((map__39280 == null)))?((((map__39280.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39280.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39280):map__39280);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39280__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39280__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39282 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39282,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39282,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js((function (){var G__39285 = new_data;
if(cljs.core.truth_(cljs.core.cst$kw$submission_DASH_review_QMARK_.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))))){
return hatti.views.table.replace_review_num_status_with_text_status(G__39285);
} else {
return G__39285;
}
})()),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39249.getBasis = ((function (active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__39241,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__39244,cljs.core.cst$sym$map__39243,cljs.core.cst$sym$active_QMARK_,cljs.core.cst$sym$p__39242,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$cursor,cljs.core.cst$sym$map__39245,cljs.core.cst$sym$active,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta39250], null);
});})(active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39249.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39249.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39249";

hatti.views.table.t_hatti$views$table39249.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39249");
});})(active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table39249 = ((function (active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table39249(p__39241__$1,owner__$1,map__39244__$2,map__39243__$2,active_QMARK___$1,p__39242__$1,slick_grid_event_handlers__$1,cursor__$1,map__39245__$2,active__$1,opts__$1,meta39250){
return (new hatti.views.table.t_hatti$views$table39249(p__39241__$1,owner__$1,map__39244__$2,map__39243__$2,active_QMARK___$1,p__39242__$1,slick_grid_event_handlers__$1,cursor__$1,map__39245__$2,active__$1,opts__$1,meta39250));
});})(active_QMARK_,map__39243,map__39243__$1,cursor,map__39244,map__39244__$1,active,map__39245,map__39245__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table39249(p__39241,owner,map__39244__$1,map__39243__$1,active_QMARK_,p__39242,slick_grid_event_handlers,cursor,map__39245__$1,active,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
