// Compiled by ClojureScript 1.9.229 {}
goog.provide('chimera.string');
goog.require('cljs.core');
goog.require('chimera.core');
goog.require('clojure.string');
goog.require('cljs.pprint');
chimera.string.email_regex = /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,6}$/i;
chimera.string.twitter_username_regex = /^[A-Za-z0-9_]*$/;
chimera.string.domain_name_regex = /([a-z0-9|-]+\.)*[a-z0-9|-]+\.[a-z]+/;
chimera.string.truncate_if_longer_than = (50);
chimera.string.ellipsis_start = (36);
chimera.string.ellipsis_stop_from_end = (12);
chimera.string.chars__GT_entities = new cljs.core.PersistentArrayMap(null, 5, ["<","&lt;",">","&gt;","&","&amp;","\"","&quot;","'","&#39;"], null);
chimera.string.vowel_QMARK_ = cljs.core.set.call(null,"aeiou");
chimera.string.parenthesize_suffix = (function chimera$string$parenthesize_suffix(prefix,suffix){
return [cljs.core.str(prefix),cljs.core.str(" ("),cljs.core.str(suffix),cljs.core.str(")")].join('');
});
/**
 * Shorten a string to a certain length with middle ellipsis.
 */
chimera.string.truncate_with_ellipsis = (function chimera$string$truncate_with_ellipsis(s){
if((cljs.core.count.call(null,s) > chimera.string.truncate_if_longer_than)){
var end_start = (cljs.core.count.call(null,s) - chimera.string.ellipsis_stop_from_end);
return [cljs.core.str(cljs.core.subs.call(null,s,(0),chimera.string.ellipsis_start)),cljs.core.str("..."),cljs.core.str(cljs.core.subs.call(null,s,end_start))].join('');
} else {
return s;
}
});
/**
 * Return the first character of a string capitalized.
 */
chimera.string.first_cap = (function chimera$string$first_cap(s){
return clojure.string.capitalize.call(null,[cljs.core.str(cljs.core.first.call(null,s))].join(''));
});
/**
 * True if `s` is an email address.
 */
chimera.string.is_email_QMARK_ = (function chimera$string$is_email_QMARK_(s){
return cljs.core.first.call(null,s.match(chimera.string.email_regex));
});
/**
 * True if `s` is a valid twitter username
 */
chimera.string.is_twitter_username_QMARK_ = (function chimera$string$is_twitter_username_QMARK_(s){
return cljs.core.first.call(null,s.match(chimera.string.twitter_username_regex));
});
/**
 * Wrap the count of a collection in parens and postfix.
 */
chimera.string.postfix_paren_count = (function chimera$string$postfix_paren_count(prefix,collection){
return chimera.string.parenthesize_suffix.call(null,prefix,cljs.core.count.call(null,collection));
});
/**
 * True if `s` ends with the passed suffix.
 */
chimera.string.ends_with_QMARK_ = (function chimera$string$ends_with_QMARK_(s,suffix){
var offset = (cljs.core.count.call(null,s) - cljs.core.count.call(null,suffix));
return ((offset >= (0))) && (cljs.core._EQ_.call(null,suffix,cljs.core.subs.call(null,s,offset)));
});
/**
 * Serialize a Clojure map to JavaScript string map.
 */
chimera.string.map__GT_js_string_map = (function chimera$string$map__GT_js_string_map(m){
return clojure.string.join.call(null,cljs.core.flatten.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["{",cljs.core.interpose.call(null,",",(function (){var iter__7189__auto__ = (function chimera$string$map__GT_js_string_map_$_iter__16796(s__16797){
return (new cljs.core.LazySeq(null,(function (){
var s__16797__$1 = s__16797;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__16797__$1);
if(temp__4657__auto__){
var s__16797__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16797__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__16797__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__16799 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__16798 = (0);
while(true){
if((i__16798 < size__7188__auto__)){
var vec__16806 = cljs.core._nth.call(null,c__7187__auto__,i__16798);
var k = cljs.core.nth.call(null,vec__16806,(0),null);
var v = cljs.core.nth.call(null,vec__16806,(1),null);
cljs.core.chunk_append.call(null,b__16799,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"",cljs.core.name.call(null,k),"\":\"",v,"\""], null));

var G__16812 = (i__16798 + (1));
i__16798 = G__16812;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16799),chimera$string$map__GT_js_string_map_$_iter__16796.call(null,cljs.core.chunk_rest.call(null,s__16797__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16799),null);
}
} else {
var vec__16809 = cljs.core.first.call(null,s__16797__$2);
var k = cljs.core.nth.call(null,vec__16809,(0),null);
var v = cljs.core.nth.call(null,vec__16809,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"",cljs.core.name.call(null,k),"\":\"",v,"\""], null),chimera$string$map__GT_js_string_map_$_iter__16796.call(null,cljs.core.rest.call(null,s__16797__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,m);
})()),"}"], null)));
});
/**
 * True if the first letter of `s` is a vowel.
 */
chimera.string.begins_with_vowel_QMARK_ = (function chimera$string$begins_with_vowel_QMARK_(s){
return chimera.string.vowel_QMARK_.call(null,cljs.core.first.call(null,clojure.string.lower_case.call(null,cljs.core.first.call(null,s))));
});
/**
 * If `s` is a string and equal to 'false' in lower case return false,
 * otherwise return `s`.
 */
chimera.string.false_str__GT_false = (function chimera$string$false_str__GT_false(s){
if(cljs.core._EQ_.call(null,(function (){var and__6397__auto__ = typeof s === 'string';
if(and__6397__auto__){
return clojure.string.lower_case.call(null,s);
} else {
return and__6397__auto__;
}
})(),"false")){
return false;
} else {
return s;
}
});
/**
 * Render a JSON error as a string for the user.
 */
chimera.string.error_json__GT_str = (function chimera$string$error_json__GT_str(json){
return clojure.string.join.call(null,"<br/>",(function (){var iter__7189__auto__ = (function chimera$string$error_json__GT_str_$_iter__16833(s__16834){
return (new cljs.core.LazySeq(null,(function (){
var s__16834__$1 = s__16834;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__16834__$1);
if(temp__4657__auto__){
var s__16834__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16834__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__16834__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__16836 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__16835 = (0);
while(true){
if((i__16835 < size__7188__auto__)){
var vec__16845 = cljs.core._nth.call(null,c__7187__auto__,i__16835);
var k = cljs.core.nth.call(null,vec__16845,(0),null);
var v = cljs.core.nth.call(null,vec__16845,(1),null);
var key = clojure.string.capitalize.call(null,cljs.core.name.call(null,k));
var value = (function (){var G__16848 = v;
if(cljs.core.vector_QMARK_.call(null,v)){
return clojure.string.join.call(null," ",G__16848);
} else {
return G__16848;
}
})();
cljs.core.chunk_append.call(null,b__16836,[cljs.core.str(key),cljs.core.str(": "),cljs.core.str(value)].join(''));

var G__16853 = (i__16835 + (1));
i__16835 = G__16853;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16836),chimera$string$error_json__GT_str_$_iter__16833.call(null,cljs.core.chunk_rest.call(null,s__16834__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16836),null);
}
} else {
var vec__16849 = cljs.core.first.call(null,s__16834__$2);
var k = cljs.core.nth.call(null,vec__16849,(0),null);
var v = cljs.core.nth.call(null,vec__16849,(1),null);
var key = clojure.string.capitalize.call(null,cljs.core.name.call(null,k));
var value = (function (){var G__16852 = v;
if(cljs.core.vector_QMARK_.call(null,v)){
return clojure.string.join.call(null," ",G__16852);
} else {
return G__16852;
}
})();
return cljs.core.cons.call(null,[cljs.core.str(key),cljs.core.str(": "),cljs.core.str(value)].join(''),chimera$string$error_json__GT_str_$_iter__16833.call(null,cljs.core.rest.call(null,s__16834__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,json);
})());
});
/**
 * Build an unescaped string.
 */
chimera.string.unescape = (function chimera$string$unescape(s){
if(typeof s === 'string'){
return cljs.core.reduce.call(null,(function (r,p__16858){
var vec__16859 = p__16858;
var k = cljs.core.nth.call(null,vec__16859,(0),null);
var v = cljs.core.nth.call(null,vec__16859,(1),null);
return clojure.string.replace.call(null,r,cljs.core.re_pattern.call(null,v),[cljs.core.str(k)].join(''));
}),s,chimera.string.chars__GT_entities);
} else {
return s;
}
});
/**
 * Checks if a variable is null
 */
chimera.string.is_null_QMARK_ = (function chimera$string$is_null_QMARK_(s){
return cljs.core._EQ_.call(null,"null",s);
});
chimera.string.is_not_null_QMARK_ = cljs.core.complement.call(null,chimera.string.is_null_QMARK_);
chimera.string.safe_lower_case = (function chimera$string$safe_lower_case(str){
if(typeof str === 'string'){
return clojure.string.lower_case.call(null,str);
} else {
return null;
}
});
/**
 * True if substring is a substring of `s`
 */
chimera.string.substring_QMARK_ = (function chimera$string$substring_QMARK_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___16868 = arguments.length;
var i__7485__auto___16869 = (0);
while(true){
if((i__7485__auto___16869 < len__7484__auto___16868)){
args__7491__auto__.push((arguments[i__7485__auto___16869]));

var G__16870 = (i__7485__auto___16869 + (1));
i__7485__auto___16869 = G__16870;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,s,p__16865){
var map__16866 = p__16865;
var map__16866__$1 = ((((!((map__16866 == null)))?((((map__16866.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16866.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16866):map__16866);
var case_sensitive_QMARK_ = cljs.core.get.call(null,map__16866__$1,new cljs.core.Keyword(null,"case-sensitive?","case-sensitive?",-2133754107),true);
if(cljs.core.truth_((function (){var or__6409__auto__ = cljs.core.empty_QMARK_.call(null,s);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return chimera.string.is_null_QMARK_.call(null,s);
}
})())){
return false;
} else {
return chimera.core.not_nil_QMARK_.call(null,cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str((cljs.core.truth_(case_sensitive_QMARK_)?null:"(?i)")),cljs.core.str(substring)].join('')),s));
}
});

chimera.string.substring_QMARK_.cljs$lang$maxFixedArity = (2);

chimera.string.substring_QMARK_.cljs$lang$applyTo = (function (seq16862){
var G__16863 = cljs.core.first.call(null,seq16862);
var seq16862__$1 = cljs.core.next.call(null,seq16862);
var G__16864 = cljs.core.first.call(null,seq16862__$1);
var seq16862__$2 = cljs.core.next.call(null,seq16862__$1);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__16863,G__16864,seq16862__$2);
});

/**
 * Insert a comma into numbers in thousands and higher
 */
chimera.string.humanize_number = (function chimera$string$humanize_number(n){
return cljs.pprint.cl_format.call(null,null,"~:d",n);
});
/**
 * Escape for types. Replaces characters in the string with this base on
 *   chars->entities map.
 */
chimera.string.escape_for_type = (function chimera$string$escape_for_type(x){
if((x == null)){
return "null";
} else {
if(typeof x === 'string'){
return clojure.string.escape.call(null,x,chimera.string.chars__GT_entities);
} else {
return x;

}
}
});
