// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.dataview');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.views.photos');
goog.require('sablono.core');
goog.require('hatti.views.user_guide');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.views.map');
goog.require('hatti.views.chart');
goog.require('hatti.views.report_view');
goog.require('hatti.shared');
goog.require('chimera.metrics');
goog.require('hatti.views.saved_charts');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('hatti.views.settings');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('hatti.views.overview');
goog.require('hatti.views.table');
hatti.views.dataview.dataview_map = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"user-guide","user-guide",774875009),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.Keyword(null,"report-view","report-view",-1592707414),new cljs.core.Keyword(null,"saved-charts","saved-charts",2129251691),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"overview","overview",-435037267),new cljs.core.Keyword(null,"chart","chart",1173225425),new cljs.core.Keyword(null,"photos","photos",11691538),new cljs.core.Keyword(null,"map","map",1371690461)],[new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"user-guide","user-guide",774875009),new cljs.core.Keyword(null,"label","label",1718410804),"User Guide",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.user_guide_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.Keyword(null,"label","label",1718410804),"Table",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.table_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"report-view","report-view",-1592707414),new cljs.core.Keyword(null,"label","label",1718410804),"Reports",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.report_view_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"saved-charts","saved-charts",2129251691),new cljs.core.Keyword(null,"label","label",1718410804),"Dashboard",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.saved_charts_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"label","label",1718410804),"Settings",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.settings_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"overview","overview",-435037267),new cljs.core.Keyword(null,"label","label",1718410804),"Overview",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.overview_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"chart","chart",1173225425),new cljs.core.Keyword(null,"label","label",1718410804),"Charts",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.chart_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"photos","photos",11691538),new cljs.core.Keyword(null,"label","label",1718410804),"Photos",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.photos_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Keyword(null,"label","label",1718410804),"Map",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.map_page], null)]);
/**
 * Initial Dataview State
 */
hatti.views.dataview.default_dataviews = (function hatti$views$dataview$default_dataviews(){
return cljs.core.atom.call(null,hatti.views.dataview.dataview_map);
});
hatti.views.dataview.view_state = hatti.views.dataview.default_dataviews.call(null);
/**
 * Build and set the tooltips for inactive views based on why they are
 * inactive.
 */
hatti.views.dataview.view__GT_inactive_tab = (function hatti$views$dataview$view__GT_inactive_tab(view,label,is_encrypted_QMARK_,not_within_pricing_limits_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.inactive","a.inactive",1325252702),[cljs.core.str(label),cljs.core.str(" ")].join(''),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tooltip","span.tooltip",-934616418),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info.tooltip","span.tip-info.tooltip",498786549),(cljs.core.truth_(is_encrypted_QMARK_)?"This tab is disabled because this form is encrypted.":(cljs.core.truth_(not_within_pricing_limits_QMARK_)?"This tab is disabled because you are over the pricing limits.":(function (){var pred__26111 = cljs.core._EQ_;
var expr__26112 = view;
if(cljs.core.truth_(pred__26111.call(null,new cljs.core.Keyword(null,"map","map",1371690461),expr__26112))){
return [cljs.core.str("The Map tab is disabled because this form "),cljs.core.str("has no location questions.")].join('');
} else {
if(cljs.core.truth_(pred__26111.call(null,new cljs.core.Keyword(null,"photos","photos",11691538),expr__26112))){
return [cljs.core.str("The Photos tab is disabled because this form has no "),cljs.core.str("photo questions.")].join('');
} else {
if(cljs.core.truth_(pred__26111.call(null,new cljs.core.Keyword(null,"table","table",-564943036),expr__26112))){
return [cljs.core.str("The table tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_(pred__26111.call(null,new cljs.core.Keyword(null,"chart","chart",1173225425),expr__26112))){
return [cljs.core.str("The charts tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_(pred__26111.call(null,new cljs.core.Keyword(null,"saved-charts","saved-charts",2129251691),expr__26112))){
return [cljs.core.str("The dashboards tab is disabled because "),cljs.core.str("you do not have permission to view it.")].join('');
} else {
return "This tab is disabled.";
}
}
}
}
}
})()
))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-question","span.tip-question",1059090371),"?"], null)], null)], null);
});
cljs.core._add_method.call(null,hatti.views.dataview_actions,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.dataview.t_hatti$views$dataview26114 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview26114 = (function (cursor,owner,meta26115){
this.cursor = cursor;
this.owner = owner;
this.meta26115 = meta26115;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview26114.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26116,meta26115__$1){
var self__ = this;
var _26116__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview26114(self__.cursor,self__.owner,meta26115__$1));
});

hatti.views.dataview.t_hatti$views$dataview26114.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26116){
var self__ = this;
var _26116__$1 = this;
return self__.meta26115;
});

hatti.views.dataview.t_hatti$views$dataview26114.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview26114.prototype.om$core$IRender$render$arity$1 = (function (this__18222__auto__){
var self__ = this;
var this__18222__auto____$1 = this;
return null;
});

hatti.views.dataview.t_hatti$views$dataview26114.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta26115","meta26115",1264238889,null)], null);
});

hatti.views.dataview.t_hatti$views$dataview26114.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview26114.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview26114";

hatti.views.dataview.t_hatti$views$dataview26114.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview26114");
});

hatti.views.dataview.__GT_t_hatti$views$dataview26114 = (function hatti$views$dataview$__GT_t_hatti$views$dataview26114(cursor__$1,owner__$1,meta26115){
return (new hatti.views.dataview.t_hatti$views$dataview26114(cursor__$1,owner__$1,meta26115));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview26114(cursor,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.dataview_infobar,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__26117,owner){
var map__26118 = p__26117;
var map__26118__$1 = ((((!((map__26118 == null)))?((((map__26118.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26118.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26118):map__26118);
var dataset_info = cljs.core.get.call(null,map__26118__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var status = cljs.core.get.call(null,map__26118__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
if(typeof hatti.views.dataview.t_hatti$views$dataview26120 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview26120 = (function (p__26117,owner,map__26118,dataset_info,status,meta26121){
this.p__26117 = p__26117;
this.owner = owner;
this.map__26118 = map__26118;
this.dataset_info = dataset_info;
this.status = status;
this.meta26121 = meta26121;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview26120.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__26118,map__26118__$1,dataset_info,status){
return (function (_26122,meta26121__$1){
var self__ = this;
var _26122__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview26120(self__.p__26117,self__.owner,self__.map__26118,self__.dataset_info,self__.status,meta26121__$1));
});})(map__26118,map__26118__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview26120.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__26118,map__26118__$1,dataset_info,status){
return (function (_26122){
var self__ = this;
var _26122__$1 = this;
return self__.meta26121;
});})(map__26118,map__26118__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview26120.prototype.om$core$IWillMount$ = true;

hatti.views.dataview.t_hatti$views$dataview26120.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__26118,map__26118__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
return hatti.shared.maybe_merge_languages_BANG_.call(null,om.core.get_shared.call(null,self__.owner,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211)));
});})(map__26118,map__26118__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview26120.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview26120.prototype.om$core$IRender$render$arity$1 = ((function (map__26118,map__26118__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.call(null,self__.owner,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var map__26123 = self__.dataset_info;
var map__26123__$1 = ((((!((map__26123 == null)))?((((map__26123.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26123.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26123):map__26123);
var num_of_submissions = cljs.core.get.call(null,map__26123__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var formid = cljs.core.get.call(null,map__26123__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var map__26124 = self__.status;
var map__26124__$1 = ((((!((map__26124 == null)))?((((map__26124.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26124.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26124):map__26124);
var loading_QMARK_ = cljs.core.get.call(null,map__26124__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var total_records = cljs.core.get.call(null,map__26124__$1,new cljs.core.Keyword(null,"total-records","total-records",-1940276645));
return React.DOM.div(({"className": "right rec-summary rec-margin"}),(function (){var attrs26127 = (cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_.call(null,form))?om.core.build.call(null,hatti.shared.language_selector,null):null);
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs26127))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),"language-selector"], null),attrs26127)):({"id": "language-selector"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs26127))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs26127)], null))));
})(),React.DOM.div(({"id": "data-status"}),(function (){var attrs26128 = (cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-spinner.fa-pulse","i.fa.fa-spinner.fa-pulse",869871146)], null):null);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs26128))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rec"], null)], null),attrs26128)):({"className": "rec"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs26128))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,hatti.utils.pluralize_number.call(null,num_of_submissions," Record"))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs26128),sablono.interpreter.interpret.call(null,hatti.utils.pluralize_number.call(null,num_of_submissions," Record"))], null))));
})()),React.DOM.div(({"className": "divider"})),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.dataview_actions,formid)));
});})(map__26118,map__26118__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview26120.getBasis = ((function (map__26118,map__26118__$1,dataset_info,status){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__26117","p__26117",1845257863,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"map__26118","map__26118",227234178,null),new cljs.core.Symbol(null,"dataset-info","dataset-info",443531964,null),new cljs.core.Symbol(null,"status","status",-357266886,null),new cljs.core.Symbol(null,"meta26121","meta26121",-582983074,null)], null);
});})(map__26118,map__26118__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview26120.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview26120.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview26120";

hatti.views.dataview.t_hatti$views$dataview26120.cljs$lang$ctorPrWriter = ((function (map__26118,map__26118__$1,dataset_info,status){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview26120");
});})(map__26118,map__26118__$1,dataset_info,status))
;

hatti.views.dataview.__GT_t_hatti$views$dataview26120 = ((function (map__26118,map__26118__$1,dataset_info,status){
return (function hatti$views$dataview$__GT_t_hatti$views$dataview26120(p__26117__$1,owner__$1,map__26118__$2,dataset_info__$1,status__$1,meta26121){
return (new hatti.views.dataview.t_hatti$views$dataview26120(p__26117__$1,owner__$1,map__26118__$2,dataset_info__$1,status__$1,meta26121));
});})(map__26118,map__26118__$1,dataset_info,status))
;

}

return (new hatti.views.dataview.t_hatti$views$dataview26120(p__26117,owner,map__26118__$1,dataset_info,status,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Strip off ampersand suffixes then switch to view if result is a valid view
 */
hatti.views.dataview.activate_view_BANG_ = (function hatti$views$dataview$activate_view_BANG_(view){
var view__$1 = cljs.core.keyword.call(null,(function (){var or__6409__auto__ = cljs.core.last.call(null,cljs.core.re_find.call(null,/(.*?)&/,view));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return view;
}
})());
var views = new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)));
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,views),view__$1)){
chimera.om.state.merge_into_app_state_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),view__$1], null));

return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"re-render","re-render",1133553258),view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_settings_view_BANG_ = (function hatti$views$dataview$activate_settings_view_BANG_(view,settings_section){
var view__$1 = cljs.core.keyword.call(null,view);
var settings_section__$1 = cljs.core.keyword.call(null,settings_section);
var views = new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)));
var settings_views = new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,settings_views),settings_section__$1)){
chimera.om.state.merge_into_app_state_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),view__$1], null));

chimera.om.state.merge_into_app_state_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"settings","settings",1556144875)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"active-tab","active-tab",1102432568),settings_section__$1], null));

return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"re-render","re-render",1133553258),view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_integrated_apps_view_BANG_ = (function hatti$views$dataview$activate_integrated_apps_view_BANG_(view,settings_section,app_type){
var view__$1 = cljs.core.keyword.call(null,view);
var settings_section__$1 = cljs.core.keyword.call(null,settings_section);
var settings_views = new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,settings_views),settings_section__$1)){
chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,((function (view__$1,settings_section__$1,settings_views){
return (function (app_state){
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"selected","selected",574897764)], null),view__$1),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"active-tab","active-tab",1102432568)], null),settings_section__$1),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"integrated-apps","integrated-apps",2094952610),new cljs.core.Keyword(null,"active-section","active-section",1090779410)], null),app_type);
});})(view__$1,settings_section__$1,settings_views))
);

if(cljs.core._EQ_.call(null,app_type,hatti.constants.google_sheets)){
chimera.om.state.merge_into_app_state_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"integrated-apps","integrated-apps",2094952610)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"add?","add?",1263018409),true], null));
} else {
}

return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"re-render","re-render",1133553258),view__$1], null));
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.tabbed_dataview,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner,opts){
if(typeof hatti.views.dataview.t_hatti$views$dataview26134 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview26134 = (function (app_state,owner,opts,meta26135){
this.app_state = app_state;
this.owner = owner;
this.opts = opts;
this.meta26135 = meta26135;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview26134.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26136,meta26135__$1){
var self__ = this;
var _26136__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview26134(self__.app_state,self__.owner,self__.opts,meta26135__$1));
});

hatti.views.dataview.t_hatti$views$dataview26134.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26136){
var self__ = this;
var _26136__$1 = this;
return self__.meta26135;
});

hatti.views.dataview.t_hatti$views$dataview26134.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview26134.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var map__26137 = self__.app_state;
var map__26137__$1 = ((((!((map__26137 == null)))?((((map__26137.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26137.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26137):map__26137);
var map__26138 = cljs.core.get.call(null,map__26137__$1,new cljs.core.Keyword(null,"views","views",1450155487));
var map__26138__$1 = ((((!((map__26138 == null)))?((((map__26138.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26138.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26138):map__26138);
var active = cljs.core.get.call(null,map__26138__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var disabled = cljs.core.get.call(null,map__26138__$1,new cljs.core.Keyword(null,"disabled","disabled",-1529784218));
var selected = cljs.core.get.call(null,map__26138__$1,new cljs.core.Keyword(null,"selected","selected",574897764));
var is_encrypted_QMARK_ = cljs.core.get.call(null,map__26137__$1,new cljs.core.Keyword(null,"is-encrypted?","is-encrypted?",-1801018432));
var is_within_pricing_limits_QMARK_ = cljs.core.get.call(null,map__26137__$1,new cljs.core.Keyword(null,"is-within-pricing-limits?","is-within-pricing-limits?",1028371005));
var view__GT_display = ((function (map__26137,map__26137__$1,map__26138,map__26138__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1){
return (function (p1__26131_SHARP_){
if(cljs.core._EQ_.call(null,selected,p1__26131_SHARP_)){
return "block";
} else {
return "none";
}
});})(map__26137,map__26137__$1,map__26138,map__26138__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1))
;
var view__GT_cls = ((function (map__26137,map__26137__$1,map__26138,map__26138__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1){
return (function (p1__26132_SHARP_){
if(cljs.core._EQ_.call(null,selected,p1__26132_SHARP_)){
return "clicked";
} else {
return null;
}
});})(map__26137,map__26137__$1,map__26138,map__26138__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1))
;
var dataviews = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,cljs.core.deref.call(null,hatti.views.dataview.view_state),new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(self__.app_state))));
var dv__GT_link = ((function (map__26137,map__26137__$1,map__26138,map__26138__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p__26141){
var map__26142 = p__26141;
var map__26142__$1 = ((((!((map__26142 == null)))?((((map__26142.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26142.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26142):map__26142);
var view = cljs.core.get.call(null,map__26142__$1,new cljs.core.Keyword(null,"view","view",1247994814));
var label = cljs.core.get.call(null,map__26142__$1,new cljs.core.Keyword(null,"label","label",1718410804));
if(cljs.core.truth_((function (){var and__6397__auto__ = cljs.core.some.call(null,((function (map__26142,map__26142__$1,view,label,map__26137,map__26137__$1,map__26138,map__26138__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p1__26133_SHARP_){
return cljs.core._EQ_.call(null,view,p1__26133_SHARP_);
});})(map__26142,map__26142__$1,view,label,map__26137,map__26137__$1,map__26138,map__26138__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
,active);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not.call(null,chimera.seq.in_QMARK_.call(null,disabled,view));
} else {
return and__6397__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),view__GT_cls.call(null,view),new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("#/"),cljs.core.str(cljs.core.name.call(null,view))].join('')], null),label], null);
} else {
return hatti.views.dataview.view__GT_inactive_tab.call(null,view,label,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_);
}
});})(map__26137,map__26137__$1,map__26138,map__26138__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
;
return React.DOM.div(({"className": "tab-container dataset-tabs"}),(function (){var attrs26144 = cljs.core.map.call(null,dv__GT_link,dataviews);
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs26144))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-bar"], null)], null),attrs26144)):({"className": "tab-bar"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs26144))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs26144),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null))));
})(),cljs.core.into_array.call(null,(function (){var iter__7189__auto__ = ((function (map__26137,map__26137__$1,map__26138,map__26138__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function hatti$views$dataview$iter__26145(s__26146){
return (new cljs.core.LazySeq(null,((function (map__26137,map__26137__$1,map__26138,map__26138__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function (){
var s__26146__$1 = s__26146;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__26146__$1);
if(temp__4657__auto__){
var s__26146__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__26146__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__26146__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__26148 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__26147 = (0);
while(true){
if((i__26147 < size__7188__auto__)){
var map__26153 = cljs.core._nth.call(null,c__7187__auto__,i__26147);
var map__26153__$1 = ((((!((map__26153 == null)))?((((map__26153.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26153.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26153):map__26153);
var component = cljs.core.get.call(null,map__26153__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var view = cljs.core.get.call(null,map__26153__$1,new cljs.core.Keyword(null,"view","view",1247994814));
var view_name = cljs.core.name.call(null,view);
cljs.core.chunk_append.call(null,b__26148,React.DOM.div(({"style": ({"height": new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"table-page","table-page",1974969102).cljs$core$IFn$_invoke$arity$1(self__.app_state)), "display": view__GT_display.call(null,view), "overflowX": (cljs.core.truth_(new cljs.core.Keyword(null,"prevent-scrolling-in-table-view?","prevent-scrolling-in-table-view?",2053296532).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"table-page","table-page",1974969102).cljs$core$IFn$_invoke$arity$1(self__.app_state)))?"hidden":"scroll")}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')}),sablono.interpreter.interpret.call(null,((cljs.core._EQ_.call(null,selected,view))?(function (){
chimera.metrics.send_event.call(null,new cljs.core.Keyword(null,"Dataview","Dataview",873494025),[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tab-content","div.tab-content",255119102),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.call(null,component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),self__.opts], null))], null);
})()
:null))));

var G__26157 = (i__26147 + (1));
i__26147 = G__26157;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26148),hatti$views$dataview$iter__26145.call(null,cljs.core.chunk_rest.call(null,s__26146__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26148),null);
}
} else {
var map__26155 = cljs.core.first.call(null,s__26146__$2);
var map__26155__$1 = ((((!((map__26155 == null)))?((((map__26155.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26155.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26155):map__26155);
var component = cljs.core.get.call(null,map__26155__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var view = cljs.core.get.call(null,map__26155__$1,new cljs.core.Keyword(null,"view","view",1247994814));
var view_name = cljs.core.name.call(null,view);
return cljs.core.cons.call(null,React.DOM.div(({"style": ({"height": new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"table-page","table-page",1974969102).cljs$core$IFn$_invoke$arity$1(self__.app_state)), "display": view__GT_display.call(null,view), "overflowX": (cljs.core.truth_(new cljs.core.Keyword(null,"prevent-scrolling-in-table-view?","prevent-scrolling-in-table-view?",2053296532).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"table-page","table-page",1974969102).cljs$core$IFn$_invoke$arity$1(self__.app_state)))?"hidden":"scroll")}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')}),sablono.interpreter.interpret.call(null,((cljs.core._EQ_.call(null,selected,view))?(function (){
chimera.metrics.send_event.call(null,new cljs.core.Keyword(null,"Dataview","Dataview",873494025),[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tab-content","div.tab-content",255119102),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.call(null,component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),self__.opts], null))], null);
})()
:null))),hatti$views$dataview$iter__26145.call(null,cljs.core.rest.call(null,s__26146__$2)));
}
} else {
return null;
}
break;
}
});})(map__26137,map__26137__$1,map__26138,map__26138__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
,null,null));
});})(map__26137,map__26137__$1,map__26138,map__26138__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
;
return iter__7189__auto__.call(null,dataviews);
})()));
});

hatti.views.dataview.t_hatti$views$dataview26134.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"meta26135","meta26135",668526036,null)], null);
});

hatti.views.dataview.t_hatti$views$dataview26134.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview26134.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview26134";

hatti.views.dataview.t_hatti$views$dataview26134.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview26134");
});

hatti.views.dataview.__GT_t_hatti$views$dataview26134 = (function hatti$views$dataview$__GT_t_hatti$views$dataview26134(app_state__$1,owner__$1,opts__$1,meta26135){
return (new hatti.views.dataview.t_hatti$views$dataview26134(app_state__$1,owner__$1,opts__$1,meta26135));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview26134(app_state,owner,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
