// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),true))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__25327_SHARP_){
if(typeof p1__25327_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__25327_SHARP_);
} else {
return p1__25327_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__25333){
var vec__25334 = p__25333;
var fname = cljs.core.nth.call(null,vec__25334,(0),null);
var answer = cljs.core.nth.call(null,vec__25334,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__25328_SHARP_){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),[cljs.core.str(p1__25328_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var media_count = (dataContext["_media_count"]);
var total_media = (dataContext["_total_media"]);
return hatti.ona.forms.format_answer.call(null,field,chimera.string.escape_for_type.call(null,clj_value),new cljs.core.Keyword(null,"language","language",-1591107564),language,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true,new cljs.core.Keyword(null,"field-key","field-key",313262601),field_key,new cljs.core.Keyword(null,"media-count","media-count",1579124405),media_count,new cljs.core.Keyword(null,"total-media","total-media",1031250100),total_media);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__25337 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__25337__$1 = ((((!((map__25337 == null)))?((((map__25337.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25337.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25337):map__25337);
var owner__$1 = cljs.core.get.call(null,map__25337__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__25337__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__25337__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = chimera.urls.last_url_param.call(null,owner__$1);
var project_id = chimera.urls.last_url_param.call(null,project);
var edit_link = chimera.urls.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input.delete-record","input.delete-record",-1708576930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip.middle-right","li.tooltip.middle-right",-548323211),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-eye","i.fa.fa-eye",-1428531423),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil","i.fa.fa-pencil",1547895857)], null)], null)], null)], null):null));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.select_unselect_all_records_id = "select-unselect-all-records";
hatti.views.table.select_unselect_all_records_element = [cljs.core.str("<input type=\"checkbox\" id=\""),cljs.core.str(hatti.views.table.select_unselect_all_records_id),cljs.core.str("\">")].join('');
hatti.views.table.delete_record_class = "delete-record";
hatti.views.table.submission_review_fields = (function hatti$views$table$submission_review_fields(cols){
var vec__25342 = cljs.core.split_at.call(null,(1),cols);
var actions = cljs.core.nth.call(null,vec__25342,(0),null);
var data = cljs.core.nth.call(null,vec__25342,(1),null);
return cljs.core.vec.call(null,cljs.core.flatten.call(null,cljs.core.conj.call(null,data,hatti.ona.forms.review_comment_field,hatti.ona.forms.review_status_field,actions)));
});
cljs.core._add_method.call(null,hatti.views.actions_column,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(100),hatti.views.table.select_unselect_all_records_element,hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
}));
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___25373 = arguments.length;
var i__7485__auto___25374 = (0);
while(true){
if((i__7485__auto___25374 < len__7484__auto___25373)){
args__7491__auto__.push((arguments[i__7485__auto___25374]));

var G__25375 = (i__7485__auto___25374 + (1));
i__7485__auto___25374 = G__25375;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__25348){
var map__25349 = p__25348;
var map__25349__$1 = ((((!((map__25349 == null)))?((((map__25349.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25349.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25349):map__25349);
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var submission_review_QMARK_ = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375));
var get_label_QMARK_ = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),true);
var language = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var owner = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var has_hxl_QMARK_ = chimera.core.any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,((function (map__25349,map__25349__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__25345_SHARP_){
return (new cljs.core.Keyword(null,"hxl","hxl",-849576989).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"instance","instance",-2121349050).cljs$core$IFn$_invoke$arity$1(p1__25345_SHARP_)) == null);
});})(map__25349,map__25349__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
,form));
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__25349,map__25349__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__25351(s__25352){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__25349,map__25349__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__25352__$1 = s__25352;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25352__$1);
if(temp__4657__auto__){
var s__25352__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25352__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25352__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25354 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25353 = (0);
while(true){
if((i__25353 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__25353);
cljs.core.chunk_append.call(null,b__25354,(function (){var map__25363 = field;
var map__25363__$1 = ((((!((map__25363 == null)))?((((map__25363.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25363.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25363):map__25363);
var map__25364 = cljs.core.get.call(null,map__25363__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25364__$1 = ((((!((map__25364 == null)))?((((map__25364.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25364.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25364):map__25364);
var hxl = cljs.core.get.call(null,map__25364__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25363__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25363__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25363__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?new cljs.core.Keyword(null,"name","name",1843675177):new cljs.core.Keyword(null,"label","label",1718410804));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__25376 = (i__25353 + (1));
i__25353 = G__25376;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25354),hatti$views$table$iter__25351.call(null,cljs.core.chunk_rest.call(null,s__25352__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25354),null);
}
} else {
var field = cljs.core.first.call(null,s__25352__$2);
return cljs.core.cons.call(null,(function (){var map__25367 = field;
var map__25367__$1 = ((((!((map__25367 == null)))?((((map__25367.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25367.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25367):map__25367);
var map__25368 = cljs.core.get.call(null,map__25367__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25368__$1 = ((((!((map__25368 == null)))?((((map__25368.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25368.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25368):map__25368);
var hxl = cljs.core.get.call(null,map__25368__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25367__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25367__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25367__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?new cljs.core.Keyword(null,"name","name",1843675177):new cljs.core.Keyword(null,"label","label",1718410804));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__25351.call(null,cljs.core.rest.call(null,s__25352__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__25349,map__25349__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__25349,map__25349__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__.call(null,(function (){var G__25371 = hatti.views.table.all_fields.call(null,form);
if(cljs.core.truth_(submission_review_QMARK_)){
return hatti.views.table.submission_review_fields.call(null,G__25371);
} else {
return G__25371;
}
})());
})();
return cljs.core.clj__GT_js.call(null,(function (){var G__25372 = columns;
if(cljs.core.not.call(null,hide_actions_column_QMARK_)){
return cljs.core.conj.call(null,G__25372,hatti.views.actions_column.call(null,owner,has_hxl_QMARK_));
} else {
return G__25372;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq25346){
var G__25347 = cljs.core.first.call(null,seq25346);
var seq25346__$1 = cljs.core.next.call(null,seq25346);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__25347,seq25346__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25393(s__25394){
return (new cljs.core.LazySeq(null,(function (){
var s__25394__$1 = s__25394;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25394__$1);
if(temp__4657__auto__){
var s__25394__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25394__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25394__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25396 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25395 = (0);
while(true){
if((i__25395 < size__7188__auto__)){
var vec__25403 = cljs.core._nth.call(null,c__7187__auto__,i__25395);
var handler_key = cljs.core.nth.call(null,vec__25403,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25403,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__25396,event.subscribe(handler_function));

var G__25409 = (i__25395 + (1));
i__25395 = G__25409;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25396),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25393.call(null,cljs.core.chunk_rest.call(null,s__25394__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25396),null);
}
} else {
var vec__25406 = cljs.core.first.call(null,s__25394__$2);
var handler_key = cljs.core.nth.call(null,vec__25406,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25406,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25393.call(null,cljs.core.rest.call(null,s__25394__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25426(s__25427){
return (new cljs.core.LazySeq(null,(function (){
var s__25427__$1 = s__25427;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25427__$1);
if(temp__4657__auto__){
var s__25427__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25427__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25427__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25429 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25428 = (0);
while(true){
if((i__25428 < size__7188__auto__)){
var vec__25436 = cljs.core._nth.call(null,c__7187__auto__,i__25428);
var handler_key = cljs.core.nth.call(null,vec__25436,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25436,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__25429,event.subscribe(handler_function));

var G__25442 = (i__25428 + (1));
i__25428 = G__25442;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25429),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25426.call(null,cljs.core.chunk_rest.call(null,s__25427__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25429),null);
}
} else {
var vec__25439 = cljs.core.first.call(null,s__25427__$2);
var handler_key = cljs.core.nth.call(null,vec__25439,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25439,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25426.call(null,cljs.core.rest.call(null,s__25427__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.update_data_to_be_deleted_vector = (function hatti$views$table$update_data_to_be_deleted_vector(checked_QMARK_,data_id){
var map__25445 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25445__$1 = ((((!((map__25445 == null)))?((((map__25445.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25445.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25445):map__25445);
var data_to_be_deleted = cljs.core.get.call(null,map__25445__$1,new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634));
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
return chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634)], null),((function (map__25445,map__25445__$1,data_to_be_deleted,fn){
return (function (){
return fn.call(null,data_to_be_deleted,data_id);
});})(map__25445,map__25445__$1,data_to_be_deleted,fn))
);
});
hatti.views.table.get_elements_count_by_selector = (function hatti$views$table$get_elements_count_by_selector(selector){
return document.querySelectorAll(selector).length;
});
hatti.views.table.check_select_unselect_all_records_element_QMARK_ = (function hatti$views$table$check_select_unselect_all_records_element_QMARK_(){
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,delete_record_class_selector);
var selected_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,[cljs.core.str(delete_record_class_selector),cljs.core.str(":checked")].join(''));
return cljs.core._EQ_.call(null,selected_rows_count,total_rows_count);
});
hatti.views.table.get_checkbox_selector = (function hatti$views$table$get_checkbox_selector(data_id){
return [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class),cljs.core.str("[data-id=\""),cljs.core.str(data_id),cljs.core.str("\"]")].join('');
});
hatti.views.table.get_delete_checkbox_by_data_id = (function hatti$views$table$get_delete_checkbox_by_data_id(data_id){
var selector = hatti.views.table.get_checkbox_selector.call(null,data_id);
return document.querySelector(selector);
});
hatti.views.table.select_rows_marked_to_be_deleted = (function hatti$views$table$select_rows_marked_to_be_deleted(){
var seq__25451 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)));
var chunk__25452 = null;
var count__25453 = (0);
var i__25454 = (0);
while(true){
if((i__25454 < count__25453)){
var data_id = cljs.core._nth.call(null,chunk__25452,i__25454);
var element_25455 = hatti.views.table.get_delete_checkbox_by_data_id.call(null,data_id);
element_25455.checked = true;

var G__25456 = seq__25451;
var G__25457 = chunk__25452;
var G__25458 = count__25453;
var G__25459 = (i__25454 + (1));
seq__25451 = G__25456;
chunk__25452 = G__25457;
count__25453 = G__25458;
i__25454 = G__25459;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__25451);
if(temp__4657__auto__){
var seq__25451__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25451__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__25451__$1);
var G__25460 = cljs.core.chunk_rest.call(null,seq__25451__$1);
var G__25461 = c__7220__auto__;
var G__25462 = cljs.core.count.call(null,c__7220__auto__);
var G__25463 = (0);
seq__25451 = G__25460;
chunk__25452 = G__25461;
count__25453 = G__25462;
i__25454 = G__25463;
continue;
} else {
var data_id = cljs.core.first.call(null,seq__25451__$1);
var element_25464 = hatti.views.table.get_delete_checkbox_by_data_id.call(null,data_id);
element_25464.checked = true;

var G__25465 = cljs.core.next.call(null,seq__25451__$1);
var G__25466 = null;
var G__25467 = (0);
var G__25468 = (0);
seq__25451 = G__25465;
chunk__25452 = G__25466;
count__25453 = G__25467;
i__25454 = G__25468;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.higlight_rows_marked_to_be_deleted = (function hatti$views$table$higlight_rows_marked_to_be_deleted(grid){
var checkboxes = document.getElementsByClassName(hatti.views.table.delete_record_class);
var indexes_of_selected_checkboxes = cljs.core.vec.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map_indexed.call(null,((function (checkboxes){
return (function (index,checkbox){
if(cljs.core.truth_(checkbox.checked)){
return index;
} else {
return null;
}
});})(checkboxes))
,checkboxes)));
chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (checkboxes,indexes_of_selected_checkboxes){
return (function (){
return cljs.core.identity.call(null,indexes_of_selected_checkboxes);
});})(checkboxes,indexes_of_selected_checkboxes))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,indexes_of_selected_checkboxes));
});
hatti.views.table.replace_review_num_status_with_text_status = (function hatti$views$table$replace_review_num_status_with_text_status(data){
return cljs.core.map.call(null,(function (row_map){
return cljs.core.assoc.call(null,row_map,"_review_status",hatti.utils.get_submission_review_text.call(null,row_map));
}),data);
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__25469){
var map__25485 = p__25469;
var map__25485__$1 = ((((!((map__25485 == null)))?((((map__25485.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25485.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25485):map__25485);
var grid_event_handlers = cljs.core.get.call(null,map__25485__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__25485__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var map__25487 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25487__$1 = ((((!((map__25487 == null)))?((((map__25487.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25487.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25487):map__25487);
var map__25488 = cljs.core.get.call(null,map__25487__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__25488__$1 = ((((!((map__25488 == null)))?((((map__25488.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25488.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25488):map__25488);
var map__25489 = cljs.core.get.call(null,map__25488__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__25489__$1 = ((((!((map__25489 == null)))?((((map__25489.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25489.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25489):map__25489);
var num_displayed_records = cljs.core.get.call(null,map__25489__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__25489__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25488__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var submission_review_QMARK_ = cljs.core.get.call(null,map__25487__$1,new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,new cljs.core.Keyword(null,"language","language",-1591107564),current_language,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754),hide_actions_column_QMARK_,new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375),submission_review_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

grid.setSelectionModel((new Slick.RowSelectionModel(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selectActiveRow","selectActiveRow",-841772687),false], null)))));

dataview.onRowCountChanged.subscribe(((function (map__25487,map__25487__$1,map__25488,map__25488__$1,map__25489,map__25489__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25485,map__25485__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__25487,map__25487__$1,map__25488,map__25488__$1,map__25489,map__25489__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25485,map__25485__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__25487,map__25487__$1,map__25488,map__25488__$1,map__25489,map__25489__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25485,map__25485__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

grid.render();

hatti.views.table.select_rows_marked_to_be_deleted.call(null);

return hatti.views.table.higlight_rows_marked_to_be_deleted.call(null,grid);
});})(map__25487,map__25487__$1,map__25488,map__25488__$1,map__25489,map__25489__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25485,map__25485__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onHeaderClick.subscribe(((function (map__25487,map__25487__$1,map__25488,map__25488__$1,map__25489,map__25489__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25485,map__25485__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var target = e.target;
var id = target.id;
var checked_QMARK_ = target.checked;
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,delete_record_class_selector);
if(cljs.core._EQ_.call(null,hatti.views.table.select_unselect_all_records_id,id)){
var records_to_be_deleted = document.getElementsByClassName(hatti.views.table.delete_record_class);
var seq__25493_25500 = cljs.core.seq.call(null,records_to_be_deleted);
var chunk__25494_25501 = null;
var count__25495_25502 = (0);
var i__25496_25503 = (0);
while(true){
if((i__25496_25503 < count__25495_25502)){
var record_25504 = cljs.core._nth.call(null,chunk__25494_25501,i__25496_25503);
record_25504.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,parseInt(record_25504.getAttribute("data-id")));

var G__25505 = seq__25493_25500;
var G__25506 = chunk__25494_25501;
var G__25507 = count__25495_25502;
var G__25508 = (i__25496_25503 + (1));
seq__25493_25500 = G__25505;
chunk__25494_25501 = G__25506;
count__25495_25502 = G__25507;
i__25496_25503 = G__25508;
continue;
} else {
var temp__4657__auto___25509 = cljs.core.seq.call(null,seq__25493_25500);
if(temp__4657__auto___25509){
var seq__25493_25510__$1 = temp__4657__auto___25509;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25493_25510__$1)){
var c__7220__auto___25511 = cljs.core.chunk_first.call(null,seq__25493_25510__$1);
var G__25512 = cljs.core.chunk_rest.call(null,seq__25493_25510__$1);
var G__25513 = c__7220__auto___25511;
var G__25514 = cljs.core.count.call(null,c__7220__auto___25511);
var G__25515 = (0);
seq__25493_25500 = G__25512;
chunk__25494_25501 = G__25513;
count__25495_25502 = G__25514;
i__25496_25503 = G__25515;
continue;
} else {
var record_25516 = cljs.core.first.call(null,seq__25493_25510__$1);
record_25516.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,parseInt(record_25516.getAttribute("data-id")));

var G__25517 = cljs.core.next.call(null,seq__25493_25510__$1);
var G__25518 = null;
var G__25519 = (0);
var G__25520 = (0);
seq__25493_25500 = G__25517;
chunk__25494_25501 = G__25518;
count__25495_25502 = G__25519;
i__25496_25503 = G__25520;
continue;
}
} else {
}
}
break;
}

chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__25487,map__25487__$1,map__25488,map__25488__$1,map__25489,map__25489__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25485,map__25485__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
if(cljs.core.truth_(checked_QMARK_)){
return cljs.core.range.call(null,total_rows_count);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});})(records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__25487,map__25487__$1,map__25488,map__25488__$1,map__25489,map__25489__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25485,map__25485__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
} else {
return null;
}
});})(map__25487,map__25487__$1,map__25488,map__25488__$1,map__25489,map__25489__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25485,map__25485__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__25487,map__25487__$1,map__25488,map__25488__$1,map__25489,map__25489__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25485,map__25485__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(map__25487,map__25487__$1,map__25488,map__25488__$1,map__25489,map__25489__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25485,map__25485__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__25487,map__25487__$1,map__25488,map__25488__$1,map__25489,map__25489__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25485,map__25485__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var class_name = elem.className;
var checked_QMARK_ = elem.checked;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
var select_unselect_all_records_chkbox = document.getElementById(hatti.views.table.select_unselect_all_records_id);
var map__25497 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25497__$1 = ((((!((map__25497 == null)))?((((map__25497.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25497.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25497):map__25497);
var selected_table_rows = cljs.core.get.call(null,map__25497__$1,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745));
if(cljs.core._EQ_.call(null,class_name,hatti.views.table.delete_record_class)){
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
var row__$1 = parseInt(grid.getCellFromEvent(e).row);
hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,data_id);

select_unselect_all_records_chkbox.checked = hatti.views.table.check_select_unselect_all_records_element_QMARK_.call(null);

chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__25497,map__25497__$1,selected_table_rows,map__25487,map__25487__$1,map__25488,map__25488__$1,map__25489,map__25489__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25485,map__25485__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
return fn.call(null,selected_table_rows,row__$1);
});})(fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__25497,map__25497__$1,selected_table_rows,map__25487,map__25487__$1,map__25488,map__25488__$1,map__25489,map__25489__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25485,map__25485__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
} else {
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
}
});})(map__25487,map__25487__$1,map__25488,map__25488__$1,map__25489,map__25489__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25485,map__25485__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,(function (){var G__25499 = data;
if(cljs.core.truth_(submission_review_QMARK_)){
return hatti.views.table.replace_review_num_status_with_text_status.call(null,G__25499);
} else {
return G__25499;
}
})()),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__13879__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto__,event_chan){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto__,event_chan){
return (function (state_25812){
var state_val_25813 = (state_25812[(1)]);
if((state_val_25813 === (7))){
var inst_25710 = (state_25812[(7)]);
var inst_25710__$1 = (state_25812[(2)]);
var inst_25712 = (inst_25710__$1 == null);
var inst_25713 = cljs.core.not.call(null,inst_25712);
var state_25812__$1 = (function (){var statearr_25814 = state_25812;
(statearr_25814[(7)] = inst_25710__$1);

return statearr_25814;
})();
if(inst_25713){
var statearr_25815_25890 = state_25812__$1;
(statearr_25815_25890[(1)] = (8));

} else {
var statearr_25816_25891 = state_25812__$1;
(statearr_25816_25891[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (20))){
var inst_25740 = (state_25812[(8)]);
var inst_25732 = (state_25812[(9)]);
var inst_25749 = inst_25740.call(null,inst_25732);
var state_25812__$1 = state_25812;
var statearr_25817_25892 = state_25812__$1;
(statearr_25817_25892[(2)] = inst_25749);

(statearr_25817_25892[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (27))){
var state_25812__$1 = state_25812;
var statearr_25818_25893 = state_25812__$1;
(statearr_25818_25893[(2)] = null);

(statearr_25818_25893[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (1))){
var state_25812__$1 = state_25812;
var statearr_25819_25894 = state_25812__$1;
(statearr_25819_25894[(2)] = null);

(statearr_25819_25894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (24))){
var state_25812__$1 = state_25812;
var statearr_25820_25895 = state_25812__$1;
(statearr_25820_25895[(2)] = null);

(statearr_25820_25895[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (4))){
var state_25812__$1 = state_25812;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25812__$1,(7),event_chan);
} else {
if((state_val_25813 === (15))){
var inst_25710 = (state_25812[(7)]);
var state_25812__$1 = state_25812;
var statearr_25821_25896 = state_25812__$1;
(statearr_25821_25896[(2)] = inst_25710);

(statearr_25821_25896[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (21))){
var state_25812__$1 = state_25812;
var statearr_25822_25897 = state_25812__$1;
(statearr_25822_25897[(2)] = null);

(statearr_25822_25897[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (31))){
var inst_25736 = (state_25812[(10)]);
var inst_25785 = (state_25812[(2)]);
var inst_25786 = cljs.core._EQ_.call(null,inst_25736,new cljs.core.Keyword(null,"table","table",-564943036));
var state_25812__$1 = (function (){var statearr_25823 = state_25812;
(statearr_25823[(11)] = inst_25785);

return statearr_25823;
})();
if(inst_25786){
var statearr_25824_25898 = state_25812__$1;
(statearr_25824_25898[(1)] = (32));

} else {
var statearr_25825_25899 = state_25812__$1;
(statearr_25825_25899[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (32))){
var inst_25736 = (state_25812[(10)]);
var inst_25740 = (state_25812[(8)]);
var inst_25731 = (state_25812[(12)]);
var inst_25735 = (state_25812[(13)]);
var inst_25734 = (state_25812[(14)]);
var inst_25741 = (state_25812[(15)]);
var inst_25732 = (state_25812[(9)]);
var inst_25730 = (state_25812[(16)]);
var inst_25733 = (state_25812[(17)]);
var inst_25799 = cljs.core.async.chan.call(null,(1));
var inst_25800 = (function (){var new_columns = inst_25735;
var submission_clicked = inst_25732;
var submission_unclicked = inst_25733;
var get_submission_data = inst_25741;
var map__25708 = inst_25730;
var re_render = inst_25736;
var update_data_BANG_ = inst_25740;
var submission_to_rank = inst_25731;
var filter_by = inst_25734;
var c__13879__auto____$1 = inst_25799;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,map__25708,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25741,inst_25732,inst_25730,inst_25733,inst_25799,state_val_25813,c__13879__auto__,event_chan){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,map__25708,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25741,inst_25732,inst_25730,inst_25733,inst_25799,state_val_25813,c__13879__auto__,event_chan){
return (function (state_25797){
var state_val_25798 = (state_25797[(1)]);
if((state_val_25798 === (1))){
var inst_25788 = cljs.core.async.timeout.call(null,(20));
var state_25797__$1 = state_25797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25797__$1,(2),inst_25788);
} else {
if((state_val_25798 === (2))){
var inst_25790 = (state_25797[(2)]);
var inst_25791 = grid.resizeCanvas();
var inst_25792 = grid.invalidateAllRows();
var inst_25793 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25794 = grid.render();
var inst_25795 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_25797__$1 = (function (){var statearr_25826 = state_25797;
(statearr_25826[(7)] = inst_25793);

(statearr_25826[(8)] = inst_25792);

(statearr_25826[(9)] = inst_25790);

(statearr_25826[(10)] = inst_25794);

(statearr_25826[(11)] = inst_25791);

return statearr_25826;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25797__$1,inst_25795);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,map__25708,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25741,inst_25732,inst_25730,inst_25733,inst_25799,state_val_25813,c__13879__auto__,event_chan))
;
return ((function (switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,map__25708,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25741,inst_25732,inst_25730,inst_25733,inst_25799,state_val_25813,c__13879__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____0 = (function (){
var statearr_25830 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25830[(0)] = hatti$views$table$handle_table_events_$_state_machine__13768__auto__);

(statearr_25830[(1)] = (1));

return statearr_25830;
});
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____1 = (function (state_25797){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_25797);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e25831){if((e25831 instanceof Object)){
var ex__13771__auto__ = e25831;
var statearr_25832_25900 = state_25797;
(statearr_25832_25900[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25797);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25831;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25901 = state_25797;
state_25797 = G__25901;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = function(state_25797){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____1.call(this,state_25797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,map__25708,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25741,inst_25732,inst_25730,inst_25733,inst_25799,state_val_25813,c__13879__auto__,event_chan))
})();
var state__13881__auto__ = (function (){var statearr_25833 = f__13880__auto__.call(null);
(statearr_25833[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto____$1);

return statearr_25833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,map__25708,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25741,inst_25732,inst_25730,inst_25733,inst_25799,state_val_25813,c__13879__auto__,event_chan))
})();
var inst_25801 = cljs.core.async.impl.dispatch.run.call(null,inst_25800);
var state_25812__$1 = (function (){var statearr_25834 = state_25812;
(statearr_25834[(18)] = inst_25801);

return statearr_25834;
})();
var statearr_25835_25902 = state_25812__$1;
(statearr_25835_25902[(2)] = inst_25799);

(statearr_25835_25902[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (33))){
var state_25812__$1 = state_25812;
var statearr_25836_25903 = state_25812__$1;
(statearr_25836_25903[(2)] = null);

(statearr_25836_25903[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (13))){
var inst_25722 = (state_25812[(2)]);
var state_25812__$1 = state_25812;
var statearr_25837_25904 = state_25812__$1;
(statearr_25837_25904[(2)] = inst_25722);

(statearr_25837_25904[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (22))){
var inst_25733 = (state_25812[(17)]);
var inst_25752 = (state_25812[(2)]);
var state_25812__$1 = (function (){var statearr_25838 = state_25812;
(statearr_25838[(19)] = inst_25752);

return statearr_25838;
})();
if(cljs.core.truth_(inst_25733)){
var statearr_25839_25905 = state_25812__$1;
(statearr_25839_25905[(1)] = (23));

} else {
var statearr_25840_25906 = state_25812__$1;
(statearr_25840_25906[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (29))){
var inst_25734 = (state_25812[(14)]);
var inst_25777 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_25778 = [inst_25734];
var inst_25779 = cljs.core.PersistentHashMap.fromArrays(inst_25777,inst_25778);
var inst_25780 = cljs.core.clj__GT_js.call(null,inst_25779);
var inst_25781 = dataview.setFilterArgs(inst_25780);
var inst_25782 = dataview.refresh();
var state_25812__$1 = (function (){var statearr_25841 = state_25812;
(statearr_25841[(20)] = inst_25781);

return statearr_25841;
})();
var statearr_25842_25907 = state_25812__$1;
(statearr_25842_25907[(2)] = inst_25782);

(statearr_25842_25907[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (6))){
var inst_25808 = (state_25812[(2)]);
var state_25812__$1 = state_25812;
var statearr_25843_25908 = state_25812__$1;
(statearr_25843_25908[(2)] = inst_25808);

(statearr_25843_25908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (28))){
var inst_25734 = (state_25812[(14)]);
var inst_25775 = (state_25812[(2)]);
var state_25812__$1 = (function (){var statearr_25844 = state_25812;
(statearr_25844[(21)] = inst_25775);

return statearr_25844;
})();
if(cljs.core.truth_(inst_25734)){
var statearr_25845_25909 = state_25812__$1;
(statearr_25845_25909[(1)] = (29));

} else {
var statearr_25846_25910 = state_25812__$1;
(statearr_25846_25910[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (25))){
var inst_25735 = (state_25812[(13)]);
var inst_25757 = (state_25812[(2)]);
var state_25812__$1 = (function (){var statearr_25847 = state_25812;
(statearr_25847[(22)] = inst_25757);

return statearr_25847;
})();
if(cljs.core.truth_(inst_25735)){
var statearr_25848_25911 = state_25812__$1;
(statearr_25848_25911[(1)] = (26));

} else {
var statearr_25849_25912 = state_25812__$1;
(statearr_25849_25912[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (34))){
var inst_25804 = (state_25812[(2)]);
var state_25812__$1 = (function (){var statearr_25850 = state_25812;
(statearr_25850[(23)] = inst_25804);

return statearr_25850;
})();
var statearr_25851_25913 = state_25812__$1;
(statearr_25851_25913[(2)] = null);

(statearr_25851_25913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (17))){
var inst_25740 = (state_25812[(8)]);
var inst_25731 = (state_25812[(12)]);
var inst_25741 = (state_25812[(15)]);
var inst_25743 = inst_25741.call(null,hatti.constants._rank,inst_25731);
var inst_25744 = inst_25740.call(null,inst_25743);
var state_25812__$1 = state_25812;
var statearr_25852_25914 = state_25812__$1;
(statearr_25852_25914[(2)] = inst_25744);

(statearr_25852_25914[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (3))){
var inst_25810 = (state_25812[(2)]);
var state_25812__$1 = state_25812;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25812__$1,inst_25810);
} else {
if((state_val_25813 === (12))){
var state_25812__$1 = state_25812;
var statearr_25853_25915 = state_25812__$1;
(statearr_25853_25915[(2)] = false);

(statearr_25853_25915[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (2))){
var state_25812__$1 = state_25812;
var statearr_25854_25916 = state_25812__$1;
(statearr_25854_25916[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (23))){
var inst_25740 = (state_25812[(8)]);
var inst_25754 = inst_25740.call(null,null);
var state_25812__$1 = state_25812;
var statearr_25856_25917 = state_25812__$1;
(statearr_25856_25917[(2)] = inst_25754);

(statearr_25856_25917[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (19))){
var inst_25732 = (state_25812[(9)]);
var inst_25747 = (state_25812[(2)]);
var state_25812__$1 = (function (){var statearr_25857 = state_25812;
(statearr_25857[(24)] = inst_25747);

return statearr_25857;
})();
if(cljs.core.truth_(inst_25732)){
var statearr_25858_25918 = state_25812__$1;
(statearr_25858_25918[(1)] = (20));

} else {
var statearr_25859_25919 = state_25812__$1;
(statearr_25859_25919[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (11))){
var state_25812__$1 = state_25812;
var statearr_25860_25920 = state_25812__$1;
(statearr_25860_25920[(2)] = true);

(statearr_25860_25920[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (9))){
var state_25812__$1 = state_25812;
var statearr_25861_25921 = state_25812__$1;
(statearr_25861_25921[(2)] = false);

(statearr_25861_25921[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (5))){
var state_25812__$1 = state_25812;
var statearr_25862_25922 = state_25812__$1;
(statearr_25862_25922[(2)] = null);

(statearr_25862_25922[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (14))){
var inst_25710 = (state_25812[(7)]);
var inst_25727 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25710);
var state_25812__$1 = state_25812;
var statearr_25863_25923 = state_25812__$1;
(statearr_25863_25923[(2)] = inst_25727);

(statearr_25863_25923[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (26))){
var inst_25736 = (state_25812[(10)]);
var inst_25740 = (state_25812[(8)]);
var inst_25731 = (state_25812[(12)]);
var inst_25735 = (state_25812[(13)]);
var inst_25734 = (state_25812[(14)]);
var inst_25741 = (state_25812[(15)]);
var inst_25732 = (state_25812[(9)]);
var inst_25730 = (state_25812[(16)]);
var inst_25733 = (state_25812[(17)]);
var inst_25770 = cljs.core.async.chan.call(null,(1));
var inst_25771 = (function (){var new_columns = inst_25735;
var submission_clicked = inst_25732;
var submission_unclicked = inst_25733;
var get_submission_data = inst_25741;
var map__25708 = inst_25730;
var re_render = inst_25736;
var update_data_BANG_ = inst_25740;
var submission_to_rank = inst_25731;
var filter_by = inst_25734;
var c__13879__auto____$1 = inst_25770;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,map__25708,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25741,inst_25732,inst_25730,inst_25733,inst_25770,state_val_25813,c__13879__auto__,event_chan){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,map__25708,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25741,inst_25732,inst_25730,inst_25733,inst_25770,state_val_25813,c__13879__auto__,event_chan){
return (function (state_25768){
var state_val_25769 = (state_25768[(1)]);
if((state_val_25769 === (1))){
var inst_25759 = cljs.core.async.timeout.call(null,(20));
var state_25768__$1 = state_25768;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25768__$1,(2),inst_25759);
} else {
if((state_val_25769 === (2))){
var inst_25761 = (state_25768[(2)]);
var inst_25762 = grid.setColumns(new_columns);
var inst_25763 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25764 = grid.render();
var inst_25765 = hatti.views.table.select_rows_marked_to_be_deleted.call(null);
var inst_25766 = hatti.views.table.higlight_rows_marked_to_be_deleted.call(null,grid);
var state_25768__$1 = (function (){var statearr_25864 = state_25768;
(statearr_25864[(7)] = inst_25761);

(statearr_25864[(8)] = inst_25762);

(statearr_25864[(9)] = inst_25765);

(statearr_25864[(10)] = inst_25764);

(statearr_25864[(11)] = inst_25763);

return statearr_25864;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25768__$1,inst_25766);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,map__25708,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25741,inst_25732,inst_25730,inst_25733,inst_25770,state_val_25813,c__13879__auto__,event_chan))
;
return ((function (switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,map__25708,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25741,inst_25732,inst_25730,inst_25733,inst_25770,state_val_25813,c__13879__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____0 = (function (){
var statearr_25868 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25868[(0)] = hatti$views$table$handle_table_events_$_state_machine__13768__auto__);

(statearr_25868[(1)] = (1));

return statearr_25868;
});
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____1 = (function (state_25768){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_25768);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e25869){if((e25869 instanceof Object)){
var ex__13771__auto__ = e25869;
var statearr_25870_25924 = state_25768;
(statearr_25870_25924[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25768);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25869;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25925 = state_25768;
state_25768 = G__25925;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = function(state_25768){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____1.call(this,state_25768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,map__25708,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25741,inst_25732,inst_25730,inst_25733,inst_25770,state_val_25813,c__13879__auto__,event_chan))
})();
var state__13881__auto__ = (function (){var statearr_25871 = f__13880__auto__.call(null);
(statearr_25871[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto____$1);

return statearr_25871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,map__25708,re_render,update_data_BANG_,submission_to_rank,filter_by,c__13879__auto____$1,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25741,inst_25732,inst_25730,inst_25733,inst_25770,state_val_25813,c__13879__auto__,event_chan))
})();
var inst_25772 = cljs.core.async.impl.dispatch.run.call(null,inst_25771);
var state_25812__$1 = (function (){var statearr_25872 = state_25812;
(statearr_25872[(25)] = inst_25772);

return statearr_25872;
})();
var statearr_25873_25926 = state_25812__$1;
(statearr_25873_25926[(2)] = inst_25770);

(statearr_25873_25926[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (16))){
var inst_25736 = (state_25812[(10)]);
var inst_25740 = (state_25812[(8)]);
var inst_25731 = (state_25812[(12)]);
var inst_25735 = (state_25812[(13)]);
var inst_25734 = (state_25812[(14)]);
var inst_25732 = (state_25812[(9)]);
var inst_25730 = (state_25812[(16)]);
var inst_25733 = (state_25812[(17)]);
var inst_25730__$1 = (state_25812[(2)]);
var inst_25731__$1 = cljs.core.get.call(null,inst_25730__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_25732__$1 = cljs.core.get.call(null,inst_25730__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_25733__$1 = cljs.core.get.call(null,inst_25730__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_25734__$1 = cljs.core.get.call(null,inst_25730__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_25735__$1 = cljs.core.get.call(null,inst_25730__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_25736__$1 = cljs.core.get.call(null,inst_25730__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_25737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25738 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_25739 = (new cljs.core.PersistentVector(null,3,(5),inst_25737,inst_25738,null));
var inst_25740__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_25739);
var inst_25741 = (function (){var map__25708 = inst_25730__$1;
var submission_to_rank = inst_25731__$1;
var submission_clicked = inst_25732__$1;
var submission_unclicked = inst_25733__$1;
var filter_by = inst_25734__$1;
var new_columns = inst_25735__$1;
var re_render = inst_25736__$1;
var update_data_BANG_ = inst_25740__$1;
return ((function (map__25708,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25730,inst_25733,inst_25730__$1,inst_25731__$1,inst_25732__$1,inst_25733__$1,inst_25734__$1,inst_25735__$1,inst_25736__$1,inst_25737,inst_25738,inst_25739,inst_25740__$1,state_val_25813,c__13879__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__25708,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25730,inst_25733,inst_25730__$1,inst_25731__$1,inst_25732__$1,inst_25733__$1,inst_25734__$1,inst_25735__$1,inst_25736__$1,inst_25737,inst_25738,inst_25739,inst_25740__$1,state_val_25813,c__13879__auto__,event_chan){
return (function (p1__25521_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__25521_SHARP_,field));
});})(map__25708,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25730,inst_25733,inst_25730__$1,inst_25731__$1,inst_25732__$1,inst_25733__$1,inst_25734__$1,inst_25735__$1,inst_25736__$1,inst_25737,inst_25738,inst_25739,inst_25740__$1,state_val_25813,c__13879__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(map__25708,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25736,inst_25740,inst_25731,inst_25735,inst_25734,inst_25732,inst_25730,inst_25733,inst_25730__$1,inst_25731__$1,inst_25732__$1,inst_25733__$1,inst_25734__$1,inst_25735__$1,inst_25736__$1,inst_25737,inst_25738,inst_25739,inst_25740__$1,state_val_25813,c__13879__auto__,event_chan))
})();
var state_25812__$1 = (function (){var statearr_25874 = state_25812;
(statearr_25874[(10)] = inst_25736__$1);

(statearr_25874[(8)] = inst_25740__$1);

(statearr_25874[(12)] = inst_25731__$1);

(statearr_25874[(13)] = inst_25735__$1);

(statearr_25874[(14)] = inst_25734__$1);

(statearr_25874[(15)] = inst_25741);

(statearr_25874[(9)] = inst_25732__$1);

(statearr_25874[(16)] = inst_25730__$1);

(statearr_25874[(17)] = inst_25733__$1);

return statearr_25874;
})();
if(cljs.core.truth_(inst_25731__$1)){
var statearr_25875_25927 = state_25812__$1;
(statearr_25875_25927[(1)] = (17));

} else {
var statearr_25876_25928 = state_25812__$1;
(statearr_25876_25928[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (30))){
var state_25812__$1 = state_25812;
var statearr_25877_25929 = state_25812__$1;
(statearr_25877_25929[(2)] = null);

(statearr_25877_25929[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (10))){
var inst_25725 = (state_25812[(2)]);
var state_25812__$1 = state_25812;
if(cljs.core.truth_(inst_25725)){
var statearr_25878_25930 = state_25812__$1;
(statearr_25878_25930[(1)] = (14));

} else {
var statearr_25879_25931 = state_25812__$1;
(statearr_25879_25931[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (18))){
var state_25812__$1 = state_25812;
var statearr_25880_25932 = state_25812__$1;
(statearr_25880_25932[(2)] = null);

(statearr_25880_25932[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (8))){
var inst_25710 = (state_25812[(7)]);
var inst_25715 = inst_25710.cljs$lang$protocol_mask$partition0$;
var inst_25716 = (inst_25715 & (64));
var inst_25717 = inst_25710.cljs$core$ISeq$;
var inst_25718 = (inst_25716) || (inst_25717);
var state_25812__$1 = state_25812;
if(cljs.core.truth_(inst_25718)){
var statearr_25881_25933 = state_25812__$1;
(statearr_25881_25933[(1)] = (11));

} else {
var statearr_25882_25934 = state_25812__$1;
(statearr_25882_25934[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto__,event_chan))
;
return ((function (switch__13767__auto__,c__13879__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____0 = (function (){
var statearr_25886 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25886[(0)] = hatti$views$table$handle_table_events_$_state_machine__13768__auto__);

(statearr_25886[(1)] = (1));

return statearr_25886;
});
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____1 = (function (state_25812){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_25812);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e25887){if((e25887 instanceof Object)){
var ex__13771__auto__ = e25887;
var statearr_25888_25935 = state_25812;
(statearr_25888_25935[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25812);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25887;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25936 = state_25812;
state_25812 = G__25936;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = function(state_25812){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____1.call(this,state_25812);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto__,event_chan))
})();
var state__13881__auto__ = (function (){var statearr_25889 = f__13880__auto__.call(null);
(statearr_25889[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto__);

return statearr_25889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto__,event_chan))
);

return c__13879__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"field-key","field-key",313262601),k);

return colset_BANG_.call(null,k);
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__25953(s__25954){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__25954__$1 = s__25954;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25954__$1);
if(temp__4657__auto__){
var s__25954__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25954__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25954__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25956 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25955 = (0);
while(true){
if((i__25955 < size__7188__auto__)){
var vec__25963 = cljs.core._nth.call(null,c__7187__auto__,i__25955);
var k = cljs.core.nth.call(null,vec__25963,(0),null);
var v = cljs.core.nth.call(null,vec__25963,(1),null);
cljs.core.chunk_append.call(null,b__25956,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__25955,vec__25963,k,v,c__7187__auto__,size__7188__auto__,b__25956,s__25954__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__25955,vec__25963,k,v,c__7187__auto__,size__7188__auto__,b__25956,s__25954__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__25969 = (i__25955 + (1));
i__25955 = G__25969;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25956),hatti$views$table$render_options_$_iter__25953.call(null,cljs.core.chunk_rest.call(null,s__25954__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25956),null);
}
} else {
var vec__25966 = cljs.core.first.call(null,s__25954__$2);
var k = cljs.core.nth.call(null,vec__25966,(0),null);
var v = cljs.core.nth.call(null,vec__25966,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__25966,k,v,s__25954__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__25966,k,v,s__25954__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__25953.call(null,cljs.core.rest.call(null,s__25954__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table25971 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25971 = (function (_,owner,meta25972){
this._ = _;
this.owner = owner;
this.meta25972 = meta25972;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25971.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25973,meta25972__$1){
var self__ = this;
var _25973__$1 = this;
return (new hatti.views.table.t_hatti$views$table25971(self__._,self__.owner,meta25972__$1));
});

hatti.views.table.t_hatti$views$table25971.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25973){
var self__ = this;
var _25973__$1 = this;
return self__.meta25972;
});

hatti.views.table.t_hatti$views$table25971.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table25971.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field-key","field-key",313262601),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table25971.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table25971.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__25974){
var self__ = this;
var map__25975 = p__25974;
var map__25975__$1 = ((((!((map__25975 == null)))?((((map__25975.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25975.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25975):map__25975);
var field_key = cljs.core.get.call(null,map__25975__$1,new cljs.core.Keyword(null,"field-key","field-key",313262601));
var language = cljs.core.get.call(null,map__25975__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__25977 = om.core.get_shared.call(null,self__.owner);
var map__25977__$1 = ((((!((map__25977 == null)))?((((map__25977.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25977.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25977):map__25977);
var flat_form = cljs.core.get.call(null,map__25977__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var map__25978 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25978__$1 = ((((!((map__25978 == null)))?((((map__25978.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25978.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25978):map__25978);
var submission_review_QMARK_ = cljs.core.get.call(null,map__25978__$1,new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375));
var colset_BANG_ = ((function (options,map__25977,map__25977__$1,flat_form,new_language,map__25978,map__25978__$1,submission_review_QMARK_,___$2,map__25975,map__25975__$1,field_key,language){
return (function (p1__25970_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__25970_SHARP_),new cljs.core.Keyword(null,"language","language",-1591107564),new_language,new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375),submission_review_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),self__.owner)], null));
});})(options,map__25977,map__25977__$1,flat_form,new_language,map__25978,map__25978__$1,submission_review_QMARK_,___$2,map__25975,map__25975__$1,field_key,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,field_key);
} else {
}

return React.DOM.div(({"className": "label-changer"}),React.DOM.span(({"className": "label-changer-label"}),"Show:"),React.DOM.div(({"id": "header-display-dropdown", "className": "drop-hover"}),(function (){var attrs25983 = options.call(null,field_key);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs25983))?sablono.interpreter.attributes.call(null,attrs25983):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25983))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i(({"className": "fa fa-angle-down"}))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25983),React.DOM.i(({"className": "fa fa-angle-down"}))], null))));
})(),(function (){var attrs25988 = hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_);
return cljs.core.apply.call(null,React.DOM.ul,((cljs.core.map_QMARK_.call(null,attrs25988))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs25988)):({"className": "submenu no-dot"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25988))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25988)], null))));
})()));
});

hatti.views.table.t_hatti$views$table25971.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta25972","meta25972",1645234660,null)], null);
});

hatti.views.table.t_hatti$views$table25971.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25971.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25971";

hatti.views.table.t_hatti$views$table25971.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25971");
});

hatti.views.table.__GT_t_hatti$views$table25971 = (function hatti$views$table$__GT_t_hatti$views$table25971(___$1,owner__$1,meta25972){
return (new hatti.views.table.t_hatti$views$table25971(___$1,owner__$1,meta25972));
});

}

return (new hatti.views.table.t_hatti$views$table25971(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__13879__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto__,query){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto__,query){
return (function (state_26031){
var state_val_26032 = (state_26031[(1)]);
if((state_val_26032 === (1))){
var inst_26017 = cljs.core.async.timeout.call(null,(150));
var state_26031__$1 = state_26031;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26031__$1,(2),inst_26017);
} else {
if((state_val_26032 === (2))){
var inst_26019 = (state_26031[(2)]);
var inst_26020 = input.value;
var inst_26021 = cljs.core._EQ_.call(null,query,inst_26020);
var state_26031__$1 = (function (){var statearr_26033 = state_26031;
(statearr_26033[(7)] = inst_26019);

return statearr_26033;
})();
if(inst_26021){
var statearr_26034_26045 = state_26031__$1;
(statearr_26034_26045[(1)] = (3));

} else {
var statearr_26035_26046 = state_26031__$1;
(statearr_26035_26046[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (3))){
var inst_26023 = [query_event_key];
var inst_26024 = [query];
var inst_26025 = cljs.core.PersistentHashMap.fromArrays(inst_26023,inst_26024);
var inst_26026 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_26025);
var state_26031__$1 = state_26031;
var statearr_26036_26047 = state_26031__$1;
(statearr_26036_26047[(2)] = inst_26026);

(statearr_26036_26047[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (4))){
var state_26031__$1 = state_26031;
var statearr_26037_26048 = state_26031__$1;
(statearr_26037_26048[(2)] = null);

(statearr_26037_26048[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (5))){
var inst_26029 = (state_26031[(2)]);
var state_26031__$1 = state_26031;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26031__$1,inst_26029);
} else {
return null;
}
}
}
}
}
});})(c__13879__auto__,query))
;
return ((function (switch__13767__auto__,c__13879__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__13768__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__13768__auto____0 = (function (){
var statearr_26041 = [null,null,null,null,null,null,null,null];
(statearr_26041[(0)] = hatti$views$table$delayed_search_$_state_machine__13768__auto__);

(statearr_26041[(1)] = (1));

return statearr_26041;
});
var hatti$views$table$delayed_search_$_state_machine__13768__auto____1 = (function (state_26031){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_26031);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e26042){if((e26042 instanceof Object)){
var ex__13771__auto__ = e26042;
var statearr_26043_26049 = state_26031;
(statearr_26043_26049[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26031);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26042;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26050 = state_26031;
state_26031 = G__26050;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__13768__auto__ = function(state_26031){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__13768__auto____1.call(this,state_26031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__13768__auto____0;
hatti$views$table$delayed_search_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__13768__auto____1;
return hatti$views$table$delayed_search_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto__,query))
})();
var state__13881__auto__ = (function (){var statearr_26044 = f__13880__auto__.call(null);
(statearr_26044[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto__);

return statearr_26044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto__,query))
);

return c__13879__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table26052 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26052 = (function (_,owner,meta26053){
this._ = _;
this.owner = owner;
this.meta26053 = meta26053;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26052.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26054,meta26053__$1){
var self__ = this;
var _26054__$1 = this;
return (new hatti.views.table.t_hatti$views$table26052(self__._,self__.owner,meta26053__$1));
});

hatti.views.table.t_hatti$views$table26052.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26054){
var self__ = this;
var _26054__$1 = this;
return self__.meta26053;
});

hatti.views.table.t_hatti$views$table26052.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table26052.prototype.om$core$IRender$render$arity$1 = (function (this__18222__auto__){
var self__ = this;
var this__18222__auto____$1 = this;
return React.DOM.div(({"className": "table-search"}),React.DOM.i(({"className": "fa fa-search"})),sablono.interpreter.input.call(null,({"type": "text", "placeholder": "Search", "onChange": ((function (this__18222__auto____$1){
return (function (p1__26051_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__26051_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__18222__auto____$1))
})));
});

hatti.views.table.t_hatti$views$table26052.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta26053","meta26053",-715621760,null)], null);
});

hatti.views.table.t_hatti$views$table26052.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26052.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26052";

hatti.views.table.t_hatti$views$table26052.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26052");
});

hatti.views.table.__GT_t_hatti$views$table26052 = (function hatti$views$table$__GT_t_hatti$views$table26052(___$1,owner__$1,meta26053){
return (new hatti.views.table.t_hatti$views$table26052(___$1,owner__$1,meta26053));
});

}

return (new hatti.views.table.t_hatti$views$table26052(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table26057 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26057 = (function (cursor,owner,meta26058){
this.cursor = cursor;
this.owner = owner;
this.meta26058 = meta26058;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26057.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26059,meta26058__$1){
var self__ = this;
var _26059__$1 = this;
return (new hatti.views.table.t_hatti$views$table26057(self__.cursor,self__.owner,meta26058__$1));
});

hatti.views.table.t_hatti$views$table26057.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26059){
var self__ = this;
var _26059__$1 = this;
return self__.meta26058;
});

hatti.views.table.t_hatti$views$table26057.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table26057.prototype.om$core$IRender$render$arity$1 = (function (this__18222__auto__){
var self__ = this;
var this__18222__auto____$1 = this;
return React.DOM.div(({"className": "topbar"}),React.DOM.div(({"id": hatti.views.table.pager_id})),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,self__.cursor)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.cursor)),React.DOM.div(({"style": ({"clear": "both"})})));
});

hatti.views.table.t_hatti$views$table26057.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta26058","meta26058",-653149865,null)], null);
});

hatti.views.table.t_hatti$views$table26057.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26057.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26057";

hatti.views.table.t_hatti$views$table26057.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26057");
});

hatti.views.table.__GT_t_hatti$views$table26057 = (function hatti$views$table$__GT_t_hatti$views$table26057(cursor__$1,owner__$1,meta26058){
return (new hatti.views.table.t_hatti$views$table26057(cursor__$1,owner__$1,meta26058));
});

}

return (new hatti.views.table.t_hatti$views$table26057(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq.call(null,data)){
var map__26067 = om.core.get_shared.call(null,owner);
var map__26067__$1 = ((((!((map__26067 == null)))?((((map__26067.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26067.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26067):map__26067);
var flat_form = cljs.core.get.call(null,map__26067__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__26068 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__26068,(0),null);
var dataview = cljs.core.nth.call(null,vec__26068,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".table-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901),hatti.views.table.get_table_view_height.call(null));
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881),resize_handler);
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__26073,owner,p__26074){
var map__26075 = p__26073;
var map__26075__$1 = ((((!((map__26075 == null)))?((((map__26075.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26075.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26075):map__26075);
var cursor = map__26075__$1;
var map__26076 = cljs.core.get.call(null,map__26075__$1,new cljs.core.Keyword(null,"views","views",1450155487));
var map__26076__$1 = ((((!((map__26076 == null)))?((((map__26076.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26076.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26076):map__26076);
var active = cljs.core.get.call(null,map__26076__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var map__26077 = p__26074;
var map__26077__$1 = ((((!((map__26077 == null)))?((((map__26077.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26077.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26077):map__26077);
var opts = map__26077__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__26077__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

var active_QMARK_ = chimera.seq.in_QMARK_.call(null,active,new cljs.core.Keyword(null,"table","table",-564943036));
if(typeof hatti.views.table.t_hatti$views$table26081 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26081 = (function (p__26074,map__26076,owner,p__26073,active_QMARK_,map__26075,map__26077,slick_grid_event_handlers,cursor,active,opts,meta26082){
this.p__26074 = p__26074;
this.map__26076 = map__26076;
this.owner = owner;
this.p__26073 = p__26073;
this.active_QMARK_ = active_QMARK_;
this.map__26075 = map__26075;
this.map__26077 = map__26077;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.cursor = cursor;
this.active = active;
this.opts = opts;
this.meta26082 = meta26082;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26081.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers){
return (function (_26083,meta26082__$1){
var self__ = this;
var _26083__$1 = this;
return (new hatti.views.table.t_hatti$views$table26081(self__.p__26074,self__.map__26076,self__.owner,self__.p__26073,self__.active_QMARK_,self__.map__26075,self__.map__26077,self__.slick_grid_event_handlers,self__.cursor,self__.active,self__.opts,meta26082__$1));
});})(active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26081.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers){
return (function (_26083){
var self__ = this;
var _26083__$1 = this;
return self__.meta26082;
});})(active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26081.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table26081.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers){
return (function (_,p__26084){
var self__ = this;
var map__26085 = p__26084;
var map__26085__$1 = ((((!((map__26085 == null)))?((((map__26085.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26085.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26085):map__26085);
var table_view_height = cljs.core.get.call(null,map__26085__$1,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901));
var ___$1 = this;
var map__26087 = self__.cursor;
var map__26087__$1 = ((((!((map__26087 == null)))?((((map__26087.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26087.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26087):map__26087);
var map__26088 = cljs.core.get.call(null,map__26087__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__26088__$1 = ((((!((map__26088 == null)))?((((map__26088.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26088.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26088):map__26088);
var submission_clicked = cljs.core.get.call(null,map__26088__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var data = cljs.core.get.call(null,map__26087__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var dataset_info = cljs.core.get.call(null,map__26087__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var map__26089 = dataset_info;
var map__26089__$1 = ((((!((map__26089 == null)))?((((map__26089.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26089.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26089):map__26089);
var num_of_submissions = cljs.core.get.call(null,map__26089__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,data);
var with_info = ((function (map__26087,map__26087__$1,map__26088,map__26088__$1,submission_clicked,data,dataset_info,map__26089,map__26089__$1,num_of_submissions,no_data_QMARK_,___$1,map__26085,map__26085__$1,table_view_height,active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers){
return (function (p1__26072_SHARP_){
return cljs.core.merge.call(null,self__.cursor,p1__26072_SHARP_);
});})(map__26087,map__26087__$1,map__26088,map__26088__$1,submission_clicked,data,dataset_info,map__26089,map__26089__$1,num_of_submissions,no_data_QMARK_,___$1,map__26085,map__26085__$1,table_view_height,active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers))
;
cljs.core.swap_BANG_.call(null,hatti.shared.app_state,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901)], null),(((document.querySelector(".table-page") == null))?null:hatti.views.table.get_table_view_height.call(null)));

if(cljs.core.truth_(self__.active_QMARK_)){
return React.DOM.div(({"style": ({"overflow": "initial"}), "className": "table-view"}),sablono.interpreter.interpret.call(null,(cljs.core.truth_(new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.call(null,hatti.views.submission_view,with_info.call(null,submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null)):null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.cursor)),React.DOM.div(({"id": hatti.views.table.table_id, "className": "slickgrid"}),(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.p(({"className": "alert alert-warning"}),"No data"):React.DOM.span(null,React.DOM.i(({"className": "fa fa-spinner fa-pulse"})),"Loading..."))));
} else {
return null;
}
});})(active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26081.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table26081.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler.call(null,self__.owner);

var data = cljs.core.get_in.call(null,self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__26097 = temp__4657__auto__;
var grid = cljs.core.nth.call(null,vec__26097,(0),null);
var dataview = cljs.core.nth.call(null,vec__26097,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26081.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table26081.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.call(null,self__.owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881)));
});})(active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26081.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table26081.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__26100 = om.core.get_state.call(null,self__.owner);
var map__26100__$1 = ((((!((map__26100 == null)))?((((map__26100.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26100.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26100):map__26100);
var grid = cljs.core.get.call(null,map__26100__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__26100__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__26102 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__26102,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__26102,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,(function (){var G__26105 = new_data;
if(cljs.core.truth_(new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)))){
return hatti.views.table.replace_review_num_status_with_text_status.call(null,G__26105);
} else {
return G__26105;
}
})()),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26081.getBasis = ((function (active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__26074","p__26074",-1379098240,null),new cljs.core.Symbol(null,"map__26076","map__26076",-582483870,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__26073","p__26073",561946565,null),new cljs.core.Symbol(null,"active?","active?",2100031303,null),new cljs.core.Symbol(null,"map__26075","map__26075",426057607,null),new cljs.core.Symbol(null,"map__26077","map__26077",117600232,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"active","active",-758473701,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"meta26082","meta26082",-453824832,null)], null);
});})(active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26081.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26081.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26081";

hatti.views.table.t_hatti$views$table26081.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26081");
});})(active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table26081 = ((function (active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table26081(p__26074__$1,map__26076__$2,owner__$1,p__26073__$1,active_QMARK___$1,map__26075__$2,map__26077__$2,slick_grid_event_handlers__$1,cursor__$1,active__$1,opts__$1,meta26082){
return (new hatti.views.table.t_hatti$views$table26081(p__26074__$1,map__26076__$2,owner__$1,p__26073__$1,active_QMARK___$1,map__26075__$2,map__26077__$2,slick_grid_event_handlers__$1,cursor__$1,active__$1,opts__$1,meta26082));
});})(active_QMARK_,map__26075,map__26075__$1,cursor,map__26076,map__26076__$1,active,map__26077,map__26077__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table26081(p__26074,map__26076__$1,owner,p__26073,active_QMARK_,map__26075__$1,map__26077__$1,slick_grid_event_handlers,cursor,active,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
