// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('c2.maths');
goog.require('cljs.core');
c2.maths.Pi = Math.PI;
c2.maths.Tau = ((2) * c2.maths.Pi);
c2.maths.e = Math.E;
c2.maths.radians_per_degree = (c2.maths.Pi / (180));
c2.maths.rad = (function c2$maths$rad(x){
return (c2.maths.radians_per_degree * x);
});
c2.maths.deg = (function c2$maths$deg(x){
return (x / c2.maths.radians_per_degree);
});
c2.maths.sin = (function c2$maths$sin(x){
return Math.sin(x);
});
c2.maths.asin = (function c2$maths$asin(x){
return Math.asin(x);
});
c2.maths.cos = (function c2$maths$cos(x){
return Math.cos(x);
});
c2.maths.acos = (function c2$maths$acos(x){
return Math.acos(x);
});
c2.maths.tan = (function c2$maths$tan(x){
return Math.tan(x);
});
c2.maths.atan = (function c2$maths$atan(x){
return Math.atan(x);
});
c2.maths.expt = (function c2$maths$expt(var_args){
var args38986 = [];
var len__7484__auto___38989 = arguments.length;
var i__7485__auto___38990 = (0);
while(true){
if((i__7485__auto___38990 < len__7484__auto___38989)){
args38986.push((arguments[i__7485__auto___38990]));

var G__38991 = (i__7485__auto___38990 + (1));
i__7485__auto___38990 = G__38991;
continue;
} else {
}
break;
}

var G__38988 = args38986.length;
switch (G__38988) {
case 1:
return c2.maths.expt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.expt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38986.length)].join('')));

}
});

c2.maths.expt.cljs$core$IFn$_invoke$arity$1 = (function (x){
return Math.exp(x);
});

c2.maths.expt.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return Math.pow(x,y);
});

c2.maths.expt.cljs$lang$maxFixedArity = 2;

c2.maths.sq = (function c2$maths$sq(x){
return c2.maths.expt.cljs$core$IFn$_invoke$arity$2(x,(2));
});
c2.maths.sqrt = (function c2$maths$sqrt(x){
return Math.sqrt(x);
});
c2.maths.floor = (function c2$maths$floor(x){
return Math.floor(x);
});
c2.maths.ceil = (function c2$maths$ceil(x){
return Math.ceil(x);
});
c2.maths.abs = (function c2$maths$abs(x){
return Math.abs(x);
});
c2.maths.log = (function c2$maths$log(var_args){
var args38993 = [];
var len__7484__auto___38996 = arguments.length;
var i__7485__auto___38997 = (0);
while(true){
if((i__7485__auto___38997 < len__7484__auto___38996)){
args38993.push((arguments[i__7485__auto___38997]));

var G__38998 = (i__7485__auto___38997 + (1));
i__7485__auto___38997 = G__38998;
continue;
} else {
}
break;
}

var G__38995 = args38993.length;
switch (G__38995) {
case 1:
return c2.maths.log.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.log.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38993.length)].join('')));

}
});

c2.maths.log.cljs$core$IFn$_invoke$arity$1 = (function (x){
return Math.log(x);
});

c2.maths.log.cljs$core$IFn$_invoke$arity$2 = (function (base,x){
return (Math.log(x) / Math.log(base));
});

c2.maths.log.cljs$lang$maxFixedArity = 2;

c2.maths.log10 = (function c2$maths$log10(x){
return (Math.log(x) / Math.LN10);
});
/**
 * Returns 2-vector of min and max elements in xs.
 */
c2.maths.extent = (function c2$maths$extent(xs){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,xs),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,xs)], null);
});
/**
 * Arithemetic mean of collection
 */
c2.maths.mean = (function c2$maths$mean(xs){
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,xs) / cljs.core.count(xs));
});
/**
 * Median of a collection.
 */
c2.maths.median = (function c2$maths$median(xs){
var sorted = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(xs);
var n = cljs.core.count(xs);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(1))){
return cljs.core.first(sorted);
} else {
if(cljs.core.odd_QMARK_(n)){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sorted,((n + (1)) / (2)));
} else {
var mid = (n / (2));
return c2.maths.mean(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sorted,c2.maths.floor(mid)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sorted,c2.maths.ceil(mid))], null));

}
}
});
/**
 * Inclusive range; same as core/range, but includes the end.
 */
c2.maths.irange = (function c2$maths$irange(var_args){
var args39000 = [];
var len__7484__auto___39003 = arguments.length;
var i__7485__auto___39004 = (0);
while(true){
if((i__7485__auto___39004 < len__7484__auto___39003)){
args39000.push((arguments[i__7485__auto___39004]));

var G__39005 = (i__7485__auto___39004 + (1));
i__7485__auto___39004 = G__39005;
continue;
} else {
}
break;
}

var G__39002 = args39000.length;
switch (G__39002) {
case 1:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39000.length)].join('')));

}
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$1 = (function (start){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1(start);
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.range.cljs$core$IFn$_invoke$arity$2(start,end),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
var r = cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,end,step);
if((cljs.core.mod(cljs.core.first(r),step) === cljs.core.mod(end,step))){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(r,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
} else {
return r;
}
});

c2.maths.irange.cljs$lang$maxFixedArity = 3;

/**
 * Checks if bottom <= x <= top.
 */
c2.maths.within_QMARK_ = (function c2$maths$within_QMARK_(x,p__39007){
var vec__39011 = p__39007;
var bottom = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39011,(0),null);
var top = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39011,(1),null);
return ((bottom <= x)) && ((x <= top));
});
c2.maths.add = (function c2$maths$add(var_args){
var args__7491__auto__ = [];
var len__7484__auto___39015 = arguments.length;
var i__7485__auto___39016 = (0);
while(true){
if((i__7485__auto___39016 < len__7484__auto___39015)){
args__7491__auto__.push((arguments[i__7485__auto___39016]));

var G__39017 = (i__7485__auto___39016 + (1));
i__7485__auto___39016 = G__39017;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.maths.add.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.maths.add.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A + B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
});

c2.maths.add.cljs$lang$maxFixedArity = (0);

c2.maths.add.cljs$lang$applyTo = (function (seq39014){
return c2.maths.add.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39014));
});

c2.maths.sub = (function c2$maths$sub(var_args){
var args__7491__auto__ = [];
var len__7484__auto___39019 = arguments.length;
var i__7485__auto___39020 = (0);
while(true){
if((i__7485__auto___39020 < len__7484__auto___39019)){
args__7491__auto__.push((arguments[i__7485__auto___39020]));

var G__39021 = (i__7485__auto___39020 + (1));
i__7485__auto___39020 = G__39021;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(args),(1))){
if((typeof (0) === 'number') && (typeof cljs.core.first(args) === 'number')){
return ((0) - cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((0))) && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,(0),cljs.core.first(args));
} else {
if((typeof (0) === 'number') && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,cljs.core.replicate(cljs.core.count(cljs.core.first(args)),(0)),cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((0))) && (typeof cljs.core.first(args) === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,(0),cljs.core.replicate(cljs.core.count((0)),cljs.core.first(args)));
} else {
return null;
}
}
}
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A - B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
}
});

c2.maths.sub.cljs$lang$maxFixedArity = (0);

c2.maths.sub.cljs$lang$applyTo = (function (seq39018){
return c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39018));
});

c2.maths.mul = (function c2$maths$mul(var_args){
var args__7491__auto__ = [];
var len__7484__auto___39023 = arguments.length;
var i__7485__auto___39024 = (0);
while(true){
if((i__7485__auto___39024 < len__7484__auto___39023)){
args__7491__auto__.push((arguments[i__7485__auto___39024]));

var G__39025 = (i__7485__auto___39024 + (1));
i__7485__auto___39024 = G__39025;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A * B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
});

c2.maths.mul.cljs$lang$maxFixedArity = (0);

c2.maths.mul.cljs$lang$applyTo = (function (seq39022){
return c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39022));
});

c2.maths.div = (function c2$maths$div(var_args){
var args__7491__auto__ = [];
var len__7484__auto___39027 = arguments.length;
var i__7485__auto___39028 = (0);
while(true){
if((i__7485__auto___39028 < len__7484__auto___39027)){
args__7491__auto__.push((arguments[i__7485__auto___39028]));

var G__39029 = (i__7485__auto___39028 + (1));
i__7485__auto___39028 = G__39029;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.maths.div.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.maths.div.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(args),(1))){
if((typeof (1) === 'number') && (typeof cljs.core.first(args) === 'number')){
return ((1) / cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((1))) && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(1),cljs.core.first(args));
} else {
if((typeof (1) === 'number') && (cljs.core.coll_QMARK_(cljs.core.first(args)))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,cljs.core.replicate(cljs.core.count(cljs.core.first(args)),(1)),cljs.core.first(args));
} else {
if((cljs.core.coll_QMARK_((1))) && (typeof cljs.core.first(args) === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(1),cljs.core.replicate(cljs.core.count((1)),cljs.core.first(args)));
} else {
return null;
}
}
}
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A / B);
} else {
if((cljs.core.coll_QMARK_(A)) && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_(B))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,cljs.core.replicate(cljs.core.count(B),A),B);
} else {
if((cljs.core.coll_QMARK_(A)) && (typeof B === 'number')){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,A,cljs.core.replicate(cljs.core.count(A),B));
} else {
return null;
}
}
}
}
}),args);
}
});

c2.maths.div.cljs$lang$maxFixedArity = (0);

c2.maths.div.cljs$lang$applyTo = (function (seq39026){
return c2.maths.div.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39026));
});

/**
 * Returns the quantiles of a dataset.
 * 
 * Kwargs:
 * 
 *   > *:probs*: ntiles of the data to return, defaults to `[0 0.25 0.5 0.75 1]`
 * 
 *   Algorithm is the same as R's quantile type=7.
 *   Transcribed from Jason Davies; https://github.com/jasondavies/science.js/blob/master/src/stats/quantiles.js
 */
c2.maths.quantile = (function c2$maths$quantile(var_args){
var args__7491__auto__ = [];
var len__7484__auto___39045 = arguments.length;
var i__7485__auto___39046 = (0);
while(true){
if((i__7485__auto___39046 < len__7484__auto___39045)){
args__7491__auto__.push((arguments[i__7485__auto___39046]));

var G__39047 = (i__7485__auto___39046 + (1));
i__7485__auto___39046 = G__39047;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__39032){
var map__39033 = p__39032;
var map__39033__$1 = ((((!((map__39033 == null)))?((((map__39033.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39033.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39033):map__39033);
var probs = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__39033__$1,cljs.core.cst$kw$probs,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),0.25,0.5,0.75,(1)], null));
var xs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.sort.cljs$core$IFn$_invoke$arity$1(data));
var n_1 = (cljs.core.count(xs) - (1));
var iter__7189__auto__ = ((function (xs,n_1,map__39033,map__39033__$1,probs){
return (function c2$maths$iter__39035(s__39036){
return (new cljs.core.LazySeq(null,((function (xs,n_1,map__39033,map__39033__$1,probs){
return (function (){
var s__39036__$1 = s__39036;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39036__$1);
if(temp__4657__auto__){
var s__39036__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39036__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39036__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39038 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39037 = (0);
while(true){
if((i__39037 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39037);
cljs.core.chunk_append(b__39038,(function (){var index = ((q * n_1) + (1));
var lo = (c2.maths.floor(index) | (0));
var h = (index - lo);
var a = (function (){var G__39043 = (lo - (1));
return (xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(G__39043) : xs.call(null,G__39043));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,(0))){
return a;
} else {
return (a + (h * ((xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(lo) : xs.call(null,lo)) - a)));
}
})());

var G__39048 = (i__39037 + (1));
i__39037 = G__39048;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39038),c2$maths$iter__39035(cljs.core.chunk_rest(s__39036__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39038),null);
}
} else {
var q = cljs.core.first(s__39036__$2);
return cljs.core.cons((function (){var index = ((q * n_1) + (1));
var lo = (c2.maths.floor(index) | (0));
var h = (index - lo);
var a = (function (){var G__39044 = (lo - (1));
return (xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(G__39044) : xs.call(null,G__39044));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,(0))){
return a;
} else {
return (a + (h * ((xs.cljs$core$IFn$_invoke$arity$1 ? xs.cljs$core$IFn$_invoke$arity$1(lo) : xs.call(null,lo)) - a)));
}
})(),c2$maths$iter__39035(cljs.core.rest(s__39036__$2)));
}
} else {
return null;
}
break;
}
});})(xs,n_1,map__39033,map__39033__$1,probs))
,null,null));
});})(xs,n_1,map__39033,map__39033__$1,probs))
;
return iter__7189__auto__(probs);
});

c2.maths.quantile.cljs$lang$maxFixedArity = (1);

c2.maths.quantile.cljs$lang$applyTo = (function (seq39030){
var G__39031 = cljs.core.first(seq39030);
var seq39030__$1 = cljs.core.next(seq39030);
return c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic(G__39031,seq39030__$1);
});

